(ns yetibot.core.db.users
  (:require [datomico.core :as dc]
            [datomico.db :refer [q]]
            [datomico.action :refer [all where raw-where]]))

(def model-ns :users)

(def schema
  (dc/build-schema model-ns
                   [; campfire ID is an int
                    ; irc ID is a string, e.g. "~devth"
                    [:id :string]
                    ; irc users can change their "nick" but id stays the
                    ; same. track those changes. campfire name is
                    ; user's actual name.
                    [:name :string]
                    [:last-seen :instant]
                    ]))

(dc/create-model-fns model-ns)
