/*
 * Decompiled with CFR 0.152.
 */
package jdk.nio;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class ByteBuffer$fn__19059
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"jdk.nio.ByteBuffer")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "A byte buffer.\n\n   This class defines six categories of operations upon\n  byte buffers:\n\n\n\n     Absolute and relative get and\n    put methods that read and write\n    single bytes;\n\n     Relative bulk get\n    methods that transfer contiguous sequences of bytes from this buffer\n    into an array;\n\n     Relative bulk put\n    methods that transfer contiguous sequences of bytes from a\n    byte array or some other byte\n    buffer into this buffer;\n\n\n\n     Absolute and relative get\n    and put methods that read and\n    write values of other primitive types, translating them to and from\n    sequences of bytes in a particular byte order;\n\n     Methods for creating view buffers,\n    which allow a byte buffer to be viewed as a buffer containing values of\n    some other primitive type; and\n\n\n\n     Methods for compacting, duplicating, and slicing\n    a byte buffer.\n\n\n\n   Byte buffers can be created either by allocation, which allocates space for the buffer's\n\n\n\n  content, or by wrapping an\n  existing byte array  into a buffer.\n\n\n\n\n\n\n\n\n\n\n\n\n   Direct vs. non-direct buffers\n\n   A byte buffer is either direct or non-direct.  Given a\n  direct byte buffer, the Java virtual machine will make a best effort to\n  perform native I/O operations directly upon it.  That is, it will attempt to\n  avoid copying the buffer's content to (or from) an intermediate buffer\n  before (or after) each invocation of one of the underlying operating\n  system's native I/O operations.\n\n   A direct byte buffer may be created by invoking the allocateDirect factory method of this class.  The\n  buffers returned by this method typically have somewhat higher allocation\n  and deallocation costs than non-direct buffers.  The contents of direct\n  buffers may reside outside of the normal garbage-collected heap, and so\n  their impact upon the memory footprint of an application might not be\n  obvious.  It is therefore recommended that direct buffers be allocated\n  primarily for large, long-lived buffers that are subject to the underlying\n  system's native I/O operations.  In general it is best to allocate direct\n  buffers only when they yield a measureable gain in program performance.\n\n   A direct byte buffer may also be created by mapping a region of a file\n  directly into memory.  An implementation of the Java platform may optionally\n  support the creation of direct byte buffers from native code via JNI.  If an\n  instance of one of these kinds of buffers refers to an inaccessible region\n  of memory then an attempt to access that region will not change the buffer's\n  content and will cause an unspecified exception to be thrown either at the\n  time of the access or at some later time.\n\n   Whether a byte buffer is direct or non-direct may be determined by\n  invoking its isDirect method.  This method is provided so\n  that explicit buffer management can be done in performance-critical code.\n\n\n\n   Access to binary data\n\n   This class defines methods for reading and writing values of all other\n  primitive types, except boolean.  Primitive values are translated\n  to (or from) sequences of bytes according to the buffer's current byte\n  order, which may be retrieved and modified via the order\n  methods.  Specific byte orders are represented by instances of the ByteOrder class.  The initial order of a byte buffer is always BIG_ENDIAN.\n\n   For access to heterogeneous binary data, that is, sequences of values of\n  different types, this class defines a family of absolute and relative\n  get and put methods for each type.  For 32-bit floating-point\n  values, for example, this class defines:\n\n\n\n  float  getFloat()\n  float  getFloat(int index)\n   void  putFloat(float f)\n   void  putFloat(int index, float f)\n\n   Corresponding methods are defined for the types char,\n  short, int, long, and double.  The index\n  parameters of the absolute get and put methods are in terms of\n  bytes rather than of the type being read or written.\n\n\n\n   For access to homogeneous binary data, that is, sequences of values of\n  the same type, this class defines methods that can create views of a\n  given byte buffer.  A view buffer is simply another buffer whose\n  content is backed by the byte buffer.  Changes to the byte buffer's content\n  will be visible in the view buffer, and vice versa; the two buffers'\n  position, limit, and mark values are independent.  The asFloatBuffer method, for example, creates an instance of\n  the FloatBuffer class that is backed by the byte buffer upon which\n  the method is invoked.  Corresponding view-creation methods are defined for\n  the types char, short, int, long, and\n  double.\n\n   View buffers have three important advantages over the families of\n  type-specific get and put methods described above:\n\n\n\n     A view buffer is indexed not in terms of bytes but rather in terms\n    of the type-specific size of its values;\n\n     A view buffer provides relative bulk get and put\n    methods that can transfer contiguous sequences of values between a buffer\n    and an array or some other buffer of the same type; and\n\n     A view buffer is potentially much more efficient because it will\n    be direct if, and only if, its backing byte buffer is direct.\n\n\n\n   The byte order of a view buffer is fixed to be that of its byte buffer\n  at the time that the view is created.\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n   Invocation chaining\n\n\n   Methods in this class that do not otherwise have a value to return are\n  specified to return the buffer upon which they are invoked.  This allows\n  method invocations to be chained.\n\n\n\n  The sequence of statements\n\n\n\n  bb.putInt(0xCAFEBABE);\n  bb.putShort(3);\n  bb.putShort(45);\n\n  can, for example, be replaced by the single statement\n\n\n\n  bb.putInt(0xCAFEBABE).putShort(3).putShort(45);"}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return ByteBuffer$fn__19059.invokeStatic();
    }
}

