(ns warpcore.dev
  (:require [taoensso.timbre :as timbre]
            [environ.core :refer [env]]))

(timbre/refer-timbre)

(defonce last-request (atom nil))

(defn wrap-save-last-request
  "Ring middleware that puts the last request into an atom for debugging"
  [handler filter-fn]
  (fn [request]
    (when (and (not (env :lein-no-dev)) (filter-fn request))
      (info "Saving request: " request)
      (reset! last-request request))
    (handler request)))
