/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public class EncryptedPrivateKey {
    private byte[] initialisationVector = null;
    private byte[] encryptedPrivateBytes = null;

    public EncryptedPrivateKey(EncryptedPrivateKey encryptedPrivateKey) {
        Preconditions.checkNotNull((Object)encryptedPrivateKey);
        this.setInitialisationVector(encryptedPrivateKey.getInitialisationVector());
        this.setEncryptedPrivateBytes(encryptedPrivateKey.getEncryptedBytes());
    }

    public EncryptedPrivateKey(byte[] initialisationVector, byte[] encryptedPrivateKeys) {
        this.setInitialisationVector(initialisationVector);
        this.setEncryptedPrivateBytes(encryptedPrivateKeys);
    }

    public byte[] getInitialisationVector() {
        return this.initialisationVector;
    }

    public void setInitialisationVector(byte[] initialisationVector) {
        if (initialisationVector == null) {
            this.initialisationVector = null;
            return;
        }
        byte[] cloneIV = new byte[initialisationVector.length];
        System.arraycopy(initialisationVector, 0, cloneIV, 0, initialisationVector.length);
        this.initialisationVector = cloneIV;
    }

    public byte[] getEncryptedBytes() {
        return this.encryptedPrivateBytes;
    }

    public void setEncryptedPrivateBytes(byte[] encryptedPrivateBytes) {
        if (encryptedPrivateBytes == null) {
            this.encryptedPrivateBytes = null;
            return;
        }
        this.encryptedPrivateBytes = Arrays.copyOf(encryptedPrivateBytes, encryptedPrivateBytes.length);
    }

    public EncryptedPrivateKey clone() {
        return new EncryptedPrivateKey(this.getInitialisationVector(), this.getEncryptedBytes());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.encryptedPrivateBytes, this.initialisationVector});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedPrivateKey other = (EncryptedPrivateKey)obj;
        return Objects.equal((Object)this.initialisationVector, (Object)other.initialisationVector) && Objects.equal((Object)this.encryptedPrivateBytes, (Object)other.encryptedPrivateBytes);
    }

    public String toString() {
        return "EncryptedPrivateKey [initialisationVector=" + Arrays.toString(this.initialisationVector) + ", encryptedPrivateKey=" + Arrays.toString(this.encryptedPrivateBytes) + "]";
    }

    public void clear() {
        if (this.encryptedPrivateBytes != null) {
            Arrays.fill(this.encryptedPrivateBytes, (byte)0);
        }
        if (this.initialisationVector != null) {
            Arrays.fill(this.initialisationVector, (byte)0);
        }
    }
}

