/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.StoredTransactionOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

public class TransactionOutputChanges {
    public final List<StoredTransactionOutput> txOutsCreated;
    public final List<StoredTransactionOutput> txOutsSpent;

    public TransactionOutputChanges(List<StoredTransactionOutput> txOutsCreated, List<StoredTransactionOutput> txOutsSpent) {
        this.txOutsCreated = txOutsCreated;
        this.txOutsSpent = txOutsSpent;
    }

    public TransactionOutputChanges(InputStream in) throws IOException {
        int numOutsCreated = (in.read() & 0xFF) << 0 | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 24;
        this.txOutsCreated = new LinkedList<StoredTransactionOutput>();
        for (int i = 0; i < numOutsCreated; ++i) {
            this.txOutsCreated.add(new StoredTransactionOutput(in));
        }
        int numOutsSpent = (in.read() & 0xFF) << 0 | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 24;
        this.txOutsSpent = new LinkedList<StoredTransactionOutput>();
        for (int i = 0; i < numOutsSpent; ++i) {
            this.txOutsSpent.add(new StoredTransactionOutput(in));
        }
    }

    public void serializeToStream(OutputStream bos) throws IOException {
        int numOutsCreated = this.txOutsCreated.size();
        bos.write(0xFF & numOutsCreated >> 0);
        bos.write(0xFF & numOutsCreated >> 8);
        bos.write(0xFF & numOutsCreated >> 16);
        bos.write(0xFF & numOutsCreated >> 24);
        for (StoredTransactionOutput output : this.txOutsCreated) {
            output.serializeToStream(bos);
        }
        int numOutsSpent = this.txOutsSpent.size();
        bos.write(0xFF & numOutsSpent >> 0);
        bos.write(0xFF & numOutsSpent >> 8);
        bos.write(0xFF & numOutsSpent >> 16);
        bos.write(0xFF & numOutsSpent >> 24);
        for (StoredTransactionOutput output : this.txOutsSpent) {
            output.serializeToStream(bos);
        }
    }
}

