/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ChildMessage;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.bitcoin.core.Wallet;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOutput
extends ChildMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TransactionOutput.class);
    private static final long serialVersionUID = -590332479859256824L;
    private BigInteger value;
    private byte[] scriptBytes;
    private transient Script scriptPubKey;
    private boolean availableForSpending;
    private TransactionInput spentBy;
    Transaction parentTransaction;
    private transient int scriptLen;

    public TransactionOutput(NetworkParameters params, Transaction parent, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
        this.parentTransaction = parent;
        this.availableForSpending = true;
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, byte[] msg, int offset, boolean parseLazy, boolean parseRetain) throws ProtocolException {
        super(params, msg, offset, parent, parseLazy, parseRetain, Integer.MIN_VALUE);
        this.parentTransaction = parent;
        this.availableForSpending = true;
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, Address to) {
        this(params, parent, value, Script.createOutputScript(to));
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, ECKey to) {
        this(params, parent, value, Script.createOutputScript(to));
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, byte[] scriptBytes) {
        super(params);
        this.value = value;
        this.scriptBytes = scriptBytes;
        this.parentTransaction = parent;
        this.availableForSpending = true;
        this.length = 8 + VarInt.sizeOf(scriptBytes.length) + scriptBytes.length;
    }

    public Script getScriptPubKey() throws ScriptException {
        if (this.scriptPubKey == null) {
            this.maybeParse();
            this.scriptPubKey = new Script(this.params, this.scriptBytes, 0, this.scriptBytes.length);
        }
        return this.scriptPubKey;
    }

    @Override
    protected void parseLite() {
        long outputValue = this.readInt64();
        this.value = BigInteger.valueOf(outputValue);
        this.scriptLen = (int)this.readVarInt();
        this.length = this.cursor - this.offset + this.scriptLen;
    }

    @Override
    void parse() throws ProtocolException {
        this.scriptBytes = this.readBytes(this.scriptLen);
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)this.scriptBytes);
        Utils.uint64ToByteStreamLE(this.getValue(), stream);
        stream.write(new VarInt(this.scriptBytes.length).encode());
        stream.write(this.scriptBytes);
    }

    public BigInteger getValue() {
        this.maybeParse();
        return this.value;
    }

    int getIndex() {
        Preconditions.checkNotNull((Object)this.parentTransaction);
        for (int i = 0; i < this.parentTransaction.getOutputs().size(); ++i) {
            if (this.parentTransaction.getOutputs().get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Output linked to wrong parent transaction?");
    }

    public void markAsSpent(TransactionInput input) {
        Preconditions.checkState((boolean)this.availableForSpending);
        this.availableForSpending = false;
        this.spentBy = input;
    }

    public void markAsUnspent() {
        this.availableForSpending = true;
        this.spentBy = null;
    }

    public boolean isAvailableForSpending() {
        return this.availableForSpending;
    }

    public byte[] getScriptBytes() {
        this.maybeParse();
        return this.scriptBytes;
    }

    public boolean isMine(Wallet wallet) {
        try {
            Script script = this.getScriptPubKey();
            if (script.isSentToRawPubKey()) {
                byte[] pubkey = script.getPubKey();
                return wallet.isPubKeyMine(pubkey);
            }
            byte[] pubkeyHash = script.getPubKeyHash();
            return wallet.isPubKeyHashMine(pubkeyHash);
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx output script: {}", (Object)e.toString());
            return false;
        }
    }

    public String toString() {
        try {
            return "TxOut of " + Utils.bitcoinValueToFriendlyString(this.value) + " to " + this.getScriptPubKey().getToAddress().toString() + " script:" + this.getScriptPubKey().toString();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionInput getSpentBy() {
        return this.spentBy;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }
}

