/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.GetBlocksMessage;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Sha256Hash;
import java.util.List;

public class GetHeadersMessage
extends GetBlocksMessage {
    public GetHeadersMessage(NetworkParameters params, List<Sha256Hash> locator, Sha256Hash stopHash) {
        super(params, locator, stopHash);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("getheaders: ");
        for (Sha256Hash hash : this.locator) {
            b.append(hash.toString());
            b.append(" ");
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GetHeadersMessage other = (GetHeadersMessage)o;
        return other.version == this.version && this.locator.size() == other.locator.size() && this.locator.containsAll(other.locator) && this.stopHash.equals(other.stopHash);
    }

    @Override
    public int hashCode() {
        int hashCode = (int)this.version ^ "getheaders".hashCode();
        for (Sha256Hash aLocator : this.locator) {
            hashCode ^= aLocator.hashCode();
        }
        return hashCode ^= this.stopHash.hashCode();
    }
}

