/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PartialMerkleTree;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.VerificationException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FilteredBlock
extends Message {
    public static final int MIN_PROTOCOL_VERSION = 70000;
    private Block header;
    private PartialMerkleTree merkleTree;
    private Set<Sha256Hash> cachedTransactionHashes = null;
    private List<Transaction> associatedTransactions = new LinkedList<Transaction>();

    public FilteredBlock(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    void parse() throws ProtocolException {
        byte[] headerBytes = new byte[80];
        System.arraycopy(this.bytes, 0, headerBytes, 0, 80);
        this.header = new Block(this.params, headerBytes);
        this.merkleTree = new PartialMerkleTree(this.params, this.bytes, 80);
        this.length = 80 + this.merkleTree.getMessageSize();
    }

    @Override
    protected void parseLite() throws ProtocolException {
    }

    public Set<Sha256Hash> getTransactionHashes() throws VerificationException {
        if (this.cachedTransactionHashes != null) {
            return Collections.unmodifiableSet(this.cachedTransactionHashes);
        }
        HashSet<Sha256Hash> hashesMatched = new HashSet<Sha256Hash>();
        if (this.header.getMerkleRoot().equals(this.merkleTree.getTxnHashAndMerkleRoot(hashesMatched))) {
            this.cachedTransactionHashes = hashesMatched;
            return Collections.unmodifiableSet(this.cachedTransactionHashes);
        }
        throw new VerificationException("Merkle root of block header does not match merkle root of partial merkle tree.");
    }

    public Block getBlockHeader() {
        return this.header.cloneAsHeader();
    }

    @Override
    public Sha256Hash getHash() {
        return this.header.getHash();
    }

    public boolean provideTransaction(Transaction tx) throws VerificationException {
        if (this.getTransactionHashes().contains(tx.getHash())) {
            this.associatedTransactions.add(tx);
            return true;
        }
        return false;
    }

    public List<Transaction> getAssociatedTransactions() {
        return Collections.unmodifiableList(this.associatedTransactions);
    }
}

