/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.BitcoinSerializer;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkConnection;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.Ping;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.VersionAck;
import com.google.bitcoin.core.VersionMessage;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPNetworkConnection
implements NetworkConnection {
    private static final Logger log = LoggerFactory.getLogger(TCPNetworkConnection.class);
    private InetAddress remoteIp;
    private final NetworkParameters params;
    private VersionMessage versionMessage;
    private BitcoinSerializer serializer = null;
    private VersionMessage myVersionMessage;
    private Channel channel;
    private NetworkHandler handler;
    private Random random = new Random();
    private static NioClientSocketChannelFactory channelFactory;
    private SettableFuture<TCPNetworkConnection> handshakeFuture;

    public TCPNetworkConnection(NetworkParameters params, VersionMessage ver) {
        this.params = params;
        this.myVersionMessage = ver;
        this.serializer = new BitcoinSerializer(this.params);
        this.handler = new NetworkHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenableFuture<TCPNetworkConnection> connectTo(NetworkParameters params, InetSocketAddress address, int connectTimeoutMsec) {
        Class<TCPNetworkConnection> clazz = TCPNetworkConnection.class;
        synchronized (TCPNetworkConnection.class) {
            if (channelFactory == null) {
                ExecutorService bossExecutor = Executors.newCachedThreadPool();
                ExecutorService workerExecutor = Executors.newCachedThreadPool();
                channelFactory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ClientBootstrap clientBootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
            ChannelPipeline pipeline = Channels.pipeline();
            final TCPNetworkConnection conn = new TCPNetworkConnection(params, new VersionMessage(params, 0));
            conn.handshakeFuture = SettableFuture.create();
            conn.setRemoteAddress(address);
            pipeline.addLast("codec", (ChannelHandler)conn.getHandler());
            clientBootstrap.setPipeline(pipeline);
            clientBootstrap.setOption("connectTimeoutMillis", (Object)connectTimeoutMsec);
            ChannelFuture socketFuture = clientBootstrap.connect((SocketAddress)address);
            socketFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isDone() && !channelFuture.isSuccess()) {
                        conn.handshakeFuture.setException(channelFuture.getCause());
                    }
                }
            });
            return conn.handshakeFuture;
        }
    }

    @Override
    public void writeMessage(Message message) throws IOException {
        Channels.write((Channel)this.channel, (Object)message);
    }

    private void onVersionMessage(Message m) throws IOException, ProtocolException {
        if (!(m instanceof VersionMessage)) {
            log.info("First message received was not a version message but rather " + m);
            return;
        }
        this.versionMessage = (VersionMessage)m;
        int peerVersion = this.versionMessage.clientVersion;
        log.info("Connected to {}: version={}, subVer='{}', services=0x{}, time={}, blocks={}", new Object[]{this.getPeerAddress().getAddr().getHostAddress(), peerVersion, this.versionMessage.subVer, this.versionMessage.localServices, new Date(this.versionMessage.time * 1000L), this.versionMessage.bestHeight});
        Channels.write((Channel)this.channel, (Object)new VersionAck());
        if (!this.versionMessage.hasBlockChain() || !this.params.allowEmptyPeerChains && this.versionMessage.bestHeight <= 0L) {
            throw new ProtocolException("Peer does not have a copy of the block chain.");
        }
        if (this.handshakeFuture != null) {
            this.handshakeFuture.set((Object)this);
        }
    }

    @Override
    public void ping() throws IOException {
        if (this.versionMessage.clientVersion > 60000) {
            Channels.write((Channel)this.channel, (Object)new Ping(this.random.nextLong()));
        } else {
            Channels.write((Channel)this.channel, (Object)new Ping());
        }
    }

    public String toString() {
        return "[" + this.remoteIp.getHostAddress() + "]:" + this.params.port;
    }

    public NetworkHandler getHandler() {
        return this.handler;
    }

    @Override
    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    @Override
    public PeerAddress getPeerAddress() {
        return new PeerAddress(this.remoteIp, this.params.port);
    }

    @Override
    public void close() {
        this.channel.close();
    }

    public void setRemoteAddress(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            this.remoteIp = ((InetSocketAddress)address).getAddress();
        }
    }

    public class NetworkHandler
    extends ReplayingDecoder<VoidEnum>
    implements ChannelDownstreamHandler {
        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelConnected(ctx, e);
            TCPNetworkConnection.this.channel = e.getChannel();
            log.info("Announcing to {} as: {}", (Object)TCPNetworkConnection.this.channel.getRemoteAddress(), (Object)((TCPNetworkConnection)TCPNetworkConnection.this).myVersionMessage.subVer);
            Channels.write((Channel)TCPNetworkConnection.this.channel, (Object)TCPNetworkConnection.this.myVersionMessage);
        }

        protected Object decode(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buffer, VoidEnum state) throws Exception {
            Message message = TCPNetworkConnection.this.serializer.deserialize((InputStream)new ChannelBufferInputStream(buffer));
            if (message instanceof VersionMessage) {
                TCPNetworkConnection.this.onVersionMessage(message);
            }
            return message;
        }

        public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
            if (!(evt instanceof MessageEvent)) {
                ctx.sendDownstream(evt);
                return;
            }
            MessageEvent e = (MessageEvent)evt;
            Message message = (Message)e.getMessage();
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
            TCPNetworkConnection.this.serializer.serialize(message, (OutputStream)new ChannelBufferOutputStream(buffer));
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)buffer, (SocketAddress)e.getRemoteAddress());
        }

        public TCPNetworkConnection getOwnerObject() {
            return TCPNetworkConnection.this;
        }
    }
}

