/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionOutputChanges;
import java.io.Serializable;
import java.util.List;

public class StoredUndoableBlock
implements Serializable {
    private static final long serialVersionUID = 5127353027086786117L;
    Sha256Hash blockHash;
    private TransactionOutputChanges txOutChanges;
    private List<Transaction> transactions;

    public StoredUndoableBlock(Sha256Hash hash, TransactionOutputChanges txOutChanges) {
        this.blockHash = hash;
        this.transactions = null;
        this.txOutChanges = txOutChanges;
    }

    public StoredUndoableBlock(Sha256Hash hash, List<Transaction> transactions) {
        this.blockHash = hash;
        this.txOutChanges = null;
        this.transactions = transactions;
    }

    public TransactionOutputChanges getTxOutChanges() {
        return this.txOutChanges;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Sha256Hash getHash() {
        return this.blockHash;
    }

    public int hashCode() {
        return this.blockHash.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StoredUndoableBlock)) {
            return false;
        }
        return ((StoredUndoableBlock)o).getHash().equals(this.getHash());
    }

    public String toString() {
        return "Undoable Block " + this.blockHash.toString();
    }
}

