/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Utils;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.spongycastle.util.encoders.Hex;

public class Sha256Hash
implements Serializable {
    private byte[] bytes;
    public static final Sha256Hash ZERO_HASH = new Sha256Hash(new byte[32]);

    public Sha256Hash(byte[] rawHashBytes) {
        Preconditions.checkArgument((rawHashBytes.length == 32 ? 1 : 0) != 0);
        this.bytes = rawHashBytes;
    }

    public Sha256Hash(String hexString) {
        Preconditions.checkArgument((hexString.length() == 64 ? 1 : 0) != 0);
        this.bytes = Hex.decode((String)hexString);
    }

    public static Sha256Hash create(byte[] contents) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return new Sha256Hash(digest.digest(contents));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Sha256Hash createDouble(byte[] contents) {
        return new Sha256Hash(Utils.doubleDigest(contents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sha256Hash hashFileContents(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            Sha256Hash sha256Hash = Sha256Hash.create(ByteStreams.toByteArray((InputStream)in));
            return sha256Hash;
        }
        finally {
            in.close();
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Sha256Hash)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Sha256Hash)other).bytes);
    }

    public int hashCode() {
        return this.bytes[31] & 0xFF | (this.bytes[30] & 0xFF) << 8 | (this.bytes[29] & 0xFF) << 16 | (this.bytes[28] & 0xFF) << 24;
    }

    public String toString() {
        return Utils.bytesToHexString(this.bytes);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Sha256Hash duplicate() {
        return new Sha256Hash(this.bytes);
    }
}

