/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractBlockChain;
import com.google.bitcoin.core.AbstractPeerEventListener;
import com.google.bitcoin.core.AbstractWalletEventListener;
import com.google.bitcoin.core.BloomFilter;
import com.google.bitcoin.core.DownloadListener;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.GetDataMessage;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.InventoryMessage;
import com.google.bitcoin.core.MemoryPool;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.TCPNetworkConnection;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VersionMessage;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.discovery.PeerDiscovery;
import com.google.bitcoin.discovery.PeerDiscoveryException;
import com.google.bitcoin.utils.Locks;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerGroup
extends AbstractIdleService {
    private static final int DEFAULT_CONNECTIONS = 4;
    private static final Logger log = LoggerFactory.getLogger(PeerGroup.class);
    protected final ReentrantLock lock = Locks.lock("peergroup");
    private final List<PeerAddress> inactives;
    @GuardedBy(value="lock")
    private final List<Peer> peers;
    @GuardedBy(value="lock")
    private final List<Peer> pendingPeers;
    private final ChannelGroup channels;
    @GuardedBy(value="lock")
    private Peer downloadPeer;
    @GuardedBy(value="lock")
    private PeerEventListener downloadListener;
    private final CopyOnWriteArrayList<PeerEventListener> peerEventListeners;
    private CopyOnWriteArraySet<PeerDiscovery> peerDiscoverers;
    private VersionMessage versionMessage;
    private final MemoryPool memoryPool;
    @GuardedBy(value="lock")
    private int maxConnections;
    private volatile Timer pingTimer;
    public static final long DEFAULT_PING_INTERVAL_MSEC = 2000L;
    private long pingIntervalMsec = 2000L;
    private final NetworkParameters params;
    private final AbstractBlockChain chain;
    private long fastCatchupTimeSecs;
    private final CopyOnWriteArrayList<Wallet> wallets;
    private AbstractPeerEventListener getDataListener = new AbstractPeerEventListener(){

        @Override
        public List<Message> getData(Peer peer, GetDataMessage m) {
            return PeerGroup.this.handleGetData(m);
        }
    };
    private ClientBootstrap bootstrap;
    private int minBroadcastConnections = 0;
    private AbstractWalletEventListener walletEventListener = new AbstractWalletEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKeyAdded(ECKey key) {
            PeerGroup.this.lock.lock();
            try {
                PeerGroup.this.recalculateFastCatchupAndFilter();
            }
            finally {
                PeerGroup.this.lock.unlock();
            }
        }
    };
    Peer.PeerLifecycleListener startupListener = new PeerStartupListener();
    private BloomFilter bloomFilter;
    public static final double DEFAULT_BLOOM_FILTER_FP_RATE = 5.0E-4;
    private double bloomFilterFPRate = 5.0E-4;
    private final long bloomFilterTweak = (long)(Math.random() * 9.223372036854776E18);
    private int lastBloomFilterElementCount;

    public PeerGroup(NetworkParameters params) {
        this(params, null);
    }

    public PeerGroup(NetworkParameters params, AbstractBlockChain chain) {
        this(params, chain, null);
    }

    public PeerGroup(NetworkParameters params, AbstractBlockChain chain, ClientBootstrap bootstrap) {
        this.params = params;
        this.chain = chain;
        this.fastCatchupTimeSecs = params.genesisBlock.getTimeSeconds();
        this.wallets = new CopyOnWriteArrayList();
        this.maxConnections = 0;
        int height = chain == null ? 0 : chain.getBestChainHeight();
        this.versionMessage = new VersionMessage(params, height, true);
        this.memoryPool = new MemoryPool();
        if (bootstrap == null) {
            this.bootstrap = PeerGroup.createClientBootstrap();
            this.bootstrap.setPipelineFactory(this.makePipelineFactory(params, chain));
        } else {
            this.bootstrap = bootstrap;
        }
        this.inactives = Collections.synchronizedList(new ArrayList());
        this.peers = new ArrayList<Peer>();
        this.pendingPeers = new ArrayList<Peer>();
        this.channels = new DefaultChannelGroup();
        this.peerDiscoverers = new CopyOnWriteArraySet();
        this.peerEventListeners = new CopyOnWriteArrayList();
    }

    public static ClientBootstrap createClientBootstrap() {
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new PeerGroupThreadFactory());
        ExecutorService workerExecutor = Executors.newCachedThreadPool(new PeerGroupThreadFactory());
        NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        ClientBootstrap bs = new ClientBootstrap((ChannelFactory)channelFactory);
        bs.setOption("connectTimeoutMillis", (Object)2000);
        return bs;
    }

    private ChannelPipelineFactory makePipelineFactory(final NetworkParameters params, final AbstractBlockChain chain) {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                VersionMessage ver = PeerGroup.this.getVersionMessage().duplicate();
                ver.bestHeight = chain == null ? 0L : (long)chain.getBestChainHeight();
                ver.time = Utils.now().getTime() / 1000L;
                ChannelPipeline p = Channels.pipeline();
                Peer peer = new Peer(params, chain, ver, PeerGroup.this.memoryPool);
                peer.addLifecycleListener(PeerGroup.this.startupListener);
                PeerGroup.this.pendingPeers.add(peer);
                TCPNetworkConnection codec = new TCPNetworkConnection(params, peer.getVersionMessage());
                p.addLast("codec", (ChannelHandler)codec.getHandler());
                p.addLast("peer", (ChannelHandler)peer.getHandler());
                return p;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConnections(int maxConnections) {
        int adjustment;
        this.lock.lock();
        try {
            this.maxConnections = maxConnections;
            if (!this.isRunning()) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        for (adjustment = maxConnections - this.channels.size(); adjustment > 0; --adjustment) {
            try {
                this.connectToAnyPeer();
                continue;
            }
            catch (PeerDiscoveryException e) {
                throw new RuntimeException(e);
            }
        }
        while (adjustment < 0) {
            ((Channel)this.channels.iterator().next()).close();
            ++adjustment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxConnections() {
        this.lock.lock();
        try {
            int n = this.maxConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> handleGetData(GetDataMessage m) {
        this.lock.lock();
        try {
            LinkedList<Message> transactions = new LinkedList<Message>();
            LinkedList<InventoryItem> items = new LinkedList<InventoryItem>(m.getItems());
            Iterator it = items.iterator();
            block3: while (it.hasNext()) {
                InventoryItem item = (InventoryItem)it.next();
                Transaction tx = this.memoryPool.get(item.hash);
                if (tx != null) {
                    transactions.add(tx);
                    it.remove();
                    continue;
                }
                for (Wallet w : this.wallets) {
                    tx = w.getTransaction(item.hash);
                    if (tx == null) continue;
                    transactions.add(tx);
                    it.remove();
                    continue block3;
                }
            }
            LinkedList<Message> linkedList = transactions;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersionMessage(VersionMessage ver) {
        this.lock.lock();
        try {
            this.versionMessage = ver;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionMessage getVersionMessage() {
        this.lock.lock();
        try {
            VersionMessage versionMessage = this.versionMessage;
            return versionMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version, String comments) {
        int height = this.chain == null ? 0 : this.chain.getBestChainHeight();
        VersionMessage ver = new VersionMessage(this.params, height, false);
        this.updateVersionMessageRelayTxesBeforeFilter(ver);
        ver.appendToSubVer(name, version, comments);
        this.setVersionMessage(ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionMessageRelayTxesBeforeFilter(VersionMessage ver) {
        this.lock.lock();
        try {
            ver.relayTxesBeforeFilter = this.chain != null && this.chain.shouldVerifyTransactions() && this.wallets.size() > 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version) {
        this.setUserAgent(name, version, null);
    }

    public void addEventListener(PeerEventListener listener) {
        this.peerEventListeners.add((PeerEventListener)Preconditions.checkNotNull((Object)listener));
    }

    public boolean removeEventListener(PeerEventListener listener) {
        return this.peerEventListeners.remove(Preconditions.checkNotNull((Object)listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> getConnectedPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.peers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> getPendingPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.pendingPeers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddress(PeerAddress peerAddress) {
        int newMax;
        this.lock.lock();
        try {
            this.inactives.add(peerAddress);
            newMax = this.getMaxConnections() + 1;
        }
        finally {
            this.lock.unlock();
        }
        this.setMaxConnections(newMax);
    }

    public void addAddress(InetAddress address) {
        this.addAddress(new PeerAddress(address, this.params.port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerDiscovery(PeerDiscovery peerDiscovery) {
        this.lock.lock();
        try {
            if (this.getMaxConnections() == 0) {
                this.setMaxConnections(4);
            }
            this.peerDiscoverers.add(peerDiscovery);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverPeers() throws PeerDiscoveryException {
        long start = System.currentTimeMillis();
        HashSet addressSet = Sets.newHashSet();
        for (PeerDiscovery peerDiscovery : this.peerDiscoverers) {
            InetSocketAddress[] addresses;
            for (InetSocketAddress address : addresses = peerDiscovery.getPeers(5L, TimeUnit.SECONDS)) {
                addressSet.add(new PeerAddress(address));
            }
            if (addressSet.size() <= 0) continue;
            break;
        }
        List<PeerAddress> list = this.inactives;
        synchronized (list) {
            this.inactives.addAll(addressSet);
        }
        log.info("Peer discovery took {}msec", (Object)(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToAnyPeer() throws PeerDiscoveryException {
        PeerAddress addr;
        Service.State state = this.state();
        if (state != Service.State.STARTING && state != Service.State.RUNNING) {
            return;
        }
        List<PeerAddress> list = this.inactives;
        synchronized (list) {
            if (this.inactives.size() == 0) {
                this.discoverPeers();
            }
            if (this.inactives.size() == 0) {
                log.debug("Peer discovery didn't provide us any more peers, not trying to build new connection.");
                return;
            }
            addr = this.inactives.remove(this.inactives.size() - 1);
        }
        this.connectTo(addr.toSocketAddress(), false);
    }

    protected void startUp() throws Exception {
        this.pingTimer = new Timer("Peer pinging thread", true);
        for (int i = 0; i < this.getMaxConnections(); ++i) {
            try {
                this.connectToAnyPeer();
                continue;
            }
            catch (PeerDiscoveryException e) {
                if (e.getCause() instanceof InterruptedException) {
                    return;
                }
                log.error(e.getMessage());
            }
        }
    }

    protected void shutDown() throws Exception {
        this.pingTimer.cancel();
        this.channels.close().await();
        this.bootstrap.releaseExternalResources();
        for (PeerDiscovery peerDiscovery : this.peerDiscoverers) {
            peerDiscovery.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWallet(Wallet wallet) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)wallet);
            Preconditions.checkState((!this.wallets.contains(wallet) ? 1 : 0) != 0);
            this.wallets.add(wallet);
            this.announcePendingWalletTransactions(Collections.singletonList(wallet), this.peers);
            wallet.addEventListener(this.walletEventListener);
            this.recalculateFastCatchupAndFilter();
            this.updateVersionMessageRelayTxesBeforeFilter(this.getVersionMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(Preconditions.checkNotNull((Object)wallet));
        wallet.removeEventListener(this.walletEventListener);
    }

    private void recalculateFastCatchupAndFilter() {
        Preconditions.checkState((boolean)this.lock.isLocked());
        if (this.chain != null && this.chain.shouldVerifyTransactions()) {
            return;
        }
        long earliestKeyTime = Long.MAX_VALUE;
        int elements = 0;
        for (Wallet w : this.wallets) {
            earliestKeyTime = Math.min(earliestKeyTime, w.getEarliestKeyCreationTime());
            elements += w.getBloomFilterElementCount();
        }
        if (elements > 0) {
            this.lastBloomFilterElementCount = elements > this.lastBloomFilterElementCount ? elements + 100 : this.lastBloomFilterElementCount;
            BloomFilter filter = new BloomFilter(this.lastBloomFilterElementCount, this.bloomFilterFPRate, this.bloomFilterTweak);
            for (Wallet w : this.wallets) {
                filter.merge(w.getBloomFilter(this.lastBloomFilterElementCount, this.bloomFilterFPRate, this.bloomFilterTweak));
            }
            this.bloomFilter = filter;
            for (Peer peer : this.peers) {
                try {
                    peer.setBloomFilter(filter);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.setFastCatchupTimeSecs(earliestKeyTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBloomFilterFalsePositiveRate(double bloomFilterFPRate) {
        this.lock.lock();
        try {
            this.bloomFilterFPRate = bloomFilterFPRate;
            this.recalculateFastCatchupAndFilter();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int numConnectedPeers() {
        return this.peers.size();
    }

    public ChannelFuture connectTo(SocketAddress address) {
        return this.connectTo(address, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelFuture connectTo(SocketAddress address, boolean incrementMaxConnections) {
        ChannelFuture future = this.bootstrap.connect(address);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    PeerGroup.this.channels.add((Object)future.getChannel());
                }
            }
        });
        TCPNetworkConnection.NetworkHandler networkHandler = (TCPNetworkConnection.NetworkHandler)future.getChannel().getPipeline().get("codec");
        if (networkHandler != null) {
            networkHandler.getOwnerObject().setRemoteAddress(address);
        }
        if (incrementMaxConnections) {
            this.lock.lock();
            try {
                ++this.maxConnections;
            }
            finally {
                this.lock.unlock();
            }
        }
        return future;
    }

    public static Peer peerFromChannelFuture(ChannelFuture future) {
        return PeerGroup.peerFromChannel(future.getChannel());
    }

    public static Peer peerFromChannel(Channel channel) {
        return ((Peer.PeerHandler)channel.getPipeline().get("peer")).getPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlockChainDownload(PeerEventListener listener) {
        this.lock.lock();
        try {
            this.downloadListener = listener;
            if (!this.peers.isEmpty()) {
                this.startBlockChainDownloadFromPeer(this.peers.iterator().next());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void downloadBlockChain() {
        DownloadListener listener = new DownloadListener();
        this.startBlockChainDownload(listener);
        try {
            listener.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewPeer(Peer peer) {
        int newSize = -1;
        this.lock.lock();
        try {
            log.info("{}: New peer", (Object)peer);
            this.pendingPeers.remove(peer);
            this.peers.add(peer);
            newSize = this.peers.size();
            try {
                if (this.bloomFilter != null) {
                    peer.setBloomFilter(this.bloomFilter);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            peer.setDownloadData(false);
            for (Wallet wallet : this.wallets) {
                peer.addWallet(wallet);
            }
            Peer newDownloadPeer = this.selectDownloadPeer(this.peers);
            if (this.downloadPeer != newDownloadPeer) {
                boolean shouldDownloadChain;
                this.setDownloadPeer(newDownloadPeer);
                boolean bl = shouldDownloadChain = this.downloadListener != null && this.chain != null;
                if (shouldDownloadChain) {
                    this.startBlockChainDownloadFromPeer(this.downloadPeer);
                }
            }
            peer.addEventListener(this.getDataListener);
            this.announcePendingWalletTransactions(this.wallets, Collections.singletonList(peer));
            for (PeerEventListener listener : this.peerEventListeners) {
                peer.addEventListener(listener);
            }
            this.setupPingingForNewPeer(peer);
        }
        finally {
            this.lock.unlock();
        }
        for (PeerEventListener listener : this.peerEventListeners) {
            listener.onPeerConnected(peer, newSize);
        }
    }

    private void setupPingingForNewPeer(final Peer peer) {
        Runnable[] pingRunnable;
        Preconditions.checkState((boolean)this.lock.isLocked());
        if (peer.getPeerVersionMessage().clientVersion < 60001) {
            return;
        }
        if (this.getPingIntervalMsec() <= 0L) {
            return;
        }
        pingRunnable = new Runnable[]{new Runnable(){
            private boolean firstRun = true;

            @Override
            public void run() {
                if (this.firstRun) {
                    this.firstRun = false;
                    try {
                        peer.ping().addListener((Runnable)this, (Executor)MoreExecutors.sameThreadExecutor());
                    }
                    catch (Exception e) {
                        log.warn("{}: Exception whilst trying to ping peer: {}", (Object)peer, (Object)e.toString());
                        return;
                    }
                    return;
                }
                long interval = PeerGroup.this.getPingIntervalMsec();
                if (interval <= 0L) {
                    return;
                }
                PeerGroup.this.pingTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            if (!PeerGroup.this.peers.contains(peer) || !PeerGroup.this.isRunning()) {
                                return;
                            }
                            peer.ping().addListener(pingRunnable[0], (Executor)MoreExecutors.sameThreadExecutor());
                        }
                        catch (Exception e) {
                            log.warn("{}: Exception whilst trying to ping peer: {}", (Object)peer, (Object)e.toString());
                        }
                    }
                }, interval);
            }
        }};
        pingRunnable[0].run();
    }

    private boolean announcePendingWalletTransactions(List<Wallet> announceWallets, List<Peer> announceToPeers) {
        Preconditions.checkState((boolean)this.lock.isLocked());
        InventoryMessage inv = new InventoryMessage(this.params);
        for (Wallet w : announceWallets) {
            for (Transaction tx : w.getPendingTransactions()) {
                inv.addTransaction(tx);
            }
        }
        if (inv.getItems().size() == 0) {
            return true;
        }
        boolean success = false;
        for (Peer p : announceToPeers) {
            log.info("{}: Announcing {} pending wallet transactions", (Object)p.getAddress(), (Object)inv.getItems().size());
            p.sendMessage(inv);
            success = true;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDownloadPeer(Peer peer) {
        this.lock.lock();
        try {
            if (this.downloadPeer == peer) {
                return;
            }
            if (this.chain == null) {
                this.downloadPeer = peer;
                return;
            }
            if (this.downloadPeer != null) {
                log.info("Unsetting download peer: {}", (Object)this.downloadPeer);
                this.downloadPeer.setDownloadData(false);
            }
            this.downloadPeer = peer;
            if (this.downloadPeer != null) {
                log.info("Setting download peer: {}", (Object)this.downloadPeer);
                this.downloadPeer.setDownloadData(true);
                this.downloadPeer.setDownloadParameters(this.fastCatchupTimeSecs, this.bloomFilter != null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public MemoryPool getMemoryPool() {
        return this.memoryPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFastCatchupTimeSecs(long secondsSinceEpoch) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.chain == null || !this.chain.shouldVerifyTransactions() ? 1 : 0) != 0, (Object)"Fast catchup is incompatible with fully verifying");
            this.fastCatchupTimeSecs = secondsSinceEpoch;
            if (this.downloadPeer != null) {
                this.downloadPeer.setDownloadParameters(secondsSinceEpoch, this.bloomFilter != null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFastCatchupTimeSecs() {
        this.lock.lock();
        try {
            long l = this.fastCatchupTimeSecs;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePeerDeath(Peer peer) {
        Service.State state = this.state();
        if (state != Service.State.RUNNING && state != Service.State.STARTING) {
            return;
        }
        int numPeers = 0;
        int numConnectedPeers = 0;
        this.lock.lock();
        try {
            this.pendingPeers.remove(peer);
            this.peers.remove(peer);
            log.info("{}: Peer died", (Object)peer.getAddress());
            if (peer == this.downloadPeer) {
                log.info("Download peer died. Picking a new one.");
                this.setDownloadPeer(null);
                Peer newDownloadPeer = this.selectDownloadPeer(this.peers);
                if (newDownloadPeer != null) {
                    this.setDownloadPeer(newDownloadPeer);
                    if (this.downloadListener != null) {
                        this.startBlockChainDownloadFromPeer(newDownloadPeer);
                    }
                }
            }
            numPeers = this.peers.size() + this.pendingPeers.size();
            numConnectedPeers = this.peers.size();
        }
        finally {
            this.lock.unlock();
        }
        if (numPeers < this.getMaxConnections()) {
            try {
                this.connectToAnyPeer();
            }
            catch (PeerDiscoveryException e) {
                log.error(e.getMessage());
            }
        }
        peer.removeEventListener(this.getDataListener);
        for (Wallet wallet : this.wallets) {
            peer.removeWallet(wallet);
        }
        for (PeerEventListener listener : this.peerEventListeners) {
            listener.onPeerDisconnected(peer, numConnectedPeers);
            peer.removeEventListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBlockChainDownloadFromPeer(Peer peer) {
        this.lock.lock();
        try {
            peer.addEventListener(this.downloadListener);
            this.setDownloadPeer(peer);
            peer.startBlockChainDownload();
        }
        catch (IOException e) {
            log.error("failed to start block chain download from " + peer, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<PeerGroup> waitForPeers(final int numPeers) {
        this.lock.lock();
        try {
            if (this.peers.size() >= numPeers) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)((Object)this));
                return listenableFuture;
            }
        }
        finally {
            this.lock.unlock();
        }
        final SettableFuture future = SettableFuture.create();
        this.addEventListener(new AbstractPeerEventListener(){

            @Override
            public void onPeerConnected(Peer peer, int peerCount) {
                if (peerCount >= numPeers) {
                    future.set((Object)PeerGroup.this);
                    PeerGroup.this.removeEventListener(this);
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinBroadcastConnections() {
        this.lock.lock();
        try {
            if (this.minBroadcastConnections == 0) {
                int max = this.getMaxConnections();
                if (max <= 1) {
                    int n = max;
                    return n;
                }
                int n = (int)Math.round((double)this.getMaxConnections() / 2.0);
                return n;
            }
            int n = this.minBroadcastConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinBroadcastConnections(int value) {
        this.lock.lock();
        try {
            this.minBroadcastConnections = value;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ListenableFuture<Transaction> broadcastTransaction(Transaction tx) {
        return this.broadcastTransaction(tx, this.getMinBroadcastConnections());
    }

    public ListenableFuture<Transaction> broadcastTransaction(final Transaction tx, final int minConnections) {
        final SettableFuture future = SettableFuture.create();
        log.info("Waiting for {} peers required for broadcast ...", (Object)minConnections);
        ListenableFuture<PeerGroup> peerAvailabilityFuture = this.waitForPeers(minConnections);
        peerAvailabilityFuture.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Peer somePeer;
                PeerGroup.this.lock.lock();
                try {
                    somePeer = (Peer)PeerGroup.this.peers.get(0);
                }
                finally {
                    PeerGroup.this.lock.unlock();
                }
                log.info("broadcastTransaction: Enough peers, adding {} to the memory pool and sending to {}", (Object)tx.getHashAsString(), (Object)somePeer);
                final Transaction pinnedTx = PeerGroup.this.memoryPool.seen(tx, somePeer.getAddress());
                if (minConnections > 1) {
                    tx.getConfidence().addEventListener(new TransactionConfidence.Listener(){

                        @Override
                        public void onConfidenceChanged(Transaction tx) {
                            TransactionConfidence conf = tx.getConfidence();
                            int numSeenPeers = conf.numBroadcastPeers();
                            boolean mined = conf.getConfidenceType() != TransactionConfidence.ConfidenceType.NOT_SEEN_IN_CHAIN;
                            log.info("broadcastTransaction: TX {} seen by {} peers{}", new Object[]{pinnedTx.getHashAsString(), numSeenPeers, mined ? " and mined" : ""});
                            if (numSeenPeers < minConnections && !mined) {
                                return;
                            }
                            for (Wallet wallet : PeerGroup.this.wallets) {
                                try {
                                    wallet.receivePending(pinnedTx, null);
                                }
                                catch (Throwable t) {
                                    future.setException(t);
                                    return;
                                }
                            }
                            log.info("broadcastTransaction: {} complete", (Object)pinnedTx.getHashAsString());
                            tx.getConfidence().removeEventListener(this);
                            future.set((Object)pinnedTx);
                        }
                    });
                }
                ChannelFuture sendComplete = somePeer.sendMessage(pinnedTx);
                if (minConnections == 1) {
                    sendComplete.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture _) throws Exception {
                            for (Wallet wallet : PeerGroup.this.wallets) {
                                try {
                                    wallet.receivePending(pinnedTx, null);
                                }
                                catch (Throwable t) {
                                    future.setException(t);
                                    return;
                                }
                            }
                            future.set((Object)pinnedTx);
                        }
                    });
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPingIntervalMsec() {
        this.lock.lock();
        try {
            long l = this.pingIntervalMsec;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPingIntervalMsec(long pingIntervalMsec) {
        this.lock.lock();
        try {
            this.pingIntervalMsec = pingIntervalMsec;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMostCommonChainHeight() {
        this.lock.lock();
        try {
            int n = PeerGroup.getMostCommonChainHeight(this.peers);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int getMostCommonChainHeight(List<Peer> peers) {
        int s = peers.size();
        int[] heights = new int[s];
        int[] counts = new int[s];
        int maxCount = 0;
        block0: for (Peer peer : peers) {
            int h = (int)peer.getBestHeight();
            for (int cursor = 0; cursor < s; ++cursor) {
                if (heights[cursor] == h) {
                    int n = cursor;
                    int n2 = counts[n] + 1;
                    counts[n] = n2;
                    maxCount = Math.max(n2, maxCount);
                    continue block0;
                }
                if (heights[cursor] != 0) continue;
                Preconditions.checkState((counts[cursor] == 0 ? 1 : 0) != 0);
                heights[cursor] = h;
                counts[cursor] = 1;
                maxCount = Math.max(maxCount, 1);
                continue block0;
            }
        }
        int[] freqHeights = new int[s];
        int cursor = 0;
        for (int i = 0; i < s; ++i) {
            if (counts[i] != maxCount) continue;
            freqHeights[cursor++] = heights[i];
        }
        Arrays.sort(freqHeights);
        return freqHeights[s - 1];
    }

    protected Peer selectDownloadPeer(List<Peer> peers) {
        if (peers.isEmpty()) {
            return null;
        }
        int mostCommonChainHeight = PeerGroup.getMostCommonChainHeight(peers);
        ArrayList<Peer> candidates = new ArrayList<Peer>();
        for (Peer peer : peers) {
            if (peer.getBestHeight() != (long)mostCommonChainHeight) continue;
            candidates.add(peer);
        }
        int highestVersion = 0;
        int preferredVersion = 0;
        int PREFERRED_VERSION = 70000;
        for (Peer peer : candidates) {
            highestVersion = Math.max(peer.getPeerVersionMessage().clientVersion, highestVersion);
            preferredVersion = Math.min(highestVersion, 70000);
        }
        ArrayList<PeerAndPing> candidates2 = new ArrayList<PeerAndPing>();
        for (Peer peer : candidates) {
            if (peer.getPeerVersionMessage().clientVersion < preferredVersion) continue;
            PeerAndPing pap = new PeerAndPing();
            pap.peer = peer;
            pap.pingTime = peer.getPingTime();
            candidates2.add(pap);
        }
        Collections.sort(candidates2, new Comparator<PeerAndPing>(){

            @Override
            public int compare(PeerAndPing peerAndPing, PeerAndPing peerAndPing2) {
                if (peerAndPing.pingTime < peerAndPing2.pingTime) {
                    return -1;
                }
                if (peerAndPing.pingTime == peerAndPing2.pingTime) {
                    return 0;
                }
                return 1;
            }
        });
        return ((PeerAndPing)candidates2.get((int)0)).peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer getDownloadPeer() {
        this.lock.lock();
        try {
            Peer peer = this.downloadPeer;
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class PeerGroupThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        PeerGroupThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "PeerGroup-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setPriority(Math.max(1, Thread.currentThread().getPriority() - 1));
            t.setDaemon(true);
            return t;
        }
    }

    private static class PeerAndPing {
        Peer peer;
        long pingTime;

        private PeerAndPing() {
        }
    }

    private class PeerStartupListener
    implements Peer.PeerLifecycleListener {
        private PeerStartupListener() {
        }

        @Override
        public void onPeerConnected(Peer peer) {
            PeerGroup.this.handleNewPeer(peer);
        }

        @Override
        public void onPeerDisconnected(Peer peer) {
            PeerGroup.this.handlePeerDeath(peer);
        }
    }
}

