/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.util.encoders.Hex;

public class NetworkParameters
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final int PROTOCOL_VERSION = 70001;
    public static final byte[] SATOSHI_KEY = Hex.decode((String)"04fc9702847840aaf195de8442ebecedf5b095cdbb9bc716bda9110971b28a49e0ead8564ff0db22209e0374782c093bb899692d524e9d6a6956e7c5ecbcd68284");
    public static final String ID_PRODNET = "org.bitcoin.production";
    public static final String ID_TESTNET = "org.bitcoin.test";
    static final String ID_UNITTESTNET = "com.google.bitcoin.unittest";
    public final Block genesisBlock;
    public BigInteger proofOfWorkLimit;
    public final int port;
    public final long packetMagic;
    public final int addressHeader;
    public final int dumpedPrivateKeyHeader;
    public int interval;
    public final int targetTimespan;
    public byte[] alertSigningKey;
    private final String id;
    private final int spendableCoinbaseDepth;
    private int subsidyDecreaseBlockCount;
    boolean allowEmptyPeerChains;
    public final int[] acceptableAddressCodes;
    private final String[] dnsSeeds;
    public Map<Integer, Sha256Hash> checkpoints = new HashMap<Integer, Sha256Hash>();
    public static final int TARGET_TIMESPAN = 1209600;
    public static final int TARGET_SPACING = 600;
    public static final int INTERVAL = 2016;
    public static final int BIP16_ENFORCE_TIME = 1333238400;
    public static final BigInteger MAX_MONEY = new BigInteger("21000000", 10).multiply(Utils.COIN);
    private static NetworkParameters tn2;
    private static NetworkParameters tn3;
    private static NetworkParameters pn;
    private static NetworkParameters ut;

    private NetworkParameters(int type) {
        this.alertSigningKey = SATOSHI_KEY;
        this.genesisBlock = NetworkParameters.createGenesis(this);
        if (type == 0) {
            this.interval = 2016;
            this.targetTimespan = 1209600;
            this.proofOfWorkLimit = Utils.decodeCompactBits(486604799L);
            this.acceptableAddressCodes = new int[]{0};
            this.dumpedPrivateKeyHeader = 128;
            this.addressHeader = 0;
            this.port = 8333;
            this.packetMagic = 4190024921L;
            this.genesisBlock.setDifficultyTarget(486604799L);
            this.genesisBlock.setTime(1231006505L);
            this.genesisBlock.setNonce(2083236893L);
            this.id = ID_PRODNET;
            this.subsidyDecreaseBlockCount = 210000;
            this.allowEmptyPeerChains = false;
            this.spendableCoinbaseDepth = 100;
            String genesisHash = this.genesisBlock.getHashAsString();
            Preconditions.checkState((boolean)genesisHash.equals("000000000019d6689c085ae165831e934ff763ae46a2a6c172b3f1b60a8ce26f"), (Object)genesisHash);
            this.checkpoints.put(91722, new Sha256Hash("00000000000271a2dc26e7667f8419f2e15416dc6955e5a6c6cdf3f2574dd08e"));
            this.checkpoints.put(91812, new Sha256Hash("00000000000af0aed4792b1acee3d966af36cf5def14935db8de83d6f9306f2f"));
            this.checkpoints.put(91842, new Sha256Hash("00000000000a4d0a398161ffc163c503763b1f4360639393e0e4c8e300e0caec"));
            this.checkpoints.put(91880, new Sha256Hash("00000000000743f190a18c5577a3c2d2a1f610ae9601ac046a38084ccb7cd721"));
            this.checkpoints.put(200000, new Sha256Hash("000000000000034a7dedef4a161fa058a2d67a173a90155f3a2fe6fc132e0ebf"));
            this.dnsSeeds = new String[]{"seed.bitcoin.sipa.be", "dnsseed.bluematt.me", "dnsseed.bitcoin.dashjr.org", "bitseed.xf2.org"};
        } else if (type == 3) {
            this.id = ID_TESTNET;
            this.packetMagic = 185665799L;
            this.interval = 2016;
            this.targetTimespan = 1209600;
            this.proofOfWorkLimit = Utils.decodeCompactBits(486604799L);
            this.port = 18333;
            this.addressHeader = 111;
            this.acceptableAddressCodes = new int[]{111};
            this.dumpedPrivateKeyHeader = 239;
            this.genesisBlock.setTime(1296688602L);
            this.genesisBlock.setDifficultyTarget(486604799L);
            this.genesisBlock.setNonce(414098458L);
            this.allowEmptyPeerChains = true;
            this.spendableCoinbaseDepth = 100;
            this.subsidyDecreaseBlockCount = 210000;
            String genesisHash = this.genesisBlock.getHashAsString();
            Preconditions.checkState((boolean)genesisHash.equals("000000000933ea01ad0ee984209779baaec3ced90fa3f408719526f8d77f4943"), (Object)genesisHash);
            this.dnsSeeds = new String[]{"testnet-seed.bitcoin.petertodd.org", "testnet-seed.bluematt.me"};
        } else if (type == 2) {
            this.id = ID_TESTNET;
            this.packetMagic = 4206867930L;
            this.port = 18333;
            this.addressHeader = 111;
            this.interval = 2016;
            this.targetTimespan = 1209600;
            this.proofOfWorkLimit = Utils.decodeCompactBits(487587839L);
            this.acceptableAddressCodes = new int[]{111};
            this.dumpedPrivateKeyHeader = 239;
            this.genesisBlock.setTime(1296688602L);
            this.genesisBlock.setDifficultyTarget(487063544L);
            this.genesisBlock.setNonce(384568319L);
            this.allowEmptyPeerChains = false;
            this.spendableCoinbaseDepth = 100;
            this.subsidyDecreaseBlockCount = 210000;
            String genesisHash = this.genesisBlock.getHashAsString();
            Preconditions.checkState((boolean)genesisHash.equals("00000007199508e34a9ff81e6ec0c477a4cccff2a4767a8eee39c11db367b008"), (Object)genesisHash);
            this.dnsSeeds = null;
        } else if (type == -1) {
            this.id = ID_UNITTESTNET;
            this.packetMagic = 185665799L;
            this.addressHeader = 111;
            this.proofOfWorkLimit = new BigInteger("00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
            this.genesisBlock.setTime(System.currentTimeMillis() / 1000L);
            this.genesisBlock.setDifficultyTarget(545259519L);
            this.genesisBlock.solve();
            this.port = 18333;
            this.interval = 10;
            this.dumpedPrivateKeyHeader = 239;
            this.allowEmptyPeerChains = false;
            this.targetTimespan = 200000000;
            this.spendableCoinbaseDepth = 5;
            this.acceptableAddressCodes = new int[]{111};
            this.subsidyDecreaseBlockCount = 100;
            this.dnsSeeds = null;
        } else {
            throw new RuntimeException();
        }
    }

    private static Block createGenesis(NetworkParameters n) {
        Block genesisBlock = new Block(n);
        Transaction t = new Transaction(n);
        try {
            byte[] bytes = Hex.decode((String)"04ffff001d0104455468652054696d65732030332f4a616e2f32303039204368616e63656c6c6f72206f6e206272696e6b206f66207365636f6e64206261696c6f757420666f722062616e6b73");
            t.addInput(new TransactionInput(n, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes(scriptPubKeyBytes, Hex.decode((String)"04678afdb0fe5548271967f1a67130b7105cd6a828e03909a67962e0ea1f61deb649f6bc3f4cef38c4f35504e51ec112de5c384df7ba0b8d578a4c702b6bf11d5f"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(n, t, Utils.toNanoCoins(50, 0), scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        return genesisBlock;
    }

    public static NetworkParameters testNet() {
        return NetworkParameters.testNet3();
    }

    public static synchronized NetworkParameters testNet2() {
        if (tn2 == null) {
            tn2 = new NetworkParameters(2);
        }
        return tn2;
    }

    public static synchronized NetworkParameters testNet3() {
        if (tn3 == null) {
            tn3 = new NetworkParameters(3);
        }
        return tn3;
    }

    public static synchronized NetworkParameters prodNet() {
        if (pn == null) {
            pn = new NetworkParameters(0);
        }
        return pn;
    }

    public static synchronized NetworkParameters unitTests() {
        if (ut == null) {
            ut = new NetworkParameters(-1);
        }
        return ut;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NetworkParameters)) {
            return false;
        }
        NetworkParameters o = (NetworkParameters)other;
        return o.getId().equals(this.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId()});
    }

    public static NetworkParameters fromID(String id) {
        if (id.equals(ID_PRODNET)) {
            return NetworkParameters.prodNet();
        }
        if (id.equals(ID_TESTNET)) {
            return NetworkParameters.testNet();
        }
        if (id.equals(ID_UNITTESTNET)) {
            return NetworkParameters.unitTests();
        }
        return null;
    }

    public int getSpendableCoinbaseDepth() {
        return this.spendableCoinbaseDepth;
    }

    public boolean passesCheckpoint(int height, Sha256Hash hash) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash == null || checkpointHash.equals(hash);
    }

    public boolean isCheckpoint(int height) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash != null;
    }

    public int getSubsidyDecreaseBlockCount() {
        return this.subsidyDecreaseBlockCount;
    }

    public void setSubsidyDecreaseBlockCount(int value) {
        this.subsidyDecreaseBlockCount = value;
    }

    public String[] getDnsSeeds() {
        return this.dnsSeeds;
    }
}

