(ns clj-fn.dbrest
  (:require [monger.core :as mg]
            [monger.collection :as mc]
            [monger.operators :refer :all]
            [monger.query :refer :all]
            [monger.conversion :refer [from-db-object]]))

(def restdb (atom {}))

(defn setdb! [db_]
  (reset! restdb db_))

;;;;; dbrest
(defn seqid [seq]
  (let [raw  (mg/command
              @restdb
              (sorted-map
               :findAndModify "seq"
               :query {:seq seq}
               :update {$inc  {:id 1}}
               :new 1
               :upsert 1))
        ret  (from-db-object raw true)
        id   (:id (:value ret))]
    id))

(defn fmt-_id [item]
  (let [ret (if item
              (conj item [:_id (str (:_id item))])
              nil)]
    ret))

(defn fmt-item [item]
  (let [item_ (conj item [:_id (str (:_id item))])
        ;item_ (conj item_ [:dateline (.getTime (:_intm item_))])
        ]
    item_))

(defmacro defdbrest [name ns-str]
  (let [base-name   (str name "s" )
        root-name   (str "/" base-name)
        sym-all     (symbol (str "get-" base-name))
        sym-get     (symbol (str "get-"    name))
        sym-get-by  (symbol (str "get-" name "-by"))
        sym-create  (symbol (str "create-" name))
        sym-update  (symbol (str "update-" name))
        sym-delete  (symbol (str "delete-" name))
        ;bind-ns     (symbol (str *ns*))
        bind-ns     (symbol ns-str)
        exp
        `(
          (defn ~sym-create [~'item]
            (let [_item# (assoc ~'item
                                :id (Long. (or (:id ~'item) (seqid ~name)))
                                :_intm (new java.util.Date))]
               (fmt-_id
                (mc/insert-and-return @restdb ~base-name _item#)
                )))

          (defn ~sym-update [id# item#]
            (let [item# (dissoc item# :id)]
              (let [v-inc# (:inc item#)
                    v-dec# (:dec item#)]

                (if v-inc# 
                  (mc/update @restdb ~base-name {:id (Integer. id#)}
                             {$inc {v-inc# 1}})
                  (if v-dec# 
                    (mc/update @restdb ~base-name {:id (Integer. id#)}
                               {$inc {v-dec# -1}})
                    (mc/update @restdb ~base-name {:id (Integer. id#)}
                               {$set item#})
                    )
                  )


              (fmt-_id
                (assoc item# :id id#)
                )
                )
              ))

          (defn ~sym-get [id#]
             (fmt-_id
              (mc/find-one-as-map @restdb ~base-name {:id (Integer. id#)})))

          (defn ~sym-delete [id#]
            (mc/remove @restdb ~base-name {:id (Integer. id#)}))

          (defn ~sym-all [page# limit# & [params#]]
            (let [page#  (Integer. (or page# 1))
                  limit# (Integer. (or limit# 10))
                  filter# (or params# {})
                  filter# (dissoc filter# :page :size)
                  filter# (if (:id filter#) 
                            (assoc filter# :id (Integer. (:id filter#))) filter#)
                  filter# (if (:uid filter#) 
                            (assoc filter# :uid (Integer. (:uid filter#))) filter#)
                  filter# (if (:tags filter#) 
                            (assoc filter# :tags {$in [(:tags filter#)]}) filter#)
                  count#  (mc/count @restdb ~base-name filter#)
                  data#  (map fmt-item
                             (with-collection @restdb ~base-name
                               (find filter#)
                               (sort {:_intm -1})
                               (paginate :page page# :per-page limit#)))
                  ]
              {:count count# :data data#}
              ;{:filter filter#}
                 ))

          (defn ~sym-get-by [filter#]
            (map fmt-item
                 (mc/find-maps @restdb ~base-name filter#)
                 )
            )
          )
        ]

    (binding [*ns* (find-ns bind-ns)]
      (doseq [exp_ exp]
        (eval exp_))
      )))

(defn gen-rest-db [name]
  (let [base-name   (str name "s" )
        root-name   (str "/" base-name)
        sym-all     (symbol (str "get-" base-name))
        sym-get     (symbol (str "get-"    name))
        sym-get-by  (symbol (str "get-" name "-by"))
        sym-create  (symbol (str "create-" name))
        sym-update  (symbol (str "update-" name))
        sym-delete  (symbol (str "delete-" name))]
    `(
      (defn ~sym-create [~'item]
        (let [_item# (assoc ~'item
                            :id (Long. (or (:id ~'item) (seqid ~name)))
                            :_intm (new java.util.Date))]
          (fmt-_id
            (mc/insert-and-return @restdb ~base-name _item#)
            )))

      (defn ~sym-update [id# item#]
        (let [item# (dissoc item# :id)]
          (let [v-inc# (:inc item#)
                v-dec# (:dec item#)
                filter# {:id (Integer. id#)}
                filter# (if (:uid item#) 
                          (assoc filter# :uid (Integer. (:uid item#))) filter#)
                item# (assoc item# :_uptm (new java.util.Date))
                ]

            (if v-inc# 
              (mc/update @restdb ~base-name filter#
                         {$inc {v-inc# 1}})
              (if v-dec# 
                (mc/update @restdb ~base-name filter#
                           {$inc {v-dec# -1}})
                (mc/update @restdb ~base-name filter#
                           {$set item#})
                )
              )


            (fmt-_id
              (assoc item# :id id#)
              )
            )
          ))

      (defn ~sym-get [id# & [uid#]]
        (let [filter# {:id (Integer. id#)}
              filter# (if uid#
                        (assoc filter# :uid (Integer. uid#)) filter#)
              ]
        (fmt-_id
          (mc/find-one-as-map @restdb ~base-name filter#))))

      (defn ~sym-delete [id# & [uid#]]
        (let [filter# {:id (Integer. id#)}
              filter# (if uid#
                        (assoc filter# :uid (Integer. uid#)) filter#)
              ]
          (mc/remove @restdb ~base-name filter#)
          {}
          ))

      (defn ~sym-all [page# limit# & [params#]]
        (let [page#  (Integer. (or page# 1))
              limit# (Integer. (or limit# 10))
              sort-name# (:sort params#)
              sort-asc# (Integer. (or (:asc params#) -1))
              q-fields# (or (:fields params#) [])

              v-sort# (if sort-name#
                           (clojure.walk/keywordize-keys {sort-name# sort-asc#})
                       {:_intm -1})
              params# (dissoc params# :sort :asc :fields)

              filter# (or params# {})
              filter# (dissoc filter# :page :size :token)
              filter# (if (:id filter#) 
                        (assoc filter# :id (Integer. (:id filter#))) filter#)
              filter# (if (:uid filter#) 
                        (assoc filter# :uid (Integer. (:uid filter#))) filter#)
              filter# (if (:tags filter#) 
                        (assoc filter# :tags {$in [(:tags filter#)]}) filter#)
              count#  (mc/count @restdb ~base-name filter#)
              data#  (map fmt-item
                          (with-collection @restdb ~base-name
                            (find filter#)
                            (fields q-fields#)
                            (sort v-sort#)
                            (paginate :page page# :per-page limit#)))
              ]
          {:count count# :data data#}
          ))

      (defn ~sym-get-by [filter#]
        (map fmt-item
             (mc/find-maps @restdb ~base-name filter#)
             )
        )
      )))
