(ns clj-fn.dbrest
  (:require [monger.core :as mg]
            [monger.collection :as mc]
            [monger.operators :refer :all]
            [monger.query :refer :all]
            [monger.conversion :refer [from-db-object]]))

(def restdb (atom {}))

(defn setdb! [db_]
  (reset! restdb db_))

;;;;; dbrest
(defn seqid [seq]
  (let [raw  (mg/command
              @restdb
              (sorted-map
               :findAndModify "seq"
               :query {:seq seq}
               :update {$inc  {:id 1}}
               :new 1
               :upsert 1))
        ret  (from-db-object raw true)
        id   (:id (:value ret))]
    id))

(defn fmt-_id [item]
  (let [ret (if item
              (conj item [:_id (str (:_id item))])
              nil)]
    ret))

(defn fmt-item [item]
  (let [item_ (conj item [:_id (str (:_id item))])
        ;item_ (conj item_ [:dateline (.getTime (:_intm item_))])
        ]
    item_))

(defmacro defdbrest [name ns-str]
  (let [base-name   (str name "s" )
        root-name   (str "/" base-name)
        sym-all     (symbol (str "get-" base-name))
        sym-get     (symbol (str "get-"    name))
        sym-get-by  (symbol (str "get-" name "-by"))
        sym-create  (symbol (str "create-" name))
        sym-update  (symbol (str "update-" name))
        sym-delete  (symbol (str "delete-" name))
        ;bind-ns     (symbol (str *ns*))
        bind-ns     (symbol ns-str)
        exp
        `(
          (defn ~sym-create [~'item]
            (let [_item# (assoc ~'item
                                :id (Long. (or (:id ~'item) (seqid ~name)))
                                :_intm (new java.util.Date))]
               (fmt-_id
                (mc/insert-and-return @restdb ~base-name _item#)
                )))

          (defn ~sym-update [id# item#]
            (mc/update @restdb ~base-name {:id (Integer. id#)}
                       {$set item#})
             (fmt-_id
              (assoc item# :id id#)))

          (defn ~sym-get [id#]
             (fmt-_id
              (mc/find-one-as-map @restdb ~base-name {:id (Integer. id#)})))

          (defn ~sym-delete [id#]
            (mc/remove @restdb ~base-name {:id (Integer. id#)}))

          (defn ~sym-all [page# limit# params#]
            (let [page#  (Integer. (or page# 1))
                  limit# (Integer. (or limit# 10))]
                 (map fmt-item
                      (with-collection @restdb ~base-name
                        (find {})
                        (sort {:_intm -1})
                        (paginate :page page# :per-page limit#)))))

          (defn ~sym-get-by [filter#]
            (map fmt-item
                 (mc/find-maps @restdb ~base-name filter#)
                 )
            )
          )
        ]

    (binding [*ns* (find-ns bind-ns)]
      (doseq [exp_ exp]
        (eval exp_))
      )))
