/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.apns.clients;

import com.clevertap.apns.Notification;
import com.clevertap.apns.NotificationResponse;
import com.clevertap.apns.NotificationResponseListener;
import com.clevertap.apns.clients.SyncOkHttpApnsClient;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AsyncOkHttpApnsClient
extends SyncOkHttpApnsClient {
    public AsyncOkHttpApnsClient(String apnsAuthKey, String teamID, String keyID, boolean production, String defaultTopic, ConnectionPool connectionPool) {
        super(apnsAuthKey, teamID, keyID, production, defaultTopic, connectionPool);
    }

    public AsyncOkHttpApnsClient(InputStream certificate, String password, boolean production, String defaultTopic, ConnectionPool connectionPool) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        super(certificate, password, production, defaultTopic, connectionPool);
    }

    public AsyncOkHttpApnsClient(String apnsAuthKey, String teamID, String keyID, boolean production, String defaultTopic, OkHttpClient.Builder builder) {
        this(apnsAuthKey, teamID, keyID, production, defaultTopic, builder, 443);
    }

    public AsyncOkHttpApnsClient(String apnsAuthKey, String teamID, String keyID, boolean production, String defaultTopic, OkHttpClient.Builder builder, int connectionPort) {
        super(apnsAuthKey, teamID, keyID, production, defaultTopic, builder);
    }

    public AsyncOkHttpApnsClient(InputStream certificate, String password, boolean production, String defaultTopic, OkHttpClient.Builder builder) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        this(certificate, password, production, defaultTopic, builder, 443);
    }

    public AsyncOkHttpApnsClient(InputStream certificate, String password, boolean production, String defaultTopic, OkHttpClient.Builder builder, int connectionPort) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        super(certificate, password, production, defaultTopic, builder);
    }

    @Override
    public NotificationResponse push(Notification notification) {
        throw new UnsupportedOperationException("Synchronous requests are not supported by this client");
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    @Override
    public void push(final Notification notification, final NotificationResponseListener nrl) {
        Request request = this.buildRequest(notification);
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                nrl.onFailure(notification, new NotificationResponse(null, -1, null, e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                NotificationResponse nr;
                try {
                    nr = AsyncOkHttpApnsClient.this.parseResponse(response);
                }
                catch (Throwable t) {
                    nrl.onFailure(notification, new NotificationResponse(null, -1, null, t));
                    return;
                }
                finally {
                    if (response != null) {
                        response.body().close();
                    }
                }
                if (nr.getHttpStatusCode() == 200) {
                    nrl.onSuccess(notification);
                } else {
                    nrl.onFailure(notification, nr);
                }
            }
        });
    }
}

