/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.apns;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.UUID;

public class Notification {
    private final String payload;
    private final String token;
    private final String topic;
    private final String collapseId;
    private final long expiration;
    private final Priority priority;
    private final String pushType;
    private final UUID uuid;

    protected Notification(String payload, String token, String topic, String collapseId, long expiration, Priority priority, UUID uuid, String pushType) {
        this.payload = payload;
        this.token = token;
        this.topic = topic;
        this.collapseId = collapseId;
        this.expiration = expiration;
        this.priority = priority;
        this.uuid = uuid;
        this.pushType = pushType;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getCollapseId() {
        return this.collapseId;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getToken() {
        return this.token;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getPushType() {
        return this.pushType;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static class Builder {
        private final ObjectMapper mapper = new ObjectMapper();
        private final HashMap<String, Object> root;
        private final HashMap<String, Object> aps;
        private final HashMap<String, Object> alert;
        private final String token;
        private String topic = null;
        private String collapseId = null;
        private long expiration = -1L;
        private Priority priority;
        private UUID uuid;
        private String pushType;

        public Builder(String token) {
            this.token = token;
            this.root = new HashMap();
            this.aps = new HashMap();
            this.alert = new HashMap();
        }

        public Builder mutableContent(boolean mutable) {
            if (mutable) {
                this.aps.put("mutable-content", 1);
            } else {
                this.aps.remove("mutable-content");
            }
            return this;
        }

        public Builder mutableContent() {
            return this.mutableContent(true);
        }

        public Builder contentAvailable(boolean contentAvailable) {
            if (contentAvailable) {
                this.aps.put("content-available", 1);
            } else {
                this.aps.remove("content-available");
            }
            return this;
        }

        public Builder contentAvailable() {
            return this.contentAvailable(true);
        }

        public Builder alertBody(String body) {
            this.alert.put("body", body);
            return this;
        }

        public Builder alertTitle(String title) {
            this.alert.put("title", title);
            return this;
        }

        public Builder urlArgs(String[] args) {
            this.aps.put("url-args", args);
            return this;
        }

        public Builder sound(String sound) {
            if (sound != null) {
                this.aps.put("sound", sound);
            } else {
                this.aps.remove("sound");
            }
            return this;
        }

        public Builder category(String category) {
            if (category != null) {
                this.aps.put("category", category);
            } else {
                this.aps.remove("category");
            }
            return this;
        }

        public Builder badge(int badge) {
            this.aps.put("badge", badge);
            return this;
        }

        public Builder customField(String key, Object value) {
            this.root.put(key, value);
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder collapseId(String collapseId) {
            this.collapseId = collapseId;
            return this;
        }

        public Builder expiration(long expiration) {
            this.expiration = expiration;
            return this;
        }

        public Builder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder pushType(String pushType) {
            this.pushType = pushType;
            return this;
        }

        public int size() {
            try {
                return this.build().getPayload().getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public Notification build() {
            String payload;
            this.root.put("aps", this.aps);
            this.aps.put("alert", this.alert);
            try {
                payload = this.mapper.writeValueAsString(this.root);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return new Notification(payload, this.token, this.topic, this.collapseId, this.expiration, this.priority, this.uuid, this.pushType);
        }
    }

    public static enum Priority {
        IMMEDIATE(10),
        POWERCONSIDERATION(5);

        private final int code;

        private Priority(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

