(ns rt.postgres.system
  (:require [std.lib :as h]
            [std.lang :as l]))

(l/script :postgres)

(defn pg-tmpl
  "creates a pg template
 
   (sys/pg-tmpl 'hello)
   => '(def$.pg hello pg-hello)"
  {:added "4.0"}
  [sym]
  (let [pg-sym (symbol (str "pg-" sym))]
    (h/$ (def$.pg ~sym ~pg-sym))))

(h/template-entries [pg-tmpl]
  [advisory-lock
   advisory-lock-shared
   advisory-unlock
   advisory-unlock-all
   advisory-unlock-shared
   advisory-xact-lock
   advisory-xact-lock-shared
   available-extension-versions
   available-extensions
   backend-pid
   backup-start-time
   blocking-pids
   cancel-backend
   char-to-encoding
   client-encoding
   collation-actual-version
   collation-for
   collation-is-visible
   column-is-updatable
   column-size
   conf-load-time
   config
   control-checkpoint
   control-init
   control-recovery
   control-system
   conversion-is-visible
   copy-logical-replication-slot
   copy-physical-replication-slot
   create-logical-replication-slot
   create-physical-replication-slot
   create-restore-point
   current-logfile
   current-snapshot
   current-wal-flush-lsn
   current-wal-insert-lsn
   current-wal-lsn
   current-xact-id
   current-xact-id-if-assigned
   cursor
   database-size
   ddl-command-in
   ddl-command-out
   ddl-command-recv
   ddl-command-send
   dependencies-in
   dependencies-out
   dependencies-recv
   dependencies-send
   describe-object
   drop-replication-slot
   encoding-max-length
   encoding-to-char
   event-trigger-ddl-commands
   event-trigger-dropped-objects
   event-trigger-table-rewrite-oid
   event-trigger-table-rewrite-reason
   export-snapshot
   extension-config-dump
   extension-update-paths
   filenode-relation
   function-is-visible
   get-constraintdef
   get-expr
   get-function-arg-default
   get-function-arguments
   get-function-identity-arguments
   get-function-result
   get-functiondef
   get-indexdef
   get-keywords
   get-multixact-members
   get-object-address
   get-partition-constraintdef
   get-partkeydef
   get-publication-tables
   get-replica-identity-index
   get-replication-slots
   get-ruledef
   get-serial-sequence
   get-shmem-allocations
   get-statisticsobjdef
   get-triggerdef
   get-userbyid
   get-viewdef
   has-role
   hba-file-rules
   identify-object
   identify-object-as-address
   import-system-collations
   index-column-has-property
   index-has-property
   indexam-has-property
   indexam-progress-phasename
   indexes-size
   is-in-backup
   is-in-recovery
   is-other-temp-schema
   is-wal-replay-paused
   isolation-test-session-is-blocked
   jit-available
   last-committed-xact
   last-wal-receive-lsn
   last-wal-replay-lsn
   last-xact-replay-timestamp
   listening-channels
   lock-status
   logical-emit-message
   logical-slot-get-binary-changes
   logical-slot-get-changes
   logical-slot-peek-binary-changes
   logical-slot-peek-changes
   ls-archive-statusdir
   ls-dir
   ls-logdir
   ls-tmpdir
   ls-waldir
   lsn-cmp
   lsn-eq
   lsn-ge
   lsn-gt
   lsn-hash
   lsn-hash-extended
   lsn-in
   lsn-larger
   lsn-le
   lsn-lt
   lsn-mi
   lsn-ne
   lsn-out
   lsn-recv
   lsn-send
   lsn-smaller
   mcv-list-in
   mcv-list-items
   mcv-list-out
   mcv-list-recv
   mcv-list-send
   my-temp-schema
   ndistinct-in
   ndistinct-out
   ndistinct-recv
   ndistinct-send
   nextoid
   node-tree-in
   node-tree-out
   node-tree-recv
   node-tree-send
   notification-queue-usage
   notify
   opclass-is-visible
   operator-is-visible
   opfamily-is-visible
   options-to-table
   partition-ancestors
   partition-root
   partition-tree
   postmaster-start-time
   prepared-statement
   prepared-xact
   promote
   read-binary-file
   read-file
   read-file-old
   relation-filenode
   relation-filepath
   relation-is-publishable
   relation-is-updatable
   relation-size
   reload-conf
   replication-origin-advance
   replication-origin-create
   replication-origin-drop
   replication-origin-oid
   replication-origin-progress
   replication-origin-session-is-setup
   replication-origin-session-progress
   replication-origin-session-reset
   replication-origin-session-setup
   replication-origin-xact-reset
   replication-origin-xact-setup
   replication-slot-advance
   rotate-logfile
   rotate-logfile-old
   safe-snapshot-blocking-pids
   sequence-last-value
   sequence-parameters
   show-all-file-settings
   show-all-settings
   show-replication-origin-status
   size-bytes
   size-pretty
   sleep
   sleep-for
   sleep-until
   snapshot-in
   snapshot-out
   snapshot-recv
   snapshot-send
   snapshot-xip
   snapshot-xmax
   snapshot-xmin
   start-backup
   stat-clear-snapshot
   stat-file
   stat-get-activity
   stat-get-analyze-count
   stat-get-archiver
   stat-get-autoanalyze-count
   stat-get-autovacuum-count
   stat-get-backend-activity
   stat-get-backend-activity-start
   stat-get-backend-client-addr
   stat-get-backend-client-port
   stat-get-backend-dbid
   stat-get-backend-idset
   stat-get-backend-pid
   stat-get-backend-start
   stat-get-backend-userid
   stat-get-backend-wait-event
   stat-get-backend-wait-event-type
   stat-get-backend-xact-start
   stat-get-bgwriter-buf-written-checkpoints
   stat-get-bgwriter-buf-written-clean
   stat-get-bgwriter-maxwritten-clean
   stat-get-bgwriter-requested-checkpoints
   stat-get-bgwriter-stat-reset-time
   stat-get-bgwriter-timed-checkpoints
   stat-get-blocks-fetched
   stat-get-blocks-hit
   stat-get-buf-alloc
   stat-get-buf-fsync-backend
   stat-get-buf-written-backend
   stat-get-checkpoint-sync-time
   stat-get-checkpoint-write-time
   stat-get-db-blk-read-time
   stat-get-db-blk-write-time
   stat-get-db-blocks-fetched
   stat-get-db-blocks-hit
   stat-get-db-checksum-failures
   stat-get-db-checksum-last-failure
   stat-get-db-conflict-all
   stat-get-db-conflict-bufferpin
   stat-get-db-conflict-lock
   stat-get-db-conflict-snapshot
   stat-get-db-conflict-startup-deadlock
   stat-get-db-conflict-tablespace
   stat-get-db-deadlocks
   stat-get-db-numbackends
   stat-get-db-stat-reset-time
   stat-get-db-temp-bytes
   stat-get-db-temp-files
   stat-get-db-tuples-deleted
   stat-get-db-tuples-fetched
   stat-get-db-tuples-inserted
   stat-get-db-tuples-returned
   stat-get-db-tuples-updated
   stat-get-db-xact-commit
   stat-get-db-xact-rollback
   stat-get-dead-tuples
   stat-get-function-calls
   stat-get-function-self-time
   stat-get-function-total-time
   stat-get-ins-since-vacuum
   stat-get-last-analyze-time
   stat-get-last-autoanalyze-time
   stat-get-last-autovacuum-time
   stat-get-last-vacuum-time
   stat-get-live-tuples
   stat-get-mod-since-analyze
   stat-get-numscans
   stat-get-progress-info
   stat-get-slru
   stat-get-snapshot-timestamp
   stat-get-subscription
   stat-get-tuples-deleted
   stat-get-tuples-fetched
   stat-get-tuples-hot-updated
   stat-get-tuples-inserted
   stat-get-tuples-returned
   stat-get-tuples-updated
   stat-get-vacuum-count
   stat-get-wal-receiver
   stat-get-wal-senders
   stat-get-xact-blocks-fetched
   stat-get-xact-blocks-hit
   stat-get-xact-function-calls
   stat-get-xact-function-self-time
   stat-get-xact-function-total-time
   stat-get-xact-numscans
   stat-get-xact-tuples-deleted
   stat-get-xact-tuples-fetched
   stat-get-xact-tuples-hot-updated
   stat-get-xact-tuples-inserted
   stat-get-xact-tuples-returned
   stat-get-xact-tuples-updated
   stat-reset
   stat-reset-shared
   stat-reset-single-function-counters
   stat-reset-single-table-counters
   stat-reset-slru
   statistics-obj-is-visible
   stop-backup
   switch-wal
   table-is-visible
   table-size
   tablespace-databases
   tablespace-location
   tablespace-size
   terminate-backend
   timezone-abbrevs
   timezone-names
   total-relation-size
   trigger-depth
   try-advisory-lock
   try-advisory-lock-shared
   try-advisory-xact-lock
   try-advisory-xact-lock-shared
   ts-config-is-visible
   ts-dict-is-visible
   ts-parser-is-visible
   ts-template-is-visible
   type-is-visible
   typeof
   visible-in-snapshot
   wal-lsn-diff
   wal-replay-pause
   wal-replay-resume
   walfile-name
   walfile-name-offset
   xact-commit-timestamp
   xact-status])

