(ns redcap.core
  (:require [std.lib :as h]
            [std.string :as str]
            [redcap.meta :as meta]
            [redcap.unit :as unit]
            [net.http :as http]
            [malli.core :as m]))

(def +units+
  (h/map-juxt
   [(comp keyword :label :input) identity]
   (mapv unit/generate-unit meta/+api-linear+)))

(defn call-api
  "calls the redcap api"
  {:added "0.1"}
  [{:keys [defaults
           spec] :as unit}
   {:keys [url token data]}]
  (let [input (merge defaults {:token token} data)
        _     (when (not (m/validate spec input))
                (throw (ex-info "Not valid"
                                {:explain (m/explain spec input)})))
        body  (http/encode-form-params input)]
    (h/prn body)
    (http/post url {:headers {"Content-Type" "application/x-www-form-urlencoded"
                              "Accept" "application/json"}
                    :body body})))

(defn create-api-form
  "creates an api form"
  {:added "0.1"}
  [[label unit]]
  `(defn ~(symbol (name label))
     ~'[{:keys [url token data] :as input}]
     (call-api (get +units+ ~label)
               ~'input)))

(def +functions+
  (eval (mapv create-api-form (sort +units+))))
