(ns lua.torch.nn
  (:require [std.lib :as h]
            [std.lang :as l]
            [std.string :as str]
            [xt.lang.base-repl :as repl])
  (:refer-clojure :exclude [test]))

(l/script :lua
  {:macro-only true
   :bundle  {:default [["nn" :as nn]]}
   :require [[lua.torch :as tch]
             [lua.core :as u]
             [xt.lang.base-lib :as k]]})

(def +nn+
  '[Abs
    AbsCriterion
    Add
    AddConstant
    BCECriterion
    BatchNormalization
    Bilinear
    Bottle
    CAdd
    CAddTable
    CAddTensorTable
    CDivTable
    CMaxTable
    CMinTable
    CMul
    CMulTable
    CReLU
    CSubTable
    Clamp
    ClassNLLCriterion
    ClassSimplexCriterion
    Collapse
    Concat
    ConcatTable
    Constant
    Container
    Contiguous
    Convert
    Copy
    Cosine
    CosineDistance
    CosineEmbeddingCriterion
    Criterion
    CriterionTable
    CrossEntropyCriterion
    Decorator
    DepthConcat
    DistKLDivCriterion
    DistanceRatioCriterion
    DontCast
    DotProduct
    Dropout
    ELU
    Euclidean
    Exp
    FlattenTable
    GPU
    GatedLinearUnit
    GradientReversal
    HardShrink
    HardTanh
    HingeEmbeddingCriterion
    Identity
    Index
    IndexLinear
    Jacobian
    JoinTable
    Kmeans
    L1Cost
    L1HingeEmbeddingCriterion
    L1Penalty
    LayerNormalization
    LeakyReLU
    Linear
    LinearWeightNorm
    Log
    LogSigmoid
    LogSoftMax
    LookupTable
    MM
    MSECriterion
    MV
    MapTable
    MarginCriterion
    MarginRankingCriterion
    MaskedSelect
    Max
    Maxout
    Mean
    Min
    MixtureTable
    Module
    ModuleCriterion
    Mul
    MulConstant
    MultiCriterion
    MultiLabelMarginCriterion
    MultiLabelSoftMarginCriterion
    MultiMarginCriterion
    NaN
    Narrow
    NarrowTable
    Normalize
    OneHot
    PReLU
    Padding
    PairwiseDistance
    Parallel
    ParallelCriterion
    ParallelTable
    PartialLinear
    PixelShuffle
    Power
    PrintSize
    Profile
    RReLU
    ReLU
    ReLU6
    Replicate
    Reshape
    Select
    SelectTable
    Sequential
    Sigmoid
    SmoothL1Criterion
    SoftMarginCriterion
    SoftMax
    SoftMin
    SoftPlus
    SoftShrink
    SoftSign
    SparseJacobian
    SparseLinear
    SpatialAdaptiveAveragePooling
    SpatialAdaptiveMaxPooling
    SpatialAutoCropMSECriterion
    SpatialAveragePooling
    SpatialBatchNormalization
    SpatialClassNLLCriterion
    SpatialContrastiveNormalization
    SpatialConvolution
    SpatialConvolutionLocal
    SpatialConvolutionMM
    SpatialConvolutionMap
    SpatialCrossMapLRN
    SpatialDepthWiseConvolution
    SpatialDilatedConvolution
    SpatialDilatedMaxPooling
    SpatialDivisiveNormalization
    SpatialDropout
    SpatialFractionalMaxPooling
    SpatialFullConvolution
    SpatialFullConvolutionMap
    SpatialLPPooling
    SpatialLogSoftMax
    SpatialMaxPooling
    SpatialMaxUnpooling
    SpatialReflectionPadding
    SpatialReplicationPadding
    SpatialSoftMax
    SpatialSubSampling
    SpatialSubtractiveNormalization
    SpatialUpSamplingBilinear
    SpatialUpSamplingNearest
    SpatialZeroPadding
    SplitTable
    Sqrt
    Square
    Squeeze
    StochasticGradient
    Sum
    Tanh
    TanhShrink
    TemporalConvolution
    TemporalDynamicKMaxPooling
    TemporalMaxPooling
    TemporalRowConvolution
    TemporalSubSampling
    Threshold
    Transpose
    Unsqueeze
    View
    VolumetricAveragePooling
    VolumetricBatchNormalization
    VolumetricConvolution
    VolumetricDilatedConvolution
    VolumetricDilatedMaxPooling
    VolumetricDropout
    VolumetricFractionalMaxPooling
    VolumetricFullConvolution
    VolumetricMaxPooling
    VolumetricMaxUnpooling
    VolumetricReplicationPadding
    WeightNorm
    WeightedEuclidean
    WeightedMSECriterion
    WhiteNoise
    ZeroGrad
    ZipTable
    ZipTableOneToMany
    hessian
    tables
    test
    testTHNN
    utils])

(h/template-entries [l/tmpl-entry {:type :fragment
                                   :base "nn"
                                   :tag "lua"
                                   :shrink true}]
  +nn+)
