(ns xyz.thoren.luminary-feast-data)

(def feasts-2020
  {2020 {7 {21 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {25 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {7 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 1,
                :days-in-feast 7}],
            13 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            6 [{:name "Passover",
                :hebrew-name "Pesach",
                :day-of-feast 1,
                :days-in-feast 1}],
            12 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            23 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            11 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            9 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 3,
                :days-in-feast 7}],
            10 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            8 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 2,
                :days-in-feast 7}]},
         6 {21 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {8 [{:name "Purim",
                :hebrew-name "Purim",
                :day-of-feast 1,
                :days-in-feast 2}],
            9 [{:name "Shushan Purim",
                :hebrew-name "Shushan Purim",
                :day-of-feast 2,
                :days-in-feast 2}],
            24 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {15 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             13 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             17 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}],
             12 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             11 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             9 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 1,
                 :days-in-feast 8}],
             14 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             16 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             10 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}]},
         2 {24 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {15 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {17 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            26 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {23 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            30 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {7 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
             1 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
             4 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
             6 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
             17 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             3 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
             2 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
             5 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
             8 [{:name "The Last Great Day",
                 :hebrew-name "Shemini Atzeret",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         8 {19 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2021
  {2021 {7 {10 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {13 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {12 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            25 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            26 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            27 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            28 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            29 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            30 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}]},
         6 {10 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            19 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {13 [{:name "First day of Adar II",
                 :hebrew-name "Rosh Chodesh Adar II",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {4 [{:name "First day of Kislev",
                 :hebrew-name "Rosh Chodesh Kislev",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             28 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             29 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             30 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             31 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}]},
         2 {12 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            25 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            26 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         11 {5 [{:name "First day of Marcheshvan",
                 :hebrew-name "Rosh Chodesh Marcheshvan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         9 {7 [{:name "First day of Elul",
                :hebrew-name "Rosh Chodesh Elul",
                :day-of-feast 1,
                :days-in-feast 1}]},
         5 {1 [{:name "Feast of First Fruits",
                :hebrew-name "Yom Bikkurim",
                :day-of-feast 1,
                :days-in-feast 1}],
            2 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 7,
                :days-in-feast 7}],
            12 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {20 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             27 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             24 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             15 [{:name "Day of Atonement",
                  :hebrew-name "Yom Ha-Kippurim",
                  :alternative-hebrew-name "Yom Kippur",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             21 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             22 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             6 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             25 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             23 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             26 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}]},
         8 {8 [{:name "First day of Av",
                :hebrew-name "Rosh Chodesh Av",
                :day-of-feast 1,
                :days-in-feast 1}]}}})

(def feasts-2022
  {2022 {7 {29 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {1 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 5,
                :days-in-feast 8}],
            2 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 6,
                :days-in-feast 8}],
            3 [{:name "First day of Tevet",
                :hebrew-name "Rosh Chodesh Tevet",
                :day-of-feast 1,
                :days-in-feast 1}
               {:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 7,
                :days-in-feast 8}],
            4 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 8,
                :days-in-feast 8}]},
         4 {20 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            1 [{:name "First day of Nisan",
                :hebrew-name "Rosh Chodesh Nisan",
                :day-of-feast 1,
                :days-in-feast 1}],
            15 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            21 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            17 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            19 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            14 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            16 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            18 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}]},
         6 {4 [{:name "Feast of Weeks",
                :alternative-name "Feast of Pentecost",
                :hebrew-name "Shavuot",
                :day-of-feast 1,
                :days-in-feast 1}],
            29 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {3 [{:name "First day of Adar",
                :hebrew-name "Rosh Chodesh Adar",
                :day-of-feast 1,
                :days-in-feast 1}],
            16 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            17 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         12 {18 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             19 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             20 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             21 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             22 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             23 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             24 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             25 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {1 [{:name "First day of Shevat",
                :hebrew-name "Rosh Chodesh Shevat",
                :day-of-feast 1,
                :days-in-feast 1}]},
         11 {24 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {26 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {1 [{:name "First day of Iyar",
                :hebrew-name "Rosh Chodesh Iyar",
                :day-of-feast 1,
                :days-in-feast 1}],
            30 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {15 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             13 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             25 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             17 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             12 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             11 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             5 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             14 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             16 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             10 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}]},
         8 {27 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2023
  {2023 {7 {18 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {22 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {7 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 3,
                :days-in-feast 7}],
            20 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            4 [{:name "Passover",
                :hebrew-name "Pesach",
                :day-of-feast 1,
                :days-in-feast 1}],
            6 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 2,
                :days-in-feast 7}],
            11 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            9 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 5,
                :days-in-feast 7}],
            5 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 1,
                :days-in-feast 7}],
            10 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            8 [{:name "Feast of First Fruits",
                :hebrew-name "Yom Bikkurim",
                :day-of-feast 1,
                :days-in-feast 1}]},
         6 {18 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {5 [{:name "Purim",
                :hebrew-name "Purim",
                :day-of-feast 1,
                :days-in-feast 2}],
            6 [{:name "Shushan Purim",
                :hebrew-name "Shushan Purim",
                :day-of-feast 2,
                :days-in-feast 2}],
            22 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {7 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 1,
                 :days-in-feast 8}],
             15 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}],
             13 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             12 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             11 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             9 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 3,
                 :days-in-feast 8}],
             14 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             10 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             8 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 2,
                 :days-in-feast 8}]},
         2 {20 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {13 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {15 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            24 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            29 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            30 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}]},
         5 {19 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            27 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {1 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
             2 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
             3 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
             4 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
             5 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
             6 [{:name "The Last Great Day",
                 :hebrew-name "Shemini Atzeret",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             15 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         8 {16 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2024
  {2024 {7 {6 [{:name "First day of Tammuz",
                :hebrew-name "Rosh Chodesh Tammuz",
                :day-of-feast 1,
                :days-in-feast 1}]},
         1 {11 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {27 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            24 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            22 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            29 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            28 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            25 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            23 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            9 [{:name "First day of Nisan",
                :hebrew-name "Rosh Chodesh Nisan",
                :day-of-feast 1,
                :days-in-feast 1}],
            26 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}]},
         6 {6 [{:name "First day of Sivan",
                :hebrew-name "Rosh Chodesh Sivan",
                :day-of-feast 1,
                :days-in-feast 1}],
            15 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {10 [{:name "First day of Adar II",
                 :hebrew-name "Rosh Chodesh Adar II",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {1 [{:name "First day of Kislev",
                 :hebrew-name "Rosh Chodesh Kislev",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             25 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             26 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             27 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             28 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             29 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             30 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             31 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}]},
         2 {10 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            23 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            24 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         11 {1 [{:name "First day of Marcheshvan",
                 :hebrew-name "Rosh Chodesh Marcheshvan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         9 {3 [{:name "First day of Elul",
                :hebrew-name "Rosh Chodesh Elul",
                :day-of-feast 1,
                :days-in-feast 1}]},
         5 {8 [{:name "First day of Iyar",
                :hebrew-name "Rosh Chodesh Iyar",
                :day-of-feast 1,
                :days-in-feast 1}]},
         10 {20 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             24 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             21 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             22 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             17 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             3 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             12 [{:name "Day of Atonement",
                  :hebrew-name "Yom Ha-Kippurim",
                  :alternative-hebrew-name "Yom Kippur",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             23 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             19 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             18 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}]},
         8 {4 [{:name "First day of Av",
                :hebrew-name "Rosh Chodesh Av",
                :day-of-feast 1,
                :days-in-feast 1}]}}})

(def feasts-2025
  {2025 {7 {25 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {1 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 8,
                :days-in-feast 8}],
            29 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {15 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            13 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            28 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            17 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            12 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            11 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            14 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            16 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            18 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}]},
         6 {25 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {13 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            14 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}],
            29 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {14 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             15 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             16 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             17 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             18 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             19 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             20 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             21 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {28 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {20 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {22 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {27 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            31 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {7 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
             1 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             21 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             13 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             6 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
             12 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             11 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             9 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
             10 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             8 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}]},
         8 {23 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2026
  {2026 {7 {14 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {19 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {17 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            30 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         6 {15 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            20 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {2 [{:name "Purim",
                :hebrew-name "Purim",
                :day-of-feast 1,
                :days-in-feast 2}],
            3 [{:name "Shushan Purim",
                :hebrew-name "Shushan Purim",
                :day-of-feast 2,
                :days-in-feast 2}],
            19 [{:name "First day of Adar II",
                 :hebrew-name "Rosh Chodesh Adar II",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {9 [{:name "First day of Kislev",
                 :hebrew-name "Rosh Chodesh Kislev",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         2 {17 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {1 [{:name "The Last Great Day",
                 :hebrew-name "Shemini Atzeret",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             9 [{:name "First day of Marcheshvan",
                 :hebrew-name "Rosh Chodesh Marcheshvan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         9 {11 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {1 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 1,
                :days-in-feast 7}],
            2 [{:name "Feast of First Fruits",
                :hebrew-name "Yom Bikkurim",
                :day-of-feast 1,
                :days-in-feast 1}],
            3 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 3,
                :days-in-feast 7}],
            4 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 4,
                :days-in-feast 7}],
            5 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 5,
                :days-in-feast 7}],
            6 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 6,
                :days-in-feast 7}],
            7 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 7,
                :days-in-feast 7}],
            17 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {20 [{:name "Day of Atonement",
                  :hebrew-name "Yom Ha-Kippurim",
                  :alternative-hebrew-name "Yom Kippur",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             27 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             31 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             29 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             28 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             25 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             11 [{:name "First day of Tishrei",
                  :hebrew-name "Rosh Chodesh Tishrei",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Feast of Trumpets",
                  :hebrew-name "Yom Teruah",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             26 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             30 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}]},
         8 {13 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2027
  {2027 {7 {4 [{:name "First day of Tammuz",
                :hebrew-name "Rosh Chodesh Tammuz",
                :day-of-feast 1,
                :days-in-feast 1}]},
         1 {2 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 1,
                :days-in-feast 8}],
            3 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 2,
                :days-in-feast 8}],
            4 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 3,
                :days-in-feast 8}],
            5 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 4,
                :days-in-feast 8}],
            6 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 5,
                :days-in-feast 8}],
            7 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 6,
                :days-in-feast 8}],
            8 [{:name "First day of Tevet",
                :hebrew-name "Rosh Chodesh Tevet",
                :day-of-feast 1,
                :days-in-feast 1}
               {:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 7,
                :days-in-feast 8}],
            9 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 8,
                :days-in-feast 8}]},
         4 {7 [{:name "First day of Nisan",
                :hebrew-name "Rosh Chodesh Nisan",
                :day-of-feast 1,
                :days-in-feast 1}],
            20 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            27 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            24 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            21 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            22 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            25 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            23 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            26 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}]},
         6 {5 [{:name "First day of Sivan",
                :hebrew-name "Rosh Chodesh Sivan",
                :day-of-feast 1,
                :days-in-feast 1}],
            12 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {8 [{:name "First day of Adar",
                :hebrew-name "Rosh Chodesh Adar",
                :day-of-feast 1,
                :days-in-feast 1}],
            21 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            22 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         12 {22 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             23 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             24 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             25 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             26 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             27 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             28 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             29 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {7 [{:name "First day of Shevat",
                :hebrew-name "Rosh Chodesh Shevat",
                :day-of-feast 1,
                :days-in-feast 1}]},
         11 {28 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {1 [{:name "First day of Elul",
                :hebrew-name "Rosh Chodesh Elul",
                :day-of-feast 1,
                :days-in-feast 1}],
            30 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {6 [{:name "First day of Iyar",
                :hebrew-name "Rosh Chodesh Iyar",
                :day-of-feast 1,
                :days-in-feast 1}]},
         10 {20 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             15 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             21 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             29 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             17 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             19 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             9 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             14 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             16 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             18 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}]},
         8 {2 [{:name "First day of Av",
                :hebrew-name "Rosh Chodesh Av",
                :day-of-feast 1,
                :days-in-feast 1}]}}})

(def feasts-2028
  {2028 {7 {22 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {27 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {15 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            13 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            25 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            12 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            11 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            9 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 1,
                :days-in-feast 7}],
            14 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            10 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            8 [{:name "Passover",
                :hebrew-name "Pesach",
                :day-of-feast 1,
                :days-in-feast 1}]},
         6 {3 [{:name "Feast of Weeks",
                :alternative-name "Feast of Pentecost",
                :hebrew-name "Shavuot",
                :day-of-feast 1,
                :days-in-feast 1}],
            23 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {9 [{:name "Purim",
                :hebrew-name "Purim",
                :day-of-feast 1,
                :days-in-feast 2}],
            10 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}],
            26 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {15 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             13 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             17 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             12 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             11 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             14 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             16 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             10 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             18 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {25 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {16 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {19 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            28 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {24 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {7 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
             4 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
             6 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
             3 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
             9 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
             5 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
             10 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             18 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             8 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 6,
                 :days-in-feast 7}]},
         8 {20 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2029
  {2029 {7 {11 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {15 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {14 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            27 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            28 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            29 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            30 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}]},
         6 {12 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            16 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {15 [{:name "First day of Adar II",
                 :hebrew-name "Rosh Chodesh Adar II",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {6 [{:name "First day of Kislev",
                 :hebrew-name "Rosh Chodesh Kislev",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             30 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             31 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}]},
         2 {13 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            26 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            27 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         11 {6 [{:name "First day of Marcheshvan",
                 :hebrew-name "Rosh Chodesh Marcheshvan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         9 {8 [{:name "First day of Elul",
                :hebrew-name "Rosh Chodesh Elul",
                :day-of-feast 1,
                :days-in-feast 1}]},
         5 {1 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 4,
                :days-in-feast 7}],
            2 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 5,
                :days-in-feast 7}],
            3 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 6,
                :days-in-feast 7}],
            4 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 7,
                :days-in-feast 7}],
            13 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {27 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             24 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             22 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             29 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             28 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             25 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             17 [{:name "Day of Atonement",
                  :hebrew-name "Yom Ha-Kippurim",
                  :alternative-hebrew-name "Yom Kippur",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             23 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             26 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             8 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         8 {10 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2030
  {2030 {7 {1 [{:name "First day of Tammuz",
                :hebrew-name "Rosh Chodesh Tammuz",
                :day-of-feast 1,
                :days-in-feast 1}],
            30 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {1 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 3,
                :days-in-feast 8}],
            2 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 4,
                :days-in-feast 8}],
            3 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 5,
                :days-in-feast 8}],
            4 [{:name "First day of Tevet",
                :hebrew-name "Rosh Chodesh Tevet",
                :day-of-feast 1,
                :days-in-feast 1}
               {:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 6,
                :days-in-feast 8}],
            5 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 7,
                :days-in-feast 8}],
            6 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 8,
                :days-in-feast 8}]},
         4 {20 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            21 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            22 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            17 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            3 [{:name "First day of Nisan",
                :hebrew-name "Rosh Chodesh Nisan",
                :day-of-feast 1,
                :days-in-feast 1}],
            23 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            19 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            16 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            18 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}]},
         6 {1 [{:name "First day of Sivan",
                :hebrew-name "Rosh Chodesh Sivan",
                :day-of-feast 1,
                :days-in-feast 1}],
            8 [{:name "Feast of Weeks",
                :alternative-name "Feast of Pentecost",
                :hebrew-name "Shavuot",
                :day-of-feast 1,
                :days-in-feast 1}]},
         3 {4 [{:name "First day of Adar",
                :hebrew-name "Rosh Chodesh Adar",
                :day-of-feast 1,
                :days-in-feast 1}],
            17 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            18 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         12 {19 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             20 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             21 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             22 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             23 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             24 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             25 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             26 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {3 [{:name "First day of Shevat",
                :hebrew-name "Rosh Chodesh Shevat",
                :day-of-feast 1,
                :days-in-feast 1}]},
         11 {25 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {27 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {2 [{:name "First day of Iyar",
                :hebrew-name "Rosh Chodesh Iyar",
                :day-of-feast 1,
                :days-in-feast 1}]},
         10 {27 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             15 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             13 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             6 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             17 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             12 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             11 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             14 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             16 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             18 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         8 {29 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2031
  {2031 {7 {19 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {23 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {7 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 2,
                :days-in-feast 7}],
            22 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            6 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 1,
                :days-in-feast 7}],
            12 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            11 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            9 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 4,
                :days-in-feast 7}],
            5 [{:name "Passover",
                :hebrew-name "Pesach",
                :day-of-feast 1,
                :days-in-feast 1}],
            10 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            8 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 3,
                :days-in-feast 7}]},
         6 {20 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {7 [{:name "Purim",
                :hebrew-name "Purim",
                :day-of-feast 1,
                :days-in-feast 2}],
            8 [{:name "Shushan Purim",
                :hebrew-name "Shushan Purim",
                :day-of-feast 2,
                :days-in-feast 2}],
            23 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {9 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 1,
                 :days-in-feast 8}],
             10 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             11 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             12 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             13 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             14 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         2 {22 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {15 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {17 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            26 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {21 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            31 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {7 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
             1 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
             4 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
             6 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
             3 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
             2 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
             5 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
             16 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             8 [{:name "The Last Great Day",
                 :hebrew-name "Shemini Atzeret",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         8 {18 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2032
  {2032 {7 {7 [{:name "First day of Tammuz",
                :hebrew-name "Rosh Chodesh Tammuz",
                :day-of-feast 1,
                :days-in-feast 1}]},
         1 {13 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {27 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            24 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            29 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            28 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            25 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            23 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            26 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            30 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            10 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         6 {8 [{:name "First day of Sivan",
                :hebrew-name "Rosh Chodesh Sivan",
                :day-of-feast 1,
                :days-in-feast 1}],
            12 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {12 [{:name "First day of Adar II",
                 :hebrew-name "Rosh Chodesh Adar II",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {3 [{:name "First day of Kislev",
                 :hebrew-name "Rosh Chodesh Kislev",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             27 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             28 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             29 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             30 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             31 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}]},
         2 {11 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            24 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            25 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         11 {3 [{:name "First day of Marcheshvan",
                 :hebrew-name "Rosh Chodesh Marcheshvan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         9 {5 [{:name "First day of Elul",
                :hebrew-name "Rosh Chodesh Elul",
                :day-of-feast 1,
                :days-in-feast 1}]},
         5 {9 [{:name "First day of Iyar",
                :hebrew-name "Rosh Chodesh Iyar",
                :day-of-feast 1,
                :days-in-feast 1}]},
         10 {20 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             24 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             4 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             21 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             13 [{:name "Day of Atonement",
                  :hebrew-name "Yom Ha-Kippurim",
                  :alternative-hebrew-name "Yom Kippur",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             22 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             25 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             23 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             19 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             18 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}]},
         8 {6 [{:name "First day of Av",
                :hebrew-name "Rosh Chodesh Av",
                :day-of-feast 1,
                :days-in-feast 1}]}}})

(def feasts-2033
  {2033 {7 {26 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {1 [{:name "First day of Tevet",
                :hebrew-name "Rosh Chodesh Tevet",
                :day-of-feast 1,
                :days-in-feast 1}
               {:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 6,
                :days-in-feast 8}],
            2 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 7,
                :days-in-feast 8}],
            3 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 8,
                :days-in-feast 8}],
            31 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {20 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            15 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            13 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            29 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            17 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            19 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            14 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            16 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            18 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}]},
         6 {4 [{:name "Feast of Weeks",
                :alternative-name "Feast of Pentecost",
                :hebrew-name "Shavuot",
                :day-of-feast 1,
                :days-in-feast 1}],
            27 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {1 [{:name "First day of Adar",
                :hebrew-name "Rosh Chodesh Adar",
                :day-of-feast 1,
                :days-in-feast 1}],
            14 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            15 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}],
            31 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {16 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             17 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             18 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             19 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             20 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             21 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             22 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             23 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         11 {22 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {23 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {28 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {7 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
             13 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             12 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             2 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             23 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             11 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             9 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
             14 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             10 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             8 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}]},
         8 {25 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2034
  {2034 {7 {16 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {20 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {7 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 5,
                :days-in-feast 7}],
            4 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 2,
                :days-in-feast 7}],
            6 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 4,
                :days-in-feast 7}],
            3 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 1,
                :days-in-feast 7}],
            2 [{:name "Passover",
                :hebrew-name "Pesach",
                :day-of-feast 1,
                :days-in-feast 1}],
            19 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            9 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 7,
                :days-in-feast 7}],
            5 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 3,
                :days-in-feast 7}],
            8 [{:name "Feast of First Fruits",
                :hebrew-name "Yom Bikkurim",
                :day-of-feast 1,
                :days-in-feast 1}]},
         6 {16 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {4 [{:name "Purim",
                :hebrew-name "Purim",
                :day-of-feast 1,
                :days-in-feast 2}],
            5 [{:name "Shushan Purim",
                :hebrew-name "Shushan Purim",
                :day-of-feast 2,
                :days-in-feast 2}],
            20 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {7 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 3,
                 :days-in-feast 8}],
             13 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}],
             6 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 2,
                 :days-in-feast 8}],
             12 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             11 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             9 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 5,
                 :days-in-feast 8}],
             5 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 1,
                 :days-in-feast 8}],
             10 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             8 [{:name "Hanukkah",
                 :hebrew-name "Chanukah",
                 :day-of-feast 4,
                 :days-in-feast 8}]},
         2 {19 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {11 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {13 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            22 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            27 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            28 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            29 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            30 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}]},
         5 {18 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            27 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {1 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
             2 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
             3 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
             4 [{:name "The Last Great Day",
                 :hebrew-name "Shemini Atzeret",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             12 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         8 {14 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2035
  {2035 {7 {5 [{:name "First day of Tammuz",
                :hebrew-name "Rosh Chodesh Tammuz",
                :day-of-feast 1,
                :days-in-feast 1}]},
         1 {10 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {27 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            24 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            21 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            22 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            28 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            25 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            23 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            26 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            8 [{:name "First day of Nisan",
                :hebrew-name "Rosh Chodesh Nisan",
                :day-of-feast 1,
                :days-in-feast 1}]},
         6 {6 [{:name "First day of Sivan",
                :hebrew-name "Rosh Chodesh Sivan",
                :day-of-feast 1,
                :days-in-feast 1}],
            16 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {10 [{:name "First day of Adar II",
                 :hebrew-name "Rosh Chodesh Adar II",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {24 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             25 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             26 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             27 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             28 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             29 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             30 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             31 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {8 [{:name "First day of Adar",
                :hebrew-name "Rosh Chodesh Adar",
                :day-of-feast 1,
                :days-in-feast 1}],
            21 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            22 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         11 {30 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {2 [{:name "First day of Elul",
                :hebrew-name "Rosh Chodesh Elul",
                :day-of-feast 1,
                :days-in-feast 1}]},
         5 {8 [{:name "First day of Iyar",
                :hebrew-name "Rosh Chodesh Iyar",
                :day-of-feast 1,
                :days-in-feast 1}]},
         10 {20 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             1 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             15 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             21 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             31 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             22 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             17 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             19 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             16 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             10 [{:name "Day of Atonement",
                  :hebrew-name "Yom Ha-Kippurim",
                  :alternative-hebrew-name "Yom Kippur",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             18 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}]},
         8 {4 [{:name "First day of Av",
                :hebrew-name "Rosh Chodesh Av",
                :day-of-feast 1,
                :days-in-feast 1}]}}})

(def feasts-2036
  {2036 {7 {23 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {28 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {15 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            13 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            17 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            12 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            11 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            14 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            26 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            16 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            10 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         6 {24 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {11 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            12 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}],
            28 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {12 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             13 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             14 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             15 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             16 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             17 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             18 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             19 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {27 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {18 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {20 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            29 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {26 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            31 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {7 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
             4 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
             6 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
             19 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             11 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             9 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
             5 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
             10 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             8 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 5,
                 :days-in-feast 7}]},
         8 {22 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2037
  {2037 {7 {13 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {16 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {16 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            29 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            30 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}]},
         6 {14 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            20 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {1 [{:name "Shushan Purim",
                :hebrew-name "Shushan Purim",
                :day-of-feast 2,
                :days-in-feast 2}],
            17 [{:name "First day of Adar II",
                 :hebrew-name "Rosh Chodesh Adar II",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {7 [{:name "First day of Kislev",
                 :hebrew-name "Rosh Chodesh Kislev",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             31 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}]},
         2 {15 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            28 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}]},
         11 {7 [{:name "First day of Marcheshvan",
                 :hebrew-name "Rosh Chodesh Marcheshvan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         9 {10 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {1 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 2,
                :days-in-feast 7}],
            2 [{:name "Feast of First Fruits",
                :hebrew-name "Yom Bikkurim",
                :day-of-feast 1,
                :days-in-feast 1}],
            3 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 4,
                :days-in-feast 7}],
            4 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 5,
                :days-in-feast 7}],
            5 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 6,
                :days-in-feast 7}],
            6 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 7,
                :days-in-feast 7}],
            15 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {27 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             24 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             29 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             28 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             25 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             23 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             9 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             26 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             30 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             18 [{:name "Day of Atonement",
                  :hebrew-name "Yom Ha-Kippurim",
                  :alternative-hebrew-name "Yom Kippur",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         8 {11 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2038
  {2038 {7 {2 [{:name "First day of Tammuz",
                :hebrew-name "Rosh Chodesh Tammuz",
                :day-of-feast 1,
                :days-in-feast 1}]},
         1 {1 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 2,
                :days-in-feast 8}],
            2 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 3,
                :days-in-feast 8}],
            3 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 4,
                :days-in-feast 8}],
            4 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 5,
                :days-in-feast 8}],
            5 [{:name "First day of Tevet",
                :hebrew-name "Rosh Chodesh Tevet",
                :day-of-feast 1,
                :days-in-feast 1}
               {:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 6,
                :days-in-feast 8}],
            6 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 7,
                :days-in-feast 8}],
            7 [{:name "Hanukkah",
                :hebrew-name "Chanukah",
                :day-of-feast 8,
                :days-in-feast 8}]},
         4 {20 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
            24 [{:name "Feast of First Fruits",
                 :hebrew-name "Yom Bikkurim",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            21 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            22 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            25 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            23 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            19 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
            5 [{:name "First day of Nisan",
                :hebrew-name "Rosh Chodesh Nisan",
                :day-of-feast 1,
                :days-in-feast 1}],
            18 [{:name "Passover",
                 :hebrew-name "Pesach",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         6 {3 [{:name "First day of Sivan",
                :hebrew-name "Rosh Chodesh Sivan",
                :day-of-feast 1,
                :days-in-feast 1}],
            12 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {6 [{:name "First day of Adar",
                :hebrew-name "Rosh Chodesh Adar",
                :day-of-feast 1,
                :days-in-feast 1}],
            19 [{:name "Purim",
                 :hebrew-name "Purim",
                 :day-of-feast 1,
                 :days-in-feast 2}],
            20 [{:name "Shushan Purim",
                 :hebrew-name "Shushan Purim",
                 :day-of-feast 2,
                 :days-in-feast 2}]},
         12 {20 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             21 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             22 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             23 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             24 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             25 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             26 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             27 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {4 [{:name "First day of Shevat",
                :hebrew-name "Rosh Chodesh Shevat",
                :day-of-feast 1,
                :days-in-feast 1}]},
         11 {26 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {29 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {4 [{:name "First day of Iyar",
                :hebrew-name "Rosh Chodesh Iyar",
                :day-of-feast 1,
                :days-in-feast 1}]},
         10 {20 [{:name "The Last Great Day",
                  :hebrew-name "Shemini Atzeret",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             15 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 3,
                  :days-in-feast 7}],
             13 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 1,
                  :days-in-feast 7}],
             28 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             17 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 5,
                  :days-in-feast 7}],
             19 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 7,
                  :days-in-feast 7}],
             14 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 2,
                  :days-in-feast 7}],
             16 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 4,
                  :days-in-feast 7}],
             18 [{:name "Feast of Tabernacles",
                  :alternative-name "Feast of Booths",
                  :hebrew-name "Chag Ha-Sukkot",
                  :day-of-feast 6,
                  :days-in-feast 7}],
             8 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         8 {1 [{:name "First day of Av",
                :hebrew-name "Rosh Chodesh Av",
                :day-of-feast 1,
                :days-in-feast 1}],
            30 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})

(def feasts-2039
  {2039 {7 {21 [{:name "First day of Av",
                 :hebrew-name "Rosh Chodesh Av",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         1 {24 [{:name "First day of Shevat",
                 :hebrew-name "Rosh Chodesh Shevat",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         4 {7 [{:name "Passover",
                :hebrew-name "Pesach",
                :day-of-feast 1,
                :days-in-feast 1}],
            13 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
            12 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
            23 [{:name "First day of Iyar",
                 :hebrew-name "Rosh Chodesh Iyar",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            11 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
            9 [{:name "Feast of First Fruits",
                :hebrew-name "Yom Bikkurim",
                :day-of-feast 1,
                :days-in-feast 1}],
            14 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 7,
                 :days-in-feast 7}],
            10 [{:name "Feast of Unleavened Bread",
                 :hebrew-name "Chag Ha-Matzot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
            8 [{:name "Feast of Unleavened Bread",
                :hebrew-name "Chag Ha-Matzot",
                :day-of-feast 1,
                :days-in-feast 7}]},
         6 {22 [{:name "First day of Tammuz",
                 :hebrew-name "Rosh Chodesh Tammuz",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         3 {8 [{:name "Purim",
                :hebrew-name "Purim",
                :day-of-feast 1,
                :days-in-feast 2}],
            9 [{:name "Shushan Purim",
                :hebrew-name "Shushan Purim",
                :day-of-feast 2,
                :days-in-feast 2}],
            25 [{:name "First day of Nisan",
                 :hebrew-name "Rosh Chodesh Nisan",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         12 {15 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             13 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 4,
                  :days-in-feast 8}],
             17 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 7,
                  :days-in-feast 8}],
             12 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 3,
                  :days-in-feast 8}],
             11 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 2,
                  :days-in-feast 8}],
             14 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 5,
                  :days-in-feast 8}],
             16 [{:name "First day of Tevet",
                  :hebrew-name "Rosh Chodesh Tevet",
                  :day-of-feast 1,
                  :days-in-feast 1}
                 {:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 6,
                  :days-in-feast 8}],
             10 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 1,
                  :days-in-feast 8}],
             18 [{:name "Hanukkah",
                  :hebrew-name "Chanukah",
                  :day-of-feast 8,
                  :days-in-feast 8}]},
         2 {23 [{:name "First day of Adar",
                 :hebrew-name "Rosh Chodesh Adar",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         11 {16 [{:name "First day of Kislev",
                  :hebrew-name "Rosh Chodesh Kislev",
                  :day-of-feast 1,
                  :days-in-feast 1}]},
         9 {18 [{:name "First day of Tishrei",
                 :hebrew-name "Rosh Chodesh Tishrei",
                 :day-of-feast 1,
                 :days-in-feast 1}
                {:name "Feast of Trumpets",
                 :hebrew-name "Yom Teruah",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            27 [{:name "Day of Atonement",
                 :hebrew-name "Yom Ha-Kippurim",
                 :alternative-hebrew-name "Yom Kippur",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         5 {23 [{:name "First day of Sivan",
                 :hebrew-name "Rosh Chodesh Sivan",
                 :day-of-feast 1,
                 :days-in-feast 1}],
            28 [{:name "Feast of Weeks",
                 :alternative-name "Feast of Pentecost",
                 :hebrew-name "Shavuot",
                 :day-of-feast 1,
                 :days-in-feast 1}]},
         10 {7 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 6,
                 :days-in-feast 7}],
             4 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 3,
                 :days-in-feast 7}],
             6 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 5,
                 :days-in-feast 7}],
             3 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 2,
                 :days-in-feast 7}],
             2 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 1,
                 :days-in-feast 7}],
             9 [{:name "The Last Great Day",
                 :hebrew-name "Shemini Atzeret",
                 :day-of-feast 1,
                 :days-in-feast 1}],
             5 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 4,
                 :days-in-feast 7}],
             18 [{:name "First day of Marcheshvan",
                  :hebrew-name "Rosh Chodesh Marcheshvan",
                  :day-of-feast 1,
                  :days-in-feast 1}],
             8 [{:name "Feast of Tabernacles",
                 :alternative-name "Feast of Booths",
                 :hebrew-name "Chag Ha-Sukkot",
                 :day-of-feast 7,
                 :days-in-feast 7}]},
         8 {20 [{:name "First day of Elul",
                 :hebrew-name "Rosh Chodesh Elul",
                 :day-of-feast 1,
                 :days-in-feast 1}]}}})
