(defproject xafizoff/auto-complete "0.1.0-SNAPSHOT"
  :description "Simple text auto completion libary"
  :url "https://github.com/xafizoff/auto-complete"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.9.946"]
                 [org.clojure/core.async "0.2.395" :exclusions [org.clojure/tools.reader]]
                 [cljs-http "0.1.44"]]

  :source-paths ["src/cljs"]
  :resource-paths []
  :clean-targets ^{:protect false} ["target" "resources/public/js/out"]

  :profiles
  {:dev
   {
    :source-paths   ["src/clj"]
    :resource-paths ["resources"]
    :dependencies   [[ring "1.5.1"]
                     [ring/ring-defaults "0.2.1"]
                     [compojure "1.5.0"]]
    :plugins        [[lein-figwheel "0.5.14"]
                     [lein-cljsbuild "1.1.5"]]}

   }

  :figwheel {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]
             :http-server-root "public"
             :server-port      3000
             :ring-handler     xafizoff.ac.server/dev-app
             :css-dirs         ["resources/public/css"]
             }

  :cljsbuild
  {:builds [
            {:id           "dev"
             :source-paths ["src/cljs"]
             :figwheel     true
             :compiler     {:main          xafizoff.ac
                            :output-to     "resources/public/js/out/autocomplete.js"
                            :output-dir    "resources/public/js/out/xac.out"
                            :optimizations :none
                            :pretty-print  true
                            :source-map    true
                            :asset-path    "js/out/xac.out"}}
            {:id           "prod"
             :source-paths ["src/cljs"]
             :compiler     {:output-to      "resources/public/js/out/autocomplete.js"
                            :optimizations  :advanced
                            :compiler-stats true}}
            ]}
  :aliases
  {"run"    ["with-profile" "dev" "figwheel"]
   "build"  ["do" ["clean"] ["cljsbuild" "once" "prod"]]
   "deploy" ["do" ["clean"] "jar" ["deploy" "clojars"]]}
  )
