Simple text auto completion library written in ClojureScript using `goog.ui.ac.AutoComplete`

[![Clojars Project](https://img.shields.io/clojars/v/xafizoff/auto-complete.svg)](https://clojars.org/xafizoff/auto-complete)

## Usage

### ClojureScript

```clojure
(require '[xafizoff.ac :as ac])

(ac/wrap (js/document.getElementById "my-input") ["my" "suggestion" "list"])
```

### JavaScript

```html
<script src="autocomplete.js" type="application/javascript"></script> 
<script>
    xafizoff.ac.wrap(document.getElementById('my-input'), ['my', 'suggestion', 'list']);
</script>
```

Signature:
```
wrap(input, suggestion_source);
wrap(input, suggestion_area, suggestion_source);
```
where 
* `input` -- `<input type=text>` or `<textarea>`
* `suggestion_area` -- element to hold popup elements
* `suggestion_source` -- source for the suggestions

### Suggestion sources



Currently supported suggestion sources:

* JavaScript arrays and ClojureScript vectors. You can simply pass an array or vector (in cljs).
Matching by prefix.
* Functions with signature: `function(token, max_matches)` which must return an array (or vector)
of strings, matching to `token`.
* Strings mean URL of the remote resource. In this case ajax request will be sent to this URL 
with following parameters: `token` -- token to filter items and `size` -- expected max number
of items in the result. Expecting json array with strings in the response body.
* Sources also can be described with JavaScript objects or ClojureScript maps with following keys:
    * url -- URL of the remote resource (required).
    * mappings -- mapping for the `token` and `size` parameter names. Defaults to "token" and "size".
    * to map/parse response body to the array of strings, add function under the key `parser` to the
    object. This function should take response body as a single argument and m
    ust return array of matching tokens.
    * rest of the key-value pairs are sent as is as the request parameters. 
* In addition, in ClojureScript you can extend type with protocol `xafizoff.ac.IMatcher` 
or implement this protocol and use this type as a suggestion source.


## License

Copyright  2018 Marat Khafizov

Distributed under the Eclipse Public License version 1.0
