(ns xafizoff.ac.util
  (:require [clojure.data :as d]))

(defn diff [curr prev]
  (let [[curr-front prev-front common-front]
        (d/diff (seq curr) (seq prev))
        [curr-back prev-back common-back]
        (d/diff (reverse curr-front) (reverse prev-front))
        not-nil? (complement nil?)
        fmt-f #(->> %
                    (filter not-nil?)
                    (apply str))
        fmt #(->> %
                  (filter not-nil?)
                  reverse
                  (apply str))]
    [(fmt-f common-front)
     (fmt common-back)
     (fmt curr-back)
     (fmt prev-back)]
    ))