(ns works-hub.pachyderm.coupons
  (:refer-clojure :exclude [list update])
  (:require [works-hub.pachyderm.transforms :as trs]
            [works-hub.pachyderm.util :refer (map->request-options map->str-ks)])
  (:import [clojure.lang IPersistentMap IPersistentStack]
           [com.stripe.model Coupon]))

(defn create
  ([^IPersistentMap attrs]
   (create attrs nil))
  ([^IPersistentMap attrs ^IPersistentMap ro-opts]
   (trs/coupon->map
    (Coupon/create (map->str-ks attrs)
                   (map->request-options ro-opts)))))

(defn retrieve
  ([^String id]
   (retrieve id nil))
  ([^String id ^IPersistentMap ro-opts]
   (trs/coupon->map
    (Coupon/retrieve id
                     (map->request-options ro-opts)))))

(defn list
  ([]
   (list {}))
  ([^IPersistentMap attrs]
   (list attrs nil))
  ([^IPersistentMap attrs ^IPersistentMap ro-opts]
   (trs/coupons-coll->seq
    (Coupon/list
     (map->str-ks attrs)
     (map->request-options ro-opts)))))
