/*
 * Decompiled with CFR 0.152.
 */
package net.soqul.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import net.soqul.Soqul;
import net.soqul.TRepository;
import net.soqul.annotation.InitateEntity;
import net.soqul.annotation.field.Hashing;
import net.soqul.annotation.field.InitateColumn;
import net.soqul.annotation.field.RetentionDefault;
import net.soqul.annotation.field.RetentionFilled;
import net.soqul.annotation.field.RetentionPrimary;
import net.soqul.cache.ResponseCache;
import net.soqul.impl.SoqulDto;
import net.soqul.impl.SoqulField;
import net.soqul.impl.TRepositoryImpl;
import net.soqul.log.Log;
import net.soqul.sql.ColumnType;
import net.soqul.sql.Executor;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;

public class SoqulImpl
implements Soqul {
    private boolean debug = false;
    private final Log log = new Log("Soqul");
    private final Map<String, SoqulDto> scannedClasses = new LinkedHashMap<String, SoqulDto>();

    @Override
    public void scanPackage(@NonNull String packageName) {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked non-null but is null");
        }
        this.log.info("Try scan %s package", packageName);
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage(packageName, new ClassLoader[0]).setScanners(new Scanner[]{Scanners.Resources, Scanners.TypesAnnotated}));
        reflections.getTypesAnnotatedWith(InitateEntity.class).forEach(this::scanClass);
        this.log.info("Success scanned %s package", packageName);
    }

    @Override
    public void scanClass(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.log.info("Try scan %s class", clazz.getName());
        InitateEntity initateEntity = clazz.getDeclaredAnnotation(InitateEntity.class);
        AtomicBoolean hasEmptyConstructor = new AtomicBoolean(false);
        Arrays.stream(clazz.getConstructors()).forEach(constructor -> {
            if (constructor.getParameterCount() == 0) {
                hasEmptyConstructor.set(true);
            }
        });
        if (!hasEmptyConstructor.get()) {
            this.log.warn("Failed to register class %s because it does not have empty constructor", clazz.getName());
            return;
        }
        if (initateEntity != null) {
            SoqulDto dtoClassData = new SoqulDto(clazz, null, new ArrayList<SoqulField>());
            Arrays.stream(clazz.getDeclaredFields()).forEach(f -> {
                InitateColumn annotation = f.getAnnotation(InitateColumn.class);
                if (annotation != null) {
                    RetentionDefault retentionDefault = f.getAnnotation(RetentionDefault.class);
                    dtoClassData.registerField(new SoqulField(ColumnType.getFromField(f), f.getAnnotation(RetentionFilled.class) != null, f.getAnnotation(RetentionPrimary.class) != null, retentionDefault != null ? retentionDefault.value() : null, f.getName(), f.getAnnotation(Hashing.class) != null, annotation));
                }
            });
            if (dtoClassData.getKeyField() == null) {
                this.log.warn("Failed to register class %s because it does not have a field marked as @PrimaryKey", clazz.getName());
                return;
            }
            this.scannedClasses.put(clazz.getName(), dtoClassData);
            this.log.info("The %s class was successfully scanned and saved!", clazz.getName());
        }
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public <T> TRepository<T> createRepository(@NonNull Class<T> clazz, @NonNull String tableName, @NonNull Connection connection, ResponseCache<T> cache) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (!this.scannedClasses.containsKey(clazz.getName())) {
            this.log.warn("Class %s is not scanned, scan now..", clazz.getName());
            this.scanClass(clazz);
        }
        try {
            String sql = this.scannedClasses.get(clazz.getName()).getCreateQuery(tableName);
            this.log.info(" SQL: %s", sql);
            connection.createStatement().execute(sql);
        }
        catch (Exception exception) {
            this.log.warn("The table could not be created.", new Object[0]);
        }
        return new TRepositoryImpl<T>(tableName, Executor.getExecutor(connection, this.debug), cache, this.scannedClasses.get(clazz.getName()));
    }
}

