/*
 * Decompiled with CFR 0.152.
 */
package net.soqul.cache.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import net.soqul.cache.CachedObject;
import net.soqul.cache.ResponseCache;
import net.soqul.sql.Executor;

public class LocalResponseCache<T>
implements ResponseCache {
    private final long aliveTime;
    private Map<String, CachedObject<T>> cachedObjectMap = new HashMap<String, CachedObject<T>>();

    public CachedObject<T> getOrCreateCached(@NonNull String query, @NonNull Executor executor, @NonNull Function createFunction) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (createFunction == null) {
            throw new NullPointerException("createFunction is marked non-null but is null");
        }
        CachedObject<Object> object = this.cachedObjectMap.get(query);
        if (object != null && System.currentTimeMillis() - object.getCachedMills() >= this.aliveTime || object == null) {
            this.cachedObjectMap.remove(query);
            object = new CachedObject(System.currentTimeMillis(), createFunction.apply(executor));
            this.cachedObjectMap.put(query, object);
        }
        return object;
    }

    public void upCache(@NonNull String query, Object o) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.cachedObjectMap.put(query, (CachedObject)o);
    }

    public LocalResponseCache(long aliveTime) {
        this.aliveTime = aliveTime;
    }
}

