/*
 * Decompiled with CFR 0.152.
 */
package net.soqul.sql;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import lombok.NonNull;

public class Statement
implements Closeable {
    private final PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public Statement(@NonNull Connection connection, @NonNull String sqlQuery, Object ... queryElements) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (sqlQuery == null) {
            throw new NullPointerException("sqlQuery is marked non-null but is null");
        }
        if (queryElements == null) {
            throw new NullPointerException("queryElements is marked non-null but is null");
        }
        this.preparedStatement = connection.prepareStatement(sqlQuery);
        if (queryElements != null && queryElements.length != 0) {
            for (int i = 0; i < queryElements.length; ++i) {
                this.preparedStatement.setObject(i + 1, queryElements[i]);
            }
        }
    }

    public void execute() throws SQLException {
        this.preparedStatement.execute();
    }

    public ResultSet getResultSet() throws SQLException {
        this.resultSet = this.preparedStatement.executeQuery();
        return this.resultSet;
    }

    @Override
    public void close() {
        try {
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            if (this.preparedStatement != null && !this.preparedStatement.isClosed()) {
                this.preparedStatement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }
}

