/*
 * Decompiled with CFR 0.152.
 */
package net.soqul.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.soqul.log.Log;
import net.soqul.sql.ResponseHandler;
import net.soqul.sql.Statement;

public class Executor {
    private static final Log log = new Log("SqlManager");
    private final boolean debug;
    private final Connection connection;

    public static Executor getExecutor(Connection connection, boolean debug) {
        return new Executor(debug, connection);
    }

    public void execute(boolean async, String sql, Object ... elements) {
        log.info("NEW REQUEST: " + sql);
        Runnable command = () -> {
            try {
                if (this.connection.isClosed()) {
                    return;
                }
                Statement statement = new Statement(this.connection, sql, elements);
                statement.execute();
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        };
        if (async) {
            CompletableFuture.runAsync(command);
            return;
        }
        command.run();
    }

    public <T> T executeQuery(boolean async, String sql, ResponseHandler<T, ResultSet, SQLException> handler) {
        log.info("NEW REQUEST: " + sql);
        AtomicReference result = new AtomicReference();
        Runnable command = () -> {
            try {
                if (this.connection.isClosed()) {
                    return;
                }
                Statement statement = new Statement(this.connection, sql, new Object[0]);
                result.set(handler.handleResponse(statement.getResultSet()));
                statement.close();
            }
            catch (IllegalAccessException | NoSuchFieldException | SQLException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        };
        if (async) {
            CompletableFuture.runAsync(command);
            return null;
        }
        command.run();
        return (T)result.get();
    }

    public Executor(boolean debug, Connection connection) {
        this.debug = debug;
        this.connection = connection;
    }
}

