/*
 * Decompiled with CFR 0.152.
 */
package net.soqul.impl;

import java.util.List;
import lombok.NonNull;
import net.soqul.impl.SoqulField;

public class SoqulDto {
    private Class<?> clazz;
    private SoqulField keyField;
    private List<SoqulField> fields;

    protected void registerField(@NonNull SoqulField field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (field.isPrimaryKey()) {
            this.keyField = field;
        }
        this.fields.add(field);
    }

    public String getCreateQuery(@NonNull String table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (SoqulField field : this.fields) {
            builder.append(field.toString() + (++i >= this.fields.size() ? "" : ", "));
        }
        return String.format("CREATE TABLE IF NOT EXISTS `%s` (%s)", table, builder);
    }

    Class<?> getClazz() {
        return this.clazz;
    }

    SoqulField getKeyField() {
        return this.keyField;
    }

    List<SoqulField> getFields() {
        return this.fields;
    }

    void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    void setKeyField(SoqulField keyField) {
        this.keyField = keyField;
    }

    void setFields(List<SoqulField> fields) {
        this.fields = fields;
    }

    SoqulDto(Class<?> clazz, SoqulField keyField, List<SoqulField> fields) {
        this.clazz = clazz;
        this.keyField = keyField;
        this.fields = fields;
    }
}

