/*
 * Decompiled with CFR 0.152.
 */
package net.lithe.automatic;

import lombok.NonNull;
import net.lithe.automatic.AccessingAllClassesInPackage;
import net.lithe.injectior.Component;
import net.lithe.injectior.Injector;
import net.lithe.injectior.implementation.RealInjector;

public class GeneratedInjectorFactory {
    public static Injector createInjector(@NonNull Class<?> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        RealInjector injector = new RealInjector();
        for (Class someClass : AccessingAllClassesInPackage.findAllClassesUsingClassLoader(c.getPackageName())) {
            Component component = someClass.getAnnotation(Component.class);
            if (component == null) continue;
            switch (component.score()) {
                case SINGLETON: {
                    try {
                        injector.getSingletonMap().put(someClass, someClass.newInstance());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case PROTOTYPE: {
                    injector.getPrototypeMap().put(someClass, someClass);
                }
            }
        }
        return injector;
    }
}

