/*
 * Decompiled with CFR 0.152.
 */
package net.jest.implementation.request;

import com.sun.net.httpserver.HttpExchange;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.jest.api.RequestSource;
import sun.net.www.ParseUtil;

public class RealRequestSource
implements RequestSource {
    private Map<Object, List<Object>> parameters;
    private HttpExchange exchange;

    @Override
    public <T> T parseParameter(@NonNull Class<T> parameterClass, @NonNull String parameterName) {
        if (parameterClass == null) {
            throw new NullPointerException("parameterClass is marked non-null but is null");
        }
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        try {
            if (parameterClass.equals(Integer.TYPE) || parameterClass.equals(Long.TYPE) || parameterClass.equals(Short.TYPE)) {
                return (T)Integer.valueOf(Integer.parseInt(this.parameters.get(parameterName).get(0).toString()));
            }
            if (parameterClass.isAssignableFrom(Collection.class)) {
                return (T)this.parameters.get(parameterName);
            }
            return (T)this.parameters.get(parameterName).stream().findFirst().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getHeader(@NonNull String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        return this.exchange.getRequestHeaders().getFirst(parameterName);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.exchange.getRemoteAddress();
    }

    @Override
    public HttpExchange getHandle() {
        return this.exchange;
    }

    @Override
    public boolean containsParameter(@NonNull String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        return this.parameters.containsKey(parameterName);
    }

    @Override
    public String getParameter(@NonNull String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        return Objects.requireNonNull(this.parameters.get(parameterName).stream().findFirst().orElse(null)).toString();
    }

    public static RealRequestSource fromExchange(HttpExchange exchange) {
        String query = exchange.getRequestURI().getRawQuery();
        if (query == null || "".equals(query) || "null".equals(query)) {
            return new RealRequestSource(Collections.emptyMap(), exchange);
        }
        return new RealRequestSource(Pattern.compile("&").splitAsStream(query).map(s -> Arrays.copyOf(s.split("="), 2)).collect(Collectors.groupingBy(s -> ParseUtil.decode(s[0]), Collectors.mapping(s -> ParseUtil.decode(s[1]), Collectors.toList()))), exchange);
    }

    public Map<Object, List<Object>> getParameters() {
        return this.parameters;
    }

    public HttpExchange getExchange() {
        return this.exchange;
    }

    public RealRequestSource(Map<Object, List<Object>> parameters, HttpExchange exchange) {
        this.parameters = parameters;
        this.exchange = exchange;
    }
}

