/*
 * Decompiled with CFR 0.152.
 */
package net.jest.reflect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.jest.api.Authorization;
import net.jest.api.Controller;
import net.jest.api.Method;
import net.jest.api.RepeatableParameterAnnotation;
import net.jest.api.RequestSource;
import net.jest.api.response.Response;
import net.jest.api.util.ResponseUtil;
import net.jest.implementation.request.RealRequestSource;
import net.jest.util.CacheUtil;

public final class MethodParser {
    public static String getName(@NonNull Controller controller, @NonNull java.lang.reflect.Method method) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        Method annotation = method.getDeclaredAnnotation(Method.class);
        if (annotation == null) {
            return null;
        }
        String path = controller.path() + annotation.name();
        return path;
    }

    public static Function<RealRequestSource, Response> parse(@NonNull Controller controller, @NonNull Object instance, @NonNull java.lang.reflect.Method method) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        String path = MethodParser.getName(controller, method);
        if (path == null) {
            return null;
        }
        ArrayList wannableParameters = new ArrayList();
        RepeatableParameterAnnotation annotation = method.getDeclaredAnnotation(RepeatableParameterAnnotation.class);
        if (annotation != null) {
            wannableParameters.addAll(Arrays.stream(annotation.value()).map(param -> param.value()).collect(Collectors.toList()));
        }
        Authorization auth = method.getDeclaredAnnotation(Authorization.class);
        if (method.getParameterCount() > 1) {
            throw new IllegalArgumentException("Bad method! Please read documentation!");
        }
        boolean empty = method.getParameterCount() == 0;
        return request -> {
            if (auth != null && CacheUtil.putIfAbsent(auth.value()) != null && !CacheUtil.putIfAbsent(auth.value()).isAuthorized(request.getExchange(), (RequestSource)request)) {
                return ResponseUtil.createResponse(401, "Cant authorize your request. Please read api documentation. (The message is generated by the Jest framework)");
            }
            if (wannableParameters.size() > request.getParameters().size()) {
                return ResponseUtil.createResponse(400, "You have not specified enough parameters. Read the documentation. (The message is generated by the Jest framework)");
            }
            AtomicReference<Object> response = new AtomicReference<Object>(null);
            wannableParameters.forEach(name -> {
                try {
                    if (!request.containsParameter((String)name)) {
                        response.set(ResponseUtil.createResponse(400, "The " + name + " argument was not found. (The message is generated by the Jest framework)"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    response.set(ResponseUtil.createResponse(500, "Internal server error during process request. (The message is generated by the Jest framework)"));
                }
            });
            if (response.get() != null) {
                return response.get();
            }
            try {
                if (method.getReturnType().isAssignableFrom(Response.class) || method.getReturnType().equals(Response.class)) {
                    return (Response)(empty ? method.invoke(instance, new Object[0]) : method.invoke(instance, request));
                }
                return ResponseUtil.createResponse(200, empty ? method.invoke(instance, new Object[0]) : method.invoke(instance, request));
            }
            catch (Exception e) {
                e.printStackTrace();
                return ResponseUtil.createResponse(500, "Internal server error during method invoke. (The message is generated by the Jest framework)");
            }
        };
    }

    private MethodParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

