/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.bukkitlib.util;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;

public final class LocationUtil {
    public static final BlockFace[] axis = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    public static final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};

    public static String locationToString(Location location) {
        if (location == null) {
            return null;
        }
        return String.format("%s, %s, %s, %s, %s, %s", location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    public static Location stringToLocation(String locString) {
        if (locString == null) {
            return null;
        }
        String[] locData = locString.split(", ");
        World world = Bukkit.getWorld((String)locData[0]);
        Objects.requireNonNull(world, "world is null");
        return new Location(world, Double.parseDouble(locData[1]), Double.parseDouble(locData[2]), Double.parseDouble(locData[3]), Float.parseFloat(locData[4]), Float.parseFloat(locData[5]));
    }

    public static boolean isDistance(Location location1, Location location2, double distance) {
        return location1.distance(location2) <= distance;
    }

    public static BlockFace yawToFace(float yaw) {
        return LocationUtil.yawToFace(yaw, true);
    }

    public static BlockFace yawToFace(float yaw, boolean useSubCardinalDirections) {
        if (useSubCardinalDirections) {
            return radial[Math.round(yaw / 45.0f) & 7];
        }
        return axis[Math.round(yaw / 90.0f) & 3];
    }

    private LocationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

