/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.bukkitlib.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class ItemFactory {
    public static ItemFactoryProperties createProperties(@NonNull Material material) {
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        return new ItemFactoryProperties(new ItemStack(material));
    }

    private ItemFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ItemFactoryProperties {
        private final ItemStack itemStack;

        public ItemFactoryProperties setDurability(int durability) {
            this.itemStack.setDurability((short)((byte)durability));
            return this;
        }

        public ItemFactoryProperties setUnbreakable(boolean flag) {
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.spigot().setUnbreakable(flag);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemFactoryProperties setMaterial(@NonNull Material material) {
            if (material == null) {
                throw new NullPointerException("material is marked non-null but is null");
            }
            this.itemStack.setType(material);
            return this;
        }

        public ItemFactoryProperties setAmount(int amount) {
            this.itemStack.setAmount(amount);
            return this;
        }

        public ItemFactoryProperties setName(String name) {
            if (name == null) {
                return this;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setDisplayName(name);
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemFactoryProperties setLore(String ... loreArray) {
            if (loreArray == null) {
                return this;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setLore(Arrays.asList(loreArray));
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemFactoryProperties setLore(List<String> loreList) {
            if (loreList == null) {
                return this;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setLore(loreList);
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemFactoryProperties addLore(@NonNull String lore) {
            if (lore == null) {
                throw new NullPointerException("lore is marked non-null but is null");
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            ArrayList<String> loreList = itemMeta.getLore();
            if (loreList == null) {
                loreList = new ArrayList<String>();
            }
            loreList.add(lore);
            return this.setLore(loreList);
        }

        public ItemFactoryProperties addLoreArray(String ... loreArray) {
            if (loreArray == null) {
                throw new NullPointerException("loreArray is marked non-null but is null");
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            ArrayList<String> loreList = itemMeta.getLore();
            if (loreList == null) {
                loreList = new ArrayList<String>();
            }
            loreList.addAll(Arrays.asList(loreArray));
            return this.setLore(loreList);
        }

        public ItemFactoryProperties setGlowing(boolean glowing) {
            Enchantment glowEnchantment = Enchantment.ARROW_DAMAGE;
            if (glowing) {
                this.addItemFlag(ItemFlag.HIDE_ENCHANTS);
                this.addEnchantment(glowEnchantment, 1);
            } else {
                this.removeItemFlag(ItemFlag.HIDE_ENCHANTS);
                this.removeEnchantment(glowEnchantment);
            }
            return this;
        }

        public ItemFactoryProperties addEnchantment(Enchantment enchantment, int level) {
            if (enchantment == null) {
                return this;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.addEnchant(enchantment, level, true);
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemFactoryProperties removeEnchantment(Enchantment enchantment) {
            if (enchantment == null) {
                return this;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            if (!itemMeta.hasEnchant(enchantment) || itemMeta.hasConflictingEnchant(enchantment)) {
                return this;
            }
            itemMeta.removeEnchant(enchantment);
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemFactoryProperties addCustomPotionEffect(PotionEffect potionEffect, boolean isAdd) {
            if (potionEffect == null) {
                return this;
            }
            PotionMeta potionMeta = (PotionMeta)this.itemStack.getItemMeta();
            potionMeta.addCustomEffect(potionEffect, isAdd);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
            return this;
        }

        public ItemFactoryProperties setMainPotionEffect(PotionEffectType potionEffectType) {
            if (potionEffectType == null) {
                return this;
            }
            PotionMeta potionMeta = (PotionMeta)this.itemStack.getItemMeta();
            potionMeta.setMainEffect(potionEffectType);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
            return this;
        }

        public ItemFactoryProperties setPotionColor(Color color) {
            if (color == null) {
                return this;
            }
            PotionMeta potionMeta = (PotionMeta)this.itemStack.getItemMeta();
            potionMeta.setColor(color);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
            return this;
        }

        public ItemFactoryProperties setPlayerSkull(String playerSkull) {
            if (playerSkull == null) {
                return this;
            }
            SkullMeta skullMeta = (SkullMeta)this.itemStack.getItemMeta();
            skullMeta.setOwner(playerSkull);
            this.itemStack.setItemMeta((ItemMeta)skullMeta);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ItemFactoryProperties setTextureValue(String texture) {
            if (texture == null) {
                return this;
            }
            SkullMeta skullMeta = (SkullMeta)this.itemStack.getItemMeta();
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "ItzStonlex");
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            Field f = null;
            Class<?> clazz = skullMeta.getClass();
            try {
                f = clazz.getDeclaredField("profile");
                f.setAccessible(true);
                f.set(skullMeta, gameProfile);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            finally {
                f.setAccessible(false);
            }
            this.itemStack.setItemMeta((ItemMeta)skullMeta);
            return this;
        }

        public ItemFactoryProperties setLeatherColor(Color color) {
            if (color == null) {
                return this;
            }
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.itemStack.getItemMeta();
            leatherArmorMeta.setColor(color);
            this.itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
            return this;
        }

        public ItemFactoryProperties addItemFlag(ItemFlag itemFlag) {
            if (itemFlag == null) {
                return this;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemFactoryProperties removeItemFlag(ItemFlag itemFlag) {
            if (itemFlag == null) {
                return this;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            if (!itemMeta.hasItemFlag(itemFlag)) {
                return this;
            }
            itemMeta.removeItemFlags(new ItemFlag[]{itemFlag});
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemStack createItem() {
            return this.itemStack;
        }

        public ItemFactoryProperties(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }
}

