/** The provided code is written by Tim Cooper:   tim@edval.com.au
This code is available under the MIT licence:  https://opensource.org/licenses/MIT  */
package com.skedgo.converter;

public class TimezoneMapper {

    public static String latLngToTimezoneString(double lat, double lng)
    {
        String tzId = timezoneStrings[getTzInt((float) lat, (float) lng)];
        return tzId;
    }

    static String[] timezoneStrings = {
            "unknown",
            "America/Dominica",
            "America/St_Vincent",
            "Australia/Lord_Howe",
            "Asia/Kashgar",
            "Pacific/Wallis",
            "Europe/Berlin",
            "America/Manaus",
            "Asia/Jerusalem",
            "America/Phoenix",
            "Australia/Darwin",
            "Asia/Seoul",
            "Africa/Gaborone",
            "Indian/Chagos",
            "America/Argentina/Mendoza",
            "Asia/Hong_Kong",
            "America/Godthab",
            "Africa/Dar_es_Salaam",
            "Pacific/Majuro",
            "America/Port-au-Prince",
            "America/Montreal",
            "Atlantic/Reykjavik",
            "America/Panama",
            "America/Sitka",
            "Asia/Ho_Chi_Minh",
            "America/Danmarkshavn",
            "Asia/Jakarta",
            "America/Boise",
            "Asia/Baghdad",
            "Africa/El_Aaiun",
            "Europe/Zagreb",
            "America/Santiago",
            "America/Merida",
            "Africa/Nouakchott",
            "America/Bahia_Banderas",
            "Australia/Perth",
            "Asia/Sakhalin",
            "Asia/Vladivostok",
            "Africa/Bissau",
            "America/Los_Angeles",
            "Asia/Rangoon",
            "America/Belize",
            "Asia/Harbin",
            "Australia/Currie",
            "Pacific/Pago_Pago",
            "America/Vancouver",
            "Asia/Magadan",
            "Asia/Tbilisi",
            "Asia/Yerevan",
            "Europe/Tallinn",
            "Pacific/Johnston",
            "Asia/Baku",
            "America/North_Dakota/New_Salem",
            "Europe/Vilnius",
            "America/Indiana/Petersburg",
            "Asia/Tehran",
            "America/Inuvik",
            "Europe/Lisbon",
            "Europe/Vatican",
            "Pacific/Chatham",
            "Antarctica/Macquarie",
            "America/Araguaina",
            "Asia/Thimphu",
            "Atlantic/Madeira",
            "America/Coral_Harbour",
            "Pacific/Funafuti",
            "Indian/Mahe",
            "Australia/Adelaide",
            "Africa/Freetown",
            "Atlantic/South_Georgia",
            "Africa/Accra",
            "America/North_Dakota/Beulah",
            "America/Jamaica",
            "America/Scoresbysund",
            "America/Swift_Current",
            "Europe/Tirane",
            "Asia/Ashgabat",
            "America/Moncton",
            "Europe/Vaduz",
            "Australia/Eucla",
            "America/Montserrat",
            "America/Glace_Bay",
            "Atlantic/Stanley",
            "Africa/Bujumbura",
            "Africa/Porto-Novo",
            "America/Argentina/Rio_Gallegos",
            "America/Grenada",
            "Asia/Novokuznetsk",
            "America/Argentina/Catamarca",
            "America/Indiana/Indianapolis",
            "America/Indiana/Tell_City",
            "America/Curacao",
            "America/Miquelon",
            "America/Detroit",
            "America/Menominee",
            "Asia/Novosibirsk",
            "Africa/Lagos",
            "Indian/Cocos",
            "America/Yakutat",
            "Europe/Volgograd",
            "Asia/Qatar",
            "Indian/Antananarivo",
            "Pacific/Marquesas",
            "America/Grand_Turk",
            "Asia/Khandyga",
            "America/North_Dakota/Center",
            "Pacific/Guam",
            "Pacific/Pitcairn",
            "America/Cambridge_Bay",
            "Asia/Bahrain",
            "America/Kentucky/Monticello",
            "Arctic/Longyearbyen",
            "Africa/Cairo",
            "Australia/Hobart",
            "Pacific/Galapagos",
            "Asia/Oral",
            "America/Dawson_Creek",
            "Africa/Mbabane",
            "America/Halifax",
            "Pacific/Tongatapu",
            "Asia/Aqtau",
            "Asia/Hovd",
            "Africa/Nairobi",
            "Asia/Ulaanbaatar",
            "Indian/Christmas",
            "Asia/Taipei",
            "Australia/Melbourne",
            "America/Argentina/Salta",
            "Australia/Broken_Hill",
            "America/Argentina/Tucuman",
            "America/Kentucky/Louisville",
            "Asia/Jayapura",
            "Asia/Macau",
            "America/Ojinaga",
            "America/Nome",
            "Pacific/Wake",
            "Europe/Andorra",
            "America/Iqaluit",
            "America/Kralendijk",
            "Europe/Jersey",
            "Asia/Ust-Nera",
            "Asia/Yakutsk",
            "America/Yellowknife",
            "America/Fortaleza",
            "Asia/Irkutsk",
            "America/Tegucigalpa",
            "Europe/Zaporozhye",
            "Pacific/Fiji",
            "Pacific/Tarawa",
            "Africa/Asmara",
            "Asia/Dhaka",
            "Asia/Pyongyang",
            "Europe/Athens",
            "America/Resolute",
            "Africa/Brazzaville",
            "Africa/Libreville",
            "Atlantic/St_Helena",
            "Europe/Samara",
            "America/Adak",
            "America/Argentina/Jujuy",
            "America/Chicago",
            "Africa/Sao_Tome",
            "Europe/Bratislava",
            "Asia/Riyadh",
            "America/Lima",
            "America/New_York",
            "America/Pangnirtung",
            "Asia/Samarkand",
            "America/Port_of_Spain",
            "Africa/Johannesburg",
            "Pacific/Port_Moresby",
            "America/Bahia",
            "Europe/Zurich",
            "America/St_Barthelemy",
            "Asia/Nicosia",
            "Europe/Kaliningrad",
            "America/Anguilla",
            "Europe/Ljubljana",
            "Asia/Yekaterinburg",
            "Africa/Kampala",
            "America/Rio_Branco",
            "Africa/Bamako",
            "America/Goose_Bay",
            "Europe/Moscow",
            "Africa/Conakry",
            "America/Chihuahua",
            "Europe/Warsaw",
            "Pacific/Palau",
            "Europe/Mariehamn",
            "Africa/Windhoek",
            "America/La_Paz",
            "America/Recife",
            "America/Mexico_City",
            "Asia/Amman",
            "America/Tijuana",
            "America/Metlakatla",
            "Pacific/Midway",
            "Europe/Simferopol",
            "Europe/Budapest",
            "Pacific/Apia",
            "America/Paramaribo",
            "Africa/Malabo",
            "Africa/Ndjamena",
            "Asia/Choibalsan",
            "America/Antigua",
            "Europe/Istanbul",
            "Africa/Blantyre",
            "Australia/Sydney",
            "Asia/Dushanbe",
            "Europe/Belgrade",
            "Asia/Karachi",
            "Europe/Luxembourg",
            "Europe/Podgorica",
            "Australia/Lindeman",
            "Africa/Bangui",
            "Asia/Aden",
            "Pacific/Chuuk",
            "Asia/Brunei",
            "Indian/Comoro",
            "America/Asuncion",
            "Europe/Prague",
            "America/Cayman",
            "Pacific/Pohnpei",
            "America/Atikokan",
            "Pacific/Norfolk",
            "Africa/Dakar",
            "America/Argentina/Buenos_Aires",
            "America/Edmonton",
            "America/Barbados",
            "America/Santo_Domingo",
            "Asia/Bishkek",
            "Asia/Kuwait",
            "Pacific/Efate",
            "Indian/Mauritius",
            "America/Aruba",
            "Australia/Brisbane",
            "Indian/Kerguelen",
            "Pacific/Kiritimati",
            "America/Toronto",
            "Asia/Qyzylorda",
            "Asia/Aqtobe",
            "America/Eirunepe",
            "Europe/Isle_of_Man",
            "America/Blanc-Sablon",
            "Pacific/Honolulu",
            "America/Montevideo",
            "Asia/Tashkent",
            "Pacific/Kosrae",
            "America/Indiana/Winamac",
            "America/Argentina/La_Rioja",
            "Africa/Mogadishu",
            "Asia/Phnom_Penh",
            "Africa/Banjul",
            "America/Creston",
            "Europe/Brussels",
            "Asia/Gaza",
            "Atlantic/Bermuda",
            "America/Indiana/Knox",
            "America/El_Salvador",
            "America/Managua",
            "Africa/Niamey",
            "Europe/Monaco",
            "Africa/Ouagadougou",
            "Pacific/Easter",
            "Atlantic/Canary",
            "Asia/Vientiane",
            "Europe/Bucharest",
            "Africa/Lusaka",
            "Asia/Kathmandu",
            "Africa/Harare",
            "Asia/Bangkok",
            "Europe/Rome",
            "Africa/Lome",
            "America/Denver",
            "Indian/Reunion",
            "Europe/Kiev",
            "Europe/Vienna",
            "America/Guadeloupe",
            "America/Argentina/Cordoba",
            "Asia/Manila",
            "Asia/Tokyo",
            "America/Nassau",
            "Pacific/Enderbury",
            "Atlantic/Azores",
            "America/Winnipeg",
            "Europe/Dublin",
            "Asia/Kuching",
            "America/Argentina/Ushuaia",
            "Asia/Colombo",
            "Asia/Krasnoyarsk",
            "America/St_Johns",
            "Asia/Shanghai",
            "Pacific/Kwajalein",
            "Africa/Kigali",
            "Europe/Chisinau",
            "America/Noronha",
            "Europe/Guernsey",
            "Europe/Paris",
            "America/Guyana",
            "Africa/Luanda",
            "Africa/Abidjan",
            "America/Tortola",
            "Europe/Malta",
            "Europe/London",
            "Pacific/Guadalcanal",
            "Pacific/Gambier",
            "America/Thule",
            "America/Rankin_Inlet",
            "America/Regina",
            "America/Indiana/Vincennes",
            "America/Santarem",
            "Africa/Djibouti",
            "Pacific/Tahiti",
            "Europe/San_Marino",
            "America/Argentina/San_Luis",
            "Africa/Ceuta",
            "Asia/Singapore",
            "America/Campo_Grande",
            "Africa/Tunis",
            "Europe/Copenhagen",
            "Asia/Pontianak",
            "Asia/Dubai",
            "Africa/Khartoum",
            "Europe/Helsinki",
            "America/Whitehorse",
            "America/Maceio",
            "Africa/Douala",
            "Asia/Kuala_Lumpur",
            "America/Martinique",
            "America/Sao_Paulo",
            "America/Dawson",
            "Africa/Kinshasa",
            "Europe/Riga",
            "Africa/Tripoli",
            "Europe/Madrid",
            "America/Nipigon",
            "Pacific/Fakaofo",
            "Europe/Skopje",
            "America/St_Thomas",
            "Africa/Maseru",
            "Europe/Sofia",
            "America/Porto_Velho",
            "America/St_Kitts",
            "Africa/Casablanca",
            "Asia/Hebron",
            "Asia/Dili",
            "America/Argentina/San_Juan",
            "Asia/Almaty",
            "Europe/Sarajevo",
            "America/Boa_Vista",
            "Africa/Addis_Ababa",
            "Indian/Mayotte",
            "Africa/Lubumbashi",
            "Atlantic/Cape_Verde",
            "America/Lower_Princes",
            "Europe/Oslo",
            "Africa/Monrovia",
            "Asia/Muscat",
            "America/Thunder_Bay",
            "America/Juneau",
            "Pacific/Rarotonga",
            "Atlantic/Faroe",
            "America/Cayenne",
            "America/Cuiaba",
            "Africa/Maputo",
            "Asia/Anadyr",
            "Asia/Kabul",
            "America/Santa_Isabel",
            "Asia/Damascus",
            "Pacific/Noumea",
            "America/Anchorage",
            "Asia/Kolkata",
            "Pacific/Niue",
            "Asia/Kamchatka",
            "America/Matamoros",
            "Europe/Stockholm",
            "America/Havana",
            "Pacific/Auckland",
            "America/Rainy_River",
            "Asia/Omsk",
            "Africa/Algiers",
            "America/Guayaquil",
            "Indian/Maldives",
            "Asia/Makassar",
            "America/Monterrey",
            "Europe/Amsterdam",
            "America/St_Lucia",
            "Europe/Uzhgorod",
            "America/Indiana/Marengo",
            "Pacific/Saipan",
            "America/Bogota",
            "America/Indiana/Vevay",
            "America/Guatemala",
            "America/Puerto_Rico",
            "America/Marigot",
            "Africa/Juba",
            "America/Costa_Rica",
            "America/Caracas",
            "Pacific/Nauru",
            "Europe/Minsk",
            "America/Belem",
            "America/Cancun",
            "America/Hermosillo",
            "Asia/Chongqing",
            "Asia/Beirut",
            "Europe/Gibraltar",
            "Asia/Urumqi",
            "America/Mazatlan"
    };

    private static int getTzInt(float lat, float lng)
    {
        if (lng < 7.123472f)
            return call50(lat,lng);
        else
        if (lng < 105.104637f)
            if (lng < 43.199055f)
                if (lat < 58.776028f)
                    if (lat < 36.495724f)
                        if (lat < 16.352222f)
                            return call24(lat,lng);
                        else
                            return call25(lat,lng);
                    else
                    if (lat < 44.885307f)
                        return call28(lat,lng);
                    else
                    if (lng < 12.963583f)
                        if (lat < 55.276527f)
                            if (lat < 54.561165f)
                                if (lat < 53.259864f)
                                    if (lat < 45.502335f)
                                        if (lng < 7.181056f)
                                            if (lat < 45.286988f)
                                            {
                                                if (poly[0].contains(lat,lng)) return 297;
                                                else return 271;
                                            }
                                            else
                                            if (lat < 45.409389f)
                                            {
                                                if (poly[1].contains(lat,lng)) return 297;
                                                else return 271;
                                            }
                                            else
                                            {
                                                if (poly[2].contains(lat,lng)) return 297;
                                                else return 271;
                                            }
                                        else
                                            return 271;
                                    else
                                    if (lng < 10.491472f)
                                        if (lng < 8.721278f)
                                            if (lat < 46.464279f)
                                            {
                                                if (poly[3].contains(lat,lng)) return 172;
                                                else return 271;
                                            }
                                            else
                                            if (lat < 49.182751f)
                                                if (lat < 47.805332f)
                                                    if (lng < 7.922375f)
                                                    {
                                                        if (poly[4].contains(lat,lng)) return 6;
                                                        if (poly[5].contains(lat,lng)) return 297;
                                                        else return 172;
                                                    }
                                                    else
                                                    {
                                                        if (poly[6].contains(lat,lng)) return 6;
                                                        if (poly[7].contains(lat,lng)) return 6;
                                                        else return 172;
                                                    }
                                                else
                                                {
                                                    if (poly[8].contains(lat,lng)) return 297;
                                                    else return 6;
                                                }
                                            else
                                            {
                                                if (poly[9].contains(lat,lng)) return 385;
                                                else return 6;
                                            }
                                        else
                                        if (lat < 46.939667f)
                                            if (lng < 9.606375f)
                                            {
                                                if (poly[10].contains(lat,lng)) return 271;
                                                else return 172;
                                            }
                                            else
                                            {
                                                if (poly[11].contains(lat,lng)) return 271;
                                                if (poly[12].contains(lat,lng)) return 276;
                                                if (poly[13].contains(lat,lng)) return 276;
                                                else return 172;
                                            }
                                        else
                                        if (lat < 50.099766f)
                                            if (lat < 48.519716f)
                                                if (lng < 9.606375f)
                                                {
                                                    if (poly[14].contains(lat,lng)) return 6;
                                                    if (poly[15].contains(lat,lng)) return 78;
                                                    if (poly[16].contains(lat,lng)) return 276;
                                                    if (poly[17].contains(lat,lng)) return 276;
                                                    if (poly[18].contains(lat,lng)) return 276;
                                                    else return 172;
                                                }
                                                else
                                                {
                                                    if (poly[19].contains(lat,lng)) return 6;
                                                    if (poly[20].contains(lat,lng)) return 78;
                                                    if (poly[21].contains(lat,lng)) return 172;
                                                    if (poly[22].contains(lat,lng)) return 172;
                                                    if (poly[23].contains(lat,lng)) return 172;
                                                    else return 276;
                                                }
                                            else
                                                return 6;
                                        else
                                            return 6;
                                    else
                                    if (lat < 45.546391f)
                                        return 271;
                                    else
                                    if (lat < 47.794126f)
                                        if (lat < 47.095196f)
                                        {
                                            if (poly[24].contains(lat,lng)) return 276;
                                            if (poly[25].contains(lat,lng)) return 276;
                                            else return 271;
                                        }
                                        else
                                        {
                                            if (poly[26].contains(lat,lng)) return 276;
                                            if (poly[27].contains(lat,lng)) return 276;
                                            else return 6;
                                        }
                                    else
                                    if (lat < 48.216392f)
                                    {
                                        if (poly[28].contains(lat,lng)) return 276;
                                        else return 6;
                                    }
                                    else
                                    {
                                        if (poly[29].contains(lat,lng)) return 220;
                                        else return 6;
                                    }
                                else
                                    return 6;
                            else
                            if (lng < 10.036305f)
                                if (lat < 54.760555f)
                                    return 6;
                                else
                                if (lat < 55.045019f)
                                    if (lng < 8.408679f)
                                        return 6;
                                    else
                                    if (lat < 54.913971f)
                                        if (lng < 9.604082f)
                                            if (lng < 8.817778f)
                                            {
                                                if (poly[30].contains(lat,lng)) return 319;
                                                else return 6;
                                            }
                                            else
                                            {
                                                if (poly[31].contains(lat,lng)) return 319;
                                                else return 6;
                                            }
                                        else
                                        if (lng < 9.782444f)
                                        {
                                            if (poly[32].contains(lat,lng)) return 6;
                                            else return 319;
                                        }
                                        else
                                        if (lat < 54.802927f)
                                            return 6;
                                        else
                                            return 319;
                                    else
                                        return 319;
                                else
                                    return 319;
                            else
                                return 319;
                        else
                        if (lat < 57.760113f)
                            if (lng < 11.307861f)
                                return 319;
                            else
                            if (lat < 56.739723f)
                                if (lng < 12.102083f)
                                    return 319;
                                else
                                if (lng < 12.792528f)
                                    if (lat < 56.120609f)
                                        if (lat < 55.698891f)
                                            return 319;
                                        else
                                        if (lng < 12.635111f)
                                        {
                                            if (poly[33].contains(lat,lng)) return 375;
                                            else return 319;
                                        }
                                        else
                                            return 375;
                                    else
                                        return 375;
                                else
                                    return 375;
                            else
                                return 375;
                        else
                        if (lng < 9.394170f)
                            return 355;
                        else
                            return 375;
                    else
                    if (lat < 56.900307f)
                        return call27(lat,lng);
                    else
                    if (lng < 19.184860f)
                        return 375;
                    else
                    if (lng < 23.412361f)
                        if (lat < 58.394665f)
                            if (lng < 19.362333f)
                                return 375;
                            else
                            if (lat < 57.761696f)
                                return 332;
                            else
                                return 49;
                        else
                            return 49;
                    else
                    if (lng < 23.499717f)
                        if (lat < 57.042571f)
                            return 332;
                        else
                            return 49;
                    else
                    if (lng < 24.020306f)
                        if (lat < 57.039259f)
                            return 332;
                        else
                            return 49;
                    else
                    if (lng < 33.609680f)
                        if (lng < 28.814993f)
                            if (lng < 26.417649f)
                            {
                                if (poly[34].contains(lat,lng)) return 332;
                                else return 49;
                            }
                            else
                            {
                                if (poly[35].contains(lat,lng)) return 49;
                                if (poly[36].contains(lat,lng)) return 332;
                                else return 183;
                            }
                        else
                            return 183;
                    else
                        return 183;
                else
                    return call29(lat,lng);
            else
            if (lat < 20.645721f)
                return call40(lat,lng);
            else
                return call41(lat,lng);
        else
            return call49(lat,lng);
    }

    private static int call0(float lat, float lng)
    {
        if (lng < -58.655621f)
            if (lng < -62.365894f)
                if (lng < -70.680565f)
                    if (lat < -36.247081f)
                        if (lng < -72.442055f)
                            return 31;
                        else
                        if (lat < -36.383263f)
                            if (lat < -39.927078f)
                                if (lat < -41.698986f)
                                {
                                    if (poly[37].contains(lat,lng)) return 88;
                                    if (poly[38].contains(lat,lng)) return 127;
                                    else return 31;
                                }
                                else
                                {
                                    if (poly[39].contains(lat,lng)) return 127;
                                    else return 31;
                                }
                            else
                            if (lat < -38.155170f)
                            {
                                if (poly[40].contains(lat,lng)) return 31;
                                else return 127;
                            }
                            else
                            {
                                if (poly[41].contains(lat,lng)) return 127;
                                else return 31;
                            }
                        else
                        {
                            if (poly[42].contains(lat,lng)) return 127;
                            else return 31;
                        }
                    else
                        return 31;
                else
                if (lat < -40.237473f)
                    if (lng < -62.790363f)
                        if (lat < -42.344032f)
                            return 88;
                        else
                        if (lat < -42.072571f)
                            return 88;
                        else
                        if (lng < -65.033895f)
                        {
                            if (poly[43].contains(lat,lng)) return 88;
                            else return 127;
                        }
                        else
                        if (lng < -65.004135f)
                            return 127;
                        else
                        {
                            if (poly[44].contains(lat,lng)) return 226;
                            else return 127;
                        }
                    else
                        return 226;
                else
                if (lat < -31.954723f)
                    if (lng < -69.174179f)
                        if (lat < -36.096098f)
                        {
                            if (poly[45].contains(lat,lng)) return 14;
                            if (poly[46].contains(lat,lng)) return 31;
                            if (poly[47].contains(lat,lng)) return 31;
                            else return 127;
                        }
                        else
                        if (lat < -34.025411f)
                        {
                            if (poly[48].contains(lat,lng)) return 31;
                            else return 14;
                        }
                        else
                        if (lat < -32.990067f)
                        {
                            if (poly[49].contains(lat,lng)) return 31;
                            else return 14;
                        }
                        else
                        {
                            if (poly[50].contains(lat,lng)) return 31;
                            if (poly[51].contains(lat,lng)) return 346;
                            else return 14;
                        }
                    else
                    if (lng < -66.501678f)
                        if (lat < -36.096098f)
                        {
                            if (poly[52].contains(lat,lng)) return 14;
                            else return 127;
                        }
                        else
                        if (lat < -34.025411f)
                        {
                            if (poly[53].contains(lat,lng)) return 127;
                            if (poly[54].contains(lat,lng)) return 314;
                            else return 14;
                        }
                        else
                        {
                            if (poly[55].contains(lat,lng)) return 314;
                            if (poly[56].contains(lat,lng)) return 346;
                            else return 14;
                        }
                    else
                    {
                        if (poly[57].contains(lat,lng)) return 127;
                        if (poly[58].contains(lat,lng)) return 226;
                        if (poly[59].contains(lat,lng)) return 314;
                        else return 278;
                    }
                else
                if (lng < -66.523230f)
                    if (lat < -28.555717f)
                        if (lng < -68.601897f)
                            if (lat < -30.255220f)
                            {
                                if (poly[60].contains(lat,lng)) return 346;
                                else return 31;
                            }
                            else
                            {
                                if (poly[61].contains(lat,lng)) return 31;
                                if (poly[62].contains(lat,lng)) return 249;
                                else return 346;
                            }
                        else
                        {
                            if (poly[63].contains(lat,lng)) return 249;
                            if (poly[64].contains(lat,lng)) return 314;
                            else return 346;
                        }
                    else
                    if (lng < -68.601897f)
                    {
                        if (poly[65].contains(lat,lng)) return 88;
                        if (poly[66].contains(lat,lng)) return 249;
                        if (poly[67].contains(lat,lng)) return 346;
                        else return 31;
                    }
                    else
                    if (lat < -26.856215f)
                    {
                        if (poly[68].contains(lat,lng)) return 31;
                        if (poly[69].contains(lat,lng)) return 249;
                        else return 88;
                    }
                    else
                    {
                        if (poly[70].contains(lat,lng)) return 31;
                        if (poly[71].contains(lat,lng)) return 127;
                        if (poly[72].contains(lat,lng)) return 127;
                        else return 88;
                    }
                else
                if (lat < -28.555717f)
                {
                    if (poly[73].contains(lat,lng)) return 249;
                    if (poly[74].contains(lat,lng)) return 278;
                    if (poly[75].contains(lat,lng)) return 314;
                    else return 88;
                }
                else
                if (lng < -64.444562f)
                    if (lat < -26.856215f)
                        if (lng < -65.483896f)
                        {
                            if (poly[76].contains(lat,lng)) return 129;
                            if (poly[77].contains(lat,lng)) return 249;
                            else return 88;
                        }
                        else
                        {
                            if (poly[78].contains(lat,lng)) return 88;
                            if (poly[79].contains(lat,lng)) return 129;
                            else return 278;
                        }
                    else
                    {
                        if (poly[80].contains(lat,lng)) return 88;
                        if (poly[81].contains(lat,lng)) return 88;
                        if (poly[82].contains(lat,lng)) return 127;
                        if (poly[83].contains(lat,lng)) return 278;
                        else return 129;
                    }
                else
                {
                    if (poly[84].contains(lat,lng)) return 127;
                    else return 278;
                }
            else
            if (lat < -38.766533f)
                return 226;
            else
            {
                if (poly[85].contains(lat,lng)) return 278;
                else return 226;
            }
        else
        if (lng < -53.073933f)
            if (lat < -33.963406f)
                if (lng < -58.364113f)
                    if (lat < -34.247784f)
                        return 226;
                    else
                    if (lng < -58.432247f)
                    {
                        if (poly[86].contains(lat,lng)) return 278;
                        else return 226;
                    }
                    else
                    if (lat < -34.015757f)
                        return 226;
                    else
                        return 245;
                else
                if (lng < -56.669033f)
                    if (lat < -34.604405f)
                    {
                        if (poly[87].contains(lat,lng)) return 245;
                        else return 226;
                    }
                    else
                    if (lng < -58.238857f)
                        if (lat < -34.121304f)
                            return 226;
                        else
                            return 245;
                    else
                        return 245;
                else
                    return 245;
            else
            if (lat < -32.746323f)
                if (lng < -58.113934f)
                    if (lng < -58.179478f)
                        if (lat < -33.112217f)
                        {
                            if (poly[88].contains(lat,lng)) return 278;
                            else return 245;
                        }
                        else
                        if (lng < -58.244583f)
                            return 278;
                        else
                        {
                            if (poly[89].contains(lat,lng)) return 245;
                            else return 278;
                        }
                    else
                    if (lat < -33.078617f)
                        return 245;
                    else
                    if (lng < -58.151073f)
                    {
                        if (poly[90].contains(lat,lng)) return 245;
                        else return 278;
                    }
                    else
                    if (lat < -33.051277f)
                        return 245;
                    else
                    {
                        if (poly[91].contains(lat,lng)) return 278;
                        else return 245;
                    }
                else
                if (lng < -58.083050f)
                    return 245;
                else
                {
                    if (poly[92].contains(lat,lng)) return 329;
                    else return 245;
                }
            else
            if (lat < -28.951517f)
                if (lng < -55.864777f)
                    if (lat < -30.848920f)
                    {
                        if (poly[93].contains(lat,lng)) return 278;
                        if (poly[94].contains(lat,lng)) return 329;
                        else return 245;
                    }
                    else
                    if (lng < -57.260199f)
                    {
                        if (poly[95].contains(lat,lng)) return 278;
                        if (poly[96].contains(lat,lng)) return 329;
                        else return 245;
                    }
                    else
                    if (lat < -29.900218f)
                    {
                        if (poly[97].contains(lat,lng)) return 329;
                        else return 245;
                    }
                    else
                    {
                        if (poly[98].contains(lat,lng)) return 278;
                        else return 329;
                    }
                else
                {
                    if (poly[99].contains(lat,lng)) return 329;
                    else return 245;
                }
            else
            if (lng < -55.864777f)
                if (lat < -27.054114f)
                {
                    if (poly[100].contains(lat,lng)) return 219;
                    if (poly[101].contains(lat,lng)) return 329;
                    else return 278;
                }
                else
                if (lng < -57.260199f)
                    if (lat < -26.105413f)
                    {
                        if (poly[102].contains(lat,lng)) return 278;
                        else return 219;
                    }
                    else
                    {
                        if (poly[103].contains(lat,lng)) return 278;
                        else return 219;
                    }
                else
                    return 219;
            else
            if (lat < -27.054114f)
                if (lng < -54.469355f)
                    if (lat < -28.002816f)
                    {
                        if (poly[104].contains(lat,lng)) return 278;
                        else return 329;
                    }
                    else
                    {
                        if (poly[105].contains(lat,lng)) return 219;
                        if (poly[106].contains(lat,lng)) return 329;
                        if (poly[107].contains(lat,lng)) return 329;
                        else return 278;
                    }
                else
                {
                    if (poly[108].contains(lat,lng)) return 278;
                    if (poly[109].contains(lat,lng)) return 278;
                    if (poly[110].contains(lat,lng)) return 278;
                    else return 329;
                }
            else
            if (lng < -54.469355f)
            {
                if (poly[111].contains(lat,lng)) return 278;
                if (poly[112].contains(lat,lng)) return 329;
                else return 219;
            }
            else
            if (lat < -26.105413f)
            {
                if (poly[113].contains(lat,lng)) return 329;
                if (poly[114].contains(lat,lng)) return 329;
                else return 278;
            }
            else
            {
                if (poly[115].contains(lat,lng)) return 219;
                if (poly[116].contains(lat,lng)) return 278;
                else return 329;
            }
        else
        if (lng < -47.913853f)
            return 329;
        else
            return 156;
    }

    private static int call1(float lat, float lng)
    {
        if (lng < -82.738289f)
            if (lat < 14.445067f)
                if (lat < 0.165531f)
                    if (lng < -124.772850f)
                        if (lng < -136.162170f)
                            if (lat < -21.293276f)
                                return 305;
                            else
                                return 312;
                        else
                        if (lng < -134.878342f)
                            return 305;
                        else
                            return 107;
                    else
                        return 114;
                else
                if (lat < 12.177296f)
                    if (lat < 8.949529f)
                        if (lng < -89.933998f)
                            return 114;
                        else
                        if (lng < -83.620537f)
                            return 396;
                        else
                        {
                            if (poly[117].contains(lat,lng)) return 22;
                            else return 396;
                        }
                    else
                    if (lat < 9.948153f)
                        if (lng < -83.621902f)
                            return 396;
                        else
                        {
                            if (poly[118].contains(lat,lng)) return 22;
                            else return 396;
                        }
                    else
                    if (lat < 10.119060f)
                        return 396;
                    else
                    if (lng < -83.202422f)
                        if (lat < 10.124827f)
                            return 396;
                        else
                        {
                            if (poly[119].contains(lat,lng)) return 259;
                            else return 396;
                        }
                    else
                        return 259;
                else
                if (lng < -87.692162f)
                    if (lat < 13.312460f)
                        return 258;
                    else
                    if (lng < -89.350505f)
                        if (lng < -90.279968f)
                            return 392;
                        else
                        {
                            if (poly[120].contains(lat,lng)) return 392;
                            else return 258;
                        }
                    else
                    {
                        if (poly[121].contains(lat,lng)) return 258;
                        if (poly[122].contains(lat,lng)) return 258;
                        if (poly[123].contains(lat,lng)) return 258;
                        else return 145;
                    }
                else
                if (lng < -85.157913f)
                    if (lng < -87.547157f)
                        if (lat < 13.082987f)
                            return 259;
                        else
                            return 145;
                    else
                    if (lat < 12.833526f)
                        return 259;
                    else
                    if (lat < 14.293488f)
                        if (lat < 13.315682f)
                        {
                            if (poly[124].contains(lat,lng)) return 259;
                            else return 145;
                        }
                        else
                        if (lng < -87.386246f)
                            return 145;
                        else
                        {
                            if (poly[125].contains(lat,lng)) return 259;
                            else return 145;
                        }
                    else
                    {
                        if (poly[126].contains(lat,lng)) return 259;
                        else return 145;
                    }
                else
                    return 259;
            else
            if (lat < 17.817400f)
                if (lng < -88.033722f)
                    if (lng < -88.175591f)
                        if (lng < -92.937019f)
                            return 192;
                        else
                        if (lng < -90.371544f)
                            if (lat < 16.131234f)
                            {
                                if (poly[127].contains(lat,lng)) return 192;
                                else return 392;
                            }
                            else
                            if (lng < -91.654282f)
                                return 192;
                            else
                            if (lat < 16.974317f)
                            {
                                if (poly[128].contains(lat,lng)) return 392;
                                else return 192;
                            }
                            else
                            {
                                if (poly[129].contains(lat,lng)) return 392;
                                else return 192;
                            }
                        else
                        if (lat < 15.718479f)
                        {
                            if (poly[130].contains(lat,lng)) return 145;
                            else return 392;
                        }
                        else
                        if (lng < -88.627838f)
                        {
                            if (poly[131].contains(lat,lng)) return 392;
                            else return 41;
                        }
                        else
                        if (lat < 16.102887f)
                            return 41;
                        else
                            return 392;
                    else
                    if (lat < 15.784808f)
                        return 145;
                    else
                        return 41;
                else
                if (lat < 16.510256f)
                    if (lng < -85.842651f)
                        return 145;
                    else
                    if (lng < -84.498272f)
                    {
                        if (poly[132].contains(lat,lng)) return 259;
                        else return 145;
                    }
                    else
                    {
                        if (poly[133].contains(lat,lng)) return 145;
                        else return 259;
                    }
                else
                if (lng < -87.468124f)
                    return 41;
                else
                    return 145;
            else
            if (lng < -87.849937f)
                if (lng < -90.983063f)
                    if (lng < -110.807060f)
                        return 407;
                    else
                    if (lng < -96.048988f)
                        return 192;
                    else
                    if (lng < -91.509560f)
                    {
                        if (poly[134].contains(lat,lng)) return 32;
                        if (poly[135].contains(lat,lng)) return 32;
                        else return 192;
                    }
                    else
                    if (lat < 18.103054f)
                    {
                        if (poly[136].contains(lat,lng)) return 192;
                        else return 32;
                    }
                    else
                        return 32;
                else
                if (lng < -88.067238f)
                    if (lng < -88.080856f)
                    {
                        if (poly[137].contains(lat,lng)) return 32;
                        if (poly[138].contains(lat,lng)) return 41;
                        else return 401;
                    }
                    else
                        return 401;
                else
                if (lat < 18.167719f)
                    return 41;
                else
                    return 401;
            else
                return 401;
        else
        if (lat < 7.644825f)
            if (lat < 1.841667f)
                if (lng < -79.895477f)
                    if (lat < -3.404815f)
                        if (lng < -80.838730f)
                            return 164;
                        else
                        if (lng < -80.230945f)
                            if (lat < -3.453752f)
                                if (lat < -3.949543f)
                                {
                                    if (poly[139].contains(lat,lng)) return 381;
                                    else return 164;
                                }
                                else
                                {
                                    if (poly[140].contains(lat,lng)) return 381;
                                    else return 164;
                                }
                            else
                            {
                                if (poly[141].contains(lat,lng)) return 164;
                                else return 381;
                            }
                        else
                        if (lat < -3.437323f)
                            if (lat < -4.285207f)
                                if (lng < -80.136307f)
                                {
                                    if (poly[142].contains(lat,lng)) return 381;
                                    else return 164;
                                }
                                else
                                {
                                    if (poly[143].contains(lat,lng)) return 381;
                                    else return 164;
                                }
                            else
                            if (lat < -3.478404f)
                            {
                                if (poly[144].contains(lat,lng)) return 164;
                                else return 381;
                            }
                            else
                            {
                                if (poly[145].contains(lat,lng)) return 164;
                                else return 381;
                            }
                        else
                            return 381;
                    else
                        return 381;
                else
                if (lat < -9.017232f)
                    return 164;
                else
                if (lat < 1.439020f)
                    if (lng < -79.723465f)
                        if (lat < -4.393893f)
                        {
                            if (poly[146].contains(lat,lng)) return 381;
                            else return 164;
                        }
                        else
                            return 381;
                    else
                    if (lat < -3.789106f)
                    {
                        if (poly[147].contains(lat,lng)) return 381;
                        else return 164;
                    }
                    else
                    if (lng < -77.101025f)
                    {
                        if (poly[148].contains(lat,lng)) return 164;
                        if (poly[149].contains(lat,lng)) return 390;
                        else return 381;
                    }
                    else
                    if (lat < -1.175043f)
                    {
                        if (poly[150].contains(lat,lng)) return 381;
                        else return 164;
                    }
                    else
                    if (lng < -75.789804f)
                    {
                        if (poly[151].contains(lat,lng)) return 390;
                        else return 381;
                    }
                    else
                    if (lat < 0.131988f)
                        if (lng < -75.134194f)
                        {
                            if (poly[152].contains(lat,lng)) return 164;
                            if (poly[153].contains(lat,lng)) return 390;
                            else return 381;
                        }
                        else
                        {
                            if (poly[154].contains(lat,lng)) return 390;
                            else return 164;
                        }
                    else
                        return 390;
                else
                    return 390;
            else
            if (lat < 7.110721f)
                return 390;
            else
            if (lng < -79.995277f)
                return 22;
            else
            if (lng < -77.718857f)
                if (lat < 7.508337f)
                {
                    if (poly[155].contains(lat,lng)) return 390;
                    else return 22;
                }
                else
                {
                    if (poly[156].contains(lat,lng)) return 390;
                    else return 22;
                }
            else
            {
                if (poly[157].contains(lat,lng)) return 22;
                else return 390;
            }
        else
        if (lng < -79.893906f)
            if (lat < 8.331585f)
                return 22;
            else
            if (lng < -82.231812f)
                if (lng < -82.555992f)
                    if (lat < 9.648608f)
                        if (lat < 8.973391f)
                        {
                            if (poly[158].contains(lat,lng)) return 396;
                            else return 22;
                        }
                        else
                        {
                            if (poly[159].contains(lat,lng)) return 396;
                            else return 22;
                        }
                    else
                        return 259;
                else
                    return 22;
            else
            if (lat < 9.380544f)
                return 22;
            else
            if (lat < 13.380502f)
                return 390;
            else
                return 221;
        else
        if (lng < -78.793159f)
            if (lat < 9.637514f)
                return 22;
            else
                return 221;
        else
        if (lat < 11.112972f)
            if (lng < -77.174110f)
                if (lng < -78.151619f)
                    return 22;
                else
                if (lat < 8.686544f)
                    if (lng < -77.659527f)
                    {
                        if (poly[160].contains(lat,lng)) return 390;
                        else return 22;
                    }
                    else
                    {
                        if (poly[161].contains(lat,lng)) return 22;
                        else return 390;
                    }
                else
                    return 22;
            else
                return 390;
        else
        if (lat < 18.526976f)
            return 72;
        else
        if (lng < -77.162140f)
            return 376;
        else
        {
            if (poly[162].contains(lat,lng)) return 165;
            if (poly[163].contains(lat,lng)) return 165;
            else return 376;
        }
    }

    private static int call2(float lat, float lng)
    {
        if (lat < -4.122895f)
            if (lng < -67.557743f)
                if (lat < -10.505639f)
                    if (lng < -71.018164f)
                        return 164;
                    else
                    if (lat < -12.734070f)
                    {
                        if (poly[164].contains(lat,lng)) return 190;
                        else return 164;
                    }
                    else
                    if (lng < -69.287953f)
                    {
                        if (poly[165].contains(lat,lng)) return 164;
                        if (poly[166].contains(lat,lng)) return 190;
                        else return 180;
                    }
                    else
                    {
                        if (poly[167].contains(lat,lng)) return 164;
                        if (poly[168].contains(lat,lng)) return 180;
                        else return 190;
                    }
                else
                if (lng < -71.018164f)
                    if (lat < -7.314267f)
                        if (lng < -72.748374f)
                            if (lat < -8.909953f)
                            {
                                if (poly[169].contains(lat,lng)) return 180;
                                else return 164;
                            }
                            else
                            if (lng < -73.613479f)
                            {
                                if (poly[170].contains(lat,lng)) return 180;
                                else return 164;
                            }
                            else
                            {
                                if (poly[171].contains(lat,lng)) return 164;
                                if (poly[172].contains(lat,lng)) return 241;
                                else return 180;
                            }
                        else
                        {
                            if (poly[173].contains(lat,lng)) return 164;
                            if (poly[174].contains(lat,lng)) return 241;
                            else return 180;
                        }
                    else
                    if (lng < -72.748374f)
                        if (lat < -5.718581f)
                        {
                            if (poly[175].contains(lat,lng)) return 180;
                            if (poly[176].contains(lat,lng)) return 241;
                            else return 164;
                        }
                        else
                        {
                            if (poly[177].contains(lat,lng)) return 241;
                            else return 164;
                        }
                    else
                    if (lat < -5.718581f)
                        return 241;
                    else
                    if (lng < -71.883269f)
                    {
                        if (poly[178].contains(lat,lng)) return 241;
                        else return 164;
                    }
                    else
                    {
                        if (poly[179].contains(lat,lng)) return 241;
                        else return 164;
                    }
                else
                if (lat < -7.314267f)
                {
                    if (poly[180].contains(lat,lng)) return 7;
                    if (poly[181].contains(lat,lng)) return 164;
                    if (poly[182].contains(lat,lng)) return 241;
                    else return 180;
                }
                else
                if (lng < -69.287953f)
                    if (lat < -5.718581f)
                        return 241;
                    else
                    if (lng < -70.153058f)
                        if (lat < -4.920738f)
                            return 241;
                        else
                        if (lng < -70.585611f)
                        {
                            if (poly[183].contains(lat,lng)) return 164;
                            else return 241;
                        }
                        else
                        {
                            if (poly[184].contains(lat,lng)) return 241;
                            if (poly[185].contains(lat,lng)) return 241;
                            else return 164;
                        }
                    else
                    {
                        if (poly[186].contains(lat,lng)) return 7;
                        if (poly[187].contains(lat,lng)) return 164;
                        if (poly[188].contains(lat,lng)) return 164;
                        if (poly[189].contains(lat,lng)) return 390;
                        else return 241;
                    }
                else
                {
                    if (poly[190].contains(lat,lng)) return 241;
                    else return 7;
                }
            else
            if (lng < -59.818611f)
                if (lat < -9.542698f)
                    if (lng < -63.688177f)
                        if (lat < -12.252600f)
                        {
                            if (poly[191].contains(lat,lng)) return 341;
                            else return 190;
                        }
                        else
                        if (lng < -65.622960f)
                            if (lat < -10.897649f)
                                return 190;
                            else
                            if (lng < -66.590351f)
                            {
                                if (poly[192].contains(lat,lng)) return 7;
                                if (poly[193].contains(lat,lng)) return 180;
                                if (poly[194].contains(lat,lng)) return 341;
                                else return 190;
                            }
                            else
                            {
                                if (poly[195].contains(lat,lng)) return 7;
                                if (poly[196].contains(lat,lng)) return 7;
                                if (poly[197].contains(lat,lng)) return 190;
                                else return 341;
                            }
                        else
                        if (lat < -10.897649f)
                        {
                            if (poly[198].contains(lat,lng)) return 341;
                            else return 190;
                        }
                        else
                        {
                            if (poly[199].contains(lat,lng)) return 190;
                            else return 341;
                        }
                    else
                    if (lat < -12.252600f)
                        if (lng < -61.753394f)
                        {
                            if (poly[200].contains(lat,lng)) return 341;
                            else return 190;
                        }
                        else
                        if (lat < -13.607551f)
                        {
                            if (poly[201].contains(lat,lng)) return 341;
                            if (poly[202].contains(lat,lng)) return 363;
                            else return 190;
                        }
                        else
                        {
                            if (poly[203].contains(lat,lng)) return 190;
                            if (poly[204].contains(lat,lng)) return 363;
                            else return 341;
                        }
                    else
                    {
                        if (poly[205].contains(lat,lng)) return 341;
                        else return 363;
                    }
                else
                if (lng < -63.688177f)
                    if (lat < -6.832796f)
                        if (lng < -65.622960f)
                        {
                            if (poly[206].contains(lat,lng)) return 180;
                            if (poly[207].contains(lat,lng)) return 341;
                            if (poly[208].contains(lat,lng)) return 341;
                            else return 7;
                        }
                        else
                        {
                            if (poly[209].contains(lat,lng)) return 341;
                            else return 7;
                        }
                    else
                        return 7;
                else
                {
                    if (poly[210].contains(lat,lng)) return 7;
                    if (poly[211].contains(lat,lng)) return 363;
                    else return 341;
                }
            else
            if (lat < -9.542698f)
                return 363;
            else
            if (lat < -6.832796f)
                if (lng < -58.062149f)
                {
                    if (poly[212].contains(lat,lng)) return 310;
                    if (poly[213].contains(lat,lng)) return 363;
                    else return 7;
                }
                else
                {
                    if (poly[214].contains(lat,lng)) return 363;
                    else return 310;
                }
            else
            {
                if (poly[215].contains(lat,lng)) return 310;
                else return 7;
            }
        else
        if (lng < -66.869835f)
            if (lat < 0.940826f)
                if (lng < -70.674210f)
                    if (lat < -1.591035f)
                        if (lng < -72.576397f)
                        {
                            if (poly[216].contains(lat,lng)) return 390;
                            else return 164;
                        }
                        else
                        if (lat < -2.856965f)
                        {
                            if (poly[217].contains(lat,lng)) return 390;
                            else return 164;
                        }
                        else
                        {
                            if (poly[218].contains(lat,lng)) return 164;
                            else return 390;
                        }
                    else
                    {
                        if (poly[219].contains(lat,lng)) return 164;
                        else return 390;
                    }
                else
                if (lat < -1.591035f)
                {
                    if (poly[220].contains(lat,lng)) return 7;
                    if (poly[221].contains(lat,lng)) return 164;
                    if (poly[222].contains(lat,lng)) return 164;
                    else return 390;
                }
                else
                {
                    if (poly[223].contains(lat,lng)) return 390;
                    else return 7;
                }
            else
            if (lng < -70.674210f)
                return 390;
            else
            if (lat < 3.472686f)
                if (lng < -68.772022f)
                {
                    if (poly[224].contains(lat,lng)) return 7;
                    else return 390;
                }
                else
                if (lat < 2.206756f)
                {
                    if (poly[225].contains(lat,lng)) return 7;
                    if (poly[226].contains(lat,lng)) return 397;
                    else return 390;
                }
                else
                {
                    if (poly[227].contains(lat,lng)) return 397;
                    else return 390;
                }
            else
            {
                if (poly[228].contains(lat,lng)) return 397;
                else return 390;
            }
        else
        if (lat < -2.231925f)
        {
            if (poly[229].contains(lat,lng)) return 7;
            else return 310;
        }
        else
        if (lng < -61.587761f)
            if (lat < 1.886310f)
                if (lng < -64.228798f)
                {
                    if (poly[230].contains(lat,lng)) return 397;
                    else return 7;
                }
                else
                if (lat < -0.172808f)
                {
                    if (poly[231].contains(lat,lng)) return 349;
                    else return 7;
                }
                else
                {
                    if (poly[232].contains(lat,lng)) return 349;
                    if (poly[233].contains(lat,lng)) return 397;
                    else return 7;
                }
            else
            if (lng < -64.228798f)
            {
                if (poly[234].contains(lat,lng)) return 349;
                if (poly[235].contains(lat,lng)) return 349;
                else return 397;
            }
            else
            if (lat < 3.945428f)
                if (lng < -62.908279f)
                    if (lat < 2.915869f)
                    {
                        if (poly[236].contains(lat,lng)) return 7;
                        if (poly[237].contains(lat,lng)) return 349;
                        else return 397;
                    }
                    else
                    {
                        if (poly[238].contains(lat,lng)) return 397;
                        if (poly[239].contains(lat,lng)) return 397;
                        if (poly[240].contains(lat,lng)) return 397;
                        if (poly[241].contains(lat,lng)) return 397;
                        if (poly[242].contains(lat,lng)) return 397;
                        else return 349;
                    }
                else
                {
                    if (poly[243].contains(lat,lng)) return 7;
                    if (poly[244].contains(lat,lng)) return 397;
                    else return 349;
                }
            else
            {
                if (poly[245].contains(lat,lng)) return 349;
                if (poly[246].contains(lat,lng)) return 349;
                if (poly[247].contains(lat,lng)) return 349;
                if (poly[248].contains(lat,lng)) return 349;
                else return 397;
            }
        else
        if (lat < 1.886310f)
            if (lng < -58.946724f)
                if (lat < -0.172808f)
                {
                    if (poly[249].contains(lat,lng)) return 349;
                    else return 7;
                }
                else
                {
                    if (poly[250].contains(lat,lng)) return 7;
                    if (poly[251].contains(lat,lng)) return 298;
                    if (poly[252].contains(lat,lng)) return 310;
                    else return 349;
                }
            else
            if (lat < -0.172808f)
            {
                if (poly[253].contains(lat,lng)) return 310;
                else return 7;
            }
            else
            {
                if (poly[254].contains(lat,lng)) return 7;
                if (poly[255].contains(lat,lng)) return 298;
                if (poly[256].contains(lat,lng)) return 298;
                if (poly[257].contains(lat,lng)) return 349;
                else return 310;
            }
        else
        if (lng < -58.946724f)
            if (lat < 3.945428f)
            {
                if (poly[258].contains(lat,lng)) return 349;
                else return 298;
            }
            else
            if (lng < -60.267242f)
            {
                if (poly[259].contains(lat,lng)) return 298;
                if (poly[260].contains(lat,lng)) return 397;
                else return 349;
            }
            else
            {
                if (poly[261].contains(lat,lng)) return 349;
                else return 298;
            }
        else
        if (lat < 3.945428f)
            if (lng < -57.626205f)
            {
                if (poly[262].contains(lat,lng)) return 200;
                else return 298;
            }
            else
            if (lat < 2.915869f)
            {
                if (poly[263].contains(lat,lng)) return 200;
                if (poly[264].contains(lat,lng)) return 310;
                if (poly[265].contains(lat,lng)) return 310;
                else return 298;
            }
            else
            {
                if (poly[266].contains(lat,lng)) return 298;
                else return 200;
            }
        else
        {
            if (poly[267].contains(lat,lng)) return 298;
            else return 200;
        }
    }

    private static int call3(float lat, float lng)
    {
        if (lat < -14.962502f)
            if (lng < -64.158066f)
                if (lng < -68.814156f)
                    if (lat < -23.428734f)
                        return 31;
                    else
                    if (lat < -16.337534f)
                        if (lat < -19.883134f)
                            return 31;
                        else
                        if (lng < -71.069149f)
                            return 164;
                        else
                        if (lat < -18.110334f)
                        {
                            if (poly[268].contains(lat,lng)) return 164;
                            if (poly[269].contains(lat,lng)) return 190;
                            else return 31;
                        }
                        else
                        {
                            if (poly[270].contains(lat,lng)) return 31;
                            if (poly[271].contains(lat,lng)) return 190;
                            else return 164;
                        }
                    else
                    {
                        if (poly[272].contains(lat,lng)) return 190;
                        else return 164;
                    }
                else
                if (lat < -20.059607f)
                    if (lat < -22.608159f)
                        if (lng < -66.486111f)
                        {
                            if (poly[273].contains(lat,lng)) return 31;
                            if (poly[274].contains(lat,lng)) return 159;
                            if (poly[275].contains(lat,lng)) return 190;
                            else return 127;
                        }
                        else
                        if (lat < -23.882435f)
                        {
                            if (poly[276].contains(lat,lng)) return 159;
                            if (poly[277].contains(lat,lng)) return 159;
                            else return 127;
                        }
                        else
                        {
                            if (poly[278].contains(lat,lng)) return 159;
                            if (poly[279].contains(lat,lng)) return 190;
                            else return 127;
                        }
                    else
                    if (lng < -66.486111f)
                    {
                        if (poly[280].contains(lat,lng)) return 31;
                        if (poly[281].contains(lat,lng)) return 159;
                        else return 190;
                    }
                    else
                    {
                        if (poly[282].contains(lat,lng)) return 127;
                        if (poly[283].contains(lat,lng)) return 127;
                        if (poly[284].contains(lat,lng)) return 159;
                        else return 190;
                    }
                else
                {
                    if (poly[285].contains(lat,lng)) return 31;
                    else return 190;
                }
            else
            if (lat < -19.294041f)
                if (lng < -59.983578f)
                    if (lat < -22.225376f)
                        if (lng < -62.070822f)
                        {
                            if (poly[286].contains(lat,lng)) return 127;
                            if (poly[287].contains(lat,lng)) return 190;
                            if (poly[288].contains(lat,lng)) return 190;
                            if (poly[289].contains(lat,lng)) return 278;
                            else return 219;
                        }
                        else
                        {
                            if (poly[290].contains(lat,lng)) return 278;
                            else return 219;
                        }
                    else
                    {
                        if (poly[291].contains(lat,lng)) return 127;
                        if (poly[292].contains(lat,lng)) return 219;
                        else return 190;
                    }
                else
                if (lng < -55.612143f)
                    if (lat < -22.225376f)
                        if (lng < -57.797860f)
                        {
                            if (poly[293].contains(lat,lng)) return 278;
                            else return 219;
                        }
                        else
                        {
                            if (poly[294].contains(lat,lng)) return 278;
                            if (poly[295].contains(lat,lng)) return 317;
                            if (poly[296].contains(lat,lng)) return 317;
                            if (poly[297].contains(lat,lng)) return 317;
                            if (poly[298].contains(lat,lng)) return 317;
                            if (poly[299].contains(lat,lng)) return 317;
                            if (poly[300].contains(lat,lng)) return 317;
                            else return 219;
                        }
                    else
                    if (lng < -57.797860f)
                        if (lat < -20.759708f)
                        {
                            if (poly[301].contains(lat,lng)) return 317;
                            else return 219;
                        }
                        else
                        {
                            if (poly[302].contains(lat,lng)) return 190;
                            if (poly[303].contains(lat,lng)) return 219;
                            else return 317;
                        }
                    else
                    {
                        if (poly[304].contains(lat,lng)) return 219;
                        if (poly[305].contains(lat,lng)) return 219;
                        if (poly[306].contains(lat,lng)) return 219;
                        if (poly[307].contains(lat,lng)) return 219;
                        if (poly[308].contains(lat,lng)) return 219;
                        if (poly[309].contains(lat,lng)) return 219;
                        else return 317;
                    }
                else
                if (lat < -22.225376f)
                    if (lng < -53.426425f)
                        if (lat < -23.691044f)
                        {
                            if (poly[310].contains(lat,lng)) return 317;
                            if (poly[311].contains(lat,lng)) return 329;
                            else return 219;
                        }
                        else
                        {
                            if (poly[312].contains(lat,lng)) return 219;
                            if (poly[313].contains(lat,lng)) return 329;
                            else return 317;
                        }
                    else
                    {
                        if (poly[314].contains(lat,lng)) return 317;
                        else return 329;
                    }
                else
                {
                    if (poly[315].contains(lat,lng)) return 329;
                    else return 317;
                }
            else
            if (lng < -57.699387f)
                if (lng < -60.928726f)
                    return 190;
                else
                if (lat < -17.128271f)
                {
                    if (poly[316].contains(lat,lng)) return 317;
                    if (poly[317].contains(lat,lng)) return 317;
                    if (poly[318].contains(lat,lng)) return 317;
                    if (poly[319].contains(lat,lng)) return 363;
                    else return 190;
                }
                else
                {
                    if (poly[320].contains(lat,lng)) return 363;
                    else return 190;
                }
            else
            if (lng < -54.470047f)
            {
                if (poly[321].contains(lat,lng)) return 190;
                if (poly[322].contains(lat,lng)) return 190;
                if (poly[323].contains(lat,lng)) return 363;
                else return 317;
            }
            else
            if (lat < -17.128271f)
                if (lng < -52.855377f)
                {
                    if (poly[324].contains(lat,lng)) return 329;
                    if (poly[325].contains(lat,lng)) return 329;
                    if (poly[326].contains(lat,lng)) return 363;
                    else return 317;
                }
                else
                {
                    if (poly[327].contains(lat,lng)) return 329;
                    else return 317;
                }
            else
            {
                if (poly[328].contains(lat,lng)) return 329;
                else return 363;
            }
        else
        if (lng < -56.305687f)
            return call2(lat,lng);
        else
        if (lng < -51.613949f)
            if (lat < -9.477882f)
            {
                if (poly[329].contains(lat,lng)) return 310;
                if (poly[330].contains(lat,lng)) return 363;
                else return 400;
            }
            else
            if (lat < -1.736668f)
                if (lat < -5.607275f)
                    if (lng < -53.959818f)
                        return 310;
                    else
                    if (lat < -7.542579f)
                    {
                        if (poly[331].contains(lat,lng)) return 400;
                        else return 310;
                    }
                    else
                    {
                        if (poly[332].contains(lat,lng)) return 400;
                        else return 310;
                    }
                else
                {
                    if (poly[333].contains(lat,lng)) return 400;
                    else return 310;
                }
            else
            if (lat < 2.133939f)
                if (lng < -53.959818f)
                {
                    if (poly[334].contains(lat,lng)) return 200;
                    if (poly[335].contains(lat,lng)) return 362;
                    if (poly[336].contains(lat,lng)) return 400;
                    else return 310;
                }
                else
                if (lat < 0.198636f)
                {
                    if (poly[337].contains(lat,lng)) return 400;
                    else return 310;
                }
                else
                {
                    if (poly[338].contains(lat,lng)) return 310;
                    else return 400;
                }
            else
            if (lng < -53.959818f)
                if (lat < 4.069243f)
                    if (lng < -55.132752f)
                    {
                        if (poly[339].contains(lat,lng)) return 310;
                        else return 200;
                    }
                    else
                    if (lat < 3.101591f)
                        if (lng < -54.546285f)
                        {
                            if (poly[340].contains(lat,lng)) return 310;
                            if (poly[341].contains(lat,lng)) return 400;
                            else return 200;
                        }
                        else
                        {
                            if (poly[342].contains(lat,lng)) return 200;
                            if (poly[343].contains(lat,lng)) return 400;
                            if (poly[344].contains(lat,lng)) return 400;
                            else return 362;
                        }
                    else
                    {
                        if (poly[345].contains(lat,lng)) return 362;
                        else return 200;
                    }
                else
                {
                    if (poly[346].contains(lat,lng)) return 362;
                    else return 200;
                }
            else
            {
                if (poly[347].contains(lat,lng)) return 400;
                else return 362;
            }
        else
        if (lat < -9.768946f)
        {
            if (poly[348].contains(lat,lng)) return 400;
            else return 363;
        }
        else
            return 400;
    }

    private static int call4(float lat, float lng)
    {
        if (lng < -5.327115f)
            if (lat < 10.000000f)
                if (lng < -7.365113f)
                    if (lng < -11.496679f)
                        if (lat < 7.561782f)
                            return 68;
                        else
                        {
                            if (poly[349].contains(lat,lng)) return 184;
                            else return 68;
                        }
                    else
                    if (lat < 5.327682f)
                    {
                        if (poly[350].contains(lat,lng)) return 300;
                        else return 356;
                    }
                    else
                    if (lat < 7.663841f)
                        if (lng < -9.430896f)
                        {
                            if (poly[351].contains(lat,lng)) return 68;
                            if (poly[352].contains(lat,lng)) return 184;
                            else return 356;
                        }
                        else
                        if (lat < 6.495762f)
                        {
                            if (poly[353].contains(lat,lng)) return 300;
                            else return 356;
                        }
                        else
                        if (lng < -8.398005f)
                        {
                            if (poly[354].contains(lat,lng)) return 184;
                            if (poly[355].contains(lat,lng)) return 184;
                            if (poly[356].contains(lat,lng)) return 300;
                            if (poly[357].contains(lat,lng)) return 300;
                            else return 356;
                        }
                        else
                        {
                            if (poly[358].contains(lat,lng)) return 184;
                            if (poly[359].contains(lat,lng)) return 356;
                            else return 300;
                        }
                    else
                    if (lng < -9.430896f)
                        if (lat < 8.831921f)
                            if (lng < -10.463788f)
                            {
                                if (poly[360].contains(lat,lng)) return 184;
                                if (poly[361].contains(lat,lng)) return 356;
                                else return 68;
                            }
                            else
                            {
                                if (poly[362].contains(lat,lng)) return 68;
                                if (poly[363].contains(lat,lng)) return 184;
                                if (poly[364].contains(lat,lng)) return 184;
                                else return 356;
                            }
                        else
                        {
                            if (poly[365].contains(lat,lng)) return 68;
                            else return 184;
                        }
                    else
                    if (lat < 8.831921f)
                        if (lng < -8.398005f)
                        {
                            if (poly[366].contains(lat,lng)) return 356;
                            if (poly[367].contains(lat,lng)) return 356;
                            if (poly[368].contains(lat,lng)) return 356;
                            else return 184;
                        }
                        else
                        {
                            if (poly[369].contains(lat,lng)) return 184;
                            else return 300;
                        }
                    else
                    {
                        if (poly[370].contains(lat,lng)) return 300;
                        else return 184;
                    }
                else
                if (lat < -15.897190f)
                    return 156;
                else
                    return 300;
            else
            if (lat < 11.842492f)
                if (lng < -8.890819f)
                    return 184;
                else
                if (lng < -7.108967f)
                    if (lat < 10.921246f)
                    {
                        if (poly[371].contains(lat,lng)) return 184;
                        if (poly[372].contains(lat,lng)) return 300;
                        else return 181;
                    }
                    else
                    {
                        if (poly[373].contains(lat,lng)) return 184;
                        else return 181;
                    }
                else
                if (lat < 10.921246f)
                    if (lng < -6.218041f)
                    {
                        if (poly[374].contains(lat,lng)) return 181;
                        if (poly[375].contains(lat,lng)) return 181;
                        if (poly[376].contains(lat,lng)) return 181;
                        if (poly[377].contains(lat,lng)) return 181;
                        if (poly[378].contains(lat,lng)) return 181;
                        else return 300;
                    }
                    else
                    {
                        if (poly[379].contains(lat,lng)) return 181;
                        if (poly[380].contains(lat,lng)) return 262;
                        else return 300;
                    }
                else
                {
                    if (poly[381].contains(lat,lng)) return 262;
                    if (poly[382].contains(lat,lng)) return 262;
                    else return 181;
                }
            else
            if (lat < 16.333138f)
                if (lng < -8.890819f)
                    if (lat < 14.087815f)
                        if (lng < -10.672671f)
                            if (lat < 12.965153f)
                                if (lng < -11.563597f)
                                {
                                    if (poly[383].contains(lat,lng)) return 225;
                                    else return 184;
                                }
                                else
                                if (lat < 12.403823f)
                                {
                                    if (poly[384].contains(lat,lng)) return 181;
                                    else return 184;
                                }
                                else
                                {
                                    if (poly[385].contains(lat,lng)) return 184;
                                    if (poly[386].contains(lat,lng)) return 225;
                                    else return 181;
                                }
                            else
                            {
                                if (poly[387].contains(lat,lng)) return 225;
                                if (poly[388].contains(lat,lng)) return 225;
                                else return 181;
                            }
                        else
                        {
                            if (poly[389].contains(lat,lng)) return 184;
                            else return 181;
                        }
                    else
                    if (lng < -10.672671f)
                        if (lat < 15.210476f)
                        {
                            if (poly[390].contains(lat,lng)) return 33;
                            if (poly[391].contains(lat,lng)) return 33;
                            if (poly[392].contains(lat,lng)) return 225;
                            else return 181;
                        }
                        else
                        {
                            if (poly[393].contains(lat,lng)) return 33;
                            else return 181;
                        }
                    else
                    {
                        if (poly[394].contains(lat,lng)) return 181;
                        else return 33;
                    }
                else
                {
                    if (poly[395].contains(lat,lng)) return 33;
                    if (poly[396].contains(lat,lng)) return 184;
                    else return 181;
                }
            else
            {
                if (poly[397].contains(lat,lng)) return 181;
                else return 33;
            }
        else
        if (lat < 4.509286f)
            if (lat < 0.415882f)
                if (lng < 5.635208f)
                    return 201;
                else
                    return 161;
            else
                return 96;
        else
        if (lat < 11.173301f)
            if (lng < -0.273275f)
                if (lat < 7.955012f)
                {
                    if (poly[398].contains(lat,lng)) return 300;
                    else return 70;
                }
                else
                if (lng < -2.800195f)
                    if (lat < 9.564156f)
                    {
                        if (poly[399].contains(lat,lng)) return 262;
                        else return 300;
                    }
                    else
                    if (lng < -4.063655f)
                        if (lat < 10.368729f)
                            if (lng < -4.695385f)
                            {
                                if (poly[400].contains(lat,lng)) return 300;
                                else return 262;
                            }
                            else
                            {
                                if (poly[401].contains(lat,lng)) return 300;
                                else return 262;
                            }
                        else
                            return 262;
                    else
                    {
                        if (poly[402].contains(lat,lng)) return 70;
                        if (poly[403].contains(lat,lng)) return 70;
                        if (poly[404].contains(lat,lng)) return 300;
                        else return 262;
                    }
                else
                if (lat < 9.564156f)
                {
                    if (poly[405].contains(lat,lng)) return 70;
                    if (poly[406].contains(lat,lng)) return 262;
                    else return 300;
                }
                else
                {
                    if (poly[407].contains(lat,lng)) return 70;
                    else return 262;
                }
            else
            if (lng < 1.806693f)
                if (lat < 8.347418f)
                    if (lat < 6.934477f)
                        if (lng < 0.766709f)
                        {
                            if (poly[408].contains(lat,lng)) return 272;
                            else return 70;
                        }
                        else
                        {
                            if (poly[409].contains(lat,lng)) return 70;
                            if (poly[410].contains(lat,lng)) return 84;
                            if (poly[411].contains(lat,lng)) return 84;
                            else return 272;
                        }
                    else
                    {
                        if (poly[412].contains(lat,lng)) return 70;
                        if (poly[413].contains(lat,lng)) return 84;
                        else return 272;
                    }
                else
                if (lat < 9.760359f)
                {
                    if (poly[414].contains(lat,lng)) return 70;
                    if (poly[415].contains(lat,lng)) return 84;
                    else return 272;
                }
                else
                if (lng < 0.766709f)
                {
                    if (poly[416].contains(lat,lng)) return 70;
                    if (poly[417].contains(lat,lng)) return 262;
                    else return 272;
                }
                else
                {
                    if (poly[418].contains(lat,lng)) return 262;
                    if (poly[419].contains(lat,lng)) return 272;
                    else return 84;
                }
            else
            if (lat < 7.841293f)
            {
                if (poly[420].contains(lat,lng)) return 84;
                else return 96;
            }
            else
            if (lng < 4.465083f)
                if (lat < 9.507297f)
                {
                    if (poly[421].contains(lat,lng)) return 96;
                    else return 84;
                }
                else
                {
                    if (poly[422].contains(lat,lng)) return 96;
                    else return 84;
                }
            else
                return 96;
        else
        if (lng < -5.199527f)
            if (lat < 11.432508f)
            {
                if (poly[423].contains(lat,lng)) return 181;
                else return 262;
            }
            else
            if (lat < 11.788111f)
            {
                if (poly[424].contains(lat,lng)) return 262;
                else return 181;
            }
            else
            {
                if (poly[425].contains(lat,lng)) return 181;
                else return 262;
            }
        else
        if (lat < 15.082593f)
            if (lng < -0.462076f)
                if (lng < -2.830801f)
                    if (lat < 13.127947f)
                    {
                        if (poly[426].contains(lat,lng)) return 181;
                        else return 262;
                    }
                    else
                    {
                        if (poly[427].contains(lat,lng)) return 262;
                        else return 181;
                    }
                else
                {
                    if (poly[428].contains(lat,lng)) return 181;
                    else return 262;
                }
            else
            if (lng < 3.330698f)
                if (lat < 13.127947f)
                    if (lng < 1.434311f)
                    {
                        if (poly[429].contains(lat,lng)) return 84;
                        if (poly[430].contains(lat,lng)) return 260;
                        else return 262;
                    }
                    else
                    if (lat < 12.150624f)
                    {
                        if (poly[431].contains(lat,lng)) return 260;
                        if (poly[432].contains(lat,lng)) return 260;
                        if (poly[433].contains(lat,lng)) return 262;
                        else return 84;
                    }
                    else
                    {
                        if (poly[434].contains(lat,lng)) return 84;
                        if (poly[435].contains(lat,lng)) return 262;
                        else return 260;
                    }
                else
                {
                    if (poly[436].contains(lat,lng)) return 181;
                    if (poly[437].contains(lat,lng)) return 262;
                    else return 260;
                }
            else
            {
                if (poly[438].contains(lat,lng)) return 84;
                if (poly[439].contains(lat,lng)) return 96;
                else return 260;
            }
        else
        if (lng < 0.961973f)
            return 181;
        else
        if (lng < 4.042722f)
        {
            if (poly[440].contains(lat,lng)) return 260;
            if (poly[441].contains(lat,lng)) return 380;
            else return 181;
        }
        else
        {
            if (poly[442].contains(lat,lng)) return 181;
            if (poly[443].contains(lat,lng)) return 380;
            else return 260;
        }
    }

    private static int call5(float lat, float lng)
    {
        if (lng < -39.243401f)
            if (lat < -1.820639f)
                if (lat < -2.685229f)
                    if (lat < -21.599977f)
                        return 329;
                    else
                    if (lat < -3.148118f)
                        if (lat < -7.354445f)
                            if (lat < -12.556720f)
                                if (lng < -39.656792f)
                                    if (lng < -44.428988f)
                                        if (lat < -17.078349f)
                                            return 329;
                                        else
                                        if (lng < -46.815085f)
                                        {
                                            if (poly[444].contains(lat,lng)) return 329;
                                            else return 61;
                                        }
                                        else
                                        if (lat < -14.817534f)
                                        {
                                            if (poly[445].contains(lat,lng)) return 171;
                                            else return 329;
                                        }
                                        else
                                        {
                                            if (poly[446].contains(lat,lng)) return 61;
                                            if (poly[447].contains(lat,lng)) return 171;
                                            else return 329;
                                        }
                                    else
                                    if (lat < -17.078349f)
                                    {
                                        if (poly[448].contains(lat,lng)) return 171;
                                        else return 329;
                                    }
                                    else
                                    if (lng < -42.042890f)
                                    {
                                        if (poly[449].contains(lat,lng)) return 329;
                                        else return 171;
                                    }
                                    else
                                    {
                                        if (poly[450].contains(lat,lng)) return 329;
                                        else return 171;
                                    }
                                else
                                    return 171;
                            else
                            if (lng < -49.154449f)
                                if (lat < -7.791389f)
                                {
                                    if (poly[451].contains(lat,lng)) return 400;
                                    else return 61;
                                }
                                else
                                {
                                    if (poly[452].contains(lat,lng)) return 400;
                                    else return 61;
                                }
                            else
                            if (lng < -44.198925f)
                                if (lat < -9.955582f)
                                    if (lng < -46.676687f)
                                        return 61;
                                    else
                                    if (lat < -11.256151f)
                                    {
                                        if (poly[453].contains(lat,lng)) return 171;
                                        else return 61;
                                    }
                                    else
                                    {
                                        if (poly[454].contains(lat,lng)) return 61;
                                        if (poly[455].contains(lat,lng)) return 143;
                                        else return 171;
                                    }
                                else
                                if (lng < -46.676687f)
                                {
                                    if (poly[456].contains(lat,lng)) return 143;
                                    if (poly[457].contains(lat,lng)) return 143;
                                    else return 61;
                                }
                                else
                                {
                                    if (poly[458].contains(lat,lng)) return 61;
                                    if (poly[459].contains(lat,lng)) return 61;
                                    else return 143;
                                }
                            else
                            if (lat < -9.955582f)
                            {
                                if (poly[460].contains(lat,lng)) return 143;
                                else return 171;
                            }
                            else
                            if (lng < -41.721163f)
                            {
                                if (poly[461].contains(lat,lng)) return 171;
                                else return 143;
                            }
                            else
                            if (lat < -8.655013f)
                            {
                                if (poly[462].contains(lat,lng)) return 143;
                                if (poly[463].contains(lat,lng)) return 191;
                                else return 171;
                            }
                            else
                            {
                                if (poly[464].contains(lat,lng)) return 143;
                                if (poly[465].contains(lat,lng)) return 143;
                                if (poly[466].contains(lat,lng)) return 171;
                                else return 191;
                            }
                        else
                        if (lng < -46.716667f)
                            if (lat < -3.180000f)
                                if (lat < -5.267222f)
                                    if (lng < -47.958925f)
                                    {
                                        if (poly[467].contains(lat,lng)) return 143;
                                        if (poly[468].contains(lat,lng)) return 143;
                                        if (poly[469].contains(lat,lng)) return 400;
                                        if (poly[470].contains(lat,lng)) return 400;
                                        else return 61;
                                    }
                                    else
                                    {
                                        if (poly[471].contains(lat,lng)) return 143;
                                        else return 61;
                                    }
                                else
                                {
                                    if (poly[472].contains(lat,lng)) return 61;
                                    if (poly[473].contains(lat,lng)) return 61;
                                    if (poly[474].contains(lat,lng)) return 400;
                                    else return 143;
                                }
                            else
                            {
                                if (poly[475].contains(lat,lng)) return 143;
                                else return 400;
                            }
                        else
                            return 143;
                    else
                    if (lng < -46.568893f)
                        if (lng < -46.698047f)
                        {
                            if (poly[476].contains(lat,lng)) return 143;
                            else return 400;
                        }
                        else
                        {
                            if (poly[477].contains(lat,lng)) return 400;
                            else return 143;
                        }
                    else
                        return 143;
                else
                if (lng < -46.206947f)
                    if (lng < -49.192532f)
                        return 400;
                    else
                    {
                        if (poly[478].contains(lat,lng)) return 143;
                        else return 400;
                    }
                else
                    return 143;
            else
            if (lng < -46.319450f)
                return 400;
            else
            if (lng < -46.049419f)
                if (lat < -1.159195f)
                    if (lat < -1.745833f)
                    {
                        if (poly[479].contains(lat,lng)) return 400;
                        else return 143;
                    }
                    else
                    {
                        if (poly[480].contains(lat,lng)) return 143;
                        else return 400;
                    }
                else
                    return 400;
            else
                return 143;
        else
        if (lng < -15.836494f)
            if (lng < -23.098490f)
                if (lat < -12.650455f)
                    return 171;
                else
                if (lng < -32.382004f)
                    if (lng < -34.790123f)
                        if (lat < -8.632456f)
                            if (lng < -37.151226f)
                                if (lat < -10.641456f)
                                {
                                    if (poly[481].contains(lat,lng)) return 325;
                                    else return 171;
                                }
                                else
                                if (lng < -38.197313f)
                                {
                                    if (poly[482].contains(lat,lng)) return 191;
                                    if (poly[483].contains(lat,lng)) return 325;
                                    else return 171;
                                }
                                else
                                {
                                    if (poly[484].contains(lat,lng)) return 171;
                                    if (poly[485].contains(lat,lng)) return 191;
                                    else return 325;
                                }
                            else
                            {
                                if (poly[486].contains(lat,lng)) return 191;
                                else return 325;
                            }
                        else
                        if (lat < -5.932234f)
                            if (lng < -37.016762f)
                                if (lat < -7.282345f)
                                    if (lng < -38.130081f)
                                    {
                                        if (poly[487].contains(lat,lng)) return 191;
                                        else return 143;
                                    }
                                    else
                                    {
                                        if (poly[488].contains(lat,lng)) return 191;
                                        else return 143;
                                    }
                                else
                                {
                                    if (poly[489].contains(lat,lng)) return 191;
                                    else return 143;
                                }
                            else
                            if (lat < -7.282345f)
                            {
                                if (poly[490].contains(lat,lng)) return 143;
                                else return 191;
                            }
                            else
                                return 143;
                        else
                            return 143;
                    else
                        return 295;
                else
                    return 353;
            else
            if (lat < 11.974076f)
                return 38;
            else
            if (lat < 16.853725f)
                if (lat < 13.691580f)
                    if (lat < 13.588785f)
                        if (lat < 13.159023f)
                            if (lat < 12.469320f)
                                if (lng < -16.062716f)
                                {
                                    if (poly[491].contains(lat,lng)) return 225;
                                    else return 38;
                                }
                                else
                                {
                                    if (poly[492].contains(lat,lng)) return 225;
                                    else return 38;
                                }
                            else
                            {
                                if (poly[493].contains(lat,lng)) return 252;
                                else return 225;
                            }
                        else
                        if (lat < 13.488581f)
                            return 252;
                        else
                        {
                            if (poly[494].contains(lat,lng)) return 225;
                            else return 252;
                        }
                    else
                        return 225;
                else
                if (lng < -22.669443f)
                    return 353;
                else
                if (lng < -16.604567f)
                    return 225;
                else
                {
                    if (poly[495].contains(lat,lng)) return 33;
                    else return 225;
                }
            else
                return 33;
        else
        if (lng < -13.435683f)
            if (lat < 11.075797f)
                if (lng < -15.169497f)
                    return 38;
                else
                if (lng < -14.295186f)
                    if (lng < -14.897633f)
                        if (lng < -14.918398f)
                            if (lat < 10.889210f)
                                return 184;
                            else
                            if (lat < 11.046461f)
                            {
                                if (poly[496].contains(lat,lng)) return 38;
                                else return 184;
                            }
                            else
                            {
                                if (poly[497].contains(lat,lng)) return 184;
                                else return 38;
                            }
                        else
                            return 184;
                    else
                    if (lat < -7.887815f)
                        return 156;
                    else
                        return 184;
                else
                    return 184;
            else
            if (lat < 11.377222f)
                if (lng < -15.225043f)
                    return 38;
                else
                {
                    if (poly[498].contains(lat,lng)) return 184;
                    else return 38;
                }
            else
            if (lat < 12.680789f)
                if (lng < -15.179247f)
                    if (lat < 11.882746f)
                        return 38;
                    else
                    {
                        if (poly[499].contains(lat,lng)) return 225;
                        else return 38;
                    }
                else
                {
                    if (poly[500].contains(lat,lng)) return 184;
                    if (poly[501].contains(lat,lng)) return 225;
                    else return 38;
                }
            else
            if (lat < 13.826571f)
            {
                if (poly[502].contains(lat,lng)) return 225;
                if (poly[503].contains(lat,lng)) return 225;
                else return 252;
            }
            else
            if (lat < 17.100223f)
                if (lat < 15.463397f)
                    return 225;
                else
                if (lng < -14.636089f)
                {
                    if (poly[504].contains(lat,lng)) return 225;
                    else return 33;
                }
                else
                {
                    if (poly[505].contains(lat,lng)) return 225;
                    else return 33;
                }
            else
                return 33;
        else
        if (lng < -12.454523f)
            if (lat < 8.912874f)
                return 68;
            else
            if (lat < 9.868772f)
                if (lng < -13.420199f)
                    return 184;
                else
                {
                    if (poly[506].contains(lat,lng)) return 68;
                    else return 184;
                }
            else
            if (lat < 12.661082f)
            {
                if (poly[507].contains(lat,lng)) return 184;
                else return 225;
            }
            else
            {
                if (poly[508].contains(lat,lng)) return 33;
                else return 225;
            }
        else
            return call4(lat,lng);
    }

    private static int call6(float lat, float lng)
    {
        if (lng < -74.478584f)
            if (lng < -138.593521f)
                if (lng < -149.919128f)
                    if (lng < -172.053955f)
                        if (lng < -178.235748f)
                            return 147;
                        else
                        if (lng < -174.397614f)
                            if (lat < -19.878145f)
                                return 119;
                            else
                            if (lng < -175.597549f)
                                if (lat < -15.562988f)
                                    if (lat < -17.727858f)
                                        return 119;
                                    else
                                        return 147;
                                else
                                    return 5;
                            else
                            if (lat < -18.782106f)
                                return 119;
                            else
                                return 282;
                        else
                        if (lng < -173.702484f)
                            return 119;
                        else
                        if (lat < -13.432207f)
                            return 199;
                        else
                        if (lng < -172.481934f)
                            return 336;
                        else
                            return 282;
                    else
                    if (lat < -15.787958f)
                        if (lng < -157.312134f)
                            if (lng < -169.775177f)
                                return 372;
                            else
                                return 360;
                        else
                            return 312;
                    else
                    if (lng < -161.067062f)
                        if (lng < -169.416077f)
                            if (lat < -14.161497f)
                                return 44;
                            else
                            if (lng < -171.409317f)
                                if (lat < -13.786870f)
                                    return 199;
                                else
                                if (lat < -6.019926f)
                                    return 282;
                                else
                                    return 336;
                            else
                            if (lng < -171.211426f)
                                if (lat < -6.907127f)
                                    return 282;
                                else
                                    return 336;
                            else
                            if (lng < -171.059448f)
                                if (lat < -7.099203f)
                                    return 44;
                                else
                                    return 282;
                            else
                                return 50;
                        else
                            return 360;
                    else
                    if (lng < -157.964737f)
                        if (lat < -8.944030f)
                            return 360;
                        else
                            return 237;
                    else
                    if (lng < -157.178757f)
                        if (lng < -157.907135f)
                            return 360;
                        else
                            return 237;
                    else
                    if (lat < -3.989176f)
                        return 237;
                    else
                        return 244;
                else
                if (lat < -10.539028f)
                    return 312;
                else
                    return 102;
            else
                return call1(lat,lng);
        else
        if (lng < -49.201183f)
            if (lat < 8.980554f)
                if (lng < -51.240707f)
                    if (lat < 8.600101f)
                        if (lat < 6.004546f)
                            return call3(lat,lng);
                        else
                        if (lng < -59.803780f)
                            if (lng < -67.422675f)
                                if (lng < -70.950629f)
                                {
                                    if (poly[509].contains(lat,lng)) return 397;
                                    else return 390;
                                }
                                else
                                {
                                    if (poly[510].contains(lat,lng)) return 390;
                                    else return 397;
                                }
                            else
                            if (lat < 8.557567f)
                                if (lng < -63.613227f)
                                    return 397;
                                else
                                if (lng < -61.708503f)
                                    return 397;
                                else
                                if (lat < 7.281056f)
                                {
                                    if (poly[511].contains(lat,lng)) return 397;
                                    else return 298;
                                }
                                else
                                {
                                    if (poly[512].contains(lat,lng)) return 298;
                                    else return 397;
                                }
                            else
                                return 397;
                        else
                            return 298;
                    else
                    if (lng < -72.626933f)
                    {
                        if (poly[513].contains(lat,lng)) return 397;
                        else return 390;
                    }
                    else
                        return 397;
                else
                if (lat < -2.030330f)
                    if (lat < -8.062619f)
                        if (lat < -19.269809f)
                        {
                            if (poly[514].contains(lat,lng)) return 317;
                            else return 329;
                        }
                        else
                        if (lat < -13.666214f)
                        {
                            if (poly[515].contains(lat,lng)) return 363;
                            else return 329;
                        }
                        else
                        if (lat < -10.864416f)
                            if (lat < -12.265315f)
                                if (lng < -50.220945f)
                                {
                                    if (poly[516].contains(lat,lng)) return 61;
                                    if (poly[517].contains(lat,lng)) return 329;
                                    else return 363;
                                }
                                else
                                {
                                    if (poly[518].contains(lat,lng)) return 329;
                                    else return 61;
                                }
                            else
                            {
                                if (poly[519].contains(lat,lng)) return 363;
                                else return 61;
                            }
                        else
                        {
                            if (poly[520].contains(lat,lng)) return 363;
                            if (poly[521].contains(lat,lng)) return 400;
                            else return 61;
                        }
                    else
                    if (lat < -6.923692f)
                        if (lat < -7.274446f)
                        {
                            if (poly[522].contains(lat,lng)) return 61;
                            else return 400;
                        }
                        else
                        {
                            if (poly[523].contains(lat,lng)) return 61;
                            else return 400;
                        }
                    else
                        return 400;
                else
                    return 400;
            else
            if (lat < 12.691054f)
                if (lng < -64.505745f)
                    if (lng < -68.192307f)
                        if (lng < -71.116249f)
                            if (lng < -71.624382f)
                                if (lat < 10.721931f)
                                {
                                    if (poly[524].contains(lat,lng)) return 390;
                                    else return 397;
                                }
                                else
                                {
                                    if (poly[525].contains(lat,lng)) return 397;
                                    if (poly[526].contains(lat,lng)) return 397;
                                    else return 390;
                                }
                            else
                            if (lat < 11.051531f)
                                return 397;
                            else
                            {
                                if (poly[527].contains(lat,lng)) return 397;
                                else return 390;
                            }
                        else
                        if (lat < 10.845729f)
                            return 397;
                        else
                        if (lng < -68.733948f)
                            if (lat < 12.385672f)
                            {
                                if (poly[528].contains(lat,lng)) return 91;
                                else return 397;
                            }
                            else
                                return 234;
                        else
                        if (lat < 11.998877f)
                            if (lat < 11.664527f)
                                return 91;
                            else
                                return 397;
                        else
                            return 138;
                    else
                        return 397;
                else
                if (lat < 9.922397f)
                    return 397;
                else
                if (lng < -61.981004f)
                    return 397;
                else
                if (lat < 11.338342f)
                    if (lng < -61.843590f)
                        if (lat < 10.095178f)
                            return 168;
                        else
                            return 397;
                    else
                        return 168;
                else
                if (lat < 12.529215f)
                    return 86;
                else
                    return 2;
            else
            if (lng < -64.555527f)
                if (lng < -65.592079f)
                    if (lng < -72.619797f)
                        if (lng < -74.131775f)
                            if (lat < 19.376385f)
                                return 19;
                            else
                                return 376;
                        else
                            return 19;
                    else
                    if (lng < -68.320000f)
                        if (lng < -71.613358f)
                            if (lat < 17.481750f)
                                return 229;
                            else
                            if (lat < 19.201639f)
                            {
                                if (poly[529].contains(lat,lng)) return 229;
                                else return 19;
                            }
                            else
                            {
                                if (poly[530].contains(lat,lng)) return 229;
                                else return 19;
                            }
                        else
                            return 229;
                    else
                        return 393;
                else
                if (lng < -64.833633f)
                    if (lng < -65.242737f)
                        return 393;
                    else
                        return 338;
                else
                if (lat < 18.379963f)
                    if (lat < 17.795403f)
                        return 338;
                    else
                    if (lng < -64.662430f)
                        return 338;
                    else
                        return 301;
                else
                    return 301;
            else
            if (lng < -62.146420f)
                if (lng < -64.268768f)
                    return 301;
                else
                if (lat < 18.130697f)
                    if (lng < -62.943668f)
                        if (lat < 17.656101f)
                            return 138;
                        else
                        if (lng < -63.012993f)
                        {
                            if (poly[531].contains(lat,lng)) return 354;
                            else return 394;
                        }
                        else
                            return 277;
                    else
                    if (lat < 17.209156f)
                        if (lat < 16.956336f)
                            return 80;
                        else
                            return 342;
                    else
                    if (lat < 17.652030f)
                        return 173;
                    else
                        return 342;
                else
                    return 176;
            else
            if (lat < 14.878819f)
                if (lat < 12.964186f)
                    return 2;
                else
                if (lat < 14.103245f)
                    if (lng < -61.113880f)
                        return 2;
                    else
                    if (lat < 13.516017f)
                        return 228;
                    else
                        return 386;
                else
                    return 328;
            else
            if (lng < -61.546261f)
                if (lat < 16.368206f)
                    return 277;
                else
                    return 204;
            else
            if (lat < 15.631809f)
                return 1;
            else
                return 277;
        else
            return call5(lat,lng);
    }

    private static int call7(float lat, float lng)
    {
        if (lng < -103.047236f)
            if (lng < -109.624168f)
                if (lat < 27.090626f)
                    if (lng < -110.792007f)
                        return 407;
                    else
                        return 402;
                else
                if (lat < 27.905155f)
                    return 402;
                else
                if (lat < 31.330078f)
                {
                    if (poly[532].contains(lat,lng)) return 9;
                    else return 402;
                }
                else
                {
                    if (poly[533].contains(lat,lng)) return 273;
                    else return 9;
                }
            else
            if (lat < 25.528921f)
                if (lng < -108.804733f)
                    return 407;
                else
                {
                    if (poly[534].contains(lat,lng)) return 384;
                    else return 407;
                }
            else
            if (lat < 27.061386f)
                if (lng < -106.335702f)
                    if (lng < -107.979935f)
                    {
                        if (poly[535].contains(lat,lng)) return 185;
                        if (poly[536].contains(lat,lng)) return 402;
                        else return 407;
                    }
                    else
                    {
                        if (poly[537].contains(lat,lng)) return 384;
                        if (poly[538].contains(lat,lng)) return 407;
                        else return 185;
                    }
                else
                {
                    if (poly[539].contains(lat,lng)) return 185;
                    else return 384;
                }
            else
            if (lng < -108.558060f)
                if (lat < 31.330776f)
                    if (lat < 29.992775f)
                    {
                        if (poly[540].contains(lat,lng)) return 185;
                        else return 402;
                    }
                    else
                    {
                        if (poly[541].contains(lat,lng)) return 185;
                        if (poly[542].contains(lat,lng)) return 402;
                        else return 133;
                    }
                else
                {
                    if (poly[543].contains(lat,lng)) return 9;
                    else return 273;
                }
            else
            if (lat < 31.159515f)
                if (lng < -105.802648f)
                {
                    if (poly[544].contains(lat,lng)) return 185;
                    else return 133;
                }
                else
                if (lat < 29.110451f)
                    if (lng < -104.424942f)
                        return 185;
                    else
                    if (lat < 28.085918f)
                    {
                        if (poly[545].contains(lat,lng)) return 384;
                        else return 185;
                    }
                    else
                    if (lng < -103.736089f)
                    {
                        if (poly[546].contains(lat,lng)) return 133;
                        if (poly[547].contains(lat,lng)) return 133;
                        if (poly[548].contains(lat,lng)) return 384;
                        else return 185;
                    }
                    else
                    if (lat < 28.598185f)
                    {
                        if (poly[549].contains(lat,lng)) return 185;
                        else return 384;
                    }
                    else
                    if (lng < -103.391663f)
                    {
                        if (poly[550].contains(lat,lng)) return 160;
                        if (poly[551].contains(lat,lng)) return 185;
                        if (poly[552].contains(lat,lng)) return 374;
                        if (poly[553].contains(lat,lng)) return 384;
                        else return 133;
                    }
                    else
                    {
                        if (poly[554].contains(lat,lng)) return 133;
                        if (poly[555].contains(lat,lng)) return 160;
                        if (poly[556].contains(lat,lng)) return 384;
                        else return 374;
                    }
                else
                if (lng < -104.424942f)
                    if (lat < 30.134983f)
                    {
                        if (poly[557].contains(lat,lng)) return 160;
                        if (poly[558].contains(lat,lng)) return 185;
                        else return 133;
                    }
                    else
                    if (lng < -105.113795f)
                    {
                        if (poly[559].contains(lat,lng)) return 185;
                        if (poly[560].contains(lat,lng)) return 273;
                        else return 133;
                    }
                    else
                    {
                        if (poly[561].contains(lat,lng)) return 160;
                        if (poly[562].contains(lat,lng)) return 185;
                        if (poly[563].contains(lat,lng)) return 185;
                        if (poly[564].contains(lat,lng)) return 273;
                        else return 133;
                    }
                else
                {
                    if (poly[565].contains(lat,lng)) return 160;
                    if (poly[566].contains(lat,lng)) return 185;
                    else return 133;
                }
            else
            if (lng < -105.802648f)
            {
                if (poly[567].contains(lat,lng)) return 185;
                if (poly[568].contains(lat,lng)) return 185;
                if (poly[569].contains(lat,lng)) return 273;
                else return 133;
            }
            else
            {
                if (poly[570].contains(lat,lng)) return 133;
                if (poly[571].contains(lat,lng)) return 160;
                else return 273;
            }
        else
        if (lng < -97.475403f)
            if (lat < 26.857126f)
                if (lng < -100.261320f)
                    return 384;
                else
                if (lng < -98.868361f)
                {
                    if (poly[572].contains(lat,lng)) return 160;
                    if (poly[573].contains(lat,lng)) return 384;
                    else return 374;
                }
                else
                if (lat < 26.155322f)
                    if (lng < -98.171882f)
                    {
                        if (poly[574].contains(lat,lng)) return 160;
                        if (poly[575].contains(lat,lng)) return 160;
                        if (poly[576].contains(lat,lng)) return 384;
                        else return 374;
                    }
                    else
                    {
                        if (poly[577].contains(lat,lng)) return 160;
                        if (poly[578].contains(lat,lng)) return 384;
                        else return 374;
                    }
                else
                {
                    if (poly[579].contains(lat,lng)) return 374;
                    if (poly[580].contains(lat,lng)) return 374;
                    else return 160;
                }
            else
            if (lng < -99.285888f)
                if (lat < 31.057385f)
                    if (lat < 28.957256f)
                        if (lng < -101.166562f)
                        {
                            if (poly[581].contains(lat,lng)) return 374;
                            else return 384;
                        }
                        else
                        if (lat < 27.907191f)
                            if (lng < -100.226225f)
                            {
                                if (poly[582].contains(lat,lng)) return 374;
                                else return 384;
                            }
                            else
                            if (lat < 27.382159f)
                            {
                                if (poly[583].contains(lat,lng)) return 160;
                                if (poly[584].contains(lat,lng)) return 384;
                                else return 374;
                            }
                            else
                            {
                                if (poly[585].contains(lat,lng)) return 160;
                                if (poly[586].contains(lat,lng)) return 384;
                                else return 374;
                            }
                        else
                        {
                            if (poly[587].contains(lat,lng)) return 160;
                            if (poly[588].contains(lat,lng)) return 384;
                            else return 374;
                        }
                    else
                    if (lng < -101.166562f)
                        if (lat < 30.007321f)
                            if (lng < -102.106899f)
                                if (lat < 29.482288f)
                                {
                                    if (poly[589].contains(lat,lng)) return 160;
                                    if (poly[590].contains(lat,lng)) return 384;
                                    else return 374;
                                }
                                else
                                {
                                    if (poly[591].contains(lat,lng)) return 160;
                                    if (poly[592].contains(lat,lng)) return 384;
                                    else return 374;
                                }
                            else
                            if (lat < 29.482288f)
                            {
                                if (poly[593].contains(lat,lng)) return 160;
                                if (poly[594].contains(lat,lng)) return 384;
                                else return 374;
                            }
                            else
                            {
                                if (poly[595].contains(lat,lng)) return 160;
                                if (poly[596].contains(lat,lng)) return 384;
                                if (poly[597].contains(lat,lng)) return 384;
                                if (poly[598].contains(lat,lng)) return 384;
                                if (poly[599].contains(lat,lng)) return 384;
                                else return 374;
                            }
                        else
                            return 160;
                    else
                    {
                        if (poly[600].contains(lat,lng)) return 160;
                        if (poly[601].contains(lat,lng)) return 384;
                        else return 374;
                    }
                else
                    return 160;
            else
                return 160;
        else
        if (lat < 25.878584f)
            if (lat < 25.603125f)
                if (lng < -97.450340f)
                {
                    if (poly[602].contains(lat,lng)) return 374;
                    else return 384;
                }
                else
                {
                    if (poly[603].contains(lat,lng)) return 374;
                    else return 384;
                }
            else
            {
                if (poly[604].contains(lat,lng)) return 160;
                else return 374;
            }
        else
            return 160;
    }

    private static int call8(float lat, float lng)
    {
        if (lng < -118.678200f)
            if (lat < 48.419193f)
                return 39;
            else
            if (lat < 49.002640f)
                if (lng < -122.902634f)
                    if (lat < 48.722092f)
                        if (lat < 48.429218f)
                            return 45;
                        else
                            return 39;
                    else
                    if (lng < -123.176979f)
                        return 45;
                    else
                    if (lat < 48.820377f)
                        if (lng < -123.040512f)
                            return 45;
                        else
                            return 39;
                    else
                    {
                        if (poly[605].contains(lat,lng)) return 45;
                        else return 39;
                    }
                else
                if (lat < 48.744881f)
                    return 39;
                else
                {
                    if (poly[606].contains(lat,lng)) return 45;
                    else return 39;
                }
            else
                return 45;
        else
        if (lat < 27.895760f)
            return 407;
        else
        if (lat < 29.996002f)
            if (lng < -114.366554f)
                if (lat < 27.899921f)
                    return 407;
                else
                    return 367;
            else
            if (lng < -112.753685f)
                if (lat < 28.002499f)
                    if (lat < 27.946997f)
                        return 407;
                    else
                    {
                        if (poly[607].contains(lat,lng)) return 367;
                        else return 407;
                    }
                else
                    return 367;
            else
                return 402;
        else
        if (lat < 33.478561f)
            if (lng < -118.299171f)
                return 39;
            else
            if (lng < -116.797958f)
                if (lat < 32.419422f)
                    return 194;
                else
                {
                    if (poly[608].contains(lat,lng)) return 194;
                    else return 39;
                }
            else
            if (lat < 30.494665f)
                if (lng < -114.543932f)
                    return 367;
                else
                    return 402;
            else
            if (lng < -113.899330f)
                if (lat < 31.986613f)
                {
                    if (poly[609].contains(lat,lng)) return 194;
                    if (poly[610].contains(lat,lng)) return 402;
                    else return 367;
                }
                else
                {
                    if (poly[611].contains(lat,lng)) return 39;
                    if (poly[612].contains(lat,lng)) return 194;
                    if (poly[613].contains(lat,lng)) return 367;
                    if (poly[614].contains(lat,lng)) return 402;
                    else return 9;
                }
            else
            {
                if (poly[615].contains(lat,lng)) return 9;
                else return 402;
            }
        else
        if (lat < 46.038212f)
            if (lat < 37.004261f)
                if (lng < -114.047243f)
                    if (lng < -116.362721f)
                        return 39;
                    else
                    if (lat < 35.241411f)
                    {
                        if (poly[616].contains(lat,lng)) return 9;
                        else return 39;
                    }
                    else
                    {
                        if (poly[617].contains(lat,lng)) return 9;
                        else return 39;
                    }
                else
                if (lat < 35.241411f)
                {
                    if (poly[618].contains(lat,lng)) return 273;
                    else return 9;
                }
                else
                if (lng < -112.523972f)
                    return 9;
                else
                if (lat < 36.122836f)
                {
                    if (poly[619].contains(lat,lng)) return 9;
                    if (poly[620].contains(lat,lng)) return 9;
                    else return 273;
                }
                else
                {
                    if (poly[621].contains(lat,lng)) return 9;
                    if (poly[622].contains(lat,lng)) return 9;
                    if (poly[623].contains(lat,lng)) return 9;
                    if (poly[624].contains(lat,lng)) return 9;
                    else return 273;
                }
            else
            if (lat < 41.521236f)
            {
                if (poly[625].contains(lat,lng)) return 39;
                else return 273;
            }
            else
            if (lng < -114.839451f)
                if (lat < 43.779724f)
                {
                    if (poly[626].contains(lat,lng)) return 27;
                    else return 39;
                }
                else
                if (lng < -116.758825f)
                {
                    if (poly[627].contains(lat,lng)) return 27;
                    if (poly[628].contains(lat,lng)) return 27;
                    else return 39;
                }
                else
                {
                    if (poly[629].contains(lat,lng)) return 27;
                    else return 39;
                }
            else
            if (lat < 43.779724f)
            {
                if (poly[630].contains(lat,lng)) return 27;
                if (poly[631].contains(lat,lng)) return 39;
                else return 273;
            }
            else
            if (lng < -112.920076f)
                if (lat < 44.908968f)
                {
                    if (poly[632].contains(lat,lng)) return 273;
                    else return 27;
                }
                else
                if (lng < -113.879764f)
                {
                    if (poly[633].contains(lat,lng)) return 27;
                    if (poly[634].contains(lat,lng)) return 39;
                    else return 273;
                }
                else
                {
                    if (poly[635].contains(lat,lng)) return 27;
                    else return 273;
                }
            else
            {
                if (poly[636].contains(lat,lng)) return 27;
                else return 273;
            }
        else
        if (lat < 52.150300f)
            if (lng < -114.839451f)
                if (lat < 49.094256f)
                {
                    if (poly[637].contains(lat,lng)) return 45;
                    if (poly[638].contains(lat,lng)) return 227;
                    if (poly[639].contains(lat,lng)) return 253;
                    if (poly[640].contains(lat,lng)) return 273;
                    else return 39;
                }
                else
                if (lng < -116.758825f)
                    if (lat < 50.622278f)
                    {
                        if (poly[641].contains(lat,lng)) return 253;
                        if (poly[642].contains(lat,lng)) return 253;
                        else return 45;
                    }
                    else
                    {
                        if (poly[643].contains(lat,lng)) return 227;
                        else return 45;
                    }
                else
                if (lat < 50.622278f)
                    if (lng < -115.799138f)
                        if (lat < 49.858267f)
                        {
                            if (poly[644].contains(lat,lng)) return 45;
                            if (poly[645].contains(lat,lng)) return 45;
                            if (poly[646].contains(lat,lng)) return 227;
                            else return 253;
                        }
                        else
                        {
                            if (poly[647].contains(lat,lng)) return 227;
                            else return 45;
                        }
                    else
                        return 227;
                else
                {
                    if (poly[648].contains(lat,lng)) return 45;
                    else return 227;
                }
            else
            {
                if (poly[649].contains(lat,lng)) return 39;
                if (poly[650].contains(lat,lng)) return 227;
                else return 273;
            }
        else
        {
            if (poly[651].contains(lat,lng)) return 45;
            else return 227;
        }
    }

    private static int call9(float lat, float lng)
    {
        if (lat < 25.453518f)
            if (lng < -108.089081f)
                return 407;
            else
            if (lat < 24.790808f)
                if (lng < -101.290734f)
                    if (lng < -106.203979f)
                        if (lat < 21.819218f)
                            return 407;
                        else
                        {
                            if (poly[652].contains(lat,lng)) return 384;
                            else return 407;
                        }
                    else
                    if (lng < -102.505865f)
                        if (lat < 22.582341f)
                            if (lng < -104.208678f)
                            {
                                if (poly[653].contains(lat,lng)) return 34;
                                if (poly[654].contains(lat,lng)) return 192;
                                if (poly[655].contains(lat,lng)) return 192;
                                if (poly[656].contains(lat,lng)) return 384;
                                if (poly[657].contains(lat,lng)) return 384;
                                else return 407;
                            }
                            else
                            {
                                if (poly[658].contains(lat,lng)) return 407;
                                else return 192;
                            }
                        else
                        {
                            if (poly[659].contains(lat,lng)) return 192;
                            if (poly[660].contains(lat,lng)) return 407;
                            if (poly[661].contains(lat,lng)) return 407;
                            else return 384;
                        }
                    else
                    if (lng < -101.403413f)
                    {
                        if (poly[662].contains(lat,lng)) return 384;
                        else return 192;
                    }
                    else
                    {
                        if (poly[663].contains(lat,lng)) return 384;
                        else return 192;
                    }
                else
                if (lng < -97.596219f)
                    if (lat < 24.653814f)
                        if (lng < -97.731384f)
                            if (lat < 22.513844f)
                            {
                                if (poly[664].contains(lat,lng)) return 384;
                                else return 192;
                            }
                            else
                            {
                                if (poly[665].contains(lat,lng)) return 192;
                                else return 384;
                            }
                        else
                        if (lat < 22.034286f)
                            return 192;
                        else
                            return 384;
                    else
                    if (lng < -101.085294f)
                    {
                        if (poly[666].contains(lat,lng)) return 384;
                        else return 192;
                    }
                    else
                        return 384;
                else
                    return 192;
            else
            if (lng < -101.222706f)
                if (lng < -108.038940f)
                    return 407;
                else
                if (lng < -101.585564f)
                    if (lng < -106.892400f)
                    {
                        if (poly[667].contains(lat,lng)) return 384;
                        else return 407;
                    }
                    else
                    {
                        if (poly[668].contains(lat,lng)) return 192;
                        else return 384;
                    }
                else
                if (lng < -101.332363f)
                {
                    if (poly[669].contains(lat,lng)) return 192;
                    else return 384;
                }
                else
                {
                    if (poly[670].contains(lat,lng)) return 192;
                    else return 384;
                }
            else
                return 384;
        else
        if (lng < -97.406975f)
            if (lat < 35.257645f)
                return call7(lat,lng);
            else
            if (lng < -108.883000f)
                if (lat < 37.340875f)
                    if (lng < -109.941851f)
                        if (lat < 36.299260f)
                            if (lng < -110.471276f)
                            {
                                if (poly[671].contains(lat,lng)) return 9;
                                if (poly[672].contains(lat,lng)) return 9;
                                else return 273;
                            }
                            else
                            {
                                if (poly[673].contains(lat,lng)) return 9;
                                if (poly[674].contains(lat,lng)) return 9;
                                if (poly[675].contains(lat,lng)) return 9;
                                else return 273;
                            }
                        else
                        {
                            if (poly[676].contains(lat,lng)) return 9;
                            if (poly[677].contains(lat,lng)) return 9;
                            else return 273;
                        }
                    else
                        return 273;
                else
                {
                    if (poly[678].contains(lat,lng)) return 227;
                    if (poly[679].contains(lat,lng)) return 227;
                    if (poly[680].contains(lat,lng)) return 273;
                    else return 308;
                }
            else
            if (lat < 47.575298f)
                if (lng < -103.093439f)
                    if (lng < -103.434273f)
                    {
                        if (poly[681].contains(lat,lng)) return 160;
                        else return 273;
                    }
                    else
                    {
                        if (poly[682].contains(lat,lng)) return 160;
                        else return 273;
                    }
                else
                if (lng < -102.432684f)
                    if (lat < 36.998989f)
                    {
                        if (poly[683].contains(lat,lng)) return 160;
                        else return 273;
                    }
                    else
                    {
                        if (poly[684].contains(lat,lng)) return 160;
                        else return 273;
                    }
                else
                if (lat < 41.416471f)
                {
                    if (poly[685].contains(lat,lng)) return 273;
                    else return 160;
                }
                else
                if (lat < 44.495885f)
                {
                    if (poly[686].contains(lat,lng)) return 273;
                    else return 160;
                }
                else
                if (lng < -99.919829f)
                    if (lat < 46.035592f)
                    {
                        if (poly[687].contains(lat,lng)) return 160;
                        else return 273;
                    }
                    else
                    if (lng < -101.176257f)
                        if (lat < 46.805445f)
                        {
                            if (poly[688].contains(lat,lng)) return 52;
                            if (poly[689].contains(lat,lng)) return 160;
                            else return 273;
                        }
                        else
                        {
                            if (poly[690].contains(lat,lng)) return 52;
                            if (poly[691].contains(lat,lng)) return 105;
                            if (poly[692].contains(lat,lng)) return 160;
                            if (poly[693].contains(lat,lng)) return 273;
                            else return 71;
                        }
                    else
                    {
                        if (poly[694].contains(lat,lng)) return 52;
                        if (poly[695].contains(lat,lng)) return 105;
                        if (poly[696].contains(lat,lng)) return 273;
                        else return 160;
                    }
                else
                    return 160;
            else
            if (lng < -103.610133f)
                if (lat < 48.997666f)
                {
                    if (poly[697].contains(lat,lng)) return 160;
                    if (poly[698].contains(lat,lng)) return 308;
                    else return 273;
                }
                else
                {
                    if (poly[699].contains(lat,lng)) return 74;
                    else return 308;
                }
            else
            if (lat < 47.674011f)
                if (lng < -102.711964f)
                {
                    if (poly[700].contains(lat,lng)) return 273;
                    else return 160;
                }
                else
                {
                    if (poly[701].contains(lat,lng)) return 273;
                    else return 160;
                }
            else
            if (lat < 48.994424f)
            {
                if (poly[702].contains(lat,lng)) return 308;
                else return 160;
            }
            else
            {
                if (poly[703].contains(lat,lng)) return 308;
                else return 284;
            }
        else
        if (lat < 27.880161f)
            if (lat < 25.959148f)
                if (lat < 25.643694f)
                {
                    if (poly[704].contains(lat,lng)) return 374;
                    else return 384;
                }
                else
                {
                    if (poly[705].contains(lat,lng)) return 160;
                    else return 374;
                }
            else
                return 160;
        else
        if (lat < 29.841980f)
            return 160;
        else
        {
            if (poly[706].contains(lat,lng)) return 284;
            if (poly[707].contains(lat,lng)) return 378;
            else return 160;
        }
    }

    private static int call10(float lat, float lng)
    {
        if (lat < 44.018513f)
            if (lng < -87.921288f)
                return 160;
            else
            if (lng < -84.575844f)
                if (lat < 30.474203f)
                    if (lng < -85.625534f)
                        return 160;
                    else
                    if (lat < 29.760227f)
                        return 165;
                    else
                    if (lng < -84.981323f)
                        if (lat < 30.444105f)
                        {
                            if (poly[708].contains(lat,lng)) return 165;
                            else return 160;
                        }
                        else
                        {
                            if (poly[709].contains(lat,lng)) return 165;
                            else return 160;
                        }
                    else
                        return 165;
                else
                if (lat < 38.929596f)
                    if (lat < 36.997822f)
                        if (lat < 33.736012f)
                        {
                            if (poly[710].contains(lat,lng)) return 165;
                            else return 160;
                        }
                        else
                        if (lng < -86.248566f)
                            return 160;
                        else
                        if (lat < 35.366917f)
                        {
                            if (poly[711].contains(lat,lng)) return 165;
                            else return 160;
                        }
                        else
                        if (lng < -85.412205f)
                            return 160;
                        else
                        if (lat < 36.182369f)
                        {
                            if (poly[712].contains(lat,lng)) return 165;
                            else return 160;
                        }
                        else
                        {
                            if (poly[713].contains(lat,lng)) return 110;
                            if (poly[714].contains(lat,lng)) return 160;
                            else return 165;
                        }
                    else
                    if (lng < -87.072258f)
                        if (lat < 37.963709f)
                            return 160;
                        else
                        if (lat < 38.446652f)
                        {
                            if (poly[715].contains(lat,lng)) return 54;
                            if (poly[716].contains(lat,lng)) return 309;
                            else return 160;
                        }
                        else
                        {
                            if (poly[717].contains(lat,lng)) return 54;
                            if (poly[718].contains(lat,lng)) return 89;
                            if (poly[719].contains(lat,lng)) return 160;
                            if (poly[720].contains(lat,lng)) return 160;
                            else return 309;
                        }
                    else
                    if (lng < -85.824051f)
                        if (lat < 37.963688f)
                        {
                            if (poly[721].contains(lat,lng)) return 90;
                            if (poly[722].contains(lat,lng)) return 130;
                            if (poly[723].contains(lat,lng)) return 165;
                            else return 160;
                        }
                        else
                        if (lng < -86.448154f)
                        {
                            if (poly[724].contains(lat,lng)) return 89;
                            if (poly[725].contains(lat,lng)) return 160;
                            if (poly[726].contains(lat,lng)) return 160;
                            if (poly[727].contains(lat,lng)) return 165;
                            if (poly[728].contains(lat,lng)) return 165;
                            if (poly[729].contains(lat,lng)) return 309;
                            if (poly[730].contains(lat,lng)) return 388;
                            else return 90;
                        }
                        else
                        if (lat < 38.446592f)
                        {
                            if (poly[731].contains(lat,lng)) return 89;
                            if (poly[732].contains(lat,lng)) return 90;
                            if (poly[733].contains(lat,lng)) return 130;
                            if (poly[734].contains(lat,lng)) return 160;
                            if (poly[735].contains(lat,lng)) return 388;
                            else return 165;
                        }
                        else
                        {
                            if (poly[736].contains(lat,lng)) return 130;
                            else return 89;
                        }
                    else
                    if (lat < 37.963709f)
                    {
                        if (poly[737].contains(lat,lng)) return 160;
                        else return 165;
                    }
                    else
                    {
                        if (poly[738].contains(lat,lng)) return 89;
                        if (poly[739].contains(lat,lng)) return 130;
                        if (poly[740].contains(lat,lng)) return 391;
                        else return 165;
                    }
                else
                if (lng < -86.466347f)
                    if (lat < 41.760455f)
                    {
                        if (poly[741].contains(lat,lng)) return 89;
                        if (poly[742].contains(lat,lng)) return 248;
                        if (poly[743].contains(lat,lng)) return 257;
                        else return 160;
                    }
                    else
                    if (lng < -87.550373f)
                        return 160;
                    else
                        return 93;
                else
                {
                    if (poly[744].contains(lat,lng)) return 89;
                    if (poly[745].contains(lat,lng)) return 165;
                    else return 93;
                }
            else
            if (lat < 41.697075f)
                return 165;
            else
            if (lng < -83.173058f)
                if (lat < 41.733951f)
                    if (lng < -83.446740f)
                    {
                        if (poly[746].contains(lat,lng)) return 165;
                        else return 93;
                    }
                    else
                        return 165;
                else
                    return 93;
            else
            if (lng < -82.407822f)
                if (lat < 41.829945f)
                    if (lng < -82.742973f)
                        return 165;
                    else
                        return 238;
                else
                {
                    if (poly[747].contains(lat,lng)) return 238;
                    else return 93;
                }
            else
            if (lat < 42.303441f)
                if (lng < -81.847701f)
                    return 238;
                else
                    return 165;
            else
                return 238;
        else
        if (lng < -86.503700f)
            if (lat < 47.860935f)
                if (lng < -90.438179f)
                    return 160;
                else
                if (lat < 45.424801f)
                    if (lng < -87.351521f)
                        if (lng < -87.652123f)
                            if (lat < 45.240341f)
                            {
                                if (poly[748].contains(lat,lng)) return 94;
                                if (poly[749].contains(lat,lng)) return 94;
                                if (poly[750].contains(lat,lng)) return 94;
                                else return 160;
                            }
                            else
                            {
                                if (poly[751].contains(lat,lng)) return 160;
                                else return 94;
                            }
                        else
                        if (lat < 44.970303f)
                            return 160;
                        else
                        if (lng < -87.580826f)
                        {
                            if (poly[752].contains(lat,lng)) return 160;
                            if (poly[753].contains(lat,lng)) return 160;
                            else return 94;
                        }
                        else
                        {
                            if (poly[754].contains(lat,lng)) return 160;
                            else return 94;
                        }
                    else
                        return 160;
                else
                if (lng < -87.267632f)
                    if (lat < 46.767605f)
                        if (lng < -88.852905f)
                        {
                            if (poly[755].contains(lat,lng)) return 93;
                            if (poly[756].contains(lat,lng)) return 160;
                            else return 94;
                        }
                        else
                        if (lng < -88.060268f)
                        {
                            if (poly[757].contains(lat,lng)) return 93;
                            if (poly[758].contains(lat,lng)) return 160;
                            else return 94;
                        }
                        else
                        {
                            if (poly[759].contains(lat,lng)) return 93;
                            if (poly[760].contains(lat,lng)) return 93;
                            if (poly[761].contains(lat,lng)) return 160;
                            else return 94;
                        }
                    else
                    if (lng < -89.863985f)
                        if (lat < 46.772694f)
                            return 93;
                        else
                            return 160;
                    else
                        return 93;
                else
                    return 93;
            else
            if (lng < -88.182213f)
                if (lng < -89.000000f)
                    if (lat < 48.175171f)
                        if (lng < -89.307442f)
                            if (lng < -89.505821f)
                                if (lng < -91.087389f)
                                {
                                    if (poly[762].contains(lat,lng)) return 223;
                                    else return 160;
                                }
                                else
                                {
                                    if (poly[763].contains(lat,lng)) return 223;
                                    if (poly[764].contains(lat,lng)) return 238;
                                    else return 160;
                                }
                            else
                                return 238;
                        else
                        if (lat < 47.993145f)
                            return 93;
                        else
                            return 238;
                    else
                    if (lng < -89.998705f)
                        if (lng < -91.732543f)
                            if (lat < 48.464100f)
                            {
                                if (poly[765].contains(lat,lng)) return 160;
                                if (poly[766].contains(lat,lng)) return 284;
                                else return 223;
                            }
                            else
                            {
                                if (poly[767].contains(lat,lng)) return 223;
                                else return 284;
                            }
                        else
                        if (lat < 49.000000f)
                        {
                            if (poly[768].contains(lat,lng)) return 160;
                            if (poly[769].contains(lat,lng)) return 238;
                            else return 223;
                        }
                        else
                        {
                            if (poly[770].contains(lat,lng)) return 284;
                            else return 238;
                        }
                    else
                    if (lat < 48.269608f)
                        return 238;
                    else
                    if (lat < 52.750000f)
                    {
                        if (poly[771].contains(lat,lng)) return 238;
                        else return 358;
                    }
                    else
                        return 284;
                else
                if (lng < -88.434196f)
                    if (lat < 48.185020f)
                        return 93;
                    else
                        return 238;
                else
                if (lat < 48.517834f)
                    if (lng < -88.375648f)
                        return 238;
                    else
                        return 93;
                else
                if (lat < 48.556038f)
                    return 238;
                else
                {
                    if (poly[772].contains(lat,lng)) return 335;
                    else return 238;
                }
            else
                return 238;
        else
        if (lng < -81.695793f)
            if (lng < -83.252220f)
                if (lat < 45.828533f)
                    return 93;
                else
                if (lat < 46.770527f)
                    if (lng < -84.597824f)
                        if (lng < -84.706245f)
                        {
                            if (poly[773].contains(lat,lng)) return 238;
                            else return 93;
                        }
                        else
                            return 93;
                    else
                    if (lng < -84.557343f)
                        if (lat < 46.441211f)
                            return 93;
                        else
                            return 238;
                    else
                    if (lng < -84.298393f)
                        if (lat < 45.987839f)
                            return 93;
                        else
                        {
                            if (poly[774].contains(lat,lng)) return 238;
                            else return 93;
                        }
                    else
                    {
                        if (poly[775].contains(lat,lng)) return 238;
                        else return 93;
                    }
                else
                    return 238;
            else
            if (lat < 45.048958f)
                if (lng < -82.802887f)
                    return 93;
                else
                    return 238;
            else
                return 238;
        else
        if (lat < 52.532292f)
            return 238;
        else
            return 137;
    }

    private static int call11(float lat, float lng)
    {
        if (lat < 47.560501f)
            if (lat < 39.177528f)
                if (lat < 35.928028f)
                    if (lng < -15.360811f)
                        if (lat < 28.585676f)
                            if (lat < 20.641302f)
                                return 33;
                            else
                            if (lat < 24.286565f)
                                if (lat < 21.330532f)
                                {
                                    if (poly[776].contains(lat,lng)) return 29;
                                    else return 33;
                                }
                                else
                                    return 29;
                            else
                                return 264;
                        else
                            return 63;
                    else
                    if (lng < -13.417682f)
                        if (lat < 27.131824f)
                        {
                            if (poly[777].contains(lat,lng)) return 33;
                            else return 29;
                        }
                        else
                            return 264;
                    else
                    if (lat < 27.298073f)
                        if (lng < 1.713168f)
                        {
                            if (poly[778].contains(lat,lng)) return 29;
                            if (poly[779].contains(lat,lng)) return 33;
                            if (poly[780].contains(lat,lng)) return 380;
                            else return 181;
                        }
                        else
                        {
                            if (poly[781].contains(lat,lng)) return 260;
                            else return 380;
                        }
                    else
                    if (lng < -5.275472f)
                        if (lat < 29.949635f)
                        {
                            if (poly[782].contains(lat,lng)) return 29;
                            if (poly[783].contains(lat,lng)) return 380;
                            else return 343;
                        }
                        else
                        {
                            if (poly[784].contains(lat,lng)) return 315;
                            else return 343;
                        }
                    else
                    if (lat < 35.690445f)
                        if (lng < 0.924000f)
                            if (lat < 31.494259f)
                            {
                                if (poly[785].contains(lat,lng)) return 343;
                                else return 380;
                            }
                            else
                            if (lng < -2.175736f)
                            {
                                if (poly[786].contains(lat,lng)) return 315;
                                if (poly[787].contains(lat,lng)) return 380;
                                if (poly[788].contains(lat,lng)) return 380;
                                else return 343;
                            }
                            else
                            {
                                if (poly[789].contains(lat,lng)) return 343;
                                else return 380;
                            }
                        else
                            return 380;
                    else
                        return 380;
                else
                if (lng < -7.828166f)
                    return 57;
                else
                if (lng < -0.467861f)
                    if (lng < -5.339639f)
                        if (lng < -6.933861f)
                        {
                            if (poly[790].contains(lat,lng)) return 57;
                            else return 334;
                        }
                        else
                        if (lng < -6.877555f)
                            return 334;
                        else
                        {
                            if (poly[791].contains(lat,lng)) return 405;
                            else return 334;
                        }
                    else
                        return 334;
                else
                if (lat < 37.093723f)
                    return 380;
                else
                    return 334;
            else
            if (lat < 43.791721f)
                if (lat < 42.254749f)
                    if (lng < -6.182694f)
                        if (lat < 42.145638f)
                            if (lng < -7.794903f)
                            {
                                if (poly[792].contains(lat,lng)) return 334;
                                else return 57;
                            }
                            else
                            if (lat < 40.661583f)
                            {
                                if (poly[793].contains(lat,lng)) return 334;
                                else return 57;
                            }
                            else
                            {
                                if (poly[794].contains(lat,lng)) return 57;
                                else return 334;
                            }
                        else
                            return 334;
                    else
                        return 334;
                else
                if (lng < 3.315139f)
                    if (lng < -8.847362f)
                        return 334;
                    else
                    if (lng < 1.780389f)
                        if (lng < -3.533486f)
                            return 334;
                        else
                        if (lng < -0.876549f)
                        {
                            if (poly[795].contains(lat,lng)) return 297;
                            else return 334;
                        }
                        else
                        {
                            if (poly[796].contains(lat,lng)) return 136;
                            if (poly[797].contains(lat,lng)) return 297;
                            if (poly[798].contains(lat,lng)) return 297;
                            else return 334;
                        }
                    else
                    {
                        if (poly[799].contains(lat,lng)) return 334;
                        if (poly[800].contains(lat,lng)) return 334;
                        else return 297;
                    }
                else
                    return 297;
            else
            if (lng < -0.597833f)
                return 297;
            else
            if (lat < 45.349019f)
                if (lat < 45.262008f)
                {
                    if (poly[801].contains(lat,lng)) return 271;
                    else return 297;
                }
                else
                {
                    if (poly[802].contains(lat,lng)) return 271;
                    else return 297;
                }
            else
            if (lng < 3.262819f)
                return 297;
            else
            if (lng < 5.193146f)
                return 297;
            else
            if (lat < 46.454760f)
            {
                if (poly[803].contains(lat,lng)) return 172;
                if (poly[804].contains(lat,lng)) return 172;
                if (poly[805].contains(lat,lng)) return 172;
                if (poly[806].contains(lat,lng)) return 271;
                else return 297;
            }
            else
            {
                if (poly[807].contains(lat,lng)) return 297;
                if (poly[808].contains(lat,lng)) return 297;
                else return 172;
            }
        else
        if (lng < -3.590778f)
            if (lng < -6.628972f)
                return 285;
            else
            if (lat < 48.755917f)
                return 297;
            else
            if (lat < 51.883221f)
                return 303;
            else
            if (lng < -6.040233f)
                return 285;
            else
                return 303;
        else
        if (lng < 0.689972f)
            if (lat < 49.871569f)
                if (lng < -2.702667f)
                    return 297;
                else
                if (lng < -2.450417f)
                    if (lat < 48.654946f)
                        return 297;
                    else
                        return 296;
                else
                if (lng < -2.351278f)
                    if (lat < 49.044780f)
                        return 296;
                    else
                        return 297;
                else
                if (lat < 49.265057f)
                {
                    if (poly[809].contains(lat,lng)) return 139;
                    else return 297;
                }
                else
                if (lng < -2.055792f)
                    return 296;
                else
                    return 297;
            else
                return 303;
        else
        if (lng < 1.759000f)
            if (lat < 50.950080f)
            {
                if (poly[810].contains(lat,lng)) return 303;
                if (poly[811].contains(lat,lng)) return 303;
                else return 297;
            }
            else
                return 303;
        else
        if (lat < 51.770695f)
            if (lat < 51.505444f)
                if (lng < 4.441236f)
                    if (lat < 49.532972f)
                        return 297;
                    else
                    if (lng < 3.100118f)
                    {
                        if (poly[812].contains(lat,lng)) return 254;
                        else return 297;
                    }
                    else
                    if (lat < 50.519208f)
                    {
                        if (poly[813].contains(lat,lng)) return 254;
                        if (poly[814].contains(lat,lng)) return 254;
                        else return 297;
                    }
                    else
                    {
                        if (poly[815].contains(lat,lng)) return 254;
                        if (poly[816].contains(lat,lng)) return 297;
                        if (poly[817].contains(lat,lng)) return 297;
                        else return 385;
                    }
                else
                if (lat < 49.532972f)
                {
                    if (poly[818].contains(lat,lng)) return 6;
                    if (poly[819].contains(lat,lng)) return 211;
                    if (poly[820].contains(lat,lng)) return 254;
                    else return 297;
                }
                else
                if (lng < 5.782354f)
                    if (lat < 50.519208f)
                    {
                        if (poly[821].contains(lat,lng)) return 211;
                        if (poly[822].contains(lat,lng)) return 211;
                        if (poly[823].contains(lat,lng)) return 297;
                        if (poly[824].contains(lat,lng)) return 297;
                        else return 254;
                    }
                    else
                    {
                        if (poly[825].contains(lat,lng)) return 254;
                        else return 385;
                    }
                else
                if (lat < 50.519208f)
                    if (lng < 6.452913f)
                        if (lat < 50.026090f)
                        {
                            if (poly[826].contains(lat,lng)) return 6;
                            if (poly[827].contains(lat,lng)) return 6;
                            if (poly[828].contains(lat,lng)) return 254;
                            if (poly[829].contains(lat,lng)) return 254;
                            if (poly[830].contains(lat,lng)) return 254;
                            if (poly[831].contains(lat,lng)) return 297;
                            else return 211;
                        }
                        else
                        {
                            if (poly[832].contains(lat,lng)) return 6;
                            if (poly[833].contains(lat,lng)) return 211;
                            else return 254;
                        }
                    else
                    {
                        if (poly[834].contains(lat,lng)) return 211;
                        else return 6;
                    }
                else
                {
                    if (poly[835].contains(lat,lng)) return 254;
                    if (poly[836].contains(lat,lng)) return 254;
                    if (poly[837].contains(lat,lng)) return 385;
                    else return 6;
                }
            else
            if (lng < 4.356167f)
                return 385;
            else
            {
                if (poly[838].contains(lat,lng)) return 6;
                else return 385;
            }
        else
        if (lng < 5.862928f)
            return 385;
        else
        {
            if (poly[839].contains(lat,lng)) return 6;
            else return 385;
        }
    }

    private static int call12(float lat, float lng)
    {
        if (lat < 47.060444f)
            if (lng < -66.343018f)
                if (lat < 44.229080f)
                    return 165;
                else
                if (lng < -67.827522f)
                    if (lng < -69.624689f)
                    {
                        if (poly[840].contains(lat,lng)) return 20;
                        else return 165;
                    }
                    else
                        return 165;
                else
                if (lng < -66.941940f)
                    if (lat < 44.620262f)
                        return 165;
                    else
                    if (lat < 45.028847f)
                    {
                        if (poly[841].contains(lat,lng)) return 77;
                        if (poly[842].contains(lat,lng)) return 77;
                        else return 165;
                    }
                    else
                    if (lng < -67.090355f)
                    {
                        if (poly[843].contains(lat,lng)) return 77;
                        else return 165;
                    }
                    else
                        return 77;
                else
                if (lat < 44.283012f)
                    return 118;
                else
                    return 77;
            else
            if (lat < 44.991669f)
                if (lat < 32.393833f)
                    return 256;
                else
                    return 118;
            else
            if (lng < -61.939835f)
                if (lng < -63.777946f)
                    if (lat < 46.279369f)
                        if (lat < 46.006592f)
                            if (lng < -64.992493f)
                                if (lat < 45.085256f)
                                    return 118;
                                else
                                {
                                    if (poly[844].contains(lat,lng)) return 118;
                                    else return 77;
                                }
                            else
                            if (lat < 45.387333f)
                                return 118;
                            else
                            {
                                if (poly[845].contains(lat,lng)) return 77;
                                else return 118;
                            }
                        else
                            return 77;
                    else
                    if (lng < -64.516182f)
                        return 77;
                    else
                        return 118;
                else
                    return 118;
            else
            if (lng < -60.897530f)
                return 118;
            else
            if (lat < 45.826886f)
                if (lng < -60.766365f)
                    return 118;
                else
                {
                    if (poly[846].contains(lat,lng)) return 81;
                    else return 118;
                }
            else
            if (lng < -60.311749f)
            {
                if (poly[847].contains(lat,lng)) return 81;
                if (poly[848].contains(lat,lng)) return 81;
                else return 118;
            }
            else
                return 81;
        else
        if (lng < -59.584435f)
            if (lat < 50.081348f)
                if (lat < 47.639160f)
                    if (lng < -64.803614f)
                        if (lng < -67.786521f)
                        {
                            if (poly[849].contains(lat,lng)) return 20;
                            if (poly[850].contains(lat,lng)) return 165;
                            else return 77;
                        }
                        else
                            return 77;
                    else
                        return 118;
                else
                if (lat < 48.065315f)
                    if (lng < -66.119873f)
                        if (lng < -66.526045f)
                            if (lng < -69.406061f)
                                return 20;
                            else
                            {
                                if (poly[851].contains(lat,lng)) return 77;
                                if (poly[852].contains(lat,lng)) return 77;
                                else return 20;
                            }
                        else
                        if (lng < -66.291616f)
                        {
                            if (poly[853].contains(lat,lng)) return 20;
                            else return 77;
                        }
                        else
                            return 77;
                    else
                    if (lng < -64.751419f)
                        if (lat < 47.945091f)
                            return 77;
                        else
                            return 20;
                    else
                    if (lng < -64.470963f)
                        return 77;
                    else
                        return 118;
                else
                    return 20;
            else
            if (lng < -63.049610f)
                if (lat < 50.567280f)
                    return 20;
                else
                if (lng < -66.638208f)
                {
                    if (poly[854].contains(lat,lng)) return 182;
                    else return 20;
                }
                else
                if (lng < -64.843909f)
                    if (lat < 51.732883f)
                    {
                        if (poly[855].contains(lat,lng)) return 182;
                        else return 20;
                    }
                    else
                    if (lng < -65.741058f)
                    {
                        if (poly[856].contains(lat,lng)) return 182;
                        else return 20;
                    }
                    else
                    {
                        if (poly[857].contains(lat,lng)) return 182;
                        else return 20;
                    }
                else
                if (lat < 51.732883f)
                {
                    if (poly[858].contains(lat,lng)) return 182;
                    else return 20;
                }
                else
                {
                    if (poly[859].contains(lat,lng)) return 182;
                    else return 20;
                }
            else
            if (lat < 50.218616f)
                if (lng < -61.578325f)
                    if (lng < -62.098534f)
                        return 20;
                    else
                    {
                        if (poly[860].contains(lat,lng)) return 243;
                        if (poly[861].contains(lat,lng)) return 243;
                        else return 20;
                    }
                else
                    return 243;
            else
            if (lat < 50.348381f)
                if (lng < -61.174600f)
                    if (lat < 50.275000f)
                        if (lng < -62.354403f)
                            return 20;
                        else
                        {
                            if (poly[862].contains(lat,lng)) return 243;
                            else return 20;
                        }
                    else
                    {
                        if (poly[863].contains(lat,lng)) return 243;
                        else return 20;
                    }
                else
                    return 243;
            else
            if (lat < 50.675139f)
            {
                if (poly[864].contains(lat,lng)) return 20;
                else return 243;
            }
            else
            {
                if (poly[865].contains(lat,lng)) return 182;
                else return 20;
            }
        else
        if (lat < 50.841103f)
            if (lng < -58.832348f)
                if (lat < 50.645809f)
                    if (lat < 48.753311f)
                        return 290;
                    else
                        return 243;
                else
                if (lng < -59.432320f)
                {
                    if (poly[866].contains(lat,lng)) return 243;
                    else return 20;
                }
                else
                    return 243;
            else
                return 290;
        else
        if (lng < -58.273293f)
            if (lat < 51.162445f)
                if (lng < -59.102900f)
                {
                    if (poly[867].contains(lat,lng)) return 20;
                    else return 243;
                }
                else
                    return 243;
            else
            if (lng < -58.370186f)
                if (lat < 51.204712f)
                    if (lng < -58.864370f)
                    {
                        if (poly[868].contains(lat,lng)) return 243;
                        else return 20;
                    }
                    else
                        return 243;
                else
                if (lat < 51.457100f)
                    if (lng < -58.647963f)
                    {
                        if (poly[869].contains(lat,lng)) return 243;
                        if (poly[870].contains(lat,lng)) return 243;
                        if (poly[871].contains(lat,lng)) return 243;
                        else return 20;
                    }
                    else
                    if (lat < 51.296436f)
                        return 243;
                    else
                    if (lng < -58.432500f)
                    {
                        if (poly[872].contains(lat,lng)) return 20;
                        else return 243;
                    }
                    else
                    {
                        if (poly[873].contains(lat,lng)) return 20;
                        else return 243;
                    }
                else
                {
                    if (poly[874].contains(lat,lng)) return 182;
                    else return 20;
                }
            else
            if (lat < 51.376093f)
                return 243;
            else
            if (lat < 51.456603f)
            {
                if (poly[875].contains(lat,lng)) return 20;
                else return 243;
            }
            else
            {
                if (poly[876].contains(lat,lng)) return 182;
                else return 20;
            }
        else
        if (lat < 51.395161f)
            if (lng < -57.116951f)
                return 243;
            else
                return 290;
        else
        if (lat < 51.401176f)
            return 243;
        else
        if (lng < -57.687763f)
            if (lat < 51.446266f)
                return 243;
            else
            if (lat < 51.588950f)
            {
                if (poly[877].contains(lat,lng)) return 20;
                else return 243;
            }
            else
            {
                if (poly[878].contains(lat,lng)) return 182;
                else return 20;
            }
        else
        if (lat < 51.465385f)
            if (lng < -57.257164f)
                return 243;
            else
            if (lng < -57.096817f)
            {
                if (poly[879].contains(lat,lng)) return 290;
                else return 243;
            }
            else
                return 290;
        else
        {
            if (poly[880].contains(lat,lng)) return 20;
            if (poly[881].contains(lat,lng)) return 182;
            if (poly[882].contains(lat,lng)) return 290;
            else return 243;
        }
    }

    private static int call13(float lat, float lng)
    {
        if (lng < -79.668747f)
            if (lng < -92.267200f)
                if (lng < -123.252068f)
                    if (lat < 51.088554f)
                        if (lat < 48.589012f)
                            if (lat < 26.074541f)
                                return 244;
                            else
                            if (lat < 46.253250f)
                                if (lng < -177.319321f)
                                    return 196;
                                else
                                    return 39;
                            else
                            if (lat < 46.976349f)
                                return 39;
                            else
                            if (lat < 48.394943f)
                            {
                                if (poly[883].contains(lat,lng)) return 45;
                                else return 39;
                            }
                            else
                                return 45;
                        else
                            return 45;
                    else
                    if (lng < -131.767334f)
                        if (lng < -169.674606f)
                            return 158;
                        else
                        if (lng < -168.881073f)
                            return 134;
                        else
                            return 45;
                    else
                        return 45;
                else
                if (lng < -111.000702f)
                    return call8(lat,lng);
                else
                    return call9(lat,lng);
            else
            if (lat < 29.388796f)
                if (lat < 24.771822f)
                    if (lat < 22.785154f)
                        if (lng < -86.703392f)
                            if (lng < -87.539192f)
                                if (lng < -89.633240f)
                                    return 32;
                                else
                                {
                                    if (poly[884].contains(lat,lng)) return 401;
                                    else return 32;
                                }
                            else
                                return 401;
                        else
                            return 376;
                    else
                    if (lat < 23.239244f)
                        return 376;
                    else
                    if (lat < 24.000000f)
                        if (lng < -80.865501f)
                            return 376;
                        else
                            return 281;
                    else
                        return 165;
                else
                if (lng < -88.995483f)
                    return 160;
                else
                    return 165;
            else
                return call10(lat,lng);
        else
        if (lng < -69.652000f)
            if (lat < 25.591423f)
                if (lat < 23.625103f)
                    if (lng < -77.591835f)
                        return 376;
                    else
                    if (lat < 22.128616f)
                        if (lng < -72.914970f)
                            if (lng < -74.517632f)
                                return 376;
                            else
                                return 281;
                        else
                            return 103;
                    else
                        return 281;
                else
                    return 281;
            else
            if (lat < 37.677757f)
                if (lat < 27.217571f)
                    return 281;
                else
                if (lat < 27.232027f)
                    return 281;
                else
                    return 165;
            else
            if (lat < 42.831356f)
                return 165;
            else
            if (lat < 47.366436f)
                if (lat < 44.056385f)
                    if (lng < -76.605095f)
                        if (lat < 43.433300f)
                        {
                            if (poly[885].contains(lat,lng)) return 238;
                            else return 165;
                        }
                        else
                            return 238;
                    else
                        return 165;
                else
                if (lat < 44.366348f)
                    if (lng < -76.498672f)
                        return 238;
                    else
                    if (lat < 44.198559f)
                        if (lng < -76.328499f)
                        {
                            if (poly[886].contains(lat,lng)) return 165;
                            else return 238;
                        }
                        else
                            return 165;
                    else
                    if (lng < -76.185989f)
                        if (lat < 44.210916f)
                            if (lng < -76.250479f)
                                return 165;
                            else
                                return 238;
                        else
                            return 238;
                    else
                    if (lat < 44.310806f)
                        return 165;
                    else
                    {
                        if (poly[887].contains(lat,lng)) return 238;
                        if (poly[888].contains(lat,lng)) return 238;
                        else return 165;
                    }
                else
                if (lng < -74.322990f)
                    if (lat < 44.438393f)
                        if (lng < -75.882416f)
                            if (lat < 44.368198f)
                                if (lng < -75.948382f)
                                    return 165;
                                else
                                    return 238;
                            else
                                return 238;
                        else
                        if (lng < -75.846375f)
                            if (lat < 44.395919f)
                                return 165;
                            else
                                return 238;
                        else
                            return 165;
                    else
                    if (lat < 45.189449f)
                    {
                        if (poly[889].contains(lat,lng)) return 20;
                        if (poly[890].contains(lat,lng)) return 238;
                        else return 165;
                    }
                    else
                    {
                        if (poly[891].contains(lat,lng)) return 20;
                        else return 238;
                    }
                else
                if (lng < -70.717628f)
                    if (lat < 45.422798f)
                        if (lng < -70.752113f)
                        {
                            if (poly[892].contains(lat,lng)) return 20;
                            else return 165;
                        }
                        else
                        {
                            if (poly[893].contains(lat,lng)) return 20;
                            else return 165;
                        }
                    else
                        return 20;
                else
                if (lat < 47.033193f)
                {
                    if (poly[894].contains(lat,lng)) return 165;
                    else return 20;
                }
                else
                    return 20;
            else
            if (lat < 52.114346f)
                if (lng < -78.852051f)
                    if (lat < 51.836979f)
                        if (lng < -79.051132f)
                            if (lat < 51.665241f)
                                if (lng < -79.509407f)
                                    if (lat < 51.471649f)
                                        if (lat < 47.537216f)
                                        {
                                            if (poly[895].contains(lat,lng)) return 20;
                                            else return 238;
                                        }
                                        else
                                        {
                                            if (poly[896].contains(lat,lng)) return 20;
                                            else return 238;
                                        }
                                    else
                                        return 20;
                                else
                                {
                                    if (poly[897].contains(lat,lng)) return 137;
                                    else return 20;
                                }
                            else
                                return 137;
                        else
                            return 20;
                    else
                    if (lng < -78.941681f)
                        return 137;
                    else
                    if (lat < 51.943222f)
                        return 20;
                    else
                        return 137;
                else
                    return 20;
            else
            if (lng < -78.946602f)
                return 137;
            else
            if (lat < 52.447598f)
                if (lng < -78.703720f)
                    return 137;
                else
                if (lat < 52.395023f)
                {
                    if (poly[898].contains(lat,lng)) return 137;
                    else return 20;
                }
                else
                if (lng < -78.558243f)
                    return 20;
                else
                    return 137;
            else
            if (lng < -78.775826f)
                if (lat < 52.728059f)
                    return 20;
                else
                if (lat < 52.776230f)
                    if (lng < -78.855316f)
                        if (lat < 52.752114f)
                            return 20;
                        else
                            return 137;
                    else
                    {
                        if (poly[899].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                    return 20;
            else
            if (lng < -78.753601f)
                if (lat < 52.665272f)
                    if (lat < 52.558494f)
                        return 20;
                    else
                    {
                        if (poly[900].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                    return 20;
            else
            {
                if (poly[901].contains(lat,lng)) return 137;
                else return 20;
            }
        else
        if (lng < -56.718918f)
            return call12(lat,lng);
        else
        if (lng < -17.721861f)
            if (lat < 47.258224f)
                if (lat < 39.531334f)
                    if (lng < -25.015833f)
                        return 283;
                    else
                        return 264;
                else
                if (lng < -54.807180f)
                    if (lng < -56.166119f)
                        return 92;
                    else
                        return 290;
                else
                if (lng < -52.813107f)
                    return 290;
                else
                    return 283;
            else
                return 290;
        else
            return call11(lat,lng);
    }

    private static int call14(float lat, float lng)
    {
        if (lng < -131.905807f)
            if (lat < 56.000004f)
                if (lat < 54.686905f)
                    if (lat < 54.256939f)
                        return 45;
                    else
                        return 23;
                else
                    return 23;
            else
            if (lat < 56.786789f)
                return 23;
            else
            if (lat < 57.121727f)
                if (lng < -133.828668f)
                    if (lng < -134.365097f)
                        if (lng < -134.656831f)
                            return 23;
                        else
                        if (lat < 56.935338f)
                            return 23;
                        else
                            return 359;
                    else
                        return 23;
                else
                if (lng < -132.799744f)
                    return 23;
                else
                {
                    if (poly[902].contains(lat,lng)) return 45;
                    else return 23;
                }
            else
            if (lat < 57.559906f)
                if (lng < -133.791367f)
                    return 359;
                else
                {
                    if (poly[903].contains(lat,lng)) return 23;
                    if (poly[904].contains(lat,lng)) return 45;
                    else return 359;
                }
            else
            if (lat < 57.895130f)
                if (lng < -133.146686f)
                    return 359;
                else
                if (lng < -133.143158f)
                    return 359;
                else
                {
                    if (poly[905].contains(lat,lng)) return 45;
                    else return 359;
                }
            else
            if (lat < 60.000000f)
                if (lng < -133.977960f)
                    if (lat < 58.412121f)
                        return 359;
                    else
                    {
                        if (poly[906].contains(lat,lng)) return 45;
                        else return 359;
                    }
                else
                {
                    if (poly[907].contains(lat,lng)) return 45;
                    else return 359;
                }
            else
                return 324;
        else
        if (lat < 54.191448f)
            if (lng < -127.544479f)
                return 45;
            else
            if (lng < -118.607060f)
            {
                if (poly[908].contains(lat,lng)) return 116;
                if (poly[909].contains(lat,lng)) return 227;
                else return 45;
            }
            else
            if (lng < -118.465407f)
            {
                if (poly[910].contains(lat,lng)) return 45;
                else return 227;
            }
            else
            {
                if (poly[911].contains(lat,lng)) return 308;
                if (poly[912].contains(lat,lng)) return 308;
                else return 227;
            }
        else
        if (lng < -130.888184f)
            if (lat < 55.457150f)
                if (lng < -131.176437f)
                    if (lat < 55.110420f)
                        if (lng < -131.351639f)
                            if (lat < 54.977901f)
                                return 23;
                            else
                            {
                                if (poly[913].contains(lat,lng)) return 23;
                                else return 195;
                            }
                        else
                            return 23;
                    else
                    if (lat < 55.283344f)
                        if (lng < -131.628221f)
                            return 23;
                        else
                        if (lng < -131.328003f)
                            if (lat < 55.190212f)
                                return 195;
                            else
                            {
                                if (poly[914].contains(lat,lng)) return 195;
                                else return 23;
                            }
                        else
                            return 23;
                    else
                        return 23;
                else
                if (lat < 54.626297f)
                    return 45;
                else
                    return 23;
            else
            if (lat < 55.990891f)
                return 23;
            else
            if (lat < 60.000000f)
            {
                if (poly[915].contains(lat,lng)) return 45;
                else return 23;
            }
            else
                return 324;
        else
        if (lng < -130.147552f)
            if (lat < 54.663948f)
                return 45;
            else
            if (lat < 55.027081f)
                if (lng < -130.246087f)
                    if (lng < -130.681854f)
                        return 23;
                    else
                    if (lng < -130.429123f)
                        if (lat < 54.759205f)
                        {
                            if (poly[916].contains(lat,lng)) return 23;
                            else return 45;
                        }
                        else
                        if (lng < -130.630005f)
                            return 23;
                        else
                        if (lat < 54.770226f)
                            return 45;
                        else
                        {
                            if (poly[917].contains(lat,lng)) return 45;
                            if (poly[918].contains(lat,lng)) return 45;
                            else return 23;
                        }
                    else
                    if (lat < 54.778793f)
                        return 45;
                    else
                    {
                        if (poly[919].contains(lat,lng)) return 23;
                        else return 45;
                    }
                else
                    return 45;
            else
            if (lat < 60.000000f)
                if (lat < 55.116245f)
                    if (lng < -130.180752f)
                        return 23;
                    else
                        return 45;
                else
                {
                    if (poly[920].contains(lat,lng)) return 45;
                    else return 23;
                }
            else
                return 324;
        else
        if (lng < -129.451582f)
            if (lat < 55.063297f)
                return 45;
            else
            if (lat < 55.692310f)
                if (lng < -129.989868f)
                    if (lat < 55.250920f)
                    {
                        if (poly[921].contains(lat,lng)) return 23;
                        else return 45;
                    }
                    else
                    {
                        if (poly[922].contains(lat,lng)) return 23;
                        else return 45;
                    }
                else
                    return 45;
            else
            if (lat < 60.000000f)
            {
                if (poly[923].contains(lat,lng)) return 23;
                else return 45;
            }
            else
                return 324;
        else
        if (lat < 60.000000f)
            if (lng < -129.253204f)
                return 45;
            else
            if (lng < -110.000000f)
                if (lng < -120.000000f)
                    if (lng < -124.626602f)
                        return 45;
                    else
                    if (lat < 57.095724f)
                        if (lng < -122.313301f)
                            if (lat < 55.643586f)
                            {
                                if (poly[924].contains(lat,lng)) return 116;
                                else return 45;
                            }
                            else
                            {
                                if (poly[925].contains(lat,lng)) return 116;
                                else return 45;
                            }
                        else
                        if (lat < 55.643586f)
                        {
                            if (poly[926].contains(lat,lng)) return 45;
                            else return 116;
                        }
                        else
                        {
                            if (poly[927].contains(lat,lng)) return 45;
                            else return 116;
                        }
                    else
                    {
                        if (poly[928].contains(lat,lng)) return 116;
                        if (poly[929].contains(lat,lng)) return 116;
                        if (poly[930].contains(lat,lng)) return 116;
                        else return 45;
                    }
                else
                    return 227;
            else
                return 308;
        else
        {
            if (poly[931].contains(lat,lng)) return 324;
            else return 142;
        }
    }

    private static int call15(float lat, float lng)
    {
        if (lng < -123.791763f)
            if (lng < -141.000000f)
                if (lng < -162.000000f)
                    if (lng < -168.892441f)
                        if (lng < -174.074051f)
                            return 365;
                        else
                        if (lat < 64.842125f)
                            if (lat < 63.787884f)
                                return 134;
                            else
                                return 365;
                        else
                        if (lng < -169.002365f)
                            return 365;
                        else
                            return 134;
                    else
                        return 134;
                else
                    return 370;
            else
            if (lat < 69.665329f)
                if (lng < -135.200684f)
                    if (lat < 69.206284f)
                        if (lat < 68.963966f)
                            if (lng < -136.526718f)
                                if (lng < -139.361644f)
                                {
                                    if (poly[932].contains(lat,lng)) return 330;
                                    else return 324;
                                }
                                else
                                    return 324;
                            else
                            {
                                if (poly[933].contains(lat,lng)) return 324;
                                else return 142;
                            }
                        else
                        if (lng < -137.210114f)
                            return 324;
                        else
                            return 142;
                    else
                    if (lng < -138.279434f)
                        return 324;
                    else
                        return 142;
                else
                if (lat < 68.416974f)
                    if (lat < 67.004977f)
                        if (lng < -129.496223f)
                            if (lat < 63.808471f)
                            {
                                if (poly[934].contains(lat,lng)) return 142;
                                if (poly[935].contains(lat,lng)) return 142;
                                else return 324;
                            }
                            else
                            if (lng < -132.348454f)
                                if (lat < 65.406724f)
                                {
                                    if (poly[936].contains(lat,lng)) return 142;
                                    if (poly[937].contains(lat,lng)) return 142;
                                    else return 324;
                                }
                                else
                                {
                                    if (poly[938].contains(lat,lng)) return 324;
                                    else return 142;
                                }
                            else
                            {
                                if (poly[939].contains(lat,lng)) return 324;
                                if (poly[940].contains(lat,lng)) return 324;
                                if (poly[941].contains(lat,lng)) return 324;
                                if (poly[942].contains(lat,lng)) return 324;
                                else return 142;
                            }
                        else
                        if (lat < 63.808471f)
                            if (lng < -126.643993f)
                            {
                                if (poly[943].contains(lat,lng)) return 324;
                                if (poly[944].contains(lat,lng)) return 324;
                                else return 142;
                            }
                            else
                            {
                                if (poly[945].contains(lat,lng)) return 324;
                                else return 142;
                            }
                        else
                            return 142;
                    else
                    {
                        if (poly[946].contains(lat,lng)) return 142;
                        if (poly[947].contains(lat,lng)) return 142;
                        else return 56;
                    }
                else
                    return 142;
            else
                return 142;
        else
        if (lat < 68.452187f)
            if (lng < -109.338089f)
                if (lng < -113.141373f)
                    if (lng < -114.096313f)
                        if (lng < -114.526794f)
                            if (lng < -114.826683f)
                                if (lng < -114.954285f)
                                {
                                    if (poly[948].contains(lat,lng)) return 142;
                                    else return 108;
                                }
                                else
                                if (lat < 66.009722f)
                                {
                                    if (poly[949].contains(lat,lng)) return 108;
                                    else return 142;
                                }
                                else
                                    return 108;
                            else
                            if (lat < 65.964136f)
                            {
                                if (poly[950].contains(lat,lng)) return 108;
                                else return 142;
                            }
                            else
                                return 108;
                        else
                        if (lat < 65.857001f)
                        {
                            if (poly[951].contains(lat,lng)) return 108;
                            else return 142;
                        }
                        else
                            return 108;
                    else
                    if (lat < 65.703211f)
                    {
                        if (poly[952].contains(lat,lng)) return 108;
                        else return 142;
                    }
                    else
                        return 108;
                else
                if (lat < 65.481310f)
                {
                    if (poly[953].contains(lat,lng)) return 108;
                    else return 142;
                }
                else
                    return 108;
            else
            if (lat < 66.829147f)
                if (lat < 64.649325f)
                {
                    if (poly[954].contains(lat,lng)) return 108;
                    else return 142;
                }
                else
                    return 108;
            else
                return 108;
        else
        if (lat < 72.171257f)
            if (lat < 70.471046f)
                if (lng < -113.461769f)
                    if (lng < -113.989479f)
                        if (lat < 68.929214f)
                            if (lng < -121.789716f)
                            {
                                if (poly[955].contains(lat,lng)) return 108;
                                else return 142;
                            }
                            else
                                return 108;
                        else
                        if (lng < -117.239929f)
                            if (lat < 69.666817f)
                            {
                                if (poly[956].contains(lat,lng)) return 108;
                                else return 142;
                            }
                            else
                                return 142;
                        else
                        if (lat < 69.653069f)
                            return 108;
                        else
                        {
                            if (poly[957].contains(lat,lng)) return 108;
                            else return 142;
                        }
                    else
                    if (lat < 69.212112f)
                        return 108;
                    else
                    {
                        if (poly[958].contains(lat,lng)) return 142;
                        else return 108;
                    }
                else
                if (lat < 68.873958f)
                    return 108;
                else
                if (lng < -112.620987f)
                    if (lat < 70.034142f)
                    {
                        if (poly[959].contains(lat,lng)) return 142;
                        else return 108;
                    }
                    else
                        return 142;
                else
                if (lng < -112.567856f)
                    if (lat < 69.785159f)
                    {
                        if (poly[960].contains(lat,lng)) return 142;
                        else return 108;
                    }
                    else
                        return 142;
                else
                {
                    if (poly[961].contains(lat,lng)) return 108;
                    else return 142;
                }
            else
            if (lng < -109.971375f)
                return 142;
            else
                return 108;
        else
        if (lng < -109.972572f)
            return 142;
        else
        if (lng < -109.971375f)
            return 142;
        else
            return 108;
    }

    private static int call16(float lat, float lng)
    {
        if (lat < 57.616158f)
            if (lat < 56.072720f)
                if (lat < 54.708080f)
                    if (lat < 53.544559f)
                        if (lng < -79.220665f)
                            return 137;
                        else
                        if (lat < 53.295464f)
                            if (lng < -79.004341f)
                                return 137;
                            else
                            if (lng < -78.951660f)
                                if (lat < 53.037329f)
                                    if (lat < 52.940544f)
                                        return 137;
                                    else
                                        return 20;
                                else
                                if (lng < -78.976112f)
                                    if (lat < 53.180402f)
                                        return 20;
                                    else
                                        return 137;
                                else
                                    return 20;
                            else
                            if (lng < -78.911201f)
                                if (lat < 52.978027f)
                                    if (lat < 52.914364f)
                                        return 20;
                                    else
                                        return 137;
                                else
                                    return 20;
                            else
                            {
                                if (poly[962].contains(lat,lng)) return 137;
                                else return 20;
                            }
                        else
                        if (lat < 53.413036f)
                            if (lng < -79.010345f)
                                if (lat < 53.361423f)
                                    return 137;
                                else
                                {
                                    if (poly[963].contains(lat,lng)) return 137;
                                    else return 20;
                                }
                            else
                            if (lng < -78.996750f)
                                return 137;
                            else
                            if (lng < -78.969765f)
                                if (lat < 53.309853f)
                                    return 137;
                                else
                                    return 20;
                            else
                            {
                                if (poly[964].contains(lat,lng)) return 137;
                                else return 20;
                            }
                        else
                        if (lng < -79.115227f)
                            if (lat < 53.459244f)
                                return 20;
                            else
                                return 137;
                        else
                        if (lat < 53.434547f)
                            if (lng < -79.082458f)
                                return 137;
                            else
                                return 20;
                        else
                        {
                            if (poly[965].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lat < 54.116554f)
                        if (lng < -79.182358f)
                            return 137;
                        else
                        if (lat < 53.833500f)
                            if (lng < -79.100655f)
                                return 137;
                            else
                            if (lat < 53.552872f)
                                return 20;
                            else
                            {
                                if (poly[966].contains(lat,lng)) return 137;
                                else return 20;
                            }
                        else
                        if (lng < -79.174927f)
                            return 137;
                        else
                        if (lat < 53.874668f)
                            if (lng < -79.087925f)
                                return 20;
                            else
                                return 137;
                        else
                        {
                            if (poly[967].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lat < 54.247169f)
                        if (lng < -79.412979f)
                            return 137;
                        else
                        if (lng < -79.237053f)
                            if (lat < 54.174984f)
                            {
                                if (poly[968].contains(lat,lng)) return 137;
                                else return 20;
                            }
                            else
                                return 20;
                        else
                        {
                            if (poly[969].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lat < 54.416172f)
                        if (lng < -79.520157f)
                            return 137;
                        else
                        {
                            if (poly[970].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lat < 54.467125f)
                        if (lng < -79.543602f)
                            return 20;
                        else
                            return 137;
                    else
                    if (lng < -79.566742f)
                        if (lat < 54.554594f)
                            return 20;
                        else
                        if (lat < 54.600740f)
                            return 20;
                        else
                            return 137;
                    else
                    {
                        if (poly[971].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                if (lat < 55.653851f)
                    if (lat < 54.798294f)
                        if (lng < -79.658430f)
                            return 137;
                        else
                        if (lng < -79.557785f)
                            if (lat < 54.722511f)
                            {
                                if (poly[972].contains(lat,lng)) return 137;
                                else return 20;
                            }
                            else
                                return 137;
                        else
                        if (lat < 54.768631f)
                        {
                            if (poly[973].contains(lat,lng)) return 20;
                            else return 137;
                        }
                        else
                        if (lng < -79.384746f)
                            return 20;
                        else
                            return 137;
                    else
                    if (lng < -79.441200f)
                        return 137;
                    else
                    if (lng < -77.706451f)
                        if (lat < 55.322748f)
                        {
                            if (poly[974].contains(lat,lng)) return 137;
                            else return 20;
                        }
                        else
                            return 137;
                    else
                    if (lng < -77.671234f)
                        if (lat < 55.371513f)
                            return 20;
                        else
                            return 137;
                    else
                    {
                        if (poly[975].contains(lat,lng)) return 20;
                        else return 137;
                    }
                else
                if (lng < -78.680573f)
                    return 137;
                else
                {
                    if (poly[976].contains(lat,lng)) return 137;
                    else return 20;
                }
            else
            if (lng < -76.914421f)
                return 137;
            else
            if (lat < 56.715569f)
                if (lng < -76.714203f)
                    return 137;
                else
                if (lat < 56.383667f)
                    if (lat < 56.352753f)
                    {
                        if (poly[977].contains(lat,lng)) return 137;
                        else return 20;
                    }
                    else
                    if (lng < -76.608892f)
                        return 20;
                    else
                        return 137;
                else
                if (lng < -76.620346f)
                    return 137;
                else
                    return 20;
            else
            if (lat < 57.060780f)
                if (lng < -76.620895f)
                    return 137;
                else
                    return 20;
            else
            if (lat < 57.274315f)
                if (lng < -76.650459f)
                    return 137;
                else
                    return 20;
            else
            if (lng < -76.866554f)
                if (lat < 57.600049f)
                    return 20;
                else
                    return 137;
            else
            {
                if (poly[978].contains(lat,lng)) return 137;
                else return 20;
            }
        else
        if (lat < 60.192261f)
            if (lng < -78.628052f)
                return 137;
            else
            if (lat < 58.644310f)
                if (lat < 58.337955f)
                    if (lat < 58.169769f)
                        if (lng < -78.124222f)
                            return 137;
                        else
                        if (lng < -77.527397f)
                        {
                            if (poly[979].contains(lat,lng)) return 20;
                            else return 137;
                        }
                        else
                        if (lng < -77.205544f)
                            if (lat < 58.004467f)
                                return 20;
                            else
                            {
                                if (poly[980].contains(lat,lng)) return 137;
                                else return 20;
                            }
                        else
                        {
                            if (poly[981].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lng < -77.701317f)
                        if (lat < 58.276955f)
                            return 137;
                        else
                        {
                            if (poly[982].contains(lat,lng)) return 20;
                            else return 137;
                        }
                    else
                    {
                        if (poly[983].contains(lat,lng)) return 137;
                        if (poly[984].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                if (lng < -78.495689f)
                    if (lng < -78.583992f)
                        return 137;
                    else
                    if (lat < 58.579838f)
                        return 137;
                    else
                    {
                        if (poly[985].contains(lat,lng)) return 20;
                        else return 137;
                    }
                else
                if (lng < -78.293175f)
                    if (lat < 58.508587f)
                        return 137;
                    else
                        return 20;
                else
                if (lat < 58.369335f)
                {
                    if (poly[986].contains(lat,lng)) return 137;
                    else return 20;
                }
                else
                if (lat < 58.411152f)
                    if (lng < -78.077976f)
                        return 20;
                    else
                        return 137;
                else
                {
                    if (poly[987].contains(lat,lng)) return 137;
                    else return 20;
                }
            else
            if (lat < 59.110462f)
                if (lng < -78.562523f)
                    if (lat < 58.697945f)
                        return 20;
                    else
                    if (lat < 58.829868f)
                        if (lng < -78.599251f)
                            return 137;
                        else
                        if (lat < 58.795967f)
                        {
                            if (poly[988].contains(lat,lng)) return 137;
                            else return 20;
                        }
                        else
                            return 137;
                    else
                    {
                        if (poly[989].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                if (lng < -78.392517f)
                    if (lat < 58.776039f)
                        if (lng < -78.530769f)
                            if (lat < 58.697453f)
                                return 20;
                            else
                            {
                                if (poly[990].contains(lat,lng)) return 137;
                                else return 20;
                            }
                        else
                            return 20;
                    else
                    {
                        if (poly[991].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                if (lng < -78.187141f)
                    if (lng < -78.310013f)
                        if (lat < 58.976772f)
                            return 20;
                        else
                        if (lat < 59.015853f)
                            return 20;
                        else
                            return 137;
                    else
                    {
                        if (poly[992].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                    return 20;
            else
            if (lng < -77.730873f)
                if (lat < 59.389897f)
                {
                    if (poly[993].contains(lat,lng)) return 137;
                    else return 20;
                }
                else
                if (lat < 59.555698f)
                {
                    if (poly[994].contains(lat,lng)) return 137;
                    else return 20;
                }
                else
                if (lat < 59.722752f)
                    return 20;
                else
                    return 137;
            else
            if (lng < -77.626198f)
                if (lat < 59.736664f)
                    if (lat < 59.691815f)
                        return 20;
                    else
                        return 137;
                else
                    return 20;
            else
            if (lng < -77.502136f)
                if (lat < 59.780479f)
                    if (lat < 59.706220f)
                        return 20;
                    else
                    {
                        if (poly[995].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                    return 20;
            else
            if (lat < 59.880760f)
            {
                if (poly[996].contains(lat,lng)) return 137;
                else return 20;
            }
            else
            {
                if (poly[997].contains(lat,lng)) return 137;
                else return 20;
            }
        else
        if (lat < 64.088704f)
            if (lat < 62.414604f)
                if (lat < 61.487820f)
                    if (lng < -77.790176f)
                        if (lng < -77.962517f)
                            if (lat < 60.775932f)
                                return 137;
                            else
                            if (lng < -78.257248f)
                                return 137;
                            else
                            if (lng < -78.080475f)
                            {
                                if (poly[998].contains(lat,lng)) return 137;
                                else return 20;
                            }
                            else
                                return 20;
                        else
                        if (lat < 60.744922f)
                            return 20;
                        else
                        if (lat < 60.768257f)
                            if (lng < -77.833070f)
                                return 20;
                            else
                                return 137;
                        else
                            return 20;
                    else
                    if (lat < 60.234997f)
                        if (lng < -77.638252f)
                            return 137;
                        else
                            return 20;
                    else
                    if (lng < -77.757133f)
                        if (lat < 61.259742f)
                            return 20;
                        else
                        {
                            if (poly[999].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lat < 60.274155f)
                        if (lng < -77.606060f)
                            return 20;
                        else
                            return 137;
                    else
                    {
                        if (poly[1000].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                if (lng < -78.011292f)
                    if (lng < -79.269890f)
                        return 137;
                    else
                    if (lat < 62.366461f)
                        return 20;
                    else
                        return 137;
                else
                if (lng < -77.801331f)
                    if (lat < 61.679256f)
                        return 137;
                    else
                        return 20;
                else
                if (lng < -77.754745f)
                    if (lat < 61.635977f)
                        return 20;
                    else
                        return 137;
                else
                    return 20;
            else
            if (lat < 63.518543f)
                if (lat < 62.585182f)
                    if (lng < -78.029663f)
                        return 137;
                    else
                    if (lat < 62.422283f)
                        return 20;
                    else
                    if (lng < -77.859993f)
                        if (lat < 62.488289f)
                            return 20;
                        else
                            return 137;
                    else
                    {
                        if (poly[1001].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                    return 137;
            else
            if (lng < -80.147430f)
                return 64;
            else
                return 137;
        else
            return 137;
    }

    private static int call17(float lat, float lng)
    {
        if (lat < 68.311264f)
            if (lng < -80.829857f)
                if (lng < -92.028229f)
                    if (lat < 67.171684f)
                        if (lat < 61.955357f)
                            if (lat < 61.434013f)
                                if (lat < 60.000000f)
                                    if (lng < -93.769402f)
                                        if (lng < -101.665837f)
                                        {
                                            if (poly[1002].contains(lat,lng)) return 308;
                                            else return 284;
                                        }
                                        else
                                        if (lat < 59.072639f)
                                            if (lng < -94.795906f)
                                            {
                                                if (poly[1003].contains(lat,lng)) return 307;
                                                else return 284;
                                            }
                                            else
                                            {
                                                if (poly[1004].contains(lat,lng)) return 307;
                                                else return 284;
                                            }
                                        else
                                        if (lat < 59.348492f)
                                            if (lng < -94.781494f)
                                            {
                                                if (poly[1005].contains(lat,lng)) return 307;
                                                else return 284;
                                            }
                                            else
                                                return 284;
                                        else
                                        {
                                            if (poly[1006].contains(lat,lng)) return 307;
                                            else return 284;
                                        }
                                    else
                                    if (lng < -93.572128f)
                                        if (lng < -93.629883f)
                                        {
                                            if (poly[1007].contains(lat,lng)) return 307;
                                            else return 284;
                                        }
                                        else
                                        if (lat < 58.785896f)
                                            return 284;
                                        else
                                            return 307;
                                    else
                                    if (lng < -92.852669f)
                                        if (lng < -93.029205f)
                                        {
                                            if (poly[1008].contains(lat,lng)) return 307;
                                            else return 284;
                                        }
                                        else
                                        {
                                            if (poly[1009].contains(lat,lng)) return 307;
                                            else return 284;
                                        }
                                    else
                                        return 284;
                                else
                                if (lng < -102.008194f)
                                    return 142;
                                else
                                    return 307;
                            else
                            if (lng < -102.008194f)
                                return 142;
                            else
                                return 307;
                        else
                        if (lng < -92.635559f)
                            if (lat < 62.243343f)
                                if (lng < -102.008194f)
                                    return 142;
                                else
                                    return 307;
                            else
                            if (lng < -93.469185f)
                                if (lng < -102.008194f)
                                {
                                    if (poly[1010].contains(lat,lng)) return 142;
                                    else return 108;
                                }
                                else
                                if (lat < 63.965088f)
                                    return 307;
                                else
                                {
                                    if (poly[1011].contains(lat,lng)) return 108;
                                    else return 307;
                                }
                            else
                            if (lat < 63.971210f)
                                return 307;
                            else
                            {
                                if (poly[1012].contains(lat,lng)) return 108;
                                else return 307;
                            }
                        else
                        if (lat < 63.815735f)
                            return 307;
                        else
                        {
                            if (poly[1013].contains(lat,lng)) return 108;
                            else return 307;
                        }
                    else
                        return 108;
                else
                if (lat < 65.453690f)
                    if (lng < -89.957558f)
                        if (lat < 57.251442f)
                            if (lng < -90.639900f)
                            {
                                if (poly[1014].contains(lat,lng)) return 307;
                                else return 284;
                            }
                            else
                            {
                                if (poly[1015].contains(lat,lng)) return 238;
                                else return 284;
                            }
                        else
                            return 307;
                    else
                    if (lng < -88.378349f)
                        if (lat < 56.984006f)
                            if (lat < 54.000000f)
                            {
                                if (poly[1016].contains(lat,lng)) return 284;
                                else return 238;
                            }
                            else
                            if (lng < -88.990593f)
                            {
                                if (poly[1017].contains(lat,lng)) return 284;
                                else return 238;
                            }
                            else
                            {
                                if (poly[1018].contains(lat,lng)) return 307;
                                else return 238;
                            }
                        else
                            return 307;
                    else
                    if (lat < 63.038517f)
                        if (lat < 55.199287f)
                            if (lng < -82.117599f)
                                if (lng < -82.722824f)
                                {
                                    if (poly[1019].contains(lat,lng)) return 137;
                                    else return 238;
                                }
                                else
                                    return 238;
                            else
                                return 137;
                        else
                        if (lat < 55.223709f)
                            return 238;
                        else
                        if (lat < 56.591577f)
                            if (lng < -83.479806f)
                                return 238;
                            else
                                return 137;
                        else
                            return 64;
                    else
                    if (lng < -86.900711f)
                        if (lat < 63.907318f)
                            return 64;
                        else
                            return 307;
                    else
                        return 64;
                else
                if (lng < -84.382332f)
                    if (lat < 66.466286f)
                        if (lng < -84.991508f)
                            if (lng < -88.369072f)
                                return 307;
                            else
                            if (lat < 66.086807f)
                                if (lng < -85.977935f)
                                {
                                    if (poly[1020].contains(lat,lng)) return 64;
                                    else return 307;
                                }
                                else
                                    return 64;
                            else
                                return 307;
                        else
                        if (lat < 65.950470f)
                            return 64;
                        else
                        if (lng < -84.818901f)
                            if (lat < 66.025795f)
                                return 64;
                            else
                                return 137;
                        else
                            return 137;
                    else
                    if (lng < -85.000000f)
                        if (lng < -89.000000f)
                            if (lat < 67.000000f)
                            {
                                if (poly[1021].contains(lat,lng)) return 108;
                                else return 307;
                            }
                            else
                                return 108;
                        else
                            return 307;
                    else
                        return 137;
                else
                    return 137;
            else
                return call16(lat,lng);
        else
        if (lat < 69.936737f)
            if (lng < -89.775421f)
                return 108;
            else
            if (lng < -85.000000f)
                if (lng < -89.000000f)
                    return 108;
                else
                    return 307;
            else
                return 137;
        else
        if (lat < 74.186783f)
            if (lng < -96.420212f)
                if (lat < 71.806007f)
                    return 108;
                else
                if (lng < -101.909744f)
                    return 108;
                else
                if (lat < 73.199013f)
                    if (lng < -100.585571f)
                        return 108;
                    else
                    if (lng < -98.208565f)
                        if (lat < 72.802119f)
                            return 108;
                        else
                        {
                            if (poly[1022].contains(lat,lng)) return 307;
                            if (poly[1023].contains(lat,lng)) return 307;
                            else return 108;
                        }
                    else
                    if (lat < 72.869066f)
                        if (lng < -96.998177f)
                        {
                            if (poly[1024].contains(lat,lng)) return 307;
                            else return 108;
                        }
                        else
                        if (lat < 72.679507f)
                        {
                            if (poly[1025].contains(lat,lng)) return 307;
                            else return 108;
                        }
                        else
                            return 307;
                    else
                        return 307;
                else
                    return 307;
            else
            if (lng < -85.000000f)
                if (lng < -90.483345f)
                    if (lat < 72.096191f)
                        return 108;
                    else
                    if (lat < 72.603363f)
                        if (lng < -95.507271f)
                            if (lng < -96.268059f)
                                return 108;
                            else
                                return 307;
                        else
                        if (lng < -95.335034f)
                            return 307;
                        else
                        {
                            if (poly[1026].contains(lat,lng)) return 108;
                            else return 307;
                        }
                    else
                        return 307;
                else
                    return 307;
            else
                return 137;
        else
        if (lat < 77.060905f)
            if (lng < -98.114273f)
                if (lng < -102.000000f)
                    return 108;
                else
                    return 307;
            else
            if (lng < -96.694435f)
                return 307;
            else
            if (lng < -93.393501f)
                if (lat < 75.642746f)
                    if (lat < 74.746109f)
                        if (lng < -96.132774f)
                            return 307;
                        else
                        if (lng < -95.229347f)
                            if (lat < 74.697929f)
                                return 153;
                            else
                                return 307;
                        else
                            return 153;
                    else
                    if (lat < 74.843742f)
                        if (lng < -96.103386f)
                            return 153;
                        else
                            return 307;
                    else
                    {
                        if (poly[1027].contains(lat,lng)) return 307;
                        if (poly[1028].contains(lat,lng)) return 307;
                        else return 153;
                    }
                else
                    return 307;
            else
            if (lng < -85.000000f)
                return 307;
            else
                return 137;
        else
        if (lng < -92.025925f)
            if (lng < -102.000000f)
                return 108;
            else
                return 307;
        else
        if (lng < -85.000000f)
            return 307;
        else
            return 137;
    }

    private static int call18(float lat, float lng)
    {
        if (lat < 56.190918f)
            if (lng < -59.178490f)
                if (lng < -61.338535f)
                    if (lng < -63.322098f)
                        if (lng < -69.141731f)
                            return 20;
                        else
                        if (lng < -66.231915f)
                            if (lat < 54.544703f)
                                if (lng < -67.686823f)
                                {
                                    if (poly[1029].contains(lat,lng)) return 182;
                                    if (poly[1030].contains(lat,lng)) return 182;
                                    else return 20;
                                }
                                else
                                if (lat < 53.721595f)
                                {
                                    if (poly[1031].contains(lat,lng)) return 182;
                                    if (poly[1032].contains(lat,lng)) return 182;
                                    else return 20;
                                }
                                else
                                {
                                    if (poly[1033].contains(lat,lng)) return 182;
                                    else return 20;
                                }
                            else
                            {
                                if (poly[1034].contains(lat,lng)) return 182;
                                else return 20;
                            }
                        else
                        if (lat < 54.544703f)
                            return 182;
                        else
                        if (lng < -64.777006f)
                        {
                            if (poly[1035].contains(lat,lng)) return 182;
                            else return 20;
                        }
                        else
                        if (lat < 55.367810f)
                        {
                            if (poly[1036].contains(lat,lng)) return 20;
                            else return 182;
                        }
                        else
                        {
                            if (poly[1037].contains(lat,lng)) return 182;
                            else return 20;
                        }
                    else
                        return 182;
                else
                    return 182;
            else
            if (lat < 53.691547f)
                if (lng < -56.276463f)
                    if (lat < 53.630226f)
                        if (lng < -57.271252f)
                        {
                            if (poly[1038].contains(lat,lng)) return 290;
                            else return 182;
                        }
                        else
                        {
                            if (poly[1039].contains(lat,lng)) return 182;
                            else return 290;
                        }
                    else
                        return 182;
                else
                    return 290;
            else
                return 182;
        else
        if (lng < -62.987293f)
            if (lng < -67.891647f)
                if (lng < -69.269768f)
                    if (lng < -69.456772f)
                        if (lng < -69.770439f)
                            if (lng < -69.818451f)
                                return 20;
                            else
                            if (lat < 58.711903f)
                                return 20;
                            else
                            if (lng < -69.791435f)
                                return 20;
                            else
                            if (lat < 58.928640f)
                                return 20;
                            else
                                return 137;
                        else
                        if (lat < 58.798076f)
                            if (lng < -69.671379f)
                                if (lat < 58.723164f)
                                    return 20;
                                else
                                    return 137;
                            else
                                return 20;
                        else
                        if (lng < -69.700226f)
                            if (lat < 58.928741f)
                                return 20;
                            else
                                return 137;
                        else
                        {
                            if (poly[1040].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lat < 58.900829f)
                        if (lng < -69.454346f)
                            return 20;
                        else
                        {
                            if (poly[1041].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                    if (lat < 58.986942f)
                        if (lng < -69.391823f)
                            return 137;
                        else
                            return 20;
                    else
                    if (lat < 59.032063f)
                        if (lng < -69.430695f)
                            if (lat < 59.015503f)
                                return 20;
                            else
                                return 137;
                        else
                        if (lng < -69.336906f)
                            return 20;
                        else
                            return 137;
                    else
                        return 20;
                else
                if (lat < 58.919376f)
                    if (lng < -68.975906f)
                        if (lng < -69.177109f)
                        {
                            if (poly[1042].contains(lat,lng)) return 137;
                            else return 20;
                        }
                        else
                            return 20;
                    else
                    if (lng < -68.692970f)
                        if (lat < 57.985935f)
                        {
                            if (poly[1043].contains(lat,lng)) return 137;
                            else return 20;
                        }
                        else
                        {
                            if (poly[1044].contains(lat,lng)) return 137;
                            else return 20;
                        }
                    else
                        return 20;
                else
                if (lng < -69.095367f)
                    if (lng < -69.227913f)
                        return 20;
                    else
                    if (lat < 58.967100f)
                        if (lng < -69.160118f)
                            return 20;
                        else
                            return 137;
                    else
                    {
                        if (poly[1045].contains(lat,lng)) return 137;
                        else return 20;
                    }
                else
                    return 137;
            else
            if (lng < -65.941536f)
                if (lng < -66.467194f)
                    if (lng < -67.493484f)
                        if (lng < -67.852905f)
                            return 20;
                        else
                        {
                            if (poly[1046].contains(lat,lng)) return 166;
                            if (poly[1047].contains(lat,lng)) return 166;
                            else return 20;
                        }
                    else
                    if (lat < 58.717937f)
                    {
                        if (poly[1048].contains(lat,lng)) return 166;
                        else return 20;
                    }
                    else
                        return 166;
                else
                if (lat < 58.867237f)
                    if (lng < -66.127945f)
                    {
                        if (poly[1049].contains(lat,lng)) return 166;
                        else return 20;
                    }
                    else
                    if (lat < 58.730328f)
                        return 20;
                    else
                    {
                        if (poly[1050].contains(lat,lng)) return 166;
                        else return 20;
                    }
                else
                if (lat < 58.928638f)
                    return 20;
                else
                    return 166;
            else
            if (lng < -65.824425f)
                if (lat < 58.990658f)
                    if (lat < 58.848312f)
                        return 20;
                    else
                    {
                        if (poly[1051].contains(lat,lng)) return 166;
                        else return 20;
                    }
                else
                    return 166;
            else
            if (lng < -65.671173f)
                if (lat < 59.082661f)
                    if (lat < 58.991425f)
                        return 20;
                    else
                    if (lng < -65.815163f)
                        return 166;
                    else
                    {
                        if (poly[1052].contains(lat,lng)) return 166;
                        else return 20;
                    }
                else
                if (lng < -65.750923f)
                    return 166;
                else
                if (lat < 59.146431f)
                {
                    if (poly[1053].contains(lat,lng)) return 20;
                    else return 166;
                }
                else
                    return 20;
            else
            if (lng < -63.468971f)
                if (lng < -65.599258f)
                    if (lat < 59.055573f)
                    {
                        if (poly[1054].contains(lat,lng)) return 166;
                        else return 20;
                    }
                    else
                        return 20;
                else
                if (lat < 57.734932f)
                {
                    if (poly[1055].contains(lat,lng)) return 182;
                    else return 20;
                }
                else
                if (lng < -64.534115f)
                {
                    if (poly[1056].contains(lat,lng)) return 182;
                    else return 20;
                }
                else
                {
                    if (poly[1057].contains(lat,lng)) return 20;
                    if (poly[1058].contains(lat,lng)) return 20;
                    else return 182;
                }
            else
                return 182;
        else
            return 182;
    }

    private static int call19(float lat, float lng)
    {
        if (lng < -54.102795f)
            if (lat < 63.936062f)
                if (lat < 59.278946f)
                    return call18(lat,lng);
                else
                if (lng < -67.629715f)
                    if (lat < 63.325298f)
                        if (lng < -70.120392f)
                            if (lat < 62.477734f)
                                return 20;
                            else
                                return 137;
                        else
                        if (lng < -68.000000f)
                            if (lat < 61.080311f)
                                if (lat < 60.850647f)
                                    if (lat < 59.984997f)
                                        if (lng < -69.924110f)
                                        {
                                            if (poly[1059].contains(lat,lng)) return 137;
                                            else return 20;
                                        }
                                        else
                                        if (lng < -69.638916f)
                                        {
                                            if (poly[1060].contains(lat,lng)) return 137;
                                            else return 20;
                                        }
                                        else
                                        if (lat < 59.391781f)
                                            return 20;
                                        else
                                        if (lat < 59.699116f)
                                        {
                                            if (poly[1061].contains(lat,lng)) return 137;
                                            else return 20;
                                        }
                                        else
                                        {
                                            if (poly[1062].contains(lat,lng)) return 137;
                                            else return 20;
                                        }
                                    else
                                    if (lng < -69.876434f)
                                        return 20;
                                    else
                                    if (lng < -69.363411f)
                                        if (lat < 60.083309f)
                                            if (lng < -69.607597f)
                                                return 20;
                                            else
                                                return 137;
                                        else
                                        {
                                            if (poly[1063].contains(lat,lng)) return 137;
                                            else return 20;
                                        }
                                    else
                                        return 137;
                                else
                                if (lng < -70.065117f)
                                    if (lat < 60.979642f)
                                        if (lat < 60.881176f)
                                            return 20;
                                        else
                                        {
                                            if (poly[1064].contains(lat,lng)) return 137;
                                            else return 20;
                                        }
                                    else
                                    if (lat < 61.035766f)
                                        return 20;
                                    else
                                        return 137;
                                else
                                if (lng < -69.893997f)
                                    if (lat < 60.913162f)
                                        return 137;
                                    else
                                        return 20;
                                else
                                {
                                    if (poly[1065].contains(lat,lng)) return 137;
                                    else return 20;
                                }
                            else
                                return 137;
                        else
                            return 166;
                    else
                    if (lng < -68.000000f)
                        return 137;
                    else
                        return 166;
                else
                if (lat < 60.695583f)
                    if (lat < 60.372677f)
                        if (lng < -64.353218f)
                            if (lng < -65.378146f)
                                if (lat < 59.453045f)
                                    if (lng < -65.590347f)
                                        return 166;
                                    else
                                    if (lng < -65.506706f)
                                        if (lat < 59.385551f)
                                        {
                                            if (poly[1066].contains(lat,lng)) return 166;
                                            else return 20;
                                        }
                                        else
                                            return 166;
                                    else
                                    if (lat < 59.336494f)
                                    {
                                        if (poly[1067].contains(lat,lng)) return 166;
                                        else return 20;
                                    }
                                    else
                                        return 20;
                                else
                                if (lng < -65.469658f)
                                    if (lat < 59.504585f)
                                        if (lng < -65.523506f)
                                            return 166;
                                        else
                                        if (lat < 59.484665f)
                                            return 20;
                                        else
                                            return 166;
                                    else
                                        return 20;
                                else
                                    return 20;
                            else
                            if (lng < -65.101463f)
                                return 20;
                            else
                            if (lat < 60.227196f)
                                if (lat < 59.753071f)
                                {
                                    if (poly[1068].contains(lat,lng)) return 20;
                                    else return 182;
                                }
                                else
                                {
                                    if (poly[1069].contains(lat,lng)) return 182;
                                    else return 20;
                                }
                            else
                            {
                                if (poly[1070].contains(lat,lng)) return 182;
                                if (poly[1071].contains(lat,lng)) return 182;
                                else return 20;
                            }
                        else
                            return 182;
                    else
                        return 20;
                else
                    return 166;
            else
            if (lat < 67.483208f)
                if (lng < -68.000000f)
                    return 137;
                else
                    return 166;
            else
            if (lng < -60.919846f)
                if (lat < 70.351471f)
                    if (lng < -68.000000f)
                        return 137;
                    else
                        return 166;
                else
                if (lng < -68.000000f)
                    if (lat < 72.289263f)
                        return 137;
                    else
                    if (lat < 78.368271f)
                        return 306;
                    else
                    if (lng < -72.985229f)
                        return 137;
                    else
                    if (lat < 79.070419f)
                        return 306;
                    else
                        return 137;
                else
                if (lat < 77.469055f)
                    if (lng < -63.736012f)
                        if (lat < 76.134232f)
                            return 306;
                        else
                        if (lng < -66.141296f)
                            return 306;
                        else
                        {
                            if (poly[1072].contains(lat,lng)) return 16;
                            else return 306;
                        }
                    else
                        return 16;
                else
                if (lat < 80.684196f)
                    if (lat < 79.171616f)
                        if (lng < -66.601120f)
                            return 306;
                        else
                        if (lat < 77.519371f)
                            if (lng < -66.168510f)
                                return 306;
                            else
                            {
                                if (poly[1073].contains(lat,lng)) return 16;
                                else return 306;
                            }
                        else
                        {
                            if (poly[1074].contains(lat,lng)) return 306;
                            else return 16;
                        }
                    else
                        return 16;
                else
                if (lng < -66.286903f)
                    return 166;
                else
                if (lat < 81.547485f)
                    if (lng < -64.459412f)
                        if (lat < 81.074245f)
                            return 16;
                        else
                            return 166;
                    else
                        return 16;
                else
                if (lng < -64.431755f)
                    return 166;
                else
                {
                    if (poly[1075].contains(lat,lng)) return 16;
                    else return 166;
                }
            else
                return 16;
        else
        if (lng < -24.752028f)
            return 16;
        else
        if (lat < 60.846443f)
            if (lng < -1.743917f)
                if (lat < 55.436916f)
                    if (lng < -8.195111f)
                        return 285;
                    else
                    if (lng < -5.434611f)
                        if (lng < -6.002389f)
                            if (lat < 53.499805f)
                                return 285;
                            else
                            if (lat < 55.253502f)
                                if (lng < -7.098750f)
                                    if (lat < 54.376654f)
                                    {
                                        if (poly[1076].contains(lat,lng)) return 303;
                                        else return 285;
                                    }
                                    else
                                    {
                                        if (poly[1077].contains(lat,lng)) return 303;
                                        if (poly[1078].contains(lat,lng)) return 303;
                                        else return 285;
                                    }
                                else
                                {
                                    if (poly[1079].contains(lat,lng)) return 303;
                                    else return 285;
                                }
                            else
                            if (lng < -6.953667f)
                                return 285;
                            else
                                return 303;
                        else
                            return 303;
                    else
                    if (lat < 53.433556f)
                        return 303;
                    else
                    if (lng < -4.311500f)
                        if (lat < 54.419724f)
                            return 242;
                        else
                            return 303;
                    else
                        return 303;
                else
                    return 303;
            else
            if (lat < 59.846554f)
                if (lat < 59.034222f)
                    if (lat < 55.619720f)
                        if (lng < 5.153944f)
                            if (lng < 1.369295f)
                                return 303;
                            else
                                return 385;
                        else
                        if (lng < 6.615556f)
                            return 385;
                        else
                        if (lat < 53.470085f)
                        {
                            if (poly[1080].contains(lat,lng)) return 6;
                            else return 385;
                        }
                        else
                            return 6;
                    else
                        return 355;
                else
                if (lng < -1.614194f)
                    return 303;
                else
                    return 355;
            else
            if (lng < 4.695556f)
                return 303;
            else
                return 355;
        else
        if (lat < 72.417862f)
            if (lng < 4.650167f)
                if (lng < -17.130816f)
                    if (lat < 66.563774f)
                        return 21;
                    else
                    if (lng < -21.973426f)
                        if (lat < 70.304049f)
                            return 16;
                        else
                        if (lat < 70.436001f)
                            return 73;
                        else
                        if (lat < 72.348299f)
                            if (lng < -24.400325f)
                            {
                                if (poly[1081].contains(lat,lng)) return 73;
                                else return 16;
                            }
                            else
                            {
                                if (poly[1082].contains(lat,lng)) return 16;
                                else return 73;
                            }
                        else
                            return 16;
                    else
                        return 73;
                else
                if (lng < -13.495815f)
                    return 21;
                else
                if (lng < -7.920997f)
                    return 111;
                else
                    return 361;
            else
                return 355;
        else
        if (lat < 77.352264f)
            if (lat < 75.090202f)
                return 16;
            else
            if (lat < 76.526947f)
                if (lat < 76.369011f)
                    if (lng < -20.440577f)
                        if (lng < -21.152466f)
                            if (lat < 76.295341f)
                            {
                                if (poly[1083].contains(lat,lng)) return 25;
                                if (poly[1084].contains(lat,lng)) return 25;
                                if (poly[1085].contains(lat,lng)) return 25;
                                else return 16;
                            }
                            else
                            if (lng < -22.890951f)
                            {
                                if (poly[1086].contains(lat,lng)) return 25;
                                else return 16;
                            }
                            else
                                return 25;
                        else
                        if (lat < 75.841735f)
                            if (lat < 75.325089f)
                                return 16;
                            else
                            {
                                if (poly[1087].contains(lat,lng)) return 25;
                                else return 16;
                            }
                        else
                            return 25;
                    else
                    if (lat < 75.798696f)
                        if (lng < -19.495006f)
                        {
                            if (poly[1088].contains(lat,lng)) return 25;
                            else return 16;
                        }
                        else
                            return 16;
                    else
                        return 25;
                else
                if (lng < -22.880474f)
                {
                    if (poly[1089].contains(lat,lng)) return 25;
                    else return 16;
                }
                else
                    return 25;
            else
            if (lng < -22.825729f)
            {
                if (poly[1090].contains(lat,lng)) return 25;
                else return 16;
            }
            else
                return 25;
        else
        if (lat < 78.385384f)
            if (lng < -21.049835f)
                if (lng < -22.757199f)
                {
                    if (poly[1091].contains(lat,lng)) return 25;
                    else return 16;
                }
                else
                    return 25;
            else
                return 25;
        else
        if (lat < 79.653531f)
            if (lng < -19.217758f)
                if (lat < 78.890169f)
                    if (lng < -22.723715f)
                    {
                        if (poly[1092].contains(lat,lng)) return 25;
                        else return 16;
                    }
                    else
                        return 25;
                else
                if (lng < -22.673079f)
                {
                    if (poly[1093].contains(lat,lng)) return 25;
                    else return 16;
                }
                else
                if (lat < 79.360726f)
                    return 25;
                else
                {
                    if (poly[1094].contains(lat,lng)) return 16;
                    else return 25;
                }
            else
                return 25;
        else
            return 16;
    }

    private static int call20(float lat, float lng)
    {
        if (lat < -28.572058f)
            if (lat < -33.408588f)
                return 169;
            else
            if (lng < 19.539615f)
                if (lng < 16.478859f)
                {
                    if (poly[1095].contains(lat,lng)) return 189;
                    else return 169;
                }
                else
                {
                    if (poly[1096].contains(lat,lng)) return 189;
                    else return 169;
                }
            else
            if (lng < 25.950998f)
                return 169;
            else
            if (lng < 29.156690f)
                if (lat < -30.990323f)
                    return 169;
                else
                if (lng < 27.553844f)
                {
                    if (poly[1097].contains(lat,lng)) return 339;
                    else return 169;
                }
                else
                if (lat < -29.781190f)
                {
                    if (poly[1098].contains(lat,lng)) return 339;
                    else return 169;
                }
                else
                {
                    if (poly[1099].contains(lat,lng)) return 339;
                    else return 169;
                }
            else
            {
                if (poly[1100].contains(lat,lng)) return 339;
                if (poly[1101].contains(lat,lng)) return 339;
                else return 169;
            }
        else
        if (lng < 29.360781f)
            if (lng < 17.403767f)
                if (lat < -28.037775f)
                    if (lng < 17.083324f)
                    {
                        if (poly[1102].contains(lat,lng)) return 169;
                        else return 189;
                    }
                    else
                    if (lat < -28.411060f)
                    {
                        if (poly[1103].contains(lat,lng)) return 189;
                        else return 169;
                    }
                    else
                    {
                        if (poly[1104].contains(lat,lng)) return 189;
                        else return 169;
                    }
                else
                if (lat < -26.993246f)
                    return 189;
                else
                if (lat < -16.959894f)
                    if (lng < 13.142432f)
                    {
                        if (poly[1105].contains(lat,lng)) return 299;
                        else return 189;
                    }
                    else
                    {
                        if (poly[1106].contains(lat,lng)) return 299;
                        else return 189;
                    }
                else
                    return 299;
            else
            if (lat < -22.090446f)
                if (lng < 23.382274f)
                    if (lat < -25.331252f)
                        if (lng < 20.393020f)
                        {
                            if (poly[1107].contains(lat,lng)) return 169;
                            else return 189;
                        }
                        else
                        if (lat < -26.951655f)
                            return 169;
                        else
                        if (lng < 21.887647f)
                        {
                            if (poly[1108].contains(lat,lng)) return 12;
                            else return 169;
                        }
                        else
                        {
                            if (poly[1109].contains(lat,lng)) return 12;
                            else return 169;
                        }
                    else
                    {
                        if (poly[1110].contains(lat,lng)) return 169;
                        if (poly[1111].contains(lat,lng)) return 169;
                        if (poly[1112].contains(lat,lng)) return 189;
                        else return 12;
                    }
                else
                if (lat < -25.331252f)
                {
                    if (poly[1113].contains(lat,lng)) return 12;
                    else return 169;
                }
                else
                if (lng < 26.371527f)
                {
                    if (poly[1114].contains(lat,lng)) return 169;
                    if (poly[1115].contains(lat,lng)) return 169;
                    else return 12;
                }
                else
                if (lat < -23.710849f)
                {
                    if (poly[1116].contains(lat,lng)) return 169;
                    else return 12;
                }
                else
                if (lng < 27.866154f)
                {
                    if (poly[1117].contains(lat,lng)) return 169;
                    else return 12;
                }
                else
                {
                    if (poly[1118].contains(lat,lng)) return 12;
                    if (poly[1119].contains(lat,lng)) return 269;
                    else return 169;
                }
            else
            if (lng < 23.382274f)
                if (lat < -18.849641f)
                {
                    if (poly[1120].contains(lat,lng)) return 189;
                    else return 12;
                }
                else
                if (lng < 20.393020f)
                {
                    if (poly[1121].contains(lat,lng)) return 299;
                    else return 189;
                }
                else
                if (lat < -17.229238f)
                {
                    if (poly[1122].contains(lat,lng)) return 12;
                    if (poly[1123].contains(lat,lng)) return 267;
                    if (poly[1124].contains(lat,lng)) return 299;
                    else return 189;
                }
                else
                {
                    if (poly[1125].contains(lat,lng)) return 299;
                    else return 267;
                }
            else
            if (lat < -18.849641f)
                if (lng < 26.371527f)
                {
                    if (poly[1126].contains(lat,lng)) return 269;
                    else return 12;
                }
                else
                if (lat < -20.470044f)
                {
                    if (poly[1127].contains(lat,lng)) return 269;
                    else return 12;
                }
                else
                {
                    if (poly[1128].contains(lat,lng)) return 12;
                    else return 269;
                }
            else
            if (lng < 26.371527f)
                if (lat < -17.229238f)
                    if (lng < 24.876900f)
                        if (lat < -18.039439f)
                        {
                            if (poly[1129].contains(lat,lng)) return 189;
                            if (poly[1130].contains(lat,lng)) return 189;
                            else return 12;
                        }
                        else
                        {
                            if (poly[1131].contains(lat,lng)) return 12;
                            if (poly[1132].contains(lat,lng)) return 12;
                            if (poly[1133].contains(lat,lng)) return 267;
                            if (poly[1134].contains(lat,lng)) return 299;
                            else return 189;
                        }
                    else
                    if (lat < -18.039439f)
                    {
                        if (poly[1135].contains(lat,lng)) return 12;
                        else return 269;
                    }
                    else
                    if (lng < 25.624214f)
                    {
                        if (poly[1136].contains(lat,lng)) return 12;
                        if (poly[1137].contains(lat,lng)) return 189;
                        if (poly[1138].contains(lat,lng)) return 269;
                        else return 267;
                    }
                    else
                    {
                        if (poly[1139].contains(lat,lng)) return 267;
                        else return 269;
                    }
                else
                    return 267;
            else
            {
                if (poly[1140].contains(lat,lng)) return 269;
                else return 267;
            }
        else
        if (lat < -25.719648f)
            if (lng < 32.895973f)
                if (lng < 32.137260f)
                {
                    if (poly[1141].contains(lat,lng)) return 169;
                    if (poly[1142].contains(lat,lng)) return 169;
                    if (poly[1143].contains(lat,lng)) return 364;
                    else return 117;
                }
                else
                if (lat < -26.830089f)
                {
                    if (poly[1144].contains(lat,lng)) return 364;
                    else return 169;
                }
                else
                    return 364;
            else
                return 364;
        else
        if (lat < -20.664242f)
            if (lat < -23.191945f)
            {
                if (poly[1145].contains(lat,lng)) return 169;
                else return 364;
            }
            else
            {
                if (poly[1146].contains(lat,lng)) return 169;
                if (poly[1147].contains(lat,lng)) return 364;
                else return 269;
            }
        else
        if (lat < -18.136539f)
        {
            if (poly[1148].contains(lat,lng)) return 364;
            else return 269;
        }
        else
        if (lng < 31.533242f)
        {
            if (poly[1149].contains(lat,lng)) return 267;
            if (poly[1150].contains(lat,lng)) return 364;
            else return 269;
        }
        else
        {
            if (poly[1151].contains(lat,lng)) return 269;
            else return 364;
        }
    }

    private static int call21(float lat, float lng)
    {
        if (lng < 24.421398f)
            if (lat < -5.927235f)
                if (lng < 12.664001f)
                    if (lat < -6.026062f)
                        if (lng < 12.560946f)
                            if (lat < -6.060813f)
                                return 299;
                            else
                                return 331;
                        else
                            return 299;
                    else
                        return 331;
                else
                if (lng < 12.869216f)
                    if (lat < -6.012101f)
                        return 299;
                    else
                    if (lat < -5.979688f)
                        if (lng < 12.722283f)
                            return 331;
                        else
                            return 299;
                    else
                        return 331;
                else
                if (lng < 12.944152f)
                    return 299;
                else
                if (lng < 18.682775f)
                    if (lng < 15.813463f)
                        return 299;
                    else
                    if (lng < 17.248119f)
                    {
                        if (poly[1152].contains(lat,lng)) return 331;
                        else return 299;
                    }
                    else
                    {
                        if (poly[1153].contains(lat,lng)) return 299;
                        else return 331;
                    }
                else
                if (lng < 21.552087f)
                {
                    if (poly[1154].contains(lat,lng)) return 299;
                    if (poly[1155].contains(lat,lng)) return 352;
                    else return 331;
                }
                else
                {
                    if (poly[1156].contains(lat,lng)) return 299;
                    else return 352;
                }
            else
            if (lng < 9.921646f)
                return 155;
            else
            if (lng < 17.865310f)
                if (lat < -5.841628f)
                    if (lng < 12.922298f)
                        if (lng < 12.876115f)
                        {
                            if (poly[1157].contains(lat,lng)) return 299;
                            else return 331;
                        }
                        else
                            return 331;
                    else
                    if (lng < 13.986273f)
                    {
                        if (poly[1158].contains(lat,lng)) return 331;
                        else return 299;
                    }
                    else
                    {
                        if (poly[1159].contains(lat,lng)) return 299;
                        else return 331;
                    }
                else
                if (lng < 13.893478f)
                    if (lat < -2.791343f)
                        if (lng < 11.956557f)
                        {
                            if (poly[1160].contains(lat,lng)) return 155;
                            else return 154;
                        }
                        else
                        if (lat < -4.316486f)
                            if (lng < 12.925017f)
                            {
                                if (poly[1161].contains(lat,lng)) return 154;
                                if (poly[1162].contains(lat,lng)) return 331;
                                else return 299;
                            }
                            else
                            {
                                if (poly[1163].contains(lat,lng)) return 299;
                                if (poly[1164].contains(lat,lng)) return 331;
                                else return 154;
                            }
                        else
                        {
                            if (poly[1165].contains(lat,lng)) return 155;
                            if (poly[1166].contains(lat,lng)) return 155;
                            else return 154;
                        }
                    else
                    if (lng < 11.907562f)
                    {
                        if (poly[1167].contains(lat,lng)) return 154;
                        else return 155;
                    }
                    else
                    {
                        if (poly[1168].contains(lat,lng)) return 154;
                        if (poly[1169].contains(lat,lng)) return 154;
                        if (poly[1170].contains(lat,lng)) return 154;
                        else return 155;
                    }
                else
                if (lat < -2.791343f)
                {
                    if (poly[1171].contains(lat,lng)) return 154;
                    else return 331;
                }
                else
                if (lng < 15.879394f)
                {
                    if (poly[1172].contains(lat,lng)) return 154;
                    if (poly[1173].contains(lat,lng)) return 154;
                    else return 155;
                }
                else
                {
                    if (poly[1174].contains(lat,lng)) return 331;
                    else return 154;
                }
            else
            if (lng < 21.143354f)
            {
                if (poly[1175].contains(lat,lng)) return 352;
                else return 331;
            }
            else
            if (lat < -2.834147f)
                return 352;
            else
            if (lng < 22.782376f)
            {
                if (poly[1176].contains(lat,lng)) return 352;
                else return 331;
            }
            else
            {
                if (poly[1177].contains(lat,lng)) return 331;
                else return 352;
            }
        else
        if (lat < -5.718678f)
            if (lng < 30.744639f)
            {
                if (poly[1178].contains(lat,lng)) return 17;
                else return 352;
            }
            else
                return 17;
        else
        if (lng < 39.221806f)
            if (lng < 30.895958f)
                if (lat < -2.078556f)
                    if (lng < 27.658678f)
                        return 352;
                    else
                    if (lat < -3.898617f)
                    {
                        if (poly[1179].contains(lat,lng)) return 83;
                        if (poly[1180].contains(lat,lng)) return 352;
                        else return 17;
                    }
                    else
                    if (lng < 29.277318f)
                    {
                        if (poly[1181].contains(lat,lng)) return 83;
                        if (poly[1182].contains(lat,lng)) return 293;
                        else return 352;
                    }
                    else
                    if (lat < -2.988586f)
                    {
                        if (poly[1183].contains(lat,lng)) return 83;
                        else return 17;
                    }
                    else
                    if (lng < 30.086638f)
                    {
                        if (poly[1184].contains(lat,lng)) return 293;
                        else return 83;
                    }
                    else
                    {
                        if (poly[1185].contains(lat,lng)) return 17;
                        if (poly[1186].contains(lat,lng)) return 293;
                        else return 83;
                    }
                else
                if (lng < 27.658678f)
                    return 352;
                else
                if (lng < 29.277318f)
                {
                    if (poly[1187].contains(lat,lng)) return 293;
                    else return 352;
                }
                else
                if (lat < -0.909808f)
                    if (lng < 30.086638f)
                    {
                        if (poly[1188].contains(lat,lng)) return 293;
                        if (poly[1189].contains(lat,lng)) return 352;
                        else return 179;
                    }
                    else
                    {
                        if (poly[1190].contains(lat,lng)) return 17;
                        if (poly[1191].contains(lat,lng)) return 179;
                        else return 293;
                    }
                else
                {
                    if (poly[1192].contains(lat,lng)) return 352;
                    else return 179;
                }
            else
            if (lat < -5.085639f)
                return 17;
            else
            {
                if (poly[1193].contains(lat,lng)) return 122;
                if (poly[1194].contains(lat,lng)) return 179;
                else return 17;
            }
        else
            return 122;
    }

    private static int call22(float lat, float lng)
    {
        if (lng < 31.305912f)
            if (lat < 5.386098f)
                if (lng < 23.651386f)
                    if (lat < 2.822519f)
                    {
                        if (poly[1195].contains(lat,lng)) return 331;
                        else return 352;
                    }
                    else
                    if (lng < 21.150613f)
                    {
                        if (poly[1196].contains(lat,lng)) return 331;
                        else return 214;
                    }
                    else
                    if (lat < 4.104309f)
                    {
                        if (poly[1197].contains(lat,lng)) return 331;
                        else return 352;
                    }
                    else
                    {
                        if (poly[1198].contains(lat,lng)) return 331;
                        if (poly[1199].contains(lat,lng)) return 352;
                        else return 214;
                    }
                else
                if (lng < 27.478649f)
                    if (lat < 2.822519f)
                        return 352;
                    else
                    if (lng < 25.565018f)
                        if (lat < 4.104309f)
                            return 352;
                        else
                        if (lng < 24.608202f)
                        {
                            if (poly[1200].contains(lat,lng)) return 352;
                            else return 214;
                        }
                        else
                        {
                            if (poly[1201].contains(lat,lng)) return 352;
                            else return 214;
                        }
                    else
                    if (lat < 4.104309f)
                        return 352;
                    else
                    if (lng < 26.521833f)
                    {
                        if (poly[1202].contains(lat,lng)) return 214;
                        else return 352;
                    }
                    else
                    {
                        if (poly[1203].contains(lat,lng)) return 352;
                        if (poly[1204].contains(lat,lng)) return 395;
                        else return 214;
                    }
                else
                if (lat < 2.822519f)
                {
                    if (poly[1205].contains(lat,lng)) return 352;
                    else return 179;
                }
                else
                if (lng < 29.392281f)
                {
                    if (poly[1206].contains(lat,lng)) return 352;
                    else return 395;
                }
                else
                if (lat < 4.104309f)
                {
                    if (poly[1207].contains(lat,lng)) return 179;
                    if (poly[1208].contains(lat,lng)) return 395;
                    else return 352;
                }
                else
                {
                    if (poly[1209].contains(lat,lng)) return 352;
                    else return 395;
                }
            else
            if (lng < 24.977876f)
                if (lat < 10.869160f)
                    if (lng < 21.813858f)
                        if (lat < 8.127629f)
                            return 214;
                        else
                        if (lng < 20.231848f)
                        {
                            if (poly[1210].contains(lat,lng)) return 214;
                            else return 202;
                        }
                        else
                        if (lat < 9.498395f)
                        {
                            if (poly[1211].contains(lat,lng)) return 202;
                            else return 214;
                        }
                        else
                        {
                            if (poly[1212].contains(lat,lng)) return 214;
                            else return 202;
                        }
                    else
                    if (lat < 8.127629f)
                    {
                        if (poly[1213].contains(lat,lng)) return 395;
                        else return 214;
                    }
                    else
                    if (lng < 23.395867f)
                    {
                        if (poly[1214].contains(lat,lng)) return 202;
                        if (poly[1215].contains(lat,lng)) return 202;
                        if (poly[1216].contains(lat,lng)) return 202;
                        if (poly[1217].contains(lat,lng)) return 322;
                        else return 214;
                    }
                    else
                    if (lat < 9.498395f)
                        if (lng < 24.186871f)
                        {
                            if (poly[1218].contains(lat,lng)) return 322;
                            if (poly[1219].contains(lat,lng)) return 395;
                            if (poly[1220].contains(lat,lng)) return 395;
                            else return 214;
                        }
                        else
                        {
                            if (poly[1221].contains(lat,lng)) return 214;
                            if (poly[1222].contains(lat,lng)) return 214;
                            if (poly[1223].contains(lat,lng)) return 322;
                            else return 395;
                        }
                    else
                    {
                        if (poly[1224].contains(lat,lng)) return 214;
                        if (poly[1225].contains(lat,lng)) return 395;
                        else return 322;
                    }
                else
                if (lng < 21.813858f)
                    return 202;
                else
                if (lat < 13.610691f)
                {
                    if (poly[1226].contains(lat,lng)) return 214;
                    if (poly[1227].contains(lat,lng)) return 322;
                    else return 202;
                }
                else
                {
                    if (poly[1228].contains(lat,lng)) return 322;
                    else return 202;
                }
            else
            if (lat < 10.869160f)
                if (lng < 28.141894f)
                    if (lat < 8.127629f)
                        if (lng < 26.559885f)
                            if (lat < 6.756863f)
                            {
                                if (poly[1229].contains(lat,lng)) return 395;
                                else return 214;
                            }
                            else
                            {
                                if (poly[1230].contains(lat,lng)) return 214;
                                else return 395;
                            }
                        else
                        {
                            if (poly[1231].contains(lat,lng)) return 214;
                            else return 395;
                        }
                    else
                    {
                        if (poly[1232].contains(lat,lng)) return 322;
                        else return 395;
                    }
                else
                {
                    if (poly[1233].contains(lat,lng)) return 395;
                    else return 322;
                }
            else
                return 322;
        else
        if (lat < 12.219149f)
            if (lat < 4.629333f)
                if (lng < 35.947697f)
                    if (lng < 33.626804f)
                    {
                        if (poly[1234].contains(lat,lng)) return 395;
                        else return 179;
                    }
                    else
                    if (lat < 2.444137f)
                    {
                        if (poly[1235].contains(lat,lng)) return 179;
                        else return 122;
                    }
                    else
                    {
                        if (poly[1236].contains(lat,lng)) return 179;
                        if (poly[1237].contains(lat,lng)) return 395;
                        else return 122;
                    }
                else
                {
                    if (poly[1238].contains(lat,lng)) return 350;
                    else return 122;
                }
            else
            if (lng < 35.437428f)
                if (lat < 8.424241f)
                    if (lng < 33.371670f)
                    {
                        if (poly[1239].contains(lat,lng)) return 350;
                        else return 395;
                    }
                    else
                    if (lat < 6.526787f)
                    {
                        if (poly[1240].contains(lat,lng)) return 350;
                        else return 395;
                    }
                    else
                    {
                        if (poly[1241].contains(lat,lng)) return 395;
                        if (poly[1242].contains(lat,lng)) return 395;
                        if (poly[1243].contains(lat,lng)) return 395;
                        else return 350;
                    }
                else
                if (lng < 33.371670f)
                {
                    if (poly[1244].contains(lat,lng)) return 322;
                    if (poly[1245].contains(lat,lng)) return 322;
                    if (poly[1246].contains(lat,lng)) return 350;
                    if (poly[1247].contains(lat,lng)) return 350;
                    else return 395;
                }
                else
                if (lat < 10.321695f)
                {
                    if (poly[1248].contains(lat,lng)) return 322;
                    if (poly[1249].contains(lat,lng)) return 350;
                    if (poly[1250].contains(lat,lng)) return 350;
                    if (poly[1251].contains(lat,lng)) return 350;
                    else return 395;
                }
                else
                {
                    if (poly[1252].contains(lat,lng)) return 350;
                    if (poly[1253].contains(lat,lng)) return 350;
                    if (poly[1254].contains(lat,lng)) return 395;
                    else return 322;
                }
            else
            {
                if (poly[1255].contains(lat,lng)) return 322;
                if (poly[1256].contains(lat,lng)) return 395;
                else return 350;
            }
        else
        if (lng < 35.437428f)
        {
            if (poly[1257].contains(lat,lng)) return 350;
            else return 322;
        }
        else
        if (lat < 14.285686f)
        {
            if (poly[1258].contains(lat,lng)) return 149;
            if (poly[1259].contains(lat,lng)) return 149;
            if (poly[1260].contains(lat,lng)) return 149;
            if (poly[1261].contains(lat,lng)) return 322;
            else return 350;
        }
        else
        {
            if (poly[1262].contains(lat,lng)) return 322;
            if (poly[1263].contains(lat,lng)) return 350;
            if (poly[1264].contains(lat,lng)) return 350;
            if (poly[1265].contains(lat,lng)) return 350;
            else return 149;
        }
    }

    private static int call23(float lat, float lng)
    {
        if (lng < 39.923779f)
            if (lng < 18.649839f)
                if (lat < 3.973938f)
                    if (lng < 8.937982f)
                        if (lng < 7.466374f)
                            return 161;
                        else
                            return 201;
                    else
                    if (lng < 9.527758f)
                        if (lat < 0.922485f)
                            if (lat < 0.668440f)
                                return 155;
                            else
                                return 201;
                        else
                        if (lat < 1.464501f)
                            return 201;
                        else
                            return 326;
                    else
                    if (lng < 11.335724f)
                        if (lat < 0.279823f)
                            return 155;
                        else
                        if (lat < 2.346989f)
                        {
                            if (poly[1266].contains(lat,lng)) return 155;
                            if (poly[1267].contains(lat,lng)) return 326;
                            else return 201;
                        }
                        else
                            return 326;
                    else
                    if (lng < 14.992782f)
                        if (lat < 2.116439f)
                            if (lng < 13.164253f)
                            {
                                if (poly[1268].contains(lat,lng)) return 154;
                                if (poly[1269].contains(lat,lng)) return 154;
                                if (poly[1270].contains(lat,lng)) return 154;
                                else return 155;
                            }
                            else
                            if (lat < 1.187690f)
                            {
                                if (poly[1271].contains(lat,lng)) return 155;
                                else return 154;
                            }
                            else
                            if (lng < 14.078517f)
                            {
                                if (poly[1272].contains(lat,lng)) return 154;
                                else return 155;
                            }
                            else
                            {
                                if (poly[1273].contains(lat,lng)) return 155;
                                if (poly[1274].contains(lat,lng)) return 326;
                                if (poly[1275].contains(lat,lng)) return 326;
                                else return 154;
                            }
                        else
                        {
                            if (poly[1276].contains(lat,lng)) return 154;
                            if (poly[1277].contains(lat,lng)) return 154;
                            if (poly[1278].contains(lat,lng)) return 155;
                            else return 326;
                        }
                    else
                    if (lat < 2.116439f)
                        if (lng < 16.821311f)
                        {
                            if (poly[1279].contains(lat,lng)) return 326;
                            else return 154;
                        }
                        else
                        {
                            if (poly[1280].contains(lat,lng)) return 331;
                            else return 154;
                        }
                    else
                    if (lng < 16.821311f)
                    {
                        if (poly[1281].contains(lat,lng)) return 154;
                        if (poly[1282].contains(lat,lng)) return 326;
                        else return 214;
                    }
                    else
                    if (lat < 3.045189f)
                    {
                        if (poly[1283].contains(lat,lng)) return 331;
                        else return 154;
                    }
                    else
                    {
                        if (poly[1284].contains(lat,lng)) return 214;
                        if (poly[1285].contains(lat,lng)) return 331;
                        else return 154;
                    }
                else
                if (lng < 8.341630f)
                    if (lat < 4.832398f)
                        return 96;
                    else
                    {
                        if (poly[1286].contains(lat,lng)) return 260;
                        else return 96;
                    }
                else
                if (lat < 4.686236f)
                    if (lng < 8.714308f)
                        return 326;
                    else
                    if (lng < 15.183470f)
                        if (lat < 4.054228f)
                            if (lng < 9.648236f)
                                return 326;
                            else
                            {
                                if (poly[1287].contains(lat,lng)) return 214;
                                else return 326;
                            }
                        else
                        {
                            if (poly[1288].contains(lat,lng)) return 214;
                            else return 326;
                        }
                    else
                    {
                        if (poly[1289].contains(lat,lng)) return 331;
                        else return 214;
                    }
                else
                if (lat < 10.519229f)
                    if (lng < 13.495735f)
                        if (lat < 7.602733f)
                            if (lng < 10.918682f)
                                if (lat < 6.144484f)
                                {
                                    if (poly[1290].contains(lat,lng)) return 326;
                                    else return 96;
                                }
                                else
                                {
                                    if (poly[1291].contains(lat,lng)) return 326;
                                    else return 96;
                                }
                            else
                            {
                                if (poly[1292].contains(lat,lng)) return 96;
                                else return 326;
                            }
                        else
                        {
                            if (poly[1293].contains(lat,lng)) return 326;
                            else return 96;
                        }
                    else
                    if (lat < 7.602733f)
                        if (lng < 16.072787f)
                            if (lat < 6.144484f)
                            {
                                if (poly[1294].contains(lat,lng)) return 326;
                                else return 214;
                            }
                            else
                            {
                                if (poly[1295].contains(lat,lng)) return 202;
                                if (poly[1296].contains(lat,lng)) return 326;
                                else return 214;
                            }
                        else
                        {
                            if (poly[1297].contains(lat,lng)) return 202;
                            if (poly[1298].contains(lat,lng)) return 202;
                            else return 214;
                        }
                    else
                    if (lng < 16.072787f)
                        if (lat < 9.060981f)
                        {
                            if (poly[1299].contains(lat,lng)) return 326;
                            else return 202;
                        }
                        else
                        {
                            if (poly[1300].contains(lat,lng)) return 96;
                            if (poly[1301].contains(lat,lng)) return 202;
                            else return 326;
                        }
                    else
                    {
                        if (poly[1302].contains(lat,lng)) return 214;
                        if (poly[1303].contains(lat,lng)) return 214;
                        else return 202;
                    }
                else
                if (lng < 13.495735f)
                    if (lat < 13.435726f)
                    {
                        if (poly[1304].contains(lat,lng)) return 260;
                        else return 96;
                    }
                    else
                    {
                        if (poly[1305].contains(lat,lng)) return 96;
                        if (poly[1306].contains(lat,lng)) return 202;
                        else return 260;
                    }
                else
                if (lat < 13.435726f)
                    if (lng < 16.072787f)
                        if (lat < 11.977477f)
                        {
                            if (poly[1307].contains(lat,lng)) return 96;
                            if (poly[1308].contains(lat,lng)) return 202;
                            else return 326;
                        }
                        else
                        if (lng < 14.784261f)
                        {
                            if (poly[1309].contains(lat,lng)) return 96;
                            if (poly[1310].contains(lat,lng)) return 202;
                            else return 326;
                        }
                        else
                        {
                            if (poly[1311].contains(lat,lng)) return 326;
                            else return 202;
                        }
                    else
                        return 202;
                else
                {
                    if (poly[1312].contains(lat,lng)) return 96;
                    if (poly[1313].contains(lat,lng)) return 260;
                    if (poly[1314].contains(lat,lng)) return 260;
                    else return 202;
                }
            else
            if (lng < 39.568943f)
                return call22(lat,lng);
            else
            if (lat < 14.553577f)
                if (lat < 3.903177f)
                {
                    if (poly[1315].contains(lat,lng)) return 350;
                    else return 122;
                }
                else
                {
                    if (poly[1316].contains(lat,lng)) return 149;
                    else return 350;
                }
            else
                return 149;
        else
        if (lat < 14.457556f)
            if (lat < 4.141098f)
            {
                if (poly[1317].contains(lat,lng)) return 350;
                else return 122;
            }
            else
            if (lng < 40.114882f)
            {
                if (poly[1318].contains(lat,lng)) return 149;
                else return 350;
            }
            else
            {
                if (poly[1319].contains(lat,lng)) return 149;
                else return 350;
            }
        else
            return 149;
    }

    private static int call24(float lat, float lng)
    {
        if (lat < 0.258941f)
            if (lat < -8.129065f)
                if (lng < 35.916821f)
                    if (lng < 33.705704f)
                        if (lat < -15.608835f)
                            return call20(lat,lng);
                        else
                        if (lng < 13.264205f)
                            return 299;
                        else
                        if (lng < 24.082119f)
                            if (lat < -11.397731f)
                            {
                                if (poly[1320].contains(lat,lng)) return 267;
                                else return 299;
                            }
                            else
                            if (lng < 18.673162f)
                                return 299;
                            else
                            if (lng < 21.377640f)
                                return 299;
                            else
                            if (lat < -9.763398f)
                            {
                                if (poly[1321].contains(lat,lng)) return 267;
                                if (poly[1322].contains(lat,lng)) return 352;
                                else return 299;
                            }
                            else
                            {
                                if (poly[1323].contains(lat,lng)) return 352;
                                else return 299;
                            }
                        else
                        if (lat < -13.998108f)
                        {
                            if (poly[1324].contains(lat,lng)) return 206;
                            if (poly[1325].contains(lat,lng)) return 206;
                            if (poly[1326].contains(lat,lng)) return 267;
                            else return 364;
                        }
                        else
                        if (lng < 30.774246f)
                            if (lat < -8.224360f)
                                if (lng < 27.428183f)
                                    if (lat < -11.111234f)
                                        if (lng < 25.755151f)
                                        {
                                            if (poly[1327].contains(lat,lng)) return 352;
                                            else return 267;
                                        }
                                        else
                                        {
                                            if (poly[1328].contains(lat,lng)) return 352;
                                            else return 267;
                                        }
                                    else
                                    {
                                        if (poly[1329].contains(lat,lng)) return 267;
                                        else return 352;
                                    }
                                else
                                if (lat < -11.111234f)
                                    if (lng < 29.101214f)
                                        if (lat < -12.554671f)
                                        {
                                            if (poly[1330].contains(lat,lng)) return 352;
                                            else return 267;
                                        }
                                        else
                                        {
                                            if (poly[1331].contains(lat,lng)) return 352;
                                            else return 267;
                                        }
                                    else
                                    {
                                        if (poly[1332].contains(lat,lng)) return 352;
                                        else return 267;
                                    }
                                else
                                {
                                    if (poly[1333].contains(lat,lng)) return 267;
                                    else return 352;
                                }
                            else
                            {
                                if (poly[1334].contains(lat,lng)) return 17;
                                else return 352;
                            }
                        else
                        if (lat < -11.063586f)
                            if (lat < -12.530847f)
                            {
                                if (poly[1335].contains(lat,lng)) return 267;
                                if (poly[1336].contains(lat,lng)) return 267;
                                if (poly[1337].contains(lat,lng)) return 267;
                                else return 206;
                            }
                            else
                            {
                                if (poly[1338].contains(lat,lng)) return 267;
                                else return 206;
                            }
                        else
                        if (lat < -9.596325f)
                        {
                            if (poly[1339].contains(lat,lng)) return 17;
                            if (poly[1340].contains(lat,lng)) return 17;
                            if (poly[1341].contains(lat,lng)) return 267;
                            else return 206;
                        }
                        else
                        if (lng < 32.239975f)
                        {
                            if (poly[1342].contains(lat,lng)) return 17;
                            else return 267;
                        }
                        else
                        {
                            if (poly[1343].contains(lat,lng)) return 206;
                            if (poly[1344].contains(lat,lng)) return 206;
                            if (poly[1345].contains(lat,lng)) return 267;
                            else return 17;
                        }
                    else
                    if (lat < -19.090635f)
                        return 364;
                    else
                    if (lat < -13.609850f)
                        if (lat < -16.350243f)
                        {
                            if (poly[1346].contains(lat,lng)) return 206;
                            else return 364;
                        }
                        else
                        if (lat < -14.980046f)
                        {
                            if (poly[1347].contains(lat,lng)) return 206;
                            else return 364;
                        }
                        else
                        {
                            if (poly[1348].contains(lat,lng)) return 206;
                            if (poly[1349].contains(lat,lng)) return 206;
                            else return 364;
                        }
                    else
                    if (lat < -10.869457f)
                    {
                        if (poly[1350].contains(lat,lng)) return 206;
                        if (poly[1351].contains(lat,lng)) return 364;
                        else return 17;
                    }
                    else
                    {
                        if (poly[1352].contains(lat,lng)) return 206;
                        else return 17;
                    }
                else
                if (lng < 40.443222f)
                    if (lat < -16.279331f)
                        if (lat < -46.609653f)
                            return 169;
                        else
                            return 364;
                    else
                    if (lat < -10.481017f)
                        if (lat < -12.512221f)
                            return 364;
                        else
                        {
                            if (poly[1353].contains(lat,lng)) return 17;
                            else return 364;
                        }
                    else
                        return 17;
                else
                if (lng < 40.842995f)
                    return 364;
                else
                    return 101;
            else
            if (lng < 39.579086f)
                return call21(lat,lng);
            else
            if (lat < -4.865081f)
                return 17;
            else
            if (lat < -1.742535f)
                return 122;
            else
            if (lng < 41.567944f)
            {
                if (poly[1354].contains(lat,lng)) return 250;
                else return 122;
            }
            else
                return 250;
        else
        if (lng < 40.467030f)
            return call23(lat,lng);
        else
        if (lat < 15.249888f)
            if (lat < 13.170722f)
                if (lat < 12.845361f)
                    if (lat < 4.667434f)
                    {
                        if (poly[1355].contains(lat,lng)) return 122;
                        if (poly[1356].contains(lat,lng)) return 250;
                        else return 350;
                    }
                    else
                    if (lat < 11.730194f)
                    {
                        if (poly[1357].contains(lat,lng)) return 250;
                        if (poly[1358].contains(lat,lng)) return 350;
                        else return 311;
                    }
                    else
                    {
                        if (poly[1359].contains(lat,lng)) return 311;
                        if (poly[1360].contains(lat,lng)) return 350;
                        else return 149;
                    }
                else
                if (lng < 42.010485f)
                {
                    if (poly[1361].contains(lat,lng)) return 149;
                    else return 350;
                }
                else
                    return 149;
            else
            if (lng < 42.562199f)
                if (lng < 41.809405f)
                    if (lat < 14.277273f)
                    {
                        if (poly[1362].contains(lat,lng)) return 350;
                        else return 149;
                    }
                    else
                        return 149;
                else
                if (lat < 13.918802f)
                    return 149;
                else
                    return 215;
            else
                return 215;
        else
        if (lng < 41.297417f)
            return 149;
        else
        if (lat < 15.769584f)
            return 215;
        else
        if (lng < 42.506054f)
            return 163;
        else
            return 215;
    }

    private static int call25(float lat, float lng)
    {
        if (lat < 25.886833f)
            if (lng < 38.296612f)
                if (lng < 36.739277f)
                    if (lng < 36.155724f)
                        if (lng < 35.794861f)
                            if (lng < 35.183971f)
                                if (lng < 24.002261f)
                                    if (lng < 15.562867f)
                                    {
                                        if (poly[1363].contains(lat,lng)) return 202;
                                        if (poly[1364].contains(lat,lng)) return 202;
                                        if (poly[1365].contains(lat,lng)) return 202;
                                        if (poly[1366].contains(lat,lng)) return 333;
                                        if (poly[1367].contains(lat,lng)) return 380;
                                        else return 260;
                                    }
                                    else
                                    {
                                        if (poly[1368].contains(lat,lng)) return 260;
                                        if (poly[1369].contains(lat,lng)) return 260;
                                        if (poly[1370].contains(lat,lng)) return 322;
                                        if (poly[1371].contains(lat,lng)) return 333;
                                        else return 202;
                                    }
                                else
                                {
                                    if (poly[1372].contains(lat,lng)) return 322;
                                    if (poly[1373].contains(lat,lng)) return 333;
                                    else return 112;
                                }
                            else
                            if (lat < 23.146889f)
                                if (lng < 35.623360f)
                                {
                                    if (poly[1374].contains(lat,lng)) return 112;
                                    else return 322;
                                }
                                else
                                    return 322;
                            else
                                return 112;
                        else
                            return 322;
                    else
                    if (lat < 22.913195f)
                        return 322;
                    else
                    if (lng < 36.208694f)
                        return 112;
                    else
                        return 163;
                else
                if (lat < 22.173639f)
                    if (lat < 17.632252f)
                    {
                        if (poly[1375].contains(lat,lng)) return 149;
                        else return 322;
                    }
                    else
                        return 322;
                else
                    return 163;
            else
            if (lat < 18.271140f)
                if (lng < 41.825443f)
                    if (lng < 40.183971f)
                        if (lat < 18.003084f)
                            if (lng < 38.562808f)
                            {
                                if (poly[1376].contains(lat,lng)) return 322;
                                else return 149;
                            }
                            else
                                return 149;
                        else
                            return 322;
                    else
                        return 163;
                else
                if (lng < 42.777195f)
                    return 163;
                else
                if (lat < 16.674110f)
                {
                    if (poly[1377].contains(lat,lng)) return 215;
                    else return 163;
                }
                else
                {
                    if (poly[1378].contains(lat,lng)) return 215;
                    else return 163;
                }
            else
                return 163;
        else
        if (lng < 32.013668f)
            if (lng < 26.336222f)
                if (lng < 23.207056f)
                    if (lng < 11.598278f)
                        if (lat < 33.904083f)
                            if (lng < 11.071555f)
                                if (lat < 29.895458f)
                                {
                                    if (poly[1379].contains(lat,lng)) return 380;
                                    else return 333;
                                }
                                else
                                {
                                    if (poly[1380].contains(lat,lng)) return 333;
                                    if (poly[1381].contains(lat,lng)) return 380;
                                    else return 318;
                                }
                            else
                            if (lat < 33.168999f)
                                if (lat < 32.523556f)
                                {
                                    if (poly[1382].contains(lat,lng)) return 318;
                                    else return 333;
                                }
                                else
                                {
                                    if (poly[1383].contains(lat,lng)) return 333;
                                    else return 318;
                                }
                            else
                                return 318;
                        else
                        if (lng < 8.473444f)
                            if (lat < 35.242054f)
                            {
                                if (poly[1384].contains(lat,lng)) return 380;
                                else return 318;
                            }
                            else
                            {
                                if (poly[1385].contains(lat,lng)) return 318;
                                else return 380;
                            }
                        else
                            return 318;
                    else
                    if (lat < 36.082027f)
                        if (lat < 35.877888f)
                            if (lat < 35.528362f)
                                if (lat < 34.318742f)
                                    return 271;
                                else
                                    return 333;
                            else
                            if (lng < 13.613921f)
                                return 271;
                            else
                                return 302;
                        else
                            return 302;
                    else
                        return 152;
                else
                if (lat < 32.286731f)
                    if (lng < 23.294111f)
                        return 333;
                    else
                    {
                        if (poly[1386].contains(lat,lng)) return 112;
                        else return 333;
                    }
                else
                    return 152;
            else
            if (lat < 31.601473f)
                return 112;
            else
            if (lng < 28.246389f)
                return 152;
            else
            if (lng < 29.647083f)
                if (lng < 29.370945f)
                    return 205;
                else
                if (lat < 36.115612f)
                    return 152;
                else
                if (lng < 29.513166f)
                    if (lat < 36.188656f)
                        return 152;
                    else
                        return 205;
                else
                {
                    if (poly[1387].contains(lat,lng)) return 152;
                    else return 205;
                }
            else
                return 205;
        else
        if (lng < 33.897335f)
            if (lat < 31.414772f)
                return 112;
            else
            if (lat < 35.429267f)
                return 174;
            else
                return 205;
        else
        if (lat < 27.855917f)
            if (lng < 34.419202f)
                return 112;
            else
                return 163;
        else
        if (lat < 28.084833f)
            if (lng < 34.444985f)
                return 112;
            else
                return 163;
        else
        if (lat < 34.684856f)
            if (lng < 34.546276f)
                if (lat < 30.429844f)
                {
                    if (poly[1388].contains(lat,lng)) return 8;
                    else return 112;
                }
                else
                if (lat < 31.523390f)
                {
                    if (poly[1389].contains(lat,lng)) return 112;
                    if (poly[1390].contains(lat,lng)) return 255;
                    else return 8;
                }
                else
                {
                    if (poly[1391].contains(lat,lng)) return 255;
                    else return 8;
                }
            else
            if (lng < 34.557480f)
                if (lat < 30.410903f)
                {
                    if (poly[1392].contains(lat,lng)) return 8;
                    else return 112;
                }
                else
                if (lat < 30.494701f)
                {
                    if (poly[1393].contains(lat,lng)) return 112;
                    else return 8;
                }
                else
                {
                    if (poly[1394].contains(lat,lng)) return 112;
                    else return 8;
                }
            else
            if (lng < 38.878267f)
                if (lat < 31.384845f)
                    if (lng < 36.717874f)
                        if (lat < 29.734839f)
                        {
                            if (poly[1395].contains(lat,lng)) return 8;
                            if (poly[1396].contains(lat,lng)) return 112;
                            if (poly[1397].contains(lat,lng)) return 193;
                            else return 163;
                        }
                        else
                        {
                            if (poly[1398].contains(lat,lng)) return 112;
                            if (poly[1399].contains(lat,lng)) return 163;
                            if (poly[1400].contains(lat,lng)) return 193;
                            if (poly[1401].contains(lat,lng)) return 344;
                            else return 8;
                        }
                    else
                    {
                        if (poly[1402].contains(lat,lng)) return 193;
                        else return 163;
                    }
                else
                if (lng < 36.717874f)
                    if (lat < 33.034851f)
                        if (lng < 35.637677f)
                            if (lat < 32.209848f)
                            {
                                if (poly[1403].contains(lat,lng)) return 193;
                                if (poly[1404].contains(lat,lng)) return 344;
                                else return 8;
                            }
                            else
                            {
                                if (poly[1405].contains(lat,lng)) return 193;
                                if (poly[1406].contains(lat,lng)) return 344;
                                if (poly[1407].contains(lat,lng)) return 368;
                                if (poly[1408].contains(lat,lng)) return 368;
                                else return 8;
                            }
                        else
                        {
                            if (poly[1409].contains(lat,lng)) return 8;
                            if (poly[1410].contains(lat,lng)) return 8;
                            if (poly[1411].contains(lat,lng)) return 193;
                            else return 368;
                        }
                    else
                    if (lat < 33.859854f)
                    {
                        if (poly[1412].contains(lat,lng)) return 8;
                        if (poly[1413].contains(lat,lng)) return 368;
                        else return 404;
                    }
                    else
                    {
                        if (poly[1414].contains(lat,lng)) return 368;
                        else return 404;
                    }
                else
                {
                    if (poly[1415].contains(lat,lng)) return 28;
                    if (poly[1416].contains(lat,lng)) return 163;
                    if (poly[1417].contains(lat,lng)) return 368;
                    else return 193;
                }
            else
            {
                if (poly[1418].contains(lat,lng)) return 163;
                if (poly[1419].contains(lat,lng)) return 193;
                if (poly[1420].contains(lat,lng)) return 368;
                else return 28;
            }
        else
        if (lng < 34.597916f)
            if (lat < 35.956875f)
                return 174;
            else
                return 205;
        else
        if (lng < 36.704777f)
        {
            if (poly[1421].contains(lat,lng)) return 205;
            else return 368;
        }
        else
        {
            if (poly[1422].contains(lat,lng)) return 368;
            else return 28;
        }
    }

    private static int call26(float lat, float lng)
    {
        if (lng < 19.449118f)
            if (lat < 46.538750f)
                if (lng < 18.806608f)
                    if (lat < 45.239193f)
                    {
                        if (poly[1423].contains(lat,lng)) return 348;
                        else return 30;
                    }
                    else
                    if (lng < 16.881983f)
                    {
                        if (poly[1424].contains(lat,lng)) return 177;
                        if (poly[1425].contains(lat,lng)) return 198;
                        else return 30;
                    }
                    else
                    {
                        if (poly[1426].contains(lat,lng)) return 30;
                        else return 198;
                    }
                else
                if (lat < 45.712029f)
                {
                    if (poly[1427].contains(lat,lng)) return 30;
                    if (poly[1428].contains(lat,lng)) return 348;
                    else return 209;
                }
                else
                {
                    if (poly[1429].contains(lat,lng)) return 30;
                    if (poly[1430].contains(lat,lng)) return 30;
                    if (poly[1431].contains(lat,lng)) return 198;
                    else return 209;
                }
            else
            if (lat < 48.102692f)
                if (lng < 17.203238f)
                    if (lng < 16.080298f)
                    {
                        if (poly[1432].contains(lat,lng)) return 177;
                        else return 276;
                    }
                    else
                    if (lat < 47.320721f)
                    {
                        if (poly[1433].contains(lat,lng)) return 177;
                        if (poly[1434].contains(lat,lng)) return 276;
                        else return 198;
                    }
                    else
                    {
                        if (poly[1435].contains(lat,lng)) return 162;
                        if (poly[1436].contains(lat,lng)) return 198;
                        else return 276;
                    }
                else
                {
                    if (poly[1437].contains(lat,lng)) return 198;
                    else return 162;
                }
            else
            if (lng < 17.203238f)
                if (lat < 49.580790f)
                {
                    if (poly[1438].contains(lat,lng)) return 162;
                    if (poly[1439].contains(lat,lng)) return 220;
                    if (poly[1440].contains(lat,lng)) return 220;
                    else return 276;
                }
                else
                if (lng < 16.080298f)
                {
                    if (poly[1441].contains(lat,lng)) return 220;
                    else return 186;
                }
                else
                {
                    if (poly[1442].contains(lat,lng)) return 220;
                    else return 186;
                }
            else
            if (lat < 49.580790f)
            {
                if (poly[1443].contains(lat,lng)) return 186;
                if (poly[1444].contains(lat,lng)) return 220;
                else return 162;
            }
            else
            {
                if (poly[1445].contains(lat,lng)) return 162;
                if (poly[1446].contains(lat,lng)) return 220;
                else return 186;
            }
        else
        if (lng < 24.644997f)
            if (lat < 46.189445f)
                if (lng < 22.047057f)
                    if (lng < 20.748087f)
                    {
                        if (poly[1447].contains(lat,lng)) return 198;
                        if (poly[1448].contains(lat,lng)) return 198;
                        if (poly[1449].contains(lat,lng)) return 266;
                        else return 209;
                    }
                    else
                    {
                        if (poly[1450].contains(lat,lng)) return 209;
                        else return 266;
                    }
                else
                    return 266;
            else
            if (lat < 46.192638f)
                if (lng < 20.503389f)
                {
                    if (poly[1451].contains(lat,lng)) return 266;
                    else return 198;
                }
                else
                if (lng < 20.511267f)
                {
                    if (poly[1452].contains(lat,lng)) return 266;
                    else return 198;
                }
                else
                {
                    if (poly[1453].contains(lat,lng)) return 266;
                    else return 198;
                }
            else
            if (lng < 22.047057f)
                if (lat < 48.625763f)
                    if (lng < 20.748087f)
                    {
                        if (poly[1454].contains(lat,lng)) return 198;
                        if (poly[1455].contains(lat,lng)) return 266;
                        else return 162;
                    }
                    else
                    if (lat < 47.409201f)
                    {
                        if (poly[1456].contains(lat,lng)) return 198;
                        else return 266;
                    }
                    else
                    {
                        if (poly[1457].contains(lat,lng)) return 162;
                        if (poly[1458].contains(lat,lng)) return 266;
                        else return 198;
                    }
                else
                {
                    if (poly[1459].contains(lat,lng)) return 162;
                    else return 186;
                }
            else
            if (lat < 48.625763f)
                if (lng < 23.346027f)
                    if (lat < 47.409201f)
                        return 266;
                    else
                    if (lng < 22.696542f)
                    {
                        if (poly[1460].contains(lat,lng)) return 162;
                        if (poly[1461].contains(lat,lng)) return 266;
                        if (poly[1462].contains(lat,lng)) return 387;
                        else return 198;
                    }
                    else
                    {
                        if (poly[1463].contains(lat,lng)) return 198;
                        if (poly[1464].contains(lat,lng)) return 266;
                        else return 387;
                    }
                else
                {
                    if (poly[1465].contains(lat,lng)) return 266;
                    if (poly[1466].contains(lat,lng)) return 275;
                    if (poly[1467].contains(lat,lng)) return 275;
                    else return 387;
                }
            else
            if (lng < 23.346027f)
                if (lat < 49.842325f)
                    if (lng < 22.696542f)
                    {
                        if (poly[1468].contains(lat,lng)) return 162;
                        if (poly[1469].contains(lat,lng)) return 275;
                        if (poly[1470].contains(lat,lng)) return 387;
                        else return 186;
                    }
                    else
                    {
                        if (poly[1471].contains(lat,lng)) return 186;
                        if (poly[1472].contains(lat,lng)) return 186;
                        if (poly[1473].contains(lat,lng)) return 387;
                        else return 275;
                    }
                else
                {
                    if (poly[1474].contains(lat,lng)) return 275;
                    else return 186;
                }
            else
            {
                if (poly[1475].contains(lat,lng)) return 186;
                if (poly[1476].contains(lat,lng)) return 387;
                else return 275;
            }
        else
        if (lat < 47.972097f)
            if (lng < 27.390221f)
            {
                if (poly[1477].contains(lat,lng)) return 275;
                if (poly[1478].contains(lat,lng)) return 294;
                else return 266;
            }
            else
            if (lat < 46.428702f)
                if (lng < 28.762833f)
                {
                    if (poly[1479].contains(lat,lng)) return 266;
                    if (poly[1480].contains(lat,lng)) return 275;
                    else return 294;
                }
                else
                {
                    if (poly[1481].contains(lat,lng)) return 266;
                    if (poly[1482].contains(lat,lng)) return 294;
                    if (poly[1483].contains(lat,lng)) return 294;
                    if (poly[1484].contains(lat,lng)) return 294;
                    if (poly[1485].contains(lat,lng)) return 294;
                    if (poly[1486].contains(lat,lng)) return 294;
                    else return 275;
                }
            else
            if (lng < 28.762833f)
            {
                if (poly[1487].contains(lat,lng)) return 266;
                else return 294;
            }
            else
            if (lat < 47.200400f)
                if (lng < 29.449139f)
                {
                    if (poly[1488].contains(lat,lng)) return 275;
                    if (poly[1489].contains(lat,lng)) return 275;
                    else return 294;
                }
                else
                {
                    if (poly[1490].contains(lat,lng)) return 294;
                    else return 275;
                }
            else
            {
                if (poly[1491].contains(lat,lng)) return 294;
                else return 275;
            }
        else
        if (lng < 27.390221f)
            if (lat < 49.515492f)
                if (lng < 26.017609f)
                {
                    if (poly[1492].contains(lat,lng)) return 266;
                    else return 275;
                }
                else
                if (lat < 48.743795f)
                    if (lng < 26.703915f)
                    {
                        if (poly[1493].contains(lat,lng)) return 266;
                        if (poly[1494].contains(lat,lng)) return 294;
                        else return 275;
                    }
                    else
                    {
                        if (poly[1495].contains(lat,lng)) return 266;
                        if (poly[1496].contains(lat,lng)) return 275;
                        else return 294;
                    }
                else
                    return 275;
            else
                return 275;
        else
        {
            if (poly[1497].contains(lat,lng)) return 294;
            if (poly[1498].contains(lat,lng)) return 294;
            else return 275;
        }
    }

    private static int call27(float lat, float lng)
    {
        if (lat < 51.058887f)
            if (lng < 30.135445f)
                if (lng < 14.957358f)
                    if (lat < 45.246277f)
                        return 30;
                    else
                    if (lat < 46.630390f)
                        if (lng < 13.369805f)
                            if (lat < 45.721138f)
                                return 271;
                            else
                            {
                                if (poly[1499].contains(lat,lng)) return 276;
                                else return 271;
                            }
                        else
                        if (lat < 45.749973f)
                            if (lng < 13.470082f)
                                return 271;
                            else
                            if (lng < 13.552361f)
                                if (lat < 45.506027f)
                                    return 30;
                                else
                                    return 271;
                            else
                            {
                                if (poly[1500].contains(lat,lng)) return 177;
                                if (poly[1501].contains(lat,lng)) return 271;
                                else return 30;
                            }
                        else
                        if (lng < 14.955778f)
                        {
                            if (poly[1502].contains(lat,lng)) return 271;
                            if (poly[1503].contains(lat,lng)) return 276;
                            else return 177;
                        }
                        else
                        {
                            if (poly[1504].contains(lat,lng)) return 276;
                            else return 177;
                        }
                    else
                    if (lat < 47.915885f)
                        if (lat < 47.721027f)
                        {
                            if (poly[1505].contains(lat,lng)) return 6;
                            else return 276;
                        }
                        else
                        {
                            if (poly[1506].contains(lat,lng)) return 6;
                            else return 276;
                        }
                    else
                    if (lat < 49.336078f)
                        if (lng < 13.960470f)
                        {
                            if (poly[1507].contains(lat,lng)) return 220;
                            if (poly[1508].contains(lat,lng)) return 276;
                            else return 6;
                        }
                        else
                        {
                            if (poly[1509].contains(lat,lng)) return 276;
                            if (poly[1510].contains(lat,lng)) return 276;
                            else return 220;
                        }
                    else
                    {
                        if (poly[1511].contains(lat,lng)) return 6;
                        if (poly[1512].contains(lat,lng)) return 186;
                        else return 220;
                    }
                else
                    return call26(lat,lng);
            else
            if (lng < 32.325027f)
                return 275;
            else
            if (lng < 33.260555f)
                if (lat < 45.807167f)
                    return 197;
                else
                    return 275;
            else
            if (lng < 37.223877f)
                if (lat < 45.442917f)
                    if (lng < 36.583805f)
                    {
                        if (poly[1513].contains(lat,lng)) return 183;
                        else return 197;
                    }
                    else
                    {
                        if (poly[1514].contains(lat,lng)) return 197;
                        else return 183;
                    }
                else
                if (lat < 45.476776f)
                    return 197;
                else
                if (lat < 48.130928f)
                    if (lng < 35.246422f)
                        if (lat < 46.282494f)
                            if (lng < 34.253489f)
                            {
                                if (poly[1515].contains(lat,lng)) return 197;
                                else return 275;
                            }
                            else
                            {
                                if (poly[1516].contains(lat,lng)) return 146;
                                if (poly[1517].contains(lat,lng)) return 197;
                                else return 275;
                            }
                        else
                        if (lng < 34.253489f)
                        {
                            if (poly[1518].contains(lat,lng)) return 146;
                            else return 275;
                        }
                        else
                        if (lat < 47.206711f)
                        {
                            if (poly[1519].contains(lat,lng)) return 275;
                            else return 146;
                        }
                        else
                        {
                            if (poly[1520].contains(lat,lng)) return 146;
                            else return 275;
                        }
                    else
                    if (lng < 36.235149f)
                    {
                        if (poly[1521].contains(lat,lng)) return 275;
                        else return 146;
                    }
                    else
                    {
                        if (poly[1522].contains(lat,lng)) return 275;
                        if (poly[1523].contains(lat,lng)) return 275;
                        else return 146;
                    }
                else
                if (lng < 35.303777f)
                {
                    if (poly[1524].contains(lat,lng)) return 183;
                    else return 275;
                }
                else
                {
                    if (poly[1525].contains(lat,lng)) return 183;
                    else return 275;
                }
            else
            if (lat < 46.770611f)
                return 183;
            else
            if (lng < 40.207390f)
                if (lat < 48.914749f)
                    if (lng < 38.715633f)
                    {
                        if (poly[1526].contains(lat,lng)) return 183;
                        if (poly[1527].contains(lat,lng)) return 183;
                        else return 275;
                    }
                    else
                    {
                        if (poly[1528].contains(lat,lng)) return 275;
                        else return 183;
                    }
                else
                {
                    if (poly[1529].contains(lat,lng)) return 275;
                    else return 183;
                }
            else
            if (lat < 48.914749f)
            {
                if (poly[1530].contains(lat,lng)) return 99;
                else return 183;
            }
            else
            {
                if (poly[1531].contains(lat,lng)) return 183;
                else return 99;
            }
        else
        if (lng < 15.497833f)
            if (lat < 54.210609f)
                if (lng < 13.778584f)
                    return 6;
                else
                if (lng < 13.804861f)
                    return 6;
                else
                if (lng < 14.358836f)
                    if (lat < 53.741001f)
                        if (lat < 53.088120f)
                        {
                            if (poly[1532].contains(lat,lng)) return 186;
                            else return 6;
                        }
                        else
                        {
                            if (poly[1533].contains(lat,lng)) return 186;
                            else return 6;
                        }
                    else
                    if (lng < 14.092113f)
                        return 6;
                    else
                    if (lat < 53.759693f)
                        return 6;
                    else
                    if (lng < 14.224361f)
                    {
                        if (poly[1534].contains(lat,lng)) return 186;
                        else return 6;
                    }
                    else
                        return 186;
                else
                if (lat < 53.467436f)
                    if (lat < 52.747607f)
                    {
                        if (poly[1535].contains(lat,lng)) return 6;
                        else return 186;
                    }
                    else
                    {
                        if (poly[1536].contains(lat,lng)) return 6;
                        else return 186;
                    }
                else
                    return 186;
            else
            if (lat < 54.683807f)
                return 6;
            else
            if (lat < 55.300140f)
                return 319;
            else
                return 375;
        else
        if (lng < 16.890838f)
            if (lat < 54.592905f)
                return 186;
            else
                return 375;
        else
        if (lng < 35.202944f)
            if (lng < 22.892805f)
                if (lat < 55.724445f)
                    if (lat < 54.813721f)
                    {
                        if (poly[1537].contains(lat,lng)) return 53;
                        if (poly[1538].contains(lat,lng)) return 175;
                        if (poly[1539].contains(lat,lng)) return 175;
                        else return 186;
                    }
                    else
                    if (lng < 18.363342f)
                        return 186;
                    else
                    {
                        if (poly[1540].contains(lat,lng)) return 53;
                        if (poly[1541].contains(lat,lng)) return 53;
                        else return 175;
                    }
                else
                {
                    if (poly[1542].contains(lat,lng)) return 53;
                    else return 332;
                }
            else
            if (lng < 29.047875f)
                if (lng < 25.970340f)
                    if (lat < 53.979597f)
                        if (lng < 24.431573f)
                            if (lat < 52.519242f)
                                if (lng < 23.662189f)
                                {
                                    if (poly[1543].contains(lat,lng)) return 275;
                                    if (poly[1544].contains(lat,lng)) return 275;
                                    if (poly[1545].contains(lat,lng)) return 275;
                                    if (poly[1546].contains(lat,lng)) return 275;
                                    if (poly[1547].contains(lat,lng)) return 399;
                                    if (poly[1548].contains(lat,lng)) return 399;
                                    else return 186;
                                }
                                else
                                {
                                    if (poly[1549].contains(lat,lng)) return 186;
                                    if (poly[1550].contains(lat,lng)) return 186;
                                    if (poly[1551].contains(lat,lng)) return 186;
                                    if (poly[1552].contains(lat,lng)) return 186;
                                    if (poly[1553].contains(lat,lng)) return 399;
                                    if (poly[1554].contains(lat,lng)) return 399;
                                    else return 275;
                                }
                            else
                            {
                                if (poly[1555].contains(lat,lng)) return 53;
                                if (poly[1556].contains(lat,lng)) return 186;
                                else return 399;
                            }
                        else
                        {
                            if (poly[1557].contains(lat,lng)) return 53;
                            if (poly[1558].contains(lat,lng)) return 53;
                            if (poly[1559].contains(lat,lng)) return 275;
                            else return 399;
                        }
                    else
                    if (lng < 24.431573f)
                    {
                        if (poly[1560].contains(lat,lng)) return 186;
                        if (poly[1561].contains(lat,lng)) return 332;
                        else return 53;
                    }
                    else
                    {
                        if (poly[1562].contains(lat,lng)) return 332;
                        if (poly[1563].contains(lat,lng)) return 399;
                        if (poly[1564].contains(lat,lng)) return 399;
                        else return 53;
                    }
                else
                if (lat < 53.979597f)
                {
                    if (poly[1565].contains(lat,lng)) return 399;
                    else return 275;
                }
                else
                if (lng < 27.509107f)
                    if (lat < 55.439952f)
                    {
                        if (poly[1566].contains(lat,lng)) return 53;
                        else return 399;
                    }
                    else
                    {
                        if (poly[1567].contains(lat,lng)) return 53;
                        if (poly[1568].contains(lat,lng)) return 399;
                        else return 332;
                    }
                else
                {
                    if (poly[1569].contains(lat,lng)) return 332;
                    if (poly[1570].contains(lat,lng)) return 399;
                    else return 183;
                }
            else
            if (lng < 32.125410f)
                if (lat < 53.979597f)
                    if (lng < 30.586642f)
                    {
                        if (poly[1571].contains(lat,lng)) return 275;
                        if (poly[1572].contains(lat,lng)) return 275;
                        if (poly[1573].contains(lat,lng)) return 275;
                        if (poly[1574].contains(lat,lng)) return 275;
                        else return 399;
                    }
                    else
                    if (lat < 52.519242f)
                    {
                        if (poly[1575].contains(lat,lng)) return 183;
                        if (poly[1576].contains(lat,lng)) return 275;
                        else return 399;
                    }
                    else
                    {
                        if (poly[1577].contains(lat,lng)) return 399;
                        else return 183;
                    }
                else
                if (lng < 30.586642f)
                {
                    if (poly[1578].contains(lat,lng)) return 399;
                    else return 183;
                }
                else
                {
                    if (poly[1579].contains(lat,lng)) return 399;
                    else return 183;
                }
            else
            if (lat < 53.979597f)
                if (lng < 33.664177f)
                {
                    if (poly[1580].contains(lat,lng)) return 275;
                    if (poly[1581].contains(lat,lng)) return 399;
                    else return 183;
                }
                else
                {
                    if (poly[1582].contains(lat,lng)) return 275;
                    else return 183;
                }
            else
                return 183;
        else
        if (lng < 35.416372f)
        {
            if (poly[1583].contains(lat,lng)) return 275;
            else return 183;
        }
        else
        {
            if (poly[1584].contains(lat,lng)) return 99;
            else return 183;
        }
    }

    private static int call28(float lat, float lng)
    {
        if (lng < 21.254360f)
            if (lat < 41.371582f)
                if (lng < 16.637009f)
                    if (lat < 37.543915f)
                        if (lng < 11.135750f)
                            if (lng < 8.672028f)
                                if (lat < 36.824917f)
                                {
                                    if (poly[1585].contains(lat,lng)) return 318;
                                    else return 380;
                                }
                                else
                                {
                                    if (poly[1586].contains(lat,lng)) return 318;
                                    else return 380;
                                }
                            else
                                return 318;
                        else
                            return 271;
                    else
                        return 271;
                else
                if (lat < 38.677971f)
                    return 152;
                else
                if (lng < 19.537333f)
                    if (lng < 18.513445f)
                        return 271;
                    else
                    if (lat < 39.873859f)
                        return 152;
                    else
                        return 75;
                else
                if (lat < 39.251167f)
                    return 152;
                else
                if (lng < 19.598167f)
                    if (lat < 40.038214f)
                        return 75;
                    else
                        return 152;
                else
                if (lat < 40.311375f)
                {
                    if (poly[1587].contains(lat,lng)) return 75;
                    else return 152;
                }
                else
                {
                    if (poly[1588].contains(lat,lng)) return 152;
                    if (poly[1589].contains(lat,lng)) return 337;
                    else return 75;
                }
            else
            if (lng < 15.454583f)
                if (lat < 44.272278f)
                    if (lng < 11.115666f)
                        if (lng < 9.561556f)
                            if (lng < 8.461638f)
                                if (lat < 43.769527f)
                                {
                                    if (poly[1590].contains(lat,lng)) return 261;
                                    else return 297;
                                }
                                else
                                {
                                    if (poly[1591].contains(lat,lng)) return 297;
                                    else return 271;
                                }
                            else
                            if (lat < 43.606562f)
                                return 271;
                            else
                                return 297;
                        else
                            return 271;
                    else
                    if (lat < 43.999805f)
                        if (lng < 15.228278f)
                            if (lng < 12.515555f)
                            {
                                if (poly[1592].contains(lat,lng)) return 313;
                                else return 271;
                            }
                            else
                            {
                                if (poly[1593].contains(lat,lng)) return 30;
                                if (poly[1594].contains(lat,lng)) return 30;
                                if (poly[1595].contains(lat,lng)) return 30;
                                else return 271;
                            }
                        else
                        if (lat < 41.926615f)
                            return 271;
                        else
                            return 30;
                    else
                    if (lng < 12.678526f)
                        return 271;
                    else
                        return 30;
                else
                if (lng < 12.496844f)
                    return 271;
                else
                    return 30;
            else
            if (lng < 16.283112f)
                if (lat < 43.460499f)
                    if (lat < 42.126751f)
                        return 271;
                    else
                        return 30;
                else
                if (lat < 43.866528f)
                    return 30;
                else
                {
                    if (poly[1596].contains(lat,lng)) return 348;
                    else return 30;
                }
            else
            if (lng < 17.754278f)
                if (lat < 42.806278f)
                    return 30;
                else
                if (lat < 43.099861f)
                    if (lng < 17.201416f)
                        return 30;
                    else
                    {
                        if (poly[1597].contains(lat,lng)) return 348;
                        else return 30;
                    }
                else
                if (lat < 43.236000f)
                    if (lng < 17.194445f)
                        return 30;
                    else
                    {
                        if (poly[1598].contains(lat,lng)) return 348;
                        else return 30;
                    }
                else
                {
                    if (poly[1599].contains(lat,lng)) return 348;
                    else return 30;
                }
            else
            if (lng < 18.018444f)
                if (lat < 42.755833f)
                    return 30;
                else
                {
                    if (poly[1600].contains(lat,lng)) return 348;
                    else return 30;
                }
            else
            if (lng < 19.088497f)
                if (lat < 43.558743f)
                    if (lat < 42.091462f)
                        return 212;
                    else
                    if (lat < 42.833974f)
                    {
                        if (poly[1601].contains(lat,lng)) return 30;
                        if (poly[1602].contains(lat,lng)) return 348;
                        else return 212;
                    }
                    else
                    {
                        if (poly[1603].contains(lat,lng)) return 212;
                        else return 348;
                    }
                else
                {
                    if (poly[1604].contains(lat,lng)) return 30;
                    if (poly[1605].contains(lat,lng)) return 209;
                    else return 348;
                }
            else
            if (lat < 43.128445f)
                if (lng < 20.171428f)
                    if (lat < 42.250013f)
                    {
                        if (poly[1606].contains(lat,lng)) return 212;
                        else return 75;
                    }
                    else
                    {
                        if (poly[1607].contains(lat,lng)) return 75;
                        if (poly[1608].contains(lat,lng)) return 209;
                        if (poly[1609].contains(lat,lng)) return 209;
                        else return 212;
                    }
                else
                if (lat < 42.250013f)
                {
                    if (poly[1610].contains(lat,lng)) return 75;
                    if (poly[1611].contains(lat,lng)) return 209;
                    else return 337;
                }
                else
                {
                    if (poly[1612].contains(lat,lng)) return 75;
                    if (poly[1613].contains(lat,lng)) return 212;
                    else return 209;
                }
            else
            if (lng < 20.171428f)
                if (lat < 44.006876f)
                {
                    if (poly[1614].contains(lat,lng)) return 212;
                    if (poly[1615].contains(lat,lng)) return 348;
                    if (poly[1616].contains(lat,lng)) return 348;
                    else return 209;
                }
                else
                {
                    if (poly[1617].contains(lat,lng)) return 209;
                    if (poly[1618].contains(lat,lng)) return 209;
                    else return 348;
                }
            else
                return 209;
        else
        if (lng < 25.743999f)
            if (lat < 40.022305f)
                return 152;
            else
            if (lat < 40.350529f)
                if (lng < 25.432277f)
                    return 152;
                else
                    return 205;
            else
            if (lat < 40.806194f)
                return 152;
            else
            if (lat < 41.580002f)
                if (lng < 23.499180f)
                {
                    if (poly[1619].contains(lat,lng)) return 337;
                    if (poly[1620].contains(lat,lng)) return 340;
                    else return 152;
                }
                else
                {
                    if (poly[1621].contains(lat,lng)) return 340;
                    else return 152;
                }
            else
            if (lng < 23.499180f)
                if (lat < 43.232655f)
                    if (lng < 22.376770f)
                    {
                        if (poly[1622].contains(lat,lng)) return 337;
                        if (poly[1623].contains(lat,lng)) return 340;
                        else return 209;
                    }
                    else
                    {
                        if (poly[1624].contains(lat,lng)) return 209;
                        if (poly[1625].contains(lat,lng)) return 337;
                        else return 340;
                    }
                else
                if (lng < 22.376770f)
                {
                    if (poly[1626].contains(lat,lng)) return 266;
                    if (poly[1627].contains(lat,lng)) return 340;
                    else return 209;
                }
                else
                if (lat < 44.058981f)
                {
                    if (poly[1628].contains(lat,lng)) return 209;
                    if (poly[1629].contains(lat,lng)) return 209;
                    if (poly[1630].contains(lat,lng)) return 266;
                    else return 340;
                }
                else
                {
                    if (poly[1631].contains(lat,lng)) return 209;
                    if (poly[1632].contains(lat,lng)) return 340;
                    else return 266;
                }
            else
            {
                if (poly[1633].contains(lat,lng)) return 340;
                else return 266;
            }
        else
        if (lat < 37.410751f)
            if (lng < 27.176777f)
                return 152;
            else
            if (lng < 27.874916f)
                if (lat < 36.917999f)
                    if (lng < 27.357195f)
                        return 152;
                    else
                    if (lat < 36.640251f)
                        if (lat < 36.533819f)
                            return 152;
                        else
                            return 205;
                    else
                        return 205;
                else
                if (lng < 27.224751f)
                    if (lat < 37.182851f)
                        return 152;
                    else
                        return 205;
                else
                    return 205;
            else
            if (lng < 35.659962f)
                return 205;
            else
            if (lng < 35.722252f)
                return 205;
            else
            if (lng < 39.460653f)
            {
                if (poly[1634].contains(lat,lng)) return 368;
                else return 205;
            }
            else
            {
                if (poly[1635].contains(lat,lng)) return 28;
                if (poly[1636].contains(lat,lng)) return 368;
                else return 205;
            }
        else
        if (lat < 39.399502f)
            if (lat < 37.814610f)
                if (lng < 26.808306f)
                    return 152;
                else
                if (lng < 27.069723f)
                    if (lat < 37.476891f)
                        return 152;
                    else
                    {
                        if (poly[1637].contains(lat,lng)) return 205;
                        else return 152;
                    }
                else
                    return 205;
            else
            if (lng < 26.619278f)
                if (lat < 38.682251f)
                    if (lng < 26.165445f)
                        return 152;
                    else
                    if (lng < 26.294640f)
                        if (lat < 38.379166f)
                            return 205;
                        else
                            return 152;
                    else
                        return 205;
                else
                if (lng < 26.603834f)
                    if (lng < 25.845306f)
                        return 152;
                    else
                    if (lat < 39.307919f)
                    {
                        if (poly[1638].contains(lat,lng)) return 205;
                        else return 152;
                    }
                    else
                    if (lng < 26.500569f)
                        return 152;
                    else
                        return 205;
                else
                if (lat < 39.053222f)
                    return 152;
                else
                    return 205;
            else
                return 205;
        else
        if (lat < 40.677166f)
            return 205;
        else
        if (lng < 29.620806f)
            if (lat < 42.107613f)
                if (lng < 28.043638f)
                    if (lng < 26.893819f)
                        if (lat < 41.392389f)
                        {
                            if (poly[1639].contains(lat,lng)) return 205;
                            if (poly[1640].contains(lat,lng)) return 340;
                            else return 152;
                        }
                        else
                        {
                            if (poly[1641].contains(lat,lng)) return 152;
                            if (poly[1642].contains(lat,lng)) return 205;
                            else return 340;
                        }
                    else
                    {
                        if (poly[1643].contains(lat,lng)) return 340;
                        else return 205;
                    }
                else
                    return 205;
            else
            if (lng < 28.612167f)
            {
                if (poly[1644].contains(lat,lng)) return 266;
                else return 340;
            }
            else
                return 266;
        else
        if (lng < 35.162596f)
            if (lat < 43.246111f)
                return 197;
            else
                return 205;
        else
        if (lng < 35.221638f)
            return 205;
        else
        if (lat < 41.763479f)
        {
            if (poly[1645].contains(lat,lng)) return 47;
            else return 205;
        }
        else
        if (lng < 40.250756f)
        {
            if (poly[1646].contains(lat,lng)) return 47;
            else return 183;
        }
        else
        {
            if (poly[1647].contains(lat,lng)) return 183;
            else return 47;
        }
    }

    private static int call29(float lat, float lng)
    {
        if (lat < 63.393749f)
            if (lng < 21.000000f)
                if (lat < 60.100693f)
                    if (lng < 18.507584f)
                        if (lng < 17.594973f)
                            if (lng < 10.975583f)
                                return 355;
                            else
                            if (lat < 58.861279f)
                                return 375;
                            else
                            if (lng < 11.114695f)
                                if (lat < 58.967918f)
                                    return 375;
                                else
                                    return 355;
                            else
                            if (lng < 12.483325f)
                                if (lat < 58.893585f)
                                    if (lng < 11.183945f)
                                        return 375;
                                    else
                                    {
                                        if (poly[1648].contains(lat,lng)) return 355;
                                        else return 375;
                                    }
                                else
                                if (lng < 11.471500f)
                                    if (lat < 58.996334f)
                                        if (lng < 11.169000f)
                                            return 375;
                                        else
                                        {
                                            if (poly[1649].contains(lat,lng)) return 355;
                                            else return 375;
                                        }
                                    else
                                    {
                                        if (poly[1650].contains(lat,lng)) return 375;
                                        else return 355;
                                    }
                                else
                                {
                                    if (poly[1651].contains(lat,lng)) return 375;
                                    else return 355;
                                }
                            else
                                return 375;
                        else
                            return 375;
                    else
                    if (lng < 19.165695f)
                        return 375;
                    else
                    if (lng < 19.207306f)
                        return 375;
                    else
                        return 188;
                else
                if (lng < 19.480333f)
                    if (lng < 17.196722f)
                        if (lng < 9.436603f)
                            return 355;
                        else
                        if (lng < 12.874028f)
                            if (lat < 61.360279f)
                            {
                                if (poly[1652].contains(lat,lng)) return 375;
                                else return 355;
                            }
                            else
                            {
                                if (poly[1653].contains(lat,lng)) return 375;
                                else return 355;
                            }
                        else
                            return 375;
                    else
                        return 375;
                else
                if (lat < 60.473862f)
                    return 188;
                else
                if (lng < 20.865360f)
                    return 323;
                else
                    return 188;
            else
            if (lng < 21.912750f)
                if (lng < 21.153862f)
                    if (lat < 60.560112f)
                        return 188;
                    else
                        return 323;
                else
                    return 323;
            else
            if (lng < 23.447250f)
                if (lat < 59.306194f)
                    return 49;
                else
                    return 323;
            else
            if (lng < 26.259001f)
                if (lat < 59.687946f)
                    return 49;
                else
                    return 323;
            else
            if (lng < 27.435055f)
                if (lat < 60.110668f)
                    if (lat < 59.586161f)
                        return 49;
                    else
                        return 183;
                else
                    return 323;
            else
            if (lng < 28.407444f)
                if (lat < 60.044083f)
                    if (lat < 59.470806f)
                    {
                        if (poly[1654].contains(lat,lng)) return 183;
                        else return 49;
                    }
                    else
                        return 183;
                else
                if (lat < 60.457390f)
                    return 183;
                else
                if (lng < 27.854750f)
                    if (lat < 60.525665f)
                        if (lng < 27.745832f)
                            return 323;
                        else
                            return 183;
                    else
                    {
                        if (poly[1655].contains(lat,lng)) return 183;
                        else return 323;
                    }
                else
                if (lat < 60.485054f)
                    return 183;
                else
                {
                    if (poly[1656].contains(lat,lng)) return 323;
                    else return 183;
                }
            else
            if (lat < 60.750500f)
                return 183;
            else
            {
                if (poly[1657].contains(lat,lng)) return 323;
                else return 183;
            }
        else
        if (lat < 66.493835f)
            if (lng < 21.873028f)
                if (lng < 12.043694f)
                    return 355;
                else
                if (lat < 65.745277f)
                    if (lng < 20.798334f)
                        if (lng < 14.575282f)
                            if (lng < 12.227278f)
                                if (lat < 63.632717f)
                                {
                                    if (poly[1658].contains(lat,lng)) return 375;
                                    else return 355;
                                }
                                else
                                    return 355;
                            else
                            if (lat < 65.221085f)
                            {
                                if (poly[1659].contains(lat,lng)) return 375;
                                else return 355;
                            }
                            else
                            if (lng < 12.453417f)
                                return 355;
                            else
                            {
                                if (poly[1660].contains(lat,lng)) return 375;
                                else return 355;
                            }
                        else
                            return 375;
                    else
                    if (lat < 63.464695f)
                        return 323;
                    else
                        return 375;
                else
                if (lng < 13.186111f)
                    return 355;
                else
                {
                    if (poly[1661].contains(lat,lng)) return 375;
                    else return 355;
                }
            else
            if (lng < 33.387779f)
                if (lng < 22.965139f)
                    if (lat < 65.340164f)
                        if (lng < 21.957138f)
                            return 375;
                        else
                            return 323;
                    else
                        return 375;
                else
                if (lng < 24.163279f)
                    if (lat < 65.677864f)
                        if (lat < 64.456893f)
                            return 323;
                        else
                            return 375;
                    else
                    if (lng < 23.574472f)
                        return 375;
                    else
                    if (lat < 65.717720f)
                        return 375;
                    else
                    if (lat < 65.759140f)
                        if (lng < 23.981722f)
                            return 323;
                        else
                            return 375;
                    else
                    {
                        if (poly[1662].contains(lat,lng)) return 323;
                        else return 375;
                    }
                else
                if (lng < 25.360001f)
                    return 323;
                else
                {
                    if (poly[1663].contains(lat,lng)) return 183;
                    else return 323;
                }
            else
                return 183;
        else
        if (lat < 69.757027f)
            if (lng < 15.314777f)
                return 355;
            else
            if (lng < 32.329250f)
                if (lng < 16.755695f)
                    if (lat < 67.925449f)
                    {
                        if (poly[1664].contains(lat,lng)) return 375;
                        else return 355;
                    }
                    else
                        return 355;
                else
                if (lng < 18.256083f)
                    if (lat < 68.558932f)
                    {
                        if (poly[1665].contains(lat,lng)) return 375;
                        else return 355;
                    }
                    else
                        return 355;
                else
                if (lng < 26.171008f)
                    if (lng < 19.024416f)
                        if (lat < 68.584389f)
                            if (lng < 18.417805f)
                            {
                                if (poly[1666].contains(lat,lng)) return 355;
                                else return 375;
                            }
                            else
                            {
                                if (poly[1667].contains(lat,lng)) return 355;
                                else return 375;
                            }
                        else
                            return 355;
                    else
                    if (lng < 22.597712f)
                        if (lng < 20.811064f)
                        {
                            if (poly[1668].contains(lat,lng)) return 323;
                            if (poly[1669].contains(lat,lng)) return 375;
                            else return 355;
                        }
                        else
                        {
                            if (poly[1670].contains(lat,lng)) return 355;
                            if (poly[1671].contains(lat,lng)) return 375;
                            else return 323;
                        }
                    else
                    if (lng < 24.384360f)
                    {
                        if (poly[1672].contains(lat,lng)) return 355;
                        if (poly[1673].contains(lat,lng)) return 375;
                        else return 323;
                    }
                    else
                    {
                        if (poly[1674].contains(lat,lng)) return 355;
                        else return 323;
                    }
                else
                if (lng < 30.945389f)
                    if (lng < 28.558198f)
                    {
                        if (poly[1675].contains(lat,lng)) return 183;
                        if (poly[1676].contains(lat,lng)) return 183;
                        else return 323;
                    }
                    else
                    if (lat < 68.125431f)
                    {
                        if (poly[1677].contains(lat,lng)) return 323;
                        else return 183;
                    }
                    else
                    {
                        if (poly[1678].contains(lat,lng)) return 183;
                        if (poly[1679].contains(lat,lng)) return 183;
                        if (poly[1680].contains(lat,lng)) return 323;
                        if (poly[1681].contains(lat,lng)) return 323;
                        if (poly[1682].contains(lat,lng)) return 323;
                        else return 355;
                    }
                else
                    return 183;
            else
                return 183;
        else
        if (lat < 76.436279f)
            if (lng < 21.929611f)
                if (lat < 70.395920f)
                    return 355;
                else
                    return 111;
            else
            if (lat < 70.096054f)
                if (lng < 30.098833f)
                    if (lng < 28.792934f)
                        if (lng < 22.034249f)
                            return 355;
                        else
                        {
                            if (poly[1683].contains(lat,lng)) return 323;
                            else return 355;
                        }
                    else
                        return 355;
                else
                if (lng < 30.400282f)
                    return 355;
                else
                if (lng < 30.856945f)
                {
                    if (poly[1684].contains(lat,lng)) return 183;
                    else return 355;
                }
                else
                    return 183;
            else
                return 355;
        else
            return 111;
    }

    private static int call30(float lat, float lng)
    {
        if (lat < 11.098028f)
            if (lat < 9.890555f)
                if (lat < 8.278500f)
                    return 270;
                else
                if (lng < 98.502388f)
                    if (lng < 98.175087f)
                        if (lng < 97.912476f)
                            return 270;
                        else
                            return 40;
                    else
                        return 270;
                else
                if (lng < 100.258641f)
                    return 270;
                else
                    return 24;
            else
            if (lng < 98.470779f)
                return 40;
            else
            if (lng < 102.955833f)
                if (lng < 98.630722f)
                    if (lat < 10.036747f)
                        if (lng < 98.503304f)
                            if (lat < 9.908667f)
                                return 270;
                            else
                                return 40;
                        else
                        if (lng < 98.551109f)
                            return 40;
                        else
                        {
                            if (poly[1685].contains(lat,lng)) return 40;
                            else return 270;
                        }
                    else
                        return 40;
                else
                if (lng < 99.519447f)
                    if (lng < 99.223419f)
                        if (lat < 10.941639f)
                        {
                            if (poly[1686].contains(lat,lng)) return 40;
                            if (poly[1687].contains(lat,lng)) return 40;
                            else return 270;
                        }
                        else
                        if (lng < 98.707916f)
                            return 40;
                        else
                        {
                            if (poly[1688].contains(lat,lng)) return 270;
                            else return 40;
                        }
                    else
                        return 270;
                else
                if (lng < 99.855583f)
                    return 270;
                else
                    return 251;
            else
            if (lng < 103.821335f)
                return 251;
            else
            if (lat < 10.323584f)
                return 24;
            else
            if (lng < 104.078867f)
                if (lat < 10.498389f)
                    return 24;
                else
                    return 251;
            else
            if (lng < 104.334137f)
                return 251;
            else
            {
                if (poly[1689].contains(lat,lng)) return 251;
                else return 24;
            }
        else
        if (lat < 12.230139f)
            if (lng < 98.681419f)
                return 40;
            else
            if (lng < 102.919525f)
                if (lng < 100.020752f)
                    if (lng < 98.690804f)
                        return 40;
                    else
                    {
                        if (poly[1690].contains(lat,lng)) return 270;
                        else return 40;
                    }
                else
                if (lng < 102.610809f)
                    return 270;
                else
                {
                    if (poly[1691].contains(lat,lng)) return 251;
                    else return 270;
                }
            else
                return 251;
        else
        if (lat < 12.614500f)
            if (lng < 98.613220f)
                return 40;
            else
            if (lng < 100.972930f)
                if (lng < 99.497317f)
                {
                    if (poly[1692].contains(lat,lng)) return 270;
                    else return 40;
                }
                else
                    return 270;
            else
            if (lng < 102.244331f)
                return 270;
            else
            {
                if (poly[1693].contains(lat,lng)) return 251;
                else return 270;
            }
        else
        if (lng < 98.224945f)
            if (lat < 14.414500f)
                return 40;
            else
            if (lat < 16.337936f)
                if (lng < 97.888252f)
                    return 40;
                else
                if (lat < 15.008137f)
                {
                    if (poly[1694].contains(lat,lng)) return 270;
                    else return 40;
                }
                else
                {
                    if (poly[1695].contains(lat,lng)) return 270;
                    else return 40;
                }
            else
            if (lat < 17.826316f)
                if (lat < 16.375928f)
                    return 40;
                else
                {
                    if (poly[1696].contains(lat,lng)) return 270;
                    else return 40;
                }
            else
            if (lat < 18.056516f)
            {
                if (poly[1697].contains(lat,lng)) return 40;
                else return 270;
            }
            else
            if (lat < 18.916257f)
            {
                if (poly[1698].contains(lat,lng)) return 40;
                else return 270;
            }
            else
            {
                if (poly[1699].contains(lat,lng)) return 270;
                else return 40;
            }
        else
        if (lng < 99.394151f)
            if (lat < 12.907416f)
                if (lng < 98.699638f)
                    return 40;
                else
                {
                    if (poly[1700].contains(lat,lng)) return 270;
                    else return 40;
                }
            else
            if (lat < 14.976789f)
                if (lng < 98.335114f)
                    if (lat < 13.213333f)
                        return 40;
                    else
                    {
                        if (poly[1701].contains(lat,lng)) return 270;
                        else return 40;
                    }
                else
                if (lat < 12.936528f)
                    if (lng < 98.556503f)
                        return 40;
                    else
                    {
                        if (poly[1702].contains(lat,lng)) return 270;
                        else return 40;
                    }
                else
                {
                    if (poly[1703].contains(lat,lng)) return 270;
                    else return 40;
                }
            else
            if (lat < 15.059563f)
            {
                if (poly[1704].contains(lat,lng)) return 40;
                else return 270;
            }
            else
            if (lat < 17.224167f)
                if (lat < 16.141865f)
                {
                    if (poly[1705].contains(lat,lng)) return 40;
                    else return 270;
                }
                else
                {
                    if (poly[1706].contains(lat,lng)) return 40;
                    else return 270;
                }
            else
            {
                if (poly[1707].contains(lat,lng)) return 40;
                else return 270;
            }
        else
        if (lat < 14.439500f)
            if (lng < 100.822113f)
                return 270;
            else
            if (lng < 103.662552f)
            {
                if (poly[1708].contains(lat,lng)) return 251;
                else return 270;
            }
            else
            {
                if (poly[1709].contains(lat,lng)) return 270;
                else return 251;
            }
        else
        if (lat < 17.542611f)
        {
            if (poly[1710].contains(lat,lng)) return 265;
            if (poly[1711].contains(lat,lng)) return 265;
            else return 270;
        }
        else
        if (lng < 102.249394f)
            if (lat < 19.094166f)
                if (lng < 100.821773f)
                    return 270;
                else
                if (lat < 18.318388f)
                {
                    if (poly[1712].contains(lat,lng)) return 265;
                    else return 270;
                }
                else
                {
                    if (poly[1713].contains(lat,lng)) return 270;
                    else return 265;
                }
            else
            if (lng < 100.821773f)
            {
                if (poly[1714].contains(lat,lng)) return 40;
                if (poly[1715].contains(lat,lng)) return 265;
                else return 270;
            }
            else
            {
                if (poly[1716].contains(lat,lng)) return 270;
                else return 265;
            }
        else
        if (lat < 19.094166f)
            if (lng < 103.677016f)
            {
                if (poly[1717].contains(lat,lng)) return 270;
                else return 265;
            }
            else
            {
                if (poly[1718].contains(lat,lng)) return 24;
                if (poly[1719].contains(lat,lng)) return 270;
                else return 265;
            }
        else
        if (lng < 103.677016f)
            return 265;
        else
        if (lat < 19.869944f)
        {
            if (poly[1720].contains(lat,lng)) return 265;
            else return 24;
        }
        else
        {
            if (poly[1721].contains(lat,lng)) return 265;
            else return 24;
        }
    }

    private static int call31(float lat, float lng)
    {
        if (lat < 55.192631f)
            if (lng < 55.123322f)
                if (lat < 50.932056f)
                    if (lat < 47.893608f)
                    {
                        if (poly[1722].contains(lat,lng)) return 240;
                        else return 120;
                    }
                    else
                    if (lng < 52.374453f)
                    {
                        if (poly[1723].contains(lat,lng)) return 120;
                        else return 115;
                    }
                    else
                    if (lat < 49.412832f)
                    {
                        if (poly[1724].contains(lat,lng)) return 115;
                        if (poly[1725].contains(lat,lng)) return 240;
                        else return 120;
                    }
                    else
                    {
                        if (poly[1726].contains(lat,lng)) return 115;
                        if (poly[1727].contains(lat,lng)) return 178;
                        if (poly[1728].contains(lat,lng)) return 178;
                        else return 240;
                    }
                else
                if (lat < 52.307041f)
                    if (lng < 52.374453f)
                        if (lng < 51.000018f)
                            if (lat < 51.619549f)
                            {
                                if (poly[1729].contains(lat,lng)) return 99;
                                if (poly[1730].contains(lat,lng)) return 99;
                                else return 115;
                            }
                            else
                            {
                                if (poly[1731].contains(lat,lng)) return 115;
                                if (poly[1732].contains(lat,lng)) return 115;
                                if (poly[1733].contains(lat,lng)) return 157;
                                if (poly[1734].contains(lat,lng)) return 178;
                                else return 99;
                            }
                        else
                        {
                            if (poly[1735].contains(lat,lng)) return 115;
                            if (poly[1736].contains(lat,lng)) return 157;
                            else return 178;
                        }
                    else
                    {
                        if (poly[1737].contains(lat,lng)) return 178;
                        else return 115;
                    }
                else
                if (lng < 52.374453f)
                    if (lat < 53.749836f)
                    {
                        if (poly[1738].contains(lat,lng)) return 99;
                        if (poly[1739].contains(lat,lng)) return 178;
                        else return 157;
                    }
                    else
                    if (lng < 51.000018f)
                    {
                        if (poly[1740].contains(lat,lng)) return 183;
                        else return 157;
                    }
                    else
                    {
                        if (poly[1741].contains(lat,lng)) return 178;
                        if (poly[1742].contains(lat,lng)) return 178;
                        if (poly[1743].contains(lat,lng)) return 178;
                        if (poly[1744].contains(lat,lng)) return 183;
                        else return 157;
                    }
                else
                if (lat < 53.749836f)
                    return 178;
                else
                if (lng < 53.748887f)
                    if (lat < 54.471233f)
                        if (lng < 53.061670f)
                        {
                            if (poly[1745].contains(lat,lng)) return 157;
                            if (poly[1746].contains(lat,lng)) return 157;
                            if (poly[1747].contains(lat,lng)) return 157;
                            if (poly[1748].contains(lat,lng)) return 183;
                            if (poly[1749].contains(lat,lng)) return 183;
                            if (poly[1750].contains(lat,lng)) return 183;
                            else return 178;
                        }
                        else
                        {
                            if (poly[1751].contains(lat,lng)) return 183;
                            else return 178;
                        }
                    else
                    {
                        if (poly[1752].contains(lat,lng)) return 157;
                        if (poly[1753].contains(lat,lng)) return 178;
                        else return 183;
                    }
                else
                    return 178;
            else
            if (lng < 61.844131f)
                if (lat < 51.509230f)
                    if (lng < 58.483727f)
                    {
                        if (poly[1754].contains(lat,lng)) return 240;
                        else return 178;
                    }
                    else
                    {
                        if (poly[1755].contains(lat,lng)) return 239;
                        if (poly[1756].contains(lat,lng)) return 240;
                        else return 178;
                    }
                else
                if (lng < 58.483727f)
                    return 178;
                else
                if (lat < 53.350930f)
                {
                    if (poly[1757].contains(lat,lng)) return 239;
                    if (poly[1758].contains(lat,lng)) return 239;
                    else return 178;
                }
                else
                {
                    if (poly[1759].contains(lat,lng)) return 239;
                    else return 178;
                }
            else
            if (lat < 51.509230f)
                if (lng < 65.204536f)
                    if (lat < 49.667529f)
                    {
                        if (poly[1760].contains(lat,lng)) return 240;
                        if (poly[1761].contains(lat,lng)) return 347;
                        else return 239;
                    }
                    else
                    {
                        if (poly[1762].contains(lat,lng)) return 240;
                        else return 239;
                    }
                else
                {
                    if (poly[1763].contains(lat,lng)) return 239;
                    else return 347;
                }
            else
            if (lng < 65.204536f)
                if (lat < 53.350930f)
                {
                    if (poly[1764].contains(lat,lng)) return 178;
                    else return 239;
                }
                else
                {
                    if (poly[1765].contains(lat,lng)) return 239;
                    if (poly[1766].contains(lat,lng)) return 239;
                    else return 178;
                }
            else
            if (lat < 53.350930f)
            {
                if (poly[1767].contains(lat,lng)) return 347;
                else return 239;
            }
            else
            if (lng < 66.884739f)
            {
                if (poly[1768].contains(lat,lng)) return 178;
                if (poly[1769].contains(lat,lng)) return 178;
                if (poly[1770].contains(lat,lng)) return 347;
                else return 239;
            }
            else
            {
                if (poly[1771].contains(lat,lng)) return 178;
                else return 347;
            }
        else
        if (lng < 59.095263f)
            if (lat < 60.730856f)
                if (lng < 54.360423f)
                    if (lat < 57.961743f)
                        if (lng < 51.993003f)
                            if (lat < 56.577187f)
                                if (lng < 50.809294f)
                                {
                                    if (poly[1772].contains(lat,lng)) return 99;
                                    else return 183;
                                }
                                else
                                if (lat < 55.884909f)
                                {
                                    if (poly[1773].contains(lat,lng)) return 157;
                                    else return 183;
                                }
                                else
                                if (lng < 51.401148f)
                                {
                                    if (poly[1774].contains(lat,lng)) return 157;
                                    if (poly[1775].contains(lat,lng)) return 157;
                                    if (poly[1776].contains(lat,lng)) return 157;
                                    if (poly[1777].contains(lat,lng)) return 183;
                                    else return 99;
                                }
                                else
                                {
                                    if (poly[1778].contains(lat,lng)) return 99;
                                    if (poly[1779].contains(lat,lng)) return 99;
                                    if (poly[1780].contains(lat,lng)) return 183;
                                    if (poly[1781].contains(lat,lng)) return 183;
                                    if (poly[1782].contains(lat,lng)) return 183;
                                    else return 157;
                                }
                            else
                            if (lng < 50.809294f)
                            {
                                if (poly[1783].contains(lat,lng)) return 183;
                                else return 99;
                            }
                            else
                            {
                                if (poly[1784].contains(lat,lng)) return 157;
                                else return 99;
                            }
                        else
                        if (lat < 56.577187f)
                            if (lng < 53.176713f)
                                if (lat < 55.884909f)
                                    return 183;
                                else
                                if (lng < 52.584858f)
                                {
                                    if (poly[1785].contains(lat,lng)) return 157;
                                    else return 183;
                                }
                                else
                                {
                                    if (poly[1786].contains(lat,lng)) return 183;
                                    else return 157;
                                }
                            else
                            if (lat < 55.884909f)
                            {
                                if (poly[1787].contains(lat,lng)) return 157;
                                if (poly[1788].contains(lat,lng)) return 178;
                                else return 183;
                            }
                            else
                            {
                                if (poly[1789].contains(lat,lng)) return 178;
                                if (poly[1790].contains(lat,lng)) return 178;
                                if (poly[1791].contains(lat,lng)) return 183;
                                if (poly[1792].contains(lat,lng)) return 183;
                                else return 157;
                            }
                        else
                        {
                            if (poly[1793].contains(lat,lng)) return 178;
                            if (poly[1794].contains(lat,lng)) return 178;
                            else return 157;
                        }
                    else
                    if (lng < 51.993003f)
                    {
                        if (poly[1795].contains(lat,lng)) return 157;
                        if (poly[1796].contains(lat,lng)) return 178;
                        if (poly[1797].contains(lat,lng)) return 183;
                        else return 99;
                    }
                    else
                    if (lat < 59.346300f)
                    {
                        if (poly[1798].contains(lat,lng)) return 157;
                        if (poly[1799].contains(lat,lng)) return 178;
                        else return 99;
                    }
                    else
                    {
                        if (poly[1800].contains(lat,lng)) return 99;
                        if (poly[1801].contains(lat,lng)) return 183;
                        else return 178;
                    }
                else
                {
                    if (poly[1802].contains(lat,lng)) return 157;
                    if (poly[1803].contains(lat,lng)) return 157;
                    else return 178;
                }
            else
            {
                if (poly[1804].contains(lat,lng)) return 178;
                else return 183;
            }
        else
        if (lat < 60.730856f)
            return 178;
        else
        if (lng < 63.830102f)
            if (lat < 63.499969f)
            {
                if (poly[1805].contains(lat,lng)) return 183;
                else return 178;
            }
            else
            {
                if (poly[1806].contains(lat,lng)) return 183;
                else return 178;
            }
        else
            return 178;
    }

    private static int call32(float lat, float lng)
    {
        if (lat < 45.945526f)
            if (lat < 44.510529f)
                if (lat < 42.932393f)
                    if (lng < 46.362106f)
                        if (lng < 44.780580f)
                            if (lat < 41.802489f)
                            {
                                if (poly[1807].contains(lat,lng)) return 47;
                                if (poly[1808].contains(lat,lng)) return 205;
                                else return 48;
                            }
                            else
                            {
                                if (poly[1809].contains(lat,lng)) return 183;
                                else return 47;
                            }
                        else
                        if (lat < 41.802489f)
                            if (lng < 45.571343f)
                            {
                                if (poly[1810].contains(lat,lng)) return 47;
                                if (poly[1811].contains(lat,lng)) return 48;
                                else return 51;
                            }
                            else
                            {
                                if (poly[1812].contains(lat,lng)) return 47;
                                if (poly[1813].contains(lat,lng)) return 48;
                                else return 51;
                            }
                        else
                        {
                            if (poly[1814].contains(lat,lng)) return 51;
                            if (poly[1815].contains(lat,lng)) return 183;
                            else return 47;
                        }
                    else
                    if (lng < 47.943632f)
                        if (lat < 41.802489f)
                        {
                            if (poly[1816].contains(lat,lng)) return 47;
                            if (poly[1817].contains(lat,lng)) return 47;
                            if (poly[1818].contains(lat,lng)) return 183;
                            else return 51;
                        }
                        else
                        {
                            if (poly[1819].contains(lat,lng)) return 47;
                            if (poly[1820].contains(lat,lng)) return 51;
                            else return 183;
                        }
                    else
                    {
                        if (poly[1821].contains(lat,lng)) return 183;
                        else return 51;
                    }
                else
                    return 183;
            else
            if (lng < 47.589027f)
                if (lat < 45.179359f)
                    return 183;
                else
                {
                    if (poly[1822].contains(lat,lng)) return 99;
                    else return 183;
                }
            else
                return 99;
        else
        if (lat < 46.203140f)
            if (lng < 49.029415f)
                if (lng < 47.174988f)
                {
                    if (poly[1823].contains(lat,lng)) return 183;
                    else return 99;
                }
                else
                    return 99;
            else
            if (lng < 49.248165f)
                return 99;
            else
                return 120;
        else
        if (lat < 51.129581f)
            if (lng < 49.420502f)
                if (lat < 46.267223f)
                    if (lng < 49.135693f)
                        if (lng < 46.866653f)
                            if (lat < 46.248047f)
                            {
                                if (poly[1824].contains(lat,lng)) return 99;
                                else return 183;
                            }
                            else
                            {
                                if (poly[1825].contains(lat,lng)) return 99;
                                else return 183;
                            }
                        else
                            return 99;
                    else
                    if (lng < 49.240028f)
                        return 99;
                    else
                        return 120;
                else
                if (lng < 49.216098f)
                    if (lng < 46.207577f)
                    {
                        if (poly[1826].contains(lat,lng)) return 99;
                        else return 183;
                    }
                    else
                    if (lat < 48.698402f)
                        if (lng < 47.711837f)
                        {
                            if (poly[1827].contains(lat,lng)) return 115;
                            if (poly[1828].contains(lat,lng)) return 120;
                            if (poly[1829].contains(lat,lng)) return 183;
                            else return 99;
                        }
                        else
                        {
                            if (poly[1830].contains(lat,lng)) return 99;
                            if (poly[1831].contains(lat,lng)) return 99;
                            if (poly[1832].contains(lat,lng)) return 115;
                            else return 120;
                        }
                    else
                    {
                        if (poly[1833].contains(lat,lng)) return 99;
                        else return 115;
                    }
                else
                if (lat < 46.433438f)
                    if (lat < 46.298000f)
                        if (lng < 49.220917f)
                            return 99;
                        else
                            return 120;
                    else
                        return 120;
                else
                if (lat < 48.018226f)
                {
                    if (poly[1834].contains(lat,lng)) return 115;
                    else return 120;
                }
                else
                {
                    if (poly[1835].contains(lat,lng)) return 115;
                    else return 99;
                }
            else
            if (lat < 46.325863f)
                return 120;
            else
            if (lat < 48.059217f)
            {
                if (poly[1836].contains(lat,lng)) return 115;
                else return 120;
            }
            else
            {
                if (poly[1837].contains(lat,lng)) return 99;
                else return 115;
            }
        else
        if (lat < 53.870827f)
            if (lng < 46.412319f)
            {
                if (poly[1838].contains(lat,lng)) return 183;
                else return 99;
            }
            else
            if (lng < 48.018951f)
            {
                if (poly[1839].contains(lat,lng)) return 99;
                if (poly[1840].contains(lat,lng)) return 99;
                if (poly[1841].contains(lat,lng)) return 157;
                else return 183;
            }
            else
            if (lat < 52.500204f)
            {
                if (poly[1842].contains(lat,lng)) return 157;
                if (poly[1843].contains(lat,lng)) return 157;
                if (poly[1844].contains(lat,lng)) return 157;
                else return 99;
            }
            else
            if (lng < 48.822268f)
                if (lat < 53.185186f)
                {
                    if (poly[1845].contains(lat,lng)) return 99;
                    if (poly[1846].contains(lat,lng)) return 157;
                    else return 183;
                }
                else
                {
                    if (poly[1847].contains(lat,lng)) return 157;
                    else return 183;
                }
            else
            {
                if (poly[1848].contains(lat,lng)) return 99;
                if (poly[1849].contains(lat,lng)) return 99;
                if (poly[1850].contains(lat,lng)) return 183;
                if (poly[1851].contains(lat,lng)) return 183;
                else return 157;
            }
        else
        if (lat < 60.069954f)
            if (lng < 46.412319f)
            {
                if (poly[1852].contains(lat,lng)) return 99;
                else return 183;
            }
            else
            if (lat < 56.970390f)
            {
                if (poly[1853].contains(lat,lng)) return 99;
                else return 183;
            }
            else
            if (lng < 48.018951f)
                if (lat < 58.520172f)
                    if (lng < 47.215635f)
                    {
                        if (poly[1854].contains(lat,lng)) return 99;
                        if (poly[1855].contains(lat,lng)) return 99;
                        else return 183;
                    }
                    else
                    {
                        if (poly[1856].contains(lat,lng)) return 183;
                        if (poly[1857].contains(lat,lng)) return 183;
                        else return 99;
                    }
                else
                {
                    if (poly[1858].contains(lat,lng)) return 183;
                    else return 99;
                }
            else
            {
                if (poly[1859].contains(lat,lng)) return 99;
                else return 183;
            }
        else
        {
            if (poly[1860].contains(lat,lng)) return 99;
            else return 183;
        }
    }

    private static int call33(float lat, float lng)
    {
        if (lng < 49.249474f)
            if (lat < 30.415028f)
                if (lng < 48.575916f)
                    if (lng < 47.971863f)
                    {
                        if (poly[1861].contains(lat,lng)) return 28;
                        if (poly[1862].contains(lat,lng)) return 28;
                        if (poly[1863].contains(lat,lng)) return 163;
                        else return 231;
                    }
                    else
                    if (lat < 29.472639f)
                        if (lat < 28.535639f)
                        {
                            if (poly[1864].contains(lat,lng)) return 231;
                            else return 163;
                        }
                        else
                            return 231;
                    else
                    if (lat < 29.903723f)
                        return 231;
                    else
                    if (lng < 48.015431f)
                        if (lat < 29.993876f)
                            return 28;
                        else
                            return 231;
                    else
                    {
                        if (poly[1865].contains(lat,lng)) return 28;
                        if (poly[1866].contains(lat,lng)) return 55;
                        else return 231;
                    }
                else
                if (lat < 28.263104f)
                    return 163;
                else
                    return 55;
            else
            if (lng < 49.007973f)
                if (lat < 37.350142f)
                    if (lng < 48.168983f)
                        if (lat < 33.882585f)
                            if (lng < 45.684019f)
                            {
                                if (poly[1867].contains(lat,lng)) return 55;
                                else return 28;
                            }
                            else
                            if (lat < 32.148806f)
                            {
                                if (poly[1868].contains(lat,lng)) return 55;
                                else return 28;
                            }
                            else
                            {
                                if (poly[1869].contains(lat,lng)) return 28;
                                else return 55;
                            }
                        else
                        if (lng < 45.684019f)
                            if (lat < 35.616364f)
                            {
                                if (poly[1870].contains(lat,lng)) return 55;
                                if (poly[1871].contains(lat,lng)) return 55;
                                else return 28;
                            }
                            else
                            if (lng < 44.441537f)
                            {
                                if (poly[1872].contains(lat,lng)) return 205;
                                else return 28;
                            }
                            else
                            if (lat < 36.483253f)
                            {
                                if (poly[1873].contains(lat,lng)) return 55;
                                else return 28;
                            }
                            else
                            {
                                if (poly[1874].contains(lat,lng)) return 55;
                                if (poly[1875].contains(lat,lng)) return 205;
                                else return 28;
                            }
                        else
                        if (lat < 35.616364f)
                        {
                            if (poly[1876].contains(lat,lng)) return 28;
                            if (poly[1877].contains(lat,lng)) return 28;
                            else return 55;
                        }
                        else
                        {
                            if (poly[1878].contains(lat,lng)) return 28;
                            else return 55;
                        }
                    else
                        return 55;
                else
                if (lng < 46.103514f)
                    if (lat < 39.011363f)
                        if (lng < 44.651284f)
                        {
                            if (poly[1879].contains(lat,lng)) return 55;
                            else return 205;
                        }
                        else
                        {
                            if (poly[1880].contains(lat,lng)) return 51;
                            if (poly[1881].contains(lat,lng)) return 205;
                            else return 55;
                        }
                    else
                    if (lng < 44.651284f)
                    {
                        if (poly[1882].contains(lat,lng)) return 48;
                        if (poly[1883].contains(lat,lng)) return 55;
                        else return 205;
                    }
                    else
                    if (lat < 39.841974f)
                    {
                        if (poly[1884].contains(lat,lng)) return 48;
                        if (poly[1885].contains(lat,lng)) return 55;
                        if (poly[1886].contains(lat,lng)) return 205;
                        else return 51;
                    }
                    else
                    {
                        if (poly[1887].contains(lat,lng)) return 51;
                        if (poly[1888].contains(lat,lng)) return 51;
                        else return 48;
                    }
                else
                if (lat < 39.011363f)
                {
                    if (poly[1889].contains(lat,lng)) return 48;
                    if (poly[1890].contains(lat,lng)) return 51;
                    if (poly[1891].contains(lat,lng)) return 51;
                    if (poly[1892].contains(lat,lng)) return 51;
                    else return 55;
                }
                else
                if (lng < 47.555743f)
                {
                    if (poly[1893].contains(lat,lng)) return 48;
                    if (poly[1894].contains(lat,lng)) return 55;
                    else return 51;
                }
                else
                {
                    if (poly[1895].contains(lat,lng)) return 55;
                    else return 51;
                }
            else
            if (lat < 37.722569f)
                return 55;
            else
                return 51;
        else
        if (lng < 50.639946f)
            if (lat < 27.723528f)
                return 163;
            else
            if (lat < 37.547089f)
                return 55;
            else
                return 51;
        else
        if (lng < 51.467556f)
            return 55;
        else
        if (lng < 53.649776f)
            if (lat < 36.882539f)
                return 55;
            else
                return 76;
        else
        if (lng < 56.605778f)
            if (lat < 36.947498f)
                return 55;
            else
            {
                if (poly[1896].contains(lat,lng)) return 55;
                else return 76;
            }
        else
        if (lat < 31.834249f)
            if (lng < 68.168892f)
                if (lng < 62.387335f)
                {
                    if (poly[1897].contains(lat,lng)) return 210;
                    if (poly[1898].contains(lat,lng)) return 366;
                    else return 55;
                }
                else
                if (lng < 65.278113f)
                {
                    if (poly[1899].contains(lat,lng)) return 55;
                    if (poly[1900].contains(lat,lng)) return 366;
                    else return 210;
                }
                else
                {
                    if (poly[1901].contains(lat,lng)) return 366;
                    else return 210;
                }
            else
            {
                if (poly[1902].contains(lat,lng)) return 366;
                else return 210;
            }
        else
        if (lng < 61.278584f)
            if (lat < 36.253417f)
                if (lng < 58.942181f)
                    return 55;
                else
                if (lat < 34.043833f)
                {
                    if (poly[1903].contains(lat,lng)) return 366;
                    else return 55;
                }
                else
                {
                    if (poly[1904].contains(lat,lng)) return 76;
                    if (poly[1905].contains(lat,lng)) return 366;
                    else return 55;
                }
            else
            if (lng < 58.942181f)
            {
                if (poly[1906].contains(lat,lng)) return 76;
                else return 55;
            }
            else
            {
                if (poly[1907].contains(lat,lng)) return 55;
                else return 76;
            }
        else
        if (lat < 36.253417f)
        {
            if (poly[1908].contains(lat,lng)) return 76;
            else return 366;
        }
        else
        if (lng < 64.921762f)
        {
            if (poly[1909].contains(lat,lng)) return 167;
            if (poly[1910].contains(lat,lng)) return 366;
            else return 76;
        }
        else
        if (lat < 38.463001f)
            if (lng < 66.743352f)
            {
                if (poly[1911].contains(lat,lng)) return 167;
                if (poly[1912].contains(lat,lng)) return 366;
                else return 76;
            }
            else
            if (lat < 37.358209f)
            {
                if (poly[1913].contains(lat,lng)) return 167;
                if (poly[1914].contains(lat,lng)) return 167;
                if (poly[1915].contains(lat,lng)) return 208;
                else return 366;
            }
            else
            {
                if (poly[1916].contains(lat,lng)) return 208;
                if (poly[1917].contains(lat,lng)) return 366;
                else return 167;
            }
        else
        if (lng < 66.743352f)
        {
            if (poly[1918].contains(lat,lng)) return 76;
            if (poly[1919].contains(lat,lng)) return 246;
            else return 167;
        }
        else
        if (lat < 39.567793f)
        {
            if (poly[1920].contains(lat,lng)) return 167;
            if (poly[1921].contains(lat,lng)) return 246;
            if (poly[1922].contains(lat,lng)) return 246;
            else return 208;
        }
        else
        {
            if (poly[1923].contains(lat,lng)) return 167;
            if (poly[1924].contains(lat,lng)) return 208;
            if (poly[1925].contains(lat,lng)) return 208;
            if (poly[1926].contains(lat,lng)) return 208;
            else return 246;
        }
    }

    private static int call34(float lat, float lng)
    {
        if (lng < 77.840919f)
            if (lat < 23.877695f)
                return 371;
            else
            if (lat < 31.180556f)
                if (lng < 73.202930f)
                    if (lat < 27.529126f)
                        if (lng < 70.883936f)
                            if (lat < 25.703410f)
                            {
                                if (poly[1927].contains(lat,lng)) return 210;
                                else return 371;
                            }
                            else
                            {
                                if (poly[1928].contains(lat,lng)) return 371;
                                else return 210;
                            }
                        else
                        {
                            if (poly[1929].contains(lat,lng)) return 210;
                            if (poly[1930].contains(lat,lng)) return 210;
                            else return 371;
                        }
                    else
                    {
                        if (poly[1931].contains(lat,lng)) return 371;
                        else return 210;
                    }
                else
                {
                    if (poly[1932].contains(lat,lng)) return 210;
                    else return 371;
                }
            else
            if (lng < 73.202930f)
                if (lat < 34.831987f)
                    if (lng < 70.883936f)
                        if (lat < 33.006272f)
                        {
                            if (poly[1933].contains(lat,lng)) return 366;
                            if (poly[1934].contains(lat,lng)) return 366;
                            else return 210;
                        }
                        else
                        {
                            if (poly[1935].contains(lat,lng)) return 210;
                            else return 366;
                        }
                    else
                    {
                        if (poly[1936].contains(lat,lng)) return 366;
                        else return 210;
                    }
                else
                if (lng < 70.883936f)
                    if (lat < 36.657702f)
                        return 366;
                    else
                    if (lng < 69.724439f)
                    {
                        if (poly[1937].contains(lat,lng)) return 366;
                        else return 208;
                    }
                    else
                    {
                        if (poly[1938].contains(lat,lng)) return 366;
                        else return 208;
                    }
                else
                if (lat < 36.657702f)
                {
                    if (poly[1939].contains(lat,lng)) return 366;
                    else return 210;
                }
                else
                if (lng < 72.043433f)
                {
                    if (poly[1940].contains(lat,lng)) return 366;
                    else return 208;
                }
                else
                {
                    if (poly[1941].contains(lat,lng)) return 208;
                    if (poly[1942].contains(lat,lng)) return 210;
                    else return 366;
                }
            else
            if (lat < 34.831987f)
                if (lng < 75.521925f)
                    if (lat < 33.006272f)
                    {
                        if (poly[1943].contains(lat,lng)) return 371;
                        else return 210;
                    }
                    else
                    {
                        if (poly[1944].contains(lat,lng)) return 371;
                        else return 210;
                    }
                else
                {
                    if (poly[1945].contains(lat,lng)) return 210;
                    else return 371;
                }
            else
            if (lng < 75.521925f)
                if (lat < 36.657702f)
                    return 210;
                else
                if (lng < 74.362428f)
                {
                    if (poly[1946].contains(lat,lng)) return 208;
                    if (poly[1947].contains(lat,lng)) return 210;
                    else return 366;
                }
                else
                if (lat < 37.570560f)
                    if (lng < 74.942176f)
                        if (lat < 37.114131f)
                        {
                            if (poly[1948].contains(lat,lng)) return 4;
                            if (poly[1949].contains(lat,lng)) return 366;
                            else return 210;
                        }
                        else
                        {
                            if (poly[1950].contains(lat,lng)) return 208;
                            if (poly[1951].contains(lat,lng)) return 366;
                            else return 4;
                        }
                    else
                    {
                        if (poly[1952].contains(lat,lng)) return 208;
                        if (poly[1953].contains(lat,lng)) return 210;
                        else return 4;
                    }
                else
                {
                    if (poly[1954].contains(lat,lng)) return 208;
                    else return 4;
                }
            else
            if (lat < 36.657702f)
            {
                if (poly[1955].contains(lat,lng)) return 4;
                if (poly[1956].contains(lat,lng)) return 371;
                else return 210;
            }
            else
            {
                if (poly[1957].contains(lat,lng)) return 210;
                else return 4;
            }
        else
        if (lat < 25.213472f)
            if (lat < 23.874722f)
                if (lng < 88.620415f)
                {
                    if (poly[1958].contains(lat,lng)) return 150;
                    else return 371;
                }
                else
                {
                    if (poly[1959].contains(lat,lng)) return 371;
                    else return 150;
                }
            else
            {
                if (poly[1960].contains(lat,lng)) return 150;
                else return 371;
            }
        else
        if (lat < 31.848445f)
            if (lng < 83.240298f)
                if (lat < 28.530959f)
                {
                    if (poly[1961].contains(lat,lng)) return 268;
                    else return 371;
                }
                else
                if (lng < 80.540609f)
                    if (lat < 30.189702f)
                    {
                        if (poly[1962].contains(lat,lng)) return 268;
                        else return 371;
                    }
                    else
                    {
                        if (poly[1963].contains(lat,lng)) return 4;
                        else return 371;
                    }
                else
                if (lat < 30.189702f)
                {
                    if (poly[1964].contains(lat,lng)) return 4;
                    if (poly[1965].contains(lat,lng)) return 371;
                    if (poly[1966].contains(lat,lng)) return 371;
                    if (poly[1967].contains(lat,lng)) return 371;
                    if (poly[1968].contains(lat,lng)) return 406;
                    else return 268;
                }
                else
                if (lng < 81.890454f)
                {
                    if (poly[1969].contains(lat,lng)) return 268;
                    if (poly[1970].contains(lat,lng)) return 268;
                    if (poly[1971].contains(lat,lng)) return 268;
                    if (poly[1972].contains(lat,lng)) return 371;
                    else return 4;
                }
                else
                if (lat < 31.019073f)
                {
                    if (poly[1973].contains(lat,lng)) return 4;
                    if (poly[1974].contains(lat,lng)) return 268;
                    else return 406;
                }
                else
                {
                    if (poly[1975].contains(lat,lng)) return 406;
                    if (poly[1976].contains(lat,lng)) return 406;
                    else return 4;
                }
            else
            if (lat < 28.530959f)
                if (lng < 85.939988f)
                    if (lat < 26.872216f)
                    {
                        if (poly[1977].contains(lat,lng)) return 371;
                        else return 268;
                    }
                    else
                    if (lng < 84.590143f)
                    {
                        if (poly[1978].contains(lat,lng)) return 371;
                        else return 268;
                    }
                    else
                    {
                        if (poly[1979].contains(lat,lng)) return 371;
                        if (poly[1980].contains(lat,lng)) return 371;
                        if (poly[1981].contains(lat,lng)) return 371;
                        if (poly[1982].contains(lat,lng)) return 406;
                        else return 268;
                    }
                else
                if (lat < 26.872216f)
                    if (lng < 87.289832f)
                    {
                        if (poly[1983].contains(lat,lng)) return 371;
                        else return 268;
                    }
                    else
                    if (lat < 26.042844f)
                    {
                        if (poly[1984].contains(lat,lng)) return 150;
                        else return 371;
                    }
                    else
                    {
                        if (poly[1985].contains(lat,lng)) return 150;
                        if (poly[1986].contains(lat,lng)) return 268;
                        else return 371;
                    }
                else
                if (lng < 87.289832f)
                {
                    if (poly[1987].contains(lat,lng)) return 268;
                    else return 406;
                }
                else
                if (lat < 27.701587f)
                {
                    if (poly[1988].contains(lat,lng)) return 371;
                    else return 268;
                }
                else
                {
                    if (poly[1989].contains(lat,lng)) return 268;
                    if (poly[1990].contains(lat,lng)) return 371;
                    else return 406;
                }
            else
            {
                if (poly[1991].contains(lat,lng)) return 4;
                if (poly[1992].contains(lat,lng)) return 268;
                else return 406;
            }
        else
        if (lng < 83.240298f)
            if (lat < 35.165931f)
                if (lng < 80.540609f)
                    if (lat < 33.507188f)
                    {
                        if (poly[1993].contains(lat,lng)) return 371;
                        else return 4;
                    }
                    else
                    {
                        if (poly[1994].contains(lat,lng)) return 371;
                        else return 4;
                    }
                else
                {
                    if (poly[1995].contains(lat,lng)) return 406;
                    if (poly[1996].contains(lat,lng)) return 406;
                    else return 4;
                }
            else
            {
                if (poly[1997].contains(lat,lng)) return 371;
                if (poly[1998].contains(lat,lng)) return 406;
                else return 4;
            }
        else
            return 406;
    }

    private static int call35(float lat, float lng)
    {
        if (lng < 92.486359f)
            if (lat < 24.867944f)
                if (lng < 89.429982f)
                    if (lng < 88.775749f)
                        if (lat < 23.983778f)
                        {
                            if (poly[1999].contains(lat,lng)) return 150;
                            else return 371;
                        }
                        else
                        {
                            if (poly[2000].contains(lat,lng)) return 371;
                            else return 150;
                        }
                    else
                        return 150;
                else
                if (lng < 90.062531f)
                    return 150;
                else
                {
                    if (poly[2001].contains(lat,lng)) return 371;
                    else return 150;
                }
            else
            if (lat < 26.461971f)
                if (lng < 90.563018f)
                    if (lng < 89.601347f)
                        if (lat < 25.664958f)
                        {
                            if (poly[2002].contains(lat,lng)) return 371;
                            else return 150;
                        }
                        else
                        if (lng < 89.120512f)
                        {
                            if (poly[2003].contains(lat,lng)) return 371;
                            if (poly[2004].contains(lat,lng)) return 371;
                            if (poly[2005].contains(lat,lng)) return 371;
                            else return 150;
                        }
                        else
                        {
                            if (poly[2006].contains(lat,lng)) return 371;
                            else return 150;
                        }
                    else
                    {
                        if (poly[2007].contains(lat,lng)) return 371;
                        if (poly[2008].contains(lat,lng)) return 371;
                        if (poly[2009].contains(lat,lng)) return 371;
                        else return 150;
                    }
                else
                {
                    if (poly[2010].contains(lat,lng)) return 371;
                    else return 150;
                }
            else
            if (lat < 32.472694f)
                if (lat < 29.467333f)
                    if (lng < 90.563018f)
                        if (lat < 27.964652f)
                            if (lng < 89.601347f)
                            {
                                if (poly[2011].contains(lat,lng)) return 371;
                                if (poly[2012].contains(lat,lng)) return 406;
                                else return 62;
                            }
                            else
                            {
                                if (poly[2013].contains(lat,lng)) return 371;
                                else return 62;
                            }
                        else
                        {
                            if (poly[2014].contains(lat,lng)) return 62;
                            if (poly[2015].contains(lat,lng)) return 371;
                            else return 406;
                        }
                    else
                    if (lat < 27.964652f)
                        if (lng < 91.524688f)
                        {
                            if (poly[2016].contains(lat,lng)) return 371;
                            else return 62;
                        }
                        else
                        if (lat < 27.213312f)
                        {
                            if (poly[2017].contains(lat,lng)) return 62;
                            else return 371;
                        }
                        else
                        {
                            if (poly[2018].contains(lat,lng)) return 62;
                            if (poly[2019].contains(lat,lng)) return 406;
                            else return 371;
                        }
                    else
                    {
                        if (poly[2020].contains(lat,lng)) return 62;
                        else return 406;
                    }
                else
                    return 406;
            else
                return 406;
        else
        if (lng < 94.108883f)
            if (lat < 24.079779f)
            {
                if (poly[2021].contains(lat,lng)) return 40;
                else return 371;
            }
            else
            {
                if (poly[2022].contains(lat,lng)) return 406;
                else return 371;
            }
        else
        if (lat < 31.176903f)
            if (lng < 99.606760f)
                if (lat < 27.523645f)
                    if (lng < 96.857821f)
                        if (lat < 25.697017f)
                        {
                            if (poly[2023].contains(lat,lng)) return 371;
                            else return 40;
                        }
                        else
                        {
                            if (poly[2024].contains(lat,lng)) return 40;
                            else return 371;
                        }
                    else
                    if (lat < 25.697017f)
                        if (lng < 98.232291f)
                        {
                            if (poly[2025].contains(lat,lng)) return 403;
                            else return 40;
                        }
                        else
                        {
                            if (poly[2026].contains(lat,lng)) return 403;
                            else return 40;
                        }
                    else
                    {
                        if (poly[2027].contains(lat,lng)) return 371;
                        if (poly[2028].contains(lat,lng)) return 403;
                        else return 40;
                    }
                else
                if (lng < 96.857821f)
                    if (lat < 29.350274f)
                        if (lng < 95.483352f)
                        {
                            if (poly[2029].contains(lat,lng)) return 406;
                            else return 371;
                        }
                        else
                        if (lat < 28.436960f)
                        {
                            if (poly[2030].contains(lat,lng)) return 406;
                            if (poly[2031].contains(lat,lng)) return 406;
                            else return 371;
                        }
                        else
                        {
                            if (poly[2032].contains(lat,lng)) return 371;
                            if (poly[2033].contains(lat,lng)) return 371;
                            else return 406;
                        }
                    else
                    {
                        if (poly[2034].contains(lat,lng)) return 371;
                        else return 406;
                    }
                else
                if (lat < 29.350274f)
                    if (lng < 98.232291f)
                        if (lat < 28.436960f)
                            if (lng < 97.545056f)
                            {
                                if (poly[2035].contains(lat,lng)) return 371;
                                if (poly[2036].contains(lat,lng)) return 406;
                                else return 40;
                            }
                            else
                            {
                                if (poly[2037].contains(lat,lng)) return 403;
                                if (poly[2038].contains(lat,lng)) return 403;
                                if (poly[2039].contains(lat,lng)) return 406;
                                else return 40;
                            }
                        else
                        {
                            if (poly[2040].contains(lat,lng)) return 40;
                            else return 406;
                        }
                    else
                    {
                        if (poly[2041].contains(lat,lng)) return 40;
                        if (poly[2042].contains(lat,lng)) return 406;
                        if (poly[2043].contains(lat,lng)) return 406;
                        else return 403;
                    }
                else
                {
                    if (poly[2044].contains(lat,lng)) return 406;
                    else return 403;
                }
            else
                return 403;
        else
        if (lng < 99.606760f)
            if (lat < 34.830160f)
                if (lng < 96.857821f)
                    return 406;
                else
                if (lat < 33.003531f)
                {
                    if (poly[2045].contains(lat,lng)) return 406;
                    else return 403;
                }
                else
                if (lng < 98.232291f)
                {
                    if (poly[2046].contains(lat,lng)) return 403;
                    else return 406;
                }
                else
                {
                    if (poly[2047].contains(lat,lng)) return 406;
                    else return 403;
                }
            else
            if (lng < 96.857821f)
                return 406;
            else
            if (lat < 36.656789f)
            {
                if (poly[2048].contains(lat,lng)) return 406;
                else return 403;
            }
            else
            {
                if (poly[2049].contains(lat,lng)) return 406;
                else return 403;
            }
        else
        {
            if (poly[2050].contains(lat,lng)) return 406;
            if (poly[2051].contains(lat,lng)) return 406;
            else return 403;
        }
    }

    private static int call36(float lat, float lng)
    {
        if (lng < 83.509430f)
            if (lng < 76.037186f)
                if (lat < 55.768539f)
                    if (lng < 72.301064f)
                        if (lat < 53.128227f)
                            return 347;
                        else
                        if (lng < 70.433002f)
                        {
                            if (poly[2052].contains(lat,lng)) return 178;
                            if (poly[2053].contains(lat,lng)) return 379;
                            else return 347;
                        }
                        else
                        if (lat < 54.448383f)
                        {
                            if (poly[2054].contains(lat,lng)) return 379;
                            else return 347;
                        }
                        else
                        {
                            if (poly[2055].contains(lat,lng)) return 178;
                            if (poly[2056].contains(lat,lng)) return 347;
                            else return 379;
                        }
                    else
                    if (lat < 53.128227f)
                        return 347;
                    else
                    if (lng < 74.169125f)
                        if (lat < 54.448383f)
                            if (lng < 73.235094f)
                            {
                                if (poly[2057].contains(lat,lng)) return 379;
                                else return 347;
                            }
                            else
                            {
                                if (poly[2058].contains(lat,lng)) return 379;
                                else return 347;
                            }
                        else
                            return 379;
                    else
                    if (lat < 54.448383f)
                    {
                        if (poly[2059].contains(lat,lng)) return 95;
                        if (poly[2060].contains(lat,lng)) return 379;
                        else return 347;
                    }
                    else
                    {
                        if (poly[2061].contains(lat,lng)) return 379;
                        if (poly[2062].contains(lat,lng)) return 379;
                        else return 95;
                    }
                else
                if (lng < 72.301064f)
                    if (lat < 58.408852f)
                        if (lng < 70.433002f)
                        {
                            if (poly[2063].contains(lat,lng)) return 379;
                            if (poly[2064].contains(lat,lng)) return 379;
                            if (poly[2065].contains(lat,lng)) return 379;
                            else return 178;
                        }
                        else
                        if (lat < 57.088696f)
                        {
                            if (poly[2066].contains(lat,lng)) return 379;
                            else return 178;
                        }
                        else
                        {
                            if (poly[2067].contains(lat,lng)) return 379;
                            else return 178;
                        }
                    else
                    {
                        if (poly[2068].contains(lat,lng)) return 379;
                        else return 178;
                    }
                else
                if (lat < 58.408852f)
                {
                    if (poly[2069].contains(lat,lng)) return 95;
                    if (poly[2070].contains(lat,lng)) return 95;
                    if (poly[2071].contains(lat,lng)) return 95;
                    if (poly[2072].contains(lat,lng)) return 95;
                    if (poly[2073].contains(lat,lng)) return 178;
                    else return 379;
                }
                else
                {
                    if (poly[2074].contains(lat,lng)) return 95;
                    if (poly[2075].contains(lat,lng)) return 379;
                    else return 178;
                }
            else
            if (lat < 55.768539f)
                if (lng < 79.773308f)
                    if (lat < 53.128227f)
                    {
                        if (poly[2076].contains(lat,lng)) return 379;
                        else return 347;
                    }
                    else
                    if (lng < 77.905247f)
                    {
                        if (poly[2077].contains(lat,lng)) return 347;
                        if (poly[2078].contains(lat,lng)) return 379;
                        else return 95;
                    }
                    else
                    {
                        if (poly[2079].contains(lat,lng)) return 95;
                        if (poly[2080].contains(lat,lng)) return 347;
                        else return 379;
                    }
                else
                if (lat < 53.128227f)
                    if (lng < 81.641369f)
                    {
                        if (poly[2081].contains(lat,lng)) return 379;
                        else return 347;
                    }
                    else
                    {
                        if (poly[2082].contains(lat,lng)) return 379;
                        else return 347;
                    }
                else
                if (lng < 81.641369f)
                {
                    if (poly[2083].contains(lat,lng)) return 379;
                    else return 95;
                }
                else
                {
                    if (poly[2084].contains(lat,lng)) return 379;
                    else return 95;
                }
            else
            if (lng < 79.773308f)
                if (lat < 58.408852f)
                {
                    if (poly[2085].contains(lat,lng)) return 379;
                    if (poly[2086].contains(lat,lng)) return 379;
                    else return 95;
                }
                else
                {
                    if (poly[2087].contains(lat,lng)) return 178;
                    else return 95;
                }
            else
            {
                if (poly[2088].contains(lat,lng)) return 178;
                else return 95;
            }
        else
        if (lat < 50.955069f)
            if (lng < 84.233223f)
                if (lat < 50.515362f)
                {
                    if (poly[2089].contains(lat,lng)) return 379;
                    else return 347;
                }
                else
                {
                    if (poly[2090].contains(lat,lng)) return 379;
                    else return 347;
                }
            else
            {
                if (poly[2091].contains(lat,lng)) return 379;
                else return 289;
            }
        else
        if (lat < 56.002116f)
            if (lng < 87.293533f)
                if (lat < 53.478593f)
                {
                    if (poly[2092].contains(lat,lng)) return 87;
                    if (poly[2093].contains(lat,lng)) return 87;
                    else return 379;
                }
                else
                if (lng < 85.401482f)
                    if (lat < 54.740354f)
                    {
                        if (poly[2094].contains(lat,lng)) return 87;
                        if (poly[2095].contains(lat,lng)) return 379;
                        else return 95;
                    }
                    else
                    {
                        if (poly[2096].contains(lat,lng)) return 95;
                        else return 87;
                    }
                else
                {
                    if (poly[2097].contains(lat,lng)) return 379;
                    if (poly[2098].contains(lat,lng)) return 379;
                    else return 87;
                }
            else
            if (lat < 53.478593f)
                if (lng < 89.185585f)
                    if (lat < 52.216831f)
                    {
                        if (poly[2099].contains(lat,lng)) return 87;
                        if (poly[2100].contains(lat,lng)) return 289;
                        else return 379;
                    }
                    else
                    {
                        if (poly[2101].contains(lat,lng)) return 289;
                        if (poly[2102].contains(lat,lng)) return 289;
                        if (poly[2103].contains(lat,lng)) return 379;
                        else return 87;
                    }
                else
                {
                    if (poly[2104].contains(lat,lng)) return 87;
                    if (poly[2105].contains(lat,lng)) return 379;
                    else return 289;
                }
            else
            if (lng < 89.185585f)
                if (lat < 54.740354f)
                {
                    if (poly[2106].contains(lat,lng)) return 87;
                    else return 289;
                }
                else
                {
                    if (poly[2107].contains(lat,lng)) return 289;
                    else return 87;
                }
            else
            {
                if (poly[2108].contains(lat,lng)) return 87;
                if (poly[2109].contains(lat,lng)) return 87;
                if (poly[2110].contains(lat,lng)) return 87;
                if (poly[2111].contains(lat,lng)) return 87;
                if (poly[2112].contains(lat,lng)) return 87;
                else return 289;
            }
        else
        if (lng < 87.293533f)
            if (lat < 58.525640f)
            {
                if (poly[2113].contains(lat,lng)) return 87;
                else return 95;
            }
            else
            {
                if (poly[2114].contains(lat,lng)) return 178;
                if (poly[2115].contains(lat,lng)) return 289;
                else return 95;
            }
        else
        if (lat < 58.525640f)
            if (lng < 89.185585f)
                if (lat < 57.263878f)
                {
                    if (poly[2116].contains(lat,lng)) return 95;
                    if (poly[2117].contains(lat,lng)) return 289;
                    else return 87;
                }
                else
                {
                    if (poly[2118].contains(lat,lng)) return 289;
                    if (poly[2119].contains(lat,lng)) return 289;
                    else return 95;
                }
            else
            {
                if (poly[2120].contains(lat,lng)) return 87;
                if (poly[2121].contains(lat,lng)) return 95;
                else return 289;
            }
        else
        {
            if (poly[2122].contains(lat,lng)) return 95;
            else return 289;
        }
    }

    private static int call37(float lat, float lng)
    {
        if (lng < 81.689583f)
            if (lng < 69.014221f)
                if (lat < 40.080223f)
                {
                    if (poly[2123].contains(lat,lng)) return 246;
                    else return 208;
                }
                else
                if (lat < 40.220528f)
                {
                    if (poly[2124].contains(lat,lng)) return 208;
                    else return 246;
                }
                else
                {
                    if (poly[2125].contains(lat,lng)) return 347;
                    else return 246;
                }
            else
            if (lng < 73.132278f)
                if (lat < 41.042252f)
                    if (lng < 70.738670f)
                        if (lat < 39.902557f)
                        {
                            if (poly[2126].contains(lat,lng)) return 230;
                            if (poly[2127].contains(lat,lng)) return 230;
                            else return 208;
                        }
                        else
                        if (lng < 69.876446f)
                        {
                            if (poly[2128].contains(lat,lng)) return 230;
                            if (poly[2129].contains(lat,lng)) return 230;
                            if (poly[2130].contains(lat,lng)) return 246;
                            else return 208;
                        }
                        else
                        {
                            if (poly[2131].contains(lat,lng)) return 230;
                            if (poly[2132].contains(lat,lng)) return 246;
                            if (poly[2133].contains(lat,lng)) return 246;
                            else return 208;
                        }
                    else
                    if (lat < 40.228500f)
                        if (lng < 70.971222f)
                            if (lat < 39.492379f)
                            {
                                if (poly[2134].contains(lat,lng)) return 230;
                                else return 208;
                            }
                            else
                            {
                                if (poly[2135].contains(lat,lng)) return 208;
                                if (poly[2136].contains(lat,lng)) return 246;
                                else return 230;
                            }
                        else
                        if (lat < 39.613609f)
                            if (lng < 71.498947f)
                            {
                                if (poly[2137].contains(lat,lng)) return 230;
                                else return 208;
                            }
                            else
                            {
                                if (poly[2138].contains(lat,lng)) return 230;
                                else return 208;
                            }
                        else
                        if (lng < 71.229332f)
                        {
                            if (poly[2139].contains(lat,lng)) return 246;
                            else return 230;
                        }
                        else
                        {
                            if (poly[2140].contains(lat,lng)) return 246;
                            if (poly[2141].contains(lat,lng)) return 246;
                            else return 230;
                        }
                    else
                    if (lng < 71.664379f)
                        if (lng < 70.789665f)
                            if (lat < 40.725140f)
                            {
                                if (poly[2142].contains(lat,lng)) return 208;
                                else return 246;
                            }
                            else
                            {
                                if (poly[2143].contains(lat,lng)) return 208;
                                else return 246;
                            }
                        else
                        if (lng < 71.491906f)
                        {
                            if (poly[2144].contains(lat,lng)) return 230;
                            else return 246;
                        }
                        else
                        {
                            if (poly[2145].contains(lat,lng)) return 230;
                            else return 246;
                        }
                    else
                    {
                        if (poly[2146].contains(lat,lng)) return 246;
                        else return 230;
                    }
                else
                if (lat < 43.204445f)
                    if (lng < 71.073250f)
                        if (lat < 42.123348f)
                            if (lng < 70.043736f)
                            {
                                if (poly[2147].contains(lat,lng)) return 246;
                                else return 347;
                            }
                            else
                            {
                                if (poly[2148].contains(lat,lng)) return 230;
                                if (poly[2149].contains(lat,lng)) return 347;
                                if (poly[2150].contains(lat,lng)) return 347;
                                else return 246;
                            }
                        else
                        {
                            if (poly[2151].contains(lat,lng)) return 230;
                            if (poly[2152].contains(lat,lng)) return 230;
                            if (poly[2153].contains(lat,lng)) return 246;
                            if (poly[2154].contains(lat,lng)) return 246;
                            else return 347;
                        }
                    else
                    if (lat < 42.123348f)
                    {
                        if (poly[2155].contains(lat,lng)) return 230;
                        else return 246;
                    }
                    else
                    {
                        if (poly[2156].contains(lat,lng)) return 246;
                        if (poly[2157].contains(lat,lng)) return 347;
                        if (poly[2158].contains(lat,lng)) return 347;
                        else return 230;
                    }
                else
                    return 347;
            else
            if (lng < 77.410931f)
                if (lat < 41.925028f)
                    if (lng < 75.271605f)
                        if (lat < 40.204223f)
                            if (lng < 74.201941f)
                            {
                                if (poly[2159].contains(lat,lng)) return 208;
                                if (poly[2160].contains(lat,lng)) return 230;
                                else return 4;
                            }
                            else
                            {
                                if (poly[2161].contains(lat,lng)) return 208;
                                if (poly[2162].contains(lat,lng)) return 230;
                                else return 4;
                            }
                        else
                        {
                            if (poly[2163].contains(lat,lng)) return 4;
                            else return 230;
                        }
                    else
                    {
                        if (poly[2164].contains(lat,lng)) return 230;
                        else return 4;
                    }
                else
                {
                    if (poly[2165].contains(lat,lng)) return 347;
                    else return 230;
                }
            else
            if (lat < 41.925028f)
            {
                if (poly[2166].contains(lat,lng)) return 230;
                else return 4;
            }
            else
            if (lng < 79.550257f)
            {
                if (poly[2167].contains(lat,lng)) return 347;
                else return 230;
            }
            else
            if (lat < 43.645833f)
                if (lng < 80.619920f)
                {
                    if (poly[2168].contains(lat,lng)) return 4;
                    if (poly[2169].contains(lat,lng)) return 230;
                    else return 347;
                }
                else
                {
                    if (poly[2170].contains(lat,lng)) return 347;
                    else return 4;
                }
            else
            {
                if (poly[2171].contains(lat,lng)) return 4;
                else return 347;
            }
        else
        if (lng < 84.960781f)
            if (lat < 41.925028f)
            {
                if (poly[2172].contains(lat,lng)) return 406;
                else return 4;
            }
            else
            if (lat < 43.645833f)
                if (lng < 83.325182f)
                {
                    if (poly[2173].contains(lat,lng)) return 406;
                    if (poly[2174].contains(lat,lng)) return 406;
                    else return 4;
                }
                else
                {
                    if (poly[2175].contains(lat,lng)) return 4;
                    if (poly[2176].contains(lat,lng)) return 4;
                    else return 406;
                }
            else
            if (lng < 83.325182f)
            {
                if (poly[2177].contains(lat,lng)) return 347;
                if (poly[2178].contains(lat,lng)) return 406;
                if (poly[2179].contains(lat,lng)) return 406;
                if (poly[2180].contains(lat,lng)) return 406;
                else return 4;
            }
            else
            {
                if (poly[2181].contains(lat,lng)) return 4;
                else return 406;
            }
        else
        if (lng < 95.032709f)
        {
            if (poly[2182].contains(lat,lng)) return 121;
            else return 406;
        }
        else
        if (lng < 100.068673f)
            if (lat < 41.925028f)
            {
                if (poly[2183].contains(lat,lng)) return 406;
                else return 403;
            }
            else
            {
                if (poly[2184].contains(lat,lng)) return 123;
                if (poly[2185].contains(lat,lng)) return 403;
                if (poly[2186].contains(lat,lng)) return 406;
                else return 121;
            }
        else
        {
            if (poly[2187].contains(lat,lng)) return 403;
            else return 123;
        }
    }

    private static int call38(float lat, float lng)
    {
        if (lat < 23.870388f)
            if (lng < 90.252220f)
                if (lng < 88.803276f)
                    if (lng < 68.778862f)
                        return 371;
                    else
                    {
                        if (poly[2188].contains(lat,lng)) return 371;
                        if (poly[2189].contains(lat,lng)) return 371;
                        else return 150;
                    }
                else
                    return 150;
            else
            if (lng < 90.759941f)
                return 150;
            else
            if (lng < 93.437553f)
                if (lng < 92.333679f)
                    if (lng < 91.259092f)
                    {
                        if (poly[2190].contains(lat,lng)) return 371;
                        else return 150;
                    }
                    else
                    {
                        if (poly[2191].contains(lat,lng)) return 150;
                        else return 371;
                    }
                else
                if (lat < 23.680471f)
                {
                    if (poly[2192].contains(lat,lng)) return 40;
                    else return 371;
                }
                else
                {
                    if (poly[2193].contains(lat,lng)) return 40;
                    else return 371;
                }
            else
            if (lng < 94.162030f)
            {
                if (poly[2194].contains(lat,lng)) return 371;
                else return 40;
            }
            else
            if (lng < 97.683406f)
            {
                if (poly[2195].contains(lat,lng)) return 403;
                else return 40;
            }
            else
            {
                if (poly[2196].contains(lat,lng)) return 403;
                else return 40;
            }
        else
        if (lat < 38.483418f)
            if (lng < 88.639677f)
                return call34(lat,lng);
            else
                return call35(lat,lng);
        else
        if (lat < 45.366638f)
            return call37(lat,lng);
        else
        if (lng < 91.077637f)
            if (lat < 50.487915f)
                if (lng < 87.312668f)
                    if (lng < 77.938805f)
                        return 347;
                    else
                    if (lng < 82.625736f)
                    {
                        if (poly[2197].contains(lat,lng)) return 406;
                        else return 347;
                    }
                    else
                    if (lat < 47.927277f)
                    {
                        if (poly[2198].contains(lat,lng)) return 406;
                        else return 347;
                    }
                    else
                    if (lng < 84.969202f)
                    {
                        if (poly[2199].contains(lat,lng)) return 379;
                        else return 347;
                    }
                    else
                    if (lat < 49.207596f)
                    {
                        if (poly[2200].contains(lat,lng)) return 379;
                        if (poly[2201].contains(lat,lng)) return 406;
                        else return 347;
                    }
                    else
                    {
                        if (poly[2202].contains(lat,lng)) return 347;
                        else return 379;
                    }
                else
                if (lat < 46.563946f)
                {
                    if (poly[2203].contains(lat,lng)) return 121;
                    else return 406;
                }
                else
                if (lat < 48.525930f)
                {
                    if (poly[2204].contains(lat,lng)) return 406;
                    else return 121;
                }
                else
                if (lng < 89.195152f)
                    if (lat < 49.506923f)
                        if (lng < 88.253910f)
                        {
                            if (poly[2205].contains(lat,lng)) return 379;
                            if (poly[2206].contains(lat,lng)) return 406;
                            if (poly[2207].contains(lat,lng)) return 406;
                            else return 121;
                        }
                        else
                        {
                            if (poly[2208].contains(lat,lng)) return 379;
                            if (poly[2209].contains(lat,lng)) return 379;
                            if (poly[2210].contains(lat,lng)) return 379;
                            if (poly[2211].contains(lat,lng)) return 379;
                            else return 121;
                        }
                    else
                    {
                        if (poly[2212].contains(lat,lng)) return 121;
                        if (poly[2213].contains(lat,lng)) return 121;
                        if (poly[2214].contains(lat,lng)) return 121;
                        if (poly[2215].contains(lat,lng)) return 121;
                        if (poly[2216].contains(lat,lng)) return 121;
                        else return 379;
                    }
                else
                if (lat < 49.506923f)
                    return 121;
                else
                if (lng < 90.136395f)
                {
                    if (poly[2217].contains(lat,lng)) return 121;
                    if (poly[2218].contains(lat,lng)) return 289;
                    else return 379;
                }
                else
                {
                    if (poly[2219].contains(lat,lng)) return 121;
                    else return 289;
                }
            else
            if (lat < 61.049164f)
                return call36(lat,lng);
            else
            if (lng < 72.250832f)
                return 178;
            else
            if (lng < 81.664234f)
                return 178;
            else
            if (lng < 86.370935f)
                if (lat < 63.659122f)
                    if (lng < 84.017585f)
                        return 178;
                    else
                    if (lat < 62.354143f)
                    {
                        if (poly[2220].contains(lat,lng)) return 289;
                        else return 178;
                    }
                    else
                    {
                        if (poly[2221].contains(lat,lng)) return 289;
                        else return 178;
                    }
                else
                if (lng < 84.017585f)
                {
                    if (poly[2222].contains(lat,lng)) return 289;
                    else return 178;
                }
                else
                {
                    if (poly[2223].contains(lat,lng)) return 178;
                    else return 289;
                }
            else
                return 289;
        else
        if (lat < 59.320831f)
            if (lng < 98.091137f)
                if (lat < 52.343735f)
                    if (lng < 94.584387f)
                    {
                        if (poly[2224].contains(lat,lng)) return 289;
                        else return 121;
                    }
                    else
                    if (lat < 48.855186f)
                    {
                        if (poly[2225].contains(lat,lng)) return 123;
                        if (poly[2226].contains(lat,lng)) return 123;
                        else return 121;
                    }
                    else
                    if (lng < 96.337762f)
                    {
                        if (poly[2227].contains(lat,lng)) return 121;
                        else return 289;
                    }
                    else
                    {
                        if (poly[2228].contains(lat,lng)) return 121;
                        if (poly[2229].contains(lat,lng)) return 123;
                        if (poly[2230].contains(lat,lng)) return 123;
                        else return 289;
                    }
                else
                if (lng < 94.584387f)
                    return 289;
                else
                if (lat < 55.832283f)
                    if (lng < 96.337762f)
                    {
                        if (poly[2231].contains(lat,lng)) return 144;
                        else return 289;
                    }
                    else
                    {
                        if (poly[2232].contains(lat,lng)) return 144;
                        else return 289;
                    }
                else
                {
                    if (poly[2233].contains(lat,lng)) return 144;
                    else return 289;
                }
            else
            if (lat < 52.343735f)
                if (lng < 101.597887f)
                    if (lat < 48.855186f)
                    {
                        if (poly[2234].contains(lat,lng)) return 123;
                        else return 121;
                    }
                    else
                    if (lng < 99.844512f)
                    {
                        if (poly[2235].contains(lat,lng)) return 121;
                        if (poly[2236].contains(lat,lng)) return 144;
                        if (poly[2237].contains(lat,lng)) return 289;
                        if (poly[2238].contains(lat,lng)) return 289;
                        else return 123;
                    }
                    else
                    {
                        if (poly[2239].contains(lat,lng)) return 123;
                        else return 144;
                    }
                else
                {
                    if (poly[2240].contains(lat,lng)) return 144;
                    else return 123;
                }
            else
            if (lng < 101.597887f)
                if (lat < 55.832283f)
                {
                    if (poly[2241].contains(lat,lng)) return 289;
                    else return 144;
                }
                else
                {
                    if (poly[2242].contains(lat,lng)) return 289;
                    else return 144;
                }
            else
            if (lat < 55.832283f)
                return 144;
            else
            if (lng < 103.351262f)
            {
                if (poly[2243].contains(lat,lng)) return 289;
                if (poly[2244].contains(lat,lng)) return 289;
                else return 144;
            }
            else
            {
                if (poly[2245].contains(lat,lng)) return 144;
                else return 289;
            }
        else
        if (lat < 59.849081f)
        {
            if (poly[2246].contains(lat,lng)) return 144;
            else return 289;
        }
        else
        {
            if (poly[2247].contains(lat,lng)) return 144;
            else return 289;
        }
    }

    private static int call39(float lat, float lng)
    {
        if (lat < 27.104834f)
            if (lng < 55.210827f)
                if (lng < 53.523224f)
                    if (lng < 51.746334f)
                        if (lng < 50.828693f)
                            if (lng < 50.664471f)
                                if (lng < 50.359833f)
                                    return 163;
                                else
                                if (lat < 25.509583f)
                                    return 163;
                                else
                                    return 109;
                            else
                            if (lat < 25.615926f)
                                if (lat < 25.523945f)
                                    if (lat < 24.963544f)
                                    {
                                        if (poly[2248].contains(lat,lng)) return 100;
                                        else return 163;
                                    }
                                    else
                                        return 100;
                                else
                                if (lng < 50.817749f)
                                {
                                    if (poly[2249].contains(lat,lng)) return 100;
                                    else return 109;
                                }
                                else
                                    return 100;
                            else
                                return 109;
                        else
                        if (lat < 24.743839f)
                            if (lng < 51.580971f)
                                if (lng < 51.478639f)
                                {
                                    if (poly[2250].contains(lat,lng)) return 100;
                                    else return 163;
                                }
                                else
                                if (lng < 51.511971f)
                                    return 163;
                                else
                                if (lat < 24.283293f)
                                    return 163;
                                else
                                    return 321;
                            else
                            if (lat < 24.239900f)
                            {
                                if (poly[2251].contains(lat,lng)) return 163;
                                else return 321;
                            }
                            else
                                return 321;
                        else
                            return 100;
                    else
                    if (lat < 24.356861f)
                        if (lat < 23.924778f)
                        {
                            if (poly[2252].contains(lat,lng)) return 321;
                            else return 163;
                        }
                        else
                            return 321;
                    else
                    if (lat < 25.154139f)
                        return 321;
                    else
                    if (lng < 52.427582f)
                        return 100;
                    else
                        return 55;
                else
                if (lat < 24.475027f)
                    if (lat < 22.826911f)
                    {
                        if (poly[2253].contains(lat,lng)) return 321;
                        else return 163;
                    }
                    else
                        return 321;
                else
                if (lat < 25.246805f)
                    return 321;
                else
                if (lat < 25.897194f)
                    if (lng < 54.772754f)
                        return 55;
                    else
                        return 321;
                else
                    return 55;
            else
            if (lng < 66.393387f)
                if (lng < 56.537693f)
                    if (lat < 26.387972f)
                        if (lat < 25.553473f)
                            if (lat < 24.983110f)
                            {
                                if (poly[2254].contains(lat,lng)) return 163;
                                if (poly[2255].contains(lat,lng)) return 321;
                                if (poly[2256].contains(lat,lng)) return 321;
                                else return 357;
                            }
                            else
                                return 321;
                        else
                        if (lat < 26.286167f)
                            if (lng < 55.572693f)
                                if (lat < 25.918639f)
                                    return 55;
                                else
                                    return 321;
                            else
                            if (lng < 55.973804f)
                                return 321;
                            else
                            {
                                if (poly[2257].contains(lat,lng)) return 321;
                                else return 357;
                            }
                        else
                            return 357;
                    else
                        return 55;
                else
                if (lng < 58.490417f)
                    if (lat < 24.613961f)
                        return 357;
                    else
                        return 55;
                else
                if (lat < 23.643444f)
                    return 357;
                else
                if (lng < 63.281387f)
                    if (lng < 59.965057f)
                        return 55;
                    else
                    if (lat < 26.874584f)
                        if (lng < 61.623222f)
                        {
                            if (poly[2258].contains(lat,lng)) return 210;
                            else return 55;
                        }
                        else
                        {
                            if (poly[2259].contains(lat,lng)) return 55;
                            else return 210;
                        }
                    else
                    {
                        if (poly[2260].contains(lat,lng)) return 210;
                        else return 55;
                    }
                else
                    return 210;
            else
            if (lng < 67.529053f)
                return 210;
            else
            if (lat < 23.647362f)
                return 371;
            else
            if (lng < 68.258080f)
                if (lat < 23.653912f)
                    return 371;
                else
                {
                    if (poly[2261].contains(lat,lng)) return 371;
                    if (poly[2262].contains(lat,lng)) return 371;
                    if (poly[2263].contains(lat,lng)) return 371;
                    else return 210;
                }
            else
            if (lat < 23.734138f)
                return 371;
            else
            {
                if (poly[2264].contains(lat,lng)) return 210;
                else return 371;
            }
        else
        if (lat < 40.672585f)
            return call33(lat,lng);
        else
        if (lng < 49.625584f)
            return call32(lat,lng);
        else
        if (lat < 46.052723f)
            if (lng < 52.873138f)
                if (lat < 42.038017f)
                    if (lat < 40.823005f)
                        return 76;
                    else
                    {
                        if (poly[2265].contains(lat,lng)) return 120;
                        else return 76;
                    }
                else
                    return 120;
            else
            if (lng < 59.666477f)
                if (lat < 44.892151f)
                    if (lat < 44.271465f)
                        if (lng < 56.269808f)
                        {
                            if (poly[2266].contains(lat,lng)) return 120;
                            if (poly[2267].contains(lat,lng)) return 167;
                            else return 76;
                        }
                        else
                        if (lat < 42.472025f)
                        {
                            if (poly[2268].contains(lat,lng)) return 167;
                            if (poly[2269].contains(lat,lng)) return 167;
                            if (poly[2270].contains(lat,lng)) return 167;
                            else return 76;
                        }
                        else
                        {
                            if (poly[2271].contains(lat,lng)) return 76;
                            if (poly[2272].contains(lat,lng)) return 76;
                            else return 167;
                        }
                    else
                    if (lng < 55.998606f)
                    {
                        if (poly[2273].contains(lat,lng)) return 167;
                        else return 120;
                    }
                    else
                        return 167;
                else
                if (lng < 58.607960f)
                {
                    if (poly[2274].contains(lat,lng)) return 167;
                    if (poly[2275].contains(lat,lng)) return 239;
                    if (poly[2276].contains(lat,lng)) return 240;
                    else return 120;
                }
                else
                if (lat < 45.436764f)
                    if (lng < 59.239082f)
                        if (lat < 44.974435f)
                            return 167;
                        else
                        {
                            if (poly[2277].contains(lat,lng)) return 239;
                            else return 167;
                        }
                    else
                    {
                        if (poly[2278].contains(lat,lng)) return 239;
                        else return 167;
                    }
                else
                if (lat < 45.622234f)
                    return 239;
                else
                {
                    if (poly[2279].contains(lat,lng)) return 240;
                    else return 239;
                }
            else
            if (lng < 62.074552f)
                if (lat < 44.584438f)
                    if (lat < 42.306305f)
                        if (lng < 59.827972f)
                        {
                            if (poly[2280].contains(lat,lng)) return 167;
                            else return 76;
                        }
                        else
                        {
                            if (poly[2281].contains(lat,lng)) return 167;
                            else return 76;
                        }
                    else
                    {
                        if (poly[2282].contains(lat,lng)) return 239;
                        else return 167;
                    }
                else
                    return 239;
            else
            if (lng < 65.319747f)
            {
                if (poly[2283].contains(lat,lng)) return 239;
                else return 167;
            }
            else
            if (lat < 43.362654f)
                if (lng < 66.942344f)
                {
                    if (poly[2284].contains(lat,lng)) return 239;
                    if (poly[2285].contains(lat,lng)) return 246;
                    if (poly[2286].contains(lat,lng)) return 347;
                    else return 167;
                }
                else
                {
                    if (poly[2287].contains(lat,lng)) return 239;
                    if (poly[2288].contains(lat,lng)) return 246;
                    else return 347;
                }
            else
            {
                if (poly[2289].contains(lat,lng)) return 167;
                if (poly[2290].contains(lat,lng)) return 347;
                else return 239;
            }
        else
        if (lat < 47.825829f)
            if (lng < 53.026917f)
                return 120;
            else
            if (lng < 61.927216f)
                if (lng < 56.525335f)
                {
                    if (poly[2291].contains(lat,lng)) return 240;
                    else return 120;
                }
                else
                {
                    if (poly[2292].contains(lat,lng)) return 240;
                    else return 239;
                }
            else
            {
                if (poly[2293].contains(lat,lng)) return 240;
                if (poly[2294].contains(lat,lng)) return 347;
                else return 239;
            }
        else
            return call31(lat,lng);
    }

    private static int call40(float lat, float lng)
    {
        if (lat < 6.978889f)
            if (lng < 99.459221f)
                if (lat < -6.391056f)
                    if (lat < -38.738110f)
                        return 236;
                    else
                    if (lat < -13.424148f)
                        if (lng < 50.483780f)
                            return 101;
                        else
                        if (lat < -20.856855f)
                            if (lng < 55.845039f)
                                return 274;
                            else
                                return 236;
                        else
                            return 233;
                    else
                    if (lng < 48.694023f)
                        if (lat < -11.362381f)
                            if (lng < 45.292950f)
                                if (lng < 44.538223f)
                                    return 218;
                                else
                                    return 351;
                            else
                                return 101;
                        else
                            return 66;
                    else
                    if (lng < 50.022717f)
                        return 101;
                    else
                    if (lng < 56.279507f)
                        return 66;
                    else
                    if (lng < 72.493164f)
                        if (lng < 56.632473f)
                            return 233;
                        else
                            return 13;
                    else
                        return 97;
                else
                if (lng < 93.949997f)
                    if (lng < 73.069031f)
                        if (lng < 55.880646f)
                            if (lng < 49.355780f)
                            {
                                if (poly[2295].contains(lat,lng)) return 350;
                                else return 250;
                            }
                            else
                                return 66;
                        else
                        if (lng < 72.336807f)
                            if (lng < 55.951393f)
                                return 66;
                            else
                                return 13;
                        else
                            return 382;
                    else
                    if (lng < 73.637276f)
                        return 382;
                    else
                    if (lng < 87.800070f)
                        return 288;
                    else
                        return 371;
                else
                if (lat < 5.768278f)
                    return 26;
                else
                if (lng < 95.376556f)
                    return 26;
                else
                    return 270;
            else
            if (lat < 1.156361f)
                return 26;
            else
            if (lat < 2.704722f)
                if (lng < 103.439392f)
                    if (lng < 101.424667f)
                        return 26;
                    else
                    if (lng < 102.513641f)
                        if (lat < 1.697561f)
                            return 26;
                        else
                        if (lng < 101.791115f)
                            if (lat < 2.119222f)
                                return 26;
                            else
                                return 327;
                        else
                            return 327;
                    else
                        return 327;
                else
                if (lat < 1.471278f)
                    if (lat < 1.256694f)
                        if (lng < 103.842331f)
                            return 316;
                        else
                            return 26;
                    else
                    if (lng < 104.009645f)
                        if (lng < 103.785408f)
                        {
                            if (poly[2296].contains(lat,lng)) return 327;
                            else return 316;
                        }
                        else
                        if (lat < 1.425806f)
                            return 316;
                        else
                        if (lng < 103.865644f)
                            return 316;
                        else
                            return 327;
                    else
                    {
                        if (poly[2297].contains(lat,lng)) return 316;
                        else return 327;
                    }
                else
                    return 327;
            else
            if (lng < 100.075518f)
                if (lat < 6.471167f)
                    if (lat < 3.361025f)
                        return 26;
                    else
                        return 327;
                else
                    return 270;
            else
            if (lng < 102.092140f)
                if (lat < 5.238778f)
                    if (lng < 100.218333f)
                        if (lat < 3.966694f)
                            return 26;
                        else
                            return 327;
                    else
                        return 327;
                else
                if (lat < 5.479667f)
                    return 327;
                else
                if (lat < 6.714139f)
                    if (lng < 100.203247f)
                    {
                        if (poly[2298].contains(lat,lng)) return 327;
                        else return 270;
                    }
                    else
                    if (lng < 101.147694f)
                    {
                        if (poly[2299].contains(lat,lng)) return 270;
                        else return 327;
                    }
                    else
                    {
                        if (poly[2300].contains(lat,lng)) return 327;
                        else return 270;
                    }
                else
                    return 270;
            else
                return 327;
        else
        if (lng < 97.696892f)
            if (lng < 93.273331f)
                if (lng < 92.358528f)
                    if (lng < 72.996170f)
                        if (lng < 55.883141f)
                            if (lat < 12.250028f)
                                if (lng < 51.413029f)
                                    if (lat < 11.523074f)
                                        if (lat < 9.873331f)
                                        {
                                            if (poly[2301].contains(lat,lng)) return 350;
                                            else return 250;
                                        }
                                        else
                                        if (lng < 43.254696f)
                                        {
                                            if (poly[2302].contains(lat,lng)) return 311;
                                            else return 250;
                                        }
                                        else
                                            return 250;
                                    else
                                    if (lng < 43.416973f)
                                        return 311;
                                    else
                                        return 250;
                                else
                                    return 215;
                            else
                            if (lat < 13.289861f)
                                if (lat < 12.586202f)
                                    if (lng < 48.346151f)
                                        return 215;
                                    else
                                        return 311;
                                else
                                    return 215;
                            else
                            if (lng < 55.215251f)
                                if (lng < 49.207153f)
                                {
                                    if (poly[2303].contains(lat,lng)) return 163;
                                    if (poly[2304].contains(lat,lng)) return 163;
                                    else return 215;
                                }
                                else
                                {
                                    if (poly[2305].contains(lat,lng)) return 163;
                                    if (poly[2306].contains(lat,lng)) return 357;
                                    else return 215;
                                }
                            else
                                return 357;
                        else
                        if (lng < 58.958778f)
                            return 357;
                        else
                        if (lat < 7.098361f)
                            return 382;
                        else
                            return 371;
                    else
                    if (lng < 79.228668f)
                        return 371;
                    else
                    if (lat < 9.555528f)
                        if (lng < 79.442337f)
                            return 371;
                        else
                            return 288;
                    else
                    if (lat < 9.831361f)
                        return 288;
                    else
                    if (lng < 92.290085f)
                        return 371;
                    else
                        return 150;
                else
                if (lat < 13.618361f)
                    return 371;
                else
                if (lat < 13.678945f)
                    return 371;
                else
                    return 40;
            else
            if (lat < 19.040861f)
                if (lng < 95.210640f)
                    if (lat < 13.453917f)
                        return 371;
                    else
                        return 40;
                else
                if (lng < 97.278137f)
                    return 40;
                else
                if (lat < 15.588417f)
                    if (lat < 8.661195f)
                        return 270;
                    else
                        return 40;
                else
                if (lat < 16.618416f)
                    return 40;
                else
                if (lat < 17.923909f)
                {
                    if (poly[2307].contains(lat,lng)) return 270;
                    else return 40;
                }
                else
                if (lat < 18.595112f)
                {
                    if (poly[2308].contains(lat,lng)) return 270;
                    else return 40;
                }
                else
                {
                    if (poly[2309].contains(lat,lng)) return 270;
                    else return 40;
                }
            else
                return 40;
        else
            return call30(lat,lng);
    }

    private static int call41(float lat, float lng)
    {
        if (lat < 66.269081f)
            if (lng < 68.564941f)
                return call39(lat,lng);
            else
            if (lat < 22.532944f)
                if (lng < 88.974408f)
                    return 371;
                else
                if (lng < 90.701530f)
                    if (lng < 89.295280f)
                        if (lng < 89.106918f)
                        {
                            if (poly[2310].contains(lat,lng)) return 150;
                            if (poly[2311].contains(lat,lng)) return 150;
                            if (poly[2312].contains(lat,lng)) return 150;
                            else return 371;
                        }
                        else
                            return 150;
                    else
                        return 150;
                else
                if (lng < 92.143913f)
                    return 150;
                else
                if (lng < 93.198753f)
                    if (lng < 92.359863f)
                        if (lat < 20.724388f)
                            return 150;
                        else
                        if (lat < 20.864358f)
                        {
                            if (poly[2313].contains(lat,lng)) return 150;
                            else return 40;
                        }
                        else
                        {
                            if (poly[2314].contains(lat,lng)) return 150;
                            else return 40;
                        }
                    else
                    if (lat < 20.758194f)
                        return 40;
                    else
                    {
                        if (poly[2315].contains(lat,lng)) return 150;
                        if (poly[2316].contains(lat,lng)) return 371;
                        else return 40;
                    }
                else
                if (lng < 102.310904f)
                    if (lng < 97.754829f)
                        return 40;
                    else
                    if (lng < 100.032866f)
                    {
                        if (poly[2317].contains(lat,lng)) return 403;
                        else return 40;
                    }
                    else
                    if (lng < 101.171885f)
                    {
                        if (poly[2318].contains(lat,lng)) return 265;
                        if (poly[2319].contains(lat,lng)) return 403;
                        else return 40;
                    }
                    else
                    if (lat < 21.589333f)
                    {
                        if (poly[2320].contains(lat,lng)) return 403;
                        else return 265;
                    }
                    else
                    {
                        if (poly[2321].contains(lat,lng)) return 24;
                        if (poly[2322].contains(lat,lng)) return 40;
                        if (poly[2323].contains(lat,lng)) return 403;
                        else return 265;
                    }
                else
                if (lat < 22.204487f)
                    if (lng < 103.707771f)
                    {
                        if (poly[2324].contains(lat,lng)) return 24;
                        else return 265;
                    }
                    else
                    {
                        if (poly[2325].contains(lat,lng)) return 265;
                        else return 24;
                    }
                else
                if (lng < 103.136834f)
                {
                    if (poly[2326].contains(lat,lng)) return 403;
                    else return 24;
                }
                else
                {
                    if (poly[2327].contains(lat,lng)) return 403;
                    else return 24;
                }
            else
            if (lat < 23.438555f)
                if (lng < 90.524109f)
                    if (lng < 88.997475f)
                        if (lng < 70.478226f)
                            return 371;
                        else
                        if (lat < 23.199751f)
                        {
                            if (poly[2328].contains(lat,lng)) return 150;
                            else return 371;
                        }
                        else
                        {
                            if (poly[2329].contains(lat,lng)) return 150;
                            else return 371;
                        }
                    else
                        return 150;
                else
                if (lng < 91.172333f)
                    return 150;
                else
                if (lng < 91.940453f)
                    if (lat < 22.756250f)
                        return 150;
                    else
                    {
                        if (poly[2330].contains(lat,lng)) return 371;
                        else return 150;
                    }
                else
                if (lng < 99.563530f)
                    if (lng < 93.402527f)
                        if (lng < 92.529763f)
                        {
                            if (poly[2331].contains(lat,lng)) return 371;
                            else return 150;
                        }
                        else
                        if (lat < 23.386499f)
                        {
                            if (poly[2332].contains(lat,lng)) return 40;
                            else return 371;
                        }
                        else
                        {
                            if (poly[2333].contains(lat,lng)) return 40;
                            else return 371;
                        }
                    else
                    {
                        if (poly[2334].contains(lat,lng)) return 403;
                        if (poly[2335].contains(lat,lng)) return 403;
                        else return 40;
                    }
                else
                if (lng < 102.907940f)
                {
                    if (poly[2336].contains(lat,lng)) return 24;
                    else return 403;
                }
                else
                if (lng < 103.916794f)
                {
                    if (poly[2337].contains(lat,lng)) return 24;
                    else return 403;
                }
                else
                {
                    if (poly[2338].contains(lat,lng)) return 24;
                    else return 403;
                }
            else
                return call38(lat,lng);
        else
        if (lng < 83.435236f)
            if (lng < 63.223320f)
                return 183;
            else
            if (lng < 79.953110f)
                if (lng < 71.758553f)
                    if (lng < 69.184860f)
                        if (lat < 69.667392f)
                            if (lng < 66.210541f)
                                if (lat < 66.326385f)
                                {
                                    if (poly[2339].contains(lat,lng)) return 183;
                                    else return 178;
                                }
                                else
                                if (lat < 67.696091f)
                                {
                                    if (poly[2340].contains(lat,lng)) return 183;
                                    else return 178;
                                }
                                else
                                {
                                    if (poly[2341].contains(lat,lng)) return 183;
                                    else return 178;
                                }
                            else
                                return 178;
                        else
                        if (lat < 72.784257f)
                            return 178;
                        else
                            return 183;
                    else
                        return 178;
                else
                if (lat < 69.003365f)
                    return 178;
                else
                if (lng < 76.088142f)
                    return 178;
                else
                if (lat < 72.602837f)
                    if (lng < 78.340698f)
                        return 178;
                    else
                    if (lat < 71.623577f)
                        if (lat < 70.303423f)
                        {
                            if (poly[2342].contains(lat,lng)) return 289;
                            else return 178;
                        }
                        else
                        {
                            if (poly[2343].contains(lat,lng)) return 289;
                            else return 178;
                        }
                    else
                    {
                        if (poly[2344].contains(lat,lng)) return 289;
                        else return 178;
                    }
                else
                if (lng < 76.746025f)
                    if (lat < 73.520027f)
                        return 178;
                    else
                        return 289;
                else
                    return 289;
            else
            if (lat < 71.978767f)
                if (lat < 70.489197f)
                    if (lng < 82.683777f)
                        if (lat < 70.098442f)
                            if (lat < 69.447754f)
                                if (lat < 68.630057f)
                                    if (lat < 68.286874f)
                                    {
                                        if (poly[2345].contains(lat,lng)) return 289;
                                        else return 178;
                                    }
                                    else
                                    {
                                        if (poly[2346].contains(lat,lng)) return 289;
                                        else return 178;
                                    }
                                else
                                if (lng < 81.683594f)
                                {
                                    if (poly[2347].contains(lat,lng)) return 289;
                                    else return 178;
                                }
                                else
                                {
                                    if (poly[2348].contains(lat,lng)) return 289;
                                    else return 178;
                                }
                            else
                                return 289;
                        else
                        if (lng < 80.798584f)
                        {
                            if (poly[2349].contains(lat,lng)) return 289;
                            if (poly[2350].contains(lat,lng)) return 289;
                            else return 178;
                        }
                        else
                            return 289;
                    else
                    if (lat < 68.798813f)
                        if (lat < 68.466825f)
                            if (lat < 67.026181f)
                            {
                                if (poly[2351].contains(lat,lng)) return 289;
                                else return 178;
                            }
                            else
                            {
                                if (poly[2352].contains(lat,lng)) return 178;
                                else return 289;
                            }
                        else
                        {
                            if (poly[2353].contains(lat,lng)) return 178;
                            else return 289;
                        }
                    else
                        return 289;
                else
                if (lng < 80.759369f)
                    if (lat < 70.654465f)
                    {
                        if (poly[2354].contains(lat,lng)) return 289;
                        else return 178;
                    }
                    else
                    if (lat < 71.133958f)
                    {
                        if (poly[2355].contains(lat,lng)) return 289;
                        else return 178;
                    }
                    else
                    {
                        if (poly[2356].contains(lat,lng)) return 178;
                        else return 289;
                    }
                else
                    return 289;
            else
                return 289;
        else
            return 289;
    }

    private static int call42(float lat, float lng)
    {
        if (lat < -10.915778f)
            if (lng < 152.840439f)
                if (lat < -21.024416f)
                    if (lat < -38.222610f)
                        if (lat < -40.198944f)
                            return 113;
                        else
                        if (lat < -39.442554f)
                            if (lng < 146.662109f)
                                if (lng < 144.138580f)
                                    return 43;
                                else
                                    return 126;
                            else
                                return 113;
                        else
                            return 126;
                    else
                    if (lng < 150.145752f)
                        if (lat < -28.555558f)
                            if (lng < 139.718369f)
                                return 67;
                            else
                            if (lng < 149.977966f)
                                if (lat < -37.546555f)
                                    if (lng < 140.969055f)
                                    {
                                        if (poly[2357].contains(lat,lng)) return 126;
                                        else return 67;
                                    }
                                    else
                                        return 126;
                                else
                                if (lng < 144.848167f)
                                    if (lat < -33.051056f)
                                        if (lng < 142.283268f)
                                            if (lat < -35.298805f)
                                            {
                                                if (poly[2358].contains(lat,lng)) return 126;
                                                else return 67;
                                            }
                                            else
                                            {
                                                if (poly[2359].contains(lat,lng)) return 67;
                                                if (poly[2360].contains(lat,lng)) return 207;
                                                else return 126;
                                            }
                                        else
                                        if (lat < -35.298805f)
                                        {
                                            if (poly[2361].contains(lat,lng)) return 207;
                                            else return 126;
                                        }
                                        else
                                        if (lng < 143.565718f)
                                            if (lat < -34.174931f)
                                                if (lng < 142.924493f)
                                                {
                                                    if (poly[2362].contains(lat,lng)) return 207;
                                                    else return 126;
                                                }
                                                else
                                                {
                                                    if (poly[2363].contains(lat,lng)) return 207;
                                                    else return 126;
                                                }
                                            else
                                                return 207;
                                        else
                                        {
                                            if (poly[2364].contains(lat,lng)) return 126;
                                            else return 207;
                                        }
                                    else
                                    {
                                        if (poly[2365].contains(lat,lng)) return 67;
                                        if (poly[2366].contains(lat,lng)) return 128;
                                        if (poly[2367].contains(lat,lng)) return 235;
                                        else return 207;
                                    }
                                else
                                if (lat < -33.051056f)
                                    if (lng < 147.413067f)
                                    {
                                        if (poly[2368].contains(lat,lng)) return 207;
                                        else return 126;
                                    }
                                    else
                                    {
                                        if (poly[2369].contains(lat,lng)) return 126;
                                        else return 207;
                                    }
                                else
                                {
                                    if (poly[2370].contains(lat,lng)) return 235;
                                    else return 207;
                                }
                            else
                            if (lat < -35.620555f)
                                return 207;
                            else
                            {
                                if (poly[2371].contains(lat,lng)) return 235;
                                else return 207;
                            }
                        else
                        if (lng < 141.004157f)
                        {
                            if (poly[2372].contains(lat,lng)) return 67;
                            if (poly[2373].contains(lat,lng)) return 235;
                            else return 10;
                        }
                        else
                            return 235;
                    else
                    if (lat < -28.264166f)
                        if (lat < -32.203251f)
                            return 207;
                        else
                        if (lng < 152.468948f)
                        {
                            if (poly[2374].contains(lat,lng)) return 235;
                            else return 207;
                        }
                        else
                        if (lat < -32.180173f)
                            return 207;
                        else
                        {
                            if (poly[2375].contains(lat,lng)) return 235;
                            else return 207;
                        }
                    else
                        return 235;
                else
                if (lng < 136.964493f)
                    return 10;
                else
                if (lng < 146.692200f)
                    if (lng < 138.000049f)
                        if (lng < 137.104355f)
                            return 10;
                        else
                        {
                            if (poly[2376].contains(lat,lng)) return 235;
                            else return 10;
                        }
                    else
                        return 235;
                else
                if (lat < -20.460417f)
                    return 235;
                else
                if (lng < 148.871002f)
                    return 235;
                else
                if (lng < 149.111053f)
                    if (lat < -20.333471f)
                        if (lng < 148.937225f)
                            return 235;
                        else
                        if (lng < 149.064468f)
                            return 213;
                        else
                            return 235;
                    else
                    if (lng < 148.893860f)
                        if (lat < -20.085666f)
                            return 213;
                        else
                            return 235;
                    else
                        return 235;
                else
                    return 170;
            else
            if (lat < -21.188667f)
                if (lng < 171.450439f)
                    if (lng < 159.045700f)
                        if (lat < -28.160110f)
                            if (lng < 153.483002f)
                                if (lat < -29.370111f)
                                    return 207;
                                else
                                {
                                    if (poly[2377].contains(lat,lng)) return 235;
                                    else return 207;
                                }
                            else
                            if (lng < 153.639252f)
                                if (lat < -28.204887f)
                                    return 207;
                                else
                                if (lng < 153.518413f)
                                {
                                    if (poly[2378].contains(lat,lng)) return 235;
                                    else return 207;
                                }
                                else
                                    return 207;
                            else
                                return 60;
                        else
                            return 235;
                    else
                    if (lat < -44.594396f)
                        return 377;
                    else
                    if (lat < -28.992390f)
                        if (lat < -41.865051f)
                            return 377;
                        else
                        if (lng < 159.111282f)
                            return 3;
                        else
                            return 224;
                    else
                        return 369;
                else
                    return 377;
            else
            if (lng < 177.058060f)
                if (lat < -16.968111f)
                    if (lng < 167.830368f)
                        return 369;
                    else
                    if (lng < 170.234772f)
                        return 232;
                    else
                        return 147;
                else
                if (lat < -12.518985f)
                    return 232;
                else
                if (lng < 154.281662f)
                    return 170;
                else
                if (lng < 168.843506f)
                    return 304;
                else
                    return 147;
            else
                return 147;
        else
        if (lng < 151.356415f)
            if (lng < 144.128952f)
                if (lng < 140.413481f)
                    return 131;
                else
                if (lat < -9.333750f)
                    return 235;
                else
                if (lng < 142.474640f)
                    if (lat < -9.182138f)
                        if (lng < 142.071442f)
                            if (lng < 141.950039f)
                                return 170;
                            else
                                return 235;
                        else
                        if (lng < 142.251190f)
                            return 235;
                        else
                        if (lat < -9.260387f)
                            return 235;
                        else
                        {
                            if (poly[2379].contains(lat,lng)) return 235;
                            else return 170;
                        }
                    else
                    if (lng < 141.021805f)
                        if (lng < 140.487747f)
                            return 131;
                        else
                        {
                            if (poly[2380].contains(lat,lng)) return 170;
                            else return 131;
                        }
                    else
                        return 170;
                else
                    return 170;
            else
                return 170;
        else
        if (lng < 158.416245f)
            if (lng < 157.126251f)
                if (lng < 154.725937f)
                    return 170;
                else
                if (lat < -6.962555f)
                    return 304;
                else
                if (lng < 155.963562f)
                    return 170;
                else
                if (lat < -6.589611f)
                    return 304;
                else
                    return 170;
            else
                return 304;
        else
        if (lat < -8.854750f)
            if (lng < 167.145645f)
                return 304;
            else
            if (lng < 167.233505f)
                return 304;
            else
                return 65;
        else
        if (lng < 173.587646f)
            if (lat < -5.449806f)
                return 304;
            else
            if (lng < 166.945282f)
                if (lat < -2.550833f)
                    return 170;
                else
                    return 398;
            else
                return 148;
        else
        if (lat < -5.641972f)
            return 65;
        else
            return 148;
    }

    private static int call43(float lat, float lng)
    {
        if (lng < 113.448914f)
            if (lng < 108.187553f)
                if (lng < 107.273552f)
                    if (lat < 20.199528f)
                        if (lat < 18.710368f)
                            if (lat < 12.303858f)
                            {
                                if (poly[2381].contains(lat,lng)) return 24;
                                else return 251;
                            }
                            else
                            if (lat < 16.095304f)
                                if (lat < 14.199581f)
                                {
                                    if (poly[2382].contains(lat,lng)) return 265;
                                    else return 251;
                                }
                                else
                                if (lng < 106.189095f)
                                    if (lat < 15.147442f)
                                    {
                                        if (poly[2383].contains(lat,lng)) return 251;
                                        if (poly[2384].contains(lat,lng)) return 251;
                                        if (poly[2385].contains(lat,lng)) return 270;
                                        else return 265;
                                    }
                                    else
                                    {
                                        if (poly[2386].contains(lat,lng)) return 270;
                                        else return 265;
                                    }
                                else
                                {
                                    if (poly[2387].contains(lat,lng)) return 24;
                                    if (poly[2388].contains(lat,lng)) return 251;
                                    else return 265;
                                }
                            else
                            if (lat < 17.402836f)
                            {
                                if (poly[2389].contains(lat,lng)) return 265;
                                else return 24;
                            }
                            else
                            {
                                if (poly[2390].contains(lat,lng)) return 265;
                                else return 24;
                            }
                        else
                            return 24;
                    else
                    if (lat < 21.023890f)
                        return 24;
                    else
                    if (lat < 23.203362f)
                        if (lat < 22.113626f)
                        {
                            if (poly[2391].contains(lat,lng)) return 403;
                            else return 24;
                        }
                        else
                        {
                            if (poly[2392].contains(lat,lng)) return 403;
                            else return 24;
                        }
                    else
                    {
                        if (poly[2393].contains(lat,lng)) return 24;
                        else return 403;
                    }
                else
                if (lat < 20.977722f)
                    if (lat < 16.122683f)
                        if (lat < 15.680320f)
                            if (lat < 13.628118f)
                            {
                                if (poly[2394].contains(lat,lng)) return 251;
                                else return 24;
                            }
                            else
                            if (lat < 14.654219f)
                            {
                                if (poly[2395].contains(lat,lng)) return 24;
                                if (poly[2396].contains(lat,lng)) return 265;
                                else return 251;
                            }
                            else
                            {
                                if (poly[2397].contains(lat,lng)) return 251;
                                if (poly[2398].contains(lat,lng)) return 265;
                                else return 24;
                            }
                        else
                        {
                            if (poly[2399].contains(lat,lng)) return 265;
                            else return 24;
                        }
                    else
                        return 24;
                else
                if (lat < 21.495306f)
                    return 24;
                else
                if (lng < 108.035889f)
                {
                    if (poly[2400].contains(lat,lng)) return 403;
                    else return 24;
                }
                else
                    return 403;
            else
            if (lat < 21.252361f)
                if (lat < 20.156473f)
                    if (lat < 16.223473f)
                        return 24;
                    else
                        return 403;
                else
                    return 406;
            else
            if (lng < 113.043556f)
                if (lng < 112.198914f)
                    if (lng < 109.072281f)
                        return 403;
                    else
                    if (lat < 22.694863f)
                        if (lng < 111.681794f)
                            if (lng < 111.101901f)
                                if (lng < 110.087091f)
                                {
                                    if (poly[2401].contains(lat,lng)) return 406;
                                    else return 403;
                                }
                                else
                                {
                                    if (poly[2402].contains(lat,lng)) return 403;
                                    else return 406;
                                }
                            else
                            if (lat < 21.392139f)
                                return 406;
                            else
                            {
                                if (poly[2403].contains(lat,lng)) return 406;
                                else return 403;
                            }
                        else
                            return 403;
                    else
                    if (lat < 23.139450f)
                    {
                        if (poly[2404].contains(lat,lng)) return 291;
                        else return 403;
                    }
                    else
                    if (lng < 110.635597f)
                        return 403;
                    else
                    if (lat < 24.261142f)
                    {
                        if (poly[2405].contains(lat,lng)) return 291;
                        if (poly[2406].contains(lat,lng)) return 291;
                        if (poly[2407].contains(lat,lng)) return 291;
                        else return 403;
                    }
                    else
                    {
                        if (poly[2408].contains(lat,lng)) return 403;
                        else return 291;
                    }
                else
                if (lat < 21.980417f)
                    return 403;
                else
                if (lat < 23.123449f)
                {
                    if (poly[2409].contains(lat,lng)) return 291;
                    if (poly[2410].contains(lat,lng)) return 291;
                    else return 403;
                }
                else
                if (lat < 23.211371f)
                {
                    if (poly[2411].contains(lat,lng)) return 403;
                    else return 291;
                }
                else
                if (lat < 23.385080f)
                {
                    if (poly[2412].contains(lat,lng)) return 403;
                    else return 291;
                }
                else
                {
                    if (poly[2413].contains(lat,lng)) return 403;
                    else return 291;
                }
            else
                return 291;
        else
        if (lat < 20.697500f)
            return 279;
        else
        if (lng < 114.403358f)
            if (lng < 113.837753f)
                if (lat < 22.222334f)
                    if (lng < 113.591026f)
                        if (lng < 113.526558f)
                            return 291;
                        else
                        if (lat < 22.137777f)
                        {
                            if (poly[2414].contains(lat,lng)) return 291;
                            else return 132;
                        }
                        else
                        if (lat < 22.163389f)
                            if (lng < 113.541180f)
                                return 132;
                            else
                                return 291;
                        else
                        {
                            if (poly[2415].contains(lat,lng)) return 291;
                            else return 132;
                        }
                    else
                        return 291;
                else
                    return 291;
            else
            if (lat < 22.253416f)
                if (lat < 22.129694f)
                    return 291;
                else
                    return 15;
            else
            if (lat < 22.374916f)
                return 15;
            else
            if (lat < 22.481138f)
                if (lng < 113.913659f)
                    if (lat < 22.442740f)
                        return 15;
                    else
                        return 291;
                else
                    return 15;
            else
            {
                if (poly[2416].contains(lat,lng)) return 291;
                else return 15;
            }
        else
        if (lng < 119.324997f)
            if (lng < 117.531754f)
                if (lat < 20.709833f)
                    return 125;
                else
                    return 291;
            else
            if (lng < 118.197639f)
                return 291;
            else
            if (lat < 24.531528f)
                if (lng < 118.472969f)
                    return 125;
                else
                if (lat < 23.962000f)
                    return 125;
                else
                    return 291;
            else
                return 291;
        else
        if (lat < 24.179411f)
            return 125;
        else
            return 291;
    }

    private static int call44(float lat, float lng)
    {
        if (lng < 120.827698f)
            if (lat < 43.386189f)
                if (lng < 114.824286f)
                    if (lng < 109.964462f)
                    {
                        if (poly[2417].contains(lat,lng)) return 403;
                        else return 123;
                    }
                    else
                    if (lng < 112.394374f)
                    {
                        if (poly[2418].contains(lat,lng)) return 123;
                        if (poly[2419].contains(lat,lng)) return 291;
                        if (poly[2420].contains(lat,lng)) return 291;
                        else return 403;
                    }
                    else
                    if (lat < 41.384137f)
                    {
                        if (poly[2421].contains(lat,lng)) return 403;
                        else return 291;
                    }
                    else
                    {
                        if (poly[2422].contains(lat,lng)) return 403;
                        else return 291;
                    }
                else
                    return 291;
            else
            if (lat < 53.269103f)
                if (lng < 112.966167f)
                    if (lat < 48.327646f)
                        if (lng < 109.035402f)
                            return 123;
                        else
                        if (lat < 45.856918f)
                        {
                            if (poly[2423].contains(lat,lng)) return 123;
                            if (poly[2424].contains(lat,lng)) return 203;
                            else return 291;
                        }
                        else
                        {
                            if (poly[2425].contains(lat,lng)) return 203;
                            else return 123;
                        }
                    else
                    if (lng < 109.035402f)
                        if (lat < 50.798375f)
                            if (lng < 107.070020f)
                            {
                                if (poly[2426].contains(lat,lng)) return 123;
                                else return 144;
                            }
                            else
                            if (lat < 49.563011f)
                            {
                                if (poly[2427].contains(lat,lng)) return 141;
                                else return 123;
                            }
                            else
                            {
                                if (poly[2428].contains(lat,lng)) return 123;
                                if (poly[2429].contains(lat,lng)) return 144;
                                else return 141;
                            }
                        else
                        {
                            if (poly[2430].contains(lat,lng)) return 141;
                            else return 144;
                        }
                    else
                    if (lat < 50.798375f)
                    {
                        if (poly[2431].contains(lat,lng)) return 141;
                        if (poly[2432].contains(lat,lng)) return 203;
                        else return 123;
                    }
                    else
                    {
                        if (poly[2433].contains(lat,lng)) return 144;
                        else return 141;
                    }
                else
                if (lat < 48.327646f)
                    if (lng < 116.896933f)
                    {
                        if (poly[2434].contains(lat,lng)) return 203;
                        else return 291;
                    }
                    else
                    if (lat < 45.856918f)
                        return 291;
                    else
                    if (lng < 118.862315f)
                    {
                        if (poly[2435].contains(lat,lng)) return 203;
                        else return 291;
                    }
                    else
                    {
                        if (poly[2436].contains(lat,lng)) return 203;
                        else return 291;
                    }
                else
                if (lng < 116.896933f)
                    if (lat < 50.798375f)
                    {
                        if (poly[2437].contains(lat,lng)) return 141;
                        if (poly[2438].contains(lat,lng)) return 291;
                        else return 203;
                    }
                    else
                    {
                        if (poly[2439].contains(lat,lng)) return 144;
                        else return 141;
                    }
                else
                if (lat < 50.798375f)
                {
                    if (poly[2440].contains(lat,lng)) return 141;
                    else return 291;
                }
                else
                if (lng < 118.862315f)
                    return 141;
                else
                if (lat < 52.033739f)
                {
                    if (poly[2441].contains(lat,lng)) return 291;
                    else return 141;
                }
                else
                {
                    if (poly[2442].contains(lat,lng)) return 291;
                    else return 141;
                }
            else
            if (lng < 105.495247f)
                if (lat < 59.469437f)
                {
                    if (poly[2443].contains(lat,lng)) return 289;
                    else return 144;
                }
                else
                {
                    if (poly[2444].contains(lat,lng)) return 289;
                    else return 144;
                }
            else
            if (lng < 113.161472f)
                if (lng < 109.328360f)
                {
                    if (poly[2445].contains(lat,lng)) return 141;
                    if (poly[2446].contains(lat,lng)) return 141;
                    else return 144;
                }
                else
                if (lat < 56.783855f)
                    return 144;
                else
                if (lng < 111.244916f)
                {
                    if (poly[2447].contains(lat,lng)) return 141;
                    else return 144;
                }
                else
                {
                    if (poly[2448].contains(lat,lng)) return 144;
                    else return 141;
                }
            else
            if (lng < 116.994585f)
                if (lat < 56.783855f)
                    if (lng < 115.078029f)
                    {
                        if (poly[2449].contains(lat,lng)) return 141;
                        else return 144;
                    }
                    else
                    if (lat < 55.026479f)
                    {
                        if (poly[2450].contains(lat,lng)) return 144;
                        else return 141;
                    }
                    else
                    {
                        if (poly[2451].contains(lat,lng)) return 141;
                        else return 144;
                    }
                else
                {
                    if (poly[2452].contains(lat,lng)) return 144;
                    else return 141;
                }
            else
            if (lat < 56.783855f)
            {
                if (poly[2453].contains(lat,lng)) return 144;
                else return 141;
            }
            else
            if (lng < 118.911141f)
                if (lat < 58.541231f)
                    if (lng < 117.952863f)
                    {
                        if (poly[2454].contains(lat,lng)) return 141;
                        else return 144;
                    }
                    else
                    {
                        if (poly[2455].contains(lat,lng)) return 144;
                        else return 141;
                    }
                else
                {
                    if (poly[2456].contains(lat,lng)) return 144;
                    else return 141;
                }
            else
            {
                if (poly[2457].contains(lat,lng)) return 144;
                else return 141;
            }
        else
        if (lat < 40.943722f)
            return 291;
        else
        if (lat < 48.188303f)
            if (lat < 44.566012f)
            {
                if (poly[2458].contains(lat,lng)) return 42;
                else return 291;
            }
            else
            if (lat < 46.377158f)
            {
                if (poly[2459].contains(lat,lng)) return 291;
                else return 42;
            }
            else
            {
                if (poly[2460].contains(lat,lng)) return 42;
                else return 291;
            }
        else
        if (lat < 52.939128f)
        {
            if (poly[2461].contains(lat,lng)) return 42;
            else return 291;
        }
        else
        {
            if (poly[2462].contains(lat,lng)) return 291;
            else return 141;
        }
    }

    private static int call45(float lat, float lng)
    {
        if (lat < 60.298607f)
            if (lat < 38.331139f)
                if (lng < 126.114944f)
                    if (lng < 122.704277f)
                        if (lng < 110.802727f)
                            if (lat < 37.663533f)
                            {
                                if (poly[2463].contains(lat,lng)) return 291;
                                else return 403;
                            }
                            else
                            {
                                if (poly[2464].contains(lat,lng)) return 291;
                                else return 403;
                            }
                        else
                            return 291;
                    else
                    if (lat < 37.284248f)
                        return 11;
                    else
                    if (lng < 125.197052f)
                        if (lng < 124.768219f)
                            if (lat < 37.982666f)
                                return 11;
                            else
                                return 151;
                        else
                            return 151;
                    else
                    if (lat < 37.678055f)
                        if (lng < 125.510507f)
                            return 11;
                        else
                            return 151;
                    else
                        return 151;
                else
                if (lat < 37.681999f)
                    return 11;
                else
                if (lng < 126.666692f)
                    if (lng < 126.167000f)
                        return 151;
                    else
                    if (lat < 37.749195f)
                        return 11;
                    else
                    if (lng < 126.336586f)
                        if (lat < 37.823339f)
                            return 11;
                        else
                            return 151;
                    else
                    if (lng < 126.516444f)
                    {
                        if (poly[2465].contains(lat,lng)) return 11;
                        else return 151;
                    }
                    else
                    {
                        if (poly[2466].contains(lat,lng)) return 11;
                        else return 151;
                    }
                else
                if (lng < 127.382829f)
                {
                    if (poly[2467].contains(lat,lng)) return 151;
                    else return 11;
                }
                else
                {
                    if (poly[2468].contains(lat,lng)) return 151;
                    else return 11;
                }
            else
            if (lat < 39.382084f)
                if (lng < 121.710999f)
                    if (lng < 111.212129f)
                        if (lat < 39.289394f)
                        {
                            if (poly[2469].contains(lat,lng)) return 291;
                            else return 403;
                        }
                        else
                        {
                            if (poly[2470].contains(lat,lng)) return 291;
                            else return 403;
                        }
                    else
                        return 291;
                else
                if (lng < 123.197807f)
                    return 291;
                else
                    return 151;
            else
            if (lng < 123.756470f)
                return call44(lat,lng);
            else
            if (lat < 39.723915f)
                return 151;
            else
            if (lat < 39.931973f)
                if (lng < 124.255466f)
                {
                    if (poly[2471].contains(lat,lng)) return 151;
                    else return 291;
                }
                else
                    return 151;
            else
            if (lat < 43.487705f)
                if (lng < 123.811134f)
                {
                    if (poly[2472].contains(lat,lng)) return 42;
                    else return 291;
                }
                else
                if (lng < 125.610680f)
                    if (lat < 41.709839f)
                    {
                        if (poly[2473].contains(lat,lng)) return 42;
                        if (poly[2474].contains(lat,lng)) return 42;
                        if (poly[2475].contains(lat,lng)) return 291;
                        else return 151;
                    }
                    else
                    {
                        if (poly[2476].contains(lat,lng)) return 291;
                        else return 42;
                    }
                else
                if (lat < 41.709839f)
                    if (lng < 126.510452f)
                    {
                        if (poly[2477].contains(lat,lng)) return 151;
                        if (poly[2478].contains(lat,lng)) return 151;
                        if (poly[2479].contains(lat,lng)) return 291;
                        if (poly[2480].contains(lat,lng)) return 291;
                        else return 42;
                    }
                    else
                    {
                        if (poly[2481].contains(lat,lng)) return 151;
                        else return 42;
                    }
                else
                {
                    if (poly[2482].contains(lat,lng)) return 151;
                    if (poly[2483].contains(lat,lng)) return 151;
                    else return 42;
                }
            else
            if (lat < 51.893156f)
                if (lat < 47.690430f)
                    return 42;
                else
                if (lat < 49.791793f)
                {
                    if (poly[2484].contains(lat,lng)) return 291;
                    else return 42;
                }
                else
                if (lng < 125.583347f)
                {
                    if (poly[2485].contains(lat,lng)) return 291;
                    else return 42;
                }
                else
                {
                    if (poly[2486].contains(lat,lng)) return 141;
                    if (poly[2487].contains(lat,lng)) return 291;
                    else return 42;
                }
            else
            if (lat < 56.095881f)
                if (lat < 53.994519f)
                    if (lng < 125.583347f)
                    {
                        if (poly[2488].contains(lat,lng)) return 141;
                        if (poly[2489].contains(lat,lng)) return 291;
                        else return 42;
                    }
                    else
                    {
                        if (poly[2490].contains(lat,lng)) return 42;
                        else return 141;
                    }
                else
                    return 141;
            else
                return 141;
        else
        if (lng < 118.797836f)
            if (lat < 75.927002f)
                if (lat < 73.209663f)
                    if (lat < 72.847191f)
                        if (lng < 112.725800f)
                            if (lat < 66.572899f)
                                if (lng < 108.915218f)
                                    if (lat < 63.435753f)
                                    {
                                        if (poly[2491].contains(lat,lng)) return 289;
                                        else return 144;
                                    }
                                    else
                                    if (lng < 107.009928f)
                                        if (lat < 65.004326f)
                                        {
                                            if (poly[2492].contains(lat,lng)) return 141;
                                            if (poly[2493].contains(lat,lng)) return 144;
                                            else return 289;
                                        }
                                        else
                                        {
                                            if (poly[2494].contains(lat,lng)) return 289;
                                            else return 141;
                                        }
                                    else
                                    if (lat < 65.004326f)
                                        if (lng < 107.962573f)
                                        {
                                            if (poly[2495].contains(lat,lng)) return 141;
                                            if (poly[2496].contains(lat,lng)) return 144;
                                            else return 289;
                                        }
                                        else
                                        {
                                            if (poly[2497].contains(lat,lng)) return 141;
                                            if (poly[2498].contains(lat,lng)) return 289;
                                            else return 144;
                                        }
                                    else
                                        return 141;
                                else
                                if (lat < 63.435753f)
                                    if (lng < 110.820509f)
                                        if (lat < 61.867180f)
                                        {
                                            if (poly[2499].contains(lat,lng)) return 144;
                                            else return 141;
                                        }
                                        else
                                        {
                                            if (poly[2500].contains(lat,lng)) return 144;
                                            else return 141;
                                        }
                                    else
                                        return 141;
                                else
                                {
                                    if (poly[2501].contains(lat,lng)) return 144;
                                    else return 141;
                                }
                            else
                            if (lng < 108.915218f)
                            {
                                if (poly[2502].contains(lat,lng)) return 141;
                                else return 289;
                            }
                            else
                            if (lat < 69.710045f)
                                return 141;
                            else
                            if (lng < 110.820509f)
                            {
                                if (poly[2503].contains(lat,lng)) return 289;
                                else return 141;
                            }
                            else
                            {
                                if (poly[2504].contains(lat,lng)) return 289;
                                else return 141;
                            }
                        else
                        {
                            if (poly[2505].contains(lat,lng)) return 144;
                            else return 141;
                        }
                    else
                    if (lng < 108.341057f)
                        return 289;
                    else
                    {
                        if (poly[2506].contains(lat,lng)) return 141;
                        else return 289;
                    }
                else
                if (lng < 113.919746f)
                    if (lng < 109.343498f)
                        return 289;
                    else
                    if (lat < 74.049721f)
                        if (lng < 111.589165f)
                        {
                            if (poly[2507].contains(lat,lng)) return 141;
                            else return 289;
                        }
                        else
                            return 141;
                    else
                    if (lng < 111.209999f)
                    {
                        if (poly[2508].contains(lat,lng)) return 141;
                        else return 289;
                    }
                    else
                    if (lat < 74.551941f)
                        return 141;
                    else
                    {
                        if (poly[2509].contains(lat,lng)) return 141;
                        else return 289;
                    }
                else
                    return 141;
            else
                return 289;
        else
            return 141;
    }

    private static int call46(float lat, float lng)
    {
        if (lat < 54.555332f)
            if (lng < 141.546310f)
                if (lng < 134.959961f)
                    if (lng < 132.286469f)
                        if (lat < 52.739679f)
                        {
                            if (poly[2510].contains(lat,lng)) return 37;
                            else return 141;
                        }
                        else
                        {
                            if (poly[2511].contains(lat,lng)) return 37;
                            else return 141;
                        }
                    else
                    if (lat < 52.739679f)
                    {
                        if (poly[2512].contains(lat,lng)) return 141;
                        else return 37;
                    }
                    else
                    if (lng < 133.623215f)
                    {
                        if (poly[2513].contains(lat,lng)) return 141;
                        else return 37;
                    }
                    else
                    {
                        if (poly[2514].contains(lat,lng)) return 141;
                        else return 37;
                    }
                else
                    return 37;
            else
                return 36;
        else
        if (lat < 55.194805f)
            if (lng < 132.413686f)
            {
                if (poly[2515].contains(lat,lng)) return 37;
                else return 141;
            }
            else
                return 37;
        else
        if (lat < 71.260391f)
            if (lng < 139.044365f)
                if (lat < 63.227598f)
                    if (lng < 134.328671f)
                        if (lat < 59.211202f)
                            if (lng < 131.970823f)
                                if (lat < 57.203003f)
                                    if (lng < 130.791900f)
                                        return 141;
                                    else
                                    if (lat < 56.198904f)
                                    {
                                        if (poly[2516].contains(lat,lng)) return 37;
                                        else return 141;
                                    }
                                    else
                                    {
                                        if (poly[2517].contains(lat,lng)) return 141;
                                        else return 37;
                                    }
                                else
                                {
                                    if (poly[2518].contains(lat,lng)) return 37;
                                    if (poly[2519].contains(lat,lng)) return 37;
                                    if (poly[2520].contains(lat,lng)) return 37;
                                    if (poly[2521].contains(lat,lng)) return 104;
                                    else return 141;
                                }
                            else
                            if (lat < 57.203003f)
                            {
                                if (poly[2522].contains(lat,lng)) return 141;
                                else return 37;
                            }
                            else
                            if (lng < 133.149747f)
                            {
                                if (poly[2523].contains(lat,lng)) return 104;
                                if (poly[2524].contains(lat,lng)) return 141;
                                if (poly[2525].contains(lat,lng)) return 141;
                                if (poly[2526].contains(lat,lng)) return 141;
                                else return 37;
                            }
                            else
                            {
                                if (poly[2527].contains(lat,lng)) return 104;
                                if (poly[2528].contains(lat,lng)) return 104;
                                else return 37;
                            }
                        else
                        {
                            if (poly[2529].contains(lat,lng)) return 37;
                            if (poly[2530].contains(lat,lng)) return 141;
                            else return 104;
                        }
                    else
                    if (lat < 59.211202f)
                    {
                        if (poly[2531].contains(lat,lng)) return 104;
                        if (poly[2532].contains(lat,lng)) return 104;
                        else return 37;
                    }
                    else
                    if (lng < 136.686518f)
                    {
                        if (poly[2533].contains(lat,lng)) return 37;
                        if (poly[2534].contains(lat,lng)) return 37;
                        if (poly[2535].contains(lat,lng)) return 141;
                        else return 104;
                    }
                    else
                    if (lat < 61.219400f)
                        if (lng < 137.865441f)
                        {
                            if (poly[2536].contains(lat,lng)) return 104;
                            else return 37;
                        }
                        else
                        {
                            if (poly[2537].contains(lat,lng)) return 104;
                            else return 37;
                        }
                    else
                    {
                        if (poly[2538].contains(lat,lng)) return 37;
                        if (poly[2539].contains(lat,lng)) return 37;
                        else return 104;
                    }
                else
                if (lng < 134.328671f)
                    if (lat < 67.243995f)
                        if (lng < 131.970823f)
                        {
                            if (poly[2540].contains(lat,lng)) return 37;
                            else return 141;
                        }
                        else
                        {
                            if (poly[2541].contains(lat,lng)) return 37;
                            if (poly[2542].contains(lat,lng)) return 141;
                            if (poly[2543].contains(lat,lng)) return 141;
                            else return 104;
                        }
                    else
                    {
                        if (poly[2544].contains(lat,lng)) return 37;
                        else return 141;
                    }
                else
                {
                    if (poly[2545].contains(lat,lng)) return 46;
                    if (poly[2546].contains(lat,lng)) return 104;
                    else return 37;
                }
            else
            if (lat < 64.217725f)
                if (lng < 143.760059f)
                    if (lat < 60.696391f)
                        return 37;
                    else
                    if (lng < 141.402212f)
                        if (lat < 62.457058f)
                        {
                            if (poly[2547].contains(lat,lng)) return 104;
                            if (poly[2548].contains(lat,lng)) return 104;
                            if (poly[2549].contains(lat,lng)) return 140;
                            if (poly[2550].contains(lat,lng)) return 140;
                            else return 37;
                        }
                        else
                        {
                            if (poly[2551].contains(lat,lng)) return 37;
                            if (poly[2552].contains(lat,lng)) return 104;
                            else return 140;
                        }
                    else
                    {
                        if (poly[2553].contains(lat,lng)) return 140;
                        else return 37;
                    }
                else
                if (lat < 61.679001f)
                    if (lng < 146.117907f)
                    {
                        if (poly[2554].contains(lat,lng)) return 46;
                        else return 37;
                    }
                    else
                    if (lat < 60.425264f)
                    {
                        if (poly[2555].contains(lat,lng)) return 37;
                        else return 46;
                    }
                    else
                    {
                        if (poly[2556].contains(lat,lng)) return 37;
                        else return 46;
                    }
                else
                if (lng < 146.117907f)
                    if (lat < 62.948363f)
                        if (lng < 144.938983f)
                        {
                            if (poly[2557].contains(lat,lng)) return 46;
                            if (poly[2558].contains(lat,lng)) return 140;
                            else return 37;
                        }
                        else
                        {
                            if (poly[2559].contains(lat,lng)) return 37;
                            if (poly[2560].contains(lat,lng)) return 140;
                            else return 46;
                        }
                    else
                    {
                        if (poly[2561].contains(lat,lng)) return 46;
                        else return 140;
                    }
                else
                {
                    if (poly[2562].contains(lat,lng)) return 37;
                    if (poly[2563].contains(lat,lng)) return 140;
                    else return 46;
                }
            else
            if (lng < 143.760059f)
                if (lat < 67.739058f)
                    if (lng < 141.402212f)
                        if (lat < 65.978391f)
                        {
                            if (poly[2564].contains(lat,lng)) return 37;
                            if (poly[2565].contains(lat,lng)) return 46;
                            if (poly[2566].contains(lat,lng)) return 140;
                            else return 104;
                        }
                        else
                        {
                            if (poly[2567].contains(lat,lng)) return 46;
                            else return 37;
                        }
                    else
                    {
                        if (poly[2568].contains(lat,lng)) return 140;
                        else return 46;
                    }
                else
                {
                    if (poly[2569].contains(lat,lng)) return 46;
                    else return 37;
                }
            else
            {
                if (poly[2570].contains(lat,lng)) return 140;
                else return 46;
            }
        else
        if (lng < 138.020813f)
            return 37;
        else
        {
            if (poly[2571].contains(lat,lng)) return 46;
            else return 37;
        }
    }

    private static int call47(float lat, float lng)
    {
        if (lat < 50.924026f)
            if (lat < 35.537945f)
                if (lng < 128.948471f)
                    return 11;
                else
                if (lng < 129.456300f)
                    if (lat < 34.702641f)
                        return 280;
                    else
                        return 11;
                else
                    return 280;
            else
            if (lng < 140.967285f)
                if (lat < 39.235085f)
                    if (lng < 130.923218f)
                        if (lng < 128.363785f)
                            if (lat < 38.612446f)
                            {
                                if (poly[2572].contains(lat,lng)) return 151;
                                else return 11;
                            }
                            else
                                return 151;
                        else
                            return 11;
                    else
                        return 280;
                else
                if (lng < 131.517105f)
                    if (lat < 40.005638f)
                        return 151;
                    else
                    if (lat < 45.016474f)
                        if (lng < 130.936279f)
                            if (lng < 130.674866f)
                                if (lat < 42.511056f)
                                    if (lng < 129.042545f)
                                    {
                                        if (poly[2573].contains(lat,lng)) return 42;
                                        else return 151;
                                    }
                                    else
                                    {
                                        if (poly[2574].contains(lat,lng)) return 37;
                                        if (poly[2575].contains(lat,lng)) return 42;
                                        if (poly[2576].contains(lat,lng)) return 42;
                                        else return 151;
                                    }
                                else
                                {
                                    if (poly[2577].contains(lat,lng)) return 37;
                                    if (poly[2578].contains(lat,lng)) return 151;
                                    else return 42;
                                }
                            else
                            if (lat < 42.642555f)
                                return 37;
                            else
                            {
                                if (poly[2579].contains(lat,lng)) return 42;
                                else return 37;
                            }
                        else
                        if (lat < 42.833363f)
                            return 37;
                        else
                        {
                            if (poly[2580].contains(lat,lng)) return 42;
                            else return 37;
                        }
                    else
                    if (lat < 47.970250f)
                    {
                        if (poly[2581].contains(lat,lng)) return 37;
                        else return 42;
                    }
                    else
                    if (lng < 129.463665f)
                    {
                        if (poly[2582].contains(lat,lng)) return 42;
                        else return 141;
                    }
                    else
                    if (lat < 49.447138f)
                        if (lng < 130.490385f)
                        {
                            if (poly[2583].contains(lat,lng)) return 141;
                            else return 42;
                        }
                        else
                        {
                            if (poly[2584].contains(lat,lng)) return 42;
                            if (poly[2585].contains(lat,lng)) return 141;
                            else return 37;
                        }
                    else
                    {
                        if (poly[2586].contains(lat,lng)) return 141;
                        else return 37;
                    }
                else
                if (lat < 42.342888f)
                    return 280;
                else
                if (lng < 131.939438f)
                    if (lat < 43.206934f)
                        return 37;
                    else
                    if (lat < 45.336029f)
                        if (lng < 131.891479f)
                        {
                            if (poly[2587].contains(lat,lng)) return 42;
                            else return 37;
                        }
                        else
                        {
                            if (poly[2588].contains(lat,lng)) return 42;
                            else return 37;
                        }
                    else
                    {
                        if (poly[2589].contains(lat,lng)) return 42;
                        else return 37;
                    }
                else
                if (lng < 134.773911f)
                    if (lat < 42.900028f)
                        return 37;
                    else
                    if (lat < 46.912027f)
                    {
                        if (poly[2590].contains(lat,lng)) return 42;
                        else return 37;
                    }
                    else
                    if (lat < 48.918027f)
                        if (lng < 133.356674f)
                        {
                            if (poly[2591].contains(lat,lng)) return 42;
                            else return 37;
                        }
                        else
                        {
                            if (poly[2592].contains(lat,lng)) return 42;
                            else return 37;
                        }
                    else
                        return 37;
                else
                {
                    if (poly[2593].contains(lat,lng)) return 280;
                    else return 37;
                }
            else
            if (lng < 146.209671f)
                if (lat < 43.290001f)
                    return 280;
                else
                if (lng < 145.393784f)
                    if (lat < 45.523140f)
                        return 280;
                    else
                        return 36;
                else
                if (lng < 145.820892f)
                    if (lat < 43.521431f)
                        return 140;
                    else
                        return 280;
                else
                    return 140;
            else
            if (lng < 156.510300f)
                return 140;
            else
                return 373;
        else
        if (lng < 148.475754f)
            if (lng < 129.612976f)
                return 141;
            else
            if (lat < 71.356834f)
                return call46(lat,lng);
            else
            if (lat < 72.331413f)
                if (lng < 137.560638f)
                    if (lng < 130.047699f)
                        return 141;
                    else
                        return 37;
                else
                if (lng < 138.896896f)
                    return 37;
                else
                {
                    if (poly[2594].contains(lat,lng)) return 46;
                    else return 37;
                }
            else
                return 37;
        else
        if (lng < 161.149689f)
            if (lng < 152.057312f)
                if (lat < 72.314082f)
                    return 46;
                else
                    return 37;
            else
            if (lat < 69.467075f)
                if (lat < 68.347848f)
                    if (lng < 155.534637f)
                        return 46;
                    else
                    if (lat < 59.780066f)
                        if (lng < 155.597702f)
                            if (lat < 57.468508f)
                                return 46;
                            else
                                return 373;
                        else
                            return 373;
                    else
                    if (lat < 60.907417f)
                        return 46;
                    else
                    if (lat < 64.627632f)
                        return 46;
                    else
                    if (lng < 158.342163f)
                    {
                        if (poly[2595].contains(lat,lng)) return 365;
                        else return 46;
                    }
                    else
                    {
                        if (poly[2596].contains(lat,lng)) return 365;
                        else return 46;
                    }
                else
                    return 46;
            else
            if (lat < 71.090889f)
                return 46;
            else
                return 37;
        else
        if (lat < 65.153413f)
            if (lat < 53.005890f)
                return 158;
            else
            if (lat < 60.870335f)
                return 373;
            else
            if (lng < 163.466064f)
                if (lat < 64.386932f)
                    if (lat < 61.465637f)
                        if (lng < 162.566748f)
                            return 46;
                        else
                            return 373;
                    else
                    if (lat < 62.926285f)
                    {
                        if (poly[2597].contains(lat,lng)) return 46;
                        else return 373;
                    }
                    else
                    {
                        if (poly[2598].contains(lat,lng)) return 46;
                        else return 373;
                    }
                else
                {
                    if (poly[2599].contains(lat,lng)) return 365;
                    if (poly[2600].contains(lat,lng)) return 373;
                    else return 46;
                }
            else
            if (lng < 174.513611f)
                if (lat < 61.112862f)
                    return 373;
                else
                if (lng < 168.989838f)
                    if (lng < 166.227951f)
                    {
                        if (poly[2601].contains(lat,lng)) return 365;
                        else return 373;
                    }
                    else
                    {
                        if (poly[2602].contains(lat,lng)) return 373;
                        else return 365;
                    }
                else
                if (lng < 171.751724f)
                    if (lat < 63.133138f)
                    {
                        if (poly[2603].contains(lat,lng)) return 373;
                        else return 365;
                    }
                    else
                    {
                        if (poly[2604].contains(lat,lng)) return 373;
                        else return 365;
                    }
                else
                {
                    if (poly[2605].contains(lat,lng)) return 365;
                    else return 373;
                }
            else
                return 365;
        else
        if (lng < 162.849396f)
            if (lat < 69.663055f)
                if (lng < 161.655670f)
                    if (lat < 68.411377f)
                        if (lng < 161.365784f)
                        {
                            if (poly[2606].contains(lat,lng)) return 46;
                            else return 365;
                        }
                        else
                        {
                            if (poly[2607].contains(lat,lng)) return 46;
                            else return 365;
                        }
                    else
                        return 46;
                else
                if (lng < 161.891998f)
                    if (lat < 68.378539f)
                    {
                        if (poly[2608].contains(lat,lng)) return 46;
                        else return 365;
                    }
                    else
                        return 46;
                else
                if (lat < 68.869705f)
                {
                    if (poly[2609].contains(lat,lng)) return 46;
                    else return 365;
                }
                else
                if (lng < 162.089188f)
                    return 46;
                else
                {
                    if (poly[2610].contains(lat,lng)) return 365;
                    else return 46;
                }
            else
                return 46;
        else
            return 365;
    }

    private static int call48(float lat, float lng)
    {
        if (lng < 120.474747f)
            if (lat < 11.575916f)
                if (lat < 5.157583f)
                    if (lng < 108.696526f)
                        return 26;
                    else
                    if (lng < 118.300781f)
                        if (lat < 3.061667f)
                            if (lng < 109.267975f)
                                if (lat < 1.751361f)
                                    return 320;
                                else
                                    return 26;
                            else
                            if (lng < 115.507401f)
                                if (lng < 111.416031f)
                                    if (lat < 2.083333f)
                                    {
                                        if (poly[2611].contains(lat,lng)) return 320;
                                        else return 286;
                                    }
                                    else
                                        return 286;
                                else
                                if (lng < 113.461716f)
                                {
                                    if (poly[2612].contains(lat,lng)) return 320;
                                    else return 286;
                                }
                                else
                                if (lat < 1.841722f)
                                    if (lng < 114.484558f)
                                    {
                                        if (poly[2613].contains(lat,lng)) return 286;
                                        if (poly[2614].contains(lat,lng)) return 383;
                                        else return 320;
                                    }
                                    else
                                    {
                                        if (poly[2615].contains(lat,lng)) return 286;
                                        if (poly[2616].contains(lat,lng)) return 320;
                                        else return 383;
                                    }
                                else
                                {
                                    if (poly[2617].contains(lat,lng)) return 383;
                                    else return 286;
                                }
                            else
                                return 383;
                        else
                        if (lng < 117.507942f)
                            if (lat < 3.454611f)
                                if (lng < 115.648697f)
                                {
                                    if (poly[2618].contains(lat,lng)) return 383;
                                    if (poly[2619].contains(lat,lng)) return 383;
                                    else return 286;
                                }
                                else
                                    return 383;
                            else
                            if (lng < 117.061142f)
                                if (lng < 115.359444f)
                                    if (lng < 114.294377f)
                                    {
                                        if (poly[2620].contains(lat,lng)) return 217;
                                        else return 286;
                                    }
                                    else
                                    if (lat < 4.250889f)
                                    {
                                        if (poly[2621].contains(lat,lng)) return 217;
                                        if (poly[2622].contains(lat,lng)) return 217;
                                        else return 286;
                                    }
                                    else
                                    if (lng < 114.826910f)
                                    {
                                        if (poly[2623].contains(lat,lng)) return 286;
                                        if (poly[2624].contains(lat,lng)) return 286;
                                        if (poly[2625].contains(lat,lng)) return 286;
                                        if (poly[2626].contains(lat,lng)) return 286;
                                        else return 217;
                                    }
                                    else
                                    {
                                        if (poly[2627].contains(lat,lng)) return 286;
                                        if (poly[2628].contains(lat,lng)) return 286;
                                        else return 217;
                                    }
                                else
                                {
                                    if (poly[2629].contains(lat,lng)) return 383;
                                    if (poly[2630].contains(lat,lng)) return 383;
                                    else return 286;
                                }
                            else
                            if (lat < 3.628139f)
                                return 383;
                            else
                            {
                                if (poly[2631].contains(lat,lng)) return 286;
                                else return 383;
                            }
                        else
                        if (lat < 4.147695f)
                            return 383;
                        else
                        if (lng < 117.585808f)
                        {
                            if (poly[2632].contains(lat,lng)) return 383;
                            else return 286;
                        }
                        else
                        {
                            if (poly[2633].contains(lat,lng)) return 383;
                            else return 286;
                        }
                    else
                    if (lng < 119.222952f)
                        if (lat < 2.312556f)
                            return 383;
                        else
                            return 286;
                    else
                    if (lat < 1.079167f)
                        return 383;
                    else
                        return 279;
                else
                if (lng < 119.272194f)
                    if (lat < 6.890389f)
                        return 286;
                    else
                    if (lng < 117.930031f)
                        if (lat < 7.363417f)
                            return 286;
                        else
                        if (lng < 109.135417f)
                            if (lng < 106.207001f)
                            {
                                if (poly[2634].contains(lat,lng)) return 251;
                                else return 24;
                            }
                            else
                                return 24;
                        else
                            return 279;
                    else
                        return 279;
                else
                    return 279;
            else
                return call43(lat,lng);
        else
        if (lng < 124.619637f)
            if (lat < 11.415667f)
                if (lat < 1.422111f)
                    return 383;
                else
                    return 279;
            else
            if (lat < 21.103582f)
                return 279;
            else
            if (lng < 122.000443f)
                if (lat < 21.120611f)
                    return 279;
                else
                    return 125;
            else
                return 280;
        else
        if (lng < 129.147415f)
            if (lat < 8.397028f)
                if (lng < 127.323502f)
                    if (lat < 2.817055f)
                        if (lng < 125.467613f)
                            return 383;
                        else
                            return 131;
                    else
                    if (lat < 4.780778f)
                        return 383;
                    else
                        return 279;
                else
                    return 131;
            else
            if (lat < 12.690361f)
                return 279;
            else
                return 280;
        else
        if (lng < 163.034882f)
            if (lng < 145.852493f)
                if (lng < 144.953979f)
                    if (lat < 7.300587f)
                        if (lat < 1.072750f)
                            return 131;
                        else
                            return 187;
                    else
                    if (lng < 139.663284f)
                        if (lat < 8.092916f)
                            return 187;
                        else
                        if (lng < 131.193527f)
                            return 280;
                        else
                            return 216;
                    else
                    if (lat < 10.022223f)
                        return 216;
                    else
                    if (lng < 141.476913f)
                        return 280;
                    else
                    if (lat < 17.090556f)
                        return 106;
                    else
                        return 389;
                else
                    return 389;
            else
            if (lng < 153.821915f)
                if (lng < 146.081223f)
                    return 389;
                else
                    return 216;
            else
            if (lng < 158.336243f)
                if (lng < 153.985229f)
                    return 280;
                else
                    return 222;
            else
            if (lat < 6.857666f)
                if (lng < 160.718369f)
                    return 222;
                else
                    return 247;
            else
                return 18;
        else
        if (lng < 170.237549f)
            if (lng < 167.775497f)
                if (lng < 166.271835f)
                    return 18;
                else
                if (lng < 166.654526f)
                    return 135;
                else
                if (lng < 166.901505f)
                    return 18;
                else
                    return 292;
            else
                return 18;
        else
        if (lng < 172.137970f)
            return 18;
        else
            return 148;
    }

    private static int call49(float lat, float lng)
    {
        if (lat < 0.621778f)
            if (lng < 135.281830f)
                if (lng < 124.870331f)
                    if (lat < -14.905778f)
                        return 35;
                    else
                    if (lng < 118.159142f)
                        if (lat < -5.413084f)
                            if (lat < -7.231639f)
                                if (lng < 114.601669f)
                                    if (lat < -8.091222f)
                                        if (lng < 112.714195f)
                                            if (lng < 105.719582f)
                                                return 124;
                                            else
                                                return 26;
                                        else
                                        if (lng < 113.425163f)
                                            return 26;
                                        else
                                        {
                                            if (poly[2635].contains(lat,lng)) return 383;
                                            if (poly[2636].contains(lat,lng)) return 383;
                                            else return 26;
                                        }
                                    else
                                        return 26;
                                else
                                    return 383;
                            else
                                return 26;
                        else
                        if (lng < 108.029915f)
                            return 26;
                        else
                        if (lng < 115.817696f)
                            if (lng < 109.185059f)
                                if (lat < -2.501333f)
                                    return 26;
                                else
                                    return 320;
                            else
                            if (lng < 113.424698f)
                                return 320;
                            else
                            if (lat < -4.363333f)
                                return 383;
                            else
                            if (lng < 114.026596f)
                            {
                                if (poly[2637].contains(lat,lng)) return 383;
                                else return 320;
                            }
                            else
                            if (lat < -1.783340f)
                            {
                                if (poly[2638].contains(lat,lng)) return 320;
                                else return 383;
                            }
                            else
                            {
                                if (poly[2639].contains(lat,lng)) return 383;
                                if (poly[2640].contains(lat,lng)) return 383;
                                else return 320;
                            }
                        else
                            return 383;
                    else
                    if (lng < 124.036163f)
                        return 383;
                    else
                    if (lat < -8.119555f)
                        if (lat < -9.174916f)
                            if (lat < -14.858306f)
                                return 35;
                            else
                            {
                                if (poly[2641].contains(lat,lng)) return 345;
                                else return 383;
                            }
                        else
                            return 383;
                    else
                    if (lat < -5.320944f)
                        return 383;
                    else
                    if (lat < -1.961278f)
                        return 131;
                    else
                    if (lat < -1.628500f)
                        if (lng < 124.177025f)
                            return 383;
                        else
                            return 131;
                    else
                    if (lat < -0.611208f)
                        return 131;
                    else
                        return 383;
                else
                if (lat < -8.137417f)
                    if (lng < 128.731216f)
                        if (lat < -14.416805f)
                            if (lat < -31.300000f)
                            {
                                if (poly[2642].contains(lat,lng)) return 35;
                                else return 79;
                            }
                            else
                                return 35;
                        else
                        if (lat < -13.734889f)
                            return 35;
                        else
                        if (lng < 127.345337f)
                            if (lng < 125.165901f)
                                if (lat < -8.630452f)
                                    if (lat < -8.964142f)
                                        if (lat < -9.109211f)
                                        {
                                            if (poly[2643].contains(lat,lng)) return 345;
                                            else return 383;
                                        }
                                        else
                                        {
                                            if (poly[2644].contains(lat,lng)) return 383;
                                            else return 345;
                                        }
                                    else
                                        return 345;
                                else
                                    return 383;
                            else
                                return 345;
                        else
                            return 131;
                    else
                    if (lat < -11.953861f)
                        if (lat < -14.820723f)
                            if (lat < -32.235695f)
                                return 67;
                            else
                            if (lng < 129.259827f)
                                if (lat < -31.300000f)
                                {
                                    if (poly[2645].contains(lat,lng)) return 79;
                                    else return 67;
                                }
                                else
                                {
                                    if (poly[2646].contains(lat,lng)) return 35;
                                    if (poly[2647].contains(lat,lng)) return 67;
                                    else return 10;
                                }
                            else
                            if (lat < -25.998917f)
                            {
                                if (poly[2648].contains(lat,lng)) return 10;
                                else return 67;
                            }
                            else
                                return 10;
                        else
                            return 10;
                    else
                    if (lat < -10.902861f)
                        return 10;
                    else
                        return 131;
                else
                    return 131;
            else
                return call42(lat,lng);
        else
        if (lat < 25.382833f)
            return call48(lat,lng);
        else
        if (lng < 127.410225f)
            if (lat < 35.297001f)
                if (lat < 30.342751f)
                    if (lng < 121.602638f)
                        if (lng < 120.578110f)
                            if (lng < 119.899170f)
                                if (lng < 111.484301f)
                                    if (lng < 108.294469f)
                                        return 403;
                                    else
                                    if (lat < 27.862792f)
                                        if (lng < 109.889385f)
                                            if (lat < 26.622813f)
                                            {
                                                if (poly[2649].contains(lat,lng)) return 403;
                                                else return 291;
                                            }
                                            else
                                            {
                                                if (poly[2650].contains(lat,lng)) return 403;
                                                else return 291;
                                            }
                                        else
                                        {
                                            if (poly[2651].contains(lat,lng)) return 403;
                                            else return 291;
                                        }
                                    else
                                    if (lng < 109.889385f)
                                        if (lat < 29.102771f)
                                        {
                                            if (poly[2652].contains(lat,lng)) return 403;
                                            else return 291;
                                        }
                                        else
                                        {
                                            if (poly[2653].contains(lat,lng)) return 403;
                                            else return 291;
                                        }
                                    else
                                        return 291;
                                else
                                    return 291;
                            else
                            if (lat < 26.386000f)
                                if (lat < 26.279583f)
                                    return 125;
                                else
                                if (lng < 120.219345f)
                                    return 125;
                                else
                                    return 291;
                            else
                                return 291;
                        else
                            return 291;
                    else
                    if (lng < 123.510361f)
                        return 291;
                    else
                        return 280;
                else
                if (lng < 125.216530f)
                    if (lng < 121.895668f)
                        if (lng < 111.023788f)
                            if (lat < 33.487884f)
                                if (lng < 108.064213f)
                                    return 403;
                                else
                                if (lat < 31.915317f)
                                {
                                    if (poly[2654].contains(lat,lng)) return 403;
                                    else return 291;
                                }
                                else
                                if (lng < 109.544000f)
                                {
                                    if (poly[2655].contains(lat,lng)) return 291;
                                    if (poly[2656].contains(lat,lng)) return 291;
                                    else return 403;
                                }
                                else
                                if (lat < 32.701600f)
                                {
                                    if (poly[2657].contains(lat,lng)) return 403;
                                    if (poly[2658].contains(lat,lng)) return 403;
                                    else return 291;
                                }
                                else
                                {
                                    if (poly[2659].contains(lat,lng)) return 291;
                                    else return 403;
                                }
                            else
                            {
                                if (poly[2660].contains(lat,lng)) return 291;
                                else return 403;
                            }
                        else
                            return 291;
                    else
                    if (lng < 122.833557f)
                        return 291;
                    else
                        return 11;
                else
                    return 11;
            else
                return call45(lat,lng);
        else
        if (lat < 34.400917f)
            return 280;
        else
            return call47(lat,lng);
    }

    private static int call50(float lat, float lng)
    {
        if (lat < 52.898487f)
            if (lat < 20.373875f)
                if (lat < -25.156712f)
                    if (lat < -50.907104f)
                        if (lng < -72.437805f)
                            return 31;
                        else
                        if (lat < -54.523746f)
                            if (lng < -68.613205f)
                                return 31;
                            else
                            if (lat < -55.351746f)
                                if (lng < -66.772804f)
                                    return 31;
                                else
                                    return 69;
                            else
                            if (lat < -55.121574f)
                                return 31;
                            else
                            if (lng < -65.110054f)
                                if (lat < -54.922653f)
                                    if (lng < -67.035919f)
                                        return 31;
                                    else
                                    if (lng < -66.787865f)
                                        if (lat < -54.971360f)
                                            return 31;
                                        else
                                            return 287;
                                    else
                                        return 287;
                                else
                                if (lng < -68.253555f)
                                    if (lat < -54.907707f)
                                        return 31;
                                    else
                                    if (lng < -68.609608f)
                                    {
                                        if (poly[2661].contains(lat,lng)) return 287;
                                        else return 31;
                                    }
                                    else
                                        return 287;
                                else
                                if (lng < -67.756295f)
                                    if (lat < -54.893145f)
                                        return 31;
                                    else
                                        return 287;
                                else
                                if (lat < -54.916042f)
                                    if (lng < -67.298005f)
                                        return 31;
                                    else
                                        return 287;
                                else
                                    return 287;
                            else
                            if (lng < -63.806961f)
                                return 287;
                            else
                                return 69;
                        else
                        if (lng < -61.327831f)
                            if (lng < -72.023773f)
                                if (lat < -51.821801f)
                                    return 31;
                                else
                                if (lat < -51.569118f)
                                {
                                    if (poly[2662].contains(lat,lng)) return 85;
                                    else return 31;
                                }
                                else
                                {
                                    if (poly[2663].contains(lat,lng)) return 31;
                                    else return 85;
                                }
                            else
                            if (lng < -71.377541f)
                                if (lat < -52.638439f)
                                    return 31;
                                else
                                {
                                    if (poly[2664].contains(lat,lng)) return 85;
                                    else return 31;
                                }
                            else
                            if (lat < -53.978534f)
                                if (lng < -69.057579f)
                                    return 31;
                                else
                                {
                                    if (poly[2665].contains(lat,lng)) return 31;
                                    else return 287;
                                }
                            else
                            if (lat < -52.456120f)
                                if (lng < -69.544449f)
                                    return 31;
                                else
                                {
                                    if (poly[2666].contains(lat,lng)) return 31;
                                    else return 287;
                                }
                            else
                            if (lng < -68.368202f)
                            {
                                if (poly[2667].contains(lat,lng)) return 31;
                                else return 85;
                            }
                            else
                                return 82;
                        else
                        if (lng < -38.240654f)
                            return 82;
                        else
                            return 69;
                    else
                    if (lat < -44.969273f)
                        if (lng < -73.589836f)
                            return 31;
                        else
                        if (lat < -45.399536f)
                            if (lng < -73.585594f)
                                return 31;
                            else
                            if (lng < -73.533890f)
                                if (lat < -49.517205f)
                                    if (lat < -50.669666f)
                                        return 31;
                                    else
                                    if (lat < -50.072808f)
                                        if (lat < -50.156428f)
                                        {
                                            if (poly[2668].contains(lat,lng)) return 85;
                                            else return 31;
                                        }
                                        else
                                        {
                                            if (poly[2669].contains(lat,lng)) return 85;
                                            else return 31;
                                        }
                                    else
                                    if (lat < -49.912819f)
                                    {
                                        if (poly[2670].contains(lat,lng)) return 85;
                                        else return 31;
                                    }
                                    else
                                    {
                                        if (poly[2671].contains(lat,lng)) return 85;
                                        else return 31;
                                    }
                                else
                                    return 31;
                            else
                            if (lat < -49.584360f)
                                if (lat < -50.092410f)
                                    if (lng < -72.230858f)
                                        if (lat < -50.855255f)
                                        {
                                            if (poly[2672].contains(lat,lng)) return 85;
                                            else return 31;
                                        }
                                        else
                                        if (lat < -50.312183f)
                                        {
                                            if (poly[2673].contains(lat,lng)) return 85;
                                            else return 31;
                                        }
                                        else
                                        {
                                            if (poly[2674].contains(lat,lng)) return 31;
                                            else return 85;
                                        }
                                    else
                                        return 85;
                                else
                                if (lat < -49.953084f)
                                    if (lng < -73.497192f)
                                        if (lat < -50.047192f)
                                        {
                                            if (poly[2675].contains(lat,lng)) return 31;
                                            else return 85;
                                        }
                                        else
                                        {
                                            if (poly[2676].contains(lat,lng)) return 85;
                                            else return 31;
                                        }
                                    else
                                        return 85;
                                else
                                {
                                    if (poly[2677].contains(lat,lng)) return 31;
                                    else return 85;
                                }
                            else
                            if (lng < -67.100245f)
                                if (lng < -72.887050f)
                                    if (lat < -48.943169f)
                                    {
                                        if (poly[2678].contains(lat,lng)) return 31;
                                        else return 85;
                                    }
                                    else
                                        return 31;
                                else
                                if (lng < -69.993648f)
                                    if (lat < -47.491948f)
                                    {
                                        if (poly[2679].contains(lat,lng)) return 31;
                                        else return 85;
                                    }
                                    else
                                    {
                                        if (poly[2680].contains(lat,lng)) return 85;
                                        if (poly[2681].contains(lat,lng)) return 88;
                                        else return 31;
                                    }
                                else
                                {
                                    if (poly[2682].contains(lat,lng)) return 88;
                                    else return 85;
                                }
                            else
                                return 85;
                        else
                        if (lng < -73.093870f)
                            return 31;
                        else
                        if (lng < -71.297264f)
                        {
                            if (poly[2683].contains(lat,lng)) return 88;
                            else return 31;
                        }
                        else
                            return 88;
                    else
                    if (lat < -43.470894f)
                        if (lng < -73.787636f)
                            if (lng < -75.012062f)
                                if (lng < -176.153000f)
                                    return 59;
                                else
                                    return 31;
                            else
                                return 31;
                        else
                        if (lng < -72.847519f)
                            return 31;
                        else
                        if (lng < -72.698524f)
                            return 31;
                        else
                        if (lng < -71.110161f)
                            if (lat < -44.523029f)
                            {
                                if (poly[2684].contains(lat,lng)) return 88;
                                else return 31;
                            }
                            else
                            {
                                if (poly[2685].contains(lat,lng)) return 88;
                                else return 31;
                            }
                        else
                            return 88;
                    else
                    if (lng < -72.622307f)
                        if (lng < -80.716499f)
                            if (lng < -177.880646f)
                                return 377;
                            else
                            if (lng < -144.296722f)
                                return 312;
                            else
                            if (lat < -30.451663f)
                                return 31;
                            else
                                return 263;
                        else
                            return 31;
                    else
                        return call0(lat,lng);
                else
                    return call6(lat,lng);
            else
                return call13(lat,lng);
        else
        if (lng < -74.961365f)
            if (lng < -106.448578f)
                if (lat < 60.611965f)
                    if (lng < -134.793625f)
                        if (lng < -152.081146f)
                            if (lng < -162.000000f)
                                if (lng < -169.662872f)
                                    if (lat < 53.077026f)
                                        return 158;
                                    else
                                        return 134;
                                else
                                    return 134;
                            else
                                return 370;
                        else
                        if (lng < -141.000000f)
                            return 370;
                        else
                        if (lat < 57.727699f)
                            return 23;
                        else
                        if (lat < 58.559212f)
                            if (lat < 58.010578f)
                                if (lat < 57.768707f)
                                    return 23;
                                else
                                if (lng < -135.902527f)
                                {
                                    if (poly[2686].contains(lat,lng)) return 359;
                                    if (poly[2687].contains(lat,lng)) return 359;
                                    else return 23;
                                }
                                else
                                {
                                    if (poly[2688].contains(lat,lng)) return 23;
                                    else return 359;
                                }
                            else
                                return 359;
                        else
                        if (lat < 58.786423f)
                            return 359;
                        else
                        if (lng < -139.228378f)
                            if (lat < 59.995773f)
                                return 98;
                            else
                            {
                                if (poly[2689].contains(lat,lng)) return 324;
                                else return 98;
                            }
                        else
                        if (lng < -136.475357f)
                            if (lat < 58.897247f)
                                if (lng < -137.563436f)
                                {
                                    if (poly[2690].contains(lat,lng)) return 98;
                                    else return 359;
                                }
                                else
                                    return 359;
                            else
                            if (lat < 60.000000f)
                                if (lng < -137.492722f)
                                    if (lat < 58.990978f)
                                    {
                                        if (poly[2691].contains(lat,lng)) return 45;
                                        if (poly[2692].contains(lat,lng)) return 359;
                                        else return 98;
                                    }
                                    else
                                    {
                                        if (poly[2693].contains(lat,lng)) return 45;
                                        else return 98;
                                    }
                                else
                                if (lat < 58.904221f)
                                    return 359;
                                else
                                {
                                    if (poly[2694].contains(lat,lng)) return 45;
                                    else return 359;
                                }
                            else
                            {
                                if (poly[2695].contains(lat,lng)) return 98;
                                else return 324;
                            }
                        else
                        if (lat < 59.019775f)
                            return 359;
                        else
                        if (lat < 60.000000f)
                        {
                            if (poly[2696].contains(lat,lng)) return 45;
                            else return 359;
                        }
                        else
                            return 324;
                    else
                        return call14(lat,lng);
                else
                    return call15(lat,lng);
            else
                return call17(lat,lng);
        else
            return call19(lat,lng);
    }

    private static class TzPolygon {

        float[] pts;

        TzPolygon(float ... D)
        {
            pts = D;
        }

        public boolean contains(float testy, float testx)
        {
            boolean inside = false;
            int n = pts.length;
            float yj = pts[n-2];
            float xj = pts[n-1];
            for (int i = 0; i < n; ) {
                float yi = pts[i++];
                float xi = pts[i++];
                if ( ((yi>testy) != (yj>testy)) && (testx < (xj-xi) * (testy-yi) / (yj-yi) + xi - 0.0001f))
                    inside = !inside;
                xj = xi;
                yj = yi;
            }
            return inside;
        }
    }


    private static TzPolygon[] poly = initPolyArray();


    private static class Initializer1 {
        private static void init() {
            poly[0] = new TzPolygon(45.286988f,7.123472f, 45.265778f,7.128861f, 45.262008f,7.123472f);
            poly[1] = new TzPolygon(45.409389f,7.123472f, 45.409389f,7.181056f, 45.349019f,7.123472f);
            poly[2] = new TzPolygon(45.446903f,7.123472f, 45.409389f,7.181056f, 45.409389f,7.123472f);
            poly[3] = new TzPolygon(46.464279f,7.123472f, 46.464279f,8.721278f, 46.108948f,8.721278f, 46.108055f,8.691222f, 46.129612f,8.615611f,
                    46.221638f,8.531472f, 46.259472f,8.451583f, 46.305054f,8.433583f, 46.409500f,8.467334f, 46.463860f,8.442945f,
                    46.427696f,8.302722f, 46.379833f,8.311055f, 46.308498f,8.199361f, 46.301334f,8.122806f, 46.267223f,8.086000f,
                    46.191582f,8.164500f, 46.152832f,8.152667f, 46.094082f,8.030084f, 46.004082f,7.985667f, 45.999111f,7.894000f,
                    45.934502f,7.859250f, 45.938389f,7.712695f, 45.981415f,7.663833f, 45.999748f,7.563528f, 45.907585f,7.381972f,
                    45.926250f,7.292500f, 45.895195f,7.211611f, 45.867001f,7.197139f, 45.887417f,7.156389f, 45.874849f,7.123472f);
            poly[4] = new TzPolygon(47.805332f,7.922375f, 47.566630f,7.922375f, 47.588112f,7.901639f, 47.589195f,7.827055f, 47.560890f,7.793639f,
                    47.538723f,7.685500f, 47.559029f,7.637222f, 47.581306f,7.671028f, 47.612473f,7.665389f, 47.582390f,7.580917f,
                    47.700500f,7.512195f, 47.726944f,7.542333f, 47.805332f,7.550589f);
            poly[5] = new TzPolygon(47.805332f,7.123472f, 47.805332f,7.550589f, 47.726944f,7.542333f, 47.700500f,7.512195f, 47.582390f,7.580917f,
                    47.585388f,7.550861f, 47.539307f,7.499833f, 47.491501f,7.499222f, 47.501362f,7.431111f, 47.486279f,7.416945f,
                    47.473000f,7.446139f, 47.437611f,7.387833f, 47.424973f,7.254583f, 47.448277f,7.174778f, 47.492195f,7.189556f,
                    47.495409f,7.123472f);
            poly[6] = new TzPolygon(47.714832f,8.695945f, 47.693474f,8.721278f, 47.688194f,8.670167f, 47.689529f,8.668139f);
            poly[7] = new TzPolygon(47.756784f,8.721278f, 47.754971f,8.687612f, 47.796028f,8.650222f, 47.764637f,8.635028f, 47.805168f,8.595250f,
                    47.757751f,8.476389f, 47.675415f,8.413445f, 47.639137f,8.479527f, 47.675251f,8.598139f, 47.650806f,8.625527f,
                    47.649387f,8.600278f, 47.600113f,8.595750f, 47.636890f,8.523500f, 47.597832f,8.461139f, 47.583000f,8.490250f,
                    47.572472f,8.356916f, 47.612946f,8.295278f, 47.626835f,8.211223f, 47.563332f,8.093805f, 47.548832f,7.939556f,
                    47.566630f,7.922375f, 47.805332f,7.922375f, 47.805332f,8.721278f);
            poly[8] = new TzPolygon(49.144871f,7.123472f, 49.123917f,7.155222f, 49.115360f,7.298194f, 49.170807f,7.372111f, 49.182751f,7.448805f,
                    49.163582f,7.444389f, 49.152222f,7.510334f, 49.141109f,7.494195f, 49.095833f,7.540139f, 49.054001f,7.646806f,
                    49.047638f,7.760528f, 49.066696f,7.803250f, 49.036640f,7.866833f, 49.057194f,7.940528f, 48.986778f,8.115723f,
                    48.969334f,8.235500f, 48.907307f,8.150306f, 48.804974f,8.090250f, 48.760555f,7.972139f, 48.717777f,7.956000f,
                    48.641666f,7.840361f, 48.394806f,7.734028f, 48.327557f,7.746833f, 48.299889f,7.695083f, 48.219944f,7.669139f,
                    48.121029f,7.581028f, 48.038445f,7.569167f, 47.969139f,7.618000f, 47.885723f,7.559055f, 47.805332f,7.550589f,
                    47.805332f,7.123472f);
            poly[9] = new TzPolygon(53.259864f,7.123472f, 53.238529f,7.213278f, 53.185722f,7.227944f, 53.137859f,7.183889f, 53.004971f,7.216583f,
                    52.892070f,7.123472f);
            poly[10] = new TzPolygon(46.108948f,8.721278f, 46.111500f,8.807195f, 46.092999f,8.832945f, 46.068748f,8.856277f, 46.005028f,8.792139f,
                    45.963028f,8.893611f, 45.873665f,8.939000f, 45.843693f,8.913972f, 45.825863f,9.016444f, 45.906250f,9.083944f,
                    45.934891f,9.019639f, 45.981777f,8.993305f, 46.001526f,9.022111f, 46.045502f,9.011611f, 46.072945f,9.076000f,
                    46.124222f,9.076805f, 46.182835f,9.188972f, 46.245472f,9.242888f, 46.328388f,9.292306f, 46.437721f,9.246417f,
                    46.502499f,9.294611f, 46.508472f,9.357333f, 46.466721f,9.411250f, 46.503971f,9.459139f, 46.375778f,9.467861f,
                    46.311138f,9.543667f, 46.306029f,9.606375f, 45.502335f,9.606375f, 45.502335f,8.721278f);
            poly[11] = new TzPolygon(46.306029f,9.606375f, 46.297638f,9.709361f, 46.353638f,9.742972f, 46.338696f,9.777000f, 46.382584f,9.949083f,
                    46.350277f,9.992695f, 46.296276f,9.991472f, 46.266640f,10.050750f, 46.232693f,10.042833f, 46.230972f,10.133472f,
                    46.264694f,10.171473f, 46.342361f,10.105445f, 46.400471f,10.160583f, 46.430695f,10.136250f, 46.424057f,10.081139f,
                    46.447498f,10.043333f, 46.538834f,10.051194f, 46.604221f,10.103027f, 46.635223f,10.233528f, 46.585194f,10.240973f,
                    46.548584f,10.303500f, 46.541500f,10.457000f, 46.612999f,10.486000f, 46.640472f,10.445528f, 46.640862f,10.395083f,
                    46.682388f,10.377944f, 46.716000f,10.417361f, 46.733028f,10.399195f, 46.754555f,10.442139f, 46.788055f,10.424111f,
                    46.861889f,10.470056f, 46.856237f,10.491472f, 45.502335f,10.491472f, 45.502335f,9.606375f);
            poly[12] = new TzPolygon(46.851898f,10.491472f, 46.852196f,10.489583f, 46.886833f,10.465528f, 46.939667f,10.491472f);
            poly[13] = new TzPolygon(46.939667f,9.878274f, 46.939667f,10.305821f, 46.922359f,10.293000f, 46.930721f,10.249833f, 46.872501f,10.227750f,
                    46.847305f,10.104584f, 46.897804f,10.022305f);
            poly[14] = new TzPolygon(47.533651f,9.606375f, 47.658749f,9.275666f, 47.686165f,9.046805f, 47.655640f,8.895166f, 47.693054f,8.855778f,
                    47.704887f,8.877277f, 47.734222f,8.808389f, 47.714554f,8.770972f, 47.698082f,8.806500f, 47.679390f,8.795667f,
                    47.696724f,8.735194f, 47.757446f,8.733583f, 47.756784f,8.721278f, 48.519716f,8.721278f, 48.519716f,9.606375f);
            poly[15] = new TzPolygon(47.145256f,9.606375f, 47.080902f,9.606375f, 47.055862f,9.569111f, 47.065334f,9.477805f, 47.099472f,9.523833f,
                    47.192139f,9.492888f, 47.273529f,9.535916f);
            poly[16] = new TzPolygon(47.061235f,9.606375f, 47.061554f,9.603666f, 47.069583f,9.606375f);
            poly[17] = new TzPolygon(47.146409f,9.606375f, 47.176777f,9.569445f, 47.210751f,9.579889f, 47.273529f,9.535916f, 47.352061f,9.606375f);
            poly[18] = new TzPolygon(47.470257f,9.606375f, 47.474804f,9.592778f, 47.542557f,9.544333f, 47.539926f,9.606375f);
            poly[19] = new TzPolygon(47.533651f,9.606375f, 48.519716f,9.606375f, 48.519716f,10.491472f, 47.546736f,10.491472f, 47.561138f,10.456750f,
                    47.588638f,10.473972f, 47.588501f,10.444612f, 47.505722f,10.429472f, 47.439026f,10.474055f, 47.314140f,10.333805f,
                    47.275776f,10.177584f, 47.382915f,10.233277f, 47.396057f,10.185972f, 47.371861f,10.161834f, 47.364498f,10.097083f,
                    47.415417f,10.068528f, 47.454945f,10.095056f, 47.496555f,9.992861f, 47.550026f,9.970166f, 47.534443f,9.871000f,
                    47.548973f,9.819417f, 47.584167f,9.819250f, 47.593418f,9.786972f, 47.534557f,9.732972f, 47.525555f,9.627778f);
            poly[20] = new TzPolygon(47.145256f,9.606375f, 47.098251f,9.632195f, 47.080902f,9.606375f);
            poly[21] = new TzPolygon(47.471485f,9.606375f, 47.461140f,9.648750f, 47.387695f,9.672861f, 47.372581f,9.624250f, 47.350840f,9.606375f);
            poly[22] = new TzPolygon(47.060194f,9.606375f, 47.060974f,9.667306f, 47.015720f,9.832861f, 47.025082f,9.874416f, 46.940723f,9.874639f,
                    46.939667f,9.878274f, 46.939667f,9.606375f);
            poly[23] = new TzPolygon(46.939667f,10.305821f, 46.986443f,10.340472f, 47.002056f,10.388000f, 46.939667f,10.491472f);
            poly[24] = new TzPolygon(46.601366f,12.963583f, 46.606472f,12.855389f, 46.646000f,12.795167f, 46.656776f,12.565722f, 46.691917f,12.436028f,
                    46.780445f,12.347889f, 46.794582f,12.281305f, 46.841888f,12.307917f, 46.890251f,12.273250f, 46.879112f,12.216028f,
                    46.915833f,12.149028f, 46.942696f,12.164194f, 47.007973f,12.121611f, 47.068695f,12.233027f, 47.095196f,12.184028f,
                    47.095196f,12.963583f);
            poly[25] = new TzPolygon(47.095196f,12.184028f, 47.055054f,11.973333f, 46.977139f,11.750139f, 47.015472f,11.620277f, 46.990417f,11.537250f,
                    47.016693f,11.473611f, 46.972527f,11.409917f, 46.995804f,11.324862f, 46.966499f,11.161555f, 46.938389f,11.148861f,
                    46.932220f,11.105833f, 46.828415f,11.072583f, 46.770306f,11.014778f, 46.767387f,10.876722f, 46.793777f,10.732862f,
                    46.831112f,10.757222f, 46.873554f,10.665639f, 46.841557f,10.557000f, 46.851898f,10.491472f, 47.095196f,10.491472f);
            poly[26] = new TzPolygon(47.095196f,12.963583f, 47.095196f,10.491472f, 47.546736f,10.491472f, 47.538361f,10.511666f, 47.537693f,10.568000f,
                    47.568943f,10.607472f, 47.562611f,10.683444f, 47.519749f,10.780889f, 47.533722f,10.901167f, 47.519806f,10.915389f,
                    47.494583f,10.866278f, 47.484196f,10.932694f, 47.401554f,10.987166f, 47.402527f,11.113305f, 47.439278f,11.202167f,
                    47.433304f,11.247583f, 47.404083f,11.226334f, 47.404251f,11.264028f, 47.456444f,11.340222f, 47.449417f,11.425722f,
                    47.480804f,11.383778f, 47.522472f,11.438916f, 47.512695f,11.504250f, 47.531361f,11.588333f, 47.592224f,11.615500f,
                    47.586304f,11.838528f, 47.618500f,11.913584f, 47.609749f,12.135639f, 47.625446f,12.205973f, 47.701889f,12.165277f,
                    47.744141f,12.253805f, 47.682693f,12.255278f, 47.699665f,12.429806f, 47.626915f,12.500417f, 47.636112f,12.573611f,
                    47.678055f,12.617972f, 47.673916f,12.778778f, 47.636028f,12.776305f, 47.611195f,12.821861f, 47.571529f,12.782528f,
                    47.493036f,12.963583f);
            poly[27] = new TzPolygon(47.713136f,12.963583f, 47.712418f,12.930833f, 47.729946f,12.908083f, 47.794126f,12.963583f);
            poly[28] = new TzPolygon(47.915885f,12.963583f, 47.947388f,12.940416f, 47.966667f,12.876945f, 48.017834f,12.855722f, 48.073029f,12.760167f,
                    48.128807f,12.761833f, 48.121777f,12.785889f, 48.198666f,12.866111f, 48.211666f,12.957389f, 48.216392f,12.963583f);
            poly[29] = new TzPolygon(49.336297f,12.963583f, 49.343777f,12.948916f, 49.351639f,12.884750f, 49.330112f,12.880250f, 49.345390f,12.784083f,
                    49.398666f,12.756389f, 49.433556f,12.660334f, 49.521751f,12.643750f, 49.540638f,12.589084f, 49.621639f,12.560528f,
                    49.632721f,12.523111f, 49.689919f,12.521167f, 49.705696f,12.449306f, 49.754528f,12.403167f, 49.789471f,12.469528f,
                    49.844582f,12.476806f, 49.923084f,12.547916f, 49.939919f,12.477972f, 49.978554f,12.493611f, 49.998001f,12.467195f,
                    49.988724f,12.437305f, 50.055557f,12.322639f, 50.063446f,12.263833f, 50.081833f,12.272000f, 50.109028f,12.211445f,
                    50.199139f,12.196472f, 50.249001f,12.096194f, 50.276360f,12.143194f, 50.315224f,12.116167f, 50.320889f,12.191167f,
                    50.270222f,12.210694f, 50.268806f,12.259833f, 50.247749f,12.244528f, 50.172085f,12.325611f, 50.232918f,12.333805f,
                    50.236862f,12.361055f, 50.322029f,12.405444f, 50.349140f,12.492416f, 50.390472f,12.509973f, 50.416000f,12.675777f,
                    50.397167f,12.707444f, 50.457863f,12.823472f, 50.407276f,12.942056f, 50.412607f,12.963583f);
            poly[30] = new TzPolygon(54.913971f,8.817778f, 54.896584f,8.754945f, 54.910000f,8.651444f, 54.913971f,8.653168f);
            poly[31] = new TzPolygon(54.913971f,8.817778f, 54.913971f,9.604082f, 54.878807f,9.562195f, 54.800499f,9.289611f, 54.872723f,9.154583f,
                    54.903721f,8.917167f, 54.893444f,8.848611f);
            poly[32] = new TzPolygon(54.874170f,9.604082f, 54.879002f,9.614417f, 54.833168f,9.610139f, 54.802927f,9.782444f, 54.760555f,9.782444f,
                    54.760555f,9.604082f);
            poly[33] = new TzPolygon(56.083153f,12.635111f, 56.120609f,12.590860f, 56.120609f,12.635111f);
            poly[34] = new TzPolygon(57.039259f,24.020306f, 57.111416f,24.194750f, 57.254028f,24.408972f, 57.619946f,24.382694f, 57.700474f,24.340889f,
                    57.752777f,24.344305f, 57.758110f,24.435444f, 57.768028f,24.344528f, 57.878139f,24.356222f, 57.880360f,24.457445f,
                    57.916416f,24.465221f, 57.959389f,24.591499f, 57.942249f,24.630917f, 57.961834f,24.673471f, 57.950474f,24.700806f,
                    57.984749f,24.772751f, 58.008335f,25.002916f, 58.082306f,25.129805f, 58.077084f,25.202612f, 57.994305f,25.270000f,
                    57.999943f,25.301695f, 58.058498f,25.265306f, 58.077610f,25.293861f, 58.013500f,25.447805f, 57.981167f,25.462584f,
                    57.970585f,25.568640f, 57.903057f,25.678862f, 57.920887f,25.749945f, 57.861916f,25.859056f, 57.848526f,26.049917f,
                    57.779556f,26.021360f, 57.730000f,26.185167f, 57.699585f,26.179777f, 57.603222f,26.276861f, 57.577836f,26.417649f,
                    56.900307f,26.417649f, 56.900307f,24.020306f);
            poly[35] = new TzPolygon(57.577836f,26.417649f, 58.776028f,26.417649f, 58.776028f,27.519501f, 58.648224f,27.476723f, 58.380474f,27.437056f,
                    58.291695f,27.506945f, 58.218498f,27.490667f, 58.079193f,27.614889f, 58.005665f,27.625334f, 58.001999f,27.695360f,
                    57.930222f,27.698584f, 57.909584f,27.806444f, 57.858501f,27.826889f, 57.829361f,27.778999f, 57.839222f,27.642471f,
                    57.820332f,27.542555f, 57.792557f,27.501305f, 57.708637f,27.531027f, 57.712555f,27.445084f, 57.680721f,27.393778f,
                    57.622002f,27.400749f, 57.548389f,27.322111f, 57.552639f,27.155890f, 57.641277f,26.909416f, 57.524582f,26.619583f,
                    57.516193f,26.522388f, 57.527943f,26.483639f, 57.567360f,26.475750f);
            poly[36] = new TzPolygon(57.577836f,26.417649f, 57.567360f,26.475750f, 57.520054f,26.504723f, 57.524582f,26.619583f, 57.641277f,26.909416f,
                    57.544167f,27.206388f, 57.538860f,27.551195f, 57.503277f,27.564833f, 57.446918f,27.513584f, 57.316582f,27.839445f,
                    57.267029f,27.866806f, 57.159668f,27.821472f, 57.092972f,27.722584f, 57.082111f,27.752251f, 57.012638f,27.717388f,
                    56.976891f,27.739277f, 56.930500f,27.723223f, 56.911057f,27.671888f, 56.900307f,27.671157f, 56.900307f,26.417649f);
            poly[37] = new TzPolygon(-43.470894f,-71.889591f, -43.456951f,-71.933052f, -43.327740f,-71.891357f, -43.332661f,-71.833000f, -43.302025f,-71.775009f,
                    -43.317333f,-71.733917f, -43.211407f,-71.728859f, -43.171421f,-71.739624f, -43.085655f,-71.978706f, -43.036518f,-71.982841f,
                    -42.928730f,-72.102921f, -42.599533f,-72.133530f, -42.562008f,-72.119308f, -42.493511f,-72.028831f, -42.427280f,-72.067886f,
                    -42.377510f,-72.049866f, -42.306767f,-72.124931f, -42.209049f,-72.044983f, -42.166801f,-72.053986f, -42.141361f,-72.028374f,
                    -42.142429f,-71.972145f, -42.187328f,-71.919235f, -42.147926f,-71.776848f, -42.115387f,-71.728493f, -42.048092f,-71.727028f,
                    -41.999722f,-71.764091f, -41.999619f,-70.680565f, -43.470894f,-70.680565f);
            poly[38] = new TzPolygon(-42.001180f,-70.680565f, -41.999722f,-71.764091f, -41.821041f,-71.746162f, -41.700172f,-71.797539f, -41.707321f,-71.826065f,
                    -41.698986f,-71.828540f, -41.698986f,-70.680565f);
            poly[39] = new TzPolygon(-41.698986f,-70.680565f, -41.698986f,-71.828540f, -41.608391f,-71.855446f, -41.571144f,-71.818878f, -41.526917f,-71.853409f,
                    -41.392300f,-71.873077f, -41.360573f,-71.906403f, -41.256382f,-71.842438f, -41.171337f,-71.878563f, -41.166840f,-71.842873f,
                    -41.060879f,-71.828125f, -40.978477f,-71.893906f, -40.955868f,-71.852715f, -40.913105f,-71.858017f, -40.739685f,-71.946686f,
                    -40.633114f,-71.832756f, -40.558140f,-71.882629f, -40.560432f,-71.849785f, -40.411640f,-71.804535f, -40.438099f,-71.719292f,
                    -40.368649f,-71.654076f, -40.300026f,-71.681313f, -40.281357f,-71.712799f, -40.307129f,-71.749199f, -40.226128f,-71.829582f,
                    -40.192368f,-71.800186f, -40.105774f,-71.796974f, -40.097439f,-71.819710f, -40.078152f,-71.788536f, -40.113312f,-71.709877f,
                    -40.104076f,-71.671257f, -40.025879f,-71.684151f, -39.962700f,-71.614227f, -39.927078f,-71.599617f, -39.927078f,-70.680565f);
            poly[40] = new TzPolygon(-38.155170f,-72.442055f, -38.155170f,-71.025413f, -38.167625f,-71.015755f, -38.250286f,-71.035599f, -38.410442f,-71.002281f,
                    -38.567341f,-70.831734f, -38.745373f,-70.947517f, -38.757347f,-70.992783f, -38.740444f,-71.054352f, -38.813438f,-71.195541f,
                    -38.805851f,-71.241272f, -38.851460f,-71.267303f, -38.929832f,-71.427811f, -39.005672f,-71.411751f, -39.042549f,-71.437424f,
                    -39.284485f,-71.386276f, -39.401779f,-71.472343f, -39.431507f,-71.447548f, -39.483807f,-71.466743f, -39.521984f,-71.533089f,
                    -39.590187f,-71.481026f, -39.625069f,-71.500961f, -39.626595f,-71.605667f, -39.571484f,-71.688187f, -39.629517f,-71.716339f,
                    -39.682594f,-71.681061f, -39.722256f,-71.712509f, -39.757286f,-71.687279f, -39.841202f,-71.689354f, -39.855965f,-71.634659f,
                    -39.903233f,-71.589836f, -39.927078f,-71.599617f, -39.927078f,-72.442055f);
            poly[41] = new TzPolygon(-38.155170f,-71.025413f, -38.133102f,-71.042526f, -38.094086f,-70.998756f, -37.952782f,-71.107101f, -37.893749f,-71.124535f,
                    -37.863625f,-71.190865f, -37.818851f,-71.136330f, -37.672318f,-71.202454f, -37.612202f,-71.177078f, -37.581303f,-71.129410f,
                    -37.522083f,-71.149300f, -37.471928f,-71.116196f, -37.297554f,-71.212784f, -37.207165f,-71.143250f, -37.138622f,-71.142204f,
                    -37.103165f,-71.091873f, -37.076408f,-71.132156f, -37.000141f,-71.155792f, -36.974865f,-71.202599f, -36.973377f,-71.122025f,
                    -36.949608f,-71.101776f, -36.906101f,-71.142433f, -36.861149f,-71.127968f, -36.846474f,-71.172104f, -36.792564f,-71.128929f,
                    -36.659355f,-71.111885f, -36.695141f,-71.065758f, -36.663647f,-71.024376f, -36.598354f,-71.050797f, -36.464882f,-71.034485f,
                    -36.473179f,-70.935638f, -36.441948f,-70.888184f, -36.383263f,-70.886147f, -36.411602f,-70.788902f, -36.397156f,-70.770485f,
                    -36.407036f,-70.693840f, -36.384747f,-70.680565f, -38.155170f,-70.680565f);
            poly[42] = new TzPolygon(-36.366585f,-70.680565f, -36.325909f,-70.707695f, -36.254688f,-70.698784f, -36.247081f,-70.680565f);
            poly[43] = new TzPolygon(-41.999619f,-70.680565f, -41.999168f,-65.932785f, -42.008728f,-65.070793f, -42.072571f,-65.033895f, -42.072571f,-70.680565f);
            poly[44] = new TzPolygon(-41.001305f,-62.790363f, -40.802780f,-63.010559f, -40.747505f,-63.126114f, -40.706589f,-63.386971f, -40.237473f,-63.387245f,
                    -40.237473f,-62.790363f);
            poly[45] = new TzPolygon(-37.183099f,-69.174179f, -37.153336f,-69.256119f, -37.171394f,-69.545288f, -37.152779f,-69.631958f, -37.084724f,-69.745834f,
                    -37.003334f,-69.813065f, -36.949173f,-69.785568f, -36.849884f,-69.792053f, -36.784447f,-69.921951f, -36.707504f,-69.951126f,
                    -36.611389f,-70.066681f, -36.581947f,-70.163620f, -36.505836f,-70.218613f, -36.367500f,-70.263336f, -36.359451f,-70.301392f,
                    -36.381111f,-70.327515f, -36.350281f,-70.368057f, -36.290001f,-70.386398f, -36.200279f,-70.358063f, -36.138023f,-70.418030f,
                    -36.096098f,-70.399459f, -36.096098f,-69.174179f);
            poly[46] = new TzPolygon(-36.096098f,-70.680565f, -36.096098f,-70.399297f, -36.145332f,-70.419083f, -36.171188f,-70.471458f, -36.129711f,-70.577065f,
                    -36.167786f,-70.576836f, -36.226131f,-70.630394f, -36.247081f,-70.680565f);
            poly[47] = new TzPolygon(-36.366585f,-70.680565f, -36.375153f,-70.674850f, -36.384747f,-70.680565f);
            poly[48] = new TzPolygon(-34.025411f,-70.680565f, -34.025411f,-69.841841f, -34.125786f,-69.875671f, -34.167137f,-69.825378f, -34.223640f,-69.815414f,
                    -34.296738f,-69.914169f, -34.252579f,-69.975922f, -34.287010f,-70.042183f, -34.401867f,-70.011452f, -34.495041f,-70.134331f,
                    -34.621174f,-70.222404f, -34.678017f,-70.226387f, -34.749275f,-70.314674f, -34.804314f,-70.262299f, -35.030876f,-70.369507f,
                    -35.142410f,-70.362633f, -35.195705f,-70.425606f, -35.205906f,-70.548340f, -35.257881f,-70.577652f, -35.306469f,-70.539284f,
                    -35.343430f,-70.424332f, -35.433372f,-70.444366f, -35.514420f,-70.388901f, -35.648022f,-70.401405f, -35.810650f,-70.325722f,
                    -35.909981f,-70.422516f, -35.923218f,-70.381287f, -35.962223f,-70.403809f, -36.027435f,-70.371704f, -36.096098f,-70.399297f,
                    -36.096098f,-70.680565f);
            poly[49] = new TzPolygon(-32.990067f,-70.680565f, -32.990067f,-70.031167f, -33.012909f,-70.039894f, -33.041874f,-70.092903f, -33.313690f,-70.024612f,
                    -33.321411f,-69.963577f, -33.222149f,-69.888115f, -33.318905f,-69.788696f, -33.407787f,-69.747169f, -33.447872f,-69.753403f,
                    -33.484676f,-69.825226f, -33.547287f,-69.864746f, -33.679909f,-69.884850f, -33.756844f,-69.858528f, -33.828667f,-69.889763f,
                    -33.941135f,-69.865845f, -33.989922f,-69.829880f, -34.025411f,-69.841841f, -34.025411f,-70.680565f);
            poly[50] = new TzPolygon(-31.954723f,-70.216194f, -31.970144f,-70.202438f, -32.043724f,-70.277557f, -32.052250f,-70.321716f, -32.032398f,-70.363106f,
                    -32.050953f,-70.385635f, -32.144966f,-70.298927f, -32.266853f,-70.317635f, -32.331802f,-70.224098f, -32.432499f,-70.233589f,
                    -32.483860f,-70.141541f, -32.565273f,-70.129402f, -32.612610f,-70.169365f, -32.731236f,-70.145699f, -32.863895f,-70.050758f,
                    -32.901600f,-69.997368f, -32.990067f,-70.031167f, -32.990067f,-70.680565f, -31.954723f,-70.680565f);
            poly[51] = new TzPolygon(-31.954723f,-69.174179f, -31.997501f,-69.250565f, -32.058617f,-69.299179f, -32.051117f,-69.442230f, -32.122780f,-69.613068f,
                    -32.234169f,-69.631393f, -32.261116f,-69.665558f, -32.269730f,-69.830292f, -32.305557f,-69.967224f, -32.279724f,-70.091400f,
                    -32.309845f,-70.244370f, -32.260864f,-70.321068f, -32.144966f,-70.298927f, -32.050953f,-70.385635f, -32.032398f,-70.363106f,
                    -32.052250f,-70.321716f, -32.043724f,-70.277557f, -31.982347f,-70.204987f, -31.956961f,-70.206642f, -31.954723f,-70.209130f);
            poly[52] = new TzPolygon(-36.096098f,-69.174179f, -36.096098f,-68.292576f, -36.163063f,-68.294724f, -36.162781f,-68.247787f, -37.565407f,-68.249481f,
                    -37.542229f,-68.431122f, -37.445007f,-68.512512f, -37.426949f,-68.693619f, -37.370560f,-68.763062f, -37.387779f,-68.865845f,
                    -37.359726f,-68.996124f, -37.331673f,-69.031403f, -37.217506f,-69.079453f, -37.183099f,-69.174179f);
            poly[53] = new TzPolygon(-36.096098f,-68.292576f, -35.998894f,-68.289459f, -36.000811f,-66.501678f, -36.096098f,-66.501678f);
            poly[54] = new TzPolygon(-36.000275f,-66.501678f, -36.000107f,-66.617294f, -35.976112f,-66.633896f, -35.359169f,-66.506958f, -35.128059f,-66.507782f,
                    -35.000557f,-66.549179f, -34.939728f,-66.540009f, -34.805283f,-66.595001f, -34.605560f,-66.743347f, -34.434448f,-66.775284f,
                    -34.390007f,-66.811401f, -34.280281f,-66.803345f, -34.239449f,-66.824722f, -34.193611f,-66.798889f, -34.188896f,-66.755569f,
                    -34.081673f,-66.743896f, -34.025411f,-66.760274f, -34.025411f,-66.501678f);
            poly[55] = new TzPolygon(-34.025411f,-66.501678f, -34.025411f,-66.760274f, -34.013893f,-66.763626f, -33.972504f,-66.815567f, -33.887222f,-66.852234f,
                    -33.825562f,-66.938065f, -33.621674f,-67.015839f, -33.423340f,-67.156113f, -33.220284f,-67.193893f, -32.983894f,-67.195007f,
                    -32.925285f,-67.226395f, -32.873894f,-67.200836f, -32.799446f,-67.216400f, -32.762779f,-67.191391f, -32.669724f,-67.255005f,
                    -32.491669f,-67.299454f, -32.345001f,-67.383057f, -32.052505f,-67.397232f, -31.983059f,-67.371948f, -31.954723f,-67.376851f,
                    -31.954723f,-66.501678f);
            poly[56] = new TzPolygon(-31.954723f,-69.174179f, -31.954723f,-67.376851f, -31.983059f,-67.371948f, -32.052505f,-67.397232f, -32.313057f,-67.389450f,
                    -32.398529f,-67.360687f, -32.284729f,-67.479736f, -32.256668f,-67.577789f, -32.264725f,-67.675568f, -32.236671f,-67.837234f,
                    -32.164726f,-67.936676f, -32.101112f,-67.969452f, -32.067780f,-68.019455f, -32.109169f,-68.228897f, -32.068893f,-68.449448f,
                    -32.169174f,-68.486115f, -32.190002f,-68.539169f, -32.150284f,-68.740845f, -32.077225f,-68.890564f, -32.081116f,-69.023895f,
                    -31.973335f,-69.123901f);
            poly[57] = new TzPolygon(-36.000811f,-66.501678f, -36.002327f,-65.087891f, -35.001976f,-65.086670f, -34.998894f,-64.974731f, -35.002228f,-63.384094f,
                    -40.237473f,-63.386734f, -40.237473f,-66.501678f);
            poly[58] = new TzPolygon(-40.237473f,-63.387245f, -36.001945f,-63.389725f, -34.379242f,-63.381989f, -34.377846f,-62.365894f, -38.760842f,-62.365894f,
                    -38.750343f,-62.402878f, -38.766533f,-62.365894f, -38.801397f,-62.365894f, -38.801807f,-62.370380f, -38.838337f,-62.404316f,
                    -38.870434f,-62.370312f, -38.896324f,-62.390270f, -38.881425f,-62.365894f, -40.194859f,-62.365894f, -40.237473f,-62.410481f);
            poly[59] = new TzPolygon(-36.000275f,-66.501678f, -31.954723f,-66.501678f, -31.954723f,-65.512410f, -32.058334f,-65.310013f, -32.111115f,-65.251114f,
                    -32.328613f,-65.195007f, -32.298889f,-64.922226f, -32.440834f,-64.922501f, -32.561111f,-64.873611f, -32.718056f,-64.916397f,
                    -32.748062f,-64.947784f, -32.875282f,-64.969727f, -32.951393f,-65.018890f, -32.997223f,-65.005005f, -33.066116f,-65.045837f,
                    -33.116394f,-65.030014f, -33.136391f,-65.091400f, -33.218338f,-65.134171f, -34.001114f,-65.085281f, -36.002327f,-65.087891f);
            poly[60] = new TzPolygon(-31.954723f,-70.209130f, -31.890007f,-70.281090f, -31.888268f,-70.364090f, -31.848299f,-70.440231f, -31.700838f,-70.464653f,
                    -31.690077f,-70.496063f, -31.601419f,-70.538925f, -31.482286f,-70.561775f, -31.443043f,-70.538361f, -31.148432f,-70.505630f,
                    -31.089745f,-70.444550f, -31.170847f,-70.391121f, -31.107182f,-70.364616f, -31.023941f,-70.266884f, -31.005903f,-70.299416f,
                    -30.891106f,-70.304955f, -30.788624f,-70.276665f, -30.713327f,-70.219612f, -30.617956f,-70.219864f, -30.456715f,-70.129204f,
                    -30.349230f,-70.153870f, -30.398163f,-69.974602f, -30.350355f,-69.910675f, -30.255220f,-69.850203f, -30.255220f,-68.601897f,
                    -31.954723f,-68.601897f);
            poly[61] = new TzPolygon(-28.555717f,-69.649733f, -28.682852f,-69.706009f, -28.772778f,-69.672333f, -28.859367f,-69.719086f, -28.892117f,-69.766411f,
                    -29.108662f,-69.784836f, -29.122627f,-69.866646f, -29.169048f,-69.949768f, -29.252136f,-69.954308f, -29.268766f,-70.000000f,
                    -29.324593f,-70.017929f, -29.393723f,-69.975807f, -29.610571f,-69.940033f, -29.692238f,-69.881584f, -29.776009f,-69.921356f,
                    -29.866741f,-69.877609f, -30.090162f,-69.940002f, -30.123415f,-69.827423f, -30.186663f,-69.806625f, -30.255220f,-69.850203f,
                    -30.255220f,-70.680565f, -28.555717f,-70.680565f);
            poly[62] = new TzPolygon(-29.647437f,-68.601897f, -29.647503f,-68.604172f, -29.602222f,-68.687225f, -29.635559f,-68.829453f, -29.617500f,-68.884735f,
                    -29.636948f,-68.970840f, -29.621948f,-69.019455f, -29.515835f,-69.018066f, -29.455833f,-68.976959f, -29.343056f,-68.978058f,
                    -29.314724f,-68.939178f, -29.279724f,-68.959167f, -29.189724f,-68.954453f, -29.178890f,-68.908066f, -29.103615f,-68.890564f,
                    -29.042503f,-68.915848f, -28.922779f,-68.916672f, -28.772503f,-69.109726f, -28.619167f,-69.156403f, -28.555717f,-69.240791f,
                    -28.555717f,-68.601897f);
            poly[63] = new TzPolygon(-29.647437f,-68.601897f, -28.555717f,-68.601897f, -28.555717f,-66.523230f, -31.903470f,-66.523230f, -31.900837f,-66.535278f,
                    -31.918335f,-66.590561f, -31.876579f,-66.730484f, -31.672989f,-66.851852f, -31.629723f,-66.852234f, -31.616112f,-66.945282f,
                    -31.533337f,-67.045563f, -31.432503f,-67.055847f, -31.358059f,-67.107788f, -31.081947f,-67.060013f, -31.037502f,-67.128891f,
                    -30.899170f,-67.076126f, -30.713890f,-67.191956f, -30.680000f,-67.265015f, -30.566948f,-67.342789f, -30.506668f,-67.430557f,
                    -30.430557f,-67.482788f, -30.388615f,-67.561111f, -30.255001f,-67.625839f, -30.150280f,-67.779175f, -30.099724f,-67.813339f,
                    -30.060001f,-67.905563f, -29.969086f,-68.010239f, -29.910015f,-68.039185f, -29.856392f,-68.148895f, -29.803337f,-68.178345f,
                    -29.748058f,-68.281677f, -29.686947f,-68.329178f, -29.644447f,-68.498901f);
            poly[64] = new TzPolygon(-31.954723f,-67.376851f, -31.886669f,-67.388626f, -31.846668f,-67.337784f, -31.868057f,-67.233063f, -31.850834f,-67.096954f,
                    -31.891945f,-66.963348f, -31.876114f,-66.697784f, -31.918335f,-66.590561f, -31.900837f,-66.535278f, -31.903470f,-66.523230f,
                    -31.954723f,-66.523230f);
            poly[65] = new TzPolygon(-27.767200f,-68.601897f, -27.749447f,-68.652237f, -27.760834f,-68.742233f, -27.795834f,-68.866959f, -27.776859f,-69.075768f,
                    -27.700800f,-69.047249f, -27.642384f,-69.061546f, -27.578377f,-68.992676f, -27.319948f,-68.855728f, -27.290710f,-68.819931f,
                    -27.204268f,-68.848656f, -27.132984f,-68.796722f, -27.103754f,-68.768951f, -27.083498f,-68.684471f, -27.156485f,-68.625977f,
                    -27.165698f,-68.601897f);
            poly[66] = new TzPolygon(-28.555717f,-69.240791f, -28.480278f,-69.341125f, -28.480556f,-69.417786f, -28.427502f,-69.466675f, -28.436668f,-69.550568f,
                    -28.386099f,-69.631538f, -28.373451f,-69.581184f, -28.319555f,-69.530991f, -28.312134f,-69.481728f, -28.171591f,-69.436905f,
                    -28.204693f,-69.379478f, -28.138365f,-69.310570f, -27.995932f,-69.242020f, -27.966862f,-69.165802f, -27.888725f,-69.104164f,
                    -27.776859f,-69.075768f, -27.795834f,-68.866959f, -27.749447f,-68.652237f, -27.767200f,-68.601897f, -28.555717f,-68.601897f);
            poly[67] = new TzPolygon(-28.555717f,-69.649733f, -28.519854f,-69.633858f, -28.443064f,-69.649391f, -28.409985f,-69.619415f, -28.438057f,-69.543060f,
                    -28.425556f,-69.473068f, -28.480556f,-69.417786f, -28.480278f,-69.341125f, -28.555717f,-69.240791f);
            poly[68] = new TzPolygon(-26.856215f,-68.601897f, -26.856215f,-68.319103f, -26.916901f,-68.272133f, -26.972687f,-68.323372f, -27.046822f,-68.326904f,
                    -27.063770f,-68.480553f, -27.187799f,-68.544136f, -27.165698f,-68.601897f);
            poly[69] = new TzPolygon(-27.767200f,-68.601897f, -27.774723f,-68.580566f, -27.735558f,-68.504730f, -27.755001f,-68.429459f, -27.850559f,-68.448898f,
                    -27.903057f,-68.429169f, -28.007778f,-68.436111f, -28.016670f,-68.353348f, -28.085835f,-68.283340f, -28.100281f,-68.162231f,
                    -28.155556f,-68.097778f, -28.120281f,-67.935013f, -28.249168f,-67.914734f, -28.384724f,-67.818344f, -28.352222f,-67.763062f,
                    -28.378891f,-67.641113f, -28.233334f,-67.510010f, -28.337223f,-67.361389f, -28.353058f,-67.136398f, -28.279446f,-67.013626f,
                    -28.449722f,-66.543060f, -28.471252f,-66.523230f, -28.555717f,-66.523230f, -28.555717f,-68.601897f);
            poly[70] = new TzPolygon(-25.156712f,-68.516720f, -25.227903f,-68.551270f, -25.329281f,-68.533440f, -25.398954f,-68.597511f, -25.441935f,-68.562767f,
                    -25.488798f,-68.568176f, -25.534939f,-68.524757f, -25.583937f,-68.543045f, -25.657089f,-68.486931f, -26.190495f,-68.390450f,
                    -26.306953f,-68.570381f, -26.509184f,-68.587700f, -26.856215f,-68.319103f, -26.856215f,-68.601897f, -25.156712f,-68.601897f);
            poly[71] = new TzPolygon(-26.275318f,-66.523230f, -26.272781f,-66.526123f, -26.096947f,-66.619446f, -25.894447f,-66.787231f, -25.812778f,-66.816116f,
                    -25.734169f,-66.812790f, -25.677223f,-66.746124f, -25.667503f,-66.571121f, -25.633769f,-66.523230f);
            poly[72] = new TzPolygon(-25.396668f,-66.523230f, -25.269169f,-66.563065f, -25.283337f,-67.806946f, -25.166389f,-68.472229f, -25.156712f,-68.506134f,
                    -25.156712f,-66.523230f);
            poly[73] = new TzPolygon(-28.555717f,-66.523230f, -28.555717f,-66.481883f, -28.647224f,-66.460281f, -28.734447f,-66.335556f, -28.815002f,-66.381958f,
                    -28.855835f,-66.361954f, -28.967224f,-66.126404f, -29.224167f,-65.810837f, -29.314724f,-65.755005f, -29.401669f,-65.755280f,
                    -30.059330f,-65.127609f, -30.140278f,-65.401947f, -30.399750f,-65.523071f, -31.061668f,-65.767227f, -31.885464f,-65.759628f,
                    -31.905590f,-65.869614f, -31.867226f,-66.012222f, -31.928059f,-66.229172f, -31.936947f,-66.370010f, -31.903470f,-66.523230f);
            poly[74] = new TzPolygon(-31.954723f,-65.512410f, -31.891392f,-65.636124f, -31.885464f,-65.759628f, -31.061668f,-65.767227f, -30.399750f,-65.523071f,
                    -30.140278f,-65.401947f, -30.076946f,-65.146118f, -29.863892f,-64.926559f, -29.575279f,-64.966293f, -29.557224f,-64.882401f,
                    -29.288334f,-65.037781f, -29.022503f,-65.080292f, -28.704723f,-65.096115f, -28.651112f,-65.179733f, -28.598057f,-65.180557f,
                    -28.591946f,-65.151947f, -28.555717f,-65.126160f, -28.555717f,-62.365894f, -31.954723f,-62.365894f);
            poly[75] = new TzPolygon(-31.903470f,-66.523230f, -31.936947f,-66.370010f, -31.928059f,-66.229172f, -31.867226f,-66.012222f, -31.905590f,-65.869614f,
                    -31.885002f,-65.771667f, -31.891392f,-65.636124f, -31.954723f,-65.512410f, -31.954723f,-66.523230f);
            poly[76] = new TzPolygon(-26.856215f,-65.483896f, -27.952569f,-65.483896f, -27.961945f,-65.498062f, -28.054726f,-65.564728f, -27.954445f,-65.660278f,
                    -27.818611f,-65.699448f, -27.783058f,-65.765289f, -27.806393f,-65.813904f, -27.791668f,-65.845840f, -27.701115f,-65.871399f,
                    -27.654724f,-65.929733f, -27.441113f,-65.986115f, -27.395279f,-65.976959f, -27.325001f,-66.194733f, -27.223892f,-66.138901f,
                    -26.935558f,-65.880280f, -26.856215f,-65.867634f);
            poly[77] = new TzPolygon(-28.471252f,-66.523230f, -28.502502f,-66.494446f, -28.555717f,-66.481883f, -28.555717f,-66.523230f);
            poly[78] = new TzPolygon(-27.952691f,-65.483896f, -27.858334f,-65.339447f, -27.924168f,-65.230835f, -27.913612f,-65.166122f, -28.268890f,-65.079727f,
                    -28.411667f,-65.071671f, -28.493614f,-65.081955f, -28.555717f,-65.126160f, -28.555717f,-65.483896f);
            poly[79] = new TzPolygon(-26.856215f,-64.691672f, -27.011948f,-64.732788f, -27.037224f,-64.773056f, -27.321667f,-64.882233f, -27.331390f,-64.934723f,
                    -27.476360f,-65.065414f, -27.507088f,-64.968842f, -27.557781f,-64.994446f, -27.567780f,-65.058899f, -27.588337f,-65.068893f,
                    -27.635281f,-65.067505f, -27.773335f,-64.994171f, -27.780003f,-65.034729f, -27.877502f,-65.061951f, -27.899445f,-65.091400f,
                    -27.924168f,-65.230835f, -27.860279f,-65.344452f, -27.952569f,-65.483896f, -26.856215f,-65.483896f);
            poly[80] = new TzPolygon(-26.275563f,-66.523230f, -26.383335f,-66.411118f, -26.376114f,-66.363892f, -26.232502f,-66.285568f, -26.229973f,-66.152802f,
                    -26.323891f,-66.162231f, -26.388889f,-66.216675f, -26.551113f,-66.213348f, -26.591946f,-66.030563f, -26.713612f,-65.857788f,
                    -26.856215f,-65.872239f, -26.856215f,-66.523230f);
            poly[81] = new TzPolygon(-25.393940f,-66.523230f, -25.406113f,-66.520279f, -25.479725f,-66.468903f, -25.613892f,-66.495010f, -25.633769f,-66.523230f);
            poly[82] = new TzPolygon(-25.633769f,-66.523230f, -25.613892f,-66.495010f, -25.479725f,-66.468903f, -25.406113f,-66.520279f, -25.396668f,-66.523230f,
                    -25.156712f,-66.523230f, -25.156712f,-64.444562f, -26.130301f,-64.444562f, -26.222778f,-64.488617f, -26.212502f,-64.806396f,
                    -26.275837f,-64.941956f, -26.166946f,-65.272232f, -26.073334f,-65.319458f, -26.121948f,-65.438065f, -26.072502f,-65.665283f,
                    -26.303059f,-65.719727f, -26.230835f,-66.111679f, -26.229446f,-66.275009f, -26.264168f,-66.313614f, -26.376114f,-66.363892f,
                    -26.389446f,-66.393066f, -26.275318f,-66.523230f);
            poly[83] = new TzPolygon(-26.856215f,-64.691672f, -26.798336f,-64.676392f, -26.792778f,-64.618057f, -26.669445f,-64.585556f, -26.685001f,-64.496674f,
                    -26.435280f,-64.525284f, -26.300556f,-64.481125f, -26.186111f,-64.479446f, -26.125829f,-64.444562f, -26.856215f,-64.444562f);
            poly[84] = new TzPolygon(-25.156712f,-62.978287f, -25.659412f,-63.398506f, -25.652500f,-63.924446f, -25.571392f,-64.196121f, -26.033611f,-64.428894f,
                    -26.105003f,-64.432510f, -26.130301f,-64.444562f, -25.156712f,-64.444562f);
            poly[85] = new TzPolygon(-34.046666f,-58.655621f, -33.947456f,-58.785622f, -33.932228f,-58.866112f, -33.844559f,-59.002686f, -33.832230f,-59.164169f,
                    -33.802544f,-59.189041f, -33.799202f,-59.234909f, -33.721390f,-59.259445f, -33.744514f,-59.308891f, -33.740837f,-59.413338f,
                    -33.652245f,-59.514297f, -33.683090f,-59.612267f, -33.619171f,-59.759445f, -33.532501f,-59.853889f, -33.436111f,-60.054726f,
                    -33.256744f,-60.294411f, -33.279449f,-60.270836f, -33.315834f,-60.280838f, -33.345840f,-60.341667f, -33.414452f,-60.347778f,
                    -33.461945f,-60.414452f, -33.537506f,-60.425835f, -33.629723f,-60.479729f, -33.640007f,-60.579445f, -33.578613f,-60.665283f,
                    -33.578613f,-60.769173f, -33.550003f,-60.838890f, -33.567505f,-60.918617f, -33.645004f,-60.926117f, -34.376945f,-61.710556f,
                    -34.377846f,-62.365894f, -25.156712f,-62.365894f, -25.156712f,-58.655621f);
            poly[86] = new TzPolygon(-33.963406f,-58.655621f, -33.964172f,-58.432247f, -34.009800f,-58.442451f, -34.052223f,-58.648338f, -34.046666f,-58.655621f);
            poly[87] = new TzPolygon(-34.734657f,-56.669033f, -34.669922f,-56.880924f, -34.604405f,-56.958068f, -34.604405f,-56.669033f);
            poly[88] = new TzPolygon(-33.112217f,-58.655621f, -33.112217f,-58.418786f, -33.127911f,-58.408192f, -33.249489f,-58.434254f, -33.309601f,-58.414490f,
                    -33.411446f,-58.498886f, -33.492107f,-58.531158f, -33.722229f,-58.555840f, -33.806366f,-58.518166f, -33.840740f,-58.457985f,
                    -33.893059f,-58.465847f, -33.896950f,-58.510563f, -33.919674f,-58.485752f, -33.909615f,-58.442272f, -33.937153f,-58.439175f,
                    -33.957489f,-58.484894f, -33.963406f,-58.438287f, -33.963406f,-58.655621f);
            poly[89] = new TzPolygon(-33.092667f,-58.180637f, -33.095020f,-58.179478f, -33.107170f,-58.211796f, -33.105629f,-58.213989f);
            poly[90] = new TzPolygon(-33.078617f,-58.160008f, -33.070263f,-58.152431f, -33.073887f,-58.151073f, -33.078617f,-58.152314f);
            poly[91] = new TzPolygon(-32.746323f,-58.142677f, -32.867043f,-58.118858f, -33.012646f,-58.128399f, -33.050895f,-58.151073f, -32.746323f,-58.151073f);
            poly[92] = new TzPolygon(-32.746323f,-53.073933f, -33.522941f,-53.073933f, -33.750706f,-53.368324f, -33.741230f,-53.421154f, -33.700855f,-53.435608f,
                    -33.689034f,-53.524460f, -33.163319f,-53.514950f, -33.053841f,-53.433838f, -32.935848f,-53.243134f, -32.910892f,-53.294228f,
                    -32.850266f,-53.181610f, -32.800652f,-53.158321f, -32.783741f,-53.094597f);
            poly[93] = new TzPolygon(-30.848920f,-58.655621f, -30.848920f,-57.799429f, -30.915720f,-57.833961f, -30.913601f,-57.910683f, -31.032894f,-57.862183f,
                    -31.129105f,-57.912880f, -31.212496f,-57.916306f, -31.319515f,-57.981270f, -31.392878f,-57.986870f, -31.469915f,-58.086422f,
                    -31.518204f,-58.015244f, -31.573807f,-57.981361f, -31.695442f,-58.022289f, -31.816376f,-58.082661f, -31.838722f,-58.174919f,
                    -31.870945f,-58.204731f, -31.964411f,-58.159016f, -32.000000f,-58.176239f, -32.000000f,-58.146439f, -32.023018f,-58.139122f,
                    -32.156181f,-58.181927f, -32.275284f,-58.099659f, -32.342209f,-58.122166f, -32.382973f,-58.182354f, -32.452267f,-58.200695f,
                    -32.746323f,-58.142677f, -32.746323f,-58.655621f);
            poly[94] = new TzPolygon(-30.848920f,-55.991916f, -30.848920f,-55.864777f, -31.076028f,-55.864777f, -31.079561f,-55.869793f, -31.087786f,-55.951057f,
                    -31.062643f,-56.007816f, -30.939920f,-56.015560f, -30.859661f,-55.987007f);
            poly[95] = new TzPolygon(-28.951517f,-57.260199f, -29.802102f,-57.260199f, -29.822790f,-57.283546f, -29.870474f,-57.319035f, -30.001225f,-57.341965f,
                    -30.040691f,-57.412037f, -30.143063f,-57.504837f, -30.180117f,-57.641468f, -30.248482f,-57.606899f, -30.338024f,-57.635391f,
                    -30.504807f,-57.872578f, -30.577246f,-57.888187f, -30.699196f,-57.806763f, -30.848920f,-57.799429f, -30.848920f,-58.655621f,
                    -28.951517f,-58.655621f);
            poly[96] = new TzPolygon(-30.266334f,-57.260199f, -30.266008f,-57.261349f, -30.288534f,-57.285740f, -30.259735f,-57.313053f, -30.282406f,-57.350517f,
                    -30.271660f,-57.373993f, -30.302553f,-57.395607f, -30.265335f,-57.463970f, -30.274714f,-57.538372f, -30.215286f,-57.555843f,
                    -30.179155f,-57.617966f, -30.143063f,-57.504837f, -30.040691f,-57.412037f, -30.001225f,-57.341965f, -29.870474f,-57.319035f,
                    -29.802102f,-57.260199f);
            poly[97] = new TzPolygon(-30.848920f,-55.991916f, -30.784410f,-56.021400f, -30.771645f,-56.059872f, -30.741293f,-56.068600f, -30.738832f,-56.127430f,
                    -30.614134f,-56.176929f, -30.600948f,-56.219543f, -30.574612f,-56.231049f, -30.584654f,-56.258823f, -30.522406f,-56.292751f,
                    -30.531038f,-56.320980f, -30.491430f,-56.350372f, -30.495270f,-56.383930f, -30.387398f,-56.459232f, -30.394119f,-56.488670f,
                    -30.360626f,-56.519054f, -30.364494f,-56.544647f, -30.312326f,-56.539963f, -30.293556f,-56.575268f, -30.302534f,-56.617229f,
                    -30.270056f,-56.607941f, -30.265965f,-56.637081f, -30.242899f,-56.627735f, -30.222256f,-56.663433f, -30.205074f,-56.644341f,
                    -30.205576f,-56.697208f, -30.177462f,-56.705822f, -30.166460f,-56.776314f, -30.106834f,-56.803612f, -30.087744f,-57.068336f,
                    -30.121901f,-57.089169f, -30.114731f,-57.110100f, -30.201887f,-57.166111f, -30.231907f,-57.157833f, -30.281454f,-57.206776f,
                    -30.266334f,-57.260199f, -29.900218f,-57.260199f, -29.900218f,-55.864777f, -30.848920f,-55.864777f);
            poly[98] = new TzPolygon(-28.951517f,-56.368247f, -28.979462f,-56.410877f, -29.072884f,-56.424786f, -29.122995f,-56.593063f, -29.361933f,-56.708401f,
                    -29.380333f,-56.765152f, -29.484146f,-56.822639f, -29.521402f,-56.889812f, -29.607138f,-56.971313f, -29.638693f,-56.971889f,
                    -29.659849f,-57.020115f, -29.751858f,-57.105194f, -29.781261f,-57.236679f, -29.802102f,-57.260199f, -28.951517f,-57.260199f);
            poly[99] = new TzPolygon(-32.746323f,-53.073933f, -32.605328f,-53.243740f, -32.617226f,-53.282333f, -32.576103f,-53.358631f, -32.582527f,-53.389820f,
                    -32.479908f,-53.459667f, -32.487171f,-53.520458f, -32.431534f,-53.594929f, -32.384529f,-53.632420f, -32.294575f,-53.635281f,
                    -32.156906f,-53.729744f, -32.104080f,-53.714149f, -32.057758f,-53.826855f, -32.000893f,-53.851562f, -31.957180f,-53.953388f,
                    -31.919411f,-53.964783f, -31.887234f,-54.035549f, -31.905582f,-54.095509f, -31.665781f,-54.465691f, -31.540012f,-54.491119f,
                    -31.482271f,-54.576340f, -31.448469f,-54.590782f, -31.446281f,-54.835564f, -31.400658f,-54.890926f, -31.392017f,-54.944679f,
                    -31.284863f,-55.014458f, -31.325661f,-55.091202f, -31.256735f,-55.245102f, -31.167381f,-55.289684f, -31.126091f,-55.340149f,
                    -31.037638f,-55.374077f, -31.008947f,-55.431519f, -30.972147f,-55.446011f, -30.847813f,-55.593533f, -30.857454f,-55.635387f,
                    -30.956448f,-55.657135f, -30.958279f,-55.697609f, -31.076028f,-55.864777f, -28.951517f,-55.864777f, -28.951517f,-53.073933f);
        }
    }

    private static class Initializer2 {
        private static void init() {
            poly[100] = new TzPolygon(-27.188787f,-58.655621f, -27.137747f,-58.648048f, -27.105818f,-58.554455f, -27.054114f,-58.549523f, -27.054114f,-58.519925f,
                    -27.060469f,-58.505894f, -27.054114f,-58.506055f, -27.054114f,-55.864777f, -27.388808f,-55.864777f, -27.345722f,-55.899979f,
                    -27.349348f,-55.972240f, -27.304419f,-56.059593f, -27.312521f,-56.143482f, -27.408508f,-56.282654f, -27.488049f,-56.289650f,
                    -27.543888f,-56.351501f, -27.598721f,-56.364822f, -27.608738f,-56.400787f, -27.581318f,-56.482918f, -27.472311f,-56.548649f,
                    -27.447981f,-56.598835f, -27.464451f,-56.708366f, -27.559475f,-56.737278f, -27.604212f,-56.850048f, -27.510633f,-57.000000f,
                    -27.464836f,-57.000000f, -27.487104f,-57.075878f, -27.414057f,-57.325756f, -27.438999f,-57.510853f, -27.327494f,-57.715687f,
                    -27.331875f,-57.801392f, -27.296431f,-57.852055f, -27.263651f,-58.006931f, -27.272093f,-58.107559f, -27.249126f,-58.243351f,
                    -27.299330f,-58.602024f, -27.232431f,-58.594391f);
            poly[101] = new TzPolygon(-28.951517f,-56.368247f, -28.915964f,-56.314011f, -28.793924f,-56.284962f, -28.770824f,-56.184864f, -28.703600f,-56.140114f,
                    -28.610699f,-56.016163f, -28.509132f,-56.010750f, -28.479164f,-55.888020f, -28.403410f,-55.901154f, -28.362265f,-55.874763f,
                    -28.363332f,-55.864777f, -28.951517f,-55.864777f);
            poly[102] = new TzPolygon(-26.105413f,-58.655621f, -26.105413f,-58.023432f, -26.116224f,-58.080006f, -26.182043f,-58.116745f, -26.180548f,-58.155479f,
                    -26.236576f,-58.113174f, -26.265755f,-58.167580f, -26.323599f,-58.153900f, -26.397747f,-58.207027f, -26.452932f,-58.177402f,
                    -26.473810f,-58.225681f, -26.495789f,-58.205002f, -26.532639f,-58.219624f, -26.642481f,-58.188942f, -26.657429f,-58.213806f,
                    -26.645239f,-58.250671f, -26.753227f,-58.250267f, -26.761765f,-58.294907f, -26.800175f,-58.289558f, -26.813965f,-58.359066f,
                    -26.866634f,-58.322353f, -26.868376f,-58.370426f, -26.917238f,-58.432270f, -26.927269f,-58.488453f, -26.989092f,-58.475712f,
                    -27.005827f,-58.507282f, -27.054114f,-58.506055f, -27.054114f,-58.519925f, -27.041265f,-58.548298f, -27.054114f,-58.549523f,
                    -27.054114f,-58.655621f);
            poly[103] = new TzPolygon(-25.156712f,-57.787628f, -25.159111f,-57.783451f, -25.266859f,-57.722721f, -25.276943f,-57.667610f, -25.326807f,-57.673035f,
                    -25.447680f,-57.556614f, -25.564631f,-57.566437f, -25.574903f,-57.598949f, -25.617508f,-57.608990f, -25.601357f,-57.671101f,
                    -25.662350f,-57.679382f, -25.660097f,-57.747150f, -25.684269f,-57.765190f, -25.723345f,-57.732040f, -25.760918f,-57.813828f,
                    -25.829599f,-57.796757f, -25.860910f,-57.856541f, -25.920172f,-57.840103f, -25.939693f,-57.883339f, -26.006014f,-57.849354f,
                    -26.103649f,-58.014202f, -26.105413f,-58.023432f, -26.105413f,-58.655621f, -25.156712f,-58.655621f);
            poly[104] = new TzPolygon(-28.002816f,-55.864777f, -28.002816f,-55.382121f, -28.033712f,-55.373402f, -28.097296f,-55.444408f, -28.081087f,-55.495789f,
                    -28.164009f,-55.554302f, -28.121393f,-55.582016f, -28.122692f,-55.604652f, -28.179676f,-55.635754f, -28.247013f,-55.773090f,
                    -28.274733f,-55.765858f, -28.333199f,-55.670597f, -28.425304f,-55.695621f, -28.375694f,-55.749134f, -28.363332f,-55.864777f);
            poly[105] = new TzPolygon(-27.054114f,-55.864777f, -27.054114f,-55.455373f, -27.102175f,-55.456573f, -27.111809f,-55.548275f, -27.162529f,-55.565750f,
                    -27.175627f,-55.615429f, -27.203476f,-55.620567f, -27.248247f,-55.580433f, -27.337038f,-55.595531f, -27.384998f,-55.681881f,
                    -27.444799f,-55.732601f, -27.433220f,-55.828491f, -27.388808f,-55.864777f);
            poly[106] = new TzPolygon(-28.002816f,-55.382121f, -27.990942f,-55.385471f, -27.968536f,-55.342159f, -27.928085f,-55.322998f, -27.917767f,-55.260715f,
                    -27.863062f,-55.195995f, -27.895418f,-55.133827f, -27.853176f,-55.116982f, -27.853931f,-55.031883f, -27.833746f,-55.026188f,
                    -27.788731f,-55.082161f, -27.771923f,-55.053314f, -27.797470f,-55.013805f, -27.775112f,-54.940521f, -27.721525f,-54.903927f,
                    -27.640909f,-54.900333f, -27.623375f,-54.847153f, -27.535900f,-54.808735f, -27.586494f,-54.781147f, -27.564945f,-54.737015f,
                    -27.575510f,-54.683308f, -27.513931f,-54.677849f, -27.549913f,-54.623844f, -27.458294f,-54.576408f, -27.506870f,-54.524673f,
                    -27.484458f,-54.469355f, -28.002816f,-54.469355f);
            poly[107] = new TzPolygon(-27.438305f,-54.469355f, -27.431713f,-54.472763f, -27.430559f,-54.469355f);
            poly[108] = new TzPolygon(-27.054114f,-53.790225f, -27.076250f,-53.773148f, -27.090254f,-53.798847f, -27.104921f,-53.775322f, -27.103771f,-53.813004f,
                    -27.134626f,-53.821144f, -27.147446f,-53.798599f, -27.172464f,-53.830185f, -27.133757f,-53.863750f, -27.177027f,-53.901962f,
                    -27.158316f,-53.949463f, -27.199356f,-53.956615f, -27.204552f,-54.008915f, -27.248613f,-54.021622f, -27.302652f,-54.089058f,
                    -27.299532f,-54.153034f, -27.260693f,-54.175957f, -27.381634f,-54.216248f, -27.400837f,-54.265179f, -27.447117f,-54.282375f,
                    -27.405546f,-54.338970f, -27.467508f,-54.353207f, -27.412132f,-54.414948f, -27.430559f,-54.469355f, -27.054114f,-54.469355f);
            poly[109] = new TzPolygon(-27.438305f,-54.469355f, -27.476463f,-54.449623f, -27.484458f,-54.469355f);
            poly[110] = new TzPolygon(-27.054114f,-53.767860f, -27.068203f,-53.760914f, -27.054114f,-53.784536f);
            poly[111] = new TzPolygon(-27.054114f,-55.455373f, -27.049028f,-55.455246f, -26.999084f,-55.420368f, -26.943678f,-55.262337f, -26.971714f,-55.206676f,
                    -26.957678f,-55.143860f, -26.866289f,-55.135178f, -26.800554f,-55.053085f, -26.790579f,-54.961952f, -26.693182f,-54.938946f,
                    -26.664341f,-54.875023f, -26.680712f,-54.823509f, -26.656389f,-54.801273f, -26.618370f,-54.785191f, -26.545460f,-54.804123f,
                    -26.452890f,-54.706551f, -26.385002f,-54.697723f, -26.317989f,-54.649860f, -26.269470f,-54.680676f, -26.217539f,-54.620258f,
                    -26.161697f,-54.673843f, -26.090303f,-54.642502f, -25.997608f,-54.681557f, -25.965288f,-54.608250f, -25.920746f,-54.623386f,
                    -25.833860f,-54.590622f, -25.681887f,-54.659447f, -25.666195f,-54.590004f, -25.594971f,-54.596363f, -25.595560f,-54.552433f,
                    -25.636497f,-54.528938f, -25.629606f,-54.490520f, -25.656389f,-54.469355f, -27.054114f,-54.469355f);
            poly[112] = new TzPolygon(-25.656389f,-54.469355f, -25.629606f,-54.490520f, -25.636497f,-54.528938f, -25.595560f,-54.552433f, -25.594971f,-54.596363f,
                    -25.459059f,-54.616676f, -25.211157f,-54.469355f);
            poly[113] = new TzPolygon(-27.054114f,-53.790225f, -27.047829f,-53.795074f, -27.054114f,-53.785816f);
            poly[114] = new TzPolygon(-27.054114f,-53.769314f, -27.034369f,-53.777596f, -27.036762f,-53.746887f, -27.018641f,-53.758278f, -27.015423f,-53.732834f,
                    -26.943119f,-53.704617f, -26.950300f,-53.675056f, -26.938034f,-53.693493f, -26.903234f,-53.674053f, -26.870100f,-53.690750f,
                    -26.868530f,-53.662308f, -26.850729f,-53.695198f, -26.776398f,-53.703827f, -26.775347f,-53.736794f, -26.767664f,-53.716938f,
                    -26.739222f,-53.727825f, -26.745457f,-53.751480f, -26.658140f,-53.715584f, -26.646215f,-53.752872f, -26.562529f,-53.706879f,
                    -26.568768f,-53.730495f, -26.547729f,-53.738205f, -26.539612f,-53.717102f, -26.501827f,-53.723934f, -26.488571f,-53.694569f,
                    -26.441349f,-53.702736f, -26.410627f,-53.647530f, -26.264887f,-53.591835f, -26.129519f,-53.722187f, -26.105413f,-53.725316f,
                    -26.105413f,-53.073933f, -27.054114f,-53.073933f);
            poly[115] = new TzPolygon(-25.157371f,-54.469355f, -25.157377f,-54.436733f, -25.212068f,-54.469355f);
            poly[116] = new TzPolygon(-25.656389f,-54.469355f, -25.705940f,-54.430195f, -25.607546f,-54.387451f, -25.613123f,-54.353786f, -25.562471f,-54.288551f,
                    -25.602489f,-54.251537f, -25.570810f,-54.233040f, -25.591200f,-54.184029f, -25.554499f,-54.212704f, -25.547081f,-54.165665f,
                    -25.504400f,-54.110592f, -25.569439f,-54.129501f, -25.625378f,-54.101093f, -25.618969f,-54.081718f, -25.578829f,-54.079720f,
                    -25.589493f,-54.046642f, -25.569025f,-54.016167f, -25.589357f,-53.978783f, -25.643618f,-53.951473f, -25.614222f,-53.940407f,
                    -25.636118f,-53.912571f, -25.625294f,-53.890556f, -25.659595f,-53.885525f, -25.689316f,-53.843918f, -25.709263f,-53.881348f,
                    -25.753052f,-53.836243f, -25.769005f,-53.854595f, -25.793314f,-53.843742f, -25.793463f,-53.823723f, -25.839582f,-53.849609f,
                    -25.875870f,-53.824562f, -25.886150f,-53.851685f, -25.899622f,-53.819008f, -25.968618f,-53.837315f, -26.047001f,-53.732899f,
                    -26.105413f,-53.725316f, -26.105413f,-54.469355f);
            poly[117] = new TzPolygon(8.317958f,-82.738289f, 8.277208f,-82.858185f, 8.216846f,-82.883270f, 8.117813f,-82.877968f, 8.074693f,-82.855270f,
                    8.025041f,-82.875542f, 8.032975f,-82.896828f, 8.111118f,-82.891182f, 8.269567f,-82.937759f, 8.277086f,-82.990341f,
                    8.333736f,-83.051445f, 8.434606f,-82.928246f, 8.437750f,-82.878387f, 8.465169f,-82.847595f, 8.626787f,-82.827850f,
                    8.765041f,-82.916710f, 8.796546f,-82.869537f, 8.845969f,-82.868141f, 8.878805f,-82.769592f, 8.908242f,-82.738289f);
            poly[118] = new TzPolygon(8.973391f,-82.738289f, 8.985933f,-82.745491f, 9.008022f,-82.800766f, 9.087294f,-82.886742f, 9.081124f,-82.935051f,
                    9.473368f,-82.937561f, 9.499599f,-82.842918f, 9.565512f,-82.886902f, 9.612393f,-82.862175f, 9.580315f,-82.748421f,
                    9.572253f,-82.738289f);
            poly[119] = new TzPolygon(12.177296f,-86.763902f, 12.177296f,-83.683601f, 12.009124f,-83.687195f, 11.967886f,-83.726860f, 11.922454f,-83.733643f,
                    11.602798f,-83.647865f, 11.557597f,-83.757286f, 11.444011f,-83.803818f, 11.441951f,-83.834625f, 11.373322f,-83.873894f,
                    11.287376f,-83.878456f, 11.070743f,-83.818138f, 10.958364f,-83.748634f, 10.916177f,-83.680183f, 10.820307f,-83.664612f,
                    10.789515f,-83.686348f, 10.768380f,-83.792694f, 10.718340f,-83.866890f, 10.707543f,-83.928490f, 10.789279f,-84.025131f,
                    10.763419f,-84.070358f, 10.769733f,-84.126656f, 10.788995f,-84.134407f, 10.779010f,-84.202408f, 10.816705f,-84.240601f,
                    10.824231f,-84.222427f, 10.863817f,-84.222466f, 10.912962f,-84.326645f, 10.992827f,-84.358383f, 10.956406f,-84.439964f,
                    11.049906f,-84.572166f, 11.038371f,-84.607697f, 11.078856f,-84.677879f, 10.941321f,-84.914108f, 11.124355f,-85.357674f,
                    11.162541f,-85.520576f, 11.210237f,-85.566360f, 11.213552f,-85.618568f, 11.073880f,-85.698433f, 11.102144f,-85.781387f,
                    11.295265f,-85.919647f, 11.339336f,-85.999489f, 11.435659f,-86.089478f, 11.478954f,-86.164032f, 11.548042f,-86.212318f,
                    11.626193f,-86.348991f, 11.774832f,-86.518509f, 11.993463f,-86.679237f);
            poly[120] = new TzPolygon(13.808829f,-90.279968f, 14.445067f,-90.279968f, 14.445067f,-89.350505f, 14.418530f,-89.353027f, 14.445052f,-89.393951f,
                    14.412374f,-89.421936f, 14.414145f,-89.486732f, 14.382007f,-89.521362f, 14.412050f,-89.541901f, 14.405725f,-89.572342f,
                    14.350834f,-89.565155f, 14.316296f,-89.585411f, 14.298436f,-89.547333f, 14.223638f,-89.519432f, 14.183924f,-89.661186f,
                    14.115606f,-89.720169f, 14.032995f,-89.737701f, 14.055885f,-89.848251f, 13.935713f,-90.026711f, 13.895348f,-90.035133f,
                    13.875019f,-90.079361f, 13.826407f,-90.112671f, 13.737302f,-90.107964f);
            poly[121] = new TzPolygon(13.382203f,-87.855835f, 13.378290f,-87.849503f, 13.368190f,-87.867111f, 13.374627f,-87.868759f);
            poly[122] = new TzPolygon(13.312460f,-88.957429f, 13.480356f,-89.298790f, 13.482163f,-89.350505f, 14.426618f,-89.350505f, 14.340095f,-89.167572f,
                    14.346266f,-89.090340f, 14.326316f,-89.043304f, 14.211896f,-88.975952f, 14.178296f,-88.864639f, 14.081009f,-88.816673f,
                    14.083919f,-88.751724f, 14.010708f,-88.680290f, 14.019085f,-88.628532f, 13.978774f,-88.565002f, 13.970968f,-88.507683f,
                    13.858118f,-88.494804f, 13.882391f,-88.376869f, 13.865360f,-88.353256f, 13.897398f,-88.254982f, 13.939721f,-88.199547f,
                    13.951336f,-88.064247f, 13.868343f,-88.010796f, 13.896628f,-87.958641f, 13.889174f,-87.799873f, 13.801051f,-87.708916f,
                    13.518681f,-87.791412f, 13.498605f,-87.722595f, 13.440451f,-87.723587f, 13.418276f,-87.841337f, 13.378997f,-87.871803f,
                    13.390502f,-87.887535f, 13.352790f,-87.868996f, 13.312460f,-87.812390f);
            poly[123] = new TzPolygon(13.418276f,-87.841337f, 13.418740f,-87.841965f, 13.450182f,-87.789345f);
            poly[124] = new TzPolygon(12.833526f,-87.523160f, 12.833791f,-87.547157f, 13.031934f,-87.547157f, 13.020338f,-87.516434f, 12.931032f,-87.469231f,
                    12.911468f,-87.405327f, 12.974335f,-87.314873f, 12.963829f,-87.258629f, 12.982411f,-87.314613f, 12.986965f,-87.031158f,
                    13.030617f,-86.960396f, 13.089302f,-86.918427f, 13.121090f,-86.933311f, 13.256348f,-86.907913f, 13.305417f,-86.828766f,
                    13.266961f,-86.756302f, 13.300037f,-86.704605f, 13.315682f,-86.705904f, 13.315682f,-85.157913f, 12.833526f,-85.157913f,
                    12.833526f,-87.501642f, 12.846725f,-87.503601f, 12.843324f,-87.527039f);
            poly[125] = new TzPolygon(13.315682f,-86.705904f, 13.369394f,-86.710365f, 13.392925f,-86.742889f, 13.434116f,-86.722122f, 13.550717f,-86.745728f,
                    13.573005f,-86.768272f, 13.635921f,-86.751465f, 13.656704f,-86.785034f, 13.773121f,-86.762840f, 13.800655f,-86.551315f,
                    13.769221f,-86.499069f, 13.782899f,-86.451141f, 13.758682f,-86.432777f, 13.761778f,-86.346161f, 13.813955f,-86.301292f,
                    13.845449f,-86.300415f, 13.955145f,-86.185905f, 13.979459f,-86.188446f, 14.000880f,-86.137451f, 14.032482f,-86.150467f,
                    14.077059f,-86.012138f, 13.989798f,-86.015450f, 13.907865f,-85.920044f, 13.913338f,-85.851273f, 13.843211f,-85.818184f,
                    13.835058f,-85.748627f, 13.862103f,-85.739700f, 13.881618f,-85.765182f, 13.964946f,-85.753914f, 13.988040f,-85.712532f,
                    13.978364f,-85.682495f, 14.012731f,-85.661552f, 14.025359f,-85.607887f, 14.062426f,-85.576477f, 14.046359f,-85.523018f,
                    14.086409f,-85.505234f, 14.106145f,-85.428291f, 14.175532f,-85.379356f, 14.222866f,-85.379608f, 14.213862f,-85.357437f,
                    14.244608f,-85.338715f, 14.250559f,-85.183571f, 14.293488f,-85.157913f, 13.315682f,-85.157913f);
            poly[126] = new TzPolygon(14.293488f,-85.157913f, 14.366777f,-85.225494f, 14.445067f,-85.179068f, 14.445067f,-85.157913f);
            poly[127] = new TzPolygon(16.131234f,-92.937019f, 16.131234f,-90.438104f, 16.121201f,-90.430557f, 16.124290f,-90.454414f, 16.094162f,-90.457413f,
                    16.102484f,-90.425606f, 16.077347f,-90.447144f, 16.076500f,-91.731903f, 15.260700f,-92.210503f, 15.070380f,-92.059448f,
                    15.021635f,-92.085785f, 15.013645f,-92.130806f, 14.985678f,-92.151543f, 14.887989f,-92.137032f, 14.828277f,-92.184158f,
                    14.662294f,-92.146408f, 14.534548f,-92.225258f, 15.048519f,-92.765877f, 15.227275f,-92.908607f, 15.243516f,-92.937019f);
            poly[128] = new TzPolygon(16.131234f,-90.437334f, 16.151993f,-90.451355f, 16.164074f,-90.426003f, 16.207951f,-90.458244f, 16.233063f,-90.429512f,
                    16.248198f,-90.456093f, 16.258553f,-90.424011f, 16.300978f,-90.438492f, 16.338169f,-90.383209f, 16.362316f,-90.411697f,
                    16.363947f,-90.372314f, 16.394587f,-90.403992f, 16.411982f,-90.388527f, 16.423094f,-90.485802f, 16.459604f,-90.479240f,
                    16.459238f,-90.530090f, 16.481283f,-90.544785f, 16.480036f,-90.632957f, 16.503506f,-90.606796f, 16.522030f,-90.617760f,
                    16.517887f,-90.646095f, 16.560925f,-90.647285f, 16.577991f,-90.626595f, 16.595514f,-90.640236f, 16.582394f,-90.667679f,
                    16.638109f,-90.657669f, 16.724779f,-90.712044f, 16.775812f,-90.802422f, 16.798157f,-90.803375f, 16.821487f,-90.921455f,
                    16.860497f,-90.935478f, 16.863695f,-90.974350f, 16.901375f,-90.963921f, 16.898680f,-90.985054f, 16.863277f,-90.987953f,
                    16.903051f,-91.066658f, 16.974317f,-91.106811f, 16.974317f,-90.371544f, 16.131234f,-90.371544f);
            poly[129] = new TzPolygon(16.974317f,-91.106811f, 17.003038f,-91.122993f, 17.015982f,-91.176064f, 17.094578f,-91.226578f, 17.108896f,-91.266922f,
                    17.170700f,-91.265472f, 17.183455f,-91.323540f, 17.160032f,-91.348679f, 17.190565f,-91.354012f, 17.210150f,-91.419456f,
                    17.247925f,-91.439438f, 17.254101f,-90.989502f, 17.817400f,-90.989502f, 17.817400f,-90.371544f, 16.974317f,-90.371544f);
            poly[130] = new TzPolygon(14.445067f,-89.350498f, 14.457456f,-89.350792f, 14.577447f,-89.238724f, 14.572211f,-89.155380f, 14.705526f,-89.133186f,
                    14.727124f,-89.165878f, 14.773200f,-89.168396f, 14.833454f,-89.221916f, 14.872553f,-89.225220f, 14.947644f,-89.165871f,
                    14.978539f,-89.158333f, 14.996996f,-89.182213f, 15.065302f,-89.154449f, 15.137063f,-88.967110f, 15.255234f,-88.826164f,
                    15.337831f,-88.682518f, 15.603988f,-88.354828f, 15.665991f,-88.306084f, 15.687259f,-88.251930f, 15.717407f,-88.249878f,
                    15.718479f,-88.217514f, 15.689617f,-88.175591f, 14.445067f,-88.175591f);
            poly[131] = new TzPolygon(17.817400f,-89.146866f, 17.048967f,-89.145714f, 15.891877f,-89.221741f, 15.909776f,-89.177933f, 15.894317f,-89.078316f,
                    15.913881f,-89.058243f, 15.890036f,-88.938820f, 15.878797f,-88.986290f, 15.891639f,-88.911674f, 15.858237f,-88.881218f,
                    15.870767f,-88.828651f, 15.747583f,-88.627838f, 15.718479f,-88.640061f, 15.718479f,-90.371544f, 17.817400f,-90.371544f);
            poly[132] = new TzPolygon(14.445067f,-85.179068f, 14.512598f,-85.139023f, 14.566558f,-85.151047f, 14.580084f,-85.126610f, 14.549147f,-85.089676f,
                    14.572330f,-85.045082f, 14.630928f,-85.026276f, 14.665405f,-85.049965f, 14.734552f,-84.987854f, 14.757909f,-84.928940f,
                    14.807712f,-84.903412f, 14.817607f,-84.802963f, 14.661679f,-84.705032f, 14.686986f,-84.680992f, 14.650124f,-84.581810f,
                    14.653832f,-84.524513f, 14.628666f,-84.534416f, 14.620847f,-84.498272f, 14.445067f,-84.498272f);
            poly[133] = new TzPolygon(15.839816f,-84.498272f, 15.815433f,-84.303970f, 15.432225f,-83.847549f, 15.254622f,-83.398598f, 15.074544f,-83.297447f,
                    14.996335f,-83.155403f, 14.974154f,-83.283730f, 14.998981f,-83.280930f, 15.000000f,-83.359962f, 15.025909f,-83.404846f,
                    14.988770f,-83.424889f, 14.975083f,-83.468102f, 15.002917f,-83.498108f, 14.986325f,-83.531738f, 14.967100f,-83.525665f,
                    14.974007f,-83.541595f, 14.944242f,-83.535316f, 14.947268f,-83.552521f, 14.905336f,-83.565323f, 14.890251f,-83.619385f,
                    14.856726f,-83.621590f, 14.875109f,-83.647346f, 14.866241f,-83.700882f, 14.843494f,-83.717735f, 14.825725f,-83.705208f,
                    14.803782f,-83.819542f, 14.785112f,-83.799400f, 14.761773f,-83.877228f, 14.779912f,-83.888962f, 14.758994f,-83.898941f,
                    14.768173f,-83.936493f, 14.742734f,-83.932106f, 14.738358f,-84.027252f, 14.783775f,-84.113571f, 14.722271f,-84.098511f,
                    14.707882f,-84.180161f, 14.754411f,-84.238800f, 14.732194f,-84.267624f, 14.674626f,-84.254478f, 14.655074f,-84.278839f,
                    14.681665f,-84.309311f, 14.675979f,-84.348297f, 14.701665f,-84.343094f, 14.711728f,-84.364601f, 14.643331f,-84.409950f,
                    14.614529f,-84.469063f, 14.620847f,-84.498272f);
            poly[134] = new TzPolygon(18.793606f,-91.535500f, 18.755074f,-91.509560f, 18.729450f,-91.556969f, 18.734694f,-91.571701f, 18.751505f,-91.557053f,
                    18.732996f,-91.602798f, 18.656002f,-91.684196f, 18.652449f,-91.714790f, 18.676140f,-91.706703f, 18.673080f,-91.726936f,
                    18.633169f,-91.826996f, 18.653992f,-91.846626f);
            poly[135] = new TzPolygon(18.466695f,-91.509560f, 18.098446f,-91.509560f, 18.096664f,-91.609177f, 17.950832f,-91.626404f, 17.951385f,-91.855286f,
                    18.017776f,-91.979446f, 18.049721f,-91.988892f, 18.157219f,-92.157791f, 18.511944f,-92.153061f, 18.513054f,-92.421677f,
                    18.646942f,-92.481949f, 18.671793f,-92.406914f, 18.720253f,-91.972374f, 18.616777f,-91.845703f, 18.540699f,-91.904770f,
                    18.520023f,-91.854317f, 18.506477f,-91.852318f, 18.516020f,-91.876213f, 18.498604f,-91.866241f, 18.441000f,-91.605003f,
                    18.450191f,-91.519592f);
            poly[136] = new TzPolygon(18.102540f,-91.509560f, 18.103054f,-91.500839f, 18.063332f,-91.321121f, 17.976109f,-91.188614f, 17.967777f,-90.983063f,
                    17.817400f,-90.984420f, 17.817400f,-91.509560f);
            poly[137] = new TzPolygon(17.817400f,-90.982338f, 19.133561f,-90.983063f, 19.279676f,-90.800720f, 19.377647f,-90.723869f, 19.456861f,-90.696869f,
                    19.624315f,-90.675003f, 19.664564f,-90.691666f, 19.752035f,-90.659966f, 19.855726f,-90.518677f, 19.952974f,-90.466164f,
                    20.175255f,-90.494904f, 20.373875f,-90.462105f, 20.373875f,-88.229271f, 19.651943f,-89.418335f, 17.817400f,-89.430550f);
            poly[138] = new TzPolygon(17.817400f,-89.145419f, 17.944826f,-89.145370f, 18.003643f,-89.028137f, 17.955568f,-88.983604f, 17.957127f,-88.941589f,
                    17.866501f,-88.843170f, 17.927467f,-88.847427f, 17.979416f,-88.779533f, 18.033674f,-88.755753f, 18.063341f,-88.699089f,
                    18.233849f,-88.604652f, 18.304064f,-88.591042f, 18.351543f,-88.545418f, 18.462267f,-88.512932f, 18.493881f,-88.475601f,
                    18.479595f,-88.442116f, 18.496557f,-88.390724f, 18.485069f,-88.305504f, 18.459763f,-88.288834f, 18.380232f,-88.389305f,
                    18.345596f,-88.378067f, 18.366434f,-88.314697f, 18.295521f,-88.363731f, 18.346025f,-88.288086f, 18.352005f,-88.203300f,
                    18.329401f,-88.211868f, 18.377310f,-88.095306f, 18.204525f,-88.080856f, 17.968336f,-88.146545f, 17.917549f,-88.200462f,
                    17.817400f,-88.211932f);
            poly[139] = new TzPolygon(-3.949543f,-80.230945f, -4.380644f,-80.230945f, -4.470112f,-80.334671f, -4.482847f,-80.388313f, -4.436912f,-80.443405f,
                    -4.370888f,-80.443459f, -4.200802f,-80.305130f, -4.212125f,-80.406708f, -4.194497f,-80.443970f, -4.122208f,-80.444138f,
                    -4.126984f,-80.460213f, -4.083902f,-80.481392f, -4.054242f,-80.475357f, -3.998211f,-80.439491f, -3.984066f,-80.397552f,
                    -4.017959f,-80.286133f, -3.951837f,-80.234909f);
            poly[140] = new TzPolygon(-3.478404f,-80.230945f, -3.465259f,-80.239456f, -3.453752f,-80.230945f);
            poly[141] = new TzPolygon(-3.453752f,-80.336407f, -3.404815f,-80.304291f, -3.435920f,-80.286293f, -3.437323f,-80.230945f, -3.453752f,-80.230945f);
            poly[142] = new TzPolygon(-4.285207f,-80.136307f, -4.294097f,-80.169083f, -4.338235f,-80.181778f, -4.380644f,-80.230945f, -4.285207f,-80.230945f);
            poly[143] = new TzPolygon(-4.393865f,-79.895477f, -4.390754f,-79.961990f, -4.305867f,-80.060310f, -4.285207f,-80.136307f, -4.285207f,-79.895477f);
            poly[144] = new TzPolygon(-3.478404f,-80.230945f, -3.503282f,-80.214836f, -3.589099f,-80.211609f, -3.598811f,-80.192177f, -3.771819f,-80.189613f,
                    -3.806996f,-80.162407f, -3.904780f,-80.153610f, -3.949543f,-80.230945f);
            poly[145] = new TzPolygon(-3.437323f,-80.230945f, -3.437626f,-80.219017f, -3.453752f,-80.230945f);
            poly[146] = new TzPolygon(-4.393893f,-79.895452f, -4.393893f,-79.723465f, -4.461247f,-79.723465f, -4.486319f,-79.811897f);
            poly[147] = new TzPolygon(-3.789106f,-79.723465f, -3.789106f,-78.378053f, -3.949200f,-78.499008f, -4.129074f,-78.570992f, -4.255292f,-78.571739f,
                    -4.319386f,-78.627472f, -4.447324f,-78.609093f, -4.496534f,-78.620842f, -4.653685f,-78.736069f, -4.680411f,-78.837601f,
                    -4.720123f,-78.881432f, -4.798948f,-78.919365f, -4.825415f,-78.912537f, -4.884890f,-78.962830f, -4.973155f,-78.993011f,
                    -4.998823f,-79.036835f, -4.969901f,-79.072609f, -4.967359f,-79.260353f, -4.901521f,-79.296715f, -4.884431f,-79.342308f,
                    -4.839324f,-79.357605f, -4.798517f,-79.416222f, -4.621288f,-79.479218f, -4.528807f,-79.481827f, -4.513120f,-79.507690f,
                    -4.527785f,-79.541161f, -4.434916f,-79.630592f, -4.461247f,-79.723465f);
            poly[148] = new TzPolygon(-3.789106f,-78.378053f, -3.787185f,-78.376602f, -3.429298f,-78.319481f, -3.410476f,-78.286293f, -3.428695f,-78.248566f,
                    -3.534078f,-78.231964f, -3.511582f,-78.189163f, -3.522452f,-78.136551f, -3.479217f,-78.122787f, -3.388964f,-78.190887f,
                    -3.354459f,-78.189713f, -3.281394f,-78.107086f, -3.219529f,-78.090576f, -3.221404f,-78.055809f, -3.135654f,-77.996758f,
                    -2.997541f,-77.824051f, -2.751672f,-77.101025f, -3.789106f,-77.101025f);
            poly[149] = new TzPolygon(0.322207f,-77.101025f, 0.373783f,-77.127701f, 0.351608f,-77.253693f, 0.387026f,-77.373215f, 0.361558f,-77.403084f,
                    0.394914f,-77.464554f, 0.532069f,-77.492912f, 0.599755f,-77.480370f, 0.631140f,-77.500877f, 0.728262f,-77.697075f,
                    0.752383f,-77.697990f, 0.789353f,-77.651695f, 0.817240f,-77.673790f, 0.839879f,-77.714874f, 0.796523f,-77.845825f,
                    0.817894f,-77.974037f, 0.913911f,-78.121933f, 0.992448f,-78.197739f, 1.044840f,-78.347038f, 1.149025f,-78.436317f,
                    1.195197f,-78.551216f, 1.265220f,-78.642609f, 1.344007f,-78.695450f, 1.439020f,-78.815991f, 1.439020f,-77.101025f);
            poly[150] = new TzPolygon(-1.175043f,-77.101025f, -1.175043f,-75.428273f, -1.536144f,-75.538368f, -1.586110f,-75.619064f, -2.128139f,-76.044701f,
                    -2.590585f,-76.627319f, -2.751672f,-77.101025f);
            poly[151] = new TzPolygon(0.084698f,-75.789804f, 0.174338f,-75.901634f, 0.349403f,-76.040146f, 0.347009f,-76.097382f, 0.393933f,-76.132187f,
                    0.398467f,-76.210838f, 0.441074f,-76.269150f, 0.384156f,-76.402611f, 0.247996f,-76.404381f, 0.258348f,-76.542290f,
                    0.232862f,-76.595444f, 0.265786f,-76.640106f, 0.285671f,-76.728859f, 0.254418f,-76.759842f, 0.264782f,-76.807541f,
                    0.241906f,-76.847427f, 0.273499f,-77.036171f, 0.292625f,-77.085724f, 0.322207f,-77.101025f, 1.439020f,-77.101025f,
                    1.439020f,-75.789804f);
            poly[152] = new TzPolygon(-1.175043f,-75.430108f, -0.955734f,-75.364357f, -0.946045f,-75.347046f, -0.979712f,-75.302940f, -0.970688f,-75.184586f,
                    -0.931737f,-75.226662f, -0.873124f,-75.214279f, -0.710882f,-75.280167f, -0.682805f,-75.257668f, -0.646341f,-75.280113f,
                    -0.610052f,-75.235100f, -0.580948f,-75.252991f, -0.534989f,-75.244949f, -0.502921f,-75.268776f, -0.516758f,-75.285599f,
                    -0.484655f,-75.298935f, -0.480651f,-75.337029f, -0.441433f,-75.351303f, -0.452537f,-75.375656f, -0.423733f,-75.414513f,
                    -0.328686f,-75.449150f, -0.326349f,-75.535988f, -0.263391f,-75.622055f, -0.108895f,-75.621948f, -0.124356f,-75.557976f,
                    -0.109977f,-75.511528f, -0.148676f,-75.411354f, -0.125134f,-75.373146f, -0.141843f,-75.358955f, -0.133623f,-75.304291f,
                    -0.020797f,-75.234169f, -0.012977f,-75.207390f, -0.033289f,-75.134194f, -1.175043f,-75.134194f);
            poly[153] = new TzPolygon(-0.033289f,-75.134194f, -0.012977f,-75.207390f, -0.093691f,-75.288200f, -0.077917f,-75.413094f, -0.013688f,-75.534454f,
                    -0.012861f,-75.577744f, 0.043680f,-75.573532f, 0.065394f,-75.598259f, 0.064395f,-75.733643f, 0.084698f,-75.789804f,
                    0.131988f,-75.789804f, 0.131988f,-75.134194f);
            poly[154] = new TzPolygon(-0.498862f,-74.478584f, -0.495678f,-74.492722f, -0.472272f,-74.497368f, -0.479466f,-74.519905f, -0.399740f,-74.575119f,
                    -0.392033f,-74.605461f, -0.366080f,-74.603271f, -0.289786f,-74.801125f, -0.253204f,-74.775261f, -0.151394f,-74.814339f,
                    -0.141831f,-74.840340f, -0.195045f,-74.903519f, -0.038623f,-75.114975f, -0.033289f,-75.134194f, 0.131988f,-75.134194f,
                    0.131988f,-74.478584f);
            poly[155] = new TzPolygon(7.110721f,-77.760304f, 7.220824f,-77.886818f, 7.459217f,-77.808762f, 7.460357f,-77.766678f, 7.508337f,-77.718857f,
                    7.110721f,-77.718857f);
            poly[156] = new TzPolygon(7.508337f,-77.718857f, 7.636698f,-77.768585f, 7.644825f,-77.766285f, 7.644825f,-77.718857f);
            poly[157] = new TzPolygon(7.644825f,-77.475784f, 7.508054f,-77.575119f, 7.545730f,-77.618134f, 7.644825f,-77.659527f);
            poly[158] = new TzPolygon(8.973391f,-82.738289f, 8.931086f,-82.713997f, 8.908242f,-82.738289f);
            poly[159] = new TzPolygon(9.648608f,-82.738289f, 9.632731f,-82.628998f, 9.545482f,-82.555992f, 9.561613f,-82.599884f, 9.502308f,-82.611656f,
                    9.496463f,-82.644180f, 9.510866f,-82.696899f, 9.541251f,-82.699326f, 9.572253f,-82.738289f);
            poly[160] = new TzPolygon(7.644825f,-77.766285f, 7.724392f,-77.743767f, 7.727368f,-77.717773f, 7.674093f,-77.671753f, 7.644825f,-77.659527f);
            poly[161] = new TzPolygon(8.686544f,-77.500851f, 8.663995f,-77.450073f, 8.681456f,-77.356674f, 8.523991f,-77.446938f, 8.490494f,-77.429337f,
                    8.474414f,-77.442787f, 8.464150f,-77.390327f, 8.372615f,-77.334145f, 8.273217f,-77.320816f, 8.226646f,-77.294014f,
                    8.214750f,-77.258072f, 8.143389f,-77.227333f, 8.036658f,-77.222099f, 7.979983f,-77.178925f, 7.934307f,-77.174110f,
                    7.903454f,-77.327362f, 7.843107f,-77.352913f, 7.740014f,-77.316811f, 7.714838f,-77.424934f, 7.644825f,-77.475784f,
                    7.644825f,-77.659527f, 8.686544f,-77.659527f);
            poly[162] = new TzPolygon(19.974030f,-75.137245f, 19.973766f,-75.087006f, 19.910521f,-75.086510f, 19.894085f,-75.164352f, 19.899225f,-75.167877f,
                    19.921700f,-75.164650f, 19.945997f,-75.099556f);
            poly[163] = new TzPolygon(19.918797f,-75.194454f, 19.913023f,-75.188217f, 19.903872f,-75.232292f, 19.921410f,-75.232346f, 19.973915f,-75.190788f,
                    19.974030f,-75.159943f, 19.955669f,-75.171356f);
            poly[164] = new TzPolygon(-14.962502f,-69.362042f, -14.886602f,-69.346779f, -14.803955f,-69.362801f, -14.753146f,-69.243797f, -14.583533f,-69.225487f,
                    -14.584173f,-69.149040f, -14.507678f,-69.152466f, -14.387169f,-68.979767f, -14.300499f,-68.996376f, -14.236923f,-68.981529f,
                    -14.210267f,-68.840683f, -14.065045f,-68.880791f, -13.979676f,-68.964996f, -13.875121f,-68.959709f, -13.799886f,-69.000000f,
                    -13.768576f,-68.987770f, -13.718650f,-69.050804f, -13.654098f,-69.075859f, -13.652464f,-68.997284f, -13.606932f,-69.005989f,
                    -13.579751f,-68.975021f, -13.485863f,-68.941727f, -13.263703f,-68.955040f, -13.254140f,-68.939102f, -13.197393f,-68.966759f,
                    -13.132371f,-68.950104f, -13.142099f,-68.969093f, -13.042745f,-68.943016f, -13.000739f,-68.970032f, -12.851520f,-68.961189f,
                    -12.841767f,-68.932381f, -12.794694f,-68.915665f, -12.796310f,-68.893433f, -12.751774f,-68.876312f, -12.749722f,-68.842049f,
                    -12.734070f,-68.847608f, -12.734070f,-67.557743f, -14.962502f,-67.557743f);
            poly[165] = new TzPolygon(-10.505639f,-70.622336f, -10.999892f,-70.620865f, -10.934457f,-70.520027f, -10.996594f,-70.453125f, -11.038018f,-70.438477f,
                    -11.070407f,-70.308716f, -11.042210f,-70.158379f, -10.986415f,-70.093704f, -10.993313f,-70.065285f, -10.920966f,-69.933640f,
                    -10.929839f,-69.769325f, -10.974780f,-69.738518f, -10.941715f,-69.576485f, -11.407184f,-69.287953f, -12.734070f,-69.287953f,
                    -12.734070f,-71.018164f, -10.505639f,-71.018164f);
            poly[166] = new TzPolygon(-11.406474f,-69.287953f, -10.956658f,-69.566444f, -10.951978f,-69.433586f, -10.928989f,-69.392899f, -10.947912f,-69.287953f);
            poly[167] = new TzPolygon(-11.407184f,-69.287953f, -11.993988f,-68.924210f, -12.520543f,-68.677986f, -12.611807f,-68.764183f, -12.648307f,-68.769394f,
                    -12.643641f,-68.749847f, -12.671489f,-68.727699f, -12.720067f,-68.750259f, -12.727921f,-68.849792f, -12.734070f,-68.847608f,
                    -12.734070f,-69.287953f);
            poly[168] = new TzPolygon(-10.947969f,-69.287953f, -10.505639f,-69.287953f, -10.505639f,-67.557743f, -10.523080f,-67.593521f, -10.598266f,-67.632622f,
                    -10.628266f,-67.684845f, -10.706590f,-67.715378f, -10.715875f,-67.738098f, -10.662381f,-67.810921f, -10.660545f,-68.020660f,
                    -10.726215f,-68.119080f, -10.759214f,-68.114792f, -10.986765f,-68.283340f, -11.012581f,-68.342506f, -11.002431f,-68.367699f,
                    -11.041128f,-68.414558f, -11.045891f,-68.512932f, -11.110317f,-68.587486f, -11.143052f,-68.738495f, -11.132725f,-68.774811f,
                    -11.006585f,-68.750626f, -10.989958f,-68.786606f, -11.023437f,-68.870674f);
            poly[169] = new TzPolygon(-8.909953f,-73.036432f, -8.909953f,-72.748374f, -9.411630f,-72.748374f, -9.411645f,-73.200569f, -9.363455f,-73.188599f,
                    -9.309076f,-73.102005f, -9.281900f,-73.110352f, -9.236690f,-73.075111f, -9.223105f,-73.009613f, -9.195173f,-73.003883f,
                    -9.178299f,-73.026161f, -9.146063f,-72.957748f, -8.985424f,-72.942085f, -8.979542f,-72.969238f, -8.916600f,-72.999596f);
            poly[170] = new TzPolygon(-8.081659f,-73.613479f, -8.056629f,-73.628349f, -8.034470f,-73.615982f, -8.006311f,-73.639366f, -8.013808f,-73.668312f,
                    -7.955156f,-73.705551f, -7.966027f,-73.727142f, -7.909289f,-73.772385f, -7.892372f,-73.754929f, -7.861796f,-73.762833f,
                    -7.878897f,-73.736214f, -7.857770f,-73.678047f, -7.781493f,-73.679512f, -7.741845f,-73.715858f, -7.717088f,-73.818474f,
                    -7.667229f,-73.839005f, -7.676264f,-73.866798f, -7.640391f,-73.900124f, -7.604479f,-73.887726f, -7.560224f,-73.978951f,
                    -7.534207f,-73.982819f, -7.533353f,-73.941467f, -7.474086f,-73.910133f, -7.357299f,-73.951225f, -7.377548f,-73.935127f,
                    -7.361791f,-73.922287f, -7.385827f,-73.903893f, -7.389232f,-73.863129f, -7.353753f,-73.853004f, -7.337423f,-73.763039f,
                    -7.353844f,-73.753838f, -7.314267f,-73.698927f, -7.314267f,-73.613479f);
            poly[171] = new TzPolygon(-8.081659f,-73.613479f, -8.135580f,-73.581444f, -8.162896f,-73.595161f, -8.222554f,-73.570686f, -8.240333f,-73.587227f,
                    -8.268299f,-73.524139f, -8.349349f,-73.542610f, -8.427393f,-73.442848f, -8.431799f,-73.405624f, -8.469974f,-73.387787f,
                    -8.474128f,-73.331306f, -8.616658f,-73.341301f, -8.610457f,-73.319069f, -8.690625f,-73.253639f, -8.698244f,-73.166626f,
                    -8.819424f,-73.112099f, -8.841410f,-73.076958f, -8.905790f,-73.059502f, -8.909953f,-73.036432f, -8.909953f,-73.613479f);
            poly[172] = new TzPolygon(-7.556756f,-72.748374f, -7.314267f,-73.324110f, -7.314267f,-72.748374f);
            poly[173] = new TzPolygon(-9.411383f,-72.748374f, -9.411629f,-72.716133f, -9.440160f,-72.695206f, -9.456212f,-72.575394f, -9.491327f,-72.520401f,
                    -9.477214f,-72.407944f, -9.494834f,-72.356781f, -9.544070f,-72.318436f, -9.539741f,-72.283630f, -9.603440f,-72.288231f,
                    -9.616149f,-72.252869f, -9.751422f,-72.262543f, -9.798193f,-72.151520f, -9.830367f,-72.163101f, -9.874979f,-72.136070f,
                    -9.931405f,-72.174530f, -9.966476f,-72.149704f, -10.000307f,-72.180527f, -10.000164f,-71.376266f, -9.966539f,-71.342262f,
                    -9.992343f,-71.298241f, -9.963224f,-71.252769f, -9.967955f,-71.214539f, -9.871908f,-71.157684f, -9.815752f,-71.051483f,
                    -9.816392f,-71.018164f, -10.505639f,-71.018164f, -10.505639f,-72.748374f);
            poly[174] = new TzPolygon(-7.999065f,-71.018164f, -7.603333f,-72.637787f, -7.556756f,-72.748374f, -7.314267f,-72.748374f, -7.314267f,-71.018164f);
            poly[175] = new TzPolygon(-7.314267f,-73.698927f, -7.311821f,-73.695534f, -7.228169f,-73.716560f, -7.206896f,-73.752350f, -7.114283f,-73.798927f,
                    -7.314267f,-73.324110f);
            poly[176] = new TzPolygon(-7.314267f,-73.324110f, -7.114283f,-73.798927f, -7.045753f,-73.756783f, -6.978029f,-73.761124f, -6.964259f,-73.743904f,
                    -6.936004f,-73.760742f, -6.754025f,-73.638649f, -6.721881f,-73.561317f, -6.675698f,-73.521103f, -6.636059f,-73.379890f,
                    -6.593249f,-73.352615f, -6.588794f,-73.227524f, -6.564562f,-73.221809f, -6.576919f,-73.206200f, -6.545561f,-73.181831f,
                    -6.522500f,-73.187897f, -6.531010f,-73.163139f, -6.510502f,-73.135391f, -6.410998f,-73.103951f, -6.380036f,-73.136299f,
                    -6.276932f,-73.161118f, -6.220162f,-73.220734f, -6.183438f,-73.217094f, -6.149736f,-73.247520f, -6.036728f,-73.237602f,
                    -6.005540f,-73.186890f, -5.944828f,-73.187485f, -5.868042f,-73.152145f, -5.864458f,-73.116341f, -5.831904f,-73.112511f,
                    -5.795653f,-73.052917f, -5.733648f,-73.027985f, -5.727990f,-73.000153f, -5.718581f,-72.998147f, -5.718581f,-72.748374f,
                    -7.314267f,-72.748374f);
            poly[177] = new TzPolygon(-5.718581f,-72.998147f, -5.661519f,-72.985985f, -5.657653f,-72.959846f, -5.621666f,-72.975800f, -5.541954f,-72.938850f,
                    -5.522201f,-72.961174f, -5.466101f,-72.959038f, -5.271058f,-72.860428f, -5.178299f,-72.868996f, -5.166781f,-72.887779f,
                    -5.144009f,-72.868683f, -5.138809f,-72.815865f, -5.102843f,-72.818893f, -5.112987f,-72.786400f, -5.076099f,-72.756783f,
                    -5.081913f,-72.748374f, -5.718581f,-72.748374f);
            poly[178] = new TzPolygon(-5.081913f,-72.748374f, -5.087831f,-72.739815f, -5.051294f,-72.728912f, -5.046453f,-72.671684f, -5.062986f,-72.657043f,
                    -5.044140f,-72.642456f, -5.062412f,-72.641739f, -5.037378f,-72.629326f, -5.051067f,-72.620918f, -4.994240f,-72.609428f,
                    -4.998320f,-72.584114f, -4.955352f,-72.551384f, -4.960766f,-72.522514f, -4.933682f,-72.522591f, -4.949840f,-72.496605f,
                    -4.933291f,-72.489006f, -4.952075f,-72.483963f, -4.914283f,-72.451492f, -4.890558f,-72.470100f, -4.900901f,-72.415550f,
                    -4.876889f,-72.423164f, -4.873602f,-72.382805f, -4.833650f,-72.390030f, -4.824298f,-72.359467f, -4.804676f,-72.371552f,
                    -4.793141f,-72.340286f, -4.812173f,-72.323517f, -4.779973f,-72.327248f, -4.790639f,-72.306953f, -4.771528f,-72.279182f,
                    -4.798799f,-72.271347f, -4.765688f,-72.256516f, -4.781855f,-72.243195f, -4.747636f,-72.208366f, -4.764156f,-72.194138f,
                    -4.711623f,-72.140190f, -4.734656f,-72.125175f, -4.669526f,-72.080383f, -4.674385f,-72.059776f, -4.622751f,-72.041901f,
                    -4.645379f,-72.005608f, -4.603489f,-71.986137f, -4.608080f,-71.947327f, -4.529864f,-71.919075f, -4.537737f,-71.885345f,
                    -4.514680f,-71.905708f, -4.520790f,-71.883269f, -5.718581f,-71.883269f, -5.718581f,-72.748374f);
            poly[179] = new TzPolygon(-4.520790f,-71.883269f, -4.525991f,-71.864166f, -4.482516f,-71.785301f, -4.502906f,-71.764648f, -4.467003f,-71.751259f,
                    -4.510228f,-71.706650f, -4.502669f,-71.660240f, -4.470958f,-71.655777f, -4.502782f,-71.648895f, -4.466942f,-71.616898f,
                    -4.509994f,-71.634674f, -4.528489f,-71.602493f, -4.476842f,-71.557243f, -4.481730f,-71.536087f, -4.463025f,-71.537170f,
                    -4.485116f,-71.493538f, -4.437187f,-71.507515f, -4.457056f,-71.485077f, -4.433681f,-71.477852f, -4.449295f,-71.438721f,
                    -4.428291f,-71.437622f, -4.435384f,-71.412636f, -4.476455f,-71.434006f, -4.426210f,-71.388596f, -4.426182f,-71.345688f,
                    -4.463430f,-71.309380f, -4.417793f,-71.319450f, -4.438925f,-71.275757f, -4.383639f,-71.267281f, -4.384397f,-71.228935f,
                    -4.406504f,-71.222954f, -4.378686f,-71.200806f, -4.423379f,-71.193718f, -4.395256f,-71.184296f, -4.403122f,-71.150345f,
                    -4.381007f,-71.148781f, -4.408303f,-71.118126f, -4.374323f,-71.098969f, -4.373039f,-71.079475f, -4.394360f,-71.075851f,
                    -4.367794f,-71.049774f, -4.400165f,-71.039383f, -4.392887f,-71.018164f, -5.718581f,-71.018164f, -5.718581f,-71.883269f);
            poly[180] = new TzPolygon(-9.537873f,-67.557743f, -7.314267f,-68.557295f, -7.314267f,-67.557743f);
            poly[181] = new TzPolygon(-9.816392f,-71.018164f, -9.816863f,-70.993629f, -9.748659f,-70.963226f, -9.740886f,-70.923279f, -9.643346f,-70.835907f,
                    -9.638897f,-70.793648f, -9.605133f,-70.757416f, -9.560698f,-70.750572f, -9.570500f,-70.729500f, -9.519578f,-70.653625f,
                    -9.441596f,-70.595451f, -9.423923f,-70.496841f, -9.463558f,-70.505318f, -9.459169f,-70.524567f, -9.504990f,-70.505760f,
                    -9.514140f,-70.544930f, -9.538113f,-70.543312f, -9.533077f,-70.571228f, -9.571807f,-70.555008f, -9.566742f,-70.588318f,
                    -9.548681f,-70.589905f, -9.562513f,-70.600685f, -9.640620f,-70.585083f, -9.714756f,-70.525406f, -9.765681f,-70.536926f,
                    -9.820790f,-70.624374f, -10.505639f,-70.622336f, -10.505639f,-71.018164f);
            poly[182] = new TzPolygon(-7.314267f,-68.557295f, -9.537873f,-67.557743f, -9.066389f,-68.657227f, -8.160557f,-70.357224f, -7.999065f,-71.018164f,
                    -7.314267f,-71.018164f);
            poly[183] = new TzPolygon(-4.122895f,-70.585611f, -4.177015f,-70.585611f, -4.186801f,-70.624802f, -4.131484f,-70.614380f, -4.123582f,-70.638016f,
                    -4.162750f,-70.649178f, -4.140761f,-70.668533f, -4.204496f,-70.678581f, -4.155879f,-70.755440f, -4.218067f,-70.845512f,
                    -4.224252f,-70.814064f, -4.249677f,-70.829323f, -4.248131f,-70.860771f, -4.275789f,-70.843277f, -4.288330f,-70.875473f,
                    -4.316332f,-70.872681f, -4.354126f,-70.932236f, -4.381441f,-70.935768f, -4.378348f,-70.966103f, -4.342616f,-70.991600f,
                    -4.385564f,-70.996811f, -4.392887f,-71.018164f, -4.122895f,-71.018164f);
            poly[184] = new TzPolygon(-4.179140f,-70.585611f, -4.171512f,-70.563576f, -4.209821f,-70.572884f, -4.152786f,-70.539200f, -4.135607f,-70.550735f,
                    -4.148835f,-70.507004f, -4.198311f,-70.505142f, -4.161055f,-70.484909f, -4.175988f,-70.463715f, -4.161035f,-70.432953f,
                    -4.131001f,-70.432320f, -4.136625f,-70.373421f, -4.178426f,-70.340103f, -4.142276f,-70.321991f, -4.170878f,-70.285614f,
                    -4.234399f,-70.279564f, -4.249172f,-70.309601f, -4.272508f,-70.283813f, -4.287740f,-70.291779f, -4.272726f,-70.247887f,
                    -4.304113f,-70.265289f, -4.317503f,-70.226036f, -4.298046f,-70.215347f, -4.361327f,-70.195244f, -4.329740f,-70.153058f,
                    -4.920738f,-70.153058f, -4.920738f,-70.585611f);
            poly[185] = new TzPolygon(-4.327544f,-70.153058f, -4.304821f,-70.171371f, -4.277298f,-70.159073f, -4.278328f,-70.153058f);
            poly[186] = new TzPolygon(-5.688841f,-69.287953f, -4.225544f,-69.945732f, -4.199977f,-69.926071f, -4.122895f,-69.911822f, -4.122895f,-69.287953f);
            poly[187] = new TzPolygon(-4.122895f,-70.023133f, -4.218711f,-69.947662f, -4.340210f,-69.976257f, -4.386697f,-69.956879f, -4.366479f,-70.029999f,
                    -4.328458f,-70.046555f, -4.314863f,-70.078880f, -4.291994f,-70.042496f, -4.288196f,-70.095390f, -4.256014f,-70.107361f,
                    -4.284266f,-70.118378f, -4.275466f,-70.153058f, -4.122895f,-70.153058f);
            poly[188] = new TzPolygon(-4.327544f,-70.153058f, -4.328913f,-70.151955f, -4.329604f,-70.153058f);
            poly[189] = new TzPolygon(-4.122895f,-70.024382f, -4.122895f,-69.911822f, -4.199977f,-69.926071f, -4.225544f,-69.945732f);
            poly[190] = new TzPolygon(-5.688841f,-69.287953f, -7.314267f,-68.557295f, -7.314267f,-69.287953f);
            poly[191] = new TzPolygon(-12.252600f,-64.480453f, -12.252600f,-63.688177f, -12.466648f,-63.688177f, -12.457861f,-63.712124f, -12.468522f,-63.875038f,
                    -12.490460f,-63.864422f, -12.557160f,-63.936729f, -12.509860f,-64.047318f, -12.516514f,-64.110321f, -12.493826f,-64.127228f,
                    -12.528850f,-64.151604f, -12.486083f,-64.175133f, -12.475866f,-64.214828f, -12.511484f,-64.277832f, -12.473837f,-64.293434f,
                    -12.466940f,-64.373398f, -12.365522f,-64.492973f, -12.299220f,-64.468987f);
            poly[192] = new TzPolygon(-9.542698f,-66.590351f, -9.665478f,-66.590351f, -9.675556f,-66.621948f, -9.753334f,-66.689728f, -9.741945f,-66.745285f,
                    -9.791113f,-66.769180f, -9.838335f,-66.830841f, -9.542698f,-67.546070f);
            poly[193] = new TzPolygon(-9.542698f,-67.557743f, -9.542698f,-67.539856f, -9.933536f,-66.622993f, -9.968781f,-66.715080f, -10.082191f,-66.854408f,
                    -10.080641f,-66.883392f, -10.179117f,-66.966919f, -10.194456f,-67.004974f, -10.254179f,-67.029045f, -10.287621f,-67.134956f,
                    -10.312646f,-67.139038f, -10.339109f,-67.185883f, -10.312380f,-67.234024f, -10.316207f,-67.315147f, -10.374251f,-67.327187f,
                    -10.371510f,-67.414490f, -10.449774f,-67.443138f, -10.505639f,-67.557743f);
            poly[194] = new TzPolygon(-9.665478f,-66.590351f, -9.889741f,-66.590351f, -9.893160f,-66.616264f, -9.933536f,-66.622993f, -9.838057f,-66.830566f,
                    -9.791113f,-66.769180f, -9.741945f,-66.745285f, -9.753334f,-66.689728f, -9.675556f,-66.621948f);
            poly[195] = new TzPolygon(-9.542698f,-66.423188f, -9.582500f,-66.468903f, -9.634445f,-66.493057f, -9.665478f,-66.590351f, -9.542698f,-66.590351f);
            poly[196] = new TzPolygon(-9.542698f,-65.688536f, -9.574446f,-65.750290f, -9.542698f,-65.787730f);
            poly[197] = new TzPolygon(-9.889741f,-66.590351f, -9.870115f,-66.441605f, -9.895280f,-66.422073f, -9.831524f,-66.322792f, -9.827606f,-66.205009f,
                    -9.785023f,-66.161263f, -9.785410f,-66.105194f, -9.809400f,-66.100914f, -9.772218f,-66.064217f, -9.806714f,-66.018387f,
                    -9.756597f,-65.872391f, -9.793812f,-65.859940f, -9.750115f,-65.809753f, -9.786165f,-65.798203f, -9.727339f,-65.776772f,
                    -9.770289f,-65.748405f, -9.748788f,-65.688576f, -9.802920f,-65.700424f, -9.778728f,-65.669052f, -9.821809f,-65.629997f,
                    -9.823135f,-65.622960f, -10.897649f,-65.622960f, -10.897649f,-66.590351f);
            poly[198] = new TzPolygon(-12.252600f,-64.480453f, -12.229553f,-64.486122f, -12.241677f,-64.519432f, -12.186312f,-64.654251f, -12.098567f,-64.682610f,
                    -12.162370f,-64.724838f, -12.112558f,-64.734154f, -12.035035f,-64.797859f, -11.999366f,-64.992996f, -11.756610f,-65.047523f,
                    -11.741384f,-65.111992f, -11.697483f,-65.106125f, -11.776802f,-65.134804f, -11.745192f,-65.201180f, -11.679188f,-65.176147f,
                    -11.630753f,-65.184448f, -11.622048f,-65.160789f, -11.602897f,-65.204414f, -11.521255f,-65.217682f, -11.499572f,-65.299034f,
                    -11.392063f,-65.338058f, -11.340607f,-65.310402f, -11.321634f,-65.356300f, -11.269267f,-65.384552f, -11.239082f,-65.349472f,
                    -11.210585f,-65.383362f, -11.166992f,-65.390503f, -11.105047f,-65.317566f, -11.043823f,-65.336380f, -10.980406f,-65.289299f,
                    -10.948838f,-65.311256f, -10.897649f,-65.313344f, -10.897649f,-63.688177f, -12.252600f,-63.688177f);
            poly[199] = new TzPolygon(-9.823135f,-65.622960f, -9.834455f,-65.562904f, -9.806202f,-65.557266f, -9.793965f,-65.507294f, -9.717839f,-65.487793f,
                    -9.680567f,-65.433823f, -9.715076f,-65.359665f, -9.850740f,-65.289711f, -9.937713f,-65.326912f, -10.225882f,-65.280739f,
                    -10.297116f,-65.308052f, -10.365348f,-65.373650f, -10.433818f,-65.382385f, -10.479697f,-65.431038f, -10.597317f,-65.411125f,
                    -10.643403f,-65.424950f, -10.672103f,-65.374863f, -10.814088f,-65.394981f, -10.873999f,-65.314308f, -10.897649f,-65.313344f,
                    -10.897649f,-65.622960f);
        }
    }

    private static class Initializer3 {
        private static void init() {
            poly[200] = new TzPolygon(-13.530348f,-61.753394f, -13.521331f,-61.778309f, -13.540883f,-61.777035f, -13.539249f,-61.824284f, -13.442552f,-61.865635f,
                    -13.423884f,-61.915058f, -13.256899f,-62.108082f, -13.148521f,-62.108517f, -13.112125f,-62.165260f, -13.136970f,-62.173248f,
                    -13.118057f,-62.222023f, -13.150787f,-62.277477f, -13.130377f,-62.304527f, -13.145263f,-62.367844f, -13.129072f,-62.414120f,
                    -13.069615f,-62.464451f, -13.073346f,-62.553566f, -13.041165f,-62.637207f, -13.014486f,-62.631287f, -12.964700f,-62.674408f,
                    -12.997673f,-62.727123f, -12.992188f,-62.764427f, -13.022641f,-62.764473f, -12.946742f,-62.826378f, -12.950569f,-62.853107f,
                    -12.853908f,-62.923340f, -12.872954f,-62.938869f, -12.849501f,-62.996193f, -12.743629f,-63.058113f, -12.718821f,-63.046074f,
                    -12.652854f,-63.082352f, -12.643157f,-63.144825f, -12.686261f,-63.233047f, -12.714272f,-63.247456f, -12.704915f,-63.326565f,
                    -12.651011f,-63.426514f, -12.557039f,-63.481968f, -12.552314f,-63.544666f, -12.494612f,-63.611969f, -12.466648f,-63.688177f,
                    -12.252600f,-63.688177f, -12.252600f,-61.753394f);
            poly[201] = new TzPolygon(-13.607551f,-60.918469f, -13.607551f,-60.665537f, -13.691502f,-60.752197f, -13.617332f,-60.906582f);
            poly[202] = new TzPolygon(-14.962502f,-60.253795f, -14.624276f,-60.256886f, -14.554859f,-60.337593f, -14.501270f,-60.336891f, -14.420212f,-60.397865f,
                    -14.368609f,-60.388260f, -14.307475f,-60.442390f, -14.234574f,-60.442890f, -14.181334f,-60.481590f, -14.092428f,-60.468105f,
                    -14.069685f,-60.421234f, -14.030080f,-60.392204f, -13.999554f,-60.399578f, -13.992455f,-60.378464f, -13.982682f,-60.415760f,
                    -13.967130f,-60.425568f, -13.958144f,-60.399296f, -13.933000f,-60.441448f, -13.879889f,-60.444809f, -13.886312f,-60.468040f,
                    -13.864545f,-60.452255f, -13.853038f,-60.477314f, -13.800958f,-60.467716f, -13.802940f,-60.534744f, -13.786082f,-60.527615f,
                    -13.780064f,-60.575661f, -13.748962f,-60.597363f, -13.748438f,-60.670753f, -13.691502f,-60.752197f, -13.607551f,-60.665537f,
                    -13.607551f,-59.818611f, -14.962502f,-59.818611f);
            poly[203] = new TzPolygon(-13.530348f,-61.753394f, -13.539737f,-61.727451f, -13.503797f,-61.669598f, -13.512298f,-61.620438f, -13.494131f,-61.577538f,
                    -13.513676f,-61.574841f, -13.554156f,-61.485764f, -13.537685f,-61.420761f, -13.473181f,-61.329777f, -13.525144f,-61.249054f,
                    -13.527482f,-61.218952f, -13.505798f,-61.210651f, -13.520514f,-61.139336f, -13.474869f,-61.126755f, -13.491400f,-61.087860f,
                    -13.463427f,-61.069042f, -13.477406f,-61.028282f, -13.486967f,-61.046299f, -13.541252f,-61.043530f, -13.538824f,-60.962227f,
                    -13.581305f,-60.950367f, -13.607551f,-60.910894f, -13.607551f,-61.753394f);
            poly[204] = new TzPolygon(-13.607551f,-60.665537f, -13.592501f,-60.650002f, -13.425835f,-60.381950f, -13.271946f,-60.351952f, -13.127224f,-60.268059f,
                    -13.047779f,-60.266945f, -12.972778f,-60.202507f, -12.938890f,-60.093895f, -12.884724f,-60.048058f, -12.714445f,-59.997505f,
                    -12.598057f,-59.894730f, -12.461668f,-59.863892f, -12.408056f,-59.820839f, -12.267502f,-59.887222f, -12.252600f,-59.887403f,
                    -12.252600f,-59.818611f, -13.607551f,-59.818611f);
            poly[205] = new TzPolygon(-9.542698f,-61.531111f, -9.565556f,-61.523338f, -9.626945f,-61.477501f, -9.709446f,-61.518890f, -9.726946f,-61.570839f,
                    -9.757223f,-61.537224f, -9.875000f,-61.517227f, -9.937500f,-61.537781f, -9.979445f,-61.526390f, -10.061111f,-61.571671f,
                    -10.144724f,-61.583336f, -10.176390f,-61.553062f, -10.262222f,-61.563896f, -10.425835f,-61.469452f, -10.690001f,-61.507782f,
                    -10.716391f,-61.461113f, -10.777500f,-61.477501f, -10.782223f,-61.523056f, -10.854168f,-61.505005f, -11.000834f,-61.527229f,
                    -11.001667f,-60.426949f, -11.044724f,-60.446945f, -11.052223f,-60.416672f, -11.112501f,-60.370003f, -11.075556f,-60.289452f,
                    -11.121389f,-60.179169f, -11.103889f,-60.145561f, -11.111113f,-60.069450f, -11.142223f,-59.996117f, -11.262501f,-59.974167f,
                    -11.384724f,-59.909729f, -11.534834f,-60.020538f, -11.598333f,-60.103889f, -11.753334f,-60.101669f, -11.898335f,-60.069450f,
                    -11.905556f,-59.986671f, -12.057779f,-59.934448f, -12.106668f,-59.889168f, -12.252600f,-59.884765f, -12.252600f,-63.688177f,
                    -9.542698f,-63.688177f);
            poly[206] = new TzPolygon(-9.535074f,-67.557743f, -9.542698f,-67.539856f, -9.542698f,-67.557743f);
            poly[207] = new TzPolygon(-9.542698f,-66.423188f, -9.518890f,-66.395844f, -9.399168f,-66.399170f, -9.423613f,-66.295563f, -9.402500f,-66.257233f,
                    -9.422779f,-66.151123f, -9.402500f,-65.953064f, -9.537224f,-65.784454f, -9.542698f,-65.781426f);
            poly[208] = new TzPolygon(-9.542698f,-65.690342f, -9.533890f,-65.671402f, -9.460835f,-65.652237f, -9.443887f,-65.622960f, -9.542698f,-65.622960f);
            poly[209] = new TzPolygon(-9.443887f,-65.622960f, -9.411945f,-65.567780f, -9.423613f,-65.505569f, -9.466946f,-65.486954f, -9.457500f,-65.447235f,
                    -9.398613f,-65.430283f, -9.321390f,-65.347778f, -9.248335f,-65.208893f, -9.297779f,-65.198624f, -9.321390f,-65.170288f,
                    -9.396389f,-65.163620f, -9.433056f,-65.121124f, -9.433056f,-65.076675f, -9.224167f,-64.906113f, -9.108334f,-64.923065f,
                    -9.031946f,-64.858063f, -8.985834f,-64.785278f, -8.983334f,-64.752502f, -9.019724f,-64.701675f, -9.027224f,-64.587784f,
                    -8.958057f,-64.504456f, -8.950001f,-64.463348f, -8.974445f,-64.418625f, -8.934446f,-64.373611f, -8.947224f,-64.302231f,
                    -8.930557f,-64.258347f, -8.956112f,-64.217224f, -8.930557f,-64.174728f, -8.966391f,-64.135010f, -8.959446f,-64.115280f,
                    -8.694168f,-64.137222f, -8.683334f,-64.106125f, -8.723333f,-64.090561f, -8.692780f,-64.009171f, -8.544445f,-63.920006f,
                    -8.471111f,-63.987785f, -8.428612f,-63.990562f, -8.321945f,-63.910835f, -8.279167f,-63.736389f, -8.200001f,-63.744446f,
                    -8.188983f,-63.688177f, -9.542698f,-63.688177f, -9.542698f,-65.622960f);
            poly[210] = new TzPolygon(-8.756756f,-59.818611f, -8.768612f,-61.611343f, -8.720556f,-61.606392f, -8.702223f,-61.625000f, -8.681112f,-61.726395f,
                    -8.730835f,-61.762779f, -8.742779f,-61.838890f, -8.848612f,-61.867783f, -8.875557f,-61.916389f, -8.851112f,-61.981117f,
                    -8.796946f,-62.021667f, -8.777500f,-62.134171f, -8.641390f,-62.176392f, -8.600557f,-62.169724f, -8.582224f,-62.197784f,
                    -8.584446f,-62.300560f, -8.364723f,-62.390282f, -8.341667f,-62.461670f, -8.366667f,-62.543335f, -8.275835f,-62.559448f,
                    -8.240002f,-62.623337f, -8.153057f,-62.670006f, -8.124723f,-62.665840f, -8.054724f,-62.733612f, -8.000557f,-62.850838f,
                    -8.000557f,-63.538338f, -8.080002f,-63.591667f, -8.168890f,-63.585556f, -8.188983f,-63.688177f, -4.122895f,-63.688177f,
                    -4.122895f,-59.818611f);
            poly[211] = new TzPolygon(-9.542698f,-61.531111f, -9.468334f,-61.556396f, -9.403891f,-61.544174f, -9.322779f,-61.615280f, -9.282223f,-61.587227f,
                    -9.239723f,-61.596115f, -9.226112f,-61.527504f, -9.105835f,-61.560562f, -8.903891f,-61.482506f, -8.825556f,-61.525558f,
                    -8.768612f,-61.611343f, -8.756756f,-59.818611f, -9.542698f,-59.818611f);
            poly[212] = new TzPolygon(-7.406572f,-58.062149f, -7.303056f,-58.171951f, -7.177778f,-58.181396f, -7.101667f,-58.217781f, -6.923612f,-58.416389f,
                    -6.832796f,-58.441745f, -6.832796f,-58.062149f);
            poly[213] = new TzPolygon(-8.756756f,-59.818611f, -8.748335f,-58.545280f, -8.701345f,-58.468208f, -8.541668f,-58.417229f, -8.412224f,-58.440559f,
                    -8.374168f,-58.395279f, -8.246668f,-58.333618f, -8.206112f,-58.341667f, -8.105001f,-58.304169f, -7.887778f,-58.375557f,
                    -7.818056f,-58.379723f, -7.622223f,-58.223335f, -7.570834f,-58.204170f, -7.508889f,-58.227501f, -7.449722f,-58.222778f,
                    -7.339168f,-58.135559f, -7.406616f,-58.062149f, -9.542698f,-58.062149f, -9.542698f,-59.818611f);
            poly[214] = new TzPolygon(-7.406616f,-58.062149f, -7.530556f,-57.978889f, -7.640000f,-57.939728f, -7.667778f,-57.903336f, -8.035833f,-57.789452f,
                    -8.096111f,-57.730003f, -8.156389f,-57.705284f, -8.207500f,-57.638062f, -8.446112f,-57.683334f, -8.495556f,-57.651115f,
                    -8.603889f,-57.646118f, -8.674446f,-57.600281f, -8.757223f,-57.596115f, -8.782778f,-57.489449f, -8.872223f,-57.373611f,
                    -8.916113f,-57.361389f, -8.951946f,-57.309448f, -9.055557f,-57.090561f, -9.228889f,-57.059174f, -9.263334f,-56.847504f,
                    -9.401945f,-56.776947f, -9.374168f,-56.678337f, -9.480907f,-56.445862f, -9.466946f,-56.461670f, -9.477882f,-56.305687f,
                    -9.542698f,-56.305687f, -9.542698f,-58.062149f);
            poly[215] = new TzPolygon(-6.832796f,-58.441745f, -6.723612f,-58.472229f, -6.660278f,-58.447502f, -6.572500f,-58.341667f, -6.483334f,-58.287224f,
                    -4.122895f,-57.192420f, -4.122895f,-56.305687f, -6.832796f,-56.305687f);
            poly[216] = new TzPolygon(-1.591035f,-72.576397f, -2.411379f,-72.576397f, -2.395664f,-72.618935f, -2.485649f,-72.670273f, -2.415711f,-72.707237f,
                    -2.458862f,-72.733040f, -2.420425f,-72.769363f, -2.476716f,-72.843300f, -2.500364f,-72.921318f, -2.466519f,-72.914421f,
                    -2.381909f,-72.961960f, -2.395864f,-72.991806f, -2.354620f,-73.020592f, -2.399816f,-73.043884f, -2.352064f,-73.060135f,
                    -2.359921f,-73.112183f, -2.330934f,-73.110275f, -2.275728f,-73.152603f, -2.235495f,-73.154869f, -2.224750f,-73.121803f,
                    -2.125317f,-73.058609f, -2.113319f,-73.095444f, -2.061768f,-73.086586f, -2.032011f,-73.113007f, -1.926637f,-73.099632f,
                    -1.891449f,-73.142975f, -1.833970f,-73.142593f, -1.774134f,-73.221901f, -1.823379f,-73.231239f, -1.831745f,-73.249229f,
                    -1.803697f,-73.249374f, -1.802760f,-73.292763f, -1.855431f,-73.297516f, -1.854823f,-73.314415f, -1.807109f,-73.384293f,
                    -1.820268f,-73.420891f, -1.769066f,-73.458450f, -1.740415f,-73.526627f, -1.659398f,-73.505325f, -1.600109f,-73.459732f,
                    -1.599102f,-73.490326f, -1.591035f,-73.490343f);
            poly[217] = new TzPolygon(-3.810203f,-70.674210f, -3.794675f,-70.703293f, -3.749730f,-70.674210f);
            poly[218] = new TzPolygon(-2.411379f,-72.576397f, -2.432802f,-72.518410f, -2.441359f,-72.409370f, -2.416131f,-72.382568f, -2.490426f,-72.346001f,
                    -2.460128f,-72.242683f, -2.433087f,-72.221146f, -2.444355f,-72.184059f, -2.427157f,-72.155380f, -2.468368f,-72.125641f,
                    -2.411918f,-72.109100f, -2.331185f,-72.035149f, -2.363740f,-71.983757f, -2.352144f,-71.933571f, -2.373359f,-71.907150f,
                    -2.311574f,-71.918991f, -2.300383f,-71.861038f, -2.186985f,-71.822296f, -2.195076f,-71.794373f, -2.128357f,-71.721519f,
                    -2.214259f,-71.706757f, -2.190725f,-71.628342f, -2.244560f,-71.500259f, -2.336429f,-71.483604f, -2.325699f,-71.462204f,
                    -2.272446f,-71.476303f, -2.263479f,-71.444160f, -2.346469f,-71.376152f, -2.397745f,-71.374855f, -2.376310f,-71.305107f,
                    -2.338442f,-71.284370f, -2.340907f,-71.213295f, -2.375733f,-71.164825f, -2.337188f,-71.146385f, -2.336031f,-71.114868f,
                    -2.287091f,-71.120728f, -2.264302f,-71.056938f, -2.297561f,-70.985634f, -2.205172f,-70.992981f, -2.207906f,-70.959839f,
                    -2.245373f,-70.928017f, -2.220152f,-70.849411f, -2.282944f,-70.821724f, -2.286644f,-70.766403f, -2.321627f,-70.740990f,
                    -2.345412f,-70.674210f, -2.856965f,-70.674210f, -2.856965f,-72.576397f);
            poly[219] = new TzPolygon(-0.498862f,-74.478584f, -0.510833f,-74.425423f, -0.560197f,-74.422043f, -0.555042f,-74.393112f, -0.669343f,-74.371933f,
                    -0.695191f,-74.342201f, -0.744934f,-74.378265f, -0.773775f,-74.349648f, -0.772973f,-74.318642f, -0.807196f,-74.317139f,
                    -0.796973f,-74.285713f, -0.847277f,-74.284378f, -0.842814f,-74.257713f, -0.899379f,-74.271629f, -0.884109f,-74.304985f,
                    -0.900235f,-74.317696f, -0.925591f,-74.277916f, -1.007108f,-74.265968f, -1.081051f,-74.073837f, -1.028274f,-74.032997f,
                    -1.122629f,-74.012756f, -1.105191f,-73.961731f, -1.143593f,-73.969093f, -1.149534f,-73.904510f, -1.250235f,-73.861404f,
                    -1.277225f,-73.776863f, -1.220120f,-73.750427f, -1.267377f,-73.731506f, -1.257736f,-73.681351f, -1.288155f,-73.648354f,
                    -1.282989f,-73.623734f, -1.343165f,-73.615700f, -1.339992f,-73.574409f, -1.376792f,-73.580627f, -1.429065f,-73.552078f,
                    -1.445080f,-73.586464f, -1.452448f,-73.538734f, -1.493765f,-73.526894f, -1.514284f,-73.490509f, -1.591035f,-73.490343f,
                    -1.591035f,-74.478584f);
            poly[220] = new TzPolygon(-4.122895f,-69.911822f, -3.398282f,-69.777878f, -1.591035f,-69.454808f, -1.591035f,-66.869835f, -4.122895f,-66.869835f);
            poly[221] = new TzPolygon(-2.345412f,-70.674210f, -2.351088f,-70.658272f, -2.398996f,-70.667244f, -2.399762f,-70.619942f, -2.473816f,-70.619781f,
                    -2.470489f,-70.550575f, -2.427985f,-70.583832f, -2.415387f,-70.562004f, -2.464849f,-70.508118f, -2.456409f,-70.461121f,
                    -2.525272f,-70.417572f, -2.493560f,-70.366203f, -2.498115f,-70.306747f, -2.525887f,-70.300110f, -2.541036f,-70.350479f,
                    -2.566795f,-70.350487f, -2.575475f,-70.316360f, -2.547501f,-70.245758f, -2.650035f,-70.213547f, -2.630361f,-70.172813f,
                    -2.697871f,-70.159874f, -2.705765f,-70.141975f, -2.644153f,-70.092926f, -2.732267f,-70.069054f, -2.741882f,-70.034164f,
                    -3.748916f,-70.674210f);
            poly[222] = new TzPolygon(-3.810203f,-70.674210f, -3.843400f,-70.612030f, -3.837487f,-70.564011f, -3.875614f,-70.528442f, -3.884690f,-70.485329f,
                    -3.849940f,-70.401398f, -3.808661f,-70.362617f, -3.804816f,-70.316185f, -3.871136f,-70.242592f, -3.888847f,-70.188881f,
                    -4.021096f,-70.157944f, -4.064720f,-70.068954f, -4.122895f,-70.023133f, -4.122895f,-70.674210f);
            poly[223] = new TzPolygon(0.940826f,-69.179530f, 0.936320f,-69.175423f, 0.919991f,-69.196327f, 0.885149f,-69.182999f, 0.868457f,-69.136986f,
                    0.844087f,-69.137047f, 0.827554f,-69.167068f, 0.769077f,-69.146103f, 0.730424f,-69.183502f, 0.642764f,-69.111931f,
                    0.638649f,-69.186417f, 0.601751f,-69.201538f, 0.609028f,-69.287651f, 0.648283f,-69.294975f, 0.620539f,-69.357117f,
                    0.734351f,-69.468208f, 0.685351f,-69.565781f, 0.623053f,-69.605736f, 0.672076f,-69.664055f, 0.615355f,-69.724617f,
                    0.622989f,-69.750923f, 0.584742f,-69.798370f, 0.591358f,-69.904106f, 0.567209f,-69.939087f, 0.582366f,-69.972984f,
                    0.545509f,-70.014008f, 0.553025f,-70.037354f, -0.134779f,-70.068024f, -0.315769f,-69.907867f, -0.335230f,-69.850311f,
                    -0.456756f,-69.730736f, -0.516707f,-69.593300f, -0.604281f,-69.586632f, -0.648225f,-69.551125f, -0.754771f,-69.608742f,
                    -0.812820f,-69.551628f, -0.835412f,-69.563354f, -0.863496f,-69.529922f, -0.936410f,-69.507874f, -0.997919f,-69.421928f,
                    -1.078478f,-69.431343f, -1.173310f,-69.375145f, -1.333702f,-69.368347f, -1.395636f,-69.386276f, -1.477611f,-69.452515f,
                    -1.552427f,-69.447906f, -1.591035f,-69.454808f, -1.591035f,-70.674210f, 0.940826f,-70.674210f);
            poly[224] = new TzPolygon(0.940826f,-69.179530f, 1.025505f,-69.256721f, 1.064014f,-69.342056f, 1.023687f,-69.416382f, 1.056308f,-69.455750f,
                    1.073588f,-69.608215f, 1.055641f,-69.700340f, 1.097106f,-69.720764f, 1.055002f,-69.817978f, 1.069752f,-69.854073f,
                    1.714919f,-69.855194f, 1.702608f,-69.778572f, 1.740834f,-69.705688f, 1.724115f,-69.660774f, 1.775197f,-69.555740f,
                    1.725671f,-69.394562f, 1.727905f,-68.772022f, 0.940826f,-68.772022f);
            poly[225] = new TzPolygon(1.727905f,-68.772022f, 1.730217f,-68.127747f, 1.747642f,-68.138367f, 1.733592f,-68.159653f, 1.748498f,-68.189339f,
                    1.789395f,-68.198952f, 1.781536f,-68.244621f, 1.831736f,-68.237373f, 1.841322f,-68.289551f, 1.888244f,-68.253487f,
                    2.037632f,-68.205444f, 1.980000f,-68.183838f, 1.951853f,-68.116913f, 1.784398f,-68.026573f, 1.747840f,-67.980881f,
                    1.750918f,-67.923531f, 1.812339f,-67.797462f, 2.075562f,-67.577995f, 2.141290f,-67.409798f, 2.114372f,-67.360504f,
                    1.915157f,-67.250252f, 1.732161f,-67.116821f, 1.532232f,-67.068146f, 1.265936f,-67.106468f, 1.170079f,-67.096664f,
                    1.224713f,-66.869835f, 0.940826f,-66.869835f, 0.940826f,-68.772022f);
            poly[226] = new TzPolygon(1.225646f,-66.869835f, 1.275092f,-66.893997f, 1.341588f,-66.880257f, 1.418306f,-66.926147f, 1.649490f,-66.977951f,
                    1.896638f,-67.063087f, 1.983099f,-67.123779f, 2.055729f,-67.103897f, 2.112754f,-67.113991f, 2.121075f,-67.156792f,
                    2.206756f,-67.192857f, 2.206756f,-66.869835f);
            poly[227] = new TzPolygon(2.206756f,-66.869835f, 2.206756f,-67.192857f, 2.250561f,-67.211296f, 2.344553f,-67.173134f, 2.391271f,-67.195045f,
                    2.435310f,-67.275841f, 2.568002f,-67.392540f, 2.621054f,-67.478973f, 2.669326f,-67.492493f, 2.671253f,-67.567322f,
                    2.728090f,-67.567192f, 2.812483f,-67.615616f, 2.801003f,-67.653290f, 2.812518f,-67.714523f, 2.840027f,-67.738533f,
                    2.834800f,-67.810768f, 2.789514f,-67.859230f, 2.869817f,-67.854393f, 3.246967f,-67.434258f, 3.248784f,-67.391907f,
                    3.287715f,-67.387054f, 3.397936f,-67.302628f, 3.448978f,-67.317307f, 3.472686f,-67.352034f, 3.472686f,-66.869835f);
            poly[228] = new TzPolygon(3.472686f,-66.869835f, 3.472686f,-67.352034f, 3.499963f,-67.391991f, 3.730872f,-67.490044f, 3.740017f,-67.595024f,
                    3.777847f,-67.626381f, 4.118264f,-67.736122f, 4.164749f,-67.784279f, 4.223799f,-67.807068f, 4.343650f,-67.782722f,
                    4.422300f,-67.799652f, 4.536075f,-67.877792f, 4.731576f,-67.827019f, 4.906523f,-67.829582f, 5.039307f,-67.794281f,
                    5.290832f,-67.850044f, 5.363085f,-67.810722f, 5.467006f,-67.655846f, 5.531435f,-67.613472f, 5.656918f,-67.647430f,
                    5.805540f,-67.609848f, 6.001365f,-67.421776f, 6.004546f,-67.422675f, 6.004546f,-66.869835f);
            poly[229] = new TzPolygon(-2.231925f,-66.869835f, -2.231925f,-56.487611f, -2.251389f,-56.486115f, -2.273889f,-56.396950f, -2.231925f,-56.305687f,
                    -2.303611f,-56.399445f, -2.353333f,-56.371674f, -4.122895f,-57.192420f, -4.122895f,-66.869835f);
            poly[230] = new TzPolygon(1.886310f,-64.228798f, 1.477701f,-64.228798f, 1.452302f,-64.293411f, 1.380010f,-64.343735f, 1.418941f,-64.381645f,
                    1.527704f,-64.344200f, 1.527459f,-64.387047f, 1.490510f,-64.417229f, 1.469739f,-64.489670f, 1.355377f,-64.529968f,
                    1.338664f,-64.586220f, 1.285774f,-64.637611f, 1.250451f,-64.720734f, 1.299998f,-64.748077f, 1.313104f,-64.782700f,
                    1.237145f,-64.843231f, 1.223235f,-64.877075f, 1.248545f,-64.903008f, 1.111735f,-64.968025f, 1.107678f,-65.020912f,
                    1.143756f,-65.055229f, 1.114882f,-65.120705f, 0.993625f,-65.126335f, 0.942731f,-65.152473f, 0.916445f,-65.304893f,
                    0.806549f,-65.373413f, 0.698704f,-65.393188f, 0.626311f,-65.511101f, 0.705491f,-65.556572f, 0.813550f,-65.483940f,
                    0.877193f,-65.470375f, 0.964946f,-65.524307f, 1.007569f,-65.582855f, 0.980297f,-65.659088f, 1.004873f,-65.732765f,
                    0.966693f,-65.762787f, 0.939189f,-65.853676f, 0.810287f,-65.951508f, 0.798747f,-66.046280f, 0.754315f,-66.095062f,
                    0.738587f,-66.140396f, 0.766854f,-66.209732f, 0.738179f,-66.322144f, 1.225646f,-66.869835f, 1.886310f,-66.869835f);
            poly[231] = new TzPolygon(-0.172808f,-62.498988f, -0.172808f,-61.587761f, -1.152253f,-61.587761f, -1.285052f,-61.623764f, -1.426773f,-61.595497f,
                    -1.394722f,-61.724167f, -1.357222f,-61.748894f, -1.388334f,-61.840561f, -1.379167f,-61.872223f, -1.256945f,-61.928894f,
                    -1.221699f,-61.985229f, -1.150000f,-62.019730f, -1.061667f,-62.148338f, -1.052778f,-62.199173f, -0.968333f,-62.238335f,
                    -0.943611f,-62.317223f, -0.826667f,-62.419174f, -0.778611f,-62.506950f, -0.694445f,-62.498894f, -0.718333f,-62.375282f,
                    -0.641667f,-62.311111f, -0.596944f,-62.303894f, -0.512778f,-62.319168f, -0.461389f,-62.376671f, -0.307778f,-62.380005f,
                    -0.256389f,-62.415840f, -0.213889f,-62.487785f);
            poly[232] = new TzPolygon(-0.172808f,-62.498988f, -0.100833f,-62.518616f, -0.041944f,-62.578056f, 0.002778f,-62.593338f, 0.031389f,-62.548615f,
                    0.095000f,-62.524727f, 0.173333f,-62.568611f, 0.246667f,-62.569725f, 0.321944f,-62.528061f, 0.419167f,-62.537224f,
                    0.464444f,-62.494728f, 0.518611f,-62.480278f, 0.723611f,-62.545837f, 0.783056f,-62.462502f, 0.825000f,-62.438896f,
                    0.918056f,-62.503334f, 1.059166f,-62.513618f, 1.266944f,-62.595284f, 1.366111f,-62.619446f, 1.408056f,-62.608894f,
                    1.487500f,-62.717224f, 1.610833f,-62.796669f, 1.703889f,-62.749451f, 1.725833f,-62.710556f, 1.833333f,-62.735001f,
                    1.886310f,-62.697013f, 1.886310f,-61.587761f, -0.172808f,-61.587761f);
            poly[233] = new TzPolygon(1.886310f,-64.055936f, 1.707904f,-64.053581f, 1.579624f,-64.105080f, 1.494397f,-64.186325f, 1.477701f,-64.228798f,
                    1.886310f,-64.228798f);
            poly[234] = new TzPolygon(3.427646f,-64.228798f, 3.476489f,-64.236397f, 3.491406f,-64.228798f);
            poly[235] = new TzPolygon(3.684872f,-64.228798f, 3.796913f,-64.324165f, 3.834754f,-64.415451f, 3.830230f,-64.469986f, 3.881664f,-64.542755f,
                    4.182162f,-64.732483f, 4.188092f,-64.764305f, 4.244174f,-64.805084f, 4.329103f,-64.790489f, 4.335419f,-64.730461f,
                    4.279819f,-64.660065f, 4.202043f,-64.627075f, 4.155511f,-64.563103f, 4.182353f,-64.368263f, 4.169591f,-64.341103f,
                    4.192603f,-64.267426f, 4.187658f,-64.228798f);
            poly[236] = new TzPolygon(1.886310f,-64.055936f, 1.932790f,-64.056549f, 1.966930f,-64.018044f, 2.000280f,-63.910282f, 1.989471f,-63.780979f,
                    2.042658f,-63.717396f, 2.047743f,-63.664528f, 2.071546f,-63.665237f, 2.124453f,-63.603935f, 2.154375f,-63.419231f,
                    2.223162f,-63.374554f, 2.157222f,-63.286118f, 2.181389f,-63.138618f, 2.105833f,-63.127785f, 2.042222f,-63.058617f,
                    2.015555f,-62.996117f, 2.019167f,-62.908279f, 1.886310f,-62.908279f);
            poly[237] = new TzPolygon(2.915869f,-64.059978f, 2.915869f,-62.908279f, 2.019167f,-62.908279f, 2.015555f,-62.996117f, 2.042222f,-63.058617f,
                    2.105833f,-63.127785f, 2.181389f,-63.138618f, 2.155278f,-63.253059f, 2.174444f,-63.329445f, 2.223162f,-63.374554f,
                    2.289375f,-63.347633f, 2.441960f,-63.382137f, 2.439636f,-63.530739f, 2.403786f,-63.573132f, 2.402544f,-63.755684f,
                    2.509034f,-64.031029f, 2.572594f,-64.042213f, 2.667315f,-63.983398f, 2.771976f,-63.986729f);
            poly[238] = new TzPolygon(3.612249f,-62.908279f, 3.638996f,-62.953526f, 3.776613f,-63.059464f, 3.872282f,-63.189156f, 3.945428f,-63.202082f,
                    3.945428f,-62.908279f);
            poly[239] = new TzPolygon(3.945428f,-63.428783f, 3.920467f,-63.434361f, 3.909822f,-63.455269f, 3.937880f,-63.533966f, 3.945428f,-63.543279f);
            poly[240] = new TzPolygon(3.945428f,-63.938321f, 3.929609f,-63.966766f, 3.945428f,-64.002471f);
            poly[241] = new TzPolygon(3.684872f,-64.228798f, 3.634167f,-64.185638f, 3.581523f,-64.182892f, 3.491406f,-64.228798f);
            poly[242] = new TzPolygon(3.427646f,-64.228798f, 3.257432f,-64.202316f, 3.153313f,-64.216385f, 3.090931f,-64.184547f, 3.062022f,-64.134377f,
                    2.915869f,-64.059978f, 2.915869f,-64.228798f);
            poly[243] = new TzPolygon(2.019167f,-62.908279f, 2.021667f,-62.847504f, 1.936666f,-62.696671f, 1.890278f,-62.694168f, 1.886310f,-62.697013f,
                    1.886310f,-62.908279f);
            poly[244] = new TzPolygon(3.612249f,-62.908279f, 3.945428f,-62.908279f, 3.945428f,-62.759011f, 3.933027f,-62.760284f, 3.877719f,-62.729305f,
                    3.724185f,-62.705090f, 3.641585f,-62.748917f, 3.583891f,-62.860306f);
            poly[245] = new TzPolygon(4.187658f,-64.228798f, 4.175617f,-64.134735f, 4.121849f,-64.081184f, 3.951800f,-64.016853f, 3.945428f,-64.002471f,
                    3.945428f,-64.228798f);
            poly[246] = new TzPolygon(3.945428f,-63.938321f, 4.018855f,-63.806293f, 3.995561f,-63.793621f, 3.990760f,-63.700253f, 4.009868f,-63.622784f,
                    3.945428f,-63.543279f);
            poly[247] = new TzPolygon(3.945428f,-63.428783f, 4.025760f,-63.410831f, 4.039675f,-63.357590f, 3.951764f,-63.203201f, 3.945428f,-63.202082f);
            poly[248] = new TzPolygon(3.945428f,-62.757720f, 4.026201f,-62.741020f, 4.055555f,-62.634979f, 4.019764f,-62.556587f, 4.051339f,-62.529636f,
                    4.135681f,-62.512238f, 4.136952f,-62.463535f, 4.153421f,-62.439728f, 4.172881f,-62.460110f, 4.186056f,-62.417156f,
                    4.083876f,-62.128765f, 4.118902f,-62.068764f, 4.143046f,-62.064632f, 4.180132f,-61.960762f, 4.156063f,-61.972481f,
                    4.106117f,-61.926704f, 4.150659f,-61.898136f, 4.165521f,-61.805325f, 4.223555f,-61.784130f, 4.261574f,-61.723473f,
                    4.244722f,-61.619247f, 4.254576f,-61.587761f, 3.945428f,-61.587761f);
            poly[249] = new TzPolygon(-0.172808f,-61.587761f, -0.172808f,-60.273896f, -0.215278f,-60.306671f, -0.306389f,-60.316116f, -0.463333f,-60.386673f,
                    -0.519722f,-60.394173f, -0.628611f,-60.311394f, -0.681944f,-60.307228f, -0.744444f,-60.479172f, -0.830556f,-60.513336f,
                    -0.830556f,-60.601952f, -0.860833f,-60.640282f, -0.843056f,-60.757225f, -0.791667f,-60.757225f, -0.686111f,-60.807503f,
                    -0.607222f,-60.910835f, -0.553056f,-60.926117f, -0.530000f,-61.061668f, -0.489444f,-61.116394f, -0.493611f,-61.218613f,
                    -0.555278f,-61.253059f, -0.650556f,-61.474167f, -0.727778f,-61.533340f, -0.908889f,-61.582504f, -1.046526f,-61.559097f,
                    -1.152253f,-61.587761f);
            poly[250] = new TzPolygon(-0.172808f,-60.273896f, -0.138611f,-60.247505f, -0.043889f,-60.220284f, 0.025278f,-60.158340f, 0.119722f,-60.136116f,
                    0.185556f,-60.053062f, 0.229444f,-60.055283f, 0.225545f,-58.946724f, -0.172808f,-58.946724f);
            poly[251] = new TzPolygon(1.305299f,-58.946724f, 1.348350f,-59.155670f, 1.397388f,-59.252750f, 1.511873f,-59.329876f, 1.521340f,-59.382614f,
                    1.728509f,-59.548702f, 1.729299f,-59.618408f, 1.763815f,-59.668766f, 1.791924f,-59.677330f, 1.824657f,-59.641068f,
                    1.848647f,-59.654217f, 1.845303f,-59.744835f, 1.860766f,-59.753902f, 1.886310f,-59.755097f, 1.886310f,-58.946724f);
            poly[252] = new TzPolygon(1.038450f,-58.946724f, 1.309811f,-58.972088f, 1.304896f,-58.946724f);
            poly[253] = new TzPolygon(-2.231925f,-56.483952f, -2.188889f,-56.479172f, -2.160000f,-56.498894f, -2.225833f,-56.634445f, -2.200556f,-56.704170f,
                    -2.163611f,-56.763062f, -2.034167f,-56.749168f, -2.028889f,-56.844727f, -1.945278f,-56.993340f, -1.863056f,-57.075562f,
                    -1.804722f,-57.090561f, -1.795278f,-57.134445f, -1.765000f,-57.159172f, -1.764445f,-57.253616f, -1.713056f,-57.251671f,
                    -1.730834f,-57.325562f, -1.713611f,-57.395561f, -1.581389f,-57.678337f, -1.538333f,-57.695007f, -1.528889f,-57.744446f,
                    -1.451945f,-57.804726f, -1.420000f,-57.912781f, -1.351389f,-57.970558f, -1.284167f,-58.104729f, -1.238889f,-58.120560f,
                    -1.233611f,-58.171112f, -1.131389f,-58.243896f, -1.110278f,-58.327507f, -1.018333f,-58.411949f, -0.836111f,-58.451668f,
                    -0.822500f,-58.497505f, -0.764167f,-58.559174f, -0.766945f,-58.628334f, -0.642222f,-58.746948f, -0.505833f,-58.750282f,
                    -0.440000f,-58.724449f, -0.372222f,-58.845001f, -0.253611f,-58.871674f, -0.172808f,-58.857637f, -0.172808f,-56.305687f,
                    -2.231925f,-56.305687f);
            poly[254] = new TzPolygon(0.225545f,-58.946724f, 0.225278f,-58.870598f, -0.082500f,-58.841949f, -0.172808f,-58.869518f, -0.172808f,-58.946724f);
            poly[255] = new TzPolygon(1.305299f,-58.946724f, 1.886310f,-58.946724f, 1.886310f,-57.438598f, 1.700689f,-57.544678f, 1.689638f,-57.639664f,
                    1.718252f,-57.770401f, 1.678573f,-57.817326f, 1.645396f,-57.919312f, 1.665301f,-58.000000f, 1.500673f,-58.008511f,
                    1.501474f,-58.129841f, 1.557843f,-58.166733f, 1.553054f,-58.244686f, 1.590138f,-58.324669f, 1.536430f,-58.380981f,
                    1.470647f,-58.382061f, 1.458016f,-58.497753f, 1.317985f,-58.467731f, 1.264406f,-58.507111f, 1.288133f,-58.551517f,
                    1.270877f,-58.588852f, 1.288300f,-58.696121f, 1.207113f,-58.735409f, 1.175080f,-58.804111f, 1.233826f,-58.903610f,
                    1.267339f,-58.892010f, 1.298510f,-58.913773f);
            poly[256] = new TzPolygon(1.886310f,-56.769323f, 1.863873f,-56.800163f, 1.886310f,-56.847603f);
            poly[257] = new TzPolygon(1.038769f,-58.946724f, 0.225278f,-58.870598f, 0.225545f,-58.946724f);
            poly[258] = new TzPolygon(3.945428f,-61.587761f, 3.945428f,-59.521001f, 3.939903f,-59.516312f, 3.901130f,-59.580925f, 3.825130f,-59.575603f,
                    3.795994f,-59.593632f, 3.776826f,-59.665920f, 3.702916f,-59.663784f, 3.623160f,-59.766788f, 3.603479f,-59.844990f,
                    3.565341f,-59.863480f, 3.495798f,-59.804379f, 3.478436f,-59.829437f, 3.469599f,-59.812759f, 3.426218f,-59.836800f,
                    3.427237f,-59.811829f, 3.354882f,-59.798679f, 3.345845f,-59.830791f, 3.219712f,-59.877457f, 3.197319f,-59.909397f,
                    3.122009f,-59.902214f, 3.062944f,-59.959000f, 2.825077f,-59.991806f, 2.682594f,-59.989750f, 2.478706f,-59.902596f,
                    2.364981f,-59.897724f, 2.290136f,-59.800194f, 2.276611f,-59.724319f, 2.177517f,-59.739925f, 2.103107f,-59.723843f,
                    2.060412f,-59.742588f, 2.025318f,-59.720356f, 1.922440f,-59.756786f, 1.886310f,-59.752693f, 1.886310f,-61.587761f);
            poly[259] = new TzPolygon(5.231411f,-60.267242f, 5.199076f,-60.329174f, 5.211761f,-60.396610f, 5.176927f,-60.438046f, 5.199242f,-60.497875f,
                    5.189377f,-60.571815f, 5.219779f,-60.643097f, 5.209053f,-60.744110f, 5.924683f,-61.384762f, 5.968737f,-61.373150f,
                    5.965284f,-61.334896f, 6.004546f,-61.302891f, 6.004546f,-60.267242f);
            poly[260] = new TzPolygon(6.004546f,-61.302891f, 5.965284f,-61.334896f, 5.968737f,-61.373150f, 5.924683f,-61.384762f, 5.166803f,-60.706398f,
                    5.108584f,-60.686127f, 5.095117f,-60.658337f, 5.036296f,-60.649292f, 4.976171f,-60.590443f, 4.930250f,-60.597706f,
                    4.777442f,-60.730770f, 4.707716f,-60.907093f, 4.662491f,-60.937798f, 4.603294f,-60.925247f, 4.549125f,-60.951878f,
                    4.508224f,-61.140610f, 4.549633f,-61.293354f, 4.471363f,-61.274448f, 4.430702f,-61.318771f, 4.443244f,-61.444080f,
                    4.398041f,-61.506702f, 4.324893f,-61.497757f, 4.273405f,-61.527603f, 4.254576f,-61.587761f, 6.004546f,-61.587761f);
            poly[261] = new TzPolygon(5.231411f,-60.267242f, 5.264877f,-60.203144f, 5.226561f,-60.176434f, 5.243235f,-60.120560f, 5.148698f,-60.085426f,
                    5.073079f,-59.969418f, 4.806850f,-60.031521f, 4.703719f,-60.030182f, 4.662842f,-60.073544f, 4.598438f,-60.087563f,
                    4.570869f,-60.158539f, 4.521160f,-60.163319f, 4.507077f,-60.111401f, 4.532019f,-60.081238f, 4.522257f,-60.062473f,
                    4.495125f,-60.068798f, 4.486564f,-59.969299f, 4.506097f,-59.962551f, 4.509368f,-59.927216f, 4.468740f,-59.905628f,
                    4.491564f,-59.867901f, 4.465512f,-59.860462f, 4.448576f,-59.822144f, 4.469686f,-59.806004f, 4.390790f,-59.720123f,
                    4.381637f,-59.673985f, 4.346664f,-59.677376f, 4.291683f,-59.726734f, 4.266734f,-59.710812f, 4.191309f,-59.726337f,
                    4.156621f,-59.697399f, 4.137568f,-59.628399f, 4.077602f,-59.655487f, 3.997792f,-59.575825f, 3.967660f,-59.580570f,
                    3.975064f,-59.546150f, 3.945428f,-59.521001f, 3.945428f,-60.267242f);
            poly[262] = new TzPolygon(3.374856f,-57.626205f, 3.367381f,-57.650635f, 3.381816f,-57.673111f, 3.426149f,-57.700481f, 3.512499f,-57.676254f,
                    3.604130f,-57.740864f, 3.665291f,-57.838356f, 3.777523f,-57.857269f, 3.880654f,-57.919666f, 3.893642f,-58.000000f,
                    3.928631f,-58.000000f, 3.945428f,-58.014188f, 3.945428f,-57.626205f);
            poly[263] = new TzPolygon(1.910455f,-56.305687f, 1.939890f,-56.359131f, 1.922371f,-56.397488f, 1.941472f,-56.480251f, 1.970551f,-56.491920f,
                    2.009794f,-56.555508f, 2.033958f,-56.707043f, 2.190870f,-56.813148f, 2.265837f,-56.820156f, 2.295865f,-56.881474f,
                    2.355207f,-56.881138f, 2.389616f,-56.934475f, 2.480431f,-56.958214f, 2.501347f,-56.942299f, 2.503534f,-56.994816f,
                    2.553908f,-56.996029f, 2.585885f,-57.028183f, 2.640177f,-57.026474f, 2.637823f,-57.054825f, 2.767933f,-57.103607f,
                    2.777977f,-57.142281f, 2.820574f,-57.123856f, 2.807364f,-57.171856f, 2.833982f,-57.204399f, 2.911927f,-57.225636f,
                    2.915869f,-57.220415f, 2.915869f,-56.305687f);
            poly[264] = new TzPolygon(1.886310f,-57.438598f, 1.894799f,-57.433746f, 1.990075f,-57.302399f, 1.943744f,-57.247444f, 2.021116f,-57.085178f,
                    1.957924f,-57.060127f, 1.918004f,-57.011600f, 1.917950f,-56.914501f, 1.886310f,-56.847603f);
            poly[265] = new TzPolygon(1.886310f,-56.769323f, 1.919642f,-56.723507f, 1.913274f,-56.675976f, 1.939786f,-56.628956f, 1.911592f,-56.562195f,
                    1.944612f,-56.453724f, 1.922371f,-56.397488f, 1.939890f,-56.359131f, 1.910455f,-56.305687f, 1.886310f,-56.305687f);
            poly[266] = new TzPolygon(3.374856f,-57.626205f, 3.385714f,-57.590725f, 3.333537f,-57.477974f, 3.373516f,-57.305061f, 3.129192f,-57.294590f,
                    3.128596f,-57.251801f, 3.090612f,-57.261772f, 3.068398f,-57.213673f, 3.035746f,-57.205124f, 3.022794f,-57.236893f,
                    3.001997f,-57.216122f, 2.944598f,-57.224571f, 2.945379f,-57.181339f, 2.915869f,-57.220415f, 2.915869f,-57.626205f);
            poly[267] = new TzPolygon(6.004546f,-57.147692f, 5.999986f,-57.146225f, 5.756562f,-57.188904f, 5.613526f,-57.180748f, 5.476017f,-57.273800f,
                    5.396416f,-57.280708f, 5.312995f,-57.348629f, 5.291864f,-57.334579f, 5.299996f,-57.298584f, 5.220871f,-57.295170f,
                    5.212469f,-57.245144f, 5.255956f,-57.240437f, 5.169795f,-57.191822f, 5.155706f,-57.218163f, 5.195405f,-57.263908f,
                    5.177150f,-57.301250f, 5.071012f,-57.339962f, 5.034745f,-57.304092f, 5.002457f,-57.438393f, 5.027977f,-57.539368f,
                    5.007347f,-57.600079f, 5.020937f,-57.680843f, 4.975194f,-57.751335f, 4.933281f,-57.766335f, 4.943924f,-57.826450f,
                    4.904678f,-57.873558f, 4.803046f,-57.931686f, 4.769263f,-57.919193f, 4.760627f,-57.883171f, 4.630972f,-57.845840f,
                    4.397534f,-57.967911f, 4.334260f,-57.967464f, 4.326353f,-58.000000f, 4.268556f,-58.001839f, 4.131202f,-58.086399f,
                    4.074831f,-58.057190f, 3.994235f,-58.055412f, 3.945428f,-58.014188f, 3.945428f,-58.946724f, 6.004546f,-58.946724f);
            poly[268] = new TzPolygon(-18.110334f,-70.732656f, -18.110334f,-69.815306f, -18.118589f,-69.818909f, -18.259893f,-69.967789f, -18.264816f,-70.048637f,
                    -18.319487f,-70.174629f, -18.310644f,-70.327873f, -18.349728f,-70.374191f, -18.156803f,-70.682320f);
            poly[269] = new TzPolygon(-19.092177f,-68.814156f, -19.045353f,-68.884087f, -18.947504f,-68.953331f, -18.875790f,-68.909378f, -18.749912f,-68.977989f,
                    -18.380926f,-69.050514f, -18.317429f,-69.037781f, -18.290449f,-69.069931f, -18.238306f,-69.070061f, -18.156723f,-69.138557f,
                    -18.110334f,-69.102311f, -18.110334f,-68.814156f);
            poly[270] = new TzPolygon(-18.110334f,-69.814906f, -17.981972f,-69.752663f, -17.939104f,-69.746956f, -17.869772f,-69.792397f, -17.778137f,-69.779915f,
                    -17.747467f,-69.818878f, -17.650354f,-69.798996f, -17.657827f,-69.661903f, -17.507553f,-69.462646f, -17.605848f,-69.461487f,
                    -17.717327f,-69.344681f, -17.801001f,-69.308182f, -17.950356f,-69.296295f, -18.029619f,-69.104187f, -18.067204f,-69.068611f,
                    -18.110334f,-69.102311f);
            poly[271] = new TzPolygon(-18.110334f,-68.814156f, -18.110334f,-69.102311f, -18.067204f,-69.068611f, -18.029619f,-69.104187f, -17.950356f,-69.296295f,
                    -17.801001f,-69.308182f, -17.731260f,-69.337257f, -17.605848f,-69.461487f, -17.375532f,-69.462875f, -17.289143f,-69.572784f,
                    -17.282017f,-69.640762f, -17.161558f,-69.551376f, -17.078199f,-69.374825f, -17.020998f,-69.391891f, -16.967113f,-69.317574f,
                    -16.935705f,-69.314552f, -16.793577f,-69.181992f, -16.731318f,-69.167679f, -16.676619f,-69.006172f, -16.565695f,-69.032272f,
                    -16.432720f,-68.982368f, -16.337534f,-68.814156f);
            poly[272] = new TzPolygon(-16.337534f,-68.814156f, -16.188629f,-68.962921f, -16.216131f,-69.010201f, -16.200209f,-69.041824f, -16.219093f,-69.099220f,
                    -16.143026f,-69.235939f, -15.620770f,-69.413857f, -15.439337f,-69.317078f, -15.420501f,-69.273972f, -15.369260f,-69.284363f,
                    -15.367968f,-69.266884f, -15.335523f,-69.264549f, -15.308644f,-69.211235f, -15.261448f,-69.185593f, -15.256123f,-69.125984f,
                    -15.163446f,-69.190720f, -15.112489f,-69.279549f, -14.979629f,-69.365486f, -14.962502f,-69.362042f, -14.962502f,-68.814156f);
            poly[273] = new TzPolygon(-22.608159f,-68.814156f, -22.608159f,-67.862101f, -22.711521f,-67.885559f, -22.825804f,-67.875130f, -22.873558f,-67.793900f,
                    -22.896133f,-67.572220f, -22.804693f,-67.177498f, -22.992395f,-66.987938f, -23.949574f,-67.293510f, -24.034197f,-67.337540f,
                    -24.379583f,-68.213531f, -24.419250f,-68.281898f, -24.484030f,-68.316612f, -24.474066f,-68.391357f, -24.546375f,-68.402916f,
                    -24.747684f,-68.567375f, -24.834064f,-68.571693f, -24.876141f,-68.500221f, -25.072287f,-68.337402f, -25.106030f,-68.404358f,
                    -25.092192f,-68.467529f, -25.133516f,-68.505463f, -25.156712f,-68.516720f, -25.156712f,-68.814156f);
            poly[274] = new TzPolygon(-24.056991f,-66.486111f, -24.163334f,-66.525284f, -24.135281f,-66.595566f, -24.134167f,-66.687500f, -24.056946f,-66.867508f,
                    -23.953892f,-66.942780f, -23.946114f,-66.985840f, -23.834167f,-67.076675f, -23.815834f,-67.149170f, -23.753042f,-67.232666f,
                    -22.992395f,-66.987938f, -22.804693f,-67.177498f, -22.710840f,-67.122169f, -22.644667f,-67.013504f, -22.608159f,-67.015992f,
                    -22.608159f,-66.486111f);
            poly[275] = new TzPolygon(-22.608159f,-67.862101f, -22.608159f,-67.015992f, -22.644667f,-67.013504f, -22.710840f,-67.122169f, -22.805611f,-67.177742f,
                    -22.896133f,-67.572220f, -22.873558f,-67.793900f, -22.825804f,-67.875130f, -22.711521f,-67.885559f);
            poly[276] = new TzPolygon(-23.882435f,-66.006803f, -23.882435f,-64.168222f, -24.171669f,-64.158066f, -24.247780f,-64.178894f, -24.384167f,-64.279175f,
                    -24.418335f,-64.324448f, -24.426670f,-64.415848f, -24.466114f,-64.443069f, -24.494167f,-64.525284f, -24.615002f,-64.618896f,
                    -24.451115f,-64.821121f, -24.600281f,-64.921951f, -24.557781f,-65.046677f, -24.451115f,-65.164459f, -24.501945f,-65.276947f,
                    -24.461113f,-65.431396f, -24.424168f,-65.465561f, -24.436111f,-65.531403f, -24.410004f,-65.580292f, -24.185280f,-65.750290f,
                    -24.069168f,-65.765289f, -23.981392f,-65.894455f, -23.997223f,-65.957230f, -23.939445f,-66.004456f, -23.900837f,-65.990280f);
            poly[277] = new TzPolygon(-23.882435f,-66.421811f, -24.056991f,-66.486111f, -23.882435f,-66.486111f);
            poly[278] = new TzPolygon(-23.882435f,-66.006803f, -23.860001f,-66.026947f, -23.775280f,-66.023056f, -23.718613f,-65.984451f, -23.688335f,-66.001114f,
                    -23.534447f,-65.990845f, -23.451668f,-66.108902f, -23.391392f,-66.257233f, -23.366669f,-66.351669f, -23.390556f,-66.378067f,
                    -23.519447f,-66.407227f, -23.740280f,-66.369446f, -23.882435f,-66.421811f, -23.882435f,-66.486111f, -22.608159f,-66.486111f,
                    -22.608159f,-65.308930f, -22.632225f,-65.264450f, -22.728336f,-65.287231f, -22.942780f,-65.233612f, -22.985558f,-65.182510f,
                    -23.007225f,-65.027512f, -23.074722f,-65.007233f, -23.251945f,-65.043335f, -23.303337f,-64.955841f, -23.496391f,-64.875565f,
                    -23.507504f,-64.809448f, -23.465279f,-64.751678f, -23.449169f,-64.669174f, -23.505280f,-64.555283f, -23.620834f,-64.444168f,
                    -23.602501f,-64.412231f, -23.503891f,-64.371124f, -23.507225f,-64.181396f, -23.882435f,-64.168222f);
            poly[279] = new TzPolygon(-22.608159f,-64.243866f, -22.626514f,-64.244911f, -22.650690f,-64.267990f, -22.761272f,-64.265770f, -22.852428f,-64.295944f,
                    -22.868658f,-64.320633f, -22.809795f,-64.330528f, -22.805895f,-64.350914f, -22.745554f,-64.341614f, -22.713644f,-64.402779f,
                    -22.686493f,-64.399773f, -22.637613f,-64.441811f, -22.608159f,-64.432836f);
            poly[280] = new TzPolygon(-20.059607f,-68.647495f, -20.082048f,-68.780464f, -20.123709f,-68.771873f, -20.141741f,-68.704674f, -20.239777f,-68.712875f,
                    -20.324041f,-68.663246f, -20.364286f,-68.741539f, -20.392424f,-68.755692f, -20.498291f,-68.678207f, -20.560022f,-68.538551f,
                    -20.602501f,-68.510109f, -20.632399f,-68.439362f, -20.726265f,-68.549171f, -20.879955f,-68.547256f, -20.932560f,-68.515427f,
                    -20.937944f,-68.400589f, -21.296675f,-68.172417f, -21.599545f,-68.177132f, -21.763161f,-68.056953f, -21.975716f,-68.064438f,
                    -22.048464f,-67.963882f, -22.090786f,-67.942650f, -22.164888f,-67.951843f, -22.243740f,-67.919662f, -22.321440f,-67.946129f,
                    -22.414806f,-67.895714f, -22.496523f,-67.888641f, -22.546459f,-67.848099f, -22.608159f,-67.862101f, -22.608159f,-68.814156f,
                    -20.059607f,-68.814156f);
            poly[281] = new TzPolygon(-22.608159f,-67.015992f, -22.533396f,-67.021088f, -22.530806f,-66.970222f, -22.484844f,-66.926369f, -22.429701f,-66.782875f,
                    -22.236582f,-66.739349f, -22.163426f,-66.486111f, -22.608159f,-66.486111f);
            poly[282] = new TzPolygon(-22.608159f,-65.293297f, -22.593056f,-65.311401f, -22.598057f,-65.343063f, -22.507778f,-65.338623f, -22.316391f,-65.237228f,
                    -22.220558f,-65.235565f, -22.088120f,-65.187584f, -22.086403f,-64.983742f, -22.120201f,-64.920753f, -22.120390f,-64.871742f,
                    -22.194710f,-64.742165f, -22.191767f,-64.655251f, -22.290604f,-64.541176f, -22.363108f,-64.571190f, -22.405096f,-64.524323f,
                    -22.440243f,-64.528061f, -22.437445f,-64.494324f, -22.538935f,-64.411743f, -22.608159f,-64.432836f);
            poly[283] = new TzPolygon(-22.608159f,-64.243866f, -22.561695f,-64.241219f, -22.434406f,-64.158066f, -22.608159f,-64.158066f);
            poly[284] = new TzPolygon(-22.163426f,-66.486111f, -22.119081f,-66.332603f, -22.085493f,-66.321457f, -22.084442f,-66.290703f, -21.948343f,-66.276321f,
                    -21.850950f,-66.235626f, -21.796875f,-66.245476f, -21.781277f,-66.221611f, -21.830694f,-66.078705f, -21.872219f,-66.038803f,
                    -21.916096f,-66.043137f, -21.932043f,-65.926170f, -22.108543f,-65.755310f, -22.111191f,-65.656761f, -22.077440f,-65.574562f,
                    -22.099045f,-65.480263f, -22.088120f,-65.187584f, -22.220558f,-65.235565f, -22.316391f,-65.237228f, -22.507778f,-65.338623f,
                    -22.588337f,-65.345566f, -22.608159f,-65.308930f, -22.608159f,-66.486111f);
            poly[285] = new TzPolygon(-19.079217f,-68.814156f, -19.086332f,-68.799461f, -19.188759f,-68.669914f, -19.269604f,-68.616211f, -19.300110f,-68.532524f,
                    -19.407597f,-68.407265f, -19.696680f,-68.622047f, -19.739092f,-68.690575f, -19.777279f,-68.627831f, -19.818111f,-68.606827f,
                    -19.842819f,-68.529846f, -19.927412f,-68.523972f, -20.044783f,-68.559662f, -20.059607f,-68.647495f, -20.059607f,-68.814156f);
            poly[286] = new TzPolygon(-22.434406f,-64.158066f, -22.408339f,-64.141037f, -22.404051f,-64.118668f, -22.265236f,-64.073647f, -22.239407f,-64.031227f,
                    -22.225376f,-64.027407f, -22.225376f,-62.685173f, -22.248497f,-62.660305f, -22.248857f,-62.629475f, -22.304132f,-62.636215f,
                    -22.327608f,-62.540543f, -22.376373f,-62.517841f, -22.369289f,-62.458092f, -22.418072f,-62.453625f, -22.416563f,-62.431458f,
                    -22.469793f,-62.378937f, -22.462471f,-62.341843f, -24.385834f,-62.333893f, -25.156712f,-62.978287f, -25.156712f,-64.158066f);
            poly[287] = new TzPolygon(-22.225376f,-64.158066f, -22.225376f,-64.027407f, -22.239407f,-64.031227f, -22.265236f,-64.073647f, -22.404051f,-64.118668f,
                    -22.408339f,-64.141037f, -22.434406f,-64.158066f);
            poly[288] = new TzPolygon(-22.225376f,-62.640318f, -22.252115f,-62.649101f, -22.225376f,-62.679729f);
            poly[289] = new TzPolygon(-25.156712f,-62.972749f, -24.403057f,-62.334450f, -22.462471f,-62.341843f, -22.537390f,-62.239956f, -22.580858f,-62.243000f,
                    -22.598053f,-62.267159f, -22.651442f,-62.189301f, -22.712847f,-62.201885f, -22.710884f,-62.180927f, -22.789499f,-62.136288f,
                    -22.850042f,-62.070822f, -25.156712f,-62.070822f);
            poly[290] = new TzPolygon(-22.850042f,-62.070822f, -22.874996f,-62.043839f, -23.023550f,-61.989819f, -23.068697f,-61.937656f, -23.089390f,-61.863735f,
                    -23.157888f,-61.814297f, -23.181223f,-61.757999f, -23.239704f,-61.739323f, -23.276274f,-61.689171f, -23.285118f,-61.611473f,
                    -23.346584f,-61.549301f, -23.350286f,-61.507950f, -23.371370f,-61.528286f, -23.418417f,-61.495605f, -23.462955f,-61.395866f,
                    -23.448719f,-61.358479f, -23.551317f,-61.235249f, -23.551281f,-61.172356f, -23.614782f,-61.096394f, -23.686960f,-61.086838f,
                    -23.811646f,-60.981937f, -23.804802f,-60.931942f, -23.871485f,-60.836735f, -23.901945f,-60.603062f, -23.956980f,-60.567429f,
                    -23.964092f,-60.452503f, -24.045639f,-60.334629f, -24.039494f,-60.116695f, -24.012131f,-60.046623f, -24.048032f,-59.983578f,
                    -25.156712f,-59.983578f, -25.156712f,-62.070822f);
            poly[291] = new TzPolygon(-22.225376f,-64.027407f, -22.105783f,-63.994846f, -22.079300f,-63.973190f, -22.088572f,-63.958149f, -22.009466f,-63.939785f,
                    -22.002594f,-63.781666f, -22.004440f,-62.808064f, -22.077862f,-62.796364f, -22.118284f,-62.815407f, -22.162548f,-62.794682f,
                    -22.172012f,-62.778145f, -22.147446f,-62.768993f, -22.225376f,-62.685173f);
            poly[292] = new TzPolygon(-22.225376f,-59.983578f, -22.225376f,-62.640419f, -21.062191f,-62.258217f, -20.567064f,-62.270020f, -20.096943f,-61.926895f,
                    -19.635500f,-61.745861f, -19.454538f,-60.599365f, -19.294041f,-59.983578f);
            poly[293] = new TzPolygon(-24.048032f,-59.983578f, -24.337097f,-59.475956f, -24.412750f,-59.421837f, -24.425278f,-59.381790f, -24.484718f,-59.352993f,
                    -24.527407f,-59.251827f, -24.619097f,-59.121784f, -24.666517f,-58.968723f, -24.768318f,-58.813465f, -24.778490f,-58.718758f,
                    -24.831194f,-58.665413f, -24.826170f,-58.566032f, -24.851236f,-58.493458f, -24.890850f,-58.423958f, -24.920872f,-58.422573f,
                    -24.999170f,-58.327259f, -24.930134f,-58.229538f, -25.043455f,-58.066578f, -25.039463f,-57.997208f, -25.083776f,-57.985916f,
                    -25.084707f,-57.867779f, -25.121496f,-57.848934f, -25.150834f,-57.797860f, -25.156712f,-57.797860f, -25.156712f,-59.983578f);
            poly[294] = new TzPolygon(-25.150834f,-57.797860f, -25.156712f,-57.787628f, -25.156712f,-57.797860f);
            poly[295] = new TzPolygon(-23.088142f,-55.612143f, -22.994284f,-55.639969f, -22.991510f,-55.685066f, -22.937218f,-55.650955f, -22.862513f,-55.666988f,
                    -22.791105f,-55.654289f, -22.765717f,-55.622780f, -22.658520f,-55.612797f, -22.616623f,-55.631836f, -22.532196f,-55.735569f,
                    -22.396128f,-55.739750f, -22.382105f,-55.789661f, -22.281366f,-55.854023f, -22.280878f,-56.208412f, -22.239986f,-56.248035f,
                    -22.225376f,-56.288173f, -22.225376f,-55.612143f);
            poly[296] = new TzPolygon(-22.225376f,-56.619117f, -22.242626f,-56.647099f, -22.261166f,-56.642826f, -22.225376f,-56.687154f);
            poly[297] = new TzPolygon(-22.225376f,-56.704470f, -22.260490f,-56.727657f, -22.236839f,-56.753551f, -22.262123f,-56.785339f, -22.249907f,-56.807827f,
                    -22.300434f,-56.831131f, -22.285059f,-56.871861f, -22.246456f,-56.893848f, -22.251127f,-56.947784f, -22.225451f,-57.000504f,
                    -22.247795f,-57.099430f, -22.225376f,-57.108776f);
            poly[298] = new TzPolygon(-22.225376f,-57.130239f, -22.231592f,-57.184147f, -22.225376f,-57.189550f);
            poly[299] = new TzPolygon(-22.225376f,-57.221092f, -22.244143f,-57.242958f, -22.225376f,-57.279798f);
        }
    }

    private static class Initializer4 {
        private static void init() {
            poly[300] = new TzPolygon(-22.225376f,-57.341666f, -22.227705f,-57.363777f, -22.225376f,-57.367694f);
            poly[301] = new TzPolygon(-20.759708f,-57.940219f, -20.759708f,-57.797860f, -22.144886f,-57.797860f, -22.147953f,-57.803490f, -22.120979f,-57.828182f,
                    -22.122072f,-57.921314f, -22.085171f,-57.942913f, -22.084568f,-57.988956f, -22.031996f,-58.005268f, -22.006546f,-57.969940f,
                    -21.900507f,-57.945095f, -21.881310f,-57.919155f, -21.843920f,-57.968826f, -21.792522f,-57.912655f, -21.746536f,-57.947025f,
                    -21.687214f,-57.893806f, -21.634737f,-57.937225f, -21.589968f,-57.915997f, -21.528080f,-57.967522f, -21.338770f,-57.854916f,
                    -21.313473f,-57.859402f, -21.278404f,-57.918194f, -21.225834f,-57.853809f, -21.101675f,-57.846878f, -21.041340f,-57.865738f,
                    -20.976418f,-57.817802f, -20.938309f,-57.824711f, -20.945004f,-57.859680f, -20.897243f,-57.926666f, -20.835226f,-57.855228f,
                    -20.797558f,-57.882736f, -20.784086f,-57.960804f);
            poly[302] = new TzPolygon(-19.294041f,-57.908008f, -19.760530f,-58.134026f, -19.985384f,-57.873581f, -20.036726f,-57.909969f, -20.027479f,-57.959267f,
                    -20.056067f,-57.977493f, -20.061220f,-58.014553f, -20.103136f,-58.050934f, -20.162462f,-58.163456f, -20.107914f,-58.138206f,
                    -19.958748f,-58.207424f, -19.865828f,-58.193752f, -19.848328f,-58.158234f, -19.797668f,-58.192402f, -19.347153f,-59.119808f,
                    -19.294041f,-59.983578f);
            poly[303] = new TzPolygon(-19.294041f,-59.983578f, -19.347153f,-59.119808f, -19.797668f,-58.192402f, -19.848328f,-58.158234f, -19.865828f,-58.193752f,
                    -19.958748f,-58.207424f, -20.107914f,-58.138206f, -20.155418f,-58.169086f, -20.188107f,-58.125038f, -20.242266f,-58.163143f,
                    -20.266598f,-58.146229f, -20.257095f,-58.091972f, -20.372423f,-58.082138f, -20.433100f,-57.999626f, -20.513123f,-58.018883f,
                    -20.572546f,-57.997147f, -20.607986f,-58.015442f, -20.643385f,-57.974972f, -20.695845f,-57.987507f, -20.702335f,-57.958572f,
                    -20.666462f,-57.922924f, -20.735619f,-57.868908f, -20.754997f,-57.936241f, -20.759708f,-57.940219f, -20.759708f,-59.983578f);
            poly[304] = new TzPolygon(-22.144886f,-57.797860f, -22.092377f,-57.701481f, -22.096186f,-57.616417f, -22.167046f,-57.584023f, -22.180969f,-57.553135f,
                    -22.198769f,-57.412449f, -22.225376f,-57.367694f, -22.225376f,-57.797860f);
            poly[305] = new TzPolygon(-22.225376f,-57.341666f, -22.219976f,-57.290398f, -22.225376f,-57.279798f);
            poly[306] = new TzPolygon(-22.225376f,-57.221092f, -22.209871f,-57.203026f, -22.225376f,-57.189550f);
            poly[307] = new TzPolygon(-22.225376f,-57.130239f, -22.223015f,-57.109760f, -22.225376f,-57.108776f);
            poly[308] = new TzPolygon(-22.225376f,-56.704470f, -22.216257f,-56.698448f, -22.225376f,-56.687154f);
            poly[309] = new TzPolygon(-22.225376f,-56.619117f, -22.192757f,-56.566204f, -22.103062f,-56.518940f, -22.077505f,-56.403347f, -22.205980f,-56.341457f,
                    -22.225376f,-56.288173f);
            poly[310] = new TzPolygon(-23.691044f,-55.466624f, -23.691044f,-54.035949f, -23.778614f,-54.060005f, -23.948059f,-54.080284f, -24.071270f,-54.283779f,
                    -24.014330f,-54.316551f, -24.000000f,-54.368328f, -23.928808f,-54.411194f, -23.884710f,-54.483372f, -23.879309f,-54.561920f,
                    -23.849836f,-54.573578f, -23.815378f,-54.667839f, -23.861084f,-54.701153f, -23.857077f,-54.759987f, -23.907230f,-54.855087f,
                    -23.899275f,-54.887566f, -23.964281f,-54.932472f, -23.958258f,-55.006069f, -23.991236f,-55.060833f, -23.962997f,-55.112206f,
                    -24.012663f,-55.226208f, -23.958941f,-55.314892f, -23.993250f,-55.341537f, -23.961388f,-55.412579f, -23.912300f,-55.441601f,
                    -23.714037f,-55.434086f, -23.714884f,-55.461205f);
            poly[311] = new TzPolygon(-25.156712f,-54.436999f, -25.087261f,-54.464771f, -25.031471f,-54.457760f, -24.649237f,-54.335812f, -24.492779f,-54.333027f,
                    -24.363293f,-54.259968f, -24.288900f,-54.278988f, -24.236370f,-54.328236f, -24.130970f,-54.328705f, -24.071270f,-54.283779f,
                    -23.948059f,-54.080284f, -23.778614f,-54.060005f, -23.691044f,-54.035949f, -23.691044f,-53.426425f, -25.156712f,-53.426425f);
            poly[312] = new TzPolygon(-23.088142f,-55.612143f, -23.141083f,-55.596447f, -23.159620f,-55.544758f, -23.197105f,-55.521690f, -23.261765f,-55.520016f,
                    -23.316954f,-55.549183f, -23.382042f,-55.501820f, -23.457907f,-55.540058f, -23.613760f,-55.535294f, -23.643694f,-55.477386f,
                    -23.691044f,-55.466624f, -23.691044f,-55.612143f);
            poly[313] = new TzPolygon(-23.691044f,-54.035949f, -23.446945f,-53.968895f, -23.346947f,-53.769173f, -23.300282f,-53.721390f, -23.102501f,-53.634171f,
                    -23.007504f,-53.636948f, -22.885265f,-53.572174f, -22.836945f,-53.496674f, -22.809839f,-53.426425f, -23.691044f,-53.426425f);
            poly[314] = new TzPolygon(-22.225376f,-52.526546f, -22.305000f,-52.685005f, -22.440556f,-52.861389f, -22.482224f,-52.975281f, -22.526669f,-53.005280f,
                    -22.551945f,-53.057503f, -22.705822f,-53.156845f, -22.809839f,-53.426425f, -22.225376f,-53.426425f);
            poly[315] = new TzPolygon(-22.225376f,-52.526546f, -22.193336f,-52.462784f, -22.100281f,-52.365562f, -21.960835f,-52.290283f, -21.857780f,-52.174446f,
                    -21.783337f,-52.150284f, -21.718891f,-52.053337f, -21.646389f,-52.037224f, -21.555836f,-52.091949f, -21.502781f,-52.049728f,
                    -21.497780f,-51.962502f, -21.350281f,-51.870560f, -21.269726f,-51.849724f, -21.149170f,-51.871117f, -21.091393f,-51.792229f,
                    -20.990559f,-51.736946f, -20.880280f,-51.630005f, -20.697502f,-51.617226f, -20.600281f,-51.580833f, -20.539169f,-51.466118f,
                    -20.382504f,-51.343895f, -20.315281f,-51.260559f, -20.312486f,-51.240707f, -22.225376f,-51.240707f);
            poly[316] = new TzPolygon(-19.294041f,-57.908008f, -19.051062f,-57.790283f, -19.033991f,-57.708553f, -18.914160f,-57.720200f, -18.903246f,-57.769115f,
                    -18.858095f,-57.756557f, -18.685235f,-57.699387f, -19.294041f,-57.699387f);
            poly[317] = new TzPolygon(-17.861346f,-57.699387f, -17.833399f,-57.712646f, -17.831265f,-57.699387f);
            poly[318] = new TzPolygon(-17.798117f,-57.699387f, -17.782171f,-57.714676f, -17.727474f,-57.721230f, -17.730628f,-57.699387f);
            poly[319] = new TzPolygon(-17.727108f,-57.699387f, -17.720024f,-57.735073f, -17.645491f,-57.785053f, -17.561592f,-57.800304f, -17.557655f,-57.769547f,
                    -17.552172f,-57.797268f, -17.478554f,-57.846458f, -17.459980f,-57.902039f, -17.519537f,-58.002548f, -17.456871f,-58.056190f,
                    -17.456488f,-58.113781f, -17.418262f,-58.117756f, -17.390753f,-58.150242f, -17.396648f,-58.184402f, -17.365883f,-58.194107f,
                    -17.354225f,-58.255753f, -17.221861f,-58.348820f, -17.196997f,-58.394608f, -17.128271f,-58.382023f, -17.128271f,-57.699387f);
            poly[320] = new TzPolygon(-17.128271f,-57.699387f, -17.128271f,-58.382023f, -17.125751f,-58.381561f, -17.115124f,-58.422680f, -16.989662f,-58.420788f,
                    -16.938763f,-58.470360f, -16.701941f,-58.467598f, -16.613119f,-58.442001f, -16.541655f,-58.340462f, -16.476341f,-58.333279f,
                    -16.439354f,-58.355560f, -16.378759f,-58.321449f, -16.269693f,-58.309341f, -16.266338f,-58.387653f, -16.303335f,-58.402794f,
                    -16.324831f,-58.470730f, -16.279503f,-59.357067f, -16.264633f,-60.172977f, -15.476063f,-60.235813f, -15.104990f,-60.565289f,
                    -15.100630f,-60.252533f, -14.962502f,-60.253795f, -14.962502f,-57.699387f);
            poly[321] = new TzPolygon(-17.796308f,-57.699387f, -17.809217f,-57.688744f, -17.829653f,-57.689365f, -17.831265f,-57.699387f);
            poly[322] = new TzPolygon(-17.866289f,-57.699387f, -18.136364f,-57.567589f, -18.228182f,-57.458096f, -18.262976f,-57.559731f, -18.685235f,-57.699387f);
            poly[323] = new TzPolygon(-17.547480f,-54.470047f, -17.512501f,-54.525841f, -17.503891f,-54.606117f, -17.508335f,-54.681671f, -17.546112f,-54.773895f,
                    -17.603058f,-54.810562f, -17.655834f,-54.907501f, -17.685837f,-55.180557f, -17.577503f,-55.343056f, -17.511391f,-55.529449f,
                    -17.392223f,-55.600281f, -17.355003f,-55.787224f, -17.301392f,-55.846115f, -17.265835f,-55.989449f, -17.195278f,-56.038338f,
                    -17.185280f,-56.121948f, -17.213612f,-56.240005f, -17.282223f,-56.312500f, -17.292503f,-56.330833f, -17.274170f,-56.354729f,
                    -17.323891f,-56.431671f, -17.300835f,-56.491951f, -17.323334f,-56.609169f, -17.314724f,-56.752502f, -17.376522f,-56.795410f,
                    -17.396667f,-56.839172f, -17.481670f,-56.849167f, -17.584167f,-56.976395f, -17.657089f,-56.977852f, -17.763512f,-57.082893f,
                    -17.867172f,-57.427040f, -17.950993f,-57.470192f, -17.891670f,-57.473618f, -17.821560f,-57.599800f, -17.740017f,-57.634354f,
                    -17.727108f,-57.699387f, -14.962502f,-57.699387f, -14.962502f,-54.470047f);
            poly[324] = new TzPolygon(-18.684210f,-52.855377f, -18.678059f,-52.890007f, -18.576946f,-52.867500f, -18.558731f,-52.855377f);
            poly[325] = new TzPolygon(-18.365916f,-52.855377f, -18.346947f,-52.895004f, -18.390003f,-53.000557f, -18.351112f,-53.043892f, -18.283058f,-53.058060f,
                    -18.056393f,-53.042229f, -17.888889f,-53.113892f, -17.671669f,-53.126114f, -17.498058f,-53.227783f, -17.367226f,-53.190834f,
                    -17.284725f,-53.201668f, -17.128271f,-53.092564f, -17.128271f,-52.855377f);
            poly[326] = new TzPolygon(-17.128271f,-54.470047f, -17.128271f,-53.092564f, -17.284725f,-53.201668f, -17.367226f,-53.190834f, -17.503613f,-53.226952f,
                    -17.671669f,-53.126114f, -17.888889f,-53.113892f, -18.016670f,-53.053894f, -18.035557f,-53.158615f, -17.997223f,-53.254723f,
                    -18.001114f,-53.454445f, -18.038059f,-53.498894f, -17.999725f,-53.657501f, -18.019203f,-53.786560f, -17.941391f,-53.898613f,
                    -17.934448f,-53.981392f, -17.901947f,-53.991394f, -17.695278f,-53.868614f, -17.651947f,-53.751114f, -17.250751f,-53.678757f,
                    -17.251667f,-53.748611f, -17.309723f,-53.829445f, -17.371113f,-53.854172f, -17.468056f,-53.958893f, -17.510281f,-54.044724f,
                    -17.585281f,-54.074173f, -17.629448f,-54.121948f, -17.633057f,-54.223335f, -17.681114f,-54.330284f, -17.675003f,-54.394173f,
                    -17.579723f,-54.418617f, -17.547480f,-54.470047f);
            poly[327] = new TzPolygon(-19.269809f,-51.240707f, -19.258892f,-51.306396f, -19.158058f,-51.423058f, -19.133335f,-51.632225f, -19.053612f,-51.841667f,
                    -18.995003f,-51.896950f, -18.944168f,-52.065559f, -18.886391f,-52.104446f, -18.836945f,-52.188614f, -18.812778f,-52.256950f,
                    -18.816669f,-52.349167f, -18.708336f,-52.472778f, -18.723057f,-52.636673f, -18.684210f,-52.855377f, -18.558731f,-52.855377f,
                    -18.412502f,-52.758057f, -18.365916f,-52.855377f, -17.128271f,-52.855377f, -17.128271f,-51.240707f);
            poly[328] = new TzPolygon(-17.128271f,-51.240707f, -17.128271f,-53.092564f, -17.052502f,-53.039726f, -16.861115f,-53.011673f, -16.821114f,-52.973335f,
                    -16.764168f,-52.832230f, -16.664722f,-52.720840f, -16.576389f,-52.691391f, -16.538891f,-52.637779f, -16.412502f,-52.614723f,
                    -16.341667f,-52.577507f, -16.294724f,-52.519173f, -16.271389f,-52.434723f, -16.230835f,-52.426949f, -16.164169f,-52.453613f,
                    -16.096947f,-52.440559f, -16.042503f,-52.330559f, -15.876945f,-52.239174f, -15.875557f,-52.037506f, -15.801111f,-51.965836f,
                    -15.822500f,-51.903893f, -15.800556f,-51.876945f, -15.630835f,-51.779724f, -15.534168f,-51.788612f, -15.540834f,-51.749725f,
                    -15.503056f,-51.738060f, -15.481945f,-51.703613f, -15.309446f,-51.680840f, -15.267502f,-51.646118f, -15.226389f,-51.663338f,
                    -15.175556f,-51.636673f, -15.148613f,-51.580833f, -15.059446f,-51.516396f, -15.045557f,-51.461945f, -14.997223f,-51.412506f,
                    -14.992224f,-51.357780f, -14.962502f,-51.318336f, -15.014723f,-51.296112f, -15.021389f,-51.257225f, -15.013485f,-51.240707f);
            poly[329] = new TzPolygon(-9.477882f,-56.294184f, -9.477882f,-52.155533f, -9.490274f,-52.154486f, -9.636793f,-52.205418f, -9.661212f,-52.259141f,
                    -9.652840f,-52.328912f, -9.586558f,-52.536828f, -9.603303f,-52.572411f, -9.639583f,-52.571016f, -9.652142f,-52.603808f,
                    -9.717024f,-52.631842f);
            poly[330] = new TzPolygon(-9.477882f,-56.305687f, -9.637222f,-54.033058f, -9.768946f,-51.613949f, -14.962502f,-51.613949f, -14.962502f,-56.305687f);
            poly[331] = new TzPolygon(-9.477882f,-52.155533f, -9.440737f,-52.158672f, -9.413527f,-52.114716f, -9.340268f,-52.090994f, -9.272590f,-52.014944f,
                    -9.189563f,-52.044946f, -9.179795f,-52.087506f, -9.135142f,-52.093785f, -9.114211f,-52.067970f, -9.071651f,-52.066575f,
                    -8.901411f,-52.138438f, -8.786987f,-52.325423f, -8.759777f,-52.346355f, -8.701169f,-52.343564f, -8.593025f,-52.455894f,
                    -8.601397f,-52.621251f, -8.571396f,-52.681253f, -8.503719f,-52.722418f, -8.466740f,-52.792188f, -8.264406f,-52.790095f,
                    -8.242079f,-52.838935f, -8.188356f,-52.861261f, -7.935786f,-52.878704f, -7.850666f,-52.825678f, -7.720893f,-52.793584f,
                    -7.542579f,-52.703410f, -7.542579f,-51.613949f, -9.477882f,-51.613949f);
            poly[332] = new TzPolygon(-7.542579f,-52.703410f, -7.537396f,-52.700789f, -7.489255f,-52.725209f, -7.409019f,-52.679160f, -7.321805f,-52.592645f,
                    -7.178776f,-52.595435f, -7.124355f,-52.546596f, -7.076213f,-52.460081f, -7.015513f,-52.453801f, -6.976441f,-52.390310f,
                    -6.967371f,-52.264723f, -6.909461f,-52.065179f, -6.809689f,-51.998897f, -6.727360f,-51.977966f, -6.555027f,-52.081226f,
                    -6.578749f,-52.193557f, -6.551538f,-52.243792f, -6.367344f,-52.370077f, -6.333157f,-52.429382f, -6.172684f,-52.446824f,
                    -6.100123f,-52.516595f, -6.003142f,-52.543805f, -5.860810f,-52.534037f, -5.750572f,-52.612180f, -5.607275f,-52.663071f,
                    -5.607275f,-51.613949f, -7.542579f,-51.613949f);
            poly[333] = new TzPolygon(-5.607275f,-52.663071f, -5.451954f,-52.718232f, -5.381486f,-52.862657f, -5.225200f,-52.869634f, -5.016586f,-52.917078f,
                    -4.859602f,-52.822190f, -4.752156f,-52.785909f, -4.710991f,-52.746140f, -4.468189f,-52.654043f, -4.411675f,-52.662415f,
                    -4.355859f,-52.722418f, -4.320974f,-52.732186f, -4.263064f,-52.718929f, -4.209341f,-52.648461f, -4.178642f,-52.637996f,
                    -3.831184f,-52.590552f, -3.725133f,-52.434963f, -3.661642f,-52.378449f, -3.405584f,-52.222163f, -3.215459f,-52.160242f,
                    -3.245111f,-52.065179f, -3.299184f,-52.019828f, -3.432620f,-51.980582f, -3.456167f,-51.943081f, -3.438725f,-51.905579f,
                    -3.402095f,-51.888136f, -3.392502f,-51.839297f, -3.358489f,-51.817494f, -3.305289f,-51.830576f, -3.227669f,-51.811389f,
                    -3.175341f,-51.760805f, -3.113420f,-51.766038f, -3.077662f,-51.844530f, -2.762822f,-52.013723f, -2.714855f,-52.021573f,
                    -2.600606f,-51.992792f, -2.467170f,-52.011979f, -2.085176f,-52.212570f, -1.747661f,-52.257048f, -1.736668f,-52.262545f,
                    -1.736668f,-51.613949f, -5.607275f,-51.613949f);
            poly[334] = new TzPolygon(2.133939f,-56.305687f, 2.133939f,-56.005382f, 2.040511f,-55.912556f, 1.974735f,-55.923462f, 1.889429f,-55.906479f,
                    1.831145f,-55.994968f, 1.891764f,-56.188629f, 1.889393f,-56.267445f, 1.910455f,-56.305687f);
            poly[335] = new TzPolygon(2.133939f,-54.124481f, 2.133939f,-54.111016f, 2.127094f,-54.114597f);
            poly[336] = new TzPolygon(1.493523f,-53.959818f, 1.520555f,-53.988060f, 1.508055f,-54.086945f, 1.545833f,-54.084724f, 1.582778f,-54.116394f,
                    1.613055f,-54.101395f, 1.614444f,-54.138062f, 1.667222f,-54.173058f, 1.647222f,-54.195839f, 1.728055f,-54.286392f,
                    1.763055f,-54.361115f, 1.746666f,-54.496674f, 1.785000f,-54.588341f, 1.768611f,-54.735001f, 1.898611f,-54.768059f,
                    1.986944f,-54.763062f, 2.017777f,-54.800835f, 2.076666f,-54.750282f, 2.133939f,-54.776084f, 2.133939f,-54.138124f,
                    2.127094f,-54.114597f, 2.133939f,-54.111016f, 2.133939f,-53.959818f);
            poly[337] = new TzPolygon(-1.736668f,-52.262545f, -1.698821f,-52.281468f, -1.667425f,-52.224779f, -1.613239f,-52.204005f, -1.524329f,-51.889469f,
                    -1.434417f,-51.954486f, -1.281056f,-51.900315f, -1.181115f,-51.910169f, -1.157693f,-51.846241f, -1.155833f,-51.956947f,
                    -1.135278f,-51.977501f, -1.165556f,-51.995285f, -1.170833f,-52.047501f, -1.220278f,-52.069450f, -1.155278f,-52.113892f,
                    -1.142222f,-52.251671f, -1.065556f,-52.367500f, -0.972222f,-52.393616f, -0.923611f,-52.368057f, -0.875556f,-52.388893f,
                    -0.860000f,-52.420837f, -0.879722f,-52.519173f, -0.743880f,-52.506599f, -0.658333f,-52.523613f, -0.624722f,-52.538063f,
                    -0.614444f,-52.600563f, -0.572778f,-52.627228f, -0.382222f,-52.632782f, -0.350000f,-52.682785f, -0.300833f,-52.701950f,
                    -0.178056f,-52.812225f, -0.203333f,-52.871948f, -0.186389f,-52.923340f, -0.016389f,-52.971115f, 0.035000f,-53.015839f,
                    0.131111f,-53.006111f, 0.198636f,-53.026578f, 0.198636f,-51.613949f, -1.736668f,-51.613949f);
            poly[338] = new TzPolygon(1.493523f,-53.959818f, 1.427500f,-53.890839f, 1.403333f,-53.892784f, 1.401944f,-53.855835f, 1.385556f,-53.861389f,
                    1.384166f,-53.827225f, 1.420555f,-53.815559f, 1.392500f,-53.753059f, 1.439722f,-53.731949f, 1.410278f,-53.696945f,
                    1.429444f,-53.664169f, 1.363055f,-53.656395f, 1.367778f,-53.553062f, 1.323333f,-53.566116f, 1.282414f,-53.539734f,
                    1.243889f,-53.548889f, 1.264444f,-53.438614f, 1.187500f,-53.405838f, 1.169722f,-53.460556f, 1.123055f,-53.466118f,
                    1.042500f,-53.430557f, 0.942222f,-53.418617f, 0.886944f,-53.350006f, 0.790278f,-53.282501f, 0.742222f,-53.117226f,
                    0.533333f,-53.141113f, 0.392222f,-53.130005f, 0.296111f,-53.089172f, 0.247500f,-53.041389f, 0.198636f,-53.026578f,
                    0.198636f,-53.959818f);
            poly[339] = new TzPolygon(2.133939f,-56.005382f, 2.176807f,-56.047974f, 2.226485f,-56.048256f, 2.262532f,-56.133774f, 2.352037f,-56.090218f,
                    2.344939f,-56.044266f, 2.404775f,-55.995178f, 2.524166f,-55.978149f, 2.531550f,-55.938831f, 2.455712f,-55.786961f,
                    2.401214f,-55.738914f, 2.442657f,-55.480839f, 2.407456f,-55.370182f, 2.516481f,-55.335915f, 2.524066f,-55.306881f,
                    2.494835f,-55.239201f, 2.563823f,-55.176785f, 2.575308f,-55.137001f, 2.568752f,-55.132752f, 2.133939f,-55.132752f);
            poly[340] = new TzPolygon(2.568752f,-55.132752f, 2.522386f,-55.102707f, 2.632479f,-54.939892f, 2.555437f,-54.969406f, 2.444036f,-54.869759f,
                    2.432270f,-54.826591f, 2.458907f,-54.779675f, 2.415000f,-54.734451f, 2.274722f,-54.711113f, 2.190278f,-54.750282f,
                    2.163611f,-54.789452f, 2.133939f,-54.776084f, 2.133939f,-55.132752f);
            poly[341] = new TzPolygon(2.133939f,-54.776084f, 2.163611f,-54.789452f, 2.190278f,-54.750282f, 2.274722f,-54.711113f, 2.425833f,-54.737228f,
                    2.458907f,-54.779675f, 2.476372f,-54.753151f, 2.450780f,-54.689152f, 2.409841f,-54.693291f, 2.400440f,-54.724384f,
                    2.331640f,-54.696304f, 2.336314f,-54.549095f, 2.332590f,-54.546285f, 2.133939f,-54.546285f);
            poly[342] = new TzPolygon(2.323334f,-54.546285f, 3.101591f,-54.546285f, 3.101591f,-54.176181f, 2.989890f,-54.183010f, 2.963052f,-54.158009f,
                    2.918233f,-54.186886f, 2.841431f,-54.181686f, 2.764508f,-54.214149f, 2.628962f,-54.316578f, 2.499406f,-54.362827f,
                    2.434860f,-54.441803f, 2.333882f,-54.440063f, 2.303486f,-54.525734f);
            poly[343] = new TzPolygon(2.332590f,-54.546285f, 2.293035f,-54.516441f, 2.274894f,-54.541370f, 2.226049f,-54.470329f, 2.214883f,-54.372974f,
                    2.157763f,-54.314297f, 2.177571f,-54.181725f, 2.138659f,-54.154346f, 2.133939f,-54.138124f, 2.133939f,-54.546285f);
            poly[344] = new TzPolygon(2.133939f,-54.111016f, 2.196785f,-54.078136f, 2.236307f,-53.959818f, 2.133939f,-53.959818f);
            poly[345] = new TzPolygon(3.101591f,-54.176181f, 3.114362f,-54.175400f, 3.125023f,-54.208382f, 3.146966f,-54.210514f, 3.200454f,-54.191338f,
                    3.308968f,-54.066860f, 3.378426f,-54.050743f, 3.425174f,-54.014019f, 3.601097f,-53.977493f, 3.648905f,-54.001423f,
                    3.634952f,-54.036201f, 3.668136f,-54.064548f, 3.798930f,-54.122993f, 3.809397f,-54.192822f, 3.847816f,-54.187737f,
                    3.874821f,-54.241753f, 4.012070f,-54.316956f, 4.046188f,-54.362503f, 4.069243f,-54.352660f, 4.069243f,-53.959993f,
                    3.101591f,-53.960095f);
            poly[346] = new TzPolygon(4.069243f,-54.352660f, 4.143001f,-54.321171f, 4.189804f,-54.389164f, 4.332997f,-54.390755f, 4.373012f,-54.418751f,
                    4.521899f,-54.446377f, 4.577557f,-54.411362f, 4.636924f,-54.433441f, 4.710537f,-54.424664f, 4.739120f,-54.466362f,
                    4.903628f,-54.474247f, 4.948222f,-54.443710f, 5.066204f,-54.415398f, 5.239499f,-54.300774f, 5.357258f,-54.140739f,
                    5.405309f,-54.126686f, 5.543812f,-54.014526f, 5.621387f,-54.011616f, 5.729805f,-53.959818f, 4.069243f,-53.959993f);
            poly[347] = new TzPolygon(2.236307f,-53.959818f, 2.293982f,-53.937016f, 2.282890f,-53.910061f, 2.316059f,-53.818577f, 2.364060f,-53.784210f,
                    2.286815f,-53.694283f, 2.290060f,-53.602848f, 2.332068f,-53.471794f, 2.272310f,-53.397404f, 2.292224f,-53.273476f,
                    2.271855f,-53.226437f, 2.222989f,-53.188385f, 2.224297f,-53.083473f, 2.169751f,-52.987366f, 2.192049f,-52.901848f,
                    2.285073f,-52.853474f, 2.373743f,-52.672802f, 2.444589f,-52.639996f, 2.449589f,-52.616550f, 2.468214f,-52.622131f,
                    2.523372f,-52.554726f, 2.554482f,-52.558510f, 2.588203f,-52.530945f, 2.645522f,-52.555515f, 2.655283f,-52.531040f,
                    2.883019f,-52.428467f, 2.912198f,-52.381531f, 2.943452f,-52.393715f, 3.073557f,-52.327984f, 3.133795f,-52.347202f,
                    3.179043f,-52.296677f, 3.236496f,-52.279541f, 3.250557f,-52.228004f, 3.295740f,-52.192142f, 3.622783f,-51.993290f,
                    3.707367f,-51.969246f, 3.734749f,-51.916248f, 3.780786f,-51.920189f, 3.889529f,-51.795406f, 3.996106f,-51.753742f,
                    4.049279f,-51.658463f, 4.165922f,-51.613949f, 2.133939f,-51.613949f, 2.133939f,-53.959818f);
            poly[348] = new TzPolygon(-9.790742f,-51.240707f, -9.770963f,-51.613949f, -9.768946f,-51.613949f, -9.768946f,-51.240707f);
            poly[349] = new TzPolygon(9.998914f,-11.496679f, 9.997462f,-11.885845f, 9.935805f,-11.906583f, 9.871853f,-12.120018f, 9.924650f,-12.227111f,
                    9.881639f,-12.431741f, 9.868772f,-12.454523f, 10.000000f,-12.454523f, 10.000000f,-11.496679f);
            poly[350] = new TzPolygon(5.327682f,-7.365113f, 4.401467f,-7.365113f, 4.381185f,-7.397680f, 4.357067f,-7.509716f, 4.393475f,-7.557402f,
                    4.428773f,-7.538608f, 4.453865f,-7.560108f, 4.510217f,-7.549981f, 4.583502f,-7.568356f, 4.609120f,-7.546407f,
                    4.655729f,-7.571111f, 4.669196f,-7.554972f, 4.785807f,-7.558362f, 4.805328f,-7.591042f, 4.895278f,-7.596900f,
                    4.922413f,-7.524233f, 4.975278f,-7.556935f, 4.998857f,-7.540038f, 5.067939f,-7.555890f, 5.102701f,-7.526069f,
                    5.096560f,-7.500409f, 5.150406f,-7.470920f, 5.281210f,-7.467324f, 5.296957f,-7.413286f, 5.254435f,-7.415398f);
            poly[351] = new TzPolygon(7.663841f,-11.496679f, 7.663841f,-10.747966f, 7.540246f,-10.849485f, 7.498620f,-10.915172f, 7.508295f,-10.931028f,
                    7.389956f,-11.092366f, 7.302634f,-11.166399f, 7.260184f,-11.177986f, 7.235098f,-11.271209f, 7.198854f,-11.289679f,
                    7.216792f,-11.306440f, 7.145648f,-11.326579f, 7.144075f,-11.347285f, 7.077685f,-11.328999f, 7.075452f,-11.366726f,
                    7.021025f,-11.364518f, 6.969614f,-11.421159f, 6.949146f,-11.411903f, 6.929611f,-11.459169f, 6.942060f,-11.496679f);
            poly[352] = new TzPolygon(7.405101f,-9.430896f, 7.362011f,-9.477838f, 7.459310f,-9.430896f);
            poly[353] = new TzPolygon(5.327682f,-7.365113f, 5.383626f,-7.376683f, 5.359167f,-7.398419f, 5.427989f,-7.446178f, 5.429402f,-7.415867f,
                    5.478634f,-7.421058f, 5.506707f,-7.389423f, 5.518979f,-7.402888f, 5.524568f,-7.378515f, 5.572956f,-7.395648f,
                    5.582454f,-7.371478f, 5.753704f,-7.441317f, 5.843457f,-7.422362f, 5.859603f,-7.466815f, 5.811672f,-7.483889f,
                    5.859017f,-7.519185f, 5.835051f,-7.545751f, 5.897295f,-7.575215f, 5.888253f,-7.599619f, 5.915747f,-7.659627f,
                    5.950229f,-7.660561f, 5.900728f,-7.684296f, 5.953354f,-7.758396f, 5.991473f,-7.791013f, 6.031557f,-7.768487f,
                    6.074874f,-7.786833f, 6.093022f,-7.823941f, 6.071994f,-7.843366f, 6.184585f,-7.840624f, 6.190201f,-7.818991f,
                    6.279850f,-7.901638f, 6.281140f,-7.965284f, 6.315147f,-8.005301f, 6.274928f,-8.167080f, 6.304496f,-8.195180f,
                    6.319874f,-8.276216f, 6.338678f,-8.269449f, 6.372831f,-8.339358f, 6.346687f,-8.392356f, 6.366781f,-8.412014f,
                    6.380413f,-8.382753f, 6.426960f,-8.408247f, 6.444934f,-8.385976f, 6.488746f,-8.455497f, 6.429647f,-8.483390f,
                    6.492203f,-8.540526f, 6.495762f,-8.556145f, 6.495762f,-7.365113f);
            poly[354] = new TzPolygon(7.405101f,-9.430896f, 7.459310f,-9.430896f, 7.612175f,-9.357147f, 7.663841f,-9.367152f, 7.663841f,-8.686663f,
                    7.640020f,-8.706784f, 7.552198f,-8.722639f, 7.508294f,-8.709048f, 7.347347f,-8.845829f, 7.283467f,-8.833481f,
                    7.263333f,-8.848072f, 7.261062f,-8.902840f, 7.287982f,-8.915597f, 7.285556f,-8.937005f, 7.262615f,-8.941023f,
                    7.193553f,-9.104451f, 7.225818f,-9.094152f, 7.273731f,-9.116056f, 7.273436f,-9.153790f, 7.303209f,-9.190242f,
                    7.385181f,-9.211778f, 7.379552f,-9.274587f, 7.422637f,-9.295266f, 7.429217f,-9.350083f, 7.388764f,-9.393971f,
                    7.423495f,-9.410858f);
            poly[355] = new TzPolygon(7.608561f,-8.398005f, 7.554582f,-8.472179f, 7.625896f,-8.565241f, 7.663841f,-8.562108f, 7.663841f,-8.398005f);
            poly[356] = new TzPolygon(6.495762f,-8.556145f, 6.505595f,-8.599302f, 6.526442f,-8.587243f, 6.518766f,-8.568664f, 6.561458f,-8.560629f,
                    6.570932f,-8.526329f, 6.604506f,-8.532824f, 6.589451f,-8.508763f, 6.611938f,-8.503819f, 6.636006f,-8.448979f,
                    6.682393f,-8.401834f, 6.706994f,-8.405842f, 6.712835f,-8.398005f, 6.495762f,-8.398005f);
            poly[357] = new TzPolygon(7.420297f,-8.398005f, 7.493816f,-8.414106f, 7.554582f,-8.472179f, 7.608561f,-8.398005f);
            poly[358] = new TzPolygon(7.608561f,-8.398005f, 7.663841f,-8.398005f, 7.663841f,-8.150527f, 7.545011f,-8.193576f, 7.533727f,-8.214911f,
                    7.601425f,-8.302776f, 7.572749f,-8.369344f, 7.612191f,-8.393017f);
            poly[359] = new TzPolygon(7.420297f,-8.398005f, 7.234249f,-8.357258f, 7.180778f,-8.276108f, 7.082397f,-8.299418f, 7.006707f,-8.273610f,
                    6.966105f,-8.324889f, 6.906307f,-8.308886f, 6.879560f,-8.332027f, 6.848192f,-8.307361f, 6.756032f,-8.340052f,
                    6.712835f,-8.398005f);
            poly[360] = new TzPolygon(8.385598f,-10.463788f, 8.307663f,-10.553535f, 8.340906f,-10.673992f, 8.273252f,-10.700704f, 8.271010f,-10.718918f,
                    8.359575f,-10.696069f, 8.387915f,-10.653097f, 8.476318f,-10.649591f, 8.541684f,-10.622394f, 8.595742f,-10.579530f,
                    8.637876f,-10.481762f, 8.674580f,-10.469391f, 8.709423f,-10.510350f, 8.772460f,-10.535750f, 8.804345f,-10.586904f,
                    8.831921f,-10.586661f, 8.831921f,-10.463788f);
            poly[361] = new TzPolygon(7.663841f,-10.747966f, 7.739516f,-10.685807f, 7.770212f,-10.604135f, 8.032037f,-10.606035f, 8.052411f,-10.567781f,
                    8.134172f,-10.514517f, 8.137498f,-10.463788f, 7.663841f,-10.463788f);
            poly[362] = new TzPolygon(8.385598f,-10.463788f, 8.395230f,-10.452695f, 8.492885f,-10.385975f, 8.502891f,-10.331406f, 8.465844f,-10.284238f,
                    8.264098f,-10.313857f, 8.201405f,-10.304780f, 8.144222f,-10.361211f, 8.137498f,-10.463788f);
            poly[363] = new TzPolygon(7.933285f,-9.430896f, 7.947937f,-9.432427f, 7.950067f,-9.430896f);
            poly[364] = new TzPolygon(8.385598f,-10.463788f, 8.831921f,-10.463788f, 8.831921f,-9.430896f, 8.046699f,-9.430896f, 8.036176f,-9.459948f,
                    8.071421f,-9.444740f, 8.165902f,-9.463471f, 8.179371f,-9.519850f, 8.242701f,-9.516605f, 8.267322f,-9.488165f,
                    8.326165f,-9.520170f, 8.376794f,-9.480072f, 8.383351f,-9.533310f, 8.432796f,-9.579597f, 8.406788f,-9.606053f,
                    8.402270f,-9.654752f, 8.458596f,-9.628118f, 8.491600f,-9.691836f, 8.444446f,-9.717484f, 8.549417f,-9.759356f,
                    8.534493f,-9.799957f, 8.502597f,-9.804309f, 8.498016f,-9.919444f, 8.420928f,-10.055259f, 8.495794f,-10.054862f,
                    8.526420f,-10.158051f, 8.480469f,-10.212584f, 8.497613f,-10.232009f, 8.492885f,-10.385975f, 8.395230f,-10.452695f);
            poly[365] = new TzPolygon(10.000000f,-11.496679f, 9.999999f,-11.205948f, 9.975811f,-11.174973f, 9.879233f,-11.154366f, 9.797737f,-11.038712f,
                    9.664074f,-10.962818f, 9.649988f,-10.921357f, 9.601929f,-10.910993f, 9.558167f,-10.859395f, 9.537504f,-10.873787f,
                    9.517880f,-10.827494f, 9.454713f,-10.848899f, 9.414400f,-10.801964f, 9.386616f,-10.814743f, 9.380188f,-10.730983f,
                    9.334681f,-10.711603f, 9.300550f,-10.663306f, 9.210006f,-10.663737f, 9.197499f,-10.718360f, 9.084249f,-10.733388f,
                    9.081545f,-10.660323f, 9.043200f,-10.584805f, 8.831921f,-10.586661f, 8.831921f,-11.496679f);
            poly[366] = new TzPolygon(8.046699f,-9.430896f, 8.047887f,-9.427618f, 7.979505f,-9.409732f, 7.950067f,-9.430896f);
            poly[367] = new TzPolygon(7.933285f,-9.430896f, 7.862288f,-9.423477f, 7.796106f,-9.359363f, 7.748662f,-9.343918f, 7.681994f,-9.370667f,
                    7.663841f,-9.367152f, 7.663841f,-9.430896f);
            poly[368] = new TzPolygon(7.663841f,-8.686663f, 7.696163f,-8.659362f, 7.692630f,-8.559731f, 7.663841f,-8.562108f);
            poly[369] = new TzPolygon(8.831921f,-7.955618f, 8.810396f,-7.961311f, 8.765494f,-7.915887f, 8.762003f,-7.767869f, 8.505851f,-7.661064f,
                    8.448476f,-7.681430f, 8.377432f,-7.641071f, 8.373319f,-7.745131f, 8.463710f,-7.788409f, 8.490190f,-7.827266f,
                    8.432846f,-7.832880f, 8.417026f,-7.886596f, 8.434916f,-7.884745f, 8.447340f,-7.921253f, 8.483293f,-7.913170f,
                    8.501075f,-7.938083f, 8.483769f,-7.985136f, 8.505838f,-8.095356f, 8.480646f,-8.119659f, 8.502724f,-8.196898f,
                    8.442554f,-8.245586f, 8.354937f,-8.225659f, 8.236025f,-8.248055f, 8.161512f,-8.068926f, 8.205473f,-8.039600f,
                    8.186384f,-8.017927f, 8.198545f,-7.998420f, 8.102264f,-8.014451f, 8.042386f,-7.946581f, 8.012988f,-7.945582f,
                    8.010965f,-7.984294f, 8.039178f,-8.000284f, 8.022717f,-8.057645f, 7.958349f,-8.065770f, 7.858753f,-8.117181f,
                    7.790230f,-8.071350f, 7.722039f,-8.094036f, 7.693283f,-8.139861f, 7.663841f,-8.150527f, 7.663841f,-8.398005f,
                    8.831921f,-8.398005f);
            poly[370] = new TzPolygon(8.831921f,-7.955618f, 9.018338f,-7.906316f, 9.082188f,-7.813031f, 9.078054f,-7.736526f, 9.150526f,-7.837843f,
                    9.174826f,-7.833143f, 9.157667f,-7.881877f, 9.186895f,-7.919881f, 9.217309f,-7.925727f, 9.437742f,-7.849985f,
                    9.396002f,-7.968117f, 9.401764f,-8.060329f, 9.532056f,-8.149226f, 9.623129f,-8.152276f, 9.654784f,-8.127794f,
                    9.758267f,-8.129759f, 9.832644f,-8.101483f, 9.867279f,-8.113339f, 9.869720f,-8.143449f, 9.917422f,-8.133353f,
                    9.912239f,-8.160780f, 9.951138f,-8.164014f, 9.957700f,-8.117781f, 9.983398f,-8.150630f, 10.000000f,-8.139139f,
                    10.000000f,-7.365113f, 8.831921f,-7.365113f);
            poly[371] = new TzPolygon(10.921246f,-8.890819f, 10.921246f,-8.281110f, 10.853077f,-8.275601f, 10.761888f,-8.328957f, 10.750940f,-8.295570f,
                    10.636234f,-8.301474f, 10.476870f,-8.261836f, 10.409996f,-8.225393f, 10.399054f,-8.173234f, 10.422130f,-8.120452f,
                    10.358088f,-8.091685f, 10.338308f,-7.995272f, 10.294886f,-7.960951f, 10.209923f,-7.952461f, 10.097103f,-8.016502f,
                    10.046897f,-8.106679f, 10.000000f,-8.138209f, 10.000000f,-8.890819f);
            poly[372] = new TzPolygon(10.000000f,-8.139139f, 10.046897f,-8.106679f, 10.097103f,-8.016502f, 10.174623f,-7.980519f, 10.170969f,-7.926467f,
                    10.236435f,-7.815990f, 10.303016f,-7.756569f, 10.312936f,-7.775708f, 10.341888f,-7.756732f, 10.351161f,-7.728500f,
                    10.417871f,-7.735874f, 10.441434f,-7.676334f, 10.486805f,-7.646448f, 10.449132f,-7.615572f, 10.441779f,-7.565238f,
                    10.479406f,-7.508476f, 10.470425f,-7.458161f, 10.389465f,-7.425368f, 10.362387f,-7.365108f, 10.274503f,-7.378907f,
                    10.288480f,-7.296016f, 10.264119f,-7.281507f, 10.257298f,-7.178484f, 10.231970f,-7.108967f, 10.000000f,-7.108967f);
            poly[373] = new TzPolygon(11.842492f,-8.811272f, 11.628344f,-8.854325f, 11.606803f,-8.760128f, 11.635574f,-8.691567f, 11.576198f,-8.688864f,
                    11.452759f,-8.612628f, 11.443320f,-8.576336f, 11.477838f,-8.535363f, 11.399284f,-8.502104f, 11.367481f,-8.375890f,
                    11.360071f,-8.410790f, 11.335579f,-8.421792f, 11.320904f,-8.365087f, 11.279171f,-8.376987f, 11.288827f,-8.479188f,
                    11.262820f,-8.499286f, 11.221963f,-8.486457f, 11.204655f,-8.566328f, 11.139832f,-8.570990f, 11.119903f,-8.622445f,
                    11.089059f,-8.620676f, 11.007796f,-8.681372f, 10.955306f,-8.677261f, 10.950238f,-8.590489f, 10.972018f,-8.515064f,
                    11.068654f,-8.472857f, 11.075978f,-8.381933f, 11.048204f,-8.323532f, 10.995128f,-8.287080f, 10.921246f,-8.281110f,
                    10.921246f,-8.890819f, 11.842492f,-8.890819f);
            poly[374] = new TzPolygon(10.921246f,-6.218041f, 10.726414f,-6.218041f, 10.736642f,-6.256417f, 10.694646f,-6.350479f, 10.712703f,-6.382493f,
                    10.700656f,-6.416442f, 10.625507f,-6.420339f, 10.607141f,-6.396479f, 10.565434f,-6.444196f, 10.586928f,-6.539869f,
                    10.672255f,-6.642263f, 10.621504f,-6.673395f, 10.536918f,-6.663971f, 10.489438f,-6.684801f, 10.438794f,-6.630166f,
                    10.365129f,-6.672197f, 10.356384f,-6.699296f, 10.391501f,-6.764007f, 10.362393f,-6.854407f, 10.369637f,-6.947465f,
                    10.303034f,-6.997070f, 10.201180f,-6.969639f, 10.159513f,-7.040181f, 10.224899f,-7.089561f, 10.231970f,-7.108967f,
                    10.921246f,-7.108967f);
            poly[375] = new TzPolygon(10.271529f,-6.218041f, 10.297971f,-6.239283f, 10.311857f,-6.218041f);
            poly[376] = new TzPolygon(10.513936f,-6.218041f, 10.527296f,-6.251118f, 10.563968f,-6.218041f);
            poly[377] = new TzPolygon(10.594356f,-6.218041f, 10.615094f,-6.223151f, 10.617829f,-6.218041f);
            poly[378] = new TzPolygon(10.653517f,-6.218041f, 10.665249f,-6.235433f, 10.725279f,-6.218041f);
            poly[379] = new TzPolygon(10.921246f,-5.460605f, 10.852600f,-5.422309f, 10.770583f,-5.449204f, 10.758454f,-5.473898f, 10.623416f,-5.482879f,
                    10.561612f,-5.465415f, 10.433264f,-5.518916f, 10.464956f,-5.569810f, 10.440355f,-5.777385f, 10.373260f,-5.884331f,
                    10.277441f,-5.912472f, 10.277762f,-5.976114f, 10.203697f,-6.011456f, 10.199197f,-6.100948f, 10.228577f,-6.183537f,
                    10.271529f,-6.218041f, 10.311857f,-6.218041f, 10.314732f,-6.213643f, 10.302639f,-6.194834f, 10.344733f,-6.194943f,
                    10.363257f,-6.165545f, 10.387010f,-6.192493f, 10.418617f,-6.161673f, 10.445386f,-6.189960f, 10.494695f,-6.170405f,
                    10.513936f,-6.218041f, 10.563968f,-6.218041f, 10.570488f,-6.212160f, 10.594356f,-6.218041f, 10.617829f,-6.218041f,
                    10.633616f,-6.188539f, 10.653517f,-6.218041f, 10.921246f,-6.218041f);
            poly[380] = new TzPolygon(10.921246f,-5.460605f, 10.921246f,-5.327115f, 10.295698f,-5.327115f, 10.293380f,-5.329689f, 10.295563f,-5.407210f,
                    10.345895f,-5.468105f, 10.433264f,-5.518916f, 10.561612f,-5.465415f, 10.623416f,-5.482879f, 10.758454f,-5.473898f,
                    10.770583f,-5.449204f, 10.852600f,-5.422309f);
            poly[381] = new TzPolygon(10.921246f,-5.460605f, 10.973197f,-5.489587f, 11.063068f,-5.496531f, 11.136602f,-5.341400f, 11.198223f,-5.327115f,
                    10.921246f,-5.327115f);
            poly[382] = new TzPolygon(11.793319f,-5.327115f, 11.831881f,-5.409314f, 11.842492f,-5.381990f, 11.824848f,-5.354128f, 11.836506f,-5.327115f);
            poly[383] = new TzPolygon(12.965153f,-11.563597f, 12.435138f,-11.563597f, 12.387862f,-11.761611f, 12.397385f,-11.849403f, 12.430870f,-11.903317f,
                    12.396857f,-11.998737f, 12.421313f,-12.096836f, 12.368048f,-12.159190f, 12.307275f,-12.353226f, 12.391567f,-12.449529f,
                    12.392074f,-12.454523f, 12.965153f,-12.454523f);
            poly[384] = new TzPolygon(12.403823f,-11.375340f, 12.403823f,-10.672671f, 11.899301f,-10.672671f, 11.893000f,-10.690214f, 11.919329f,-10.735487f,
                    11.993781f,-10.756367f, 12.029770f,-10.792308f, 12.109358f,-10.790227f, 12.131584f,-10.845102f, 12.202316f,-10.890525f,
                    12.222416f,-10.928596f, 12.205572f,-11.015382f, 12.221040f,-11.044818f, 12.135284f,-11.072783f, 12.097152f,-11.105801f,
                    12.089847f,-11.142274f, 12.050509f,-11.142561f, 11.992474f,-11.246950f, 12.053916f,-11.355181f, 12.103890f,-11.375995f,
                    12.133606f,-11.464109f, 12.209526f,-11.497768f, 12.286798f,-11.434847f, 12.378613f,-11.439661f, 12.389361f,-11.373748f);
            poly[385] = new TzPolygon(12.432286f,-11.563597f, 12.441490f,-11.459713f, 12.413562f,-11.379462f, 12.403823f,-11.377163f, 12.403823f,-11.563597f);
            poly[386] = new TzPolygon(12.965153f,-11.413741f, 12.959573f,-11.393157f, 12.965153f,-11.389142f, 12.965153f,-11.365391f, 12.937011f,-11.355887f,
                    12.926462f,-11.405832f, 12.901845f,-11.393651f, 12.843436f,-11.416177f, 12.826292f,-11.390632f, 12.768908f,-11.400503f,
                    12.730712f,-11.375450f, 12.726368f,-11.426057f, 12.663125f,-11.452310f, 12.653913f,-11.423971f, 12.626307f,-11.414378f,
                    12.611134f,-11.432181f, 12.585592f,-11.413221f, 12.541445f,-11.449291f, 12.520040f,-11.416522f, 12.532220f,-11.393576f,
                    12.483217f,-11.381893f, 12.496778f,-11.362926f, 12.413562f,-11.379462f, 12.442837f,-11.531350f, 12.435138f,-11.563597f,
                    12.965153f,-11.563597f);
            poly[387] = new TzPolygon(14.087815f,-12.000523f, 14.000280f,-12.014380f, 13.921368f,-11.940720f, 13.813754f,-11.955746f, 13.715892f,-12.079435f,
                    13.627905f,-12.040934f, 13.533744f,-11.974014f, 13.461216f,-11.875929f, 13.383931f,-11.895082f, 13.304437f,-11.832282f,
                    13.338107f,-11.772927f, 13.409338f,-11.742508f, 13.382915f,-11.698421f, 13.387371f,-11.637003f, 13.355615f,-11.644013f,
                    13.358844f,-11.604799f, 13.304116f,-11.597032f, 13.250816f,-11.534207f, 13.202620f,-11.548107f, 13.185255f,-11.509198f,
                    13.146025f,-11.522436f, 13.094516f,-11.481779f, 13.079691f,-11.436890f, 13.006268f,-11.407912f, 12.966947f,-11.420355f,
                    12.965153f,-11.413741f, 12.965153f,-12.454523f, 14.087815f,-12.454523f);
            poly[388] = new TzPolygon(12.965153f,-11.389142f, 12.987620f,-11.372978f, 12.965153f,-11.365391f);
            poly[389] = new TzPolygon(11.899301f,-10.672671f, 11.910162f,-10.642435f, 11.969213f,-10.620753f, 11.995934f,-10.564357f, 12.021978f,-10.578286f,
                    12.041234f,-10.522943f, 12.083826f,-10.505152f, 12.112853f,-10.516498f, 12.116529f,-10.456400f, 12.141086f,-10.414026f,
                    12.172576f,-10.410717f, 12.187275f,-10.335012f, 12.225475f,-10.339325f, 12.190846f,-10.293618f, 12.212652f,-10.282997f,
                    12.215254f,-10.248378f, 12.172676f,-10.148975f, 12.179743f,-10.090956f, 12.139131f,-10.067090f, 12.128195f,-10.001694f,
                    12.098347f,-9.970773f, 12.098484f,-9.914441f, 12.057120f,-9.882901f, 12.023816f,-9.699758f, 12.123687f,-9.677726f,
                    12.172826f,-9.630399f, 12.192676f,-9.541409f, 12.245822f,-9.479281f, 12.260290f,-9.414622f, 12.242922f,-9.340386f,
                    12.354605f,-9.296910f, 12.447309f,-9.384387f, 12.444466f,-9.403601f, 12.495671f,-9.362003f, 12.476832f,-9.335703f,
                    12.500628f,-9.319593f, 12.482209f,-9.288610f, 12.502625f,-9.253329f, 12.486217f,-9.161708f, 12.423066f,-9.034279f,
                    12.332039f,-8.960145f, 12.251355f,-8.993819f, 12.192906f,-8.978591f, 12.198616f,-8.924522f, 12.151885f,-8.896679f,
                    12.041155f,-8.912936f, 12.031610f,-8.890819f, 11.842492f,-8.890819f, 11.842492f,-10.672671f);
            poly[390] = new TzPolygon(15.210476f,-12.454523f, 15.210476f,-11.824764f, 15.171913f,-11.838077f, 15.135653f,-11.816285f, 15.091529f,-11.847196f,
                    15.048355f,-11.846905f, 15.025212f,-11.792294f, 14.896805f,-11.807745f, 14.813736f,-11.936801f, 14.761557f,-11.978932f,
                    14.758201f,-12.047185f, 14.715547f,-12.056991f, 14.772843f,-12.136103f, 14.758045f,-12.236219f, 14.847750f,-12.403065f,
                    14.891202f,-12.451164f, 14.903401f,-12.454523f);
            poly[391] = new TzPolygon(15.210476f,-10.844987f, 15.189150f,-10.873935f, 15.103617f,-10.902922f, 15.210476f,-10.978855f);
            poly[392] = new TzPolygon(14.930209f,-12.454523f, 14.870360f,-12.431918f, 14.760610f,-12.241923f, 14.696291f,-12.212968f, 14.681018f,-12.163843f,
                    14.657309f,-12.180538f, 14.648184f,-12.151021f, 14.620848f,-12.148832f, 14.536594f,-12.219861f, 14.401520f,-12.204181f,
                    14.368880f,-12.100148f, 14.306371f,-12.100482f, 14.281689f,-12.024789f, 14.169964f,-11.987518f, 14.087815f,-12.000523f,
                    14.087815f,-12.454523f);
            poly[393] = new TzPolygon(15.414999f,-10.672671f, 15.433556f,-10.687647f, 15.436578f,-10.724225f, 15.349189f,-10.726892f, 15.268967f,-10.829273f,
                    15.217776f,-10.835078f, 15.210476f,-10.844987f, 15.210476f,-10.978855f, 15.238161f,-10.998528f, 15.420205f,-11.253754f,
                    15.525817f,-11.362678f, 15.574476f,-11.370984f, 15.641027f,-11.422181f, 15.642838f,-11.498940f, 15.618759f,-11.502309f,
                    15.576350f,-11.567466f, 15.537560f,-11.577165f, 15.520786f,-11.646284f, 15.537513f,-11.711870f, 15.210476f,-11.824764f,
                    15.210476f,-12.454523f, 16.333138f,-12.454523f, 16.333138f,-10.672671f);
            poly[394] = new TzPolygon(15.414999f,-10.672671f, 15.404601f,-10.664280f, 15.440048f,-10.507583f, 15.433513f,-10.336386f, 15.367039f,-10.131493f,
                    15.356557f,-9.998300f, 15.373857f,-9.922482f, 15.365005f,-9.811294f, 15.427493f,-9.697563f, 15.434369f,-9.408240f,
                    15.597577f,-9.442870f, 15.692281f,-9.332037f, 15.666197f,-9.311138f, 15.496246f,-9.328486f, 15.497589f,-8.890819f,
                    14.087815f,-8.890819f, 14.087815f,-10.672671f);
            poly[395] = new TzPolygon(16.333138f,-5.327115f, 15.507971f,-5.506424f, 15.497589f,-8.890819f, 16.333138f,-8.890819f);
            poly[396] = new TzPolygon(12.031610f,-8.890819f, 12.023277f,-8.871512f, 12.039003f,-8.832333f, 12.005167f,-8.805390f, 11.972600f,-8.816203f,
                    11.923866f,-8.794912f, 11.842492f,-8.811272f, 11.842492f,-8.890819f);
            poly[397] = new TzPolygon(16.333138f,-5.327115f, 16.499434f,-5.602800f, 20.373875f,-6.041087f, 20.373875f,-5.327115f);
            poly[398] = new TzPolygon(7.955012f,-5.327115f, 7.955012f,-2.720771f, 7.918053f,-2.745270f, 7.949609f,-2.780885f, 7.864588f,-2.791600f,
                    7.820105f,-2.830357f, 7.608613f,-2.923468f, 7.277253f,-2.977560f, 7.235056f,-2.954354f, 7.138444f,-3.027151f,
                    7.071743f,-3.035838f, 7.052661f,-3.090311f, 6.818001f,-3.229418f, 6.769928f,-3.232419f, 6.714436f,-3.196959f,
                    6.618508f,-3.255420f, 6.596525f,-3.234153f, 6.243467f,-3.177339f, 6.244720f,-3.153659f, 6.149232f,-3.104023f,
                    6.003701f,-3.079238f, 5.862218f,-3.018393f, 5.707550f,-3.025537f, 5.708756f,-2.956828f, 5.637141f,-2.967554f,
                    5.611966f,-2.933438f, 5.655939f,-2.861728f, 5.593544f,-2.762861f, 5.540581f,-2.770461f, 5.379182f,-2.726394f,
                    5.337746f,-2.727837f, 5.338245f,-2.777687f, 5.284192f,-2.787052f, 5.249761f,-2.771757f, 5.254874f,-2.756484f,
                    5.208704f,-2.765222f, 5.137735f,-2.727679f, 5.101192f,-2.758005f, 5.119366f,-2.888414f, 5.079289f,-2.957426f,
                    5.117719f,-3.034365f, 5.110734f,-3.111516f, 5.094452f,-3.110742f, 5.196557f,-3.814122f, 5.246169f,-3.987890f,
                    5.145241f,-4.796902f, 5.103235f,-5.327115f);
            poly[399] = new TzPolygon(9.435936f,-2.800195f, 9.531004f,-2.901227f, 9.564156f,-2.918171f, 9.564156f,-2.800195f);
        }
    }

    private static class Initializer5 {
        private static void init() {
            poly[400] = new TzPolygon(10.307525f,-5.327115f, 10.319864f,-5.300287f, 10.322351f,-5.206856f, 10.302064f,-5.192394f, 10.324627f,-5.157140f,
                    10.220008f,-5.158786f, 10.226661f,-5.126451f, 10.206492f,-5.129895f, 10.226842f,-5.094822f, 10.181299f,-5.114698f,
                    10.181726f,-5.073596f, 10.142308f,-5.079864f, 10.123763f,-5.044092f, 10.123878f,-5.078673f, 10.106580f,-5.076529f,
                    10.106138f,-5.047760f, 10.080732f,-5.062982f, 10.103954f,-5.003714f, 10.070326f,-5.021224f, 10.023647f,-4.961452f,
                    10.004031f,-4.964433f, 10.006623f,-4.989556f, 9.952507f,-4.946882f, 9.892443f,-4.967852f, 9.873501f,-4.934439f,
                    9.893553f,-4.913843f, 9.833396f,-4.788739f, 9.785122f,-4.788700f, 9.786519f,-4.816321f, 9.768057f,-4.809834f,
                    9.736217f,-4.776824f, 9.753817f,-4.771465f, 9.750185f,-4.741010f, 9.681592f,-4.695385f, 9.564156f,-4.695385f,
                    9.564156f,-5.327115f);
            poly[401] = new TzPolygon(9.681592f,-4.695385f, 9.677105f,-4.692400f, 9.722555f,-4.617725f, 9.687339f,-4.570990f, 9.719661f,-4.545346f,
                    9.740481f,-4.559288f, 9.742334f,-4.509500f, 9.659137f,-4.518873f, 9.662263f,-4.433447f, 9.594547f,-4.389462f,
                    9.626220f,-4.361242f, 9.599602f,-4.318694f, 9.622078f,-4.300447f, 9.756972f,-4.271105f, 9.775328f,-4.180421f,
                    9.831949f,-4.130129f, 9.808848f,-4.063655f, 9.564156f,-4.063655f, 9.564156f,-4.695385f);
            poly[402] = new TzPolygon(10.271452f,-2.800195f, 10.318419f,-2.854034f, 10.385194f,-2.834779f, 10.404427f,-2.800195f);
            poly[403] = new TzPolygon(10.426428f,-2.800195f, 10.451955f,-2.869885f, 10.629519f,-2.945597f, 10.686227f,-2.911277f, 10.715823f,-2.941347f,
                    10.774140f,-2.893785f, 10.878501f,-2.869361f, 10.913298f,-2.825063f, 10.959872f,-2.844743f, 11.004156f,-2.834325f,
                    11.003281f,-2.800195f);
            poly[404] = new TzPolygon(9.808848f,-4.063655f, 9.801636f,-4.042902f, 9.834204f,-4.030594f, 9.832970f,-3.980951f, 9.869460f,-3.972938f,
                    9.900578f,-3.900427f, 9.888268f,-3.809170f, 9.931648f,-3.751976f, 9.957134f,-3.641695f, 9.919691f,-3.599318f,
                    9.925076f,-3.469790f, 9.891124f,-3.349601f, 9.901510f,-3.315275f, 9.859146f,-3.318525f, 9.851628f,-3.281157f,
                    9.927480f,-3.195469f, 9.844904f,-3.186981f, 9.844567f,-3.125532f, 9.719488f,-3.060089f, 9.737350f,-3.006692f,
                    9.564156f,-2.918171f, 9.564156f,-4.063655f);
            poly[405] = new TzPolygon(7.955012f,-2.720771f, 8.027001f,-2.673052f, 8.042381f,-2.600105f, 8.074503f,-2.588279f, 8.148513f,-2.619182f,
                    8.205227f,-2.494897f, 8.778668f,-2.587169f, 8.784299f,-2.629772f, 8.817704f,-2.599925f, 8.909583f,-2.628101f,
                    8.947576f,-2.664097f, 8.999161f,-2.656192f, 9.024185f,-2.752771f, 9.055429f,-2.779666f, 9.132677f,-2.776157f,
                    9.247826f,-2.664351f, 9.309350f,-2.722318f, 9.379241f,-2.678855f, 9.496471f,-2.690352f, 9.564156f,-2.771273f,
                    9.564156f,-0.273275f, 7.955012f,-0.273275f);
            poly[406] = new TzPolygon(9.564156f,-2.800195f, 9.564156f,-2.771287f, 9.488792f,-2.689926f, 9.401108f,-2.763182f, 9.435936f,-2.800195f);
            poly[407] = new TzPolygon(9.564156f,-2.771273f, 9.642015f,-2.754237f, 9.705201f,-2.795654f, 9.747727f,-2.795241f, 9.828265f,-2.735684f,
                    9.892487f,-2.770882f, 9.956467f,-2.752748f, 10.106063f,-2.796424f, 10.180722f,-2.799592f, 10.238597f,-2.762533f,
                    10.271452f,-2.800195f, 10.404427f,-2.800195f, 10.417691f,-2.776345f, 10.426428f,-2.800195f, 11.003281f,-2.800195f,
                    10.976135f,-1.741705f, 10.996942f,-1.659856f, 10.988300f,-1.592670f, 11.018970f,-1.586861f, 11.018033f,-1.431780f,
                    10.990245f,-1.397374f, 10.994205f,-0.932981f, 10.959088f,-0.878686f, 10.989361f,-0.860749f, 11.002810f,-0.814127f,
                    10.980865f,-0.656417f, 10.953805f,-0.673144f, 10.938537f,-0.633894f, 10.902180f,-0.621151f, 10.912501f,-0.595608f,
                    10.981317f,-0.569656f, 10.984181f,-0.519407f, 11.024138f,-0.482618f, 11.029692f,-0.437513f, 11.098266f,-0.432699f,
                    11.120007f,-0.399639f, 11.116022f,-0.376659f, 11.068086f,-0.361077f, 11.103921f,-0.337401f, 11.121910f,-0.273974f,
                    11.143615f,-0.291391f, 11.173301f,-0.273275f, 9.564156f,-0.273275f);
            poly[408] = new TzPolygon(6.426924f,0.766709f, 6.432512f,0.756910f, 6.510959f,0.718745f, 6.577189f,0.737163f, 6.584340f,0.681031f,
                    6.607338f,0.679885f, 6.632189f,0.637556f, 6.745858f,0.644985f, 6.761607f,0.576387f, 6.800076f,0.566469f,
                    6.803752f,0.583959f, 6.825836f,0.530341f, 6.914354f,0.558188f, 6.934477f,0.542039f, 6.934477f,0.766709f);
            poly[409] = new TzPolygon(6.426924f,0.766709f, 6.370354f,0.865912f, 6.321336f,0.903840f, 6.323575f,0.996295f, 6.162475f,1.085882f,
                    6.155019f,1.191649f, 6.104417f,1.191781f, 6.035741f,1.075264f, 5.913476f,0.995660f, 5.837298f,0.981056f,
                    5.784073f,0.924824f, 5.762720f,0.766709f);
            poly[410] = new TzPolygon(6.284240f,1.806693f, 6.256431f,1.806693f, 6.225748f,1.627816f, 6.248093f,1.645669f);
            poly[411] = new TzPolygon(6.284240f,1.806693f, 6.463924f,1.750620f, 6.498353f,1.727938f, 6.500412f,1.695732f, 6.548019f,1.698008f,
                    6.557667f,1.668556f, 6.583197f,1.674293f, 6.605819f,1.609801f, 6.666285f,1.602837f, 6.688242f,1.573920f,
                    6.760242f,1.626102f, 6.806443f,1.596619f, 6.825077f,1.614786f, 6.868981f,1.594506f, 6.901865f,1.606222f,
                    6.923002f,1.577900f, 6.934477f,1.574808f, 6.934477f,1.806693f);
            poly[412] = new TzPolygon(8.347418f,0.721993f, 8.307272f,0.730367f, 8.284056f,0.725227f, 8.257078f,0.640832f, 8.197056f,0.591728f,
                    8.167120f,0.609462f, 8.089195f,0.591381f, 7.860689f,0.622494f, 7.705178f,0.617410f, 7.707022f,0.589766f,
                    7.616967f,0.578012f, 7.587568f,0.518584f, 7.463701f,0.501813f, 7.390865f,0.560040f, 7.390156f,0.646166f,
                    7.311095f,0.658360f, 7.132056f,0.598940f, 7.091365f,0.614360f, 7.013436f,0.599622f, 6.966551f,0.516299f,
                    6.934477f,0.542039f, 6.934477f,-0.273275f, 8.347418f,-0.273275f);
            poly[413] = new TzPolygon(6.934477f,1.806693f, 6.934477f,1.574808f, 6.997486f,1.557832f, 6.994573f,1.642032f, 7.417774f,1.636422f,
                    7.485553f,1.643882f, 7.497910f,1.677525f, 7.534023f,1.652930f, 7.661111f,1.631449f, 8.347418f,1.620177f,
                    8.347418f,1.806693f);
            poly[414] = new TzPolygon(9.760359f,-0.273275f, 9.760359f,0.326293f, 9.724616f,0.315030f, 9.661898f,0.361986f, 9.585025f,0.376331f,
                    9.570420f,0.237937f, 9.519634f,0.237106f, 9.503274f,0.305508f, 9.472002f,0.263339f, 9.480290f,0.228561f,
                    9.455466f,0.227102f, 9.422432f,0.272910f, 9.445063f,0.330866f, 9.491378f,0.353735f, 9.493739f,0.447481f,
                    9.402190f,0.562796f, 9.310391f,0.544984f, 9.262770f,0.505099f, 9.205269f,0.526362f, 9.146270f,0.470399f,
                    9.046906f,0.452927f, 8.875776f,0.528812f, 8.808764f,0.493377f, 8.807603f,0.447890f, 8.783875f,0.434169f,
                    8.790520f,0.390027f, 8.749467f,0.381674f, 8.606551f,0.466131f, 8.491966f,0.643656f, 8.420437f,0.663840f,
                    8.384398f,0.714280f, 8.347418f,0.721993f, 8.347418f,-0.273275f);
            poly[415] = new TzPolygon(8.347418f,1.620177f, 8.374103f,1.619739f, 8.477665f,1.650187f, 8.518692f,1.631122f, 9.042293f,1.624833f,
                    9.170154f,1.559118f, 9.307435f,1.420920f, 9.497304f,1.390208f, 9.486378f,1.361089f, 9.546260f,1.341589f,
                    9.661502f,1.369304f, 9.760359f,1.365186f, 9.760359f,1.806693f, 8.347418f,1.806693f);
            poly[416] = new TzPolygon(11.173301f,-0.273275f, 11.138977f,-0.142005f, 11.104910f,-0.145849f, 11.090066f,-0.111697f, 11.106096f,-0.018740f,
                    11.092212f,0.017763f, 10.984734f,0.032068f, 10.956484f,-0.011677f, 10.817951f,-0.028104f, 10.769341f,-0.073564f,
                    10.714592f,-0.088137f, 10.641025f,-0.063918f, 10.530698f,0.131929f, 10.396866f,0.192661f, 10.417224f,0.213201f,
                    10.416032f,0.281502f, 10.372401f,0.289441f, 10.329201f,0.331277f, 10.305450f,0.318884f, 10.304264f,0.392497f,
                    10.252584f,0.359138f, 10.095751f,0.347781f, 10.053377f,0.414615f, 10.017003f,0.404156f, 10.028897f,0.353055f,
                    9.977185f,0.353598f, 9.937587f,0.382358f, 9.910736f,0.348897f, 9.842957f,0.352318f, 9.760359f,0.326293f,
                    9.760359f,-0.273275f);
            poly[417] = new TzPolygon(11.173301f,0.766709f, 10.996982f,0.766709f, 10.997355f,0.656307f, 10.930997f,0.494682f, 11.009084f,0.502847f,
                    11.173301f,-0.273275f);
            poly[418] = new TzPolygon(11.173301f,1.159502f, 11.164371f,1.160053f, 11.171608f,1.118336f, 11.127711f,1.050938f, 11.113338f,1.086619f,
                    11.030404f,1.110176f, 11.059021f,1.069570f, 11.049483f,1.035143f, 11.083440f,1.013135f, 11.090450f,0.978646f,
                    10.996490f,0.912155f, 10.996982f,0.766709f, 11.173301f,0.766709f);
            poly[419] = new TzPolygon(10.996982f,0.766709f, 10.996490f,0.912155f, 10.804958f,0.873821f, 10.718287f,0.801826f, 10.590958f,0.807566f,
                    10.384764f,0.774575f, 10.179353f,1.056815f, 10.000000f,1.355205f, 9.760359f,1.365186f, 9.760359f,0.766709f);
            poly[420] = new TzPolygon(7.841293f,1.806693f, 7.841293f,2.698766f, 7.792222f,2.729464f, 7.580174f,2.730281f, 7.527503f,2.749486f,
                    7.494520f,2.792927f, 7.437972f,2.799681f, 7.417439f,2.747578f, 7.261153f,2.749460f, 7.234420f,2.774254f,
                    7.159227f,2.784869f, 7.092677f,2.745093f, 7.041276f,2.792603f, 6.986536f,2.720640f, 6.940331f,2.718215f,
                    6.912416f,2.751513f, 6.778647f,2.732744f, 6.738933f,2.789703f, 6.694790f,2.786590f, 6.630785f,2.731428f,
                    6.570467f,2.753123f, 6.507771f,2.720289f, 6.368820f,2.709604f, 6.327712f,2.222245f, 6.256431f,1.806693f,
                    6.284240f,1.806693f);
            poly[421] = new TzPolygon(7.841293f,2.698766f, 7.889781f,2.668432f, 7.930818f,2.695501f, 8.211312f,2.754102f, 8.324169f,2.695632f,
                    8.420317f,2.706947f, 8.445014f,2.740681f, 8.505328f,2.761837f, 8.772683f,2.728413f, 8.809783f,2.763381f,
                    8.894723f,2.773553f, 8.907859f,2.758113f, 8.970237f,2.788786f, 9.065207f,2.780915f, 9.062149f,2.867592f,
                    9.092599f,2.953382f, 9.073917f,3.008144f, 9.101578f,3.088169f, 9.252194f,3.126350f, 9.282456f,3.157170f,
                    9.462844f,3.136215f, 9.507297f,3.186117f, 9.507297f,4.465083f, 7.841293f,4.465083f);
            poly[422] = new TzPolygon(9.507297f,3.186117f, 9.515109f,3.194886f, 9.652356f,3.263500f, 9.657742f,3.315170f, 9.685226f,3.348598f,
                    9.776752f,3.323343f, 9.817596f,3.346855f, 9.861171f,3.456388f, 9.862082f,3.529646f, 9.945736f,3.595777f,
                    10.075980f,3.615721f, 10.107061f,3.662934f, 10.169748f,3.678951f, 10.221718f,3.612528f, 10.275146f,3.584625f,
                    10.417266f,3.631809f, 10.456362f,3.687709f, 10.405383f,3.786002f, 10.599811f,3.850976f, 10.704922f,3.840979f,
                    10.735463f,3.797159f, 10.825560f,3.749384f, 10.930770f,3.771224f, 11.010634f,3.751768f, 11.024343f,3.716902f,
                    11.124095f,3.725914f, 11.128139f,3.691927f, 11.173301f,3.638001f, 11.173301f,4.465083f, 9.507297f,4.465083f);
            poly[423] = new TzPolygon(11.432508f,-5.327115f, 11.432508f,-5.199527f, 11.358822f,-5.265651f, 11.234489f,-5.272127f, 11.198223f,-5.327115f);
            poly[424] = new TzPolygon(11.432508f,-5.199527f, 11.585302f,-5.223245f, 11.619288f,-5.299093f, 11.763700f,-5.263980f, 11.788111f,-5.316014f,
                    11.788111f,-5.199527f);
            poly[425] = new TzPolygon(20.373875f,-5.199527f, 11.904181f,-5.199527f, 11.835576f,-5.267698f, 11.854169f,-5.286191f, 11.836506f,-5.327115f,
                    20.373875f,-5.327115f);
            poly[426] = new TzPolygon(13.127947f,-5.199527f, 13.127947f,-4.351348f, 12.949829f,-4.231950f, 12.778131f,-4.228288f, 12.725898f,-4.248287f,
                    12.699240f,-4.294474f, 12.731423f,-4.369590f, 12.710483f,-4.489498f, 12.651656f,-4.487478f, 12.602092f,-4.428079f,
                    12.531888f,-4.393459f, 12.414710f,-4.452916f, 12.314307f,-4.421036f, 12.322833f,-4.484440f, 12.267612f,-4.503342f,
                    12.189937f,-4.590875f, 12.134602f,-4.569054f, 12.113600f,-4.625549f, 12.053868f,-4.658313f, 12.050063f,-4.707304f,
                    11.996787f,-4.734348f, 12.017387f,-4.840816f, 11.981522f,-5.078550f, 11.949443f,-5.154552f, 11.904181f,-5.199527f);
            poly[427] = new TzPolygon(13.127947f,-4.351348f, 13.133988f,-4.355398f, 13.180732f,-4.287360f, 13.182652f,-4.246329f, 13.229729f,-4.258330f,
                    13.311843f,-4.133372f, 13.395359f,-4.092478f, 13.439881f,-3.998429f, 13.495845f,-3.984532f, 13.495342f,-3.956788f,
                    13.459262f,-3.946271f, 13.444564f,-3.915836f, 13.407557f,-3.974844f, 13.382822f,-3.960848f, 13.358526f,-3.797708f,
                    13.202238f,-3.599840f, 13.171988f,-3.532245f, 13.162863f,-3.433222f, 13.263376f,-3.431493f, 13.283864f,-3.256077f,
                    13.305626f,-3.237766f, 13.534143f,-3.282000f, 13.648494f,-3.255122f, 13.715793f,-3.279644f, 13.685327f,-3.185615f,
                    13.695428f,-3.107286f, 13.623915f,-3.051451f, 13.667566f,-3.006520f, 13.626776f,-2.953706f, 13.655334f,-2.871966f,
                    13.724443f,-2.903039f, 13.825576f,-2.895913f, 13.997855f,-2.832427f, 14.002218f,-2.851354f, 14.060630f,-2.837031f,
                    14.063415f,-2.830801f, 13.127947f,-2.830801f);
            poly[428] = new TzPolygon(15.082593f,-0.462076f, 15.079910f,-0.720203f, 14.790123f,-1.087860f, 14.733589f,-1.314944f, 14.506894f,-1.674909f,
                    14.482295f,-1.757676f, 14.480876f,-1.975367f, 14.195762f,-1.993668f, 14.150282f,-2.105820f, 14.252217f,-2.291982f,
                    14.297865f,-2.476469f, 14.134245f,-2.672331f, 14.063415f,-2.830801f, 15.082593f,-2.830801f);
            poly[429] = new TzPolygon(11.173301f,1.157977f, 11.265936f,1.136440f, 11.245324f,1.252071f, 11.264238f,1.276253f, 11.320992f,1.259089f,
                    11.289876f,1.325122f, 11.311295f,1.340917f, 11.362756f,1.320047f, 11.399461f,1.388263f, 11.442225f,1.384437f,
                    11.470548f,1.434311f, 11.173301f,1.434311f);
            poly[430] = new TzPolygon(12.743485f,1.434311f, 13.047900f,1.065802f, 13.059218f,0.992786f, 13.127947f,0.992573f, 13.127947f,1.434311f);
            poly[431] = new TzPolygon(12.150624f,3.103872f, 12.150624f,3.330698f, 11.888887f,3.330698f, 11.887661f,3.307631f, 11.994179f,3.248569f,
                    12.016192f,3.261755f);
            poly[432] = new TzPolygon(12.150624f,2.398831f, 12.142663f,2.399829f, 11.994620f,2.468418f, 11.955391f,2.431235f, 11.952911f,2.401563f,
                    11.901612f,2.405395f, 12.150624f,2.214298f);
            poly[433] = new TzPolygon(12.150624f,1.434311f, 12.150624f,2.214298f, 11.901612f,2.405395f, 11.793143f,2.372374f, 11.785372f,2.340380f,
                    11.735291f,2.303669f, 11.674421f,2.305729f, 11.597241f,2.185440f, 11.427713f,2.019249f, 11.444384f,1.841670f,
                    11.416741f,1.752393f, 11.429130f,1.714145f, 11.407961f,1.699712f, 11.390404f,1.620471f, 11.398189f,1.592951f,
                    11.471489f,1.554366f, 11.447311f,1.531788f, 11.472098f,1.434311f);
            poly[434] = new TzPolygon(12.150624f,2.398831f, 12.242217f,2.387346f, 12.268689f,2.494419f, 12.294403f,2.514347f, 12.274584f,2.536060f,
                    12.304181f,2.663131f, 12.280666f,2.686227f, 12.349338f,2.715879f, 12.418347f,2.794593f, 12.389774f,2.866644f,
                    12.272345f,3.001497f, 12.190688f,3.056818f, 12.150624f,3.103872f);
            poly[435] = new TzPolygon(12.743485f,1.434311f, 12.631305f,1.570111f, 12.616357f,1.863835f, 12.704566f,1.924723f, 12.697496f,1.948870f,
                    12.738781f,1.986293f, 12.726534f,2.098688f, 12.665193f,2.122747f, 12.611071f,2.214413f, 12.525083f,2.216421f,
                    12.428378f,2.274273f, 12.419984f,2.155155f, 12.379086f,2.107401f, 12.391980f,2.073011f, 12.352380f,2.059467f,
                    12.150624f,2.214298f, 12.150624f,1.434311f);
            poly[436] = new TzPolygon(15.082593f,1.100242f, 14.978951f,0.973189f, 14.945825f,0.703158f, 15.001424f,0.512085f, 14.969600f,0.401776f,
                    14.989659f,0.268592f, 14.985179f,-0.009211f, 15.076954f,-0.253790f, 15.007614f,-0.388667f, 15.082593f,-0.462076f);
            poly[437] = new TzPolygon(15.082593f,-0.462076f, 15.007614f,-0.388667f, 15.076954f,-0.253790f, 14.985179f,-0.009211f, 14.989671f,0.229351f,
                    14.886071f,0.235736f, 14.806706f,0.190881f, 14.756286f,0.202436f, 14.523348f,0.167995f, 14.364031f,0.288968f,
                    14.335680f,0.362986f, 14.265839f,0.391382f, 14.139214f,0.357350f, 14.027875f,0.398786f, 13.977721f,0.450281f,
                    13.952679f,0.450720f, 13.965769f,0.480504f, 13.917692f,0.473359f, 13.840676f,0.530440f, 13.787557f,0.589423f,
                    13.786627f,0.620477f, 13.730409f,0.599734f, 13.699059f,0.619017f, 13.692969f,0.772598f, 13.677268f,0.796923f,
                    13.642696f,0.781645f, 13.624112f,0.897423f, 13.566094f,0.998148f, 13.486142f,1.044918f, 13.445189f,1.037644f,
                    13.393120f,1.143640f, 13.402361f,1.245755f, 13.358625f,1.280971f, 13.333696f,1.231296f, 13.373847f,1.202298f,
                    13.316788f,1.182509f, 13.370920f,0.991822f, 13.127947f,0.992573f, 13.127947f,-0.462076f);
            poly[438] = new TzPolygon(11.888887f,3.330698f, 11.891026f,3.370941f, 11.854339f,3.485037f, 11.783440f,3.526306f, 11.776603f,3.558566f,
                    11.730397f,3.555143f, 11.696975f,3.605074f, 11.601606f,3.561241f, 11.292326f,3.495874f, 11.173301f,3.638001f,
                    11.173301f,3.330698f);
            poly[439] = new TzPolygon(11.173301f,3.638001f, 11.292326f,3.495874f, 11.616995f,3.565960f, 11.691838f,3.600056f, 11.758454f,3.679195f,
                    11.810472f,3.665852f, 11.839364f,3.626731f, 11.916888f,3.617670f, 11.977861f,3.668822f, 12.117120f,3.630781f,
                    12.268548f,3.657529f, 12.520149f,3.642556f, 12.764190f,3.942208f, 12.996067f,4.096463f, 13.148302f,4.129665f,
                    13.472634f,4.130281f, 13.473179f,4.197474f, 13.703427f,4.464738f, 13.782478f,4.870761f, 13.748610f,4.909519f,
                    13.746101f,5.270488f, 13.844792f,5.354970f, 13.892007f,5.526512f, 13.642835f,6.149414f, 13.666857f,6.283037f,
                    13.601575f,6.421309f, 13.355463f,6.677834f, 13.117972f,6.818586f, 12.989853f,6.928008f, 13.021093f,7.123472f,
                    11.173301f,7.123472f);
            poly[440] = new TzPolygon(15.082593f,1.093269f, 15.265145f,1.324030f, 15.367121f,2.628790f, 15.341487f,3.527506f, 15.488314f,3.538171f,
                    15.526161f,3.607660f, 15.639359f,3.706119f, 15.669553f,3.837933f, 15.717040f,3.889080f, 15.909518f,3.929572f,
                    15.985981f,4.004404f, 16.060646f,3.987741f, 16.221619f,4.042722f, 15.082593f,4.042722f);
            poly[441] = new TzPolygon(20.373875f,4.042722f, 19.096399f,4.042722f, 18.960028f,3.333774f, 19.113857f,3.127324f, 19.159056f,3.107240f,
                    19.269154f,3.193857f, 19.335358f,3.209996f, 19.395109f,3.271068f, 19.478935f,3.234671f, 19.517080f,3.249852f,
                    19.577997f,3.210657f, 19.645351f,3.233783f, 19.680862f,3.212268f, 19.824564f,3.231133f, 19.838087f,3.167266f,
                    19.950565f,2.964042f, 20.004688f,2.705234f, 20.004887f,2.578319f, 20.061243f,2.467937f, 20.056179f,2.418841f,
                    20.208292f,2.317848f, 20.285780f,2.210636f, 20.287979f,2.173081f, 20.212132f,2.095358f, 20.256464f,2.045671f,
                    20.241829f,2.009984f, 20.260506f,1.958792f, 20.238632f,1.916876f, 20.298286f,1.876006f, 20.299778f,1.798455f,
                    20.373875f,1.713168f);
            poly[442] = new TzPolygon(19.097693f,4.042722f, 19.136717f,4.242888f, 18.810007f,4.244968f, 16.987701f,4.241203f, 16.912310f,4.076758f,
                    16.320419f,4.076468f, 16.221619f,4.042722f);
            poly[443] = new TzPolygon(20.373875f,6.881532f, 19.437710f,5.817081f, 19.096399f,4.042722f, 20.373875f,4.042722f);
            poly[444] = new TzPolygon(-12.740888f,-49.201183f, -12.617740f,-49.124710f, -12.556720f,-49.048920f, -12.621610f,-49.052181f, -12.639330f,-48.975368f,
                    -12.757780f,-48.908501f, -13.185250f,-48.798031f, -13.188610f,-48.725128f, -13.044630f,-48.621929f, -13.066080f,-48.445400f,
                    -13.032800f,-48.155300f, -13.079400f,-48.141102f, -13.177500f,-48.176701f, -13.269330f,-47.976089f, -13.312320f,-47.761440f,
                    -13.306980f,-47.717541f, -13.100240f,-47.684620f, -13.101900f,-47.649700f, -13.181100f,-47.589699f, -13.300800f,-47.538898f,
                    -13.094610f,-47.247509f, -13.031860f,-46.957458f, -13.031710f,-46.858429f, -13.013379f,-46.815085f, -17.078349f,-46.815085f,
                    -17.078349f,-49.201183f);
            poly[445] = new TzPolygon(-14.817534f,-45.991090f, -14.817534f,-45.285140f, -14.859724f,-45.320557f, -14.936945f,-45.451393f, -14.934168f,-45.556671f,
                    -15.017778f,-45.612503f, -15.042501f,-45.657227f, -15.098333f,-45.678337f, -15.147501f,-45.747223f, -15.122223f,-45.916946f,
                    -15.191946f,-45.972504f, -15.219301f,-46.040031f, -15.246113f,-46.050835f, -15.243057f,-46.081390f, -15.000000f,-45.974724f,
                    -14.861113f,-46.021118f);
            poly[446] = new TzPolygon(-12.556720f,-46.157710f, -12.600279f,-46.156952f, -12.711668f,-46.234169f, -12.789247f,-46.239391f, -12.878180f,-46.582802f,
                    -12.962360f,-46.694450f, -13.013379f,-46.815085f, -12.556720f,-46.815085f);
            poly[447] = new TzPolygon(-14.817534f,-45.991090f, -14.703890f,-45.912781f, -14.502224f,-45.970840f, -14.360279f,-45.916389f, -14.303890f,-46.007782f,
                    -14.230556f,-46.058060f, -14.189724f,-46.125839f, -14.071390f,-46.170280f, -13.995556f,-46.225563f, -13.881390f,-46.258896f,
                    -13.656668f,-46.272781f, -13.424168f,-46.202507f, -13.343613f,-46.088058f, -13.301390f,-46.073891f, -13.250557f,-46.081947f,
                    -13.209446f,-46.182785f, -13.061668f,-46.166389f, -13.027224f,-46.151672f, -12.958334f,-46.060562f, -12.779167f,-46.244171f,
                    -12.711668f,-46.234169f, -12.600279f,-46.156952f, -12.556720f,-46.159133f, -12.556720f,-44.428988f, -14.293209f,-44.428988f,
                    -14.398890f,-44.660835f, -14.448057f,-44.708893f, -14.515556f,-44.836395f, -14.577501f,-44.848892f, -14.601112f,-44.880836f,
                    -14.715557f,-45.091667f, -14.731668f,-45.213058f, -14.817534f,-45.285140f);
            poly[448] = new TzPolygon(-18.332932f,-39.656792f, -18.010281f,-40.188339f, -17.930000f,-40.230835f, -17.829170f,-40.183334f, -17.751114f,-40.216667f,
                    -17.713337f,-40.293892f, -17.667225f,-40.317505f, -17.633057f,-40.376396f, -17.562778f,-40.403336f, -17.559170f,-40.488060f,
                    -17.430836f,-40.483063f, -17.425556f,-40.539452f, -17.359726f,-40.515556f, -17.371391f,-40.558060f, -17.414448f,-40.585556f,
                    -17.398613f,-40.610001f, -17.301392f,-40.601395f, -17.251114f,-40.559723f, -17.121113f,-40.574448f, -17.078349f,-40.563061f,
                    -17.078349f,-39.656792f);
            poly[449] = new TzPolygon(-14.297683f,-44.428988f, -14.244167f,-44.321396f, -14.259445f,-44.241951f, -14.236113f,-44.213615f, -14.269445f,-44.177223f,
                    -14.289167f,-44.033340f, -14.273890f,-43.994446f, -14.303890f,-43.954445f, -14.315556f,-43.831673f, -14.342232f,-43.789444f,
                    -14.515556f,-43.871948f, -14.643333f,-43.870560f, -14.685835f,-43.844170f, -14.712502f,-43.727783f, -14.738890f,-43.708618f,
                    -14.788612f,-43.492500f, -14.778891f,-43.446671f, -14.703890f,-43.390282f, -14.652500f,-43.281952f, -14.635557f,-43.151672f,
                    -14.683334f,-42.942780f, -14.756111f,-42.883614f, -14.940834f,-42.636116f, -14.931667f,-42.563614f, -15.035557f,-42.425560f,
                    -15.108334f,-42.266945f, -15.120834f,-42.203613f, -15.105278f,-42.166389f, -15.183613f,-42.091667f, -15.181080f,-42.042890f,
                    -17.078349f,-42.042890f, -17.078349f,-44.428988f);
            poly[450] = new TzPolygon(-15.181080f,-42.042890f, -15.176111f,-41.947227f, -15.121389f,-41.855835f, -15.109167f,-41.790840f, -15.498611f,-41.356949f,
                    -15.751112f,-41.327507f, -15.738056f,-41.274727f, -15.784445f,-41.146667f, -15.672224f,-40.933891f, -15.698334f,-40.896667f,
                    -15.684168f,-40.811951f, -15.744167f,-40.753891f, -15.720001f,-40.634171f, -15.740002f,-40.590836f, -15.802223f,-40.542503f,
                    -15.773056f,-40.470558f, -15.822224f,-40.357506f, -15.823057f,-40.213341f, -15.898890f,-40.173058f, -15.896667f,-40.115837f,
                    -15.977222f,-40.036667f, -16.002224f,-39.933617f, -16.067780f,-39.884445f, -16.151947f,-39.861389f, -16.161114f,-39.890839f,
                    -16.321392f,-39.946671f, -16.394726f,-40.057503f, -16.483059f,-40.130836f, -16.549168f,-40.139168f, -16.544170f,-40.196671f,
                    -16.583336f,-40.269730f, -16.755558f,-40.283340f, -16.844448f,-40.245834f, -16.884724f,-40.304169f, -16.867226f,-40.476112f,
                    -16.920834f,-40.521118f, -17.078349f,-40.563061f, -17.078349f,-42.042890f);
            poly[451] = new TzPolygon(-7.791389f,-49.201183f, -7.791389f,-49.154449f, -8.052778f,-49.196396f, -8.059852f,-49.201183f);
            poly[452] = new TzPolygon(-7.751123f,-49.201183f, -7.791389f,-49.154449f, -7.791389f,-49.201183f);
            poly[453] = new TzPolygon(-12.556720f,-46.159133f, -12.495001f,-46.162224f, -12.431112f,-46.310562f, -12.343334f,-46.345558f, -12.098612f,-46.331673f,
                    -12.056391f,-46.256668f, -11.997501f,-46.210838f, -11.920000f,-46.067780f, -11.865278f,-46.102226f, -11.835279f,-46.156670f,
                    -11.841946f,-46.261391f, -11.753613f,-46.272507f, -11.659445f,-46.090836f, -11.609724f,-46.080002f, -11.544724f,-46.190559f,
                    -11.495556f,-46.442223f, -11.414167f,-46.491112f, -11.370001f,-46.559174f, -11.328890f,-46.572227f, -11.256151f,-46.540208f,
                    -11.256151f,-44.198925f, -12.556720f,-44.198925f);
            poly[454] = new TzPolygon(-9.955582f,-46.464415f, -10.013889f,-46.467506f, -10.178612f,-46.342781f, -10.175556f,-46.188614f, -10.206945f,-46.088615f,
                    -10.277224f,-46.027229f, -10.312500f,-45.964172f, -10.330833f,-45.757782f, -10.350000f,-45.789452f, -10.431112f,-45.812225f,
                    -10.460279f,-45.845558f, -10.573612f,-46.034172f, -10.582779f,-46.085007f, -10.765001f,-46.309448f, -10.791113f,-46.313614f,
                    -10.807501f,-46.273338f, -10.903334f,-46.229729f, -10.980001f,-46.380280f, -11.189445f,-46.467781f, -11.226667f,-46.527229f,
                    -11.256151f,-46.541740f, -11.256151f,-46.676687f, -9.955582f,-46.676687f);
            poly[455] = new TzPolygon(-9.955582f,-46.464415f, -9.955582f,-44.198925f, -10.622567f,-44.198925f, -10.630001f,-44.216949f, -10.585835f,-44.403336f,
                    -10.635834f,-44.552505f, -10.738890f,-44.650841f, -10.778334f,-44.750282f, -10.872501f,-44.803062f, -10.863611f,-44.952507f,
                    -10.896946f,-45.057228f, -10.784168f,-45.274727f, -10.778334f,-45.326393f, -10.618612f,-45.440559f, -10.468056f,-45.479729f,
                    -10.331112f,-45.603340f, -10.317688f,-45.945984f, -10.286667f,-46.015839f, -10.218613f,-46.071945f, -10.195557f,-46.119728f,
                    -10.173056f,-46.215279f, -10.190834f,-46.306946f, -10.178612f,-46.342781f, -10.013889f,-46.467506f);
            poly[456] = new TzPolygon(-9.442555f,-46.676687f, -9.385557f,-46.790558f, -9.314724f,-46.829170f, -9.177223f,-46.841667f, -9.109724f,-46.882225f,
                    -9.067501f,-46.944725f, -9.067223f,-47.034172f, -9.044168f,-47.081390f, -8.976667f,-47.064171f, -8.822779f,-46.899727f,
                    -8.736389f,-46.923058f, -8.467224f,-46.827507f, -8.406389f,-46.718895f, -8.404719f,-46.676687f);
            poly[457] = new TzPolygon(-7.915393f,-46.676687f, -7.959445f,-46.870834f, -8.032501f,-46.963890f, -8.043056f,-47.020004f, -7.988890f,-47.047783f,
                    -7.980000f,-47.080284f, -7.857223f,-47.148613f, -7.819167f,-47.208618f, -7.749167f,-47.239174f, -7.735001f,-47.281670f,
                    -7.700834f,-47.277504f, -7.639723f,-47.313614f, -7.640278f,-47.330284f, -7.665833f,-47.330559f, -7.658334f,-47.348335f,
                    -7.583889f,-47.367226f, -7.575556f,-47.408340f, -7.533056f,-47.402504f, -7.536112f,-47.465279f, -7.446667f,-47.503616f,
                    -7.446112f,-47.589172f, -7.380000f,-47.479446f, -7.354445f,-47.484952f, -7.354445f,-46.676687f);
            poly[458] = new TzPolygon(-7.915393f,-46.676687f, -7.898056f,-46.600281f, -7.966111f,-46.486671f, -8.068056f,-46.463058f, -8.165279f,-46.506950f,
                    -8.200279f,-46.487228f, -8.283611f,-46.509727f, -8.315279f,-46.547226f, -8.397223f,-46.487228f, -8.404719f,-46.676687f);
            poly[459] = new TzPolygon(-9.442555f,-46.676687f, -9.512222f,-46.537506f, -9.551111f,-46.533340f, -9.607500f,-46.587784f, -9.652779f,-46.599167f,
                    -9.682779f,-46.665283f, -9.752224f,-46.668335f, -9.873335f,-46.488892f, -9.930000f,-46.463058f, -9.955582f,-46.464415f,
                    -9.955582f,-46.676687f);
            poly[460] = new TzPolygon(-9.955582f,-44.198925f, -9.955582f,-43.714502f, -10.064445f,-43.707230f, -10.111389f,-43.757507f, -10.177223f,-43.763618f,
                    -10.200279f,-43.802780f, -10.355835f,-43.871117f, -10.376945f,-43.905281f, -10.440556f,-43.918892f, -10.448057f,-43.989174f,
                    -10.589445f,-44.118614f, -10.622567f,-44.198925f);
            poly[461] = new TzPolygon(-9.955582f,-43.714502f, -9.939724f,-43.715561f, -9.863611f,-43.680000f, -9.801668f,-43.682503f, -9.737780f,-43.734169f,
                    -9.567780f,-43.778893f, -9.466391f,-43.835281f, -9.428057f,-43.803894f, -9.448891f,-43.700005f, -9.352501f,-43.650002f,
                    -9.334723f,-43.619446f, -9.362223f,-43.521118f, -9.304167f,-43.481674f, -9.300835f,-43.453613f, -9.433613f,-43.353615f,
                    -9.404167f,-43.300285f, -9.419724f,-43.184448f, -9.387779f,-43.167229f, -9.370279f,-43.123611f, -9.396667f,-43.038612f,
                    -9.440556f,-43.022224f, -9.449722f,-42.936111f, -9.512222f,-42.935562f, -9.551668f,-42.848618f, -9.520000f,-42.748894f,
                    -9.530001f,-42.677223f, -9.569168f,-42.625839f, -9.484167f,-42.585281f, -9.497778f,-42.483612f, -9.408890f,-42.431946f,
                    -9.377501f,-42.366951f, -9.307222f,-42.313614f, -9.321390f,-42.274170f, -9.295557f,-42.149445f, -9.204445f,-42.039452f,
                    -9.225000f,-42.014450f, -9.206390f,-41.991394f, -9.225834f,-41.955002f, -9.210001f,-41.922501f, -9.253056f,-41.849724f,
                    -9.173889f,-41.796951f, -9.139446f,-41.732780f, -8.981112f,-41.740005f, -8.978499f,-41.721163f, -9.955582f,-41.721163f);
            poly[462] = new TzPolygon(-8.655013f,-41.721163f, -8.655013f,-41.253474f, -8.711945f,-41.370834f, -8.934168f,-41.497780f, -8.976946f,-41.565559f,
                    -8.962778f,-41.607780f, -8.978499f,-41.721163f);
            poly[463] = new TzPolygon(-8.655013f,-41.253474f, -8.655013f,-39.669038f, -8.659445f,-39.686111f, -8.786112f,-39.685280f, -8.829445f,-39.891670f,
                    -8.958889f,-39.888618f, -9.045557f,-39.968895f, -9.105001f,-40.115837f, -9.064445f,-40.208061f, -9.069168f,-40.244446f,
                    -9.117779f,-40.280006f, -9.364723f,-40.334167f, -9.362780f,-40.417229f, -9.410002f,-40.453339f, -9.410833f,-40.511116f,
                    -9.471668f,-40.561111f, -9.488335f,-40.634171f, -9.452951f,-40.758301f, -9.345001f,-40.689171f, -9.221390f,-40.702507f,
                    -9.154167f,-40.853889f, -9.081945f,-40.857224f, -9.025278f,-40.895836f, -8.845001f,-40.897224f, -8.823057f,-40.924171f,
                    -8.829723f,-40.973618f, -8.771946f,-41.002228f, -8.785557f,-41.093895f, -8.713612f,-41.113060f, -8.709723f,-41.225838f,
                    -8.738611f,-41.293335f, -8.711945f,-41.370834f);
            poly[464] = new TzPolygon(-7.354445f,-39.917503f, -7.419445f,-40.154167f, -7.391111f,-40.270004f, -7.399723f,-40.651947f, -7.423889f,-40.688614f,
                    -7.486945f,-40.695557f, -7.655834f,-40.618340f, -7.756111f,-40.663063f, -7.824445f,-40.551392f, -7.860834f,-40.532501f,
                    -8.003889f,-40.536949f, -8.108334f,-40.578896f, -8.245834f,-40.753334f, -8.363335f,-40.824173f, -8.343334f,-40.885834f,
                    -8.428057f,-40.903954f, -8.415556f,-41.015839f, -8.525835f,-41.079727f, -8.542223f,-41.152229f, -8.630556f,-41.203056f,
                    -8.655013f,-41.253474f, -8.655013f,-41.721163f, -7.354445f,-41.721163f);
            poly[465] = new TzPolygon(-7.684195f,-39.243401f, -7.677778f,-39.256950f, -7.551667f,-39.341667f, -7.481668f,-39.528336f, -7.371112f,-39.665840f,
                    -7.354445f,-39.917503f, -7.354445f,-39.243401f);
            poly[466] = new TzPolygon(-8.655013f,-39.669038f, -8.631111f,-39.576950f, -8.540279f,-39.419449f, -8.530834f,-39.367500f, -8.569445f,-39.276947f,
                    -8.632456f,-39.243401f, -8.655013f,-39.243401f);
            poly[467] = new TzPolygon(-5.267222f,-48.040957f, -5.269167f,-48.043617f, -5.267222f,-48.138664f);
            poly[468] = new TzPolygon(-5.267222f,-48.562847f, -5.328334f,-48.602226f, -5.303889f,-48.663338f, -5.358612f,-48.718895f, -5.353333f,-48.750557f,
                    -5.267222f,-48.643768f);
            poly[469] = new TzPolygon(-5.267222f,-49.201183f, -5.267222f,-48.643768f, -5.353333f,-48.750557f, -5.410833f,-48.569168f, -5.398612f,-48.371674f,
                    -5.516389f,-48.298058f, -5.541112f,-48.212784f, -5.610001f,-48.142784f, -5.697779f,-48.168892f, -5.722501f,-48.272507f,
                    -5.759167f,-48.302223f, -5.833334f,-48.289452f, -5.907500f,-48.225838f, -5.936389f,-48.228340f, -5.983056f,-48.336670f,
                    -6.032581f,-48.336403f, -6.055905f,-48.286522f, -6.103333f,-48.289452f, -6.142778f,-48.403336f, -6.182222f,-48.434174f,
                    -6.364722f,-48.381950f, -6.355000f,-48.506950f, -6.437778f,-48.603058f, -6.525001f,-48.662224f, -6.655001f,-48.667229f,
                    -6.740001f,-48.846947f, -6.798889f,-49.038895f, -6.918279f,-49.201183f);
            poly[470] = new TzPolygon(-7.071958f,-49.201183f, -7.251390f,-49.186111f, -7.274446f,-49.201183f);
            poly[471] = new TzPolygon(-7.354445f,-47.484952f, -7.289722f,-47.498894f, -7.272779f,-47.584450f, -7.308612f,-47.640556f, -7.255000f,-47.669174f,
                    -7.211112f,-47.736946f, -7.161389f,-47.726112f, -7.143889f,-47.682503f, -7.157223f,-47.637779f, -6.988056f,-47.501396f,
                    -6.671945f,-47.483894f, -6.621945f,-47.456947f, -6.558612f,-47.454727f, -6.491667f,-47.410561f, -6.432501f,-47.424446f,
                    -6.397500f,-47.403618f, -6.336667f,-47.406670f, -6.276112f,-47.370003f, -6.106112f,-47.427223f, -5.870556f,-47.413338f,
                    -5.746945f,-47.478615f, -5.629168f,-47.465004f, -5.542778f,-47.487503f, -5.475556f,-47.543617f, -5.475278f,-47.601952f,
                    -5.386667f,-47.742783f, -5.385000f,-47.838890f, -5.300279f,-47.857780f, -5.267222f,-47.885497f, -5.267222f,-46.716667f,
                    -7.354445f,-46.716667f);
            poly[472] = new TzPolygon(-5.267222f,-48.562847f, -5.199445f,-48.519173f, -5.164167f,-48.385002f, -5.168889f,-48.333893f, -5.266945f,-48.152229f,
                    -5.267222f,-48.138664f);
            poly[473] = new TzPolygon(-5.267222f,-48.040957f, -5.234445f,-47.996117f, -5.255556f,-47.895279f, -5.267222f,-47.885497f);
            poly[474] = new TzPolygon(-3.180000f,-46.716667f, -3.205278f,-46.765556f, -3.234723f,-46.756668f, -3.276389f,-46.803894f, -3.329167f,-46.820282f,
                    -3.342778f,-46.888893f, -3.401667f,-46.944450f, -3.524167f,-46.968338f, -3.569167f,-47.034172f, -3.813334f,-47.057503f,
                    -3.893889f,-47.086113f, -3.919167f,-47.136116f, -4.043334f,-47.237228f, -4.053056f,-47.278336f, -4.081389f,-47.292229f,
                    -4.077223f,-47.320282f, -4.260556f,-47.356674f, -4.333889f,-47.454445f, -4.419723f,-47.486946f, -4.555000f,-47.587502f,
                    -4.610556f,-47.661949f, -4.593334f,-47.808060f, -5.267222f,-48.643768f, -5.267222f,-49.201183f, -3.180000f,-49.201183f);
            poly[475] = new TzPolygon(-3.180000f,-46.716667f, -3.153334f,-46.732780f, -3.148118f,-46.727077f, -3.148118f,-46.716667f);
            poly[476] = new TzPolygon(-3.148118f,-46.727077f, -3.135556f,-46.713341f, -3.148118f,-46.698047f);
            poly[477] = new TzPolygon(-2.685229f,-46.630047f, -2.722778f,-46.661392f, -2.800278f,-46.623894f, -2.801389f,-46.603058f, -2.836389f,-46.596947f,
                    -2.855000f,-46.568893f, -2.850000f,-46.601112f, -2.903611f,-46.621674f, -2.894722f,-46.655281f, -3.006111f,-46.636116f,
                    -3.148118f,-46.698047f, -2.685229f,-46.698047f);
            poly[478] = new TzPolygon(-2.685229f,-46.630047f, -2.660556f,-46.609451f, -2.675556f,-46.591667f, -2.650278f,-46.575562f, -2.635278f,-46.522224f,
                    -2.551111f,-46.488060f, -2.540833f,-46.428894f, -2.423056f,-46.436111f, -2.366111f,-46.403893f, -2.376389f,-46.453056f,
                    -2.325834f,-46.414726f, -2.275834f,-46.404167f, -2.253889f,-46.423615f, -2.254445f,-46.371948f, -2.175000f,-46.291946f,
                    -1.925833f,-46.210556f, -1.820639f,-46.210556f, -1.820639f,-46.206947f, -2.685229f,-46.206947f);
            poly[479] = new TzPolygon(-1.745833f,-46.319450f, -1.809445f,-46.301117f, -1.792222f,-46.246948f, -1.820639f,-46.214979f, -1.820639f,-46.319450f);
            poly[480] = new TzPolygon(-1.745833f,-46.319450f, -1.727222f,-46.235001f, -1.688056f,-46.205559f, -1.616389f,-46.206390f, -1.573889f,-46.180557f,
                    -1.486111f,-46.203613f, -1.353889f,-46.121948f, -1.299722f,-46.169449f, -1.238329f,-46.136341f, -1.219558f,-46.075897f,
                    -1.159195f,-46.049419f, -1.745833f,-46.049419f);
            poly[481] = new TzPolygon(-10.641456f,-37.792322f, -10.641456f,-37.151226f, -11.124881f,-37.151226f, -11.116234f,-37.162720f, -11.185385f,-37.168011f,
                    -11.185459f,-37.152866f, -11.278661f,-37.258564f, -11.423970f,-37.326023f, -11.445910f,-37.379787f, -11.492440f,-37.402061f,
                    -11.540556f,-37.537224f, -11.521667f,-37.634171f, -11.576113f,-37.673340f, -11.552778f,-37.691116f, -11.515001f,-37.808334f,
                    -11.445835f,-37.840561f, -11.403612f,-37.894173f, -11.412224f,-37.956390f, -11.378056f,-37.999451f, -11.357224f,-38.009171f,
                    -11.320278f,-37.980835f, -11.300280f,-37.996948f, -11.212778f,-37.986671f, -11.167778f,-38.067505f, -11.021946f,-38.107780f,
                    -11.020557f,-38.139450f, -10.980835f,-38.181946f, -10.936390f,-38.184448f, -10.913334f,-38.232780f, -10.832779f,-38.245560f,
                    -10.714169f,-38.192780f, -10.712223f,-38.076950f, -10.761391f,-37.998894f, -10.696667f,-37.841393f);
            poly[482] = new TzPolygon(-8.632456f,-38.197313f, -9.303155f,-38.197313f, -9.332411f,-38.234711f, -9.136112f,-38.313896f, -9.078611f,-38.313896f,
                    -9.025278f,-38.286667f, -8.988611f,-38.318062f, -9.037224f,-38.408615f, -9.007502f,-38.474449f, -8.947224f,-38.510002f,
                    -8.882223f,-38.466393f, -8.845835f,-38.473618f, -8.830833f,-38.568336f, -8.864723f,-38.594170f, -8.967779f,-38.607506f,
                    -8.978613f,-38.643616f, -8.845835f,-38.701950f, -8.787500f,-38.795280f, -8.774168f,-38.850563f, -8.793890f,-38.955002f,
                    -8.730835f,-39.044724f, -8.710279f,-39.141945f, -8.679167f,-39.180283f, -8.685278f,-39.215279f, -8.635360f,-39.243401f,
                    -8.632456f,-39.243401f);
            poly[483] = new TzPolygon(-9.419884f,-38.197313f, -9.418890f,-38.203896f, -9.376112f,-38.204445f, -9.330833f,-38.235840f, -9.301785f,-38.197313f);
            poly[484] = new TzPolygon(-9.419884f,-38.197313f, -9.433613f,-38.106392f, -9.480278f,-38.014725f, -9.530720f,-38.001411f, -9.616945f,-38.048058f,
                    -9.646667f,-37.988617f, -9.744446f,-38.030281f, -9.891111f,-37.956390f, -9.910002f,-37.898056f, -9.949722f,-37.902779f,
                    -10.013889f,-37.828339f, -10.108334f,-37.770836f, -10.337778f,-37.789726f, -10.413057f,-37.843338f, -10.493334f,-37.813614f,
                    -10.570835f,-37.825562f, -10.625341f,-37.778000f, -10.641456f,-37.785413f, -10.641456f,-38.197313f);
            poly[485] = new TzPolygon(-9.256990f,-37.151226f, -9.207224f,-37.234169f, -9.066389f,-37.361671f, -9.000000f,-37.485001f, -8.946667f,-37.513618f,
                    -8.948612f,-37.583061f, -8.992779f,-37.662224f, -8.853334f,-37.754173f, -8.892502f,-37.811668f, -8.998890f,-37.820007f,
                    -9.056391f,-37.900841f, -9.155834f,-37.981674f, -9.194445f,-38.109169f, -9.265278f,-38.148895f, -9.303155f,-38.197313f,
                    -8.632456f,-38.197313f, -8.632456f,-37.151226f);
            poly[486] = new TzPolygon(-9.256990f,-37.151226f, -8.632456f,-37.151226f, -8.632456f,-35.059051f, -8.695489f,-35.085903f, -8.749394f,-35.085144f,
                    -8.830312f,-35.133533f, -8.913097f,-35.149227f, -8.883612f,-35.294174f, -8.886391f,-35.410004f, -8.858612f,-35.464172f,
                    -8.828056f,-35.477783f, -8.845001f,-35.574448f, -8.926390f,-35.727783f, -8.901390f,-35.794449f, -8.865557f,-35.795563f,
                    -8.878334f,-35.910278f, -8.912779f,-35.972504f, -8.886391f,-36.005280f, -8.964169f,-36.093338f, -8.966946f,-36.125282f,
                    -9.014446f,-36.114174f, -9.090834f,-36.249451f, -9.135557f,-36.245834f, -9.209167f,-36.358337f, -9.207779f,-36.447502f,
                    -9.301945f,-36.587227f, -9.273335f,-36.694725f, -9.273335f,-36.889450f, -9.355835f,-36.938614f, -9.299168f,-37.008614f,
                    -9.272223f,-37.125839f);
            poly[487] = new TzPolygon(-7.684195f,-39.243401f, -7.745001f,-39.115005f, -7.857779f,-39.070282f, -7.816945f,-39.007782f, -7.854167f,-38.970284f,
                    -7.706389f,-38.870003f, -7.715279f,-38.832504f, -7.659167f,-38.811951f, -7.660278f,-38.749451f, -7.630279f,-38.732506f,
                    -7.618890f,-38.658058f, -7.685278f,-38.641113f, -7.694445f,-38.585556f, -7.744722f,-38.585556f, -7.769167f,-38.522224f,
                    -7.726389f,-38.440834f, -7.753056f,-38.408058f, -7.703334f,-38.367783f, -7.702500f,-38.341118f, -7.783611f,-38.298058f,
                    -7.830278f,-38.303062f, -7.851111f,-38.249725f, -7.808056f,-38.228889f, -7.817223f,-38.173340f, -7.765834f,-38.148338f,
                    -7.793406f,-38.130081f, -8.632456f,-38.130081f, -8.632456f,-39.243401f);
            poly[488] = new TzPolygon(-7.793406f,-38.130081f, -7.806945f,-38.121117f, -7.822779f,-38.081116f, -7.752778f,-38.056396f, -7.769444f,-37.958061f,
                    -7.665278f,-37.875282f, -7.635556f,-37.781113f, -7.551945f,-37.712784f, -7.475556f,-37.547501f, -7.364445f,-37.480278f,
                    -7.343612f,-37.426392f, -7.366389f,-37.423340f, -7.362779f,-37.401115f, -7.302778f,-37.357506f, -7.282345f,-37.295702f,
                    -7.282345f,-37.237032f, -7.345834f,-37.152229f, -7.394167f,-37.022507f, -7.412409f,-37.016762f, -7.499702f,-37.016762f,
                    -7.579167f,-37.204727f, -7.636111f,-37.217224f, -7.740001f,-37.170006f, -7.786112f,-37.171112f, -7.820556f,-37.232224f,
                    -7.992500f,-37.348335f, -8.005001f,-37.327507f, -7.958889f,-37.215004f, -7.981945f,-37.140282f, -8.041113f,-37.153618f,
                    -8.175556f,-37.125557f, -8.236389f,-37.061394f, -8.258772f,-37.016762f, -8.632456f,-37.016762f, -8.632456f,-38.130081f);
            poly[489] = new TzPolygon(-7.282345f,-37.295702f, -7.268889f,-37.255005f, -7.282345f,-37.237032f);
            poly[490] = new TzPolygon(-7.499702f,-37.016762f, -7.489445f,-36.992500f, -7.412409f,-37.016762f, -7.282345f,-37.016762f, -7.282345f,-34.795035f,
                    -7.472541f,-34.802612f, -7.548030f,-34.828465f, -7.520000f,-34.968613f, -7.431667f,-35.025002f, -7.395278f,-35.106392f,
                    -7.380000f,-35.267227f, -7.465834f,-35.381950f, -7.450556f,-35.490837f, -7.654445f,-35.555557f, -7.711390f,-35.664452f,
                    -7.704722f,-35.705284f, -7.757778f,-35.855278f, -7.725000f,-35.890282f, -7.759445f,-35.900284f, -7.803889f,-35.859169f,
                    -7.801945f,-35.918892f, -7.842501f,-35.924171f, -7.815278f,-35.971672f, -7.831389f,-36.068611f, -7.771389f,-36.100563f,
                    -7.823056f,-36.160835f, -7.822500f,-36.199722f, -7.780556f,-36.211113f, -7.826112f,-36.262222f, -7.811945f,-36.412224f,
                    -7.837501f,-36.426949f, -7.875278f,-36.412781f, -7.913611f,-36.450562f, -7.915833f,-36.562782f, -7.930000f,-36.583061f,
                    -7.956389f,-36.573616f, -7.961945f,-36.623062f, -8.013056f,-36.660278f, -8.093889f,-36.630836f, -8.137222f,-36.701393f,
                    -8.216946f,-36.767227f, -8.231668f,-36.862503f, -8.283611f,-36.962784f, -8.257762f,-37.016762f);
            poly[491] = new TzPolygon(12.469320f,-16.794668f, 12.469320f,-16.062716f, 12.456376f,-16.214922f, 12.360582f,-16.389898f, 12.356055f,-16.672808f,
                    12.329175f,-16.724874f, 12.463106f,-16.797447f);
            poly[492] = new TzPolygon(12.435402f,-15.836494f, 12.440459f,-15.958014f, 12.469320f,-16.062716f, 12.469320f,-15.836494f);
            poly[493] = new TzPolygon(13.159023f,-16.790438f, 13.159023f,-16.693559f, 13.114009f,-16.742378f, 13.064252f,-16.755833f, 13.087676f,-16.785509f);
            poly[494] = new TzPolygon(13.587775f,-15.836494f, 13.588785f,-16.560143f, 13.588785f,-15.836494f);
            poly[495] = new TzPolygon(16.853725f,-16.343892f, 16.853725f,-15.836494f, 16.500165f,-15.836494f, 16.494186f,-15.857825f, 16.518282f,-15.896758f,
                    16.488461f,-15.956124f, 16.501612f,-16.003054f, 16.479433f,-16.051363f, 16.556532f,-16.116350f, 16.516907f,-16.189356f,
                    16.524748f,-16.262775f, 16.306200f,-16.368189f, 16.270952f,-16.351439f, 16.218958f,-16.384489f, 16.208862f,-16.435633f,
                    16.102282f,-16.443050f, 16.062185f,-16.505772f, 16.279724f,-16.515236f, 16.487677f,-16.448195f, 16.625006f,-16.436182f);
            poly[496] = new TzPolygon(11.046461f,-15.108827f, 11.046461f,-14.932779f, 11.005613f,-14.952805f, 10.924265f,-15.079601f, 10.936242f,-15.096517f,
                    10.991766f,-15.034266f, 10.954882f,-15.077908f, 10.959709f,-15.114285f);
            poly[497] = new TzPolygon(11.049326f,-14.918398f, 11.054543f,-14.926619f, 11.071544f,-14.918398f);
            poly[498] = new TzPolygon(11.075797f,-14.916341f, 11.377222f,-14.770593f, 11.377222f,-13.435683f, 11.075797f,-13.435683f);
            poly[499] = new TzPolygon(12.680789f,-15.836494f, 12.680789f,-15.179247f, 12.611763f,-15.329826f, 12.522363f,-15.452144f, 12.428300f,-15.665849f,
                    12.435402f,-15.836494f);
        }
    }

    private static class Initializer6 {
        private static void init() {
            poly[500] = new TzPolygon(11.377222f,-14.770593f, 11.382429f,-14.768075f, 11.506736f,-14.665382f, 11.498796f,-14.516198f, 11.603085f,-14.319524f,
                    11.678388f,-14.268074f, 11.664300f,-14.137654f, 11.630502f,-14.088980f, 11.656075f,-14.037422f, 11.648363f,-13.977118f,
                    11.684897f,-13.931956f, 11.668644f,-13.879784f, 11.724758f,-13.854130f, 11.751829f,-13.863235f, 11.686463f,-13.782382f,
                    11.709823f,-13.713426f, 12.004339f,-13.705562f, 12.032366f,-13.791136f, 12.079291f,-13.817758f, 12.128542f,-13.892817f,
                    12.135917f,-13.941764f, 12.191512f,-13.965025f, 12.236045f,-13.922398f, 12.243892f,-13.857457f, 12.279545f,-13.865012f,
                    12.280440f,-13.839993f, 12.256374f,-13.829143f, 12.294554f,-13.801518f, 12.250593f,-13.804420f, 12.251992f,-13.773093f,
                    12.275308f,-13.762997f, 12.245699f,-13.725097f, 12.315237f,-13.663193f, 12.405408f,-13.663054f, 12.449789f,-13.636522f,
                    12.532014f,-13.679629f, 12.676220f,-13.709032f, 12.661082f,-13.435683f, 11.377222f,-13.435683f);
            poly[501] = new TzPolygon(12.662752f,-13.435683f, 12.677311f,-13.823390f, 12.680789f,-15.179247f, 12.680789f,-13.435683f);
            poly[502] = new TzPolygon(13.159023f,-15.836494f, 13.159100f,-15.812263f, 13.341087f,-15.807810f, 13.358396f,-15.670901f, 13.338038f,-15.587646f,
                    13.387020f,-15.510426f, 13.343554f,-15.383827f, 13.360430f,-15.296222f, 13.430408f,-15.224655f, 13.531476f,-15.199104f,
                    13.589462f,-15.110601f, 13.523372f,-15.048307f, 13.456468f,-14.940442f, 13.413065f,-14.768794f, 13.334338f,-14.659720f,
                    13.344831f,-14.587736f, 13.310571f,-14.546916f, 13.295171f,-14.463823f, 13.229048f,-14.369119f, 13.221724f,-14.141988f,
                    13.275811f,-14.113913f, 13.339051f,-13.841396f, 13.437148f,-13.799096f, 13.529346f,-13.878470f, 13.573400f,-13.964473f,
                    13.543133f,-14.124961f, 13.475917f,-14.247162f, 13.460607f,-14.348280f, 13.528615f,-14.459772f, 13.635179f,-14.532991f,
                    13.654000f,-14.616471f, 13.614170f,-14.719204f, 13.661844f,-14.788959f, 13.721027f,-14.800082f, 13.766752f,-14.839972f,
                    13.826571f,-15.071154f, 13.826571f,-13.435683f, 12.680789f,-13.435683f, 12.680789f,-15.836494f);
            poly[503] = new TzPolygon(13.826571f,-15.071154f, 13.754016f,-15.222216f, 13.776931f,-15.306919f, 13.758180f,-15.381220f, 13.681431f,-15.457903f,
                    13.587279f,-15.481128f, 13.587775f,-15.836494f, 13.826571f,-15.836494f);
            poly[504] = new TzPolygon(16.500165f,-15.836494f, 16.508038f,-15.808406f, 16.475243f,-15.700640f, 16.491833f,-15.636189f, 16.530237f,-15.625643f,
                    16.528732f,-15.515756f, 16.570948f,-15.515589f, 16.596670f,-15.468549f, 16.543444f,-15.405613f, 16.585203f,-15.313324f,
                    16.563770f,-15.232772f, 16.600664f,-15.171691f, 16.593248f,-15.110415f, 16.612272f,-15.095082f, 16.639868f,-15.126729f,
                    16.672554f,-15.104721f, 16.631449f,-15.033796f, 16.691633f,-14.983164f, 16.633924f,-14.936859f, 16.651388f,-14.911768f,
                    16.634836f,-14.897084f, 16.663477f,-14.881537f, 16.640991f,-14.855780f, 16.636303f,-14.824683f, 16.656029f,-14.811440f,
                    16.633760f,-14.785689f, 16.658123f,-14.762588f, 16.623945f,-14.738510f, 16.648527f,-14.727541f, 16.651758f,-14.679380f,
                    16.651449f,-14.638909f, 16.635265f,-14.636089f, 15.463397f,-14.636089f, 15.463397f,-15.836494f);
            poly[505] = new TzPolygon(16.635265f,-14.636089f, 16.623360f,-14.634014f, 16.623878f,-14.554015f, 16.647718f,-14.540891f, 16.620464f,-14.497192f,
                    16.654240f,-14.419317f, 16.642593f,-14.332907f, 16.570398f,-14.326444f, 16.583454f,-14.270693f, 16.520304f,-14.256178f,
                    16.548998f,-14.247450f, 16.543823f,-14.209496f, 16.352655f,-14.021432f, 16.330608f,-13.960182f, 16.307236f,-13.951496f,
                    16.296484f,-13.982889f, 16.266943f,-13.945373f, 16.224035f,-13.964966f, 16.231840f,-13.915608f, 16.196434f,-13.902488f,
                    16.195044f,-13.872603f, 16.107100f,-13.839947f, 16.180725f,-13.715548f, 16.096003f,-13.684553f, 16.145481f,-13.481459f,
                    16.125484f,-13.471096f, 16.088799f,-13.507477f, 16.079823f,-13.488503f, 16.107012f,-13.457607f, 16.093220f,-13.435683f,
                    15.463397f,-13.435683f, 15.463397f,-14.636089f);
            poly[506] = new TzPolygon(8.912874f,-13.185021f, 8.954439f,-13.255637f, 8.950082f,-13.293886f, 9.037539f,-13.307631f, 9.092398f,-13.174167f,
                    9.049626f,-13.107512f, 9.052161f,-13.069378f, 9.112831f,-12.991609f, 9.286657f,-12.935081f, 9.270345f,-12.893098f,
                    9.298263f,-12.872898f, 9.285883f,-12.816511f, 9.300714f,-12.789514f, 9.342599f,-12.776983f, 9.349608f,-12.750869f,
                    9.396490f,-12.752238f, 9.389536f,-12.712171f, 9.415545f,-12.703490f, 9.409179f,-12.686798f, 9.508852f,-12.650646f,
                    9.532029f,-12.660468f, 9.548223f,-12.634370f, 9.601146f,-12.621155f, 9.599878f,-12.591736f, 9.702730f,-12.566657f,
                    9.720542f,-12.536140f, 9.707267f,-12.519409f, 9.843648f,-12.499009f, 9.868772f,-12.454523f, 8.912874f,-12.454523f);
            poly[507] = new TzPolygon(12.661082f,-13.435683f, 12.648770f,-13.213355f, 12.627760f,-13.187695f, 12.638985f,-13.073472f, 12.582062f,-13.050899f,
                    12.529708f,-13.076587f, 12.477808f,-13.060603f, 12.461672f,-12.968648f, 12.530523f,-12.930916f, 12.540651f,-12.887652f,
                    12.486883f,-12.834180f, 12.470900f,-12.771829f, 12.435070f,-12.755456f, 12.431276f,-12.633937f, 12.368556f,-12.564578f,
                    12.397323f,-12.506198f, 12.392074f,-12.454523f, 9.868772f,-12.454523f, 9.868772f,-13.435683f);
            poly[508] = new TzPolygon(14.903401f,-12.454523f, 15.002318f,-12.481759f, 15.098997f,-12.657623f, 15.080531f,-12.691578f, 15.146680f,-12.788505f,
                    15.209909f,-12.803046f, 15.198281f,-12.849763f, 15.252639f,-12.899152f, 15.257136f,-12.845049f, 15.292343f,-12.840010f,
                    15.357313f,-12.943282f, 15.434598f,-12.930403f, 15.444433f,-12.960191f, 15.499133f,-12.964278f, 15.472794f,-13.060057f,
                    15.499997f,-13.103927f, 15.577058f,-13.096951f, 15.620442f,-13.183279f, 15.617033f,-13.236433f, 15.668022f,-13.254800f,
                    15.693663f,-13.216077f, 15.758386f,-13.291513f, 15.780649f,-13.293986f, 15.786342f,-13.271441f, 15.886151f,-13.333318f,
                    15.914375f,-13.321671f, 15.972376f,-13.374041f, 16.049686f,-13.370948f, 16.092509f,-13.435683f, 20.373875f,-13.435683f,
                    20.373875f,-12.454523f);
            poly[509] = new TzPolygon(6.994635f,-70.950629f, 6.980262f,-70.962914f, 6.994942f,-70.987160f, 6.983195f,-71.092979f, 7.029072f,-71.139519f,
                    7.012481f,-71.330185f, 7.033195f,-71.421059f, 7.011037f,-71.466270f, 7.029924f,-71.472107f, 7.020736f,-71.590088f,
                    7.046751f,-71.597031f, 7.051333f,-71.650879f, 7.021134f,-71.663269f, 7.038628f,-71.726929f, 7.061688f,-71.734474f,
                    7.049778f,-71.758842f, 7.071980f,-71.763885f, 7.045744f,-71.820343f, 7.007701f,-71.840485f, 7.013873f,-72.024323f,
                    7.251312f,-72.173103f, 7.328435f,-72.165939f, 7.381046f,-72.203331f, 7.374147f,-72.331467f, 7.400355f,-72.438660f,
                    7.484615f,-72.480705f, 7.560476f,-72.456696f, 7.626878f,-72.479225f, 7.775156f,-72.475403f, 7.830923f,-72.449020f,
                    7.914371f,-72.464310f, 7.933972f,-72.487198f, 7.992756f,-72.421211f, 8.038215f,-72.413818f, 8.016312f,-72.348648f,
                    8.089793f,-72.349998f, 8.107259f,-72.373390f, 8.170620f,-72.355118f, 8.263382f,-72.391029f, 8.321577f,-72.380867f,
                    8.389983f,-72.414803f, 8.600101f,-72.626933f, 8.600101f,-70.950629f);
            poly[510] = new TzPolygon(6.994635f,-70.950629f, 7.057353f,-70.897026f, 7.092551f,-70.691467f, 7.064274f,-70.637451f, 7.076914f,-70.560799f,
                    7.005371f,-70.499573f, 6.981435f,-70.386948f, 6.932851f,-70.319031f, 7.002468f,-70.089317f, 6.112890f,-69.441437f,
                    6.152771f,-69.335106f, 6.095168f,-69.282524f, 6.087361f,-69.215149f, 6.183323f,-69.112648f, 6.212960f,-69.051498f,
                    6.175571f,-68.932892f, 6.183807f,-68.835510f, 6.132707f,-68.661446f, 6.190351f,-68.455917f, 6.168655f,-68.314682f,
                    6.223938f,-68.144501f, 6.211117f,-67.969536f, 6.301990f,-67.841576f, 6.280529f,-67.634148f, 6.194591f,-67.476051f,
                    6.090558f,-67.484955f, 6.041116f,-67.433006f, 6.004546f,-67.422675f, 6.004546f,-70.950629f);
            poly[511] = new TzPolygon(7.281056f,-61.708503f, 7.281056f,-60.627692f, 7.224684f,-60.647652f, 7.128838f,-60.558384f, 7.174550f,-60.504601f,
                    7.187938f,-60.441048f, 7.172709f,-60.373222f, 7.090169f,-60.268723f, 7.064825f,-60.271538f, 7.011142f,-60.350903f,
                    6.929701f,-60.368561f, 6.937792f,-60.431152f, 6.883407f,-60.485924f, 6.817854f,-60.656036f, 6.758633f,-60.710590f,
                    6.759876f,-60.751663f, 6.800455f,-60.795097f, 6.781041f,-60.855896f, 6.813902f,-60.907455f, 6.752349f,-60.900257f,
                    6.716392f,-60.952023f, 6.730263f,-61.065056f, 6.703627f,-61.080688f, 6.721282f,-61.119312f, 6.687773f,-61.165306f,
                    6.620632f,-61.176254f, 6.567850f,-61.213459f, 6.546182f,-61.188412f, 6.513948f,-61.188938f, 6.513949f,-61.156586f,
                    6.450874f,-61.128258f, 6.324182f,-61.156727f, 6.270501f,-61.098965f, 6.209517f,-61.107555f, 6.191120f,-61.157486f,
                    6.129356f,-61.185795f, 6.111337f,-61.258869f, 6.014178f,-61.295040f, 6.004546f,-61.302891f, 6.004546f,-61.708503f);
            poly[512] = new TzPolygon(7.281056f,-60.627692f, 7.339094f,-60.607143f, 7.423829f,-60.652668f, 7.469798f,-60.709881f, 7.533752f,-60.731052f,
                    7.571114f,-60.688351f, 7.568699f,-60.646065f, 7.827923f,-60.516045f, 7.815528f,-60.408978f, 7.833536f,-60.378868f,
                    7.808831f,-60.376617f, 7.945329f,-60.236755f, 8.030521f,-60.112366f, 8.020081f,-60.066822f, 8.049591f,-60.014488f,
                    8.171167f,-59.981293f, 8.217115f,-59.936058f, 8.233445f,-59.842701f, 8.273121f,-59.808464f, 8.304035f,-59.806301f,
                    8.557567f,-59.997871f, 8.360294f,-59.833630f, 8.349139f,-59.803780f, 7.281056f,-59.803780f);
            poly[513] = new TzPolygon(8.600101f,-72.626933f, 8.626049f,-72.653130f, 8.980554f,-72.738473f, 8.980554f,-72.626933f);
            poly[514] = new TzPolygon(-19.269809f,-51.240707f, -19.290836f,-51.114174f, -19.456680f,-50.923409f, -19.475002f,-50.962784f, -19.556667f,-50.932503f,
                    -19.571667f,-50.981117f, -19.722504f,-51.023613f, -19.920002f,-50.985558f, -20.233334f,-51.033890f, -20.299168f,-51.146118f,
                    -20.312486f,-51.240707f);
            poly[515] = new TzPolygon(-13.666214f,-51.240707f, -13.666214f,-50.789283f, -13.668056f,-50.789726f, -13.718613f,-50.870560f, -13.870001f,-50.843056f,
                    -13.970835f,-50.867783f, -14.086390f,-50.845558f, -14.110279f,-50.863617f, -14.119722f,-50.926949f, -14.158335f,-50.918335f,
                    -14.233891f,-50.962227f, -14.405556f,-50.999168f, -14.530834f,-50.967781f, -14.659723f,-51.038338f, -14.891111f,-51.097504f,
                    -14.914446f,-51.136116f, -14.975000f,-51.160278f, -15.013485f,-51.240707f);
            poly[516] = new TzPolygon(-12.867999f,-50.220945f, -12.843900f,-50.368488f, -12.696740f,-50.335049f, -12.578290f,-50.257038f, -12.470800f,-50.255001f,
                    -12.539700f,-50.357800f, -12.573900f,-50.356899f, -12.620800f,-50.407001f, -12.673600f,-50.410801f, -12.698300f,-50.449402f,
                    -12.816700f,-50.462502f, -12.844881f,-50.484089f, -12.832224f,-50.559174f, -12.804167f,-50.559723f, -12.812223f,-50.595558f,
                    -12.656389f,-50.625557f, -12.645000f,-50.663063f, -12.605278f,-50.677505f, -12.595835f,-50.646118f, -12.384167f,-50.613617f,
                    -12.284445f,-50.619728f, -12.265315f,-50.632201f, -12.265315f,-50.220945f);
            poly[517] = new TzPolygon(-13.666214f,-50.789283f, -13.537779f,-50.758339f, -13.444168f,-50.670563f, -13.388334f,-50.661118f, -13.296946f,-50.591667f,
                    -13.228613f,-50.568336f, -13.077223f,-50.590279f, -13.050280f,-50.548058f, -13.018057f,-50.566391f, -12.950556f,-50.494171f,
                    -12.698300f,-50.449402f, -12.673600f,-50.410801f, -12.620800f,-50.407001f, -12.573900f,-50.356899f, -12.539700f,-50.357800f,
                    -12.470800f,-50.255001f, -12.578290f,-50.257038f, -12.696740f,-50.335049f, -12.843900f,-50.368488f, -12.867999f,-50.220945f,
                    -13.666214f,-50.220945f);
            poly[518] = new TzPolygon(-12.867999f,-50.220945f, -12.869020f,-50.214691f, -12.933630f,-50.074261f, -12.958750f,-49.822380f, -13.066430f,-49.624001f,
                    -13.156160f,-49.363209f, -13.141810f,-49.323090f, -12.768500f,-49.218330f, -12.740888f,-49.201183f, -13.666214f,-49.201183f,
                    -13.666214f,-50.220945f);
            poly[519] = new TzPolygon(-10.864416f,-50.617130f, -10.881390f,-50.611671f, -10.932501f,-50.637779f, -11.065279f,-50.609451f, -11.142502f,-50.664726f,
                    -11.243057f,-50.659172f, -11.471111f,-50.741951f, -11.524445f,-50.736671f, -11.603334f,-50.648338f, -11.664167f,-50.657501f,
                    -11.714724f,-50.711113f, -11.749428f,-50.714485f, -11.870001f,-50.679726f, -11.885557f,-50.642502f, -12.048613f,-50.683891f,
                    -12.202223f,-50.673340f, -12.265315f,-50.632201f, -12.265315f,-51.240707f, -10.864416f,-51.240707f);
            poly[520] = new TzPolygon(-9.789270f,-51.240707f, -9.844168f,-50.232506f, -10.028891f,-50.309448f, -10.110279f,-50.381668f, -10.307501f,-50.408615f,
                    -10.355835f,-50.430557f, -10.393612f,-50.482780f, -10.563334f,-50.522781f, -10.655834f,-50.606674f, -10.739445f,-50.582504f,
                    -10.826113f,-50.629448f, -10.864416f,-50.617130f, -10.864416f,-51.240707f);
            poly[521] = new TzPolygon(-8.062619f,-51.240707f, -8.062619f,-49.203056f, -8.098333f,-49.227226f, -8.378056f,-49.306114f, -8.441668f,-49.387505f,
                    -8.661667f,-49.498062f, -8.708889f,-49.500839f, -8.852222f,-49.597504f, -8.868057f,-49.676392f, -8.929724f,-49.766113f,
                    -9.155834f,-49.906395f, -9.321667f,-50.053337f, -9.703335f,-50.148613f, -9.844168f,-50.232506f, -9.790742f,-51.240707f);
            poly[522] = new TzPolygon(-7.751123f,-49.201183f, -7.653056f,-49.315002f, -7.529723f,-49.368057f, -7.274446f,-49.201183f);
            poly[523] = new TzPolygon(-7.102898f,-49.201183f, -6.936667f,-49.218056f, -6.923692f,-49.201183f);
            poly[524] = new TzPolygon(10.721931f,-74.478584f, 10.721931f,-72.711839f, 10.667427f,-72.735329f, 10.571233f,-72.823631f, 10.488544f,-72.846428f,
                    10.456061f,-72.889610f, 10.108714f,-72.914040f, 9.928616f,-72.989586f, 9.882874f,-72.990448f, 9.840187f,-72.947723f,
                    9.684622f,-73.049919f, 9.565972f,-73.080238f, 9.545272f,-73.145767f, 9.438385f,-73.195999f, 9.376892f,-73.255074f,
                    9.237057f,-73.316742f, 9.241742f,-73.354073f, 9.182608f,-73.350319f, 9.164061f,-73.249794f, 9.182858f,-73.174316f,
                    9.234805f,-73.129234f, 9.234612f,-73.087410f, 9.296101f,-73.010780f, 9.257681f,-72.985291f, 9.227658f,-72.993217f,
                    9.207809f,-72.963615f, 9.164596f,-72.962677f, 9.148978f,-72.985237f, 9.095225f,-72.943993f, 9.088101f,-72.922585f,
                    9.135428f,-72.879364f, 9.126774f,-72.824028f, 9.143715f,-72.818298f, 9.106619f,-72.768822f, 8.980554f,-72.738473f,
                    8.980554f,-74.478584f);
            poly[525] = new TzPolygon(10.721931f,-72.711839f, 10.883132f,-72.642365f, 10.919364f,-72.576233f, 11.057410f,-72.476837f, 11.094588f,-72.485786f,
                    11.130611f,-72.437271f, 11.116750f,-72.433540f, 11.157571f,-72.341637f, 11.152378f,-72.237442f, 11.650083f,-71.966057f,
                    11.744095f,-71.624382f, 11.691513f,-71.624382f, 11.656494f,-71.800201f, 11.608981f,-71.934677f, 11.578037f,-71.958893f,
                    11.411208f,-71.956108f, 11.268923f,-71.899910f, 11.136990f,-71.812904f, 11.002930f,-71.624382f, 10.988165f,-71.624382f,
                    10.978981f,-71.661499f, 10.996959f,-71.663780f, 11.020187f,-71.724136f, 11.013867f,-71.793999f, 10.959143f,-71.718529f,
                    10.798538f,-71.670265f, 10.752514f,-71.624382f, 10.721931f,-71.624382f);
            poly[526] = new TzPolygon(10.968725f,-71.652817f, 10.957708f,-71.624382f, 10.955901f,-71.626503f, 10.964725f,-71.677055f);
            poly[527] = new TzPolygon(11.744095f,-71.624382f, 11.788143f,-71.464294f, 11.817017f,-71.377151f, 11.833475f,-71.383362f, 11.855274f,-71.335793f,
                    11.801346f,-71.336243f, 11.729532f,-71.433495f, 11.691513f,-71.624382f);
            poly[528] = new TzPolygon(12.385672f,-69.150192f, 12.341960f,-69.071136f, 12.252455f,-69.038605f, 12.212516f,-68.999886f, 12.165371f,-68.846519f,
                    12.041252f,-68.733948f, 12.032745f,-68.782364f, 12.104357f,-68.956490f, 12.189939f,-69.036575f, 12.177007f,-69.062241f,
                    12.280807f,-69.149796f, 12.374491f,-69.157204f);
            poly[529] = new TzPolygon(17.762563f,-71.613358f, 17.768444f,-71.683815f, 17.837727f,-71.625916f, 17.901709f,-71.671944f, 17.921961f,-71.653107f,
                    17.963718f,-71.662987f, 18.030148f,-71.754051f, 18.095972f,-71.731773f, 18.143438f,-71.742821f, 18.175028f,-71.779861f,
                    18.341171f,-71.692856f, 18.458145f,-71.900253f, 18.484625f,-71.904457f, 18.505085f,-71.877922f, 18.606018f,-71.962959f,
                    18.625265f,-72.003487f, 18.655109f,-71.957336f, 18.633261f,-71.813324f, 18.693542f,-71.795860f, 18.730448f,-71.737732f,
                    18.875668f,-71.720566f, 18.908440f,-71.765808f, 18.952909f,-71.782822f, 18.967213f,-71.839302f, 18.944311f,-71.861542f,
                    18.954300f,-71.882385f, 18.999214f,-71.836670f, 18.991110f,-71.788826f, 19.025553f,-71.772484f, 19.065929f,-71.706520f,
                    19.102068f,-71.703743f, 19.108601f,-71.648331f, 19.201639f,-71.613358f);
            poly[530] = new TzPolygon(19.201639f,-71.613358f, 19.228018f,-71.632286f, 19.265051f,-71.733818f, 19.333628f,-71.787071f, 19.365408f,-71.690666f,
                    19.441677f,-71.675034f, 19.509632f,-71.685257f, 19.584814f,-71.738747f, 19.654676f,-71.733536f, 19.702724f,-71.757805f,
                    19.694565f,-71.710968f, 19.779507f,-71.747284f, 19.760128f,-71.775826f, 19.781267f,-71.775749f, 19.859631f,-71.654510f,
                    19.898354f,-71.649590f, 19.878698f,-71.628357f, 19.888623f,-71.613358f);
            poly[531] = new TzPolygon(18.070248f,-63.053574f, 18.060326f,-63.012993f, 18.011692f,-63.041431f, 18.060019f,-63.144039f, 18.052963f,-63.084576f);
            poly[532] = new TzPolygon(31.330078f,-111.000702f, 31.330078f,-110.218782f, 31.328904f,-111.000702f);
            poly[533] = new TzPolygon(35.257645f,-109.624168f, 35.170948f,-109.625725f, 35.158649f,-111.000702f, 35.257645f,-111.000702f);
            poly[534] = new TzPolygon(25.453518f,-107.087220f, 25.528921f,-107.085674f, 25.528921f,-103.047236f, 25.453518f,-103.047236f);
            poly[535] = new TzPolygon(26.792335f,-107.979935f, 26.819721f,-108.003891f, 26.947498f,-108.035568f, 26.972775f,-108.220573f, 27.036942f,-108.245560f,
                    27.059998f,-108.290558f, 27.030830f,-108.405006f, 26.961330f,-108.471336f, 26.994164f,-108.495010f, 27.053333f,-108.617508f,
                    27.061386f,-108.621078f, 27.061386f,-107.979935f);
            poly[536] = new TzPolygon(27.061386f,-109.624168f, 27.061386f,-108.616691f, 27.038055f,-108.604172f, 26.976944f,-108.475571f, 26.923054f,-108.467506f,
                    26.831944f,-108.486389f, 26.338314f,-109.143723f, 26.314888f,-109.251640f, 26.514244f,-109.271126f, 26.659548f,-109.405243f,
                    26.699356f,-109.605400f, 26.694679f,-109.624168f);
            poly[537] = new TzPolygon(25.528921f,-107.085674f, 25.606087f,-107.084091f, 25.622498f,-106.740280f, 25.789165f,-106.533623f, 26.021111f,-106.520844f,
                    26.079998f,-106.403061f, 26.147499f,-106.367508f, 26.239441f,-106.388634f, 26.328331f,-106.452217f, 26.376389f,-106.450012f,
                    26.368889f,-106.344727f, 26.372842f,-106.335702f, 25.528921f,-106.335702f);
            poly[538] = new TzPolygon(26.792335f,-107.979935f, 26.639999f,-107.846680f, 26.200275f,-107.784447f, 26.111664f,-107.362793f, 25.899441f,-107.273064f,
                    25.808331f,-107.175568f, 25.680275f,-107.100853f, 25.528921f,-107.082632f, 25.528921f,-107.979935f);
            poly[539] = new TzPolygon(27.061386f,-103.738052f, 26.661079f,-103.630859f, 26.728886f,-103.844177f, 26.756386f,-104.188339f, 26.721664f,-104.240837f,
                    26.353886f,-104.534447f, 26.351665f,-104.586937f, 26.450554f,-104.725571f, 26.433331f,-104.796677f, 26.492775f,-104.843903f,
                    26.463055f,-104.899437f, 26.490555f,-104.954453f, 26.459442f,-105.010010f, 26.483330f,-105.079727f, 26.541386f,-105.137512f,
                    26.458885f,-105.326134f, 26.587776f,-105.585281f, 26.662777f,-105.636948f, 26.677776f,-105.701683f, 26.654999f,-105.753891f,
                    26.838608f,-106.027512f, 26.734997f,-106.091949f, 26.769444f,-106.126953f, 26.752220f,-106.153343f, 26.591389f,-106.172234f,
                    26.539997f,-106.211937f, 26.467220f,-106.210564f, 26.414997f,-106.239464f, 26.372842f,-106.335702f, 27.061386f,-106.335702f);
            poly[540] = new TzPolygon(27.061386f,-108.621078f, 27.168610f,-108.668617f, 27.319164f,-108.636398f, 27.404163f,-108.667511f, 27.519997f,-108.655289f,
                    27.599442f,-108.775009f, 27.728611f,-108.820847f, 27.785000f,-108.913887f, 27.833054f,-108.924179f, 28.175831f,-109.146393f,
                    28.299164f,-109.055847f, 28.275833f,-109.021957f, 28.305553f,-108.976959f, 28.298332f,-108.880836f, 28.212219f,-108.652512f,
                    28.289165f,-108.565567f, 28.696388f,-108.689453f, 28.771111f,-108.623901f, 29.400833f,-108.707779f, 29.401108f,-108.613617f,
                    29.992775f,-108.558060f, 27.061386f,-108.558060f);
            poly[541] = new TzPolygon(29.992775f,-108.558060f, 30.575832f,-108.677780f, 30.632500f,-108.735001f, 31.120130f,-108.789229f, 31.122064f,-108.760020f,
                    31.082376f,-108.748431f, 31.124351f,-108.604689f, 31.105176f,-108.558060f);
            poly[542] = new TzPolygon(31.330078f,-109.624168f, 31.330776f,-108.832703f, 31.192219f,-108.891403f, 31.156944f,-108.836121f, 31.204998f,-108.798073f,
                    30.632500f,-108.735001f, 30.575832f,-108.677780f, 29.992775f,-108.558060f, 29.992775f,-109.624168f);
            poly[543] = new TzPolygon(35.257645f,-109.624168f, 35.231499f,-109.198677f, 35.167480f,-109.199326f, 35.165997f,-109.045761f, 31.331833f,-109.049980f,
                    31.330971f,-109.624168f);
            poly[544] = new TzPolygon(31.105176f,-108.558060f, 31.064356f,-108.458792f, 31.128192f,-108.427318f, 31.107939f,-108.238604f, 31.131551f,-108.231579f,
                    31.088449f,-108.060978f, 31.127877f,-108.051016f, 31.129705f,-108.007550f, 31.159515f,-108.006824f, 31.159515f,-106.166015f,
                    31.155886f,-106.162645f, 31.159515f,-106.158737f, 31.159515f,-106.145627f, 31.128976f,-106.145908f, 31.128725f,-106.118648f,
                    31.104188f,-106.117824f, 31.105653f,-106.074163f, 31.074455f,-106.071480f, 31.077810f,-106.032472f, 31.043564f,-106.013019f,
                    31.037109f,-105.967525f, 30.972730f,-105.968426f, 30.971757f,-105.929625f, 30.932945f,-105.919541f, 30.945786f,-105.870115f,
                    30.906344f,-105.858114f, 30.922763f,-105.802648f, 27.061386f,-105.802648f, 27.061386f,-108.558060f);
            poly[545] = new TzPolygon(27.061386f,-103.738052f, 27.870552f,-103.954727f, 28.085918f,-103.828178f, 28.085918f,-103.047236f, 27.061386f,-103.047236f);
            poly[546] = new TzPolygon(28.889005f,-103.736089f, 28.888171f,-103.742060f, 28.982802f,-103.845399f, 28.983448f,-103.932029f, 29.042979f,-103.973270f,
                    29.023431f,-104.021920f, 29.073516f,-104.053144f, 29.061944f,-104.147639f, 29.110451f,-104.170355f, 29.110451f,-103.736089f);
            poly[547] = new TzPolygon(29.110451f,-104.170906f, 29.098463f,-104.192084f, 29.110451f,-104.202998f);
            poly[548] = new TzPolygon(28.085918f,-103.828178f, 28.242640f,-103.736089f, 28.085918f,-103.736089f);
            poly[549] = new TzPolygon(28.598185f,-103.736089f, 28.598185f,-103.527225f, 28.242686f,-103.736089f);
            poly[550] = new TzPolygon(29.028066f,-103.391663f, 29.041361f,-103.428940f, 29.110451f,-103.505026f, 29.110451f,-103.391663f);
            poly[551] = new TzPolygon(28.889005f,-103.736089f, 28.899635f,-103.659986f, 28.845729f,-103.645441f, 28.822232f,-103.598346f, 28.829865f,-103.542104f,
                    28.778845f,-103.527813f, 28.786563f,-103.469851f, 28.757491f,-103.433629f, 28.598185f,-103.527225f, 28.598185f,-103.736089f);
            poly[552] = new TzPolygon(28.760967f,-103.391663f, 28.768588f,-103.395227f, 28.760905f,-103.431557f, 28.827712f,-103.391663f);
            poly[553] = new TzPolygon(28.598185f,-103.527171f, 28.760905f,-103.431557f, 28.768588f,-103.395227f, 28.760967f,-103.391663f, 28.598185f,-103.391663f);
            poly[554] = new TzPolygon(29.028066f,-103.391663f, 29.017639f,-103.362427f, 29.044552f,-103.340797f, 29.019068f,-103.337852f, 29.023947f,-103.308571f,
                    29.006941f,-103.315063f, 29.000433f,-103.288521f, 28.837678f,-103.391663f);
            poly[555] = new TzPolygon(29.028066f,-103.391663f, 29.110451f,-103.391663f, 29.110451f,-103.047236f, 29.096181f,-103.047236f, 29.090761f,-103.071655f,
                    29.056541f,-103.096756f, 28.987640f,-103.115273f, 28.976137f,-103.157089f, 28.998753f,-103.266937f, 28.984957f,-103.278412f,
                    29.006941f,-103.315063f, 29.022345f,-103.305428f, 29.019068f,-103.337852f, 29.040213f,-103.329018f, 29.017639f,-103.362427f);
            poly[556] = new TzPolygon(28.760967f,-103.391663f, 28.718834f,-103.371956f, 28.738591f,-103.329716f, 28.702164f,-103.283718f, 28.716948f,-103.260028f,
                    28.704021f,-103.213590f, 28.722925f,-103.198595f, 28.696696f,-103.177986f, 28.727753f,-103.138459f, 28.702139f,-103.086911f,
                    28.736611f,-103.066497f, 28.737256f,-103.047236f, 28.598185f,-103.047236f, 28.598185f,-103.391663f);
            poly[557] = new TzPolygon(29.575474f,-104.424942f, 29.635252f,-104.506180f, 29.770805f,-104.561783f, 29.926056f,-104.678497f, 30.134983f,-104.696484f,
                    30.134983f,-104.424942f);
            poly[558] = new TzPolygon(30.134983f,-105.802648f, 30.134983f,-104.969771f, 30.058299f,-104.957782f, 30.029356f,-104.980368f, 29.998561f,-104.944536f,
                    29.949754f,-104.972346f, 29.909562f,-104.935285f, 29.872292f,-104.951563f, 29.828551f,-104.896071f, 29.747535f,-104.897883f,
                    29.717902f,-104.845787f, 29.651659f,-104.833318f, 29.637485f,-104.803414f, 29.591308f,-104.809211f, 29.565434f,-104.757657f,
                    29.525528f,-104.762061f, 29.522896f,-104.738219f, 29.453271f,-104.718056f, 29.441156f,-104.672586f, 29.419350f,-104.673563f,
                    29.417189f,-104.625345f, 29.372234f,-104.614115f, 29.376865f,-104.595575f, 29.290630f,-104.503176f, 29.303284f,-104.431899f,
                    29.289627f,-104.424942f, 29.110451f,-104.424942f, 29.110451f,-105.802648f);
            poly[559] = new TzPolygon(30.922763f,-105.802648f, 30.925212f,-105.794373f, 30.852457f,-105.799760f, 30.839041f,-105.753397f, 30.776479f,-105.719591f,
                    30.755991f,-105.636382f, 30.663021f,-105.604464f, 30.637542f,-105.486954f, 30.612989f,-105.480173f, 30.613859f,-105.452118f,
                    30.563205f,-105.435617f, 30.577435f,-105.391936f, 30.542774f,-105.378652f, 30.555615f,-105.345147f, 30.537771f,-105.306251f,
                    30.485348f,-105.252373f, 30.488302f,-105.209171f, 30.471565f,-105.214144f, 30.428992f,-105.148424f, 30.393956f,-105.143899f,
                    30.391620f,-105.119438f, 30.364528f,-105.136508f, 30.341059f,-105.113795f, 30.293941f,-105.113795f, 30.281760f,-105.118088f,
                    30.279854f,-105.113795f, 30.134983f,-105.113795f, 30.134983f,-105.802648f);
            poly[560] = new TzPolygon(30.728970f,-105.113795f, 30.796827f,-105.198219f, 30.798845f,-105.261032f, 30.819553f,-105.271584f, 30.851542f,-105.393608f,
                    30.891117f,-105.400085f, 30.988981f,-105.552048f, 31.090715f,-105.608635f, 31.159515f,-105.746706f, 31.159515f,-105.113795f);
            poly[561] = new TzPolygon(30.134983f,-104.424942f, 30.134983f,-104.696484f, 30.237196f,-104.705284f, 30.263308f,-104.748039f, 30.370533f,-104.818115f,
                    30.381113f,-104.852470f, 30.564341f,-104.895699f, 30.600487f,-104.921021f, 30.627633f,-104.983027f, 30.664709f,-104.914108f,
                    30.813017f,-104.903580f, 31.159515f,-104.908376f, 31.159515f,-104.424942f);
            poly[562] = new TzPolygon(30.341059f,-105.113795f, 30.328480f,-105.101621f, 30.293941f,-105.113795f);
            poly[563] = new TzPolygon(30.279854f,-105.113795f, 30.258071f,-105.064731f, 30.209313f,-105.069407f, 30.202111f,-105.023686f, 30.143017f,-104.971028f,
                    30.134983f,-104.969771f, 30.134983f,-105.113795f);
            poly[564] = new TzPolygon(30.728970f,-105.113795f, 31.159515f,-105.113795f, 31.159515f,-104.908376f, 30.813017f,-104.903580f, 30.664709f,-104.914108f,
                    30.628255f,-104.983253f, 30.680363f,-105.002953f, 30.683056f,-105.056671f);
            poly[565] = new TzPolygon(29.110451f,-103.505026f, 29.153730f,-103.552689f, 29.178549f,-103.715714f, 29.227715f,-103.757690f, 29.224159f,-103.779678f,
                    29.260885f,-103.782295f, 29.320852f,-104.039467f, 29.392506f,-104.160606f, 29.481661f,-104.209084f, 29.540106f,-104.376877f,
                    29.575474f,-104.424942f, 31.159515f,-104.424942f, 31.159515f,-103.047236f, 29.110451f,-103.047236f);
            poly[566] = new TzPolygon(29.289627f,-104.424942f, 29.247853f,-104.403661f, 29.237137f,-104.361441f, 29.178764f,-104.344499f, 29.144215f,-104.233738f,
                    29.110451f,-104.202998f, 29.110451f,-104.424942f);
            poly[567] = new TzPolygon(31.159515f,-108.006824f, 31.177331f,-108.006390f, 31.179128f,-107.985426f, 31.334708f,-107.998761f, 31.485987f,-107.960540f,
                    31.493492f,-107.990244f, 31.583877f,-107.999479f, 31.579627f,-106.691962f, 31.556254f,-106.692916f, 31.553100f,-106.615586f,
                    31.486038f,-106.575578f, 31.495018f,-106.545336f, 31.466979f,-106.507061f, 31.432474f,-106.519610f, 31.415277f,-106.472323f,
                    31.324550f,-106.442670f, 31.323522f,-106.408125f, 31.284685f,-106.409890f, 31.279887f,-106.367927f, 31.232855f,-106.348099f,
                    31.234268f,-106.302812f, 31.203335f,-106.285010f, 31.213042f,-106.268143f, 31.187601f,-106.226256f, 31.198344f,-106.202074f,
                    31.159515f,-106.166015f);
            poly[568] = new TzPolygon(31.159515f,-106.158737f, 31.171795f,-106.145514f, 31.159515f,-106.145627f);
            poly[569] = new TzPolygon(31.208682f,-105.802648f, 31.292048f,-105.875488f, 31.316248f,-105.937897f, 31.360714f,-105.949829f, 31.392328f,-106.006889f,
                    31.397142f,-106.072571f, 31.469688f,-106.205597f, 31.729677f,-106.375084f, 31.747938f,-106.484932f, 31.778206f,-106.521141f,
                    31.783461f,-108.203476f, 31.331347f,-108.205894f, 31.331550f,-108.558060f, 35.257645f,-108.558060f, 35.257645f,-105.802648f);
            poly[570] = new TzPolygon(31.208682f,-105.802648f, 31.170973f,-105.769699f, 31.159515f,-105.746706f, 31.159515f,-105.802648f);
            poly[571] = new TzPolygon(31.159515f,-104.908376f, 32.002937f,-104.920052f, 31.999643f,-103.064163f, 35.257645f,-103.047236f, 31.159515f,-103.047236f);
            poly[572] = new TzPolygon(26.356742f,-98.868361f, 26.353493f,-98.895615f, 26.390551f,-98.928772f, 26.371952f,-98.943237f, 26.410971f,-99.032402f,
                    26.391436f,-99.069305f, 26.419394f,-99.111893f, 26.477089f,-99.093086f, 26.538620f,-99.171707f, 26.563108f,-99.158791f,
                    26.790249f,-99.234604f, 26.857126f,-99.285888f, 26.857126f,-98.868361f);
            poly[573] = new TzPolygon(26.857126f,-99.652099f, 26.841001f,-99.613557f, 26.791759f,-99.614576f, 26.777372f,-99.564793f, 26.713391f,-99.555783f,
                    26.725340f,-99.470934f, 26.556913f,-99.408949f, 26.503211f,-99.447287f, 26.470555f,-99.401544f, 26.405633f,-99.421336f,
                    26.313804f,-99.331187f, 26.278692f,-99.338997f, 26.251748f,-99.266877f, 26.153134f,-99.221662f, 26.167686f,-99.155519f,
                    26.114412f,-99.109463f, 26.135338f,-99.037998f, 26.087788f,-98.991343f, 26.080481f,-98.875480f, 26.063733f,-98.868361f,
                    25.453518f,-98.868361f, 25.453518f,-100.261320f, 26.857126f,-100.261320f);
            poly[574] = new TzPolygon(26.055213f,-98.171882f, 26.053680f,-98.205261f, 26.095375f,-98.289948f, 26.108961f,-98.267014f, 26.129541f,-98.290245f,
                    26.101149f,-98.300034f, 26.155322f,-98.334759f, 26.155322f,-98.171882f);
            poly[575] = new TzPolygon(26.155322f,-98.365070f, 26.151628f,-98.382278f, 26.155322f,-98.383371f);
            poly[576] = new TzPolygon(26.063733f,-98.868361f, 26.025813f,-98.852244f, 26.026542f,-98.792483f, 25.995455f,-98.772402f, 26.010032f,-98.749835f,
                    25.951506f,-98.700711f, 25.971685f,-98.644908f, 25.947549f,-98.612430f, 25.961031f,-98.578709f, 25.943439f,-98.560519f,
                    25.960628f,-98.543895f, 25.900524f,-98.508240f, 25.908242f,-98.476469f, 25.841505f,-98.403819f, 25.826476f,-98.296391f,
                    25.794633f,-98.284367f, 25.806598f,-98.252683f, 25.765956f,-98.185669f, 25.765782f,-98.171882f, 25.453518f,-98.171882f,
                    25.453518f,-98.868361f);
            poly[577] = new TzPolygon(25.878584f,-97.475403f, 25.882858f,-97.525116f, 25.923988f,-97.540314f, 25.930691f,-97.582520f, 25.945751f,-97.570625f,
                    25.952175f,-97.605980f, 26.031235f,-97.662819f, 26.019741f,-97.738167f, 26.059607f,-97.859726f, 26.054325f,-98.024223f,
                    26.029640f,-98.083344f, 26.059200f,-98.085068f, 26.055213f,-98.171882f, 26.155322f,-98.171882f, 26.155322f,-97.475403f);
            poly[578] = new TzPolygon(25.765782f,-98.171882f, 25.765178f,-98.123755f, 25.787623f,-98.105949f, 25.752065f,-98.075673f, 25.780512f,-98.042264f,
                    25.763083f,-97.965599f, 25.794279f,-97.948361f, 25.797941f,-97.924464f, 25.773600f,-97.908044f, 25.794514f,-97.873426f,
                    25.761058f,-97.852639f, 25.751214f,-97.777207f, 25.723889f,-97.772969f, 25.729999f,-97.733568f, 25.639501f,-97.668220f,
                    25.650320f,-97.623104f, 25.606461f,-97.599337f, 25.606197f,-97.525202f, 25.576746f,-97.501577f, 25.590222f,-97.475403f,
                    25.453518f,-97.475403f, 25.453518f,-97.523981f, 25.462065f,-97.546921f, 25.453518f,-97.553956f, 25.453518f,-98.171882f);
            poly[579] = new TzPolygon(26.356742f,-98.868361f, 26.364073f,-98.806862f, 26.326109f,-98.783272f, 26.316826f,-98.745697f, 26.290442f,-98.751541f,
                    26.284639f,-98.695641f, 26.266184f,-98.714005f, 26.232075f,-98.664917f, 26.257401f,-98.593315f, 26.226242f,-98.565247f,
                    26.243958f,-98.548615f, 26.199932f,-98.482758f, 26.223423f,-98.477089f, 26.217936f,-98.451477f, 26.187862f,-98.433739f,
                    26.181026f,-98.390976f, 26.155322f,-98.383371f, 26.155322f,-98.868361f);
            poly[580] = new TzPolygon(26.155322f,-98.365070f, 26.161041f,-98.338425f, 26.155322f,-98.334759f);
            poly[581] = new TzPolygon(28.957256f,-102.768432f, 28.940813f,-102.780148f, 28.930938f,-102.835522f, 28.896030f,-102.839967f, 28.895579f,-102.875717f,
                    28.832422f,-102.877522f, 28.820419f,-102.908374f, 28.795853f,-102.907384f, 28.787238f,-102.960446f, 28.764079f,-102.961834f,
                    28.767313f,-103.015816f, 28.738053f,-103.023407f, 28.737256f,-103.047236f, 28.957256f,-103.047236f);
            poly[582] = new TzPolygon(27.881904f,-100.226225f, 27.907191f,-100.267441f, 27.907191f,-100.226225f);
            poly[583] = new TzPolygon(26.857126f,-99.285888f, 26.918573f,-99.333008f, 26.939327f,-99.385628f, 26.976080f,-99.380989f, 27.017824f,-99.451202f,
                    27.161259f,-99.428909f, 27.247444f,-99.445305f, 27.257965f,-99.494080f, 27.296402f,-99.494621f, 27.311853f,-99.539360f,
                    27.332058f,-99.508301f, 27.382159f,-99.493753f, 27.382159f,-99.285888f);
            poly[584] = new TzPolygon(27.382159f,-100.226225f, 27.382159f,-99.770407f, 27.341502f,-99.820645f, 27.322268f,-99.805079f, 27.304312f,-99.822102f,
                    27.279205f,-99.795619f, 27.255212f,-99.812317f, 27.184423f,-99.734232f, 27.121489f,-99.741818f, 27.096329f,-99.717714f,
                    27.082871f,-99.733228f, 27.030824f,-99.688081f, 26.972008f,-99.730310f, 26.922634f,-99.683047f, 26.875285f,-99.695503f,
                    26.857126f,-99.652099f, 26.857126f,-100.226225f);
            poly[585] = new TzPolygon(27.382159f,-99.285888f, 27.382159f,-99.493753f, 27.399113f,-99.488831f, 27.480083f,-99.482826f, 27.495914f,-99.527191f,
                    27.563145f,-99.514664f, 27.607834f,-99.549034f, 27.597767f,-99.582466f, 27.634180f,-99.595757f, 27.623415f,-99.633141f,
                    27.629160f,-99.663055f, 27.656132f,-99.671417f, 27.653168f,-99.711189f, 27.769539f,-99.812141f, 27.761175f,-99.837692f,
                    27.794563f,-99.873878f, 27.872801f,-99.902740f, 27.897003f,-99.891151f, 27.907191f,-99.901689f, 27.907191f,-99.285888f);
            poly[586] = new TzPolygon(27.881904f,-100.226225f, 27.863994f,-100.197033f, 27.778791f,-100.169503f, 27.752606f,-100.114819f, 27.699028f,-100.140098f,
                    27.680245f,-100.100309f, 27.581088f,-100.059427f, 27.585169f,-100.001119f, 27.533616f,-99.995443f, 27.532447f,-99.943195f,
                    27.477745f,-99.933061f, 27.457333f,-99.828789f, 27.383660f,-99.791730f, 27.384556f,-99.767444f, 27.382159f,-99.770407f,
                    27.382159f,-100.226225f);
            poly[587] = new TzPolygon(27.907191f,-99.285888f, 27.907191f,-99.901689f, 27.940657f,-99.936302f, 27.976643f,-99.931389f, 27.997364f,-99.994255f,
                    28.141123f,-100.078918f, 28.189318f,-100.201256f, 28.228365f,-100.213882f, 28.233269f,-100.247520f, 28.277470f,-100.287231f,
                    28.475183f,-100.362465f, 28.494431f,-100.332573f, 28.514383f,-100.384842f, 28.581675f,-100.394287f, 28.672371f,-100.500923f,
                    28.798506f,-100.529686f, 28.941429f,-100.636658f, 28.957256f,-100.640395f, 28.957256f,-99.285888f);
            poly[588] = new TzPolygon(28.957256f,-100.922562f, 28.916794f,-100.912339f, 28.921873f,-100.867199f, 28.904528f,-100.855039f, 28.833072f,-100.889248f,
                    28.788064f,-100.871730f, 28.780146f,-100.830530f, 28.691732f,-100.813712f, 28.684213f,-100.786098f, 28.609222f,-100.754575f,
                    28.602031f,-100.724544f, 28.491220f,-100.718212f, 28.478465f,-100.669513f, 28.378291f,-100.632791f, 28.343563f,-100.571511f,
                    28.268198f,-100.596558f, 28.209054f,-100.503389f, 28.117419f,-100.520435f, 28.105767f,-100.457797f, 28.049015f,-100.462114f,
                    28.029934f,-100.388164f, 27.961514f,-100.360998f, 27.960278f,-100.291545f, 27.909927f,-100.271900f, 27.907191f,-100.267441f,
                    27.907191f,-101.166562f, 28.957256f,-101.166562f);
            poly[589] = new TzPolygon(29.482288f,-103.047236f, 29.482288f,-102.813514f, 29.437746f,-102.827087f, 29.395704f,-102.811684f, 29.356026f,-102.837219f,
                    29.341852f,-102.879997f, 29.255547f,-102.903709f, 29.218758f,-102.865242f, 29.172953f,-102.991806f, 29.100403f,-103.028214f,
                    29.096181f,-103.047236f);
            poly[590] = new TzPolygon(28.957256f,-102.768432f, 29.000412f,-102.737685f, 29.002577f,-102.703179f, 29.042628f,-102.705452f, 29.057275f,-102.645008f,
                    29.100275f,-102.655427f, 29.128207f,-102.596975f, 29.167552f,-102.615725f, 29.194799f,-102.583416f, 29.246823f,-102.598648f,
                    29.293142f,-102.547709f, 29.339891f,-102.565512f, 29.361912f,-102.538927f, 29.409250f,-102.562978f, 29.435469f,-102.503228f,
                    29.482047f,-102.511298f, 29.475697f,-102.451144f, 29.482288f,-102.446373f, 29.482288f,-102.106899f, 28.957256f,-102.106899f);
            poly[591] = new TzPolygon(29.793574f,-102.106899f, 29.800131f,-102.136703f, 29.846092f,-102.180336f, 29.841068f,-102.222275f, 29.879465f,-102.314255f,
                    29.847326f,-102.357697f, 29.763218f,-102.384827f, 29.784315f,-102.482689f, 29.782135f,-102.511406f, 29.743233f,-102.542931f,
                    29.771544f,-102.563866f, 29.734341f,-102.627480f, 29.744328f,-102.667465f, 29.678961f,-102.687950f, 29.631794f,-102.737289f,
                    29.592539f,-102.738449f, 29.595802f,-102.760262f, 29.546234f,-102.768799f, 29.521042f,-102.801704f, 29.482288f,-102.813514f,
                    29.482288f,-103.047236f, 30.007321f,-103.047236f, 30.007321f,-102.106899f);
            poly[592] = new TzPolygon(29.482288f,-102.446373f, 29.515854f,-102.422078f, 29.484215f,-102.338378f, 29.521352f,-102.311842f, 29.508680f,-102.279681f,
                    29.543736f,-102.254545f, 29.538173f,-102.213494f, 29.557914f,-102.210819f, 29.519925f,-102.177416f, 29.532792f,-102.158663f,
                    29.512307f,-102.142145f, 29.540728f,-102.106899f, 29.482288f,-102.106899f);
            poly[593] = new TzPolygon(29.478391f,-101.166562f, 29.479870f,-101.171135f, 29.482288f,-101.172230f, 29.482288f,-101.166562f);
            poly[594] = new TzPolygon(29.482288f,-102.106899f, 29.482288f,-101.754396f, 29.481116f,-101.752856f, 29.482288f,-101.751164f, 29.482288f,-101.718391f,
                    29.475720f,-101.712003f, 29.475367f,-101.653308f, 29.482288f,-101.647416f, 29.482288f,-101.620998f, 29.471186f,-101.606086f,
                    29.482288f,-101.594311f, 29.482288f,-101.573664f, 29.436717f,-101.549169f, 29.437885f,-101.530290f, 29.395624f,-101.528703f,
                    29.389430f,-101.477298f, 29.328597f,-101.458128f, 29.327639f,-101.419253f, 29.289396f,-101.411833f, 29.278001f,-101.273137f,
                    29.245889f,-101.273595f, 29.245324f,-101.233996f, 29.208909f,-101.242238f, 29.198562f,-101.196528f, 29.137041f,-101.173393f,
                    29.138232f,-101.166562f, 28.957256f,-101.166562f, 28.957256f,-102.106899f);
            poly[595] = new TzPolygon(29.482288f,-101.166562f, 29.482288f,-101.172230f, 29.522051f,-101.190231f, 29.523605f,-101.253258f, 29.623137f,-101.253632f,
                    29.570261f,-101.306213f, 29.638956f,-101.298920f, 29.658142f,-101.346230f, 29.644072f,-101.359612f, 29.694468f,-101.369347f,
                    29.743660f,-101.413078f, 29.767847f,-101.400597f, 29.746548f,-101.444107f, 29.787117f,-101.458519f, 29.756044f,-101.533241f,
                    29.809868f,-101.543022f, 29.767071f,-101.576538f, 29.751009f,-101.643646f, 29.780125f,-101.807892f, 29.809793f,-101.814140f,
                    29.786915f,-101.822830f, 29.804621f,-101.852402f, 29.779781f,-101.929062f, 29.814798f,-101.973755f, 29.795147f,-101.985275f,
                    29.785440f,-102.069923f, 29.793574f,-102.106899f, 30.007321f,-102.106899f, 30.007321f,-101.166562f);
            poly[596] = new TzPolygon(29.540728f,-102.106899f, 29.502611f,-102.067204f, 29.532264f,-102.038116f, 29.514535f,-102.027268f, 29.526861f,-101.965497f,
                    29.497149f,-101.938089f, 29.537036f,-101.888592f, 29.509733f,-101.860567f, 29.514604f,-101.796865f, 29.482288f,-101.754396f,
                    29.482288f,-102.106899f);
            poly[597] = new TzPolygon(29.482288f,-101.751164f, 29.495847f,-101.731578f, 29.482288f,-101.718391f);
            poly[598] = new TzPolygon(29.482288f,-101.647416f, 29.494327f,-101.637168f, 29.482288f,-101.620998f);
            poly[599] = new TzPolygon(29.482288f,-101.594311f, 29.495209f,-101.580608f, 29.482288f,-101.573664f);
        }
    }

    private static class Initializer7 {
        private static void init() {
            poly[600] = new TzPolygon(28.957256f,-100.640395f, 29.102413f,-100.674675f, 29.165094f,-100.769157f, 29.258591f,-100.812798f, 29.363337f,-101.007683f,
                    29.442814f,-101.056587f, 29.478391f,-101.166562f, 31.057385f,-101.166562f, 31.057385f,-99.285888f, 28.957256f,-99.285888f);
            poly[601] = new TzPolygon(29.138232f,-101.166562f, 29.146490f,-101.119222f, 29.100684f,-101.104019f, 29.097871f,-101.041835f, 29.066538f,-101.041566f,
                    29.014187f,-100.979968f, 28.985498f,-100.984269f, 28.968751f,-100.925466f, 28.957256f,-100.922562f, 28.957256f,-101.166562f);
            poly[602] = new TzPolygon(25.603125f,-97.450340f, 25.590222f,-97.475403f, 25.603125f,-97.475403f);
            poly[603] = new TzPolygon(25.557400f,-97.406975f, 25.603125f,-97.450340f, 25.603125f,-97.406975f);
            poly[604] = new TzPolygon(25.878584f,-97.475403f, 25.878584f,-97.406975f, 25.845987f,-97.406975f, 25.852848f,-97.410355f, 25.836241f,-97.422646f,
                    25.863562f,-97.447807f, 25.856382f,-97.469337f, 25.877155f,-97.458786f);
            poly[605] = new TzPolygon(49.002640f,-123.035405f, 49.001335f,-123.034027f, 49.001205f,-123.091866f, 49.002640f,-123.092029f);
            poly[606] = new TzPolygon(49.002640f,-122.763202f, 49.002640f,-118.678200f, 49.000088f,-118.678200f, 48.999363f,-121.093048f, 49.001190f,-122.756149f);
            poly[607] = new TzPolygon(28.002499f,-112.769588f, 27.998886f,-112.764153f, 28.000336f,-114.203705f, 28.002499f,-114.202100f);
            poly[608] = new TzPolygon(32.419422f,-116.797958f, 32.419422f,-117.096455f, 32.464302f,-117.116920f, 32.534622f,-117.123581f, 32.559267f,-116.797958f);
            poly[609] = new TzPolygon(31.986613f,-116.797958f, 31.986613f,-116.484362f, 31.694955f,-116.541717f, 31.685986f,-116.663143f, 31.741388f,-116.731522f,
                    31.719105f,-116.668983f, 31.732620f,-116.642738f, 31.774395f,-116.612038f, 31.846441f,-116.607285f, 31.905546f,-116.740944f,
                    31.971329f,-116.765701f, 31.974984f,-116.797958f);
            poly[610] = new TzPolygon(31.986613f,-115.002302f, 31.986613f,-113.899330f, 31.602788f,-113.899330f, 31.613111f,-113.907982f, 31.595978f,-113.927971f,
                    31.656334f,-113.972076f, 31.585730f,-113.963905f, 31.568125f,-113.992340f, 31.566891f,-113.939560f, 31.491383f,-114.025932f,
                    31.497679f,-114.169975f, 31.674109f,-114.491013f, 31.764387f,-114.593025f, 31.764305f,-114.693687f, 31.817017f,-114.753845f,
                    31.822977f,-114.810555f, 31.957062f,-115.028946f);
            poly[611] = new TzPolygon(33.478561f,-114.603758f, 33.423458f,-114.634239f, 33.404583f,-114.724243f, 33.344620f,-114.697563f, 33.302280f,-114.728806f,
                    33.264740f,-114.670082f, 33.088184f,-114.703598f, 33.033310f,-114.660667f, 33.049503f,-114.644218f, 33.028618f,-114.614380f,
                    33.025429f,-114.509384f, 32.974518f,-114.491791f, 32.969753f,-114.466347f, 32.846184f,-114.466003f, 32.797150f,-114.526100f,
                    32.750896f,-114.537178f, 32.729115f,-114.613914f, 32.744984f,-114.698471f, 32.716342f,-114.722538f, 32.559267f,-116.797958f,
                    33.478561f,-116.797958f);
            poly[612] = new TzPolygon(32.559267f,-116.797958f, 32.716759f,-114.717033f, 32.665752f,-114.739151f, 32.618076f,-114.803703f, 32.509629f,-114.803682f,
                    32.388409f,-116.405347f, 31.986613f,-116.484362f, 31.986613f,-116.797958f);
            poly[613] = new TzPolygon(31.986613f,-116.484362f, 32.388409f,-116.405347f, 32.509629f,-114.803682f, 32.230785f,-114.986862f, 32.124508f,-114.980667f,
                    32.123096f,-114.997780f, 32.028042f,-114.964951f, 31.986613f,-115.002302f);
            poly[614] = new TzPolygon(31.986613f,-115.002302f, 32.028042f,-114.964951f, 32.123096f,-114.997780f, 32.124508f,-114.980667f, 32.230785f,-114.986862f,
                    32.495926f,-114.814217f, 32.211144f,-113.899330f, 31.986613f,-113.899330f);
            poly[615] = new TzPolygon(32.215359f,-113.899330f, 33.478561f,-113.899330f, 33.478561f,-111.000702f, 31.328904f,-111.000702f, 31.328808f,-111.064751f);
            poly[616] = new TzPolygon(33.478561f,-114.603758f, 33.500420f,-114.591667f, 33.557877f,-114.524681f, 33.674236f,-114.529533f, 33.706165f,-114.490837f,
                    33.856220f,-114.528282f, 33.879589f,-114.500198f, 33.940723f,-114.531532f, 34.022591f,-114.438850f, 34.109634f,-114.414917f,
                    34.181919f,-114.244957f, 34.267208f,-114.129486f, 34.356014f,-114.180199f, 34.454441f,-114.335358f, 34.458839f,-114.382996f,
                    34.530361f,-114.378944f, 34.596024f,-114.434021f, 34.613541f,-114.421722f, 34.715199f,-114.470779f, 34.769875f,-114.549484f,
                    34.880173f,-114.634712f, 35.035320f,-114.635208f, 35.067707f,-114.603653f, 35.106956f,-114.649239f, 35.130695f,-114.579346f,
                    35.179996f,-114.570724f, 35.241411f,-114.582325f, 35.241411f,-114.047243f, 33.478561f,-114.047243f);
            poly[617] = new TzPolygon(35.241411f,-114.582325f, 35.343788f,-114.601662f, 35.500530f,-114.680489f, 35.608101f,-114.655334f, 35.705040f,-114.704613f,
                    35.808628f,-114.712746f, 35.852985f,-114.705910f, 35.871895f,-114.662720f, 35.944523f,-114.731918f, 35.984608f,-114.745300f,
                    36.030037f,-114.723618f, 36.091862f,-114.753014f, 36.150917f,-114.572937f, 36.151756f,-114.507431f, 36.128323f,-114.504356f,
                    36.147324f,-114.396706f, 36.102016f,-114.321404f, 36.062843f,-114.316216f, 36.023148f,-114.258125f, 36.030521f,-114.147385f,
                    36.113037f,-114.122757f, 36.195095f,-114.048653f, 36.999989f,-114.050964f, 36.999994f,-114.047243f, 35.241411f,-114.047243f);
            poly[618] = new TzPolygon(35.241411f,-111.237861f, 35.241411f,-111.000702f, 35.158649f,-111.000702f, 35.156540f,-111.236458f);
            poly[619] = new TzPolygon(36.122836f,-112.523972f, 36.122836f,-111.759797f, 36.008282f,-111.760162f, 35.979126f,-111.705681f, 35.848061f,-111.722649f,
                    35.825745f,-111.688690f, 35.746346f,-111.689018f, 35.746017f,-111.741722f, 35.672962f,-111.740837f, 35.672699f,-111.640633f,
                    35.641388f,-111.640778f, 35.640182f,-111.553062f, 35.758530f,-111.531952f, 35.758411f,-111.315582f, 35.613194f,-111.317871f,
                    35.572510f,-111.268478f, 35.497009f,-111.242088f, 35.241411f,-111.237861f, 35.241411f,-112.523972f);
            poly[620] = new TzPolygon(36.122836f,-111.212260f, 36.122836f,-111.157669f, 36.107941f,-111.157692f, 36.122836f,-111.127176f, 36.122836f,-111.082734f,
                    36.057007f,-111.082367f, 36.019455f,-111.115135f, 36.023289f,-111.138977f, 35.965591f,-111.138969f, 35.964882f,-111.246925f,
                    36.030693f,-111.255592f, 36.052624f,-111.295197f, 36.096832f,-111.278038f);
            poly[621] = new TzPolygon(36.937727f,-111.328409f, 36.869591f,-111.232796f, 36.905941f,-111.321060f);
            poly[622] = new TzPolygon(37.002400f,-112.523972f, 37.004261f,-111.345024f, 36.937727f,-111.328409f, 36.966995f,-111.376945f, 36.946236f,-111.395546f,
                    36.954151f,-111.438675f, 36.924587f,-111.419319f, 36.932983f,-111.470497f, 36.873741f,-111.506439f, 36.870789f,-111.564125f,
                    36.841702f,-111.545898f, 36.855499f,-111.600449f, 36.714771f,-111.701080f, 36.670296f,-111.685768f, 36.685810f,-111.724724f,
                    36.613300f,-111.745621f, 36.565331f,-111.797348f, 36.551250f,-111.784210f, 36.551289f,-111.809410f, 36.519093f,-111.811783f,
                    36.504169f,-111.841583f, 36.450172f,-111.819389f, 36.424374f,-111.858337f, 36.393040f,-111.828102f, 36.368607f,-111.873871f,
                    36.223370f,-111.801117f, 36.206963f,-111.759529f, 36.122836f,-111.759797f, 36.122836f,-112.523972f);
            poly[623] = new TzPolygon(36.122836f,-111.212260f, 36.162804f,-111.205261f, 36.123356f,-111.209557f, 36.122836f,-111.157669f);
            poly[624] = new TzPolygon(36.122836f,-111.127176f, 36.144470f,-111.082855f, 36.122836f,-111.082734f);
            poly[625] = new TzPolygon(41.521236f,-118.678200f, 41.521236f,-114.039373f, 37.004261f,-114.047243f, 37.004261f,-118.678200f);
            poly[626] = new TzPolygon(41.993091f,-114.839451f, 42.000309f,-117.029274f, 42.452209f,-117.029724f, 42.448506f,-118.214354f, 43.362724f,-118.236198f,
                    43.779724f,-118.234785f, 43.779724f,-114.839451f);
            poly[627] = new TzPolygon(43.779724f,-118.234785f, 44.256397f,-118.233170f, 44.271439f,-118.154144f, 44.299690f,-118.153168f, 44.329189f,-118.094635f,
                    44.414692f,-118.032112f, 44.442749f,-117.971565f, 44.445923f,-117.590569f, 44.387012f,-117.485008f, 44.299870f,-117.483765f,
                    44.301785f,-117.218132f, 44.319607f,-117.196716f, 44.389275f,-117.240196f, 44.428146f,-117.212967f, 44.484531f,-117.221634f,
                    44.535202f,-117.147339f, 44.730198f,-117.057388f, 44.783031f,-116.935211f, 44.881615f,-116.855194f, 45.028683f,-116.841270f,
                    45.113689f,-116.758825f, 43.779724f,-116.758825f);
            poly[628] = new TzPolygon(45.829731f,-116.758825f, 45.832050f,-116.787354f, 45.858635f,-116.788963f, 45.878064f,-116.758825f);
            poly[629] = new TzPolygon(45.113689f,-116.758825f, 45.145035f,-116.728424f, 45.327099f,-116.667038f, 45.609306f,-116.461639f, 45.692520f,-116.534126f,
                    45.752079f,-116.546715f, 45.779308f,-116.592361f, 45.781181f,-116.662354f, 45.825699f,-116.709236f, 45.829731f,-116.758825f,
                    45.878064f,-116.758825f, 45.897457f,-116.728745f, 45.966591f,-116.744606f, 45.999191f,-116.698494f, 45.995495f,-116.646637f,
                    46.038212f,-116.624603f, 45.980927f,-116.548569f, 45.974506f,-116.456055f, 45.918129f,-116.429535f, 45.894348f,-116.329453f,
                    45.861820f,-116.297836f, 45.763935f,-116.330444f, 45.732231f,-116.306740f, 45.671219f,-116.320076f, 45.667141f,-116.282806f,
                    45.626133f,-116.305809f, 45.601845f,-116.275200f, 45.573997f,-116.306351f, 45.417080f,-116.315109f, 45.402744f,-116.223175f,
                    45.428894f,-116.142677f, 45.401428f,-116.108253f, 45.460991f,-115.933624f, 45.469177f,-115.802559f, 45.378918f,-115.510117f,
                    45.460899f,-115.421707f, 45.476887f,-115.353058f, 45.535316f,-115.292671f, 45.570072f,-115.207848f, 45.507389f,-115.017349f,
                    45.408785f,-114.839451f, 43.779724f,-114.839451f, 43.779724f,-116.758825f);
            poly[630] = new TzPolygon(43.779724f,-114.839451f, 43.779724f,-111.045665f, 43.313576f,-111.043617f, 42.000484f,-111.046280f, 41.989838f,-113.852577f,
                    41.993091f,-114.839451f);
            poly[631] = new TzPolygon(41.995231f,-114.839451f, 41.993378f,-114.040382f, 41.521236f,-114.039373f, 41.521236f,-114.839451f);
            poly[632] = new TzPolygon(44.416807f,-112.920076f, 44.456535f,-113.007256f, 44.527016f,-113.009430f, 44.604164f,-113.085777f, 44.636936f,-113.051628f,
                    44.775398f,-113.134651f, 44.822880f,-113.247505f, 44.788002f,-113.344398f, 44.820454f,-113.356804f, 44.869984f,-113.456039f,
                    44.908968f,-113.477924f, 44.908968f,-112.920076f);
            poly[633] = new TzPolygon(45.408785f,-114.839451f, 45.394676f,-114.813995f, 45.397205f,-114.733253f, 45.440044f,-114.795746f, 45.508602f,-114.795395f,
                    45.466316f,-114.662689f, 45.527149f,-114.624474f, 45.561474f,-114.564674f, 45.564686f,-114.467743f, 45.458687f,-114.334961f,
                    45.484043f,-114.271538f, 45.546688f,-114.247284f, 45.536381f,-114.196213f, 45.590244f,-114.089462f, 45.653015f,-114.016319f,
                    45.695206f,-114.014404f, 45.694187f,-113.933609f, 45.619148f,-113.902534f, 45.620108f,-113.879764f, 44.908968f,-113.879764f,
                    44.908968f,-114.839451f);
            poly[634] = new TzPolygon(46.038212f,-114.501509f, 46.032570f,-114.505646f, 46.025841f,-114.475327f, 45.994720f,-114.480026f, 45.977318f,-114.412842f,
                    45.934586f,-114.430725f, 45.886280f,-114.385986f, 45.852184f,-114.409714f, 45.846863f,-114.507454f, 45.777309f,-114.565544f,
                    45.718010f,-114.500740f, 45.671497f,-114.500114f, 45.638767f,-114.562370f, 45.608116f,-114.538033f, 45.570793f,-114.557388f,
                    45.527149f,-114.624474f, 45.470894f,-114.655548f, 45.508602f,-114.795395f, 45.440044f,-114.795746f, 45.397205f,-114.733253f,
                    45.394676f,-114.813995f, 45.408785f,-114.839451f, 46.038212f,-114.839451f);
            poly[635] = new TzPolygon(45.620108f,-113.879764f, 45.621208f,-113.853683f, 45.591225f,-113.800598f, 45.519623f,-113.833862f, 45.519234f,-113.771378f,
                    45.408787f,-113.774597f, 45.390072f,-113.733597f, 45.330830f,-113.738487f, 45.257942f,-113.687416f, 45.180580f,-113.590569f,
                    45.125992f,-113.572823f, 45.111832f,-113.508141f, 45.087349f,-113.521599f, 45.055286f,-113.451385f, 44.958603f,-113.446198f,
                    44.942776f,-113.496902f, 44.908968f,-113.477924f, 44.908968f,-113.879764f);
            poly[636] = new TzPolygon(44.417700f,-112.920076f, 44.403217f,-112.887566f, 44.358097f,-112.850761f, 44.381138f,-112.814865f, 44.443951f,-112.828430f,
                    44.485809f,-112.776932f, 44.505577f,-112.714928f, 44.464520f,-112.504463f, 44.478897f,-112.466888f, 44.449276f,-112.383423f,
                    44.532997f,-112.355782f, 44.569122f,-112.286232f, 44.524021f,-112.104919f, 44.566185f,-111.869354f, 44.511135f,-111.822334f,
                    44.558655f,-111.701248f, 44.540604f,-111.465439f, 44.597107f,-111.522545f, 44.644619f,-111.514099f, 44.668003f,-111.471725f,
                    44.703087f,-111.487648f, 44.712883f,-111.411049f, 44.753010f,-111.388000f, 44.730301f,-111.329399f, 44.648163f,-111.274010f,
                    44.622036f,-111.217514f, 44.612568f,-111.240761f, 44.580318f,-111.228523f, 44.533855f,-111.133125f, 44.490868f,-111.111946f,
                    44.477230f,-111.048729f, 43.779724f,-111.045665f, 43.779724f,-112.920076f);
            poly[637] = new TzPolygon(49.094256f,-118.678200f, 49.094256f,-117.038817f, 49.059400f,-117.038600f, 49.064000f,-116.909500f, 49.037500f,-116.886300f,
                    49.000616f,-116.921369f, 49.000088f,-118.678200f);
            poly[638] = new TzPolygon(48.999027f,-114.839451f, 49.000679f,-115.728397f, 49.029600f,-115.733400f, 49.094256f,-115.826302f, 49.094256f,-114.839451f);
            poly[639] = new TzPolygon(49.094256f,-117.047873f, 49.094256f,-115.826745f, 49.019400f,-115.727000f, 49.000679f,-115.728397f, 49.000616f,-116.921369f,
                    49.037500f,-116.886300f, 49.064000f,-116.909500f, 49.059400f,-117.038600f);
            poly[640] = new TzPolygon(46.797736f,-114.839451f, 46.810925f,-114.865875f, 46.803410f,-114.899895f, 46.862343f,-114.946289f, 46.915195f,-114.923256f,
                    46.973938f,-115.010460f, 46.970745f,-115.049881f, 47.101925f,-115.140564f, 47.188637f,-115.296310f, 47.258110f,-115.320145f,
                    47.287327f,-115.502937f, 47.374165f,-115.595520f, 47.425583f,-115.759743f, 47.474628f,-115.634911f, 47.485001f,-115.686539f,
                    47.532249f,-115.700806f, 47.545292f,-115.753601f, 47.592598f,-115.689842f, 47.649132f,-115.732094f, 47.699951f,-115.725410f,
                    47.755310f,-115.798965f, 47.752319f,-115.831436f, 47.825348f,-115.853699f, 47.973011f,-116.047104f, 49.000374f,-116.050720f,
                    49.000468f,-114.839451f);
            poly[641] = new TzPolygon(49.094256f,-117.047873f, 49.101500f,-117.049800f, 49.155800f,-117.039200f, 49.167300f,-116.988900f, 49.149900f,-116.940200f,
                    49.182600f,-116.940100f, 49.213500f,-116.861000f, 49.177500f,-116.830200f, 49.223492f,-116.758825f, 49.094256f,-116.758825f);
            poly[642] = new TzPolygon(49.346927f,-116.758825f, 49.589200f,-116.832300f, 49.637700f,-116.911100f, 49.809200f,-116.869700f, 49.800910f,-116.758825f);
            poly[643] = new TzPolygon(50.692730f,-116.758825f, 50.707300f,-116.786700f, 50.923100f,-117.069100f, 50.961900f,-117.042600f, 50.975900f,-117.162300f,
                    51.017800f,-117.134500f, 51.066500f,-117.217300f, 51.283300f,-117.333100f, 51.273500f,-117.217300f, 51.300000f,-117.235100f,
                    51.329200f,-117.201200f, 51.361100f,-117.249300f, 51.367700f,-117.361800f, 51.401700f,-117.373600f, 51.412200f,-117.420400f,
                    51.467100f,-117.432000f, 51.418300f,-117.717400f, 51.453200f,-117.815800f, 51.488200f,-117.847500f, 51.451400f,-117.923700f,
                    51.473200f,-117.976000f, 51.530500f,-117.940300f, 51.623800f,-117.980100f, 51.656000f,-117.913300f, 51.722100f,-117.943000f,
                    51.748600f,-118.012600f, 51.721400f,-118.031700f, 51.732600f,-118.109700f, 51.773300f,-118.130700f, 51.786500f,-118.184600f,
                    51.897900f,-118.113300f, 51.895800f,-118.159000f, 51.950400f,-118.192600f, 51.986800f,-118.288100f, 51.980800f,-118.389500f,
                    52.031100f,-118.400400f, 52.012600f,-118.438900f, 52.054500f,-118.512000f, 52.054100f,-118.588400f, 52.104900f,-118.607000f,
                    52.150300f,-118.678200f, 52.150300f,-116.758825f);
            poly[644] = new TzPolygon(49.858267f,-116.685509f, 49.802800f,-116.678800f, 49.805483f,-116.758825f, 49.858267f,-116.758825f);
            poly[645] = new TzPolygon(49.346927f,-116.758825f, 49.271900f,-116.683700f, 49.223492f,-116.758825f);
            poly[646] = new TzPolygon(49.094256f,-115.826302f, 49.098500f,-115.832400f, 49.131100f,-115.822200f, 49.166000f,-115.861400f, 49.159100f,-115.936200f,
                    49.190600f,-115.947500f, 49.196400f,-116.002700f, 49.291600f,-116.026800f, 49.291400f,-116.057100f, 49.261100f,-116.070900f,
                    49.293600f,-116.104600f, 49.288000f,-116.166900f, 49.326200f,-116.185200f, 49.354900f,-116.150700f, 49.420700f,-116.236900f,
                    49.522700f,-116.296900f, 49.533800f,-116.432400f, 49.488900f,-116.467200f, 49.457000f,-116.557600f, 49.477000f,-116.594800f,
                    49.472200f,-116.664100f, 49.555900f,-116.620600f, 49.570400f,-116.683200f, 49.619700f,-116.644600f, 49.642100f,-116.677400f,
                    49.699000f,-116.587900f, 49.736500f,-116.588200f, 49.802800f,-116.678800f, 49.858267f,-116.685509f, 49.858267f,-115.799138f,
                    49.094256f,-115.799138f);
            poly[647] = new TzPolygon(49.858267f,-116.685509f, 49.883000f,-116.688500f, 49.887500f,-116.633600f, 49.985800f,-116.508400f, 49.967600f,-116.467200f,
                    49.997400f,-116.429900f, 50.053000f,-116.497600f, 50.133800f,-116.442100f, 50.248400f,-116.551600f, 50.319700f,-116.541900f,
                    50.309100f,-116.600000f, 50.331000f,-116.620700f, 50.513100f,-116.692400f, 50.582300f,-116.674000f, 50.622278f,-116.612903f,
                    50.622278f,-115.799138f, 49.858267f,-115.799138f);
            poly[648] = new TzPolygon(50.692730f,-116.758825f, 50.667000f,-116.709600f, 50.679000f,-116.662800f, 50.649500f,-116.571300f, 50.622278f,-116.612903f,
                    50.622278f,-116.758825f);
            poly[649] = new TzPolygon(46.797736f,-114.839451f, 46.763691f,-114.771240f, 46.712776f,-114.786751f, 46.697716f,-114.763947f, 46.739887f,-114.670250f,
                    46.709930f,-114.626602f, 46.667274f,-114.641838f, 46.637863f,-114.612823f, 46.652054f,-114.541946f, 46.633053f,-114.467941f,
                    46.669704f,-114.370506f, 46.652645f,-114.325294f, 46.517334f,-114.344582f, 46.498905f,-114.403290f, 46.439301f,-114.373711f,
                    46.391403f,-114.420288f, 46.287746f,-114.429062f, 46.259289f,-114.470863f, 46.173927f,-114.446884f, 46.168835f,-114.507309f,
                    46.147076f,-114.524361f, 46.094448f,-114.460274f, 46.038212f,-114.501509f, 46.038212f,-114.839451f);
            poly[650] = new TzPolygon(48.999027f,-114.839451f, 52.150300f,-114.839451f, 52.150300f,-111.000702f, 48.996147f,-111.000702f, 48.995358f,-112.863899f);
            poly[651] = new TzPolygon(52.898487f,-118.607060f, 52.881523f,-118.604721f, 52.898487f,-118.566051f, 52.898487f,-118.465407f, 52.852257f,-118.447075f,
                    52.851582f,-118.396927f, 52.771992f,-118.413116f, 52.736885f,-118.335716f, 52.676807f,-118.286392f, 52.612160f,-118.351715f,
                    52.561253f,-118.265266f, 52.502571f,-118.259026f, 52.479126f,-118.192284f, 52.447765f,-118.246094f, 52.388013f,-118.217863f,
                    52.348800f,-118.258700f, 52.364300f,-118.359900f, 52.285500f,-118.548400f, 52.190500f,-118.578200f, 52.150300f,-118.678200f,
                    52.898487f,-118.678200f);
            poly[652] = new TzPolygon(24.357631f,-106.203979f, 24.390274f,-106.249184f, 24.362221f,-106.321404f, 24.283054f,-106.401398f, 24.311108f,-106.531952f,
                    24.588608f,-106.650848f, 24.702499f,-106.782791f, 24.752777f,-106.800003f, 24.773331f,-106.889183f, 24.790808f,-106.892400f,
                    24.790808f,-106.203979f);
            poly[653] = new TzPolygon(20.898510f,-105.428423f, 20.735115f,-105.239287f, 20.675657f,-105.278587f, 20.771147f,-105.347130f, 20.752174f,-105.413925f,
                    20.794825f,-105.546631f, 20.819918f,-105.521301f, 20.810736f,-105.497620f, 20.893438f,-105.451805f);
            poly[654] = new TzPolygon(20.373875f,-105.686029f, 20.406277f,-105.701302f, 20.485571f,-105.589760f, 20.491573f,-105.454025f, 20.568186f,-105.264587f,
                    20.639349f,-105.243637f, 20.675657f,-105.278587f, 20.886665f,-105.130280f, 20.937775f,-105.054169f, 20.916111f,-105.028061f,
                    20.934166f,-104.923073f, 21.020275f,-104.790009f, 21.012775f,-104.721947f, 20.923611f,-104.625000f, 20.916111f,-104.535004f,
                    20.829720f,-104.467216f, 20.709164f,-104.284729f, 20.860832f,-104.275009f, 20.978054f,-104.210007f, 21.177734f,-104.227661f,
                    21.181185f,-104.208678f, 20.373875f,-104.208678f);
            poly[655] = new TzPolygon(21.907063f,-104.208678f, 21.971386f,-104.269730f, 22.076385f,-104.402786f, 22.421944f,-104.258621f, 22.582341f,-104.244232f,
                    22.582341f,-104.208678f);
            poly[656] = new TzPolygon(22.582341f,-104.647250f, 22.582341f,-104.244232f, 22.421944f,-104.258621f, 22.319212f,-104.311432f, 22.451385f,-104.345001f,
                    22.411110f,-104.491386f, 22.472500f,-104.612503f);
            poly[657] = new TzPolygon(22.582341f,-104.931266f, 22.541943f,-104.985291f, 22.582341f,-104.989630f);
            poly[658] = new TzPolygon(21.907063f,-104.208678f, 21.785831f,-104.093613f, 21.598053f,-104.152786f, 21.547222f,-104.207230f, 21.429996f,-104.056122f,
                    21.374973f,-103.944931f, 21.287777f,-103.961403f, 21.211388f,-104.042511f, 21.181185f,-104.208678f);
            poly[659] = new TzPolygon(22.582341f,-104.244232f, 23.062775f,-104.201134f, 23.142776f,-104.169724f, 23.195831f,-104.096123f, 23.447498f,-104.078056f,
                    23.523052f,-104.022232f, 23.573055f,-103.936684f, 23.623333f,-103.919724f, 23.674721f,-103.808327f, 23.736942f,-103.858612f,
                    23.861385f,-103.875557f, 24.073055f,-103.850853f, 24.182499f,-103.600571f, 24.275555f,-103.612503f, 24.476109f,-103.267502f,
                    24.433887f,-102.767227f, 24.458885f,-102.735291f, 24.452221f,-102.513634f, 24.790808f,-102.505865f, 22.582341f,-102.505865f);
            poly[660] = new TzPolygon(22.582341f,-105.774583f, 22.589357f,-105.775574f, 22.677776f,-105.837654f, 22.837488f,-106.036873f, 22.823179f,-106.040459f,
                    23.010937f,-106.203979f, 24.357631f,-106.203979f, 24.211941f,-106.002228f, 24.098888f,-105.959732f, 24.055275f,-105.908073f,
                    23.789444f,-105.896393f, 23.474720f,-105.718063f, 23.287220f,-105.684174f, 23.144444f,-105.528900f, 23.147221f,-105.416672f,
                    23.067455f,-105.402077f, 23.034721f,-105.312500f, 23.039719f,-105.171951f, 22.927776f,-104.917511f, 22.783054f,-104.879997f,
                    22.678886f,-105.000000f, 22.582341f,-105.000000f);
            poly[661] = new TzPolygon(22.582341f,-104.947367f, 22.658886f,-104.828903f, 22.676666f,-104.757507f, 22.624443f,-104.660568f, 22.582341f,-104.647250f);
            poly[662] = new TzPolygon(24.790808f,-101.403413f, 24.761387f,-101.445282f, 24.754444f,-101.579727f, 24.788330f,-101.610001f, 24.790808f,-101.609132f);
            poly[663] = new TzPolygon(24.790808f,-101.290734f, 24.778610f,-101.321121f, 24.790808f,-101.332363f);
            poly[664] = new TzPolygon(22.513844f,-99.275911f, 22.513844f,-97.848787f, 22.338694f,-97.823227f, 22.267559f,-97.785362f, 22.213886f,-97.855835f,
                    22.271942f,-97.925568f, 22.297775f,-97.901947f, 22.326385f,-97.913345f, 22.382774f,-98.101959f, 22.471386f,-98.193069f,
                    22.468609f,-98.293335f, 22.398331f,-98.313904f, 22.401386f,-98.369171f, 22.428738f,-98.381073f, 22.406666f,-98.403625f,
                    22.432220f,-98.428345f, 22.440277f,-98.490005f, 22.423332f,-98.669724f, 22.339165f,-98.872787f, 22.414165f,-99.070007f,
                    22.448887f,-99.235840f);
            poly[665] = new TzPolygon(24.653814f,-101.085294f, 24.630276f,-101.061684f, 24.575275f,-100.946671f, 24.597221f,-100.860573f, 24.486111f,-100.740570f,
                    24.304165f,-100.596947f, 24.220554f,-100.566681f, 23.940552f,-100.594177f, 23.797497f,-100.483612f, 23.785831f,-100.441391f,
                    23.747498f,-100.417236f, 23.695000f,-100.418327f, 23.610832f,-100.468063f, 23.412220f,-100.427780f, 23.278332f,-100.455292f,
                    23.234165f,-100.444168f, 23.206108f,-100.423073f, 23.194443f,-100.371948f, 23.203888f,-100.333069f, 23.248055f,-100.303337f,
                    23.241108f,-100.057243f, 23.120831f,-100.089172f, 23.127220f,-100.025848f, 23.002220f,-99.908066f, 22.930553f,-99.936401f,
                    22.838886f,-100.048607f, 22.776943f,-99.976959f, 22.669720f,-99.721680f, 22.614998f,-99.530563f, 22.729721f,-99.549454f,
                    22.633610f,-99.427231f, 22.679443f,-99.378067f, 22.513844f,-99.275911f, 22.513844f,-101.290734f, 24.653814f,-101.290734f);
            poly[666] = new TzPolygon(24.653814f,-101.085294f, 24.790808f,-101.222706f, 24.790808f,-101.085294f);
            poly[667] = new TzPolygon(24.790808f,-106.892400f, 24.812496f,-106.896393f, 24.841942f,-106.948898f, 24.952774f,-107.021118f, 25.148609f,-107.107513f,
                    25.294441f,-107.124733f, 25.453518f,-107.087220f, 25.453518f,-106.892400f);
            poly[668] = new TzPolygon(24.790808f,-102.505865f, 24.828609f,-102.504997f, 25.075832f,-102.666946f, 25.118053f,-102.665848f, 25.155552f,-102.257233f,
                    25.026943f,-101.837509f, 25.001110f,-101.797234f, 24.905830f,-101.746399f, 24.858055f,-101.585564f, 24.790808f,-101.609132f);
            poly[669] = new TzPolygon(24.790808f,-101.403413f, 24.821110f,-101.360291f, 24.790808f,-101.332363f);
            poly[670] = new TzPolygon(24.790808f,-101.290734f, 24.810276f,-101.242233f, 24.790808f,-101.222706f);
            poly[671] = new TzPolygon(35.600028f,-110.471276f, 35.584663f,-110.471276f, 35.500008f,-110.751083f);
            poly[672] = new TzPolygon(36.281406f,-111.000702f, 36.299260f,-110.936792f, 36.299260f,-110.922683f, 36.279804f,-110.917671f, 36.277718f,-110.875702f,
                    36.299260f,-110.864103f, 36.299260f,-110.471276f, 36.135296f,-110.471276f, 36.157150f,-110.500694f, 36.142590f,-110.569252f,
                    36.099583f,-110.616623f, 36.041477f,-110.616737f, 36.041477f,-110.545357f, 36.015083f,-110.545410f, 36.015751f,-110.500687f,
                    36.070511f,-110.500694f, 36.070093f,-110.471276f, 35.519221f,-110.471276f, 35.519882f,-110.723068f, 35.500008f,-110.723061f,
                    35.500008f,-110.886330f, 35.548412f,-110.838760f, 35.548492f,-110.803413f, 35.578400f,-110.803482f, 35.578178f,-110.839142f,
                    35.548588f,-110.856247f, 35.548992f,-111.000694f);
            poly[673] = new TzPolygon(35.600028f,-110.471276f, 35.692028f,-110.213905f, 35.719730f,-110.236206f, 35.809635f,-110.146202f, 35.809341f,-110.100975f,
                    35.782558f,-110.102875f, 35.792759f,-110.083420f, 35.702568f,-110.081573f, 35.584663f,-110.471276f);
            poly[674] = new TzPolygon(36.299260f,-110.400850f, 36.281597f,-110.417122f, 36.163868f,-110.444336f, 36.134201f,-110.469803f, 36.135296f,-110.471276f,
                    36.299260f,-110.471276f);
            poly[675] = new TzPolygon(36.070093f,-110.471276f, 36.070076f,-110.470100f, 36.099369f,-110.464981f, 36.099152f,-110.425018f, 36.043076f,-110.402847f,
                    36.043129f,-110.291725f, 36.000004f,-110.321472f, 36.000004f,-110.252213f, 35.965248f,-110.160629f, 35.993855f,-110.124161f,
                    35.911896f,-110.119186f, 35.925056f,-110.019737f, 35.845169f,-110.054718f, 35.844269f,-110.000671f, 35.648975f,-110.000671f,
                    35.649029f,-110.146416f, 35.579281f,-110.125679f, 35.590851f,-110.277817f, 35.539539f,-110.277725f, 35.518642f,-110.250687f,
                    35.519221f,-110.471276f);
            poly[676] = new TzPolygon(36.299260f,-110.936792f, 36.302937f,-110.923630f, 36.299260f,-110.922683f);
            poly[677] = new TzPolygon(36.299260f,-110.864103f, 36.357929f,-110.832512f, 36.374046f,-110.845032f, 36.410198f,-110.753426f, 36.374996f,-110.721786f,
                    36.374996f,-110.577293f, 36.396507f,-110.552933f, 36.388065f,-110.502930f, 36.414101f,-110.456360f, 36.399059f,-110.423195f,
                    36.430649f,-110.321274f, 36.383873f,-110.322899f, 36.299260f,-110.400850f);
            poly[678] = new TzPolygon(52.898487f,-109.246415f, 52.820200f,-109.245700f, 52.820300f,-109.318300f, 52.739900f,-109.306800f, 52.740000f,-109.390800f,
                    52.696700f,-109.390700f, 52.696500f,-109.435000f, 52.675400f,-109.435200f, 52.667308f,-110.000000f, 48.996571f,-110.000000f,
                    48.996147f,-111.000702f, 52.898487f,-111.000702f);
            poly[679] = new TzPolygon(52.898487f,-108.901310f, 52.804300f,-108.883000f, 52.804700f,-109.003800f, 52.885400f,-109.004100f, 52.885500f,-109.125200f,
                    52.898487f,-109.125123f);
            poly[680] = new TzPolygon(49.000768f,-111.000702f, 48.997666f,-108.883000f, 37.340875f,-108.883000f, 37.340875f,-111.000702f);
            poly[681] = new TzPolygon(47.575298f,-103.437449f, 47.527050f,-103.434273f, 47.515476f,-103.609627f, 47.575298f,-103.610133f);
            poly[682] = new TzPolygon(47.575298f,-103.093439f, 47.570328f,-103.183258f, 47.575298f,-103.219300f);
            poly[683] = new TzPolygon(35.257645f,-103.047236f, 36.500473f,-103.040779f, 36.501289f,-103.000656f, 36.998989f,-103.000870f, 36.994980f,-102.432684f,
                    35.257645f,-102.432684f);
            poly[684] = new TzPolygon(47.575298f,-102.432684f, 47.565319f,-102.444199f, 47.515064f,-102.438293f, 47.511234f,-102.505493f, 47.544117f,-102.599648f,
                    47.529018f,-102.678001f, 47.574188f,-102.693779f, 47.575298f,-102.700876f);
            poly[685] = new TzPolygon(41.416471f,-102.432684f, 41.416471f,-101.405425f, 41.395439f,-101.405487f, 41.395943f,-101.270180f, 41.048794f,-101.268829f,
                    41.047630f,-101.248695f, 40.697426f,-101.245575f, 40.697338f,-101.343185f, 40.004246f,-101.322418f, 40.003910f,-102.048553f,
                    39.568859f,-102.047546f, 39.568550f,-101.390160f, 39.134537f,-101.391281f, 39.133850f,-101.477890f, 38.700176f,-101.484985f,
                    38.700375f,-101.569351f, 37.736435f,-101.527054f, 37.738407f,-102.043236f, 36.992226f,-102.042274f, 36.994980f,-102.432684f);
            poly[686] = new TzPolygon(44.495885f,-102.432684f, 44.495885f,-100.575531f, 44.460754f,-100.578499f, 44.444809f,-100.548409f, 44.452080f,-100.402504f,
                    44.371542f,-100.371283f, 44.167671f,-100.554504f, 44.169754f,-101.045906f, 43.844398f,-101.068039f, 43.838615f,-101.138382f,
                    43.783474f,-101.233551f, 42.995293f,-101.227699f, 42.995083f,-100.904144f, 42.812885f,-100.902817f, 42.812523f,-100.864647f,
                    42.783344f,-100.845474f, 42.755058f,-100.845665f, 42.755310f,-100.890800f, 42.611336f,-100.891045f, 42.610268f,-100.773277f,
                    42.438473f,-100.775101f, 42.438934f,-100.829506f, 42.351803f,-100.829094f, 42.351925f,-100.809998f, 42.205063f,-100.808517f,
                    42.205807f,-100.750061f, 42.088654f,-100.748962f, 42.089584f,-100.844398f, 41.740372f,-100.843887f, 41.743195f,-101.404457f,
                    41.416471f,-101.405425f, 41.416471f,-102.432684f);
            poly[687] = new TzPolygon(44.495885f,-100.575531f, 44.498146f,-100.575340f, 44.541946f,-100.515800f, 44.577450f,-100.637611f, 44.722065f,-100.623131f,
                    44.767117f,-100.716438f, 44.798576f,-100.730042f, 44.831036f,-100.691536f, 44.767258f,-100.602638f, 44.764553f,-100.533203f,
                    44.868099f,-100.394173f, 45.001858f,-100.418480f, 45.025558f,-100.371338f, 45.023617f,-100.280991f, 45.095367f,-100.328568f,
                    45.233192f,-100.260887f, 45.312309f,-100.316345f, 45.383984f,-100.277863f, 45.499245f,-100.363174f, 45.536617f,-100.486488f,
                    45.594879f,-100.430214f, 45.653843f,-100.420937f, 45.654686f,-100.339493f, 45.702648f,-100.298958f, 45.816643f,-100.387428f,
                    45.861507f,-100.357803f, 45.878887f,-100.426544f, 45.914410f,-100.423439f, 45.909294f,-100.473274f, 45.943882f,-100.512184f,
                    45.943693f,-101.349696f, 46.035592f,-101.353996f, 46.035592f,-99.919829f, 44.495885f,-99.919829f);
            poly[688] = new TzPolygon(46.370464f,-101.176257f, 46.370533f,-101.299210f, 46.629963f,-101.299706f, 46.631027f,-101.716919f, 46.717266f,-101.715202f,
                    46.717060f,-102.093910f, 46.805445f,-102.094943f, 46.805445f,-101.176257f);
            poly[689] = new TzPolygon(46.035592f,-101.353996f, 46.077507f,-101.355957f, 46.092907f,-101.311600f, 46.127716f,-101.310051f, 46.149441f,-101.189552f,
                    46.186039f,-101.196503f, 46.193451f,-101.176257f, 46.035592f,-101.176257f);
            poly[690] = new TzPolygon(46.805445f,-101.176257f, 46.805445f,-102.094943f, 46.980900f,-102.096992f, 46.982227f,-101.176257f);
            poly[691] = new TzPolygon(47.279618f,-101.176257f, 46.982165f,-101.176257f, 46.982071f,-101.763321f, 47.242020f,-101.763672f, 47.242039f,-101.257156f,
                    47.268230f,-101.256798f, 47.246471f,-101.201141f, 47.278255f,-101.184792f);
            poly[692] = new TzPolygon(47.280041f,-101.176257f, 47.278255f,-101.184792f, 47.246414f,-101.211823f, 47.291618f,-101.344551f, 47.366879f,-101.362907f,
                    47.462914f,-101.441185f, 47.519905f,-101.374985f, 47.563206f,-101.435257f, 47.527866f,-101.611702f, 47.530487f,-101.737099f,
                    47.495255f,-101.817497f, 47.534542f,-102.022751f, 47.572887f,-102.029465f, 47.566730f,-102.183136f, 47.575298f,-102.194947f,
                    47.575298f,-101.176257f);
            poly[693] = new TzPolygon(47.560222f,-102.432684f, 47.575298f,-102.423863f, 47.575298f,-102.205561f, 47.573383f,-102.203430f, 47.329155f,-102.207764f,
                    47.327629f,-102.144234f, 46.982182f,-102.144226f, 46.980900f,-102.096992f, 46.805445f,-102.094943f, 46.805445f,-102.432684f);
            poly[694] = new TzPolygon(46.370464f,-101.176257f, 46.982227f,-101.176257f, 46.982574f,-100.935104f, 46.904800f,-100.908463f, 46.806805f,-100.817108f,
                    46.749069f,-100.834251f, 46.731529f,-100.774475f, 46.691620f,-100.788506f, 46.689583f,-100.742447f, 46.656368f,-100.734642f,
                    46.677670f,-100.639626f, 46.634357f,-100.661606f, 46.593048f,-100.565109f, 46.574833f,-100.586197f, 46.531155f,-100.543213f,
                    46.493355f,-100.585503f, 46.427361f,-100.592010f, 46.413525f,-100.680298f, 46.379101f,-100.718399f, 46.400154f,-100.734940f,
                    46.385326f,-100.815903f, 46.407135f,-100.889153f, 46.325314f,-100.974876f, 46.320118f,-101.017609f, 46.303230f,-100.999718f,
                    46.275612f,-101.036331f, 46.370392f,-101.048958f);
            poly[695] = new TzPolygon(47.279618f,-101.176257f, 47.295284f,-101.078110f, 47.257961f,-100.985664f, 47.185822f,-100.988464f, 47.025436f,-100.879517f,
                    46.982574f,-100.935104f, 46.982165f,-101.176257f);
            poly[696] = new TzPolygon(46.370464f,-101.176257f, 46.370392f,-101.048958f, 46.280594f,-101.050186f, 46.271698f,-101.096138f, 46.215271f,-101.116653f,
                    46.193451f,-101.176257f);
            poly[697] = new TzPolygon(47.575298f,-103.610133f, 47.589474f,-103.610252f, 47.588871f,-103.737091f, 47.675842f,-103.738724f, 47.675797f,-103.799232f,
                    47.848930f,-103.800613f, 47.848114f,-103.965576f, 47.959892f,-103.965942f, 47.997276f,-104.044670f, 48.990587f,-104.049544f,
                    48.990840f,-103.610133f);
            poly[698] = new TzPolygon(48.997666f,-108.883000f, 48.997666f,-103.610133f, 48.991120f,-103.610133f, 48.990303f,-104.023682f, 48.996967f,-105.000000f,
                    48.996659f,-108.883000f);
            poly[699] = new TzPolygon(50.310156f,-107.769619f, 50.273790f,-107.758044f, 50.259220f,-107.791933f, 50.283603f,-107.829110f, 50.310045f,-107.827148f);
        }
    }

    private static class Initializer8 {
        private static void init() {
            poly[700] = new TzPolygon(47.575298f,-103.436537f, 47.591843f,-103.438538f, 47.576626f,-103.069450f, 47.633202f,-103.020645f, 47.669712f,-103.038185f,
                    47.674011f,-103.004082f, 47.600971f,-102.865021f, 47.575298f,-102.711964f);
            poly[701] = new TzPolygon(47.575298f,-102.423863f, 47.590809f,-102.414787f, 47.615253f,-102.250024