(ns works-hub.pachyderm.client
  (:import com.stripe.Stripe))

(defn set-api-key!
  "Configures default Stripe API key to be used."
  [^String key]
  (set! (. Stripe apiKey) key) nil)

(defn set-global-connection-timeout!
  "Configures global connection timeout"
  [^Integer ms]
  (Stripe/setConnectTimeout ms))

(defn set-global-read-timeout!
  "Configures global read timeout"
  [^Integer ms]
  (Stripe/setReadTimeout ms))
