(ns works-hub.pachyderm.cards
  (:refer-clojure :exclude [list update])
  (:require [clojure.string :as str]
            [works-hub.pachyderm.transforms :as trs]
            [works-hub.pachyderm.util :refer (map->request-options map->str-ks)])
  (:import [clojure.lang IPersistentMap]
           [com.stripe.exception InvalidRequestException]))

(defn create
  ([^IPersistentMap customer ^String token]
   (create customer token nil))
  ([^IPersistentMap customer ^String token ^IPersistentMap ro-opts]
   (if-let [o (:__origin__ customer)]
     (trs/card->map (.create (.getSources o)
                             (map->str-ks {:source token})
                             (map->request-options ro-opts)))
     (throw (IllegalArgumentException.
             "cards/create-from-token only accepts maps returned by customer/create and other library functions that return customer maps")))))

(defn retrieve
  ([^IPersistentMap customer ^String card-id]
   (if-let [o (:__origin__ customer)]
     (try
       (trs/card->map (let [cs (.getSources o)]
                        (.retrieve cs card-id)))
       (catch InvalidRequestException e
         (when-not (str/starts-with? (.getMessage e) "No such source")
           (throw e))))
     (throw (IllegalArgumentException.
             "cards/retrieve only accepts maps returned by customer/create and other library functions that return customer maps")))))

(defn list
  ([^IPersistentMap customer]
   (if-let [o (:__origin__ customer)]
     ;; TODO: pagination
     (map trs/card->map (into [] (.getData (.getSources o))))
     (throw (IllegalArgumentException.
             "cards/list only accepts maps returned by customer/create and other library functions that return customer maps")))))

(defn update
  ([^IPersistentMap card ^IPersistentMap attrs]
   (update card attrs nil))
  ([^IPersistentMap card ^IPersistentMap attrs ^IPersistentMap ro-opts]
   (if-let [o (:__origin__ card)]
     (trs/card->map (.update o
                             (map->str-ks attrs)
                             (map->request-options ro-opts)))
     (throw (IllegalArgumentException.
             "cards/update only accepts maps returned by cards/create and other library functions that return card information")))))

(defn delete
  ([^IPersistentMap card]
   (delete card nil))
  ([^IPersistentMap card ^IPersistentMap ro-opts]
   (if-let [o (:__origin__ card)]
     (.delete o (map->request-options ro-opts))
     (throw (IllegalArgumentException.
             "cards/dete only accepts maps returned by cards/create and other library functions that return card information")))))
