# pachyderm

A modern (no, really!) Clojure client for the [Stripe API](https://stripe.com/docs/api).
This is strongly inspired and influenced by [Elephant from ClojureWerkz](https://github.com/clojurewerkz/elephant).

pachyderm wraps the [stripe-java bindings](https://github.com/stripe/stripe-java)

## Examples

### Getting Started

``` clojure
;; set global api key
(require '[works-hub.pachyderm.client :as client])

(client/set-api-key! "xxxxxxx")
```

### Customers

``` clojure
(require '[works-hub.pachyderm.customers :as customers])

;; create a new customer
;; https://stripe.com/docs/api?lang=java#create_customer
(def a (customers/create {:source "tok_mastercard"})

;; update a customer
;; https://stripe.com/docs/api?lang=java#update_customer
(def b (customers/update c {:description "Foo bar baz"}

;; delete a customer
;; https://stripe.com/docs/api?lang=java#delete_customer
(def c (customers/delete b)
```

### TODO add more examples

## Testing

There is a suite of integration tests that can be run with the following command:

``` bash
STRIPE_API_KEY=xxxxx lein test
```

## License

Copyright © 2018 WorksHub

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
