(ns workflo.macros.specs.types
  (:refer-clojure :exclude [bigdec? bytes? double? float? uri?])
  (:require [clojure.spec :as s]))

;;;; Helpers

(defn long? [x]
  #?(:cljs (and (number? x)
                (not (js/isNaN x))
                (not (identical? x js/Infinity))
                (= 0 (rem x 1)))
     :clj  (instance? java.lang.Long x)))

(defn bigint? [x]
  #?(:cljs (long? x)
     :clj  (instance? clojure.lang.BigInt x)))

(defn float? [x]
  #?(:cljs (and (number? x)
                (not (js/isNaN x))
                (not (identical? x js/Infinity))
                (not= (js/parseFloat x) (js/parseInt x 10)))
     :clj  (clojure.core/float? x)))

(defn double? [x]
  #?(:cljs (float? x)
     :clj  (clojure.core/double? x)))

(defn bigdec? [x]
  #?(:cljs (float? x)
     :clj  (clojure.core/bigdec? x)))

(defn bytes? [x]
  #?(:cljs (array? x)
     :clj  (clojure.core/bytes? x)))

;;;; Fundamental types

(s/def ::keyword keyword?)
(s/def ::string string?)
(s/def ::boolean boolean?)
(s/def ::long long?)
(s/def ::bigint bigint?)
(s/def ::float float?)
(s/def ::double double?)
(s/def ::bigdec bigdec?)
(s/def ::instant inst?)
(s/def ::uuid uuid?)
(s/def ::bytes bytes?)
(s/def ::enum keyword?)

;;;; Entity IDs

(s/def ::id any?)

;;;; Reference types

(s/def ::ref ::id)
(s/def ::ref-many (s/coll-of ::id :kind vector?))

;;;; Type options

(s/def ::unique-value any?)
(s/def ::unique-identity any?)
(s/def ::indexed any?)
(s/def ::fulltext any?)
(s/def ::component any?)
(s/def ::no-history any?)
