(ns toolbox.boot.utils
  (:require
   [boot.core :as boot]
   [clojure.edn :as edn]))

(defn load-deps []
  (let [deps (:deps (edn/read-string (slurp "deps.edn")))
        dependencies (map (fn [[lib source]]
                            [lib (:mvn/version source)])
                          deps)]
    (println "Additional dependencies from deps.edn:" dependencies)
    (boot/set-env! :dependencies (into (boot/get-env :dependencies) dependencies))))

(load-deps)
