(ns witan.workspace-executor.demo
  (:require [schema.core :as s]
            [witan.workspace-executor.core :as wex]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def workflow [:a :c
               :b :c
               :c :d
               :d :e
               :f :e])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn inc*
  [{:keys [number]} _]
  {:number (inc number)})

(defn mul2
  [{:keys [number]} _]
  {:number (* number 2)})

(defn add
  [{:keys [number to-add]} _]
  {:number (+ number to-add)})

(defn ->str
  [{:keys [one two]} params]
  {:str (format (:format params) one two)})

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def contracts
  [{:witan/fn      :foo/inc
    :witan/impl    'witan.workspace-executor.demo/inc*
    :witan/version "1.0"
    :witan/params-schema nil
    :witan/inputs  [{:witan/schema       s/Num
                     :witan/key          :number
                     :witan/display-name "Number"}]
    :witan/outputs [{:witan/schema       s/Num
                     :witan/key          :number
                     :witan/display-name "Number"}]}

   {:witan/fn      :foo/mul2
    :witan/impl    'witan.workspace-executor.demo/mul2
    :witan/version "1.0"
    :witan/params-schema nil
    :witan/inputs  [{:witan/schema       s/Num
                     :witan/key          :number
                     :witan/display-name "Number"}]
    :witan/outputs [{:witan/schema       s/Num
                     :witan/key          :number
                     :witan/display-name "Number"}]}

   {:witan/fn      :foo/add
    :witan/impl    'witan.workspace-executor.demo/add
    :witan/version "1.0"
    :witan/params-schema nil
    :witan/inputs  [{:witan/schema       s/Num
                     :witan/key          :number
                     :witan/display-name "Number"}
                    {:witan/schema       s/Num
                     :witan/key          :to-add
                     :witan/display-name "To add"}]
    :witan/outputs [{:witan/schema       s/Num
                     :witan/key          :number
                     :witan/display-name "Number"}]}

   {:witan/fn      :foo/str-format
    :witan/impl    'witan.workspace-executor.demo/->str
    :witan/version "1.0"
    :witan/params-schema {:format s/Str}
    :witan/inputs  [{:witan/schema       s/Any
                     :witan/key          :one
                     :witan/display-name "First item in format"}
                    {:witan/schema       s/Any
                     :witan/key          :two
                     :witan/display-name "Second item in format"}]
    :witan/outputs [{:witan/schema       s/Str
                     :witan/key          :str
                     :witan/display-name "String representation"}]}])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def catalog [{:witan/name :a
               :witan/fn :foo/inc
               :witan/version "1.0"
               :witan/inputs [{:witan/input-src-fn   'clojure.core/identity
                               :witan/input-src-key  1
                               :witan/input-dest-key :number}]}

              {:witan/name :b
               :witan/fn :foo/inc
               :witan/version "1.0"
               :witan/inputs [{:witan/input-src-fn   'clojure.core/identity
                               :witan/input-src-key  3
                               :witan/input-dest-key :number}]
               :witan/outputs [{:witan/output-src-key :number
                                :witan/output-dest-key :to-add}]}

              {:witan/name :c
               :witan/fn :foo/add
               :witan/version "1.0"
               :witan/inputs [{:witan/input-src-key :number}
                              {:witan/input-src-key :to-add}]}

              {:witan/name :d
               :witan/fn :foo/mul2
               :witan/version "1.0"
               :witan/inputs [{:witan/input-src-key :number}]
               :witan/outputs [{:witan/output-src-key :number
                                :witan/output-dest-key :one}]}

              {:witan/name :f
               :witan/fn :foo/inc
               :witan/version "1.0"
               :witan/inputs [{:witan/input-src-fn   'clojure.core/identity
                               :witan/input-src-key  99
                               :witan/input-dest-key :number}]
               :witan/outputs [{:witan/output-src-key :number
                                :witan/output-dest-key :two}]}

              {:witan/name :e
               :witan/fn :foo/str-format
               :witan/version "1.0"
               :witan/params {:format "First number: %s. Second number: %s."}
               :witan/inputs [{:witan/input-src-key :one}
                              {:witan/input-src-key :two}]}])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn run
  []
  (wex/execute {:workflow  workflow
                :catalog   catalog
                :contracts contracts}))
