(ns witan.phyrexian.lfb-ingester
  (:require [clojure.java.io :as io]
            [clojure.string :as str]
            [witan.phyrexian.utils :as u]
            [schema.core :as s]
            [schema.utils :as su]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LFB Incident data                   ;;
;;                                     ;;
;; Manual step before processing data: ;;
;;   - Save as .csv                    ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def input-fire-risk-keys [:NumPumpsAttending :PropertyType
                           :PropertyCategory :IncidentGroup])

(def ouput-fire-risk-keys [:NumPumpsAttending :PropertyType])

(def HistoricalFireSchema
  {:NumPumpsAttending s/Int
   :PropertyType s/Str})

(defn scrub-data [k data]
  (map #(select-keys % k) data))

(defn incident-is-fire? [m]
  (= "Fire" (:IncidentGroup m)))

(defn property-is-non-residential? [m]
  (= "Non Residential" (:PropertyCategory m)))

(defn format-data [schema data]
  (->> data
       (map #(u/schema-coercion schema %))
       (remove su/error?)))

(defn process-lfb-data [data]
  (->> data
       (scrub-data input-fire-risk-keys)
       (filter incident-is-fire?)
       (filter property-is-non-residential?)
       (scrub-data ouput-fire-risk-keys)
       (format-data HistoricalFireSchema)))


(defn -main [input output]
  (->> input
       u/load-csv
       (process-lfb-data)
       (u/write-csv output)))
