(ns {{project-ns}}.routes.route
    (:require [{{project-ns}}.model.state :refer [app-state]]
              [bidi.bidi :as bidi]
              [{{project-ns}}.view.example :refer
               [example-page1 example-page2 example-page3]]))

;;定义路由模型，由嵌套向量表示
(def routes
  ["/"
   [["example1" example-page1]
    ["example2" example-page2]
    ["example3" example-page3]]])

;;匹配对应的路由，并渲染路由对应的组件
(defn dispatch-view []
  (let [route (:route @app-state)
        {:keys [handler]} (bidi/match-route routes route)]
    [(or handler example-page1)]))
