(ns {{project-ns}}.core
    (:require
     [reagent.core :as r]
     [{{project-ns}}.model.state :refer [navigation]]
     [{{project-ns}}.view.home :refer [home-page]]
     [goog.events :as events]
     [goog.history.EventType :as EventType])
    (:import [goog History]))

;; -------------------------
;; Initialize app

(defn mount-root []
  (doto (History.)
    (events/listen EventType/NAVIGATE navigation)
    (.setEnabled true))
  (r/render [home-page] (.getElementById js/document "app")))

(defn init! []
  (mount-root))
