(ns wiseloong.utils
  (:require [goog.string :as gstring]
            [goog.uri.utils :as guu]))

(defn href "跳转url，同时可用于按钮下载"
  [url] (set! (.-href js/location) url))

(defn differ-minute [date]
  (let [now (js/Date.now)
        differ (- now date)]
    (/ differ 60000)))

(defn select-data [ms]
  (letfn [(f [{:keys [id name]}] [id name])]
    (->> ms
         (map f)
         (reduce into))))

(defn get-date-string []
  (let [date (js/Date.)
        year (.getFullYear date)
        month (inc (.getMonth date))
        day (.getDate date)
        hours (.getHours date)
        minutes (.getMinutes date)
        seconds (.getSeconds date)]
    (str year month day hours minutes seconds)))

(defn url-decode [s]
  (gstring/urlDecode s))

(defn url-encode [s]
  (gstring/urlEncode s))

(defn url-param-value
  ([k] (url-param-value (.-href (.-location js/window)) k))
  ([url k] (guu/getParamValue url k)))
