(ns leiningen.kibit_xml
  (:require [clojure.tools.namespace :as clj-ns]
            [clojure.java.io :as io]
            [jonase.kibit.core :as kibit]
            [jonase.kibit.reporters :as reporters]))

(defn kibit_xml
  "foo"
  [project]
  (let [paths (or (:source-paths project) [(:source-path project)])
        source-files (mapcat #(-> % io/file clj-ns/find-clojure-sources-in-dir)
                             paths)]
    (doseq [source-file source-files]
      (printf "<file name=\"%s\">\n"
              (find-path
                (or (second (clj-ns/read-file-ns-decl source-file)) source-file)))
      (kibit/check-file source-file :reporter reporters/xml-reporter)
      (printf "</file>")
      (flush))))

(defn- find-path
  "Converts namespace representation to file name"
  [path]
  (let [parts (.split path "\\.")]
    (str "src/" (clojure.string/join "," (seq parts)) ".clj")))