(ns leiningen.kibit
  (:require [clojure.tools.namespace :as clj-ns]
            [clojure.java.io :as io]
            [jonase.kibit.core :as kibit]
            [jonase.kibit.reporters :as reporters]))

(defn kibit
  "Suggest idiomatic replacements for patterns of code."
  [project]
  (let [paths (or (:source-paths project) [(:source-path project)])
        source-files (mapcat #(-> % io/file clj-ns/find-clojure-sources-in-dir)
                             paths)]
    (doseq [source-file source-files]
      (printf "__ %s ==\n"
              (or (second (clj-ns/read-file-ns-decl source-file)) source-file))
      (kibit/check-file source-file)
      (flush))))

(defn kibit-xml2
  "foo"
  [project]
  (let [paths (or (:source-paths project) [(:source-path project)])
        source-files (mapcat #(-> % io/file clj-ns/find-clojure-sources-in-dir)
                             paths)]
    (doseq [source-file source-files]
      (printf "<file name=\"%s\">\n"
              (or (second (clj-ns/read-file-ns-decl source-file)) source-file))
      (kibit/check-file source-file {:reporter reporters/xml-reporter})
      (flush))))