# clj-interest-graph

A Clojure client library for the [Prismatic Interest Graph](https://github.com/Prismatic/interest-graph).

## Installation

[wildworld/clj-interest-graph "0.1.0"]


## Usage

Require it in your REPL:

```cl
(require '[wildworld/clj-interest-graph.core :as graph])
```

Or in your application:

```cl
(ns my-app.core
  (:require [wildworld/clj-interest-graph.core :as graph]))
```

Then you can use freely. All API endpoints are supported.

Here's an example:

```clj
;; Create a client. It's just configuration map.
(def client (graph/create-client {:token "<my-token>"}))

;; Make a call to the API. Client configuration is explicitly passed with all
;; API methods.
(graph/ping client)
```


## License

Copyright © 2015 WildWorld, Inc.

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
