(ns simplelog.core
  (:import 
    [java.util.Date]
    [java.text.DateFormat]))

(defn timestamp []
  (str "[" (.toGMTString (java.util.Date.)) "]"))

(defn thread-id []
  (.getId (Thread/currentThread)))

(defonce enabled-levels (atom #{}))

(defn define-level [level]
  `(defn ~level [& anything#]
     (when (@enabled-levels '~level)
       (apply println (simplelog.core/timestamp)
         (str "[thread=" (simplelog.core/timestamp) "]")
         (.toUpperCase (str "[" '~level "]"))
         anything#))))

(defmacro log-levels [& levels]
  `(do 
     (println "what the fuck")
     (reset! simplelog.core/enabled-levels (into #{} '~levels))
     ~@(map simplelog.core/define-level levels)))

(defn silence!
  [& levels]
  (doseq [level levels]
    (swap! enabled-levels disj (-> level name symbol))))

(defn enable!
  [& levels]
  (doseq [level levels]
    (swap! enabled-levels conj (-> level name symbol))))
